/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token.store.jwk;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.jwt.codec.Codecs;
import org.springframework.security.jwt.crypto.sign.EllipticCurveVerifier;
import org.springframework.security.jwt.crypto.sign.RsaVerifier;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.oauth2.provider.token.store.jwk.EllipticCurveJwkDefinition;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkDefinition;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkException;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkSetConverter;
import org.springframework.security.oauth2.provider.token.store.jwk.RsaJwkDefinition;

class JwkDefinitionSource {
    private final List<URL> jwkSetUrls;
    private final Map<String, JwkDefinitionHolder> jwkDefinitions = new ConcurrentHashMap<String, JwkDefinitionHolder>();
    private static final JwkSetConverter jwkSetConverter = new JwkSetConverter();

    JwkDefinitionSource(String jwkSetUrl) {
        this(Arrays.asList(jwkSetUrl));
    }

    JwkDefinitionSource(List<String> jwkSetUrls) {
        this.jwkSetUrls = new ArrayList<URL>();
        for (String jwkSetUrl : jwkSetUrls) {
            try {
                this.jwkSetUrls.add(new URL(jwkSetUrl));
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("Invalid JWK Set URL: " + ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JwkDefinitionHolder getDefinitionLoadIfNecessary(String keyId, String x5t) {
        JwkDefinitionHolder result = this.getDefinition(keyId, x5t);
        if (result != null) {
            return result;
        }
        Map<String, JwkDefinitionHolder> map = this.jwkDefinitions;
        synchronized (map) {
            result = this.getDefinition(keyId, x5t);
            if (result != null) {
                return result;
            }
            LinkedHashMap<String, JwkDefinitionHolder> newJwkDefinitions = new LinkedHashMap<String, JwkDefinitionHolder>();
            for (URL jwkSetUrl : this.jwkSetUrls) {
                newJwkDefinitions.putAll(JwkDefinitionSource.loadJwkDefinitions(jwkSetUrl));
            }
            this.jwkDefinitions.clear();
            this.jwkDefinitions.putAll(newJwkDefinitions);
            return this.getDefinition(keyId, x5t);
        }
    }

    private JwkDefinitionHolder getDefinition(String keyId, String x5t) {
        JwkDefinitionHolder result = null;
        if (keyId != null) {
            result = this.jwkDefinitions.get(keyId);
        } else if (x5t != null) {
            Iterator<JwkDefinitionHolder> iter = this.jwkDefinitions.values().iterator();
            while (result == null && iter.hasNext()) {
                JwkDefinitionHolder entry = iter.next();
                if (!x5t.equals(entry.getJwkDefinition().getX5t())) continue;
                result = entry;
            }
        }
        return result;
    }

    static Map<String, JwkDefinitionHolder> loadJwkDefinitions(URL jwkSetUrl) {
        InputStream jwkSetSource;
        try {
            jwkSetSource = jwkSetUrl.openStream();
        }
        catch (IOException ex) {
            throw new JwkException("An I/O error occurred while reading from the JWK Set source: " + ex.getMessage(), ex);
        }
        Set<JwkDefinition> jwkDefinitionSet = jwkSetConverter.convert(jwkSetSource);
        LinkedHashMap<String, JwkDefinitionHolder> jwkDefinitions = new LinkedHashMap<String, JwkDefinitionHolder>();
        for (JwkDefinition jwkDefinition : jwkDefinitionSet) {
            if (JwkDefinition.KeyType.RSA.equals((Object)jwkDefinition.getKeyType())) {
                jwkDefinitions.put(jwkDefinition.getKeyId(), new JwkDefinitionHolder(jwkDefinition, (SignatureVerifier)JwkDefinitionSource.createRsaVerifier((RsaJwkDefinition)jwkDefinition)));
                continue;
            }
            if (!JwkDefinition.KeyType.EC.equals((Object)jwkDefinition.getKeyType())) continue;
            jwkDefinitions.put(jwkDefinition.getKeyId(), new JwkDefinitionHolder(jwkDefinition, (SignatureVerifier)JwkDefinitionSource.createEcVerifier((EllipticCurveJwkDefinition)jwkDefinition)));
        }
        return jwkDefinitions;
    }

    private static RsaVerifier createRsaVerifier(RsaJwkDefinition rsaDefinition) {
        RsaVerifier result;
        try {
            BigInteger modulus = new BigInteger(1, Codecs.b64UrlDecode((CharSequence)rsaDefinition.getModulus()));
            BigInteger exponent = new BigInteger(1, Codecs.b64UrlDecode((CharSequence)rsaDefinition.getExponent()));
            RSAPublicKey rsaPublicKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(modulus, exponent));
            result = rsaDefinition.getAlgorithm() != null ? new RsaVerifier(rsaPublicKey, rsaDefinition.getAlgorithm().standardName()) : new RsaVerifier(rsaPublicKey);
        }
        catch (Exception ex) {
            throw new JwkException("An error occurred while creating a RSA Public Key Verifier for " + rsaDefinition.getKeyId() + " : " + ex.getMessage(), ex);
        }
        return result;
    }

    private static EllipticCurveVerifier createEcVerifier(EllipticCurveJwkDefinition ecDefinition) {
        EllipticCurveVerifier result;
        try {
            BigInteger x = new BigInteger(1, Codecs.b64UrlDecode((CharSequence)ecDefinition.getX()));
            BigInteger y = new BigInteger(1, Codecs.b64UrlDecode((CharSequence)ecDefinition.getY()));
            String algorithm = null;
            if (EllipticCurveJwkDefinition.NamedCurve.P256.value().equals(ecDefinition.getCurve())) {
                algorithm = JwkDefinition.CryptoAlgorithm.ES256.standardName();
            } else if (EllipticCurveJwkDefinition.NamedCurve.P384.value().equals(ecDefinition.getCurve())) {
                algorithm = JwkDefinition.CryptoAlgorithm.ES384.standardName();
            } else if (EllipticCurveJwkDefinition.NamedCurve.P521.value().equals(ecDefinition.getCurve())) {
                algorithm = JwkDefinition.CryptoAlgorithm.ES512.standardName();
            }
            result = new EllipticCurveVerifier(x, y, ecDefinition.getCurve(), algorithm);
        }
        catch (Exception ex) {
            throw new JwkException("An error occurred while creating an EC Public Key Verifier for " + ecDefinition.getKeyId() + " : " + ex.getMessage(), ex);
        }
        return result;
    }

    static class JwkDefinitionHolder {
        private final JwkDefinition jwkDefinition;
        private final SignatureVerifier signatureVerifier;

        private JwkDefinitionHolder(JwkDefinition jwkDefinition, SignatureVerifier signatureVerifier) {
            this.jwkDefinition = jwkDefinition;
            this.signatureVerifier = signatureVerifier;
        }

        JwkDefinition getJwkDefinition() {
            return this.jwkDefinition;
        }

        SignatureVerifier getSignatureVerifier() {
            return this.signatureVerifier;
        }
    }
}

