/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.export.TemplateImportContext;
import com.xebialabs.xlrelease.export.TemplateImporter;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.UploadService;
import com.xebialabs.xlrelease.views.AttachmentView;
import com.xebialabs.xlrelease.views.ImportResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/upload")
@Consumes(value={"multipart/form-data"})
@Produces(value={"text/html; charset=utf-8"})
@Controller
public class UploadResource {
    private static final String JSON_SUFFIX = ".json";
    private PermissionChecker permissionChecker;
    private TemplateImporter templateImporter;
    private UploadService uploadService;

    @Autowired
    public UploadResource(PermissionChecker permissionChecker, TemplateImporter templateImporter, UploadService uploadService) {
        this.permissionChecker = permissionChecker;
        this.templateImporter = templateImporter;
        this.uploadService = uploadService;
    }

    public UploadResource() {
    }

    @POST
    @Timed
    @Path(value="templates/zip")
    public List<ImportResult> importTemplates(@Context HttpServletRequest request, @QueryParam(value="folderId") String folderId) throws IOException, FileUploadException {
        if (Ids.isNullId((String)folderId)) {
            this.permissionChecker.check(XLReleasePermissions.CREATE_TEMPLATE);
        } else {
            this.permissionChecker.check(XLReleasePermissions.EDIT_TEMPLATE, folderId);
        }
        ServletFileUpload upload = new ServletFileUpload();
        FileItemIterator fileItems = upload.getItemIterator(request);
        while (fileItems.hasNext()) {
            FileItemStream item = fileItems.next();
            if (item.isFormField()) continue;
            try (InputStream stream = item.openStream();){
                boolean isJson = item.getName().toLowerCase().endsWith(JSON_SUFFIX);
                boolean isDsl = item.getName().toLowerCase().endsWith(".zip");
                List<ImportResult> list = this.templateImporter.importTemplate(stream, new TemplateImportContext(folderId, isJson, false, isDsl, null));
                return list;
            }
        }
        throw new IllegalArgumentException("Missing file");
    }

    @POST
    @Timed
    @Path(value="attachment/{ciId}")
    public List<AttachmentView> addAttachment(@PathParam(value="ciId") @IdParam String ciId, @Context HttpServletRequest request) throws IOException {
        this.permissionChecker.checkEditAttachment(ciId);
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            throw new BadRequestException("Expected multipart content");
        }
        ServletFileUpload upload = new ServletFileUpload();
        upload.setSizeMax((long)XlrConfig.getInstance().server().upload().maxSizeBytes());
        try {
            FileItemIterator fileItems = upload.getItemIterator(request);
            List<AttachmentView> returnedViews = this.uploadService.addAttachment(ciId, fileItems).stream().map(AttachmentView::new).collect(Collectors.toList());
            if (returnedViews.isEmpty()) {
                throw new BadRequestException("Expected file upload");
            }
            return returnedViews;
        }
        catch (FileUploadException ex) {
            throw new BadRequestException((Throwable)ex);
        }
    }
}

