/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.variables;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.variables.ValueProviderConfiguration;
import com.xebialabs.xlrelease.variable.VariableHelper;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(virtual=true, versioned=false)
public abstract class Variable
extends BaseConfiguration
implements Cloneable,
VisitableItem {
    @PublicApiMember
    @Property(description="The unique name of the variable in the way it is used in template or release, without curly braces")
    protected String key;
    @PublicApiMember
    @Property(required=false, defaultValue="true", description="Shows if an empty value is a valid value for this variable")
    protected boolean requiresValue;
    @PublicApiMember
    @Property(required=false, defaultValue="true", description="Shows if this variable will be shown on create release page")
    protected boolean showOnReleaseStart;
    @PublicApiMember
    @Property(required=false, description="Label of the variable")
    protected String label;
    @PublicApiMember
    @Property(required=false, description="Description of the variable")
    protected String description;
    @PublicApiMember
    @Property(required=false, description="Configuration of the variable values provider")
    protected ValueProviderConfiguration valueProvider;
    @Property(required=false, description="Determines whether the variable value is inherited from the template variable. Used in the Create Release Task only.")
    protected boolean inherited;

    @PublicApiMember
    public abstract Object getValue();

    public abstract Object getEmptyValue();

    @PublicApiMember
    public boolean isValueEmpty() {
        return this.getValue() == null || this.getValue().equals(this.getEmptyValue());
    }

    public abstract void setUntypedValue(Object var1) throws IllegalArgumentException;

    @PublicApiMember
    public String getKey() {
        return this.key;
    }

    @PublicApiMember
    public void setKey(String key) {
        this.key = key;
    }

    @PublicApiMember
    public boolean getRequiresValue() {
        return this.requiresValue;
    }

    @PublicApiMember
    public void setRequiresValue(boolean requiresValue) {
        this.requiresValue = requiresValue;
    }

    @PublicApiMember
    public boolean getShowOnReleaseStart() {
        return this.showOnReleaseStart;
    }

    @PublicApiMember
    public void setShowOnReleaseStart(boolean showOnReleaseStart) {
        this.showOnReleaseStart = showOnReleaseStart;
    }

    @PublicApiMember
    public String getLabel() {
        return this.label;
    }

    @PublicApiMember
    public void setLabel(String label) {
        this.label = label;
    }

    @PublicApiMember
    public String getDescription() {
        return this.description;
    }

    @PublicApiMember
    public void setDescription(String description) {
        this.description = description;
    }

    public void checkValidity() {
        Preconditions.checkNotNull((Object)this.getKey());
        Preconditions.checkArgument((!VariableHelper.isCiPropertyVariable(this.getKey()) ? 1 : 0) != 0, (Object)String.format("You cannot create a variable with a key like release.* (%s)", this.getKey()));
        Preconditions.checkArgument((!VariableHelper.isGlobalVariable(this.getKey()) ? 1 : 0) != 0, (Object)String.format("You cannot create a variable with a key like global.* (%s)", this.getKey()));
        Preconditions.checkArgument((!VariableHelper.isFolderVariable(this.getKey()) ? 1 : 0) != 0, (Object)String.format("You cannot create a variable with a key like folder.* (%s)", this.getKey()));
    }

    public void checkGlobalVariableValidity() {
        Preconditions.checkNotNull((Object)this.getKey());
        Preconditions.checkArgument((boolean)VariableHelper.isGlobalVariable(this.getKey()), (String)"Global variable names must start with \"global.\", but [%s] was supplied", (Object)this.getKey());
        Preconditions.checkArgument((!this.requiresValue && !this.showOnReleaseStart ? 1 : 0) != 0, (Object)"Global variables must have requiresValue and showOnReleaseStart flags unchecked");
    }

    public void checkFolderVariableValidity() {
        Preconditions.checkNotNull((Object)this.getKey());
        Preconditions.checkArgument((boolean)VariableHelper.isFolderVariable(this.getKey()), (String)"Folder variable names must start with \"folder.\", but [%s] was supplied", (Object)this.getKey());
        Preconditions.checkArgument((!this.requiresValue && !this.showOnReleaseStart ? 1 : 0) != 0, (Object)"Folder variables must have requiresValue and showOnReleaseStart flags unchecked");
    }

    public abstract boolean isPassword();

    public abstract String getValueAsString();

    public abstract String getEmptyValueAsString();

    public abstract boolean isValueAssignableFrom(Object var1);

    protected String escapeQuotes(String value) {
        return value.replace("'", "\\'");
    }

    public ValueProviderConfiguration getValueProvider() {
        return this.valueProvider;
    }

    public void setValueProvider(ValueProviderConfiguration valueProvider) {
        this.valueProvider = valueProvider;
        if (valueProvider != null) {
            valueProvider.setVariable(this);
        }
    }

    @Override
    public void accept(ReleaseVisitor visitor) {
        if (this.getValueProvider() != null) {
            visitor.visit(this.getValueProvider());
        }
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public static abstract class VariableWithValue<V>
    extends Variable {
        public abstract V getValue();

        public abstract void setValue(V var1);
    }
}

