/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.views.ClusterInfoView;
import com.xebialabs.xlrelease.views.LicenseView;
import com.xebialabs.xlrelease.views.ServerInfoView;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/server")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class ServerResource {
    private ServerConfiguration serverConfiguration;
    private LicenseService licenseService;

    @Autowired
    public ServerResource(ServerConfiguration serverConfiguration, LicenseService licenseService) {
        this.serverConfiguration = serverConfiguration;
        this.licenseService = licenseService;
    }

    @GET
    @Timed
    @Path(value="host")
    public ServerInfoView getHostUrl() {
        return new ServerInfoView(this.serverConfiguration.getServerUrl());
    }

    @GET
    @Timed
    @Path(value="license")
    public LicenseView getLicence() {
        return new LicenseView(this.licenseService.getLicense());
    }

    @GET
    @Timed
    @Path(value="cluster")
    public ClusterInfoView getClusterInfo() {
        ClusterInfoView clusterInfoView = new ClusterInfoView();
        clusterInfoView.setClusterMode(XlrConfig.getInstance().clusterMode().configOption());
        clusterInfoView.setClusterName(XlrConfig.getInstance().cluster().name());
        if (XlrConfig.getInstance().cluster().config().hasPath("clusterPort")) {
            clusterInfoView.setClusterPort(XlrConfig.getInstance().cluster().config().getInt("clusterPort"));
        }
        if (XlrConfig.getInstance().cluster().config().hasPath("hostname")) {
            clusterInfoView.setNodeHostname(XlrConfig.getInstance().cluster().config().getString("hostname"));
        }
        return clusterInfoView;
    }

    @GET
    @Timed
    @Path(value="configuration")
    public Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("client.session.remember.enabled", this.serverConfiguration.isClientSessionRememberEnabled());
        return properties;
    }
}

