/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTree;
import org.kohsuke.github.Requester;

public class GHTreeBuilder {
    private final GHRepository repo;
    private final Requester req;
    private final List<TreeEntry> treeEntries = new ArrayList<TreeEntry>();

    GHTreeBuilder(GHRepository repo) {
        this.repo = repo;
        this.req = new Requester(repo.root);
    }

    public GHTreeBuilder baseTree(String baseTree) {
        this.req.with("base_tree", baseTree);
        return this;
    }

    public GHTreeBuilder entry(String path, String mode, String type, String sha, String content) {
        TreeEntry entry = new TreeEntry(path, mode, type);
        entry.sha = sha;
        entry.content = content;
        this.treeEntries.add(entry);
        return this;
    }

    public GHTreeBuilder shaEntry(String path, String sha, boolean executable) {
        TreeEntry entry = new TreeEntry(path, executable ? "100755" : "100644", "blob");
        entry.sha = sha;
        this.treeEntries.add(entry);
        return this;
    }

    public GHTreeBuilder textEntry(String path, String content, boolean executable) {
        TreeEntry entry = new TreeEntry(path, executable ? "100755" : "100644", "blob");
        entry.content = content;
        this.treeEntries.add(entry);
        return this;
    }

    private String getApiTail() {
        return String.format("/repos/%s/%s/git/trees", this.repo.getOwnerName(), this.repo.getName());
    }

    public GHTree create() throws IOException {
        this.req._with("tree", this.treeEntries);
        return ((GHTree)((Object)this.req.method("POST").to(this.getApiTail(), GHTree.class))).wrap(this.repo);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private static final class TreeEntry {
        private final String path;
        private final String mode;
        private final String type;
        private String sha;
        private String content;

        private TreeEntry(String path, String mode, String type) {
            this.path = path;
            this.mode = mode;
            this.type = type;
        }
    }
}

