/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.DownloadService;
import com.xebialabs.deployit.core.rest.api.DownloadResource$;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.util.OverthereUtils;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.UUID;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Predef$;
import scala.collection.convert.ImplicitConversionsToScala$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005}u!\u0002\r\u001a\u0011\u00031c!\u0002\u0015\u001a\u0011\u0003I\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004b\u0002\u001a\u0002\u0005\u0004%\ta\r\u0005\u0007y\u0005\u0001\u000b\u0011\u0002\u001b\u0007\t!J\u0002!\u0010\u0005\t\u001d\u0016\u0011\t\u0011)A\u0005\u001f\")\u0001'\u0002C\u0001U\"9!/\u0002b\u0001\n\u0013\u0019\bB\u0002>\u0006A\u0003%A\u000fC\u0004|\u000b\t\u0007I\u0011B:\t\rq,\u0001\u0015!\u0003u\u0011\u0015iX\u0001\"\u0011\u007f\u0011\u001d\t9#\u0002C\u0001\u0003SAq!a\r\u0006\t\u0013\t)\u0004C\u0004\u0002H\u0015!I!!\u0013\t\u000f\u0005=S\u0001\"\u0003\u0002R\u00191\u0011QK\u0003\u0006\u0003/B\u0011\"!\f\u0012\u0005\u0003\u0005\u000b\u0011\u0002;\t\rA\nB\u0011AA-\u0011\u001d\t\t'\u0005C\u0001\u0003GBq!a\u001f\u0012\t\u0003\ti\bC\u0004\u0002\u0004F!\t!!\"\t\u0013\u0005-U!!A\u0005\f\u00055\u0015\u0001\u0005#po:dw.\u00193SKN|WO]2f\u0015\tQ2$A\u0002ba&T!\u0001H\u000f\u0002\tI,7\u000f\u001e\u0006\u0003=}\tAaY8sK*\u0011\u0001%I\u0001\tI\u0016\u0004Hn\\=ji*\u0011!eI\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001J\u0001\u0004G>l7\u0001\u0001\t\u0003O\u0005i\u0011!\u0007\u0002\u0011\t><h\u000e\\8bIJ+7o\\;sG\u0016\u001c\"!\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta%\u0001\rD\u001f:#VI\u0014+`)f\u0003ViU0G\u001f2#UI\u0015(B\u001b\u0016+\u0012\u0001\u000e\t\u0003kij\u0011A\u000e\u0006\u0003oa\nA\u0001\\1oO*\t\u0011(\u0001\u0003kCZ\f\u0017BA\u001e7\u0005\u0019\u0019FO]5oO\u0006I2i\u0014(U\u000b:#v\fV-Q\u000bN{fi\u0014'E\u000bJs\u0015)T#!'\u0011)a(\u0011$\u0011\u0005Uz\u0014B\u0001!7\u0005\u0019y%M[3diB\u0011!\tR\u0007\u0002\u0007*\u0011!$H\u0005\u0003\u000b\u000e\u0013q\u0002R8x]2|\u0017\rZ*feZL7-\u001a\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bQa\u001d7gi)T\u0011aS\u0001\tOJL'P\u001f7fI&\u0011Q\n\u0013\u0002\b\u0019><w-\u001b8h\u00039)\u0007\u0010]8siJ{w\u000e\u001e)bi\"\u0004\"\u0001U,\u000f\u0005E+\u0006C\u0001*-\u001b\u0005\u0019&B\u0001+&\u0003\u0019a$o\\8u}%\u0011a\u000bL\u0001\u0007!J,G-\u001a4\n\u0005mB&B\u0001,-Q\u00111!\f[5\u0011\u0005m3W\"\u0001/\u000b\u0005us\u0016AC1o]>$\u0018\r^5p]*\u0011q\fY\u0001\bM\u0006\u001cGo\u001c:z\u0015\t\t'-A\u0003cK\u0006t7O\u0003\u0002dI\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001f\u0003\ry'oZ\u0005\u0003Or\u0013\u0011\"U;bY&4\u0017.\u001a:\u0002\u000bY\fG.^3\"\u00039#\"a\u001b7\u0011\u0005\u001d*\u0001\"\u0002(\b\u0001\u0004y\u0005\u0006\u00027[Q&D#aB8\u0011\u0005m\u0003\u0018BA9]\u0005%\tU\u000f^8xSJ,G-\u0001\u0006fqB|'\u000f\u001e*p_R,\u0012\u0001\u001e\t\u0003kbl\u0011A\u001e\u0006\u0003ob\n!![8\n\u0005e4(\u0001\u0002$jY\u0016\f1\"\u001a=q_J$(k\\8uA\u0005\u00012m\u001c8uK:$H+\u001f9fgJ+\u0007o\\\u0001\u0012G>tG/\u001a8u)f\u0004Xm\u001d*fa>\u0004\u0013\u0001\u00033po:dw.\u00193\u0015\u0007}\f)\u0002\u0005\u0003\u0002\u0002\u0005EQBAA\u0002\u0015\rq\u0012Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0002sg*!\u00111BA\u0007\u0003\t98O\u0003\u0002\u0002\u0010\u0005)!.\u0019<bq&!\u00111CA\u0002\u0005!\u0011Vm\u001d9p]N,\u0007BBA\f\u0019\u0001\u0007q*A\u0006e_^tGn\\1e\u0017\u0016L\bfBA\u000b\u00037A\u00171\u0005\t\u0005\u0003;\ty\"\u0004\u0002\u0002\u0006%!\u0011\u0011EA\u0003\u0005%\u0001\u0016\r\u001e5QCJ\fW.\t\u0002\u0002&\u0005YAm\\<oY>\fGm[3z\u0003!\u0011XmZ5ti\u0016\u0014H#B(\u0002,\u0005=\u0002BBA\u0017\u001b\u0001\u0007A/\u0001\u0003gS2,\u0007BBA\u0019\u001b\u0001\u0007q*A\u0006d_:$XM\u001c;UsB,\u0017!\u00053po:dw.\u00193G_2$WM\u001d$peR!\u0011qGA#!\u0011\tI$!\u0011\u000e\u0005\u0005m\"\u0002BA\u0017\u0003{Q1!a\u00109\u0003\rq\u0017n\\\u0005\u0005\u0003\u0007\nYD\u0001\u0003QCRD\u0007BBA\f\u001d\u0001\u0007q*A\nsK\u001eL7\u000f^3s\u0007>tG/\u001a8u)f\u0004X\r\u0006\u0004\u00028\u0005-\u0013Q\n\u0005\u0007\u0003/y\u0001\u0019A(\t\r\u0005Er\u00021\u0001P\u00039\u0019wN\u001c;f]R$\u0016\u0010]3G_J$B!a\u000e\u0002T!1\u0011q\u0003\tA\u0002=\u0013\u0011BR5mKV#\u0018\u000e\\:\u0014\u0005EQC\u0003BA.\u0003?\u00022!!\u0018\u0012\u001b\u0005)\u0001BBA\u0017'\u0001\u0007A/A\tu_N#(/Z1nS:<w*\u001e;qkR$B!!\u001a\u0002lA!\u0011\u0011AA4\u0013\u0011\tI'a\u0001\u0003\u001fM#(/Z1nS:<w*\u001e;qkRD\u0001\"!\u001c\u0015\t\u0003\u0007\u0011qN\u0001\u000eM&t\u0017\r\\5{K^\u0013\u0018\u000e^3\u0011\u000b-\n\t(!\u001e\n\u0007\u0005MDF\u0001\u0005=Eft\u0017-\\3?!\rY\u0013qO\u0005\u0004\u0003sb#\u0001B+oSR\fa!\\8wKR{G\u0003BA\u001c\u0003\u007fBq!!!\u0016\u0001\u0004\t9$A\teKN$\u0018N\\1uS>tgi\u001c7eKJ\fQ\"\u001a8tkJ,\u0007K]3tK:$Hc\u0001;\u0002\b\"1\u0011\u0011\u0012\fA\u0002=\u000baa\u001c:FYN,\u0017!\u0003$jY\u0016,F/\u001b7t)\u0011\tY&a$\t\r\u00055r\u00031\u0001uQ\r)\u00111\u0013\t\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011\u00142\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002\u001e\u0006]%AC\"p]R\u0014x\u000e\u001c7fe\u0002")
public class DownloadResource
implements DownloadService,
Logging {
    private final File exportRoot;
    private final File contentTypesRepo;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String CONTENT_TYPES_FOLDERNAME() {
        return DownloadResource$.MODULE$.CONTENT_TYPES_FOLDERNAME();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DownloadResource downloadResource = this;
        synchronized (downloadResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private File exportRoot() {
        return this.exportRoot;
    }

    private File contentTypesRepo() {
        return this.contentTypesRepo;
    }

    public Response download(@PathParam(value="downloadkey") String downloadKey) {
        File downloadFolder = this.downloadFolderFor(downloadKey).toFile();
        File contents = (File)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (File)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])downloadFolder.listFiles())).head()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(39).append("The download with key [").append(downloadKey).append("] was not found.").toString(), new Object[0]);
        });
        String contentType = (String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (String)ImplicitConversionsToScala$.MODULE$.list$u0020asScalaBuffer(Files.readAllLines(this.contentTypeFor(downloadKey))).head()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(54).append("Cannot determine content type for download with key [").append(downloadKey).append("]").toString(), new Object[0]);
        });
        StreamingOutput output = this.FileUtils(contents).toStreamingOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalFile.from((File)downloadFolder).deleteRecursively();
            this.contentTypeFor(downloadKey).toFile().delete();
        });
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Going to stream download of [").append(downloadKey).append("] with type [").append(contentType).append("]").toString());
        return Response.ok((Object)output, (String)contentType).header("Content-Disposition", (Object)new StringBuilder(23).append("attachment; filename=\"").append(contents.getName()).append("\"").toString()).header("Content-Length", (Object)String.valueOf(contents.length())).build();
    }

    /*
     * WARNING - void declaration
     */
    public String register(File file, String contentType) {
        void var3_3;
        String downloadKey = UUID.randomUUID().toString();
        Path downloadFolder = this.downloadFolderFor(downloadKey);
        if (!downloadFolder.toFile().mkdirs()) {
            throw new DeployitException(new StringBuilder(38).append("Cannot create directory for download: ").append(downloadFolder).toString());
        }
        Path movedFile = this.FileUtils(file).moveTo(downloadFolder);
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Registering download [").append(movedFile).append("] with content type [").append(contentType).append("] and key [").append(downloadKey).append("]").toString());
        this.registerContentType(downloadKey, contentType);
        return var3_3;
    }

    private Path downloadFolderFor(String downloadKey) {
        return Paths.get(this.exportRoot().getAbsolutePath(), downloadKey);
    }

    private Path registerContentType(String downloadKey, String contentType) {
        Path path;
        Path registerPath = this.contentTypeFor(downloadKey);
        try {
            path = Files.write(registerPath, Collections.singletonList(contentType), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new DeployitException((Throwable)e, new StringBuilder(54).append("Cannot register content type for download key [").append(downloadKey).append("] in [").append(registerPath).append("]").toString(), new Object[0]);
        }
        return path;
    }

    private Path contentTypeFor(String downloadKey) {
        return Paths.get(this.contentTypesRepo().getAbsolutePath(), downloadKey);
    }

    private FileUtils FileUtils(File file) {
        return new FileUtils(this, file);
    }

    @Autowired
    public DownloadResource(@Qualifier(value="exportRootPath") String exportRootPath) {
        Logging.$init$((Logging)this);
        this.exportRoot = this.FileUtils(new File(exportRootPath)).ensurePresent(new StringBuilder(32).append("Cannot create download cache at ").append(exportRootPath).toString());
        this.contentTypesRepo = this.FileUtils(new File(this.exportRoot(), DownloadResource$.MODULE$.CONTENT_TYPES_FOLDERNAME())).ensurePresent(new StringBuilder(44).append("Cannot create content-type repository under ").append(this.exportRoot().getAbsolutePath()).toString());
    }

    public class FileUtils {
        private final File file;
        public final /* synthetic */ DownloadResource $outer;

        public StreamingOutput toStreamingOutput(Function0<BoxedUnit> finalizeWrite) {
            return outputStream -> {
                FileInputStream is = new FileInputStream($this.file);
                try {
                    OverthereUtils.write((InputStream)is, (OutputStream)outputStream);
                }
                finally {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                    finalizeWrite.apply$mcV$sp();
                }
            };
        }

        public Path moveTo(Path destinationFolder) {
            Path path;
            Path destination = destinationFolder.resolve(this.file.getName());
            try {
                path = Files.move(this.file.toPath(), destination, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new DeployitException((Throwable)e, new StringBuilder(41).append("Could not move file ").append(this.file.getAbsolutePath()).append(" to download cache [").append(destination).append("]").toString(), new Object[0]);
            }
            return path;
        }

        public File ensurePresent(String orElse) {
            if (!this.file.exists() && !this.file.mkdirs()) {
                throw new DeployitException(orElse);
            }
            return this.file;
        }

        public /* synthetic */ DownloadResource com$xebialabs$deployit$core$rest$api$DownloadResource$FileUtils$$$outer() {
            return this.$outer;
        }

        public FileUtils(DownloadResource $outer, File file) {
            this.file = file;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

