/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class ScriptLifeCycle {
    private Map<String, State> executionStates = Maps.newHashMap();

    public synchronized void tryAborting(String executionId) {
        if (this.executionStates.containsKey(executionId)) {
            this.executionStates.get(executionId).tryInterrupting();
        }
    }

    public synchronized void register(String executionId) {
        Preconditions.checkState((!this.executionStates.containsKey(executionId) ? 1 : 0) != 0, (Object)("Expected executionId: '" + executionId + "' to be unregistered"));
        this.executionStates.put(executionId, new State());
    }

    public synchronized void start(String executionId) throws InterruptedException {
        Preconditions.checkState((boolean)this.executionStates.containsKey(executionId), (Object)("Expected executionId: '" + executionId + "' to be registered"));
        this.executionStates.get(executionId).begin(executionId);
    }

    public synchronized void end(String executionId) {
        Preconditions.checkState((boolean)this.executionStates.containsKey(executionId), (Object)("Expected executionId: '" + executionId + "' to be registered"));
        this.executionStates.get(executionId).end("executionId");
    }

    public synchronized void unregister(String executionId) {
        Preconditions.checkState((boolean)this.executionStates.containsKey(executionId), (Object)("Expected executionId: '" + executionId + "' to be registered"));
        ScriptState scriptState = this.executionStates.get(executionId).scriptState;
        Preconditions.checkState((scriptState == ScriptState.REGISTERED || scriptState == ScriptState.DONE ? 1 : 0) != 0, (Object)("Expected executionId: '" + executionId + "' to be registered or done"));
        this.executionStates.remove(executionId);
    }

    static class State {
        private ScriptState scriptState = ScriptState.REGISTERED;
        private boolean interruptionRequested = false;
        private Thread thread = null;

        State() {
        }

        public void tryInterrupting() {
            this.interruptionRequested = true;
            if (this.scriptState == ScriptState.STARTED) {
                this.thread.interrupt();
            }
        }

        public void begin(String executionId) throws InterruptedException {
            Preconditions.checkState((this.scriptState == ScriptState.REGISTERED ? 1 : 0) != 0, (Object)("Expected executionId: '" + executionId + "' to be registered"));
            if (this.interruptionRequested) {
                this.interruptionRequested = false;
                throw new InterruptedException();
            }
            this.scriptState = ScriptState.STARTED;
            this.thread = Thread.currentThread();
        }

        public void end(String executionId) {
            Preconditions.checkState((this.scriptState == ScriptState.STARTED ? 1 : 0) != 0, (Object)("Expected executionId: '" + executionId + "' to be started"));
            this.scriptState = ScriptState.DONE;
            Thread.interrupted();
        }
    }

    static enum ScriptState {
        REGISTERED,
        STARTED,
        DONE;

    }
}

