/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.domain.DeliveryStatus;
import com.xebialabs.xlrelease.delivery.domain.Stage;
import com.xebialabs.xlrelease.delivery.domain.StageStatus;
import com.xebialabs.xlrelease.delivery.domain.StageTrackedItem;
import com.xebialabs.xlrelease.delivery.domain.Subscriber;
import com.xebialabs.xlrelease.delivery.domain.SubscriptionResult;
import com.xebialabs.xlrelease.delivery.domain.SubscriptionStatus;
import com.xebialabs.xlrelease.delivery.domain.TrackedItem;
import com.xebialabs.xlrelease.delivery.domain.TrackedItemStatus;
import com.xebialabs.xlrelease.delivery.domain.Transition;
import com.xebialabs.xlrelease.delivery.events.DeliveryCompletedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryEvent;
import com.xebialabs.xlrelease.delivery.events.ItemAvailableEvent;
import com.xebialabs.xlrelease.delivery.events.ItemCompletedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemDescopedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemRescopedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemSkippedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemTransitionApprovedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.StageCompletedEvent;
import com.xebialabs.xlrelease.delivery.events.StageReopenedEvent;
import com.xebialabs.xlrelease.delivery.events.StageStartedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionExecutedEvent;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.transition.TransitionEvaluator$;
import com.xebialabs.xlrelease.delivery.transition.TransitionParams;
import com.xebialabs.xlrelease.delivery.transition.TransitionResult;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Date;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSeqLike;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tms!B\u0016-\u0011\u00039d!B\u001d-\u0011\u0003Q\u0004\"B!\u0002\t\u0003\u0011\u0005\"B\"\u0002\t\u0003!e\u0001B\u001d-\u0001\u0019C\u0001b\f\u0003\u0003\u0006\u0004%\ta\u0012\u0005\t\u001d\u0012\u0011\t\u0011)A\u0005\u0011\"Aq\n\u0002B\u0001B\u0003%\u0001\u000bC\u0003B\t\u0011\u0005a\u000bC\u0004Z\t\t\u0007I\u0011\u0002.\t\r!$\u0001\u0015!\u0003\\\u0011\u001dIGA1A\u0005\n)Daa\u001e\u0003!\u0002\u0013Y\u0007\"\u0002=\u0005\t\u0003I\bbBA\u0004\t\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003\u001b!A\u0011AA\b\u0011\u001d\tY\u0002\u0002C\u0001\u0003;Aq!!\t\u0005\t\u0003\t\u0019\u0003C\u0004\u00020\u0011!\t!!\r\t\u000f\u0005eB\u0001\"\u0001\u0002<!9\u0011Q\n\u0003\u0005\u0002\u0005=\u0003bBA)\t\u0011\u0005\u00111\u000b\u0005\n\u0003\u0003#\u0011\u0013!C\u0001\u0003\u0007C\u0011\"!'\u0005#\u0003%\t!a'\t\u000f\u0005}E\u0001\"\u0001\u0002\"\"9\u00111\u0016\u0003\u0005\u0002\u00055\u0006\"CA[\tE\u0005I\u0011AAN\u0011\u001d\t9\f\u0002C\u0001\u0003sCq!!0\u0005\t\u0003\ty\fC\u0004\u0002D\u0012!\t!!2\t\u000f\u0005%G\u0001\"\u0001\u0002L\"9\u0011q\u001a\u0003\u0005\u0002\u0005E\u0007bBAl\t\u0011\u0005\u0011\u0011\u001c\u0005\b\u0003G$A\u0011AAs\u0011\u001d\t\u0019\u000f\u0002C\u0005\u0003\u007fDqAa\u0004\u0005\t\u0013\u0011\t\u0002C\u0005\u0003\u001a\u0011\t\n\u0011\"\u0003\u0003\u001c!9!q\u0004\u0003\u0005\n\t\u0005\u0002b\u0002B\u0019\t\u0011%!1\u0007\u0005\b\u0005k!A\u0011\u0002B\u001c\u0011\u001d\u0011Y\u0004\u0002C\u0005\u0005{AqA!\u0011\u0005\t\u0013\u0011\u0019\u0005C\u0004\u0003F\u0011!IAa\u0012\u0002)\u0011+G.\u001b<fef\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0015\tic&A\u0004tKJ4\u0018nY3\u000b\u0005=\u0002\u0014\u0001\u00033fY&4XM]=\u000b\u0005E\u0012\u0014!\u0003=me\u0016dW-Y:f\u0015\t\u0019D'A\u0005yK\nL\u0017\r\\1cg*\tQ'A\u0002d_6\u001c\u0001\u0001\u0005\u00029\u00035\tAF\u0001\u000bEK2Lg/\u001a:z'R\fG/Z'b]\u0006<WM]\n\u0003\u0003m\u0002\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00018\u0003\u0015\t\u0007\u000f\u001d7z)\u0015)%1\nB'!\tADa\u0005\u0002\u0005wU\t\u0001\n\u0005\u0002J\u00196\t!J\u0003\u0002L]\u00051Am\\7bS:L!!\u0014&\u0003\u0011\u0011+G.\u001b<fef\f\u0011\u0002Z3mSZ,'/\u001f\u0011\u0002\u000f\u0019\f7\r^8ssB\u0011\u0011\u000bV\u0007\u0002%*\u00111KL\u0001\u0005kRLG.\u0003\u0002V%\n)B)\u001a7jm\u0016\u0014\u0018p\u00142kK\u000e$h)Y2u_JLHcA#X1\")q\u0006\u0003a\u0001\u0011\")q\n\u0003a\u0001!\u00061QM^3oiN,\u0012a\u0017\t\u00049\u0006\u001cW\"A/\u000b\u0005y{\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0003Av\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0011WL\u0001\u0004Ck\u001a4WM\u001d\t\u0003I\u001al\u0011!\u001a\u0006\u00033:J!aZ3\u0003\u001b\u0011+G.\u001b<fef,e/\u001a8u\u0003\u001d)g/\u001a8ug\u0002\n\u0001\"\\3tg\u0006<Wm]\u000b\u0002WB\u0019A,\u00197\u0011\u00055$hB\u00018s!\tyW(D\u0001q\u0015\t\th'\u0001\u0004=e>|GOP\u0005\u0003gv\na\u0001\u0015:fI\u00164\u0017BA;w\u0005\u0019\u0019FO]5oO*\u00111/P\u0001\n[\u0016\u001c8/Y4fg\u0002\n\u0011bZ3u\u000bZ,g\u000e^:\u0016\u0003i\u0004Ba_A\u0001G:\u0011AP \b\u0003_vL\u0011AP\u0005\u0003\u007fv\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0004\u0005\u0015!\u0001\u0002'jgRT!a`\u001f\u0002\u0017\u001d,G/T3tg\u0006<Wm]\u000b\u0003\u0003\u0017\u0001Ba_A\u0001Y\u0006q\u0011\r\u001a3Ue\u0006\u001c7.\u001a3Ji\u0016lG\u0003BA\t\u0003/\u00012!SA\n\u0013\r\t)B\u0013\u0002\f)J\f7m[3e\u0013R,W\u000eC\u0004\u0002\u001a=\u0001\r!!\u0005\u0002\t%$X-\\\u0001\u0012kB$\u0017\r^3Ue\u0006\u001c7.\u001a3Ji\u0016lG\u0003BA\t\u0003?Aq!!\u0007\u0011\u0001\u0004\t\t\"A\teK2,G/\u001a+sC\u000e\\W\rZ%uK6$B!!\n\u0002,A\u0019A(a\n\n\u0007\u0005%RH\u0001\u0003V]&$\bBBA\u0017#\u0001\u0007A.\u0001\u0004ji\u0016l\u0017\nZ\u0001\u0011C\u0012$'+\u001a7fCN,Gk\\%uK6$b!!\n\u00024\u0005U\u0002bBA\r%\u0001\u0007\u0011\u0011\u0003\u0005\u0007\u0003o\u0011\u0002\u0019\u00017\u0002\u0013I,G.Z1tK&#\u0017A\u0005:fO&\u001cH/\u001a:Tk\n\u001c8M]5cKJ$B!!\u0010\u0002DA\u0019\u0011*a\u0010\n\u0007\u0005\u0005#J\u0001\nTk\n\u001c8M]5qi&|gNU3tk2$\bbBA#'\u0001\u0007\u0011qI\u0001\u000bgV\u00147o\u0019:jE\u0016\u0014\bcA%\u0002J%\u0019\u00111\n&\u0003\u0015M+(m]2sS\n,'/A\u0003ti\u0006\u0014H\u000fF\u0001I\u0003]i\u0017M]6Ue\u0006\u001c7.\u001a3Ji\u0016l7/\u00138Ti\u0006<W\r\u0006\u0007\u0002V\u0005m\u0013qLA5\u0003g\ni\bE\u0003|\u0003/\n\t\"\u0003\u0003\u0002Z\u0005\u0015!aA*fc\"9\u0011QL\u000bA\u0002\u0005U\u0013!B5uK6\u001c\bbBA1+\u0001\u0007\u00111M\u0001\u0006gR\fw-\u001a\t\u0004\u0013\u0006\u0015\u0014bAA4\u0015\n)1\u000b^1hK\"9\u00111N\u000bA\u0002\u00055\u0014AB:uCR,8\u000fE\u0002J\u0003_J1!!\u001dK\u0005E!&/Y2lK\u0012LE/Z7Ti\u0006$Xo\u001d\u0005\n\u0003k*\u0002\u0013!a\u0001\u0003o\nq\u0002\u001d:fG\u0016$\u0017N\\4Ti\u0006<Wm\u001d\t\u0004y\u0005e\u0014bAA>{\t9!i\\8mK\u0006t\u0007\u0002CA@+A\u0005\t\u0019\u00017\u0002\u001b\u0019\u0014x.\u001c*fY\u0016\f7/Z%e\u0003\u0005j\u0017M]6Ue\u0006\u001c7.\u001a3Ji\u0016l7/\u00138Ti\u0006<W\r\n3fM\u0006,H\u000e\u001e\u00135+\t\t)I\u000b\u0003\u0002x\u0005\u001d5FAAE!\u0011\tY)!&\u000e\u0005\u00055%\u0002BAH\u0003#\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005MU(\u0001\u0006b]:|G/\u0019;j_:LA!a&\u0002\u000e\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002C5\f'o\u001b+sC\u000e\\W\rZ%uK6\u001c\u0018J\\*uC\u001e,G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005u%f\u00017\u0002\b\u00061R.\u0019:l)J\f7m[3e\u0013R,W.\u00138Ti\u0006<W\r\u0006\u0006\u0002&\u0005\r\u0016QUAT\u0003SCq!!\u0007\u0019\u0001\u0004\t\t\u0002C\u0004\u0002ba\u0001\r!a\u0019\t\u000f\u0005-\u0004\u00041\u0001\u0002n!1\u0011q\u0010\rA\u00021\f!dY8na2,G/\u001a+sC\u000e\\W\rZ%uK6Len\u0015;bO\u0016$r\u0001SAX\u0003c\u000b\u0019\fC\u0004\u0002\u001ae\u0001\r!!\u0005\t\u000f\u0005\u0005\u0014\u00041\u0001\u0002d!A\u0011qP\r\u0011\u0002\u0003\u0007A.\u0001\u0013d_6\u0004H.\u001a;f)J\f7m[3e\u0013R,W.\u00138Ti\u0006<W\r\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0019w.\u001c9mKR,7\u000b^1hKR!\u0011QEA^\u0011\u001d\t\tg\u0007a\u0001\u0003G\n1B]3pa\u0016t7\u000b^1hKR!\u0011QEAa\u0011\u001d\t\t\u0007\ba\u0001\u0003G\nA\u0002Z3tG>\u0004X-\u0013;f[N$B!!\n\u0002H\"9\u0011QL\u000fA\u0002\u0005U\u0013\u0001\u0004:fg\u000e|\u0007/Z%uK6\u001cH\u0003BA\u0013\u0003\u001bDq!!\u0018\u001f\u0001\u0004\t)&\u0001\ftW&\u0004HK]1dW\u0016$\u0017\n^3n\u0013:\u001cF/Y4f)\u0015A\u00151[Ak\u0011\u001d\tIb\ba\u0001\u0003#Aq!!\u0019 \u0001\u0004\t\u0019'A\bti\u0006\u0014Ho\u0015;bO\u0016<%o\\;q)\u0019\t)#a7\u0002b\"9\u0011Q\u001c\u0011A\u0002\u0005}\u0017AB:uC\u001e,7\u000fE\u0003|\u0003/\n\u0019\u0007C\u0004\u0002^\u0001\u0002\r!!\u0016\u0002!!\fg\u000e\u001a7f)J\fgn]5uS>tGCBA\u0013\u0003O\f\t\u0010C\u0004\u0002j\u0006\u0002\r!a;\u0002\u0015Q\u0014\u0018M\\:ji&|g\u000eE\u0002J\u0003[L1!a<K\u0005)!&/\u00198tSRLwN\u001c\u0005\b\u0003g\f\u0003\u0019AA{\u0003\u0019\u0001\u0018M]1ngB!\u0011q_A~\u001b\t\tIPC\u0002\u0002j:JA!!@\u0002z\n\u0001BK]1og&$\u0018n\u001c8QCJ\fWn\u001d\u000b\t\u0003K\u0011\tAa\u0001\u0003\u0006!9\u0011\u0011\u001e\u0012A\u0002\u0005-\bbBAzE\u0001\u0007\u0011Q\u001f\u0005\b\u0005\u000f\u0011\u0003\u0019\u0001B\u0005\u0003A!(/\u00198tSRLwN\u001c*fgVdG\u000f\u0005\u0003\u0002x\n-\u0011\u0002\u0002B\u0007\u0003s\u0014\u0001\u0003\u0016:b]NLG/[8o%\u0016\u001cX\u000f\u001c;\u00027\u0019|'oY3DY>\u001cXm\u0015;bO\u0016\u001c\u0018J\u001a(pi\u000ecwn]3e)\u0019\t)Ca\u0005\u0003\u0016!9\u0011Q\\\u0012A\u0002\u0005}\u0007\"\u0003B\fGA\u0005\t\u0019AA+\u00039IG/Z7t)>$Um]2pa\u0016\fQEZ8sG\u0016\u001cEn\\:f'R\fw-Z:JM:{Go\u00117pg\u0016$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tu!\u0006BA+\u0003\u000f\u000bQEZ8sG\u0016\u001c6.\u001b9Ue\u0006\u001c7.\u001a3Ji\u0016l\u0017J\\*uC\u001e,\u0017J\u001a(piJ+\u0017\rZ=\u0015\u0011\u0005\u0015\"1\u0005B\u0013\u0005OAq!!\u0007&\u0001\u0004\t\t\u0002C\u0004\u0002b\u0015\u0002\r!a\u0019\t\u000f\t%R\u00051\u0001\u0003,\u0005\u00012\u000f^1hKR\u0013\u0018mY6fI&#X-\u001c\t\u0004\u0013\n5\u0012b\u0001B\u0018\u0015\n\u00012\u000b^1hKR\u0013\u0018mY6fI&#X-\\\u0001\nQ\u0006\u001c8\u000b^1hKN,\"!a\u001e\u0002+%\u001c\u0018\t\u001c7po\u0016$Gk\\\"m_N,7\u000b^1hKR!\u0011q\u000fB\u001d\u0011\u001d\t\tg\na\u0001\u0003G\na#[:BY2|w/\u001a3U_J+w\u000e]3o'R\fw-\u001a\u000b\u0005\u0003o\u0012y\u0004C\u0004\u0002b!\u0002\r!a\u0019\u0002+\rDWmY6EK2Lg/\u001a:z\u0013N\f5\r^5wKR\u0011\u0011QE\u0001\u000eC\u0012$7+\u001e2tGJL'-\u001a:\u0015\t\u0005u\"\u0011\n\u0005\b\u0003\u000bR\u0003\u0019AA$\u0011\u0015y3\u00011\u0001I\u0011\u001d\u0011ye\u0001a\u0001\u0005#\n1bY5JIN+'O^5dKB!!1\u000bB,\u001b\t\u0011)F\u0003\u0002.a%!!\u0011\fB+\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3")
public class DeliveryStateManager {
    private final Delivery delivery;
    private final DeliveryObjectFactory factory;
    private final Buffer<DeliveryEvent> events;
    private final Buffer<String> messages;

    public static DeliveryStateManager apply(Delivery delivery, CiIdService ciIdService) {
        return DeliveryStateManager$.MODULE$.apply(delivery, ciIdService);
    }

    public Delivery delivery() {
        return this.delivery;
    }

    private Buffer<DeliveryEvent> events() {
        return this.events;
    }

    private Buffer<String> messages() {
        return this.messages;
    }

    public List<DeliveryEvent> getEvents() {
        return this.events().toList();
    }

    public List<String> getMessages() {
        return this.messages().toList();
    }

    public TrackedItem addTrackedItem(TrackedItem item) {
        block0: {
            this.checkDeliveryIsActive();
            String itemId = this.factory.trackedItemId(this.delivery().getId());
            item.setId(itemId);
            item.setModifiedDate(new Date());
            this.delivery().addTrackedItem(item);
            this.delivery().addReleaseIds(item.getReleaseIds());
            this.events().$plus$eq((Object)new ItemCreatedEvent(item, this.delivery()));
            if (this.delivery().isTemplate()) break block0;
            this.delivery().getStagesBeforeFirstOpenTransition().forEach(stage -> {
                block0: {
                    StageTrackedItem stageTrackedItem = $this.factory.createStageTrackedItem(stage.getId(), itemId);
                    stage.getItems().add(stageTrackedItem);
                    this.events().$plus$eq((Object)new ItemAvailableEvent(item, (Stage)((Object)stage), this.delivery()));
                    if (!stage.isClosed()) break block0;
                    stageTrackedItem.setStatus(TrackedItemStatus.SKIPPED);
                    this.events().$plus$eq((Object)new ItemSkippedEvent(item, (Stage)((Object)stage), this.delivery()));
                }
            });
        }
        return item;
    }

    /*
     * WARNING - void declaration
     */
    public TrackedItem updateTrackedItem(TrackedItem item) {
        void var2_2;
        this.checkDeliveryIsActive();
        TrackedItem updatedItem = this.delivery().getItemByIdOrTitle(item.getId());
        TrackedItem originalItem = (TrackedItem)CiCloneHelper.cloneCi((ConfigurationItem)updatedItem);
        updatedItem.setTitle(item.getTitle());
        updatedItem.setModifiedDate(new Date());
        this.events().$plus$eq((Object)new ItemUpdatedEvent(updatedItem, this.delivery(), originalItem));
        return var2_2;
    }

    public void deleteTrackedItem(String itemId) {
        this.checkDeliveryIsActive();
        TrackedItem item = this.delivery().getItemByIdOrTitle(itemId);
        this.delivery().removeTrackedItem(itemId);
        if (!this.delivery().isTemplate()) {
            this.delivery().getStages().forEach(x$1 -> x$1.removeTrackedItem(itemId));
        }
        this.events().$plus$eq((Object)new ItemRemovedEvent(item, this.delivery()));
    }

    public void addReleaseToItem(TrackedItem item, String releaseId) {
        this.checkDeliveryIsActive();
        item.addReleaseId(releaseId);
        this.delivery().addReleaseId(releaseId);
    }

    public SubscriptionResult registerSubscriber(Subscriber subscriber) {
        this.checkDeliveryIsActive();
        return this.addSubscriber(subscriber);
    }

    public Delivery start() {
        block0: {
            this.delivery().setStatus(DeliveryStatus.IN_PROGRESS);
            if (!this.hasStages()) break block0;
            Buffer firstStageGroup = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getStagesBeforeFirstOpenTransition()).asScala();
            this.startStageGroup((Seq<Stage>)firstStageGroup, (Seq<TrackedItem>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getTrackedItems()).asScala()));
        }
        return this.delivery();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Seq<TrackedItem> markTrackedItemsInStage(Seq<TrackedItem> items, Stage stage, TrackedItemStatus status, boolean precedingStages, String fromReleaseId) {
        v0 = this.delivery().getStatus();
        var8_6 = DeliveryStatus.IN_PROGRESS;
        Checks.checkTrue((boolean)(!(v0 != null ? v0.equals((Object)var8_6) == false : var8_6 != null)), (String)"Only in-progress release deliveries may complete or skip items", (Object[])new Object[0]);
        Checks.checkTrue((boolean)stage.isOpen(), (String)"Stage must be open in order to update items in it", (Object[])new Object[0]);
        v1 = status;
        var9_7 = TrackedItemStatus.READY;
        if (!(v1 == null ? var9_7 != null : v1.equals((Object)var9_7) == false)) ** GOTO lbl-1000
        v2 = status;
        var10_8 = TrackedItemStatus.SKIPPED;
        if (!(v2 != null ? v2.equals((Object)var10_8) == false : var10_8 != null)) lbl-1000:
        // 2 sources

        {
            v3 = true;
        } else {
            v3 = false;
        }
        Checks.checkTrue((boolean)v3, (String)new StringBuilder(29).append("Not allowed to mark items as ").append((Object)status).toString(), (Object[])new Object[0]);
        descopedItems = (Seq)items.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$1$adapted(com.xebialabs.xlrelease.delivery.domain.TrackedItem ), (Lcom/xebialabs/xlrelease/delivery/domain/TrackedItem;)Ljava/lang/Object;)());
        Checks.checkTrue((boolean)descopedItems.isEmpty(), (String)new StringBuilder(72).append("Unable to complete task, the following tracked items are de-scoped:\n * ").append(((TraversableOnce)descopedItems.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$2(com.xebialabs.xlrelease.delivery.domain.TrackedItem ), (Lcom/xebialabs/xlrelease/delivery/domain/TrackedItem;)Ljava/lang/String;)(), Seq$.MODULE$.canBuildFrom())).mkString("\n * ")).append("\n").toString(), (Object[])new Object[0]);
        if (precedingStages) {
            ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getStagesBefore(stage)).asScala()).dropWhile((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$3$adapted(com.xebialabs.xlrelease.delivery.domain.Stage ), (Lcom/xebialabs/xlrelease/delivery/domain/Stage;)Ljava/lang/Object;)())).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$4(com.xebialabs.xlrelease.delivery.service.DeliveryStateManager scala.collection.Seq com.xebialabs.xlrelease.delivery.domain.TrackedItemStatus java.lang.String com.xebialabs.xlrelease.delivery.domain.Stage ), (Lcom/xebialabs/xlrelease/delivery/domain/Stage;)Lscala/collection/Seq;)((DeliveryStateManager)this, items, (TrackedItemStatus)status, (String)fromReleaseId));
        }
        var7_11 = TrackedItemStatus.READY.equals((Object)(var13_10 = status)) != false ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrackedItemStatus[]{TrackedItemStatus.READY})) : (TrackedItemStatus.SKIPPED.equals((Object)var13_10) != false ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrackedItemStatus[]{TrackedItemStatus.READY, TrackedItemStatus.SKIPPED})) : (Seq)Seq$.MODULE$.empty());
        doneStatuses = var7_11;
        doneItems = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stage.getItems()).asScala()).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$6$adapted(scala.collection.Seq com.xebialabs.xlrelease.delivery.domain.StageTrackedItem ), (Lcom/xebialabs/xlrelease/delivery/domain/StageTrackedItem;)Ljava/lang/Object;)((Seq)doneStatuses))).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$7(com.xebialabs.xlrelease.delivery.domain.StageTrackedItem ), (Lcom/xebialabs/xlrelease/delivery/domain/StageTrackedItem;)Ljava/lang/String;)(), Buffer$.MODULE$.canBuildFrom())).toSet();
        var16_14 = items.partition((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$8$adapted(scala.collection.immutable.Set com.xebialabs.xlrelease.delivery.domain.TrackedItem ), (Lcom/xebialabs/xlrelease/delivery/domain/TrackedItem;)Ljava/lang/Object;)((Set)doneItems));
        if (var16_14 == null) {
            throw new MatchError((Object)var16_14);
        }
        done = (Seq)var16_14._1();
        notDone = (Seq)var16_14._2();
        var6_17 = new Tuple2((Object)done, (Object)notDone);
        var15_18 = var6_17;
        done = (Seq)var15_18._1();
        notDone = (Seq)var15_18._2();
        v4 /* !! */  = done.nonEmpty() != false ? this.messages().$plus$eq((Object)new StringBuilder(57).append("Tracked items [").append(((TraversableOnce)done.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$9(com.xebialabs.xlrelease.delivery.domain.TrackedItem ), (Lcom/xebialabs/xlrelease/delivery/domain/TrackedItem;)Ljava/lang/String;)(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("] already completed or skipped on stage '").append(stage.getId()).append("'").toString()) : BoxedUnit.UNIT;
        notDone.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$10$adapted(com.xebialabs.xlrelease.delivery.service.DeliveryStateManager com.xebialabs.xlrelease.delivery.domain.Stage com.xebialabs.xlrelease.delivery.domain.TrackedItemStatus java.lang.String com.xebialabs.xlrelease.delivery.domain.TrackedItem ), (Lcom/xebialabs/xlrelease/delivery/domain/TrackedItem;)Ljava/lang/Object;)((DeliveryStateManager)this, (Stage)stage, (TrackedItemStatus)status, (String)fromReleaseId));
        return notDone;
    }

    public boolean markTrackedItemsInStage$default$4() {
        return false;
    }

    public String markTrackedItemsInStage$default$5() {
        return null;
    }

    public void markTrackedItemInStage(TrackedItem item, Stage stage, TrackedItemStatus status, String fromReleaseId) {
        TrackedItemStatus trackedItemStatus = status;
        if (((Object)((Object)TrackedItemStatus.READY)).equals((Object)trackedItemStatus)) {
            this.completeTrackedItemInStage(item, stage, fromReleaseId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (((Object)((Object)TrackedItemStatus.SKIPPED)).equals((Object)trackedItemStatus)) {
            this.skipTrackedItemInStage(item, stage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Delivery completeTrackedItemInStage(TrackedItem item, Stage stage, String fromReleaseId) {
        DeliveryStatus deliveryStatus = this.delivery().getStatus();
        DeliveryStatus deliveryStatus2 = DeliveryStatus.IN_PROGRESS;
        Checks.checkTrue((!(deliveryStatus != null ? !((Object)((Object)deliveryStatus)).equals((Object)deliveryStatus2) : deliveryStatus2 != null) ? 1 : 0) != 0, (String)"Only in-progress release deliveries may complete items", (Object[])new Object[0]);
        Checks.checkTrue((boolean)stage.isOpen(), (String)"Stage must be open in order to complete items in it", (Object[])new Object[0]);
        Checks.checkTrue((!item.isDescoped() ? 1 : 0) != 0, (String)"Cannot complete de-scoped item", (Object[])new Object[0]);
        StageTrackedItem stageItem = stage.getItemById(item.getId());
        TrackedItemStatus trackedItemStatus = stageItem.getStatus();
        TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.READY;
        Checks.checkTrue(((trackedItemStatus == null ? trackedItemStatus2 != null : !((Object)((Object)trackedItemStatus)).equals((Object)trackedItemStatus2)) ? 1 : 0) != 0, (String)"Only not completed tracked items can be completed", (Object[])new Object[0]);
        stageItem.setStatus(TrackedItemStatus.READY);
        this.events().$plus$eq((Object)new ItemCompletedEvent(item, stage, this.delivery(), fromReleaseId));
        return this.delivery();
    }

    public String completeTrackedItemInStage$default$3() {
        return null;
    }

    public void completeStage(Stage stage) {
        DeliveryStatus deliveryStatus = this.delivery().getStatus();
        DeliveryStatus deliveryStatus2 = DeliveryStatus.IN_PROGRESS;
        Checks.checkTrue((!(deliveryStatus != null ? !((Object)((Object)deliveryStatus)).equals((Object)deliveryStatus2) : deliveryStatus2 != null) ? 1 : 0) != 0, (String)"Only in-progress release deliveries may complete stages", (Object[])new Object[0]);
        Checks.checkTrue((boolean)stage.isOpen(), (String)"Only open stages may be completed", (Object[])new Object[0]);
        Checks.checkTrue((boolean)this.isAllowedToCloseStage(stage), (String)"Stages cannot be completed if their preceding stages are not closed", (Object[])new Object[0]);
        Buffer toDescopeAndSkip = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stage.getItems()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$completeStage$1(x$9)))).map((Function1 & Serializable & scala.Serializable)stageItem -> this.delivery().getItemByIdOrTitle(stageItem.getTrackedItemId()), Buffer$.MODULE$.canBuildFrom());
        this.forceCloseStagesIfNotClosed((Seq<Stage>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Stage[]{stage}))), (Seq<TrackedItem>)toDescopeAndSkip);
    }

    public void reopenStage(Stage stage) {
        block0: {
            DeliveryStatus deliveryStatus = this.delivery().getStatus();
            DeliveryStatus deliveryStatus2 = DeliveryStatus.IN_PROGRESS;
            Checks.checkTrue((!(deliveryStatus != null ? !((Object)((Object)deliveryStatus)).equals((Object)deliveryStatus2) : deliveryStatus2 != null) ? 1 : 0) != 0, (String)"Only in-progress release deliveries may reopen stages", (Object[])new Object[0]);
            Checks.checkTrue((boolean)stage.isClosed(), (String)"Only closed stages may be reopened", (Object[])new Object[0]);
            Checks.checkTrue((boolean)this.isAllowedToReopenStage(stage), (String)"Stages cannot be reopened if their subsequent stages are closed", (Object[])new Object[0]);
            if (!stage.isClosed()) break block0;
            stage.setStatus(StageStatus.OPEN);
            this.events().$plus$eq((Object)new StageReopenedEvent(stage, this.delivery()));
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                DeliveryStateManager.$anonfun$reopenStage$1(x$10);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void descopeItems(Seq<TrackedItem> items) {
        Map itemsNotYetDescoped = ((TraversableOnce)items.view().filterNot((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.isDescoped())).map((Function1 & Serializable & scala.Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.getId()), (Object)item), SeqView$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        itemsNotYetDescoped.valuesIterator().foreach((Function1 & Serializable & scala.Serializable)item -> {
            item.setDescoped(true);
            return this.events().$plus$eq((Object)new ItemDescopedEvent((TrackedItem)((Object)item), this.delivery()));
        });
    }

    public void rescopeItems(Seq<TrackedItem> items) {
        Map descopedItems = ((TraversableOnce)items.view().filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isDescoped())).map((Function1 & Serializable & scala.Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.getId()), (Object)item), SeqView$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        descopedItems.valuesIterator().foreach((Function1 & Serializable & scala.Serializable)item -> {
            item.setDescoped(false);
            return this.events().$plus$eq((Object)new ItemRescopedEvent((TrackedItem)((Object)item), this.delivery()));
        });
    }

    public Delivery skipTrackedItemInStage(TrackedItem item, Stage stage) {
        DeliveryStatus deliveryStatus = this.delivery().getStatus();
        DeliveryStatus deliveryStatus2 = DeliveryStatus.IN_PROGRESS;
        Checks.checkTrue((!(deliveryStatus != null ? !((Object)((Object)deliveryStatus)).equals((Object)deliveryStatus2) : deliveryStatus2 != null) ? 1 : 0) != 0, (String)"Only in-progress release deliveries may skip items", (Object[])new Object[0]);
        Checks.checkTrue((boolean)stage.isOpen(), (String)"Items can only be skipped in OPEN stages", (Object[])new Object[0]);
        Checks.checkTrue((!item.isDescoped() ? 1 : 0) != 0, (String)"Cannot skip a descoped item", (Object[])new Object[0]);
        StageTrackedItem stageItem = stage.getItemById(item.getId());
        TrackedItemStatus trackedItemStatus = stageItem.getStatus();
        TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.NOT_READY;
        Checks.checkTrue((!(trackedItemStatus != null ? !((Object)((Object)trackedItemStatus)).equals((Object)trackedItemStatus2) : trackedItemStatus2 != null) ? 1 : 0) != 0, (String)"Only NOT_READY items can be skipped", (Object[])new Object[0]);
        this.forceSkipTrackedItemInStageIfNotReady(item, stage, stageItem);
        return this.delivery();
    }

    public void startStageGroup(Seq<Stage> stages, Seq<TrackedItem> items) {
        stages.foreach((Function1 & Serializable & scala.Serializable)stage -> {
            DeliveryStateManager.$anonfun$startStageGroup$1(this, items, stage);
            return BoxedUnit.UNIT;
        });
    }

    public void handleTransition(Transition transition, TransitionParams params) {
        TransitionEvaluator$.MODULE$.evaluate(params).foreach((Function1 & Serializable & scala.Serializable)result -> {
            this.handleTransition(transition, params, result);
            return BoxedUnit.UNIT;
        });
    }

    private void handleTransition(Transition transition, TransitionParams params, TransitionResult transitionResult) {
        this.events().$plus$eq((Object)new TransitionExecutedEvent(transition, this.delivery(), params));
        Stage stage2 = this.delivery().getStageByTransition(transition);
        transitionResult.toTransition().toList().foreach((Function1 & Serializable & scala.Serializable)item -> this.events().$plus$eq((Object)new ItemTransitionApprovedEvent((TrackedItem)((Object)item), stage2.findItemById(item.getId()).get(), transition, stage2, this.delivery())));
        if (transitionResult.closeStages()) {
            Buffer stagesToClose = (Buffer)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getStagesBefore(params.transitionStage())).asScala()).filter((Function1 & Serializable & scala.Serializable)stage -> BoxesRunTime.boxToBoolean((boolean)stage.isOpen()))).$colon$plus((Object)params.transitionStage(), Buffer$.MODULE$.canBuildFrom());
            this.forceCloseStagesIfNotClosed((Seq<Stage>)stagesToClose, (Seq<TrackedItem>)transitionResult.toDescope().toList());
        }
        Buffer nextStageGroup = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getStageGroupAfterTransition(transition)).asScala();
        this.startStageGroup((Seq<Stage>)nextStageGroup, (Seq<TrackedItem>)transitionResult.toTransition().toList());
    }

    private void forceCloseStagesIfNotClosed(Seq<Stage> stages, Seq<TrackedItem> itemsToDescope) {
        stages.foreach((Function1 & Serializable & scala.Serializable)stage -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            itemsToDescope.foreach((Function1 & Serializable & scala.Serializable)item -> {
                DeliveryStateManager.$anonfun$forceCloseStagesIfNotClosed$2(this, stage, item);
                return BoxedUnit.UNIT;
            });
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
                x$17.setAutomated(false);
                return BoxedUnit.UNIT;
            });
            if (stage.isOpen()) {
                stage.setStatus(StageStatus.CLOSED);
                boxedUnit2 = this.events().$plus$eq((Object)new StageCompletedEvent((Stage)((Object)stage), this.delivery()));
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (this.delivery().isLastStage((Stage)((Object)stage))) {
                this.delivery().setStatus(DeliveryStatus.COMPLETED);
                boxedUnit = this.events().$plus$eq((Object)new DeliveryCompletedEvent(this.delivery()));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        this.descopeItems(itemsToDescope);
    }

    private Seq<TrackedItem> forceCloseStagesIfNotClosed$default$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private void forceSkipTrackedItemInStageIfNotReady(TrackedItem item, Stage stage, StageTrackedItem stageTrackedItem) {
        block0: {
            TrackedItemStatus trackedItemStatus = stageTrackedItem.getStatus();
            TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.NOT_READY;
            if (trackedItemStatus != null ? !((Object)((Object)trackedItemStatus)).equals((Object)trackedItemStatus2) : trackedItemStatus2 != null) break block0;
            stageTrackedItem.setStatus(TrackedItemStatus.SKIPPED);
            this.events().$plus$eq((Object)new ItemSkippedEvent(item, stage, this.delivery()));
        }
    }

    private boolean hasStages() {
        return this.delivery().getStages() != null && !this.delivery().getStages().isEmpty();
    }

    private boolean isAllowedToCloseStage(Stage stage) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.delivery().findPreviousStage(stage))).forall((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$isAllowedToCloseStage$1(x$18)));
    }

    private boolean isAllowedToReopenStage(Stage stage) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.delivery().findNextStage(stage))).forall((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$isAllowedToReopenStage$1(x$19)));
    }

    private void checkDeliveryIsActive() {
        Checks.checkTrue((!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DeliveryStatus.INACTIVE_STATUSES)).contains((Object)this.delivery().getStatus()) ? 1 : 0) != 0, (String)"Can't modify ABORTED or COMPLETED release delivery", (Object[])new Object[0]);
    }

    private SubscriptionResult addSubscriber(Subscriber subscriber) {
        Subscriber subscriber2;
        SubscriptionStatus subscriptionStatus;
        subscriber.validate(this.delivery());
        SubscriptionResult result = subscriber.evaluate(this.delivery());
        int subscriberIndex = ((GenSeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getSubscribers()).asScala()).indexWhere((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)x$20.isEqual(subscriber)));
        SubscriptionResult subscriptionResult = result;
        if (subscriptionResult != null && ((Object)((Object)SubscriptionStatus.COMPLETED)).equals((Object)(subscriptionStatus = subscriptionResult.status())) && subscriberIndex != -1) {
            subscriber2 = this.delivery().getSubscribers().remove(subscriberIndex);
        } else {
            SubscriptionStatus subscriptionStatus2;
            SubscriptionStatus subscriptionStatus3;
            boolean bl = subscriptionResult != null && ((Object)((Object)SubscriptionStatus.FAILED)).equals((Object)(subscriptionStatus3 = subscriptionResult.status())) ? true : subscriptionResult != null && ((Object)((Object)SubscriptionStatus.IN_PROGRESS)).equals((Object)(subscriptionStatus2 = subscriptionResult.status()));
            if (bl && subscriberIndex != -1) {
                subscriber2 = this.delivery().getSubscribers().set(subscriberIndex, subscriber);
            } else {
                SubscriptionStatus subscriptionStatus4;
                SubscriptionStatus subscriptionStatus5;
                boolean bl2 = subscriptionResult != null && ((Object)((Object)SubscriptionStatus.FAILED)).equals((Object)(subscriptionStatus5 = subscriptionResult.status())) ? true : subscriptionResult != null && ((Object)((Object)SubscriptionStatus.IN_PROGRESS)).equals((Object)(subscriptionStatus4 = subscriptionResult.status()));
                if (bl2) {
                    this.delivery().addSubscriber(subscriber);
                    subscriber2 = BoxedUnit.UNIT;
                } else {
                    subscriber2 = BoxedUnit.UNIT;
                }
            }
        }
        return result;
    }

    public static final /* synthetic */ String $anonfun$markTrackedItemsInStage$2(TrackedItem x$3) {
        return x$3.getTitle();
    }

    public static final /* synthetic */ boolean $anonfun$markTrackedItemsInStage$5(Stage stage$1, TrackedItem item) {
        return stage$1.findItemById(item.getId()).isPresent();
    }

    public static final /* synthetic */ Seq $anonfun$markTrackedItemsInStage$4(DeliveryStateManager $this, Seq items$1, TrackedItemStatus status$1, String fromReleaseId$1, Stage stage) {
        Seq itemsInStage = (Seq)items$1.filter((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$markTrackedItemsInStage$5(stage, item)));
        return $this.markTrackedItemsInStage((Seq<TrackedItem>)itemsInStage, stage, status$1, false, fromReleaseId$1);
    }

    public static final /* synthetic */ String $anonfun$markTrackedItemsInStage$7(StageTrackedItem x$5) {
        return x$5.getTrackedItemId();
    }

    public static final /* synthetic */ String $anonfun$markTrackedItemsInStage$9(TrackedItem x$7) {
        return x$7.getId();
    }

    public static final /* synthetic */ boolean $anonfun$completeStage$1(StageTrackedItem x$9) {
        TrackedItemStatus trackedItemStatus = x$9.getStatus();
        TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.NOT_READY;
        return !(trackedItemStatus != null ? !((Object)((Object)trackedItemStatus)).equals((Object)trackedItemStatus2) : trackedItemStatus2 != null);
    }

    public static final /* synthetic */ void $anonfun$reopenStage$1(Transition x$10) {
        x$10.getAllConditions().forEach(x$11 -> x$11.reset());
    }

    public static final /* synthetic */ void $anonfun$startStageGroup$1(DeliveryStateManager $this, Seq items$2, Stage stage) {
        block0: {
            Set existingItems = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stage.getItems()).asScala()).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.getTrackedItemId(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Seq newItems = (Seq)items$2.filterNot((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)existingItems.apply((Object)item.getId())));
            java.util.List stageItems = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)newItems.map((Function1 & Serializable & scala.Serializable)item -> $this.factory.createStageTrackedItem(stage.getId(), item.getId()), Seq$.MODULE$.canBuildFrom())).asJava();
            stage.addTrackedItems(stageItems);
            Object object = existingItems.isEmpty() ? $this.events().$plus$eq((Object)new StageStartedEvent(stage, $this.delivery())) : BoxedUnit.UNIT;
            newItems.foreach((Function1 & Serializable & scala.Serializable)x$15 -> $this.events().$plus$eq((Object)new ItemAvailableEvent((TrackedItem)((Object)x$15), stage, $this.delivery())));
            if (!stage.isClosed()) break block0;
            stageItems.forEach(stageItem -> stageItem.setStatus(TrackedItemStatus.SKIPPED));
            newItems.foreach((Function1 & Serializable & scala.Serializable)x$16 -> $this.events().$plus$eq((Object)new ItemSkippedEvent((TrackedItem)((Object)x$16), stage, $this.delivery())));
        }
    }

    public static final /* synthetic */ void $anonfun$forceCloseStagesIfNotClosed$2(DeliveryStateManager $this, Stage stage$5, TrackedItem item) {
        stage$5.findItemById(item.getId()).ifPresent(stageItem -> $this.forceSkipTrackedItemInStageIfNotReady(item, stage$5, (StageTrackedItem)((Object)stageItem)));
    }

    public static final /* synthetic */ boolean $anonfun$isAllowedToCloseStage$1(Stage x$18) {
        StageStatus stageStatus = x$18.getStatus();
        StageStatus stageStatus2 = StageStatus.CLOSED;
        return !(stageStatus != null ? !((Object)((Object)stageStatus)).equals((Object)stageStatus2) : stageStatus2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isAllowedToReopenStage$1(Stage x$19) {
        StageStatus stageStatus = x$19.getStatus();
        StageStatus stageStatus2 = StageStatus.CLOSED;
        return stageStatus == null ? stageStatus2 != null : !((Object)((Object)stageStatus)).equals((Object)stageStatus2);
    }

    public DeliveryStateManager(Delivery delivery, DeliveryObjectFactory factory) {
        this.delivery = delivery;
        this.factory = factory;
        this.events = (Buffer)Buffer$.MODULE$.empty();
        this.messages = (Buffer)Buffer$.MODULE$.empty();
    }

    public static final /* synthetic */ Object $anonfun$markTrackedItemsInStage$1$adapted(TrackedItem x$2) {
        return BoxesRunTime.boxToBoolean((boolean)x$2.isDescoped());
    }

    public static final /* synthetic */ Object $anonfun$markTrackedItemsInStage$3$adapted(Stage x$4) {
        return BoxesRunTime.boxToBoolean((boolean)x$4.isClosed());
    }

    public static final /* synthetic */ Object $anonfun$markTrackedItemsInStage$6$adapted(Seq doneStatuses$1, StageTrackedItem stageItem) {
        return BoxesRunTime.boxToBoolean((boolean)doneStatuses$1.contains((Object)stageItem.getStatus()));
    }

    public static final /* synthetic */ Object $anonfun$markTrackedItemsInStage$8$adapted(Set doneItems$1, TrackedItem item) {
        return BoxesRunTime.boxToBoolean((boolean)doneItems$1.contains((Object)item.getId()));
    }

    public static final /* synthetic */ Object $anonfun$markTrackedItemsInStage$10$adapted(DeliveryStateManager $this, Stage stage$2, TrackedItemStatus status$1, String fromReleaseId$1, TrackedItem x$8) {
        $this.markTrackedItemInStage(x$8, stage$2, status$1, fromReleaseId$1);
        return BoxedUnit.UNIT;
    }
}

