/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.templates;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext$;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseRestoredEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.DependencyTargetResolver;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.versioning.templates.ReleaseVersioningSerialization;
import com.xebialabs.xlrelease.versioning.templates.TemplateStorageService;
import com.xebialabs.xlrelease.versioning.templates.domain.events.RevisionDeletedEvent;
import com.xebialabs.xlrelease.versioning.templates.domain.events.VersionCreatedEvent;
import com.xebialabs.xlrelease.versioning.templates.repository.TemplateRevisionDataRepository;
import com.xebialabs.xlrelease.versioning.templates.repository.TemplateRevisionRepository;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevision;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevisionData;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevisionType$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@Service
@Primary
@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\teb\u0001B\f\u0019\u0001\rB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!a\u0005A!A!\u0002\u0013i\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u0011Y\u0003!\u0011!Q\u0001\n]C\u0001B\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\tG\u0002\u0011\t\u0011)A\u0005I\"A!\u000e\u0001B\u0001B\u0003%1\u000eC\u0003o\u0001\u0011\u0005q\u000eC\u0004\u0002\u0016\u0001!\t%a\u0006\t\u000f\u00055\u0003\u0001\"\u0011\u0002P!9\u0011q\u000e\u0001\u0005\n\u0005E\u0004\"CAH\u0001E\u0005I\u0011BAI\u0011\u001d\t)\u000b\u0001C!\u0003OCq!a,\u0001\t\u0003\n\t\fC\u0004\u0002N\u0002!\t%a4\t\u000f\u0005U\u0007\u0001\"\u0011\u0002X\"9\u0011\u0011\u001f\u0001\u0005\n\u0005M\bbBA\u007f\u0001\u0011%\u0011q \u0005\b\u0005\u0007\u0001A\u0011\u0002B\u0003\u0005a!%\rV3na2\fG/Z*u_J\fw-Z*feZL7-\u001a\u0006\u00033i\t\u0011\u0002^3na2\fG/Z:\u000b\u0005ma\u0012A\u0003<feNLwN\\5oO*\u0011QDH\u0001\nq2\u0014X\r\\3bg\u0016T!a\b\u0011\u0002\u0013a,'-[1mC\n\u001c(\"A\u0011\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001!#F\f\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-bS\"\u0001\r\n\u00055B\"A\u0006+f[Bd\u0017\r^3Ti>\u0014\u0018mZ3TKJ4\u0018nY3\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014!B:mMRR'\"A\u001a\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u000e\u0019\u0003\u000f1{wmZ5oO\u0006QB/Z7qY\u0006$XMU3wSNLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0011\u0001hO\u0007\u0002s)\u0011!\bG\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001\u001f:\u0005i!V-\u001c9mCR,'+\u001a<jg&|gNU3q_NLGo\u001c:z\u0003y!X-\u001c9mCR,'+\u001a<jg&|g\u000eR1uCJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00029\u007f%\u0011\u0001)\u000f\u0002\u001f)\u0016l\u0007\u000f\\1uKJ+g/[:j_:$\u0015\r^1SKB|7/\u001b;pef\faD]3mK\u0006\u001cXMV3sg&|g.\u001b8h'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u0011\u0005-\u001a\u0015B\u0001#\u0019\u0005y\u0011V\r\\3bg\u00164VM]:j_:LgnZ*fe&\fG.\u001b>bi&|g.\u0001\bsK2,\u0017m]3TKJ4\u0018nY3\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%c\u0012aB:feZL7-Z\u0005\u0003\u0017\"\u0013aBU3mK\u0006\u001cXmU3sm&\u001cW-A\tsK2,\u0017m]3SKB|7/\u001b;pef\u0004\"A\u0014)\u000e\u0003=S!A\u000f\u000f\n\u0005E{%!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0006YA/Y:l'\u0016\u0014h/[2f!\t9E+\u0003\u0002V\u0011\nYA+Y:l'\u0016\u0014h/[2f\u0003-!X-Y7TKJ4\u0018nY3\u0011\u0005\u001dC\u0016BA-I\u0005-!V-Y7TKJ4\u0018nY3\u00021I,\u0007o\\:ji>\u0014\u0018PV3sg&|gnU3sm&\u001cW\r\u0005\u0002]C6\tQL\u0003\u0002_?\u00069Q\u000f]4sC\u0012,'B\u00011\u001f\u0003)AH\u000e\u001d7bi\u001a|'/\\\u0005\u0003Ev\u0013\u0001DU3q_NLGo\u001c:z-\u0016\u00148/[8o'\u0016\u0014h/[2f\u0003!)g/\u001a8u\u0005V\u001c\bCA3i\u001b\u00051'BA4\u001d\u0003\u0019)g/\u001a8ug&\u0011\u0011N\u001a\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018\u0001\u00073fa\u0016tG-\u001a8dsR\u000b'oZ3u%\u0016\u001cx\u000e\u001c<feB\u0011a\n\\\u0005\u0003[>\u0013\u0001\u0004R3qK:$WM\\2z)\u0006\u0014x-\u001a;SKN|GN^3s\u0003\u0019a\u0014N\\5u}QY\u0001/\u001d:tiV4x\u000f_={!\tY\u0003\u0001C\u00037\u0017\u0001\u0007q\u0007C\u0003>\u0017\u0001\u0007a\bC\u0003B\u0017\u0001\u0007!\tC\u0003F\u0017\u0001\u0007a\tC\u0003M\u0017\u0001\u0007Q\nC\u0003S\u0017\u0001\u00071\u000bC\u0003W\u0017\u0001\u0007q\u000bC\u0003[\u0017\u0001\u00071\fC\u0003d\u0017\u0001\u0007A\rC\u0003k\u0017\u0001\u00071\u000e\u000b\u0002\fyB\u0019Q0!\u0005\u000e\u0003yT1a`A\u0001\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003\u0007\t)!A\u0004gC\u000e$xN]=\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0006E\u0016\fgn\u001d\u0006\u0005\u0003\u0017\ti!A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\ty!A\u0002pe\u001eL1!a\u0005\u007f\u0005%\tU\u000f^8xSJ,G-\u0001\u0007tCZ,'+\u001a<jg&|g\u000e\u0006\u0005\u0002\u001a\u0005}\u0011qFA%!\r)\u00131D\u0005\u0004\u0003;1#\u0001B+oSRDq!!\t\r\u0001\u0004\t\u0019#\u0001\u0005uK6\u0004H.\u0019;f!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"bAA\u00159\u00051Am\\7bS:LA!!\f\u0002(\t9!+\u001a7fCN,\u0007bBA\u0019\u0019\u0001\u0007\u00111G\u0001\u0005kN,'\u000f\u0005\u0003\u00026\u0005\rc\u0002BA\u001c\u0003\u007f\u00012!!\u000f'\u001b\t\tYDC\u0002\u0002>\t\na\u0001\u0010:p_Rt\u0014bAA!M\u00051\u0001K]3eK\u001aLA!!\u0012\u0002H\t11\u000b\u001e:j]\u001eT1!!\u0011'\u0011\u001d\tY\u0005\u0004a\u0001\u0003g\tq!\\3tg\u0006<W-A\u0006tCZ,g+\u001a:tS>tGCCA)\u0003G\n9'!\u001b\u0002nA1\u00111KA-\u0003;j!!!\u0016\u000b\u0007\u0005]c%\u0001\u0003vi&d\u0017\u0002BA.\u0003+\u00121\u0001\u0016:z!\r)\u0013qL\u0005\u0004\u0003C2#aA%oi\"9\u0011QM\u0007A\u0002\u0005M\u0012A\u0003;f[Bd\u0017\r^3JI\"9\u0011\u0011G\u0007A\u0002\u0005M\u0002bBA6\u001b\u0001\u0007\u00111G\u0001\fm\u0016\u00148/[8o\u001d\u0006lW\rC\u0004\u0002L5\u0001\r!a\r\u0002\u001d\r\u0014X-\u0019;f%\u00164\u0018n]5p]RQ\u00111OAB\u0003\u000b\u000b9)a#\u0011\t\u0005U\u0014qP\u0007\u0003\u0003oRA!!\u001f\u0002|\u0005!A-\u0019;b\u0015\r\ti(O\u0001\fa\u0016\u00148/[:uK:\u001cW-\u0003\u0003\u0002\u0002\u0006]$\u0001\u0005+f[Bd\u0017\r^3SKZL7/[8o\u0011\u001d\t\tC\u0004a\u0001\u0003GAq!!\r\u000f\u0001\u0004\t\u0019\u0004C\u0004\u0002\n:\u0001\r!a\r\u0002\u0017\u0011,7o\u0019:jaRLwN\u001c\u0005\n\u0003\u001bs\u0001\u0013!a\u0001\u0003g\tqA^3sg&|g.\u0001\rde\u0016\fG/\u001a*fm&\u001c\u0018n\u001c8%I\u00164\u0017-\u001e7uIQ*\"!a%+\t\u0005M\u0012QS\u0016\u0003\u0003/\u0003B!!'\u0002\"6\u0011\u00111\u0014\u0006\u0005\u0003;\u000by*A\u0005v]\u000eDWmY6fI*\u0011qPJ\u0005\u0005\u0003G\u000bYJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqA]3ti>\u0014X\r\u0006\u0004\u0002$\u0005%\u00161\u0016\u0005\b\u0003K\u0002\u0002\u0019AA\u001a\u0011\u001d\ti\u000b\u0005a\u0001\u0003;\n!B]3wSNLwN\\%e\u0003\u0011aw.\u00193\u0015\r\u0005\r\u00121WA[\u0011\u001d\ti+\u0005a\u0001\u0003;Bq!a.\u0012\u0001\u0004\tI,A\u0004d_:$X\r\u001f;\u0011\t\u0005m\u0016\u0011Z\u0007\u0003\u0003{SA!a0\u0002B\u0006i1/\u001a:jC2L'0\u0019;j_:TA!a1\u0002F\u0006A\u0001\u000f\\;nE&twMC\u0002\u0002Hz\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u0003\u0017\fiLA\tSKN|G.\u001e;j_:\u001cuN\u001c;fqR\fa\u0002Z3mKR,'+\u001a<jg&|g\u000e\u0006\u0004\u0002\u001a\u0005E\u00171\u001b\u0005\b\u0003K\u0012\u0002\u0019AA\u001a\u0011\u001d\tiK\u0005a\u0001\u0003;\nq\u0002Z3mKR,'+\u001a<jg&|gn\u001d\u000b\u0007\u00033\tI.a7\t\u000f\u0005\u00154\u00031\u0001\u00024!9\u0011Q\\\nA\u0002\u0005}\u0017a\u0003:fm&\u001c\u0018n\u001c8JIN\u0004b!!9\u0002l\u0006uc\u0002BAr\u0003OtA!!\u000f\u0002f&\tq%C\u0002\u0002j\u001a\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002n\u0006=(aA*fc*\u0019\u0011\u0011\u001e\u0014\u0002/A\u0014xnY3tgJ+7\u000f^8sK\u0012$V-\u001c9mCR,GCBA\r\u0003k\fI\u0010C\u0004\u0002xR\u0001\r!a\t\u0002!I,7\u000f^8sK\u0012$V-\u001c9mCR,\u0007bBA~)\u0001\u0007\u00111E\u0001\u0010GV\u0014(/\u001a8u)\u0016l\u0007\u000f\\1uK\u0006\u0019\u0002O]8dKN\u001cH)\u001a9f]\u0012,gnY5fgR!\u00111\u0005B\u0001\u0011\u001d\t90\u0006a\u0001\u0003G\t!\u0002\u001f7s-\u0016\u00148/[8o+\t\t\u0019\u0004K\u0002\u0001\u0005\u0013\u0001BAa\u0003\u0003\u001a5\u0011!Q\u0002\u0006\u0005\u0005\u001f\u0011\t\"A\u0006ue\u0006t7/Y2uS>t'\u0002\u0002B\n\u0005+\t1a]9m\u0015\r\u00119\u0002H\u0001\u0003I\nLAAa\u0007\u0003\u000e\ty\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000eK\u0002\u0001\u0005?\u0001BA!\t\u0003(5\u0011!1\u0005\u0006\u0004\u007f\n\u0015\"\u0002BA\\\u0003\u0013IAA!\u000b\u0003$\t9\u0001K]5nCJL\bf\u0001\u0001\u0003.A!!q\u0006B\u001b\u001b\t\u0011\tD\u0003\u0003\u00034\u0005%\u0011AC:uKJ,w\u000e^=qK&!!q\u0007B\u0019\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class DbTemplateStorageService
implements TemplateStorageService,
Logging {
    private final TemplateRevisionRepository templateRevisionRepository;
    private final TemplateRevisionDataRepository templateRevisionDataRepository;
    private final ReleaseVersioningSerialization releaseVersioningSerialization;
    private final ReleaseService releaseService;
    private final ReleaseRepository releaseRepository;
    private final RepositoryVersionService repositoryVersionService;
    private final XLReleaseEventBus eventBus;
    private final DependencyTargetResolver dependencyTargetResolver;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DbTemplateStorageService dbTemplateStorageService = this;
        synchronized (dbTemplateStorageService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public void saveRevision(Release template, String user, String message) {
        this.createRevision(template, user, message, this.createRevision$default$4());
    }

    @Override
    public Try<Object> saveVersion(String templateId, String user, String versionName, String message) {
        Release template = this.releaseService.findById(templateId);
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            TemplateRevision version = this.createRevision(template, user, message, versionName);
            $this.templateRevisionRepository.deleteRevisionsForVersion(version);
            $this.eventBus.publish((XLReleaseEvent)new VersionCreatedEvent(templateId, versionName));
            return version.id();
        }).recoverWith((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DbTemplateStorageService $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.logger().error((Function0 & Serializable & scala.Serializable)() -> "Unable to create new template version", (Function0 & Serializable & scala.Serializable)() -> exception);
                    object = new Failure((Throwable)exception);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2(java.lang.Exception )}, serializedLambda);
            }
        });
    }

    private TemplateRevision createRevision(Release template, String user, String description, String version) {
        TemplateRevision templateRevision = new TemplateRevision();
        templateRevision.ciUid_$eq(Predef$.MODULE$.Integer2int(template.getCiUid()));
        templateRevision.revisionType_$eq(version != null ? TemplateRevisionType$.MODULE$.VERSION() : TemplateRevisionType$.MODULE$.REVISION());
        templateRevision.version_$eq(version);
        templateRevision.description_$eq(description);
        templateRevision.username_$eq(user);
        templateRevision.revisionTime_$eq(new Date());
        TemplateRevision savedTr = this.templateRevisionRepository.create(templateRevision);
        TemplateRevisionData trd = new TemplateRevisionData(savedTr.id(), this.xlrVersion(), this.releaseVersioningSerialization.toBytes(template));
        this.templateRevisionDataRepository.create(trd);
        return savedTr;
    }

    private String createRevision$default$4() {
        return null;
    }

    @Override
    public Release restore(String templateId, int revisionId) {
        Release currentTemplate = this.releaseService.findById(templateId);
        ResolutionContext context = Ids.isInFolder((String)templateId) ? ResolutionContext$.MODULE$.apply(Ids.getParentId((String)templateId)) : ResolutionContext$.MODULE$.GLOBAL();
        Release previousTemplate = this.load(revisionId, context);
        this.processRestoredTemplate(previousTemplate, currentTemplate);
        Release updatedTemplate = this.releaseRepository.replace(currentTemplate, previousTemplate);
        this.eventBus.publish((XLReleaseEvent)new ReleaseRestoredEvent(currentTemplate, updatedTemplate, revisionId));
        return this.releaseService.findById(templateId);
    }

    @Override
    public Release load(int revisionId, ResolutionContext context) {
        Release release;
        Option<TemplateRevisionData> option = this.templateRevisionDataRepository.findById(revisionId);
        if (option instanceof Some) {
            Some some = (Some)option;
            TemplateRevisionData trd = (TemplateRevisionData)some.value();
            Option<Release> option2 = this.releaseVersioningSerialization.fromBytes(trd.content(), trd.dataModelVersion(), context);
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    throw new LogFriendlyNotFoundException(new StringBuilder(41).append("Error reading ").append(revisionId).append(", see logs for more details").toString(), new Object[0]);
                }
                throw new MatchError(option2);
            }
            Some some2 = (Some)option2;
            Release template = (Release)some2.value();
            release = this.processDependencies(template);
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new LogFriendlyNotFoundException(new StringBuilder(22).append("Revision id ").append(revisionId).append(" not found").toString(), new Object[0]);
            }
            throw new MatchError(option);
        }
        Release release2 = release;
        return release2;
    }

    @Override
    public void deleteRevision(String templateId, int revisionId) {
        this.releaseRepository.getUid(templateId).foreach((Function1 & Serializable & scala.Serializable)templateCiUid -> {
            DbTemplateStorageService.$anonfun$deleteRevision$1(this, revisionId, templateId, templateCiUid);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void deleteRevisions(String templateId, Seq<Object> revisionIds) {
        this.releaseRepository.getUid(templateId).foreach((Function1 & Serializable & scala.Serializable)templateCiUid -> {
            DbTemplateStorageService.$anonfun$deleteRevisions$1(this, revisionIds, templateId, templateCiUid);
            return BoxedUnit.UNIT;
        });
    }

    private void processRestoredTemplate(Release restoredTemplate, Release currentTemplate) {
        restoredTemplate.setCiUid(currentTemplate.getCiUid());
        CiHelper.rewriteWithNewId((ConfigurationItem)restoredTemplate, (String)currentTemplate.getId());
        restoredTemplate.setRunningTriggeredReleasesCount(currentTemplate.getRunningTriggeredReleasesCount());
        restoredTemplate.setReleaseTriggers(new ArrayList());
        this.processDependencies(restoredTemplate);
        restoredTemplate.get$ciAttributes().setScmTraceabilityDataId(null);
    }

    private Release processDependencies(Release restoredTemplate) {
        restoredTemplate.getAllGates().forEach(gateTask -> {
            List validDependencies = gateTask.getDependencies().stream().filter(d -> d.hasResolvedTarget() || Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.dependencyTargetResolver.resolveTarget(d)).isSuccess()).collect(Collectors.toList());
            gateTask.setDependencies(validDependencies);
        });
        return restoredTemplate;
    }

    private String xlrVersion() {
        Version version = this.repositoryVersionService.readVersionOfComponent("xl-release");
        return version == null ? "0.0.0" : version.getVersion();
    }

    public static final /* synthetic */ void $anonfun$deleteRevision$1(DbTemplateStorageService $this, int revisionId$1, String templateId$2, Integer templateCiUid) {
        $this.templateRevisionRepository.deleteRevisions(templateCiUid, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{revisionId$1}))));
        $this.eventBus.publish((XLReleaseEvent)new RevisionDeletedEvent(templateId$2, revisionId$1));
    }

    public static final /* synthetic */ void $anonfun$deleteRevisions$1(DbTemplateStorageService $this, Seq revisionIds$1, String templateId$3, Integer templateCiUid) {
        $this.templateRevisionRepository.deleteRevisions(templateCiUid, (Seq<Object>)revisionIds$1);
        revisionIds$1.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> $this.eventBus.publish((XLReleaseEvent)new RevisionDeletedEvent(templateId$3, id)));
    }

    @Autowired
    public DbTemplateStorageService(TemplateRevisionRepository templateRevisionRepository, TemplateRevisionDataRepository templateRevisionDataRepository, ReleaseVersioningSerialization releaseVersioningSerialization, ReleaseService releaseService, ReleaseRepository releaseRepository, TaskService taskService, TeamService teamService, RepositoryVersionService repositoryVersionService, XLReleaseEventBus eventBus, DependencyTargetResolver dependencyTargetResolver) {
        this.templateRevisionRepository = templateRevisionRepository;
        this.templateRevisionDataRepository = templateRevisionDataRepository;
        this.releaseVersioningSerialization = releaseVersioningSerialization;
        this.releaseService = releaseService;
        this.releaseRepository = releaseRepository;
        this.repositoryVersionService = repositoryVersionService;
        this.eventBus = eventBus;
        this.dependencyTargetResolver = dependencyTargetResolver;
        Logging.$init$((Logging)this);
    }
}

