/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.audit;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.xlplatform.io.ZipUtils$;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.utils.ReleaseIdInDatabase;
import com.xebialabs.xlrelease.planner.PlannerReleaseItem;
import com.xebialabs.xlrelease.reports.audit.MultiReleaseAuditReport;
import com.xebialabs.xlrelease.reports.audit.MultiReleaseAuditReportComponent$;
import com.xebialabs.xlrelease.reports.audit.ReportFilterMapper;
import com.xebialabs.xlrelease.reports.audit.package;
import com.xebialabs.xlrelease.reports.audit.package$;
import com.xebialabs.xlrelease.reports.domain.MaybeData$;
import com.xebialabs.xlrelease.reports.domain.MaybeData$Implicits$;
import com.xebialabs.xlrelease.reports.domain.MaybeData$Implicits$EitherOps$;
import com.xebialabs.xlrelease.reports.excel.AuditReport;
import com.xebialabs.xlrelease.reports.excel.AuditReport$;
import com.xebialabs.xlrelease.reports.excel.ExcelSheetWriter;
import com.xebialabs.xlrelease.reports.excel.MultiReleaseAuditReport;
import com.xebialabs.xlrelease.reports.excel.MultiReleaseAuditReport$;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.reports.job.api.ReportJobProgressMonitor;
import com.xebialabs.xlrelease.reports.job.api.ReportJobRunContext;
import com.xebialabs.xlrelease.reports.service.ReportsService;
import com.xebialabs.xlrelease.search.ReleaseCountResults;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.udm.reporting.AuditReportRequest;
import com.xebialabs.xlrelease.views.converters.ReleaseViewConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.joda.time.Duration;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Success;
import scala.util.Try;

@Service
@ScalaSignature(bytes="\u0006\u0001\r}t!B\"E\u0011\u0003ye!B)E\u0011\u0003\u0011\u0006\"B-\u0002\t\u0003Q\u0006bB.\u0002\u0005\u0004%\t\u0001\u0018\u0005\u0007K\u0006\u0001\u000b\u0011B/\t\u000f\u0019\f!\u0019!C\u00019\"1q-\u0001Q\u0001\nuCq\u0001[\u0001C\u0002\u0013\u0005A\f\u0003\u0004j\u0003\u0001\u0006I!\u0018\u0005\bU\u0006\u0011\r\u0011\"\u0001]\u0011\u0019Y\u0017\u0001)A\u0005;\"9A.\u0001b\u0001\n\u0003a\u0006BB7\u0002A\u0003%Q\fC\u0004o\u0003\t\u0007I\u0011\u0001/\t\r=\f\u0001\u0015!\u0003^\u0011\u001d\u0001\u0018A1A\u0005\u0002qCa!]\u0001!\u0002\u0013i\u0006b\u0002:\u0002\u0005\u0004%\ta\u001d\u0005\u0007u\u0006\u0001\u000b\u0011\u0002;\t\u000fm\f!\u0019!C\u0001y\"9\u0011\u0011A\u0001!\u0002\u0013i\b\u0002CA\u0002\u0003\t\u0007I\u0011\u0001?\t\u000f\u0005\u0015\u0011\u0001)A\u0005{\"I\u0011qA\u0001C\u0002\u0013\u0005\u0011\u0011\u0002\u0005\t\u0003?\t\u0001\u0015!\u0003\u0002\f!9\u0011\u0011E\u0001\u0005\u0002\u0005\rbABA\u001f\u0003\u0001\u000by\u0004\u0003\u0006\u0002Ni\u0011)\u001a!C\u0001\u0003\u001fB!\"!\u0015\u001b\u0005#\u0005\u000b\u0011BA\u0013\u0011)\t\u0019F\u0007BK\u0002\u0013\u0005\u0011Q\u000b\u0005\u000b\u0003GR\"\u0011#Q\u0001\n\u0005]\u0003BCA35\tU\r\u0011\"\u0001\u0002h!Q\u0011q\u0011\u000e\u0003\u0012\u0003\u0006I!!\u001b\t\reSB\u0011AAE\u0011%\t)JGA\u0001\n\u0003\t9\nC\u0005\u0002 j\t\n\u0011\"\u0001\u0002\"\"I\u0011q\u0017\u000e\u0012\u0002\u0013\u0005\u0011\u0011\u0018\u0005\n\u0003{S\u0012\u0013!C\u0001\u0003\u007fC\u0001\"a1\u001b\u0003\u0003%\t\u0005\u0018\u0005\t\u0003\u000bT\u0012\u0011!C\u0001y\"I\u0011q\u0019\u000e\u0002\u0002\u0013\u0005\u0011\u0011\u001a\u0005\n\u0003+T\u0012\u0011!C!\u0003/D\u0011\"!:\u001b\u0003\u0003%\t!a:\t\u0013\u0005E($!A\u0005B\u0005M\b\"CA{5\u0005\u0005I\u0011IA|\u0011%\tIPGA\u0001\n\u0003\nYpB\u0005\u0002\u0000\u0006\t\t\u0011#\u0001\u0003\u0002\u0019I\u0011QH\u0001\u0002\u0002#\u0005!1\u0001\u0005\u00073>\"\tA!\u0005\t\u0013\u0005Ux&!A\u0005F\u0005]\b\"\u0003B\n_\u0005\u0005I\u0011\u0011B\u000b\u0011%\u0011ibLA\u0001\n\u0003\u0013y\u0002C\u0005\u00032=\n\t\u0011\"\u0003\u00034\u0019)\u0011\u000b\u0012\u0001\u0003<!Q!QJ\u001b\u0003\u0002\u0003\u0006IAa\u0014\t\u0015\tmSG!A!\u0002\u0013\u0011i\u0006\u0003\u0006\u0003hU\u0012\t\u0011)A\u0005\u0005SB!Ba\u001c6\u0005\u0003\u0005\u000b\u0011\u0002B9\u0011)\u0011i(\u000eB\u0001B\u0003%!q\u0010\u0005\u000b\u0005\u001f+$\u0011!Q\u0001\n\tE\u0005B\u0003BLk\t\u0005\t\u0015!\u0003\u0003\u001a\"1\u0011,\u000eC\u0001\u0005?CqA!46\t\u0003\u0011y\rC\u0004\u0003zV\"IAa?\t\u000f\r-S\u0007\"\u0003\u0004N!911L\u001b\u0005\u0002\ru\u0003bBB1k\u0011%11M\u0001!\u001bVdG/\u001b*fY\u0016\f7/Z!vI&$(+\u001a9peR\u001cu.\u001c9p]\u0016tGO\u0003\u0002F\r\u0006)\u0011-\u001e3ji*\u0011q\tS\u0001\be\u0016\u0004xN\u001d;t\u0015\tI%*A\u0005yYJ,G.Z1tK*\u00111\nT\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!T\u0001\u0004G>l7\u0001\u0001\t\u0003!\u0006i\u0011\u0001\u0012\u0002!\u001bVdG/\u001b*fY\u0016\f7/Z!vI&$(+\u001a9peR\u001cu.\u001c9p]\u0016tGo\u0005\u0002\u0002'B\u0011AkV\u0007\u0002+*\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A(\u0002\u001f\u0015C6)\u0012'`\u000bb#VIT*J\u001f:+\u0012!\u0018\t\u0003=\u000el\u0011a\u0018\u0006\u0003A\u0006\fA\u0001\\1oO*\t!-\u0001\u0003kCZ\f\u0017B\u00013`\u0005\u0019\u0019FO]5oO\u0006\u0001R\tW\"F\u0019~+\u0005\fV#O'&{e\nI\u0001\u0013\u000bb\u001bU\tT0D\u001f:#VI\u0014+`)f\u0003V)A\nF1\u000e+EjX\"P\u001dR+e\nV0U3B+\u0005%A\u0007[\u0013B{V\t\u0017+F\u001dNKuJT\u0001\u000f5&\u0003v,\u0012-U\u000b:\u001b\u0016j\u0014(!\u00031i\u0015i\u0015+F%~#\u0016\n\u0016'F\u00035i\u0015i\u0015+F%~#\u0016\n\u0016'FA\u00051R*Q*U\u000bJ{F+\u0013+M\u000b~\u001bV\tU!S\u0003R{%+A\fN\u0003N#VIU0U\u0013RcUiX*F!\u0006\u0013\u0016\tV(SA\u000512+\u0013(H\u0019\u0016{F+\u0013+M\u000b~\u001bV\tU!S\u0003R{%+A\fT\u0013:;E*R0U\u0013RcUiX*F!\u0006\u0013\u0016\tV(SA\u0005\u00112+\u0013(H\u0019\u0016{&+\u0012)P%R\u001bv\fR%S\u0003M\u0019\u0016JT$M\u000b~\u0013V\tU(S)N{F)\u0013*!\u0003I!\u0015\tV#U\u00136+uLR(S\u001b\u0006#F+\u0012*\u0016\u0003Q\u0004\"!\u001e=\u000e\u0003YT!a^1\u0002\tQ,\u0007\u0010^\u0005\u0003sZ\u0014\u0001cU5na2,G)\u0019;f\r>\u0014X.\u0019;\u0002'\u0011\u000bE+\u0012+J\u001b\u0016{fi\u0014*N\u0003R#VI\u0015\u0011\u0002'\u0019KE*\u0012(B\u001b\u0016{V*\u0011-`\u0019\u0016su\t\u0016%\u0016\u0003u\u0004\"\u0001\u0016@\n\u0005},&aA%oi\u0006!b)\u0013'F\u001d\u0006kUiX'B1~cUIT$U\u0011\u0002\n\u0011\u0003R#G\u0003VcEk\u0018)B\u000f\u0016{6+\u0013.F\u0003I!UIR!V\u0019R{\u0006+Q$F?NK%,\u0012\u0011\u0002%\u0011+e)Q+M)~{%\u000bR#S?6{E)R\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u001c5\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0003g_Jl7O\u0003\u0003\u0002\u0016\u0005]\u0011A\u0001<2\u0015\r\tI\u0002S\u0001\u0004CBL\u0017\u0002BA\u000f\u0003\u001f\u0011\u0001CU3mK\u0006\u001cXm\u0014:eKJlu\u000eZ3\u0002'\u0011+e)Q+M)~{%\u000bR#S?6{E)\u0012\u0011\u0002!M\fg.\u001b;ju\u00164\u0015\u000e\\3oC6,G\u0003BA\u0013\u0003s\u0001B!a\n\u000269!\u0011\u0011FA\u0019!\r\tY#V\u0007\u0003\u0003[Q1!a\fO\u0003\u0019a$o\\8u}%\u0019\u00111G+\u0002\rA\u0013X\rZ3g\u0013\r!\u0017q\u0007\u0006\u0004\u0003g)\u0006bBA\u001e3\u0001\u0007\u0011QE\u0001\tM&dWM\\1nK\n!A)\u0019;b'\u0019Q2+!\u0011\u0002HA\u0019A+a\u0011\n\u0007\u0005\u0015SKA\u0004Qe>$Wo\u0019;\u0011\u0007Q\u000bI%C\u0002\u0002LU\u0013AbU3sS\u0006d\u0017N_1cY\u0016\f1bZ3oKJ\fG/\u001a3CsV\u0011\u0011QE\u0001\rO\u0016tWM]1uK\u0012\u0014\u0015\u0010I\u0001\fO\u0016tWM]1uK\u0012|e.\u0006\u0002\u0002XA!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^\u0005\fA!\u001e;jY&!\u0011\u0011MA.\u0005\u0011!\u0015\r^3\u0002\u0019\u001d,g.\u001a:bi\u0016$wJ\u001c\u0011\u0002\u001bI,\u0007o\u001c:u\r&dG/\u001a:t+\t\tI\u0007\u0005\u0004\u0002l\u0005U\u00141\u0010\b\u0005\u0003[\n\tH\u0004\u0003\u0002,\u0005=\u0014\"\u0001,\n\u0007\u0005MT+A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0014\u0011\u0010\u0002\u0004'\u0016\f(bAA:+B!\u0011QPAB\u001b\t\tyHC\u0002\u0002\u0002\u001a\u000bqAZ5mi\u0016\u00148/\u0003\u0003\u0002\u0006\u0006}$\u0001\u0004*fa>\u0014HOR5mi\u0016\u0014\u0018A\u0004:fa>\u0014HOR5mi\u0016\u00148\u000f\t\u000b\t\u0003\u0017\u000by)!%\u0002\u0014B\u0019\u0011Q\u0012\u000e\u000e\u0003\u0005Aq!!\u0014\"\u0001\u0004\t)\u0003C\u0004\u0002T\u0005\u0002\r!a\u0016\t\u000f\u0005\u0015\u0014\u00051\u0001\u0002j\u0005!1m\u001c9z)!\tY)!'\u0002\u001c\u0006u\u0005\"CA'EA\u0005\t\u0019AA\u0013\u0011%\t\u0019F\tI\u0001\u0002\u0004\t9\u0006C\u0005\u0002f\t\u0002\n\u00111\u0001\u0002j\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAARU\u0011\t)#!*,\u0005\u0005\u001d\u0006\u0003BAU\u0003gk!!a+\u000b\t\u00055\u0016qV\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!-V\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003k\u000bYKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002<*\"\u0011qKAS\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!1+\t\u0005%\u0014QU\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111ZAi!\r!\u0016QZ\u0005\u0004\u0003\u001f,&aA!os\"A\u00111\u001b\u0015\u0002\u0002\u0003\u0007Q0A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00033\u0004b!a7\u0002b\u0006-WBAAo\u0015\r\ty.V\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAr\u0003;\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011^Ax!\r!\u00161^\u0005\u0004\u0003[,&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003'T\u0013\u0011!a\u0001\u0003\u0017\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002{\u0006AAo\\*ue&tw\rF\u0001^\u0003\u0019)\u0017/^1mgR!\u0011\u0011^A\u007f\u0011%\t\u0019.LA\u0001\u0002\u0004\tY-\u0001\u0003ECR\f\u0007cAAG_M)qF!\u0002\u0002HAa!q\u0001B\u0007\u0003K\t9&!\u001b\u0002\f6\u0011!\u0011\u0002\u0006\u0004\u0005\u0017)\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005\u001f\u0011IAA\tBEN$(/Y2u\rVt7\r^5p]N\"\"A!\u0001\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\u0005-%q\u0003B\r\u00057Aq!!\u00143\u0001\u0004\t)\u0003C\u0004\u0002TI\u0002\r!a\u0016\t\u000f\u0005\u0015$\u00071\u0001\u0002j\u00059QO\\1qa2LH\u0003\u0002B\u0011\u0005[\u0001R\u0001\u0016B\u0012\u0005OI1A!\nV\u0005\u0019y\u0005\u000f^5p]BIAK!\u000b\u0002&\u0005]\u0013\u0011N\u0005\u0004\u0005W)&A\u0002+va2,7\u0007C\u0005\u00030M\n\t\u00111\u0001\u0002\f\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005k\u00012A\u0018B\u001c\u0013\r\u0011Id\u0018\u0002\u0007\u001f\nTWm\u0019;\u0014\tU\u001a&Q\b\t\u0005\u0005\u007f\u0011I%\u0004\u0002\u0003B)!!1\tB#\u0003\u0015\u0019HN\u001a\u001bk\u0015\t\u00119%\u0001\u0005he&T(\u0010\\3e\u0013\u0011\u0011YE!\u0011\u0003\u000f1{wmZ5oO\u0006q!/\u001a9peR\u001c8+\u001a:wS\u000e,\u0007\u0003\u0002B)\u0005/j!Aa\u0015\u000b\u0007\tUc)A\u0004tKJ4\u0018nY3\n\t\te#1\u000b\u0002\u000f%\u0016\u0004xN\u001d;t'\u0016\u0014h/[2f\u0003Q\u0011X\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dKB!!q\fB2\u001b\t\u0011\tGC\u0002\u0003V!KAA!\u001a\u0003b\t!\"+\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\faB]3mK\u0006\u001cXmU3sm&\u001cW\r\u0005\u0003\u0003`\t-\u0014\u0002\u0002B7\u0005C\u0012aBU3mK\u0006\u001cXmU3sm&\u001cW-A\ntKJ4XM]\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0003\u0003t\teTB\u0001B;\u0015\r\u00119HS\u0001\tI\u0016\u0004Hn\\=ji&!!1\u0010B;\u0005M\u0019VM\u001d<fe\u000e{gNZ5hkJ\fG/[8o\u0003Q\u0011X\r\\3bg\u00164\u0016.Z<D_:4XM\u001d;feB!!\u0011\u0011BF\u001b\t\u0011\u0019I\u0003\u0003\u0003\u0006\n\u001d\u0015AC2p]Z,'\u000f^3sg*\u0019!\u0011\u0012%\u0002\u000bYLWm^:\n\t\t5%1\u0011\u0002\u0015%\u0016dW-Y:f-&,woQ8om\u0016\u0014H/\u001a:\u0002#Q\f7o[!dG\u0016\u001c8oU3sm&\u001cW\r\u0005\u0003\u0003`\tM\u0015\u0002\u0002BK\u0005C\u0012\u0011\u0003V1tW\u0006\u001b7-Z:t'\u0016\u0014h/[2f\u0003I\u0011X\r]8si\u001aKG\u000e^3s\u001b\u0006\u0004\b/\u001a:\u0011\u0007A\u0013Y*C\u0002\u0003\u001e\u0012\u0013!CU3q_J$h)\u001b7uKJl\u0015\r\u001d9feR\u0001\"\u0011\u0015BR\u0005K\u00139K!+\u0003,\n5&q\u0016\t\u0003!VBqA!\u0014>\u0001\u0004\u0011y\u0005C\u0004\u0003\\u\u0002\rA!\u0018\t\u000f\t\u001dT\b1\u0001\u0003j!9!qN\u001fA\u0002\tE\u0004b\u0002B?{\u0001\u0007!q\u0010\u0005\b\u0005\u001fk\u0004\u0019\u0001BI\u0011\u001d\u00119*\u0010a\u0001\u00053C3!\u0010BZ!\u0011\u0011)L!3\u000e\u0005\t]&\u0002BAY\u0005sSAAa/\u0003>\u00069a-Y2u_JL(\u0002\u0002B`\u0005\u0003\fQAY3b]NTAAa1\u0003F\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0003H\u0006\u0019qN]4\n\t\t-'q\u0017\u0002\n\u0003V$xn^5sK\u0012\fabZ3oKJ\fG/\u001a*fa>\u0014H\u000f\u0006\u0004\u0003R\nu'q\u001d\t\u0005\u0005'\u0014I.\u0004\u0002\u0003V*\u0019!q[1\u0002\u0005%|\u0017\u0002\u0002Bn\u0005+\u0014AAR5mK\"9!q\u001c A\u0002\t\u0005\u0018\u0001\u0005:fa>\u0014H\u000fR3gS:LG/[8o!\r\u0001&1]\u0005\u0004\u0005K$%aF'vYRL'+\u001a7fCN,\u0017)\u001e3jiJ+\u0007o\u001c:u\u0011\u001d\u0011IO\u0010a\u0001\u0005W\f1C]3q_J$(j\u001c2Sk:\u001cuN\u001c;fqR\u0004BA!<\u0003v6\u0011!q\u001e\u0006\u0005\u00033\u0011\tPC\u0002\u0003t\u001a\u000b1A[8c\u0013\u0011\u00119Pa<\u0003'I+\u0007o\u001c:u\u0015>\u0014'+\u001e8D_:$X\r\u001f;\u00027\u001d,g.\u001a:bi\u0016\u001c\u0016N\\4mKJ+G.Z1tKJ+\u0007o\u001c:u)\u0019\u0011ipa\t\u00048A!!q`B\u000f\u001d\u0011\u0019\taa\u0006\u000f\t\r\r11\u0003\b\u0005\u0007\u000b\u0019\tB\u0004\u0003\u0004\b\r=a\u0002BB\u0005\u0007\u001bqA!a\u000b\u0004\f%\tQ*\u0003\u0002L\u0019&\u0011\u0011JS\u0005\u0003\u000f\"K1a!\u0006G\u0003\u0015)\u0007pY3m\u0013\u0011\u0019Iba\u0007\u0002/5+H\u000e^5SK2,\u0017m]3Bk\u0012LGOU3q_J$(bAB\u000b\r&!1qDB\u0011\u00059\u0001VM\u001d*fY\u0016\f7/\u001a#bi\u0006TAa!\u0007\u0004\u001c!91QE A\u0002\r\u001d\u0012aB<pe.$\u0015N\u001d\t\u0005\u0007S\u0019\u0019$\u0004\u0002\u0004,)!1QFB\u0018\u0003\u00111\u0017\u000e\\3\u000b\u0007\rE\u0012-A\u0002oS>LAa!\u000e\u0004,\t!\u0001+\u0019;i\u0011\u001d\u0019Id\u0010a\u0001\u0007w\t\u0011B]3mK\u0006\u001cX-\u00133\u0011\t\ru2qI\u0007\u0003\u0007\u007fQAa!\u0011\u0004D\u0005)Q\u000f^5mg*\u00191Q\t%\u0002\r\u0011|W.Y5o\u0013\u0011\u0019Iea\u0010\u0003'I+G.Z1tK&#\u0017J\u001c#bi\u0006\u0014\u0017m]3\u0002\u0019%t7\u000f^1oG\u0016$\u0015\r^1\u0016\u0005\r=\u0003\u0003BB)\u0007+r1\u0001UB*\u0013\r\t\u0019\bR\u0005\u0005\u0007/\u001aIF\u0001\u0007J]N$\u0018M\\2f\t\u0006$\u0018MC\u0002\u0002t\u0011\u000bq\u0001\u001d:fm&,w\u000f\u0006\u0003\u0002L\u000e}\u0003b\u0002Bp\u0003\u0002\u0007!\u0011]\u0001\u000fM>\u0014X.\u0019;EkJ\fG/[8o)\u0011\t)c!\u001a\t\u000f\r\u001d$\t1\u0001\u0004j\u00059!/\u001a7fCN,\u0007\u0003BB6\u0007[j!aa\u0011\n\t\r=41\t\u0002\b%\u0016dW-Y:fQ\r)41\u000f\t\u0005\u0007k\u001aY(\u0004\u0002\u0004x)!1\u0011\u0010Ba\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0007{\u001a9HA\u0004TKJ4\u0018nY3")
public class MultiReleaseAuditReportComponent
implements Logging {
    private final ReportsService reportsService;
    private final ReleaseSearchService releaseSearchService;
    private final ServerConfiguration serverConfiguration;
    private final ReleaseViewConverter releaseViewConverter;
    private final TaskAccessService taskAccessService;
    private final ReportFilterMapper reportFilterMapper;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String sanitizeFilename(String string) {
        return MultiReleaseAuditReportComponent$.MODULE$.sanitizeFilename(string);
    }

    public static ReleaseOrderMode DEFAULT_ORDER_MODE() {
        return MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_ORDER_MODE();
    }

    public static int DEFAULT_PAGE_SIZE() {
        return MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_PAGE_SIZE();
    }

    public static int FILENAME_MAX_LENGTH() {
        return MultiReleaseAuditReportComponent$.MODULE$.FILENAME_MAX_LENGTH();
    }

    public static SimpleDateFormat DATETIME_FORMATTER() {
        return MultiReleaseAuditReportComponent$.MODULE$.DATETIME_FORMATTER();
    }

    public static String SINGLE_REPORTS_DIR() {
        return MultiReleaseAuditReportComponent$.MODULE$.SINGLE_REPORTS_DIR();
    }

    public static String SINGLE_TITLE_SEPARATOR() {
        return MultiReleaseAuditReportComponent$.MODULE$.SINGLE_TITLE_SEPARATOR();
    }

    public static String MASTER_TITLE_SEPARATOR() {
        return MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE_SEPARATOR();
    }

    public static String MASTER_TITLE() {
        return MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE();
    }

    public static String ZIP_EXTENSION() {
        return MultiReleaseAuditReportComponent$.MODULE$.ZIP_EXTENSION();
    }

    public static String EXCEL_CONTENT_TYPE() {
        return MultiReleaseAuditReportComponent$.MODULE$.EXCEL_CONTENT_TYPE();
    }

    public static String EXCEL_EXTENSION() {
        return MultiReleaseAuditReportComponent$.MODULE$.EXCEL_EXTENSION();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        MultiReleaseAuditReportComponent multiReleaseAuditReportComponent = this;
        synchronized (multiReleaseAuditReportComponent) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public File generateReport(MultiReleaseAuditReport reportDefinition, ReportJobRunContext reportJobRunContext) {
        String reportName;
        Data data = new Data(reportDefinition.getGeneratedBy(), reportDefinition.getGeneratedOn(), (Seq<ReportFilter>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(reportDefinition.filters()).asScala()));
        Seq releaseIds = this.releaseSearchService.searchAllIdsWithoutPermissionsCheck(data.reportFilters(), (Option)new Some((Object)ReleaseOrderMode.start_date), this.releaseSearchService.searchAllIdsWithoutPermissionsCheck$default$3(), this.releaseSearchService.searchAllIdsWithoutPermissionsCheck$default$4());
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Creating report for ").append(releaseIds.length()).append(" releases in job with id '").append(reportJobRunContext.jobId()).append("'.").toString());
        int totalWorkItems = releaseIds.length() + 3;
        ReportJobProgressMonitor progressMonitor = reportJobRunContext.reportJobProgressMonitor();
        progressMonitor.sendTotalWorkItems(totalWorkItems);
        File workDir = reportJobRunContext.reportStorage().workdir();
        String reportDirName = reportName = reportJobRunContext.reportName();
        Path reportDir = Paths.get(workDir.getPath(), reportDirName);
        Path reportsDir = reportDir.resolve(MultiReleaseAuditReportComponent$.MODULE$.SINGLE_REPORTS_DIR());
        reportsDir.toFile().mkdirs();
        scala.collection.immutable.Map releasesData = (scala.collection.immutable.Map)releaseIds.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Map done = (scala.collection.immutable.Map)tuple2._1();
            ReleaseIdInDatabase id = (ReleaseIdInDatabase)tuple2._2();
            scala.collection.immutable.Map toR = done.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)id.adaptiveReleaseId()), MaybeData$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.generateSingleReleaseReport(reportsDir, id))));
            progressMonitor.sendCompletedWorkItems(toR.keys().size());
            scala.collection.immutable.Map map = toR;
            return map;
        });
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Creating master report with all releases");
        MultiReleaseAuditReport.Data masterData = new MultiReleaseAuditReport.Data(data.generatedBy(), data.generatedOn(), this.instanceData(), this.reportFilterMapper.map(data.reportFilters()), (Seq<Try<Either<Tuple2<Throwable, MultiReleaseAuditReport.PerReleaseData>, MultiReleaseAuditReport.PerReleaseData>>>)releasesData.values().toSeq());
        Workbook masterWorkBook = MultiReleaseAuditReport$.MODULE$.getWorkBook(masterData);
        File masterFile = package$.MODULE$.writeToFile(reportDir, masterWorkBook, data.generatedOn(), MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE());
        progressMonitor.sendCompletedWorkItems(releaseIds.length() + 1);
        File file = masterFile;
        File fullReport = ZipUtils$.MODULE$.archive((Seq)((TraversableOnce)releasesData.values().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Try<Either<Tuple2<Throwable, MultiReleaseAuditReport.PerReleaseData>, MultiReleaseAuditReport.PerReleaseData>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Success) {
                    Success success = (Success)A1;
                    Either releaseData = (Either)success.value();
                    object = ((Tuple2)((MultiReleaseAuditReport.PerReleaseData)MaybeData$Implicits$EitherOps$.MODULE$.getValue$extension(MaybeData$Implicits$.MODULE$.EitherOps(releaseData))).storedPath().get())._1();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Try<Either<Tuple2<Throwable, MultiReleaseAuditReport.PerReleaseData>, MultiReleaseAuditReport.PerReleaseData>> x1) {
                Try<Either<Tuple2<Throwable, MultiReleaseAuditReport.PerReleaseData>, MultiReleaseAuditReport.PerReleaseData>> try_ = x1;
                boolean bl = try_ instanceof Success;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq().$plus$colon((Object)file, Seq$.MODULE$.canBuildFrom()), reportDir.resolve(new StringBuilder(0).append(reportName).append(MultiReleaseAuditReportComponent$.MODULE$.ZIP_EXTENSION()).toString()).toFile(), (Option)new Some((Object)workDir.getPath()));
        progressMonitor.sendCompletedWorkItems(releaseIds.length() + 2);
        FileUtils.deleteDirectory((File)reportsDir.toFile());
        masterFile.delete();
        progressMonitor.sendCompletedWorkItems(totalWorkItems);
        return fullReport;
    }

    private MultiReleaseAuditReport.PerReleaseData generateSingleReleaseReport(Path workDir, ReleaseIdInDatabase releaseId) {
        MultiReleaseAuditReport.PerReleaseData perReleaseData;
        try {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Working on report for [").append(releaseId.adaptiveReleaseId().folderlessReleaseId()).append("]").toString());
            Release release = this.reportsService.findReleaseByReleaseIdInDatabase(releaseId);
            AuditReport.Data data = this.reportsService.fetchAuditReportData(release);
            Workbook workBook = AuditReport$.MODULE$.getWorkBook(data);
            Try<Either<Tuple2<Throwable, String>, String>> folder = this.reportsService.formattedReleaseFolderPath(release.getId());
            File stored = package$.MODULE$.writeToFile(workDir, workBook, data.releaseTree().release().getStartOrScheduledDate(), data.releaseTree().release().getTitle());
            PlannerReleaseItem root = data.releaseTree().root();
            perReleaseData = new MultiReleaseAuditReport.PerReleaseData(release.getTitle(), release.getOwner(), folder, (Date)Option$.MODULE$.apply((Object)release.getStartDate()).getOrElse((Function0 & Serializable & scala.Serializable)() -> release.getScheduledStartDate()), (Either<Date, Date>)((Either)root.endDate().map((Function1 & Serializable & scala.Serializable)dt -> scala.package$.MODULE$.Left().apply((Object)dt.toDate())).orElse((Function0 & Serializable & scala.Serializable)() -> root.dueDate().map((Function1 & Serializable & scala.Serializable)dt -> scala.package$.MODULE$.Right().apply((Object)dt.toDate()))).get()), this.formatDuration(release), release.getStatus(), data.releaseOverviewData().startedBy(), (Option<Tuple2<File, String>>)new Some((Object)new Tuple2((Object)stored, (Object)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(stored.getPath())).stripPrefix(workDir.getParent().toFile().getPath()))).stripPrefix(File.separator))), data.releaseOverviewData().templateInfo());
        }
        catch (Exception e) {
            throw new IllegalStateException(new StringBuilder(43).append("Unable to generate individual report for ").append(releaseId.adaptiveReleaseId().folderlessReleaseId()).append(": ").append(e.getMessage()).toString(), e);
        }
        return perReleaseData;
    }

    private package.InstanceData instanceData() {
        Option<String> instanceName = this.reportsService.getInstanceName();
        Option instanceUrl = Option$.MODULE$.apply((Object)this.serverConfiguration.getServerUrl());
        Option<String> xlrVersion = this.reportsService.getInstanceVersion();
        return new package.InstanceData(instanceName, (Option<String>)instanceUrl, xlrVersion);
    }

    public Object preview(MultiReleaseAuditReport reportDefinition) {
        AuditReportRequest reportRequest = new AuditReportRequest((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(reportDefinition.filters()).asScala(), Option$.MODULE$.apply((Object)MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_ORDER_MODE()));
        List<Release> releases = this.reportsService.getReleasesForPreview(reportRequest, 0L, MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_PAGE_SIZE());
        ReleaseCountResults releaseCount = this.reportsService.getReleasesCountByStatus(reportRequest);
        List properties = Collections.emptyList();
        List<String> extensions = Collections.singletonList("progress");
        Buffer views = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(releases).asScala()).map((Function1 & Serializable & scala.Serializable)r -> $this.releaseViewConverter.toFullView(r, $this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser(), properties, extensions, 2), Buffer$.MODULE$.canBuildFrom());
        return JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releases"), JavaConverters$.MODULE$.bufferAsJavaListConverter(views).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releaseCount"), (Object)releaseCount)}))).asJava();
    }

    private String formatDuration(Release release) {
        Duration duration = (Duration)Option$.MODULE$.apply((Object)release.getActualDuration()).getOrElse((Function0 & Serializable & scala.Serializable)() -> release.getComputedPlannedDuration());
        return ExcelSheetWriter.PERIOD_FORMATTER.print((ReadablePeriod)duration.toPeriod().normalizedStandard(PeriodType.dayTime()));
    }

    @Autowired
    public MultiReleaseAuditReportComponent(ReportsService reportsService, ReleaseSearchService releaseSearchService, ReleaseService releaseService, ServerConfiguration serverConfiguration, ReleaseViewConverter releaseViewConverter, TaskAccessService taskAccessService, ReportFilterMapper reportFilterMapper) {
        this.reportsService = reportsService;
        this.releaseSearchService = releaseSearchService;
        this.serverConfiguration = serverConfiguration;
        this.releaseViewConverter = releaseViewConverter;
        this.taskAccessService = taskAccessService;
        this.reportFilterMapper = reportFilterMapper;
        Logging.$init$((Logging)this);
    }

    public static class Data
    implements Product,
    scala.Serializable {
        private final String generatedBy;
        private final Date generatedOn;
        private final Seq<ReportFilter> reportFilters;

        public String generatedBy() {
            return this.generatedBy;
        }

        public Date generatedOn() {
            return this.generatedOn;
        }

        public Seq<ReportFilter> reportFilters() {
            return this.reportFilters;
        }

        public Data copy(String generatedBy, Date generatedOn, Seq<ReportFilter> reportFilters) {
            return new Data(generatedBy, generatedOn, reportFilters);
        }

        public String copy$default$1() {
            return this.generatedBy();
        }

        public Date copy$default$2() {
            return this.generatedOn();
        }

        public Seq<ReportFilter> copy$default$3() {
            return this.reportFilters();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Seq<ReportFilter> seq;
            int n = x$1;
            switch (n) {
                case 0: {
                    seq = this.generatedBy();
                    break;
                }
                case 1: {
                    seq = this.generatedOn();
                    break;
                }
                case 2: {
                    seq = this.reportFilters();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return seq;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            String string = this.generatedBy();
            String string2 = data.generatedBy();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Date date = this.generatedOn();
            Date date2 = data.generatedOn();
            if (date == null) {
                if (date2 != null) {
                    return false;
                }
            } else if (!((Object)date).equals(date2)) return false;
            Seq<ReportFilter> seq = this.reportFilters();
            Seq<ReportFilter> seq2 = data.reportFilters();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(String generatedBy, Date generatedOn, Seq<ReportFilter> reportFilters) {
            this.generatedBy = generatedBy;
            this.generatedOn = generatedOn;
            this.reportFilters = reportFilters;
            Product.$init$((Product)this);
        }
    }
}

