/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.utils.ResponseHelper;
import com.xebialabs.xlrelease.api.v1.forms.FacetFilters;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord;
import com.xebialabs.xlrelease.reports.job.domain.BaseStreamingReleaseReportDefinition;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TypeHelper;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.FacetService;
import com.xebialabs.xlrelease.service.ReleaseService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import scala.collection.JavaConverters;
import scala.collection.Seq;

@Path(value="/api/v1/reports")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class ReportApi
implements ApiService {
    private final ApplicationContext applicationContext;
    private final FacetService facetService;
    private final ReleaseService releaseService;
    private final PermissionChecker permissions;

    @Autowired
    public ReportApi(ApplicationContext applicationContext, FacetService facetService, ReleaseService releaseService, PermissionChecker permissions) {
        this.applicationContext = applicationContext;
        this.facetService = facetService;
        this.releaseService = releaseService;
        this.permissions = permissions;
    }

    public String serviceName() {
        return "reportApi";
    }

    @GET
    @Path(value="/records/{releaseId:.*Release[^/]*}")
    @PublicApiMember
    @Timed
    public List<TaskReportingRecord> getRecordsForRelease(@PathParam(value="releaseId") String releaseId) {
        return this.searchRecords(new FacetFilters().withParentId(releaseId));
    }

    @GET
    @Path(value="/records/{taskId:.*/Task[^/]*}")
    @PublicApiMember
    @Timed
    public List<TaskReportingRecord> getRecordsForTask(@PathParam(value="taskId") String taskId) {
        return this.searchRecords(new FacetFilters().withTargetId(taskId));
    }

    @POST
    @Path(value="/records/search")
    @PublicApiMember
    @Timed
    public List<TaskReportingRecord> searchRecords(FacetFilters facetFilters) {
        facetFilters.validate();
        String containerId = facetFilters.getParentId() != null ? facetFilters.getParentId() : facetFilters.getTargetId();
        this.permissions.checkView(Ids.releaseIdFrom((String)containerId));
        this.checkFiltersContainValidSearchableTypes(facetFilters);
        return this.facetService.search(facetFilters).stream().map(facet -> (TaskReportingRecord)facet).collect(Collectors.toList());
    }

    @GET
    @Path(value="/download/{reportType}/{releaseId:.*Release[^/]*}")
    @Produces(value={"application/octet-stream"})
    @Timed
    public Response downloadReleaseReport(@PathParam(value="reportType") String reportType, @PathParam(value="releaseId") @IdParam String releaseId) {
        BaseStreamingReleaseReportDefinition report = this.createReportDefinition(reportType, releaseId);
        StreamingOutput output = report.run();
        return ResponseHelper.streamFile((String)report.getFileName(), (StreamingOutput)output, (String)report.contentType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublicApiMember
    @Timed
    public byte[] getReleaseReport(String reportType, String releaseId) throws IOException {
        BaseStreamingReleaseReportDefinition report = this.createReportDefinition(reportType, releaseId);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            report.run().write((OutputStream)outputStream);
        }
        return outputStream.toByteArray();
    }

    private BaseStreamingReleaseReportDefinition createReportDefinition(String reportType, String releaseId) {
        Release release = this.releaseService.findByIdIncludingArchived(releaseId);
        this.permissions.checkView(release);
        BaseStreamingReleaseReportDefinition report = (BaseStreamingReleaseReportDefinition)Type.valueOf((String)reportType).getDescriptor().newInstance(null);
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)report);
        report.setRelease(release);
        return report;
    }

    private void checkFiltersContainValidSearchableTypes(FacetFilters facetFilters) {
        Type taskReportingRecordType = Type.valueOf(TaskReportingRecord.class);
        if (facetFilters.getTypes() == null || facetFilters.getTypes().isEmpty()) {
            facetFilters.setTypes(JavaConverters.seqAsJavaList((Seq)TypeHelper.getAllSubtypesOf((Type)taskReportingRecordType)));
        } else {
            Predicate<Type> isUnsupportedType = facetType -> !facetType.instanceOf(taskReportingRecordType);
            facetFilters.getTypes().removeIf(isUnsupportedType);
            if (facetFilters.getTypes().isEmpty()) {
                throw new IllegalArgumentException("Filter contains unsupported types");
            }
        }
    }
}

