/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.joda.time.format.ISODateTimeFormat;

public class DateVariableUtils {
    public static final String ISO_8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ssXXX";

    private DateVariableUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static Date parseDate(String dateString) {
        try {
            return ISODateTimeFormat.dateOptionalTimeParser().parseDateTime(dateString).toDate();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Given date '%s' has invalid format", dateString), e);
        }
    }

    public static Date parseDate(Object date) {
        if (date instanceof Number) {
            return new Date(((Number)date).longValue());
        }
        return DateVariableUtils.parseDate(Objects.toString(date));
    }

    public static String printDate(Date date) {
        return new SimpleDateFormat(ISO_8601_PATTERN).format(date);
    }
}

