/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned=false)
public class Team
extends BaseConfigurationItem {
    public static final String FOLDER_OWNER_TEAMNAME = "Folder Owner";
    public static final String TEMPLATE_OWNER_TEAMNAME = "Template Owner";
    public static final String RELEASE_ADMIN_TEAMNAME = "Release Admin";
    @Property
    private String teamName;
    @Property(required=false)
    private List<String> members = new ArrayList<String>();
    @Property(required=false)
    private List<String> roles = new ArrayList<String>();
    @Property(required=false)
    private List<String> permissions = new ArrayList<String>();

    @PublicApiMember
    public String getTeamName() {
        return this.teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public boolean hasMember(String username) {
        return this.members.contains(username);
    }

    public boolean hasAnyMember(Collection<String> members) {
        return members.stream().anyMatch(this::hasMember);
    }

    public boolean hasPermission(String permission) {
        return this.permissions.contains(permission);
    }

    @PublicApiMember
    public List<String> getMembers() {
        return this.members;
    }

    public void setMembers(List<String> members) {
        this.members = members;
    }

    public void addMember(String newMember) {
        for (String member : this.members) {
            if (!member.equals(newMember)) continue;
            return;
        }
        if (newMember != null) {
            this.members.add(newMember);
        }
    }

    @PublicApiMember
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void addRole(String newRole) {
        for (String role : this.roles) {
            if (!role.equals(newRole)) continue;
            return;
        }
        if (newRole != null) {
            this.roles.add(newRole);
        }
    }

    public boolean hasRole(String role) {
        return this.roles.contains(role);
    }

    public boolean hasAnyRole(List<Role> roles) {
        for (Role role : roles) {
            if (!this.hasRole(role.getName())) continue;
            return true;
        }
        return false;
    }

    @PublicApiMember
    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(String permission) {
        if (!this.permissions.contains(permission) && permission != null) {
            this.permissions.add(permission);
        }
    }

    public boolean isReleaseAdminTeam() {
        return RELEASE_ADMIN_TEAMNAME.equals(this.teamName);
    }

    public boolean isTemplateOwnerTeam() {
        return TEMPLATE_OWNER_TEAMNAME.equals(this.teamName);
    }

    public boolean isFolderOwnerTeam() {
        return this.hasPermission(XLReleasePermissions.EDIT_FOLDER_SECURITY.getPermissionName());
    }

    public boolean isFolderAdminTeam() {
        return !this.isFolderOwnerTeam() && this.hasPermission(XLReleasePermissions.EDIT_FOLDER_TEAMS.getPermissionName());
    }

    public boolean isSystemTeam() {
        return this.isReleaseAdminTeam() || this.isTemplateOwnerTeam() || FOLDER_OWNER_TEAMNAME.equals(this.teamName);
    }

    public void addMembers(String[] members) {
        for (String member : members) {
            this.addMember(member);
        }
    }

    public void addRoles(String[] roles) {
        for (String role : roles) {
            this.addRole(role);
        }
    }

    public void addPermissions(String[] permissions) {
        for (String permission : permissions) {
            this.addPermission(permission);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!Team.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        Team other = (Team)((Object)obj);
        return (other.getId() == null && this.id == null || other.getId() != null && other.getId().equals(this.id)) && (other.getTeamName() == null && this.teamName == null || other.getTeamName() != null && other.getTeamName().equals(this.teamName)) && other.getPermissions().containsAll(this.permissions) && this.permissions.containsAll(other.getPermissions()) && other.getMembers().containsAll(this.members) && this.members.containsAll(other.getMembers()) && other.getRoles().containsAll(this.roles) && this.roles.containsAll(other.getRoles());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.teamName, this.permissions, this.members, this.roles);
    }

    public String toString() {
        return "{id: '" + this.id + "', teamName: '" + this.teamName + "', members: " + Arrays.toString(this.members.toArray()) + ", roles: " + Arrays.toString(this.roles.toArray()) + ", permissions: " + Arrays.toString(this.permissions.toArray()) + "}";
    }
}

