/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.ScheduledTrigger;
import com.xebialabs.xlrelease.domain.utils.FolderId;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.utils.Collectors;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned=false, virtual=false)
public class ReleaseTrigger
extends ScheduledTrigger {
    public static final String SCRIPT_VARS = "variables";
    @PublicApiMember
    @Property(description="Name given to releases created by this trigger. This field can contain variables.")
    private String releaseTitle;
    @Property(required=false, category="hidden", description="Not in Use. Keep it for backwards compatibility.")
    private String executionId;
    @PublicApiMember
    @Property(asContainment=true, required=false, category="hidden")
    protected List<Variable> variables = Lists.newArrayList();
    @Property(required=false, category="hidden")
    private String template;
    @PublicApiMember
    @Property(required=false, category="hidden")
    protected List<String> tags = Lists.newArrayList();

    @PublicApiMember
    public String getReleaseTitle() {
        return this.releaseTitle;
    }

    @PublicApiMember
    public void setReleaseTitle(String releaseTitle) {
        this.releaseTitle = releaseTitle;
    }

    @PublicApiMember
    public Map<String, String> getTemplateVariables() {
        return VariableHelper.getStringVariableValues(this.variables);
    }

    @PublicApiMember
    public Map<String, String> getTemplatePasswordVariables() {
        return VariableHelper.getPasswordStringVariableValues(this.variables);
    }

    @PublicApiMember
    public List<Variable> getVariables() {
        return Lists.newArrayList(this.variables);
    }

    public void setVariables(List<Variable> variables) {
        VariableHelper.checkVariables(variables);
        this.variables = variables;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public boolean hasExecutionId() {
        return this.executionId != null;
    }

    @VisibleForTesting
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public void resetExecutionId() {
        this.executionId = null;
    }

    public void setTriggerStateFromResults(String state) {
        if (state != null && !state.trim().isEmpty()) {
            this.setTriggerState(state);
        }
    }

    public void setScriptVariablesFromResults(Map<String, Object> variableValues) {
        Collection propertyDescriptors = this.getType().getDescriptor().getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!Objects.equal((Object)propertyDescriptor.getCategory(), (Object)SCRIPT_VARS)) continue;
            String propertyName = propertyDescriptor.getName();
            this.setProperty(propertyName, variableValues.get(propertyName));
        }
    }

    public Map<String, String> getStringScriptVariableValues() {
        return this.getScriptVariableValues().entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> VariableHelper.withVariableSyntax((String)e.getKey()), e -> e.getValue().toString()));
    }

    public Map<String, Object> getScriptVariableValues() {
        return this.getType().getDescriptor().getPropertyDescriptors().stream().filter(pd -> Objects.equal((Object)pd.getCategory(), (Object)SCRIPT_VARS)).collect(Collectors.toMap(PropertyDescriptor::getName, pd -> this.getProperty(pd.getName())));
    }

    public Map<String, Object> getTemplateVariableValues(Predicate<Variable> variablePredicate) {
        return this.getVariables().stream().filter(variablePredicate).collect(Collectors.toMap(Variable::getKey, Variable::getValue));
    }

    public Map<String, Variable> getVariablesByKeys() {
        return VariableHelper.indexByKey(this.getVariables());
    }

    @Override
    public String getContainerId() {
        FolderId folder = FolderId.apply(this.getFolderId());
        String containerId = folder.isEmpty() ? this.getTemplate() : folder.absolute();
        return containerId;
    }
}

