/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.ReleaseInfo;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.deployit.util.DeployitKeyStoreException;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.XLReleaseServer;
import com.xebialabs.xlrelease.XLReleaseServerLaunchOptions;
import com.xebialabs.xlrelease.XLReleaseSetup;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import java.io.File;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.security.Provider;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import javax.crypto.SecretKey;
import javax.servlet.DispatcherType;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class XLReleaseBootstrapper {
    private static final int DEFAULT_PORT = 5516;
    private final XLReleaseServerLaunchOptions launchOptions;
    private final ServerConfigFile configFile;
    private static final Logger logger = LoggerFactory.getLogger(XLReleaseBootstrapper.class);

    public XLReleaseBootstrapper(XLReleaseServerLaunchOptions launchOptions, ServerConfigFile configFile) {
        this.launchOptions = launchOptions;
        this.configFile = configFile;
    }

    public static void main(String[] args) {
        long startTimestamp = System.currentTimeMillis();
        XLReleaseServerLaunchOptions launchOptions = XLReleaseServerLaunchOptions.parseCommandLine(args);
        if (launchOptions == null) {
            return;
        }
        try {
            File serverConfFile = ResourceUtils.getFile((String)XlrConfig.bootConfig().confFile_location());
            ServerConfigFile confFile = new ServerConfigFile(serverConfFile);
            new XLReleaseBootstrapper(launchOptions, confFile).start(startTimestamp);
        }
        catch (Exception e) {
            logger.error("Could not start {}", (Object)"XL Release", (Object)e);
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    private void start(long startTimestamp) {
        XLReleaseBootstrapper.outputReleaseInfo();
        Security.addProvider((Provider)new BouncyCastleProvider());
        logger.info("Reading configuration file from: " + this.configFile);
        if (this.launchOptions.isDoSetup()) {
            this.startSetup();
        } else {
            if (!this.configFile.exists()) {
                logger.warn("Configuration not found...");
                this.startSetup();
            }
            this.startServer(startTimestamp);
        }
    }

    private static void outputReleaseInfo() {
        ReleaseInfo releaseInfo = new ReleaseInfo("com/xebialabs/deployit/release.properties");
        logger.info("{} version {} (built at {})", new Object[]{"XL Release", releaseInfo.getVersion(), releaseInfo.getDate()});
        logger.info("{} running with {} (version {}) from {}", new Object[]{"XL Release", System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version"), System.getProperty("java.vm.vendor")});
        logger.info("(c) 2012-{} XebiaLabs, Inc.\n", (Object)new SimpleDateFormat("yyyy").format(new Date()));
        if (Environment.isDevelopment()) {
            logger.warn(" DEVELOPMENT MODE");
        }
    }

    private void startSetup() {
        ServerConfiguration serverDefaults = new ServerConfiguration();
        serverDefaults.setHttpPort(5516);
        logger.info("Initializing Repository");
        XLReleaseSetup setupWizard = new XLReleaseSetup("XL Release", this.configFile, this.launchOptions, serverDefaults);
        setupWizard.run();
    }

    private void startServer(long startTimestamp) {
        logger.info("Starting server...");
        try {
            ServerConfiguration config = this.loadConfigAndInitPasswordEncryptionKey();
            XLReleasePermissions.init();
            this.checkPortAvailable(config);
            XLReleaseServer server = new XLReleaseServer("XL Release", config, Environment.getSpringConfig(), config.getWebContextRoot(), this.launchOptions, startTimestamp);
            server.getContext().addFilter(RequestLocal.class, "*", EnumSet.of(DispatcherType.REQUEST));
            server.start(startTimestamp);
        }
        catch (Throwable e) {
            logger.error("Fatal error starting server", e);
        }
    }

    private void checkPortAvailable(ServerConfiguration config) {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(config.getHttpBindAddress());
        }
        catch (UnknownHostException e) {
            logger.error("Cannot start {}; invalid bind address: {}", (Object)"XL Release", (Object)config.getHttpBindAddress());
            System.exit(1);
        }
        if (!XLReleaseBootstrapper.isPortAvailable(config.getHttpPort(), address)) {
            logger.error("Cannot start {}; port {} already in use.", (Object)"XL Release", (Object)config.getHttpPort());
            logger.error("Perhaps another instance of {} is running.", (Object)"XL Release");
            System.exit(1);
        }
    }

    private static boolean isPortAvailable(int port, InetAddress address) {
        try {
            ServerSocket socket = new ServerSocket(port, 1, address);
            socket.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private ServerConfiguration loadConfigAndInitPasswordEncryptionKey() {
        ServerConfiguration config = this.configFile.loadConfig(false, false);
        String repositoryKeyStorePassword = this.launchOptions.getRepositoryKeystorePassword() != null ? this.launchOptions.getRepositoryKeystorePassword() : config.getRepositoryKeyStorePassword();
        try {
            SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)repositoryKeyStorePassword);
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        }
        catch (DeployitKeyStoreException e) {
            throw new RuntimeException("Could not load the encryption key. The server will not start.");
        }
        config.loadEncryptedPasswords();
        this.configFile.saveDirtyConfiguration(config);
        return config;
    }
}

