/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.v1.forms.CreateDelivery;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryPatternFilters;
import com.xebialabs.xlrelease.api.v1.forms.DuplicateDeliveryPattern;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.domain.Condition;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.domain.DeliveryStatus;
import com.xebialabs.xlrelease.delivery.domain.Stage;
import com.xebialabs.xlrelease.delivery.domain.StageStatus;
import com.xebialabs.xlrelease.delivery.domain.Transition;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatingEvent;
import com.xebialabs.xlrelease.delivery.events.StageCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.StageRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.StageUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryServiceUtils;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

@Service
@ScalaSignature(bytes="\u0006\u0001\r=e\u0001B\u001b7\u0001\u0005C\u0001\u0002\u0014\u0001\u0003\u0006\u0004%\t!\u0014\u0005\t)\u0002\u0011\t\u0011)A\u0005\u001d\"AQ\u000b\u0001BC\u0002\u0013\u0005a\u000b\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003X\u0011!i\u0006A!b\u0001\n\u0003q\u0006\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u0011\u0015\u0004!Q1A\u0005\u0002\u0019D\u0001B\u001b\u0001\u0003\u0002\u0003\u0006Ia\u001a\u0005\tW\u0002\u0011)\u0019!C\u0001Y\"A1\u000f\u0001B\u0001B\u0003%Q\u000e\u0003\u0005u\u0001\t\u0015\r\u0011\"\u0001v\u0011!I\bA!A!\u0002\u00131\b\u0002\u0003>\u0001\u0005\u000b\u0007I\u0011A>\t\u0013\u0005%\u0001A!A!\u0002\u0013a\bBCA\u0006\u0001\t\u0015\r\u0011\"\u0001\u0002\u000e!Q\u00111\u0004\u0001\u0003\u0002\u0003\u0006I!a\u0004\t\u000f\u0005u\u0001\u0001\"\u0001\u0002 !I\u0011\u0011\u000b\u0001C\u0002\u0013\u0015\u00111\u000b\u0005\t\u00037\u0002\u0001\u0015!\u0004\u0002V!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0003bBAN\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0003K\u0003A\u0011AAT\u0011\u001d\tI\f\u0001C\u0001\u0003wCq!a1\u0001\t\u0003\t)\rC\u0004\u0002N\u0002!\t!a4\t\u000f\u0005]\u0007\u0001\"\u0001\u0002Z\"9\u0011Q\u001d\u0001\u0005\u0002\u0005\u001d\bb\u0002B\u0003\u0001\u0011\u0005!q\u0001\u0005\b\u0005/\u0001A\u0011\u0001B\r\u0011\u001d\u0011\t\u0005\u0001C\u0001\u0005\u0007BqA!\u0015\u0001\t\u0003\u0011\u0019\u0006C\u0004\u0003R\u0001!\tA!\u0018\t\u000f\t\u0015\u0004\u0001\"\u0001\u0003h!9!q\u000e\u0001\u0005\u0002\tE\u0004b\u0002B>\u0001\u0011\u0005!Q\u0010\u0005\b\u0005w\u0002A\u0011\u0001BI\u0011\u001d\u0011Y\n\u0001C\u0001\u0005;CqAa'\u0001\t\u0003\u0011)\u000bC\u0004\u0003.\u0002!\tAa,\t\u000f\te\u0006\u0001\"\u0003\u0003<\"9!Q\u001b\u0001\u0005\n\t]\u0007b\u0002Bn\u0001\u0011%!Q\u001c\u0005\b\u0005C\u0004A\u0011\u0002Br\u0011\u001d\u00119\u000f\u0001C\u0005\u0005SDqA!=\u0001\t\u0013\u0011\u0019\u0010C\u0004\u0003z\u0002!IAa?\t\u0013\r\r\u0001!%A\u0005\n\r\u0015\u0001bBB\r\u0001\u0011%11\u0004\u0005\b\u0007S\u0001A\u0011BB\u0016\u0011\u001d\u0019)\u0007\u0001C\u0005\u0007OB\u0011ba\u001c\u0001#\u0003%Ia!\u001d\t\u000f\rU\u0004\u0001\"\u0015\u0004x\t1B)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014hnU3sm&\u001cWM\u0003\u00028q\u000591/\u001a:wS\u000e,'BA\u001d;\u0003!!W\r\\5wKJL(BA\u001e=\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002>}\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u007f\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\u0011%\u0011\u0005\r3U\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\r\u0005s\u0017PU3g!\tI%*D\u00017\u0013\tYeG\u0001\u000bEK2Lg/\u001a:z'\u0016\u0014h/[2f+RLGn]\u0001\u0013I\u0016d\u0017N^3ssJ+\u0007o\\:ji>\u0014\u00180F\u0001O!\ty%+D\u0001Q\u0015\t\t\u0006(\u0001\u0006sKB|7/\u001b;pefL!a\u0015)\u0003%\u0011+G.\u001b<fef\u0014V\r]8tSR|'/_\u0001\u0014I\u0016d\u0017N^3ssJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JLX#A,\u0011\u0005aSV\"A-\u000b\u0005ES\u0014BA.Z\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\u0013e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\b%\u0001\bsK2,\u0017m]3TKJ4\u0018nY3\u0016\u0003}\u0003\"\u0001\u00192\u000e\u0003\u0005T!a\u000e\u001e\n\u0005\r\f'A\u0004*fY\u0016\f7/Z*feZL7-Z\u0001\u0010e\u0016dW-Y:f'\u0016\u0014h/[2fA\u0005Y1-[%e'\u0016\u0014h/[2f+\u00059\u0007C\u00011i\u0013\tI\u0017MA\u0006DS&#7+\u001a:wS\u000e,\u0017\u0001D2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\u0013\u0001E1sG\"Lg/\u001a3SK2,\u0017m]3t+\u0005i\u0007C\u00018r\u001b\u0005y'B\u00019;\u0003\t!'-\u0003\u0002s_\n\u0001\u0012I]2iSZ,GMU3mK\u0006\u001cXm]\u0001\u0012CJ\u001c\u0007.\u001b<fIJ+G.Z1tKN\u0004\u0013!\u00044pY\u0012,'oU3sm&\u001cW-F\u0001w!\t\u0001w/\u0003\u0002yC\niai\u001c7eKJ\u001cVM\u001d<jG\u0016\faBZ8mI\u0016\u00148+\u001a:wS\u000e,\u0007%A\u0006s_2,7+\u001a:wS\u000e,W#\u0001?\u0011\u0007u\f)!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\tg\u0016\u001cWO]5us*\u0019\u00111\u0001\u001f\u0002\u0011\u0011,\u0007\u000f\\8zSRL1!a\u0002\u007f\u0005-\u0011v\u000e\\3TKJ4\u0018nY3\u0002\u0019I|G.Z*feZL7-\u001a\u0011\u0002\u0011\u00154XM\u001c;CkN,\"!a\u0004\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006;\u0003\u0019)g/\u001a8ug&!\u0011\u0011DA\n\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\nKZ,g\u000e\u001e\"vg\u0002\na\u0001P5oSRtDCEA\u0011\u0003G\t)#a\n\u0002*\u0005-\u0012QFA\u0018\u0003c\u0001\"!\u0013\u0001\t\u000b1\u000b\u0002\u0019\u0001(\t\u000bU\u000b\u0002\u0019A,\t\u000bu\u000b\u0002\u0019A0\t\u000b\u0015\f\u0002\u0019A4\t\u000b-\f\u0002\u0019A7\t\u000bQ\f\u0002\u0019\u0001<\t\u000bi\f\u0002\u0019\u0001?\t\u000f\u0005-\u0011\u00031\u0001\u0002\u0010!\u001a\u0011#!\u000e\u0011\t\u0005]\u0012QJ\u0007\u0003\u0003sQA!a\u000f\u0002>\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005}\u0012\u0011I\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\t\u0019%!\u0012\u0002\u000b\t,\u0017M\\:\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u00111J\u0001\u0004_J<\u0017\u0002BA(\u0003s\u0011\u0011\"Q;u_^L'/\u001a3\u0002'\u0011+e)Q+M)~\u001bF+Q$F?RKE\u000bT#\u0016\u0005\u0005UsBAA,C\t\tI&A\u0005OK^\u00043\u000b^1hK\u0006!B)\u0012$B+2#vl\u0015+B\u000f\u0016{F+\u0013+M\u000b\u0002\n!bZ3u!\u0006$H/\u001a:o)\u0011\t\t'!\u001c\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001a9\u0003\u0019!w.\\1j]&!\u00111NA3\u0005!!U\r\\5wKJL\bbBA8)\u0001\u0007\u0011\u0011O\u0001\na\u0006$H/\u001a:o\u0013\u0012\u0004B!a\u001d\u0002\u0002:!\u0011QOA?!\r\t9\bR\u0007\u0003\u0003sR1!a\u001fA\u0003\u0019a$o\\8u}%\u0019\u0011q\u0010#\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019)!\"\u0003\rM#(/\u001b8h\u0015\r\ty\b\u0012\u0015\u0004)\u0005%\u0005\u0003BAF\u0003/k!!!$\u000b\t\u0005m\u0012q\u0012\u0006\u0005\u0003#\u000b\u0019*A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005Ue(\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\tI*!$\u0003\u000bQKW.\u001a3\u0002+\u001d,G\u000fU1ui\u0016\u0014hNQ=JI>\u0013H+\u001b;mKR!\u0011\u0011MAP\u0011\u001d\t\t+\u0006a\u0001\u0003c\n\u0001\u0003]1ui\u0016\u0014h.\u00133PeRKG\u000f\\3)\u0007U\tI)\u0001\ffq&\u001cHo\u001d)biR,'O\\,ji\"$\u0016\u000e\u001e7f)\u0019\tI+a,\u00024B\u00191)a+\n\u0007\u00055FIA\u0004C_>dW-\u00198\t\u000f\u0005Ef\u00031\u0001\u0002r\u0005\u0011\u0011\u000e\u001a\u0005\b\u0003k3\u0002\u0019AA9\u0003\u0015!\u0018\u000e\u001e7fQ\r1\u0012\u0011R\u0001\u000eKbL7\u000f^:QCR$XM\u001d8\u0015\t\u0005%\u0016Q\u0018\u0005\b\u0003\u007f;\u0002\u0019AA9\u0003)!W\r\\5wKJL\u0018\n\u001a\u0015\u0004/\u0005%\u0015!F2sK\u0006$X\rR3mSZ,'/\u001f)biR,'O\u001c\u000b\u0005\u0003C\n9\rC\u0004\u0002Jb\u0001\r!!\u0019\u0002\u000fA\fG\u000f^3s]\"\u001a\u0001$!#\u0002+U\u0004H-\u0019;f\t\u0016d\u0017N^3ssB\u000bG\u000f^3s]R!\u0011\u0011MAi\u0011\u001d\t\u0019.\u0007a\u0001\u0003C\nq!\u001e9eCR,G\rK\u0002\u001a\u0003\u0013\u000bQ\u0003Z3mKR,G)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014h\u000e\u0006\u0003\u0002\\\u0006\u0005\bcA\"\u0002^&\u0019\u0011q\u001c#\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003_R\u0002\u0019AA9Q\rQ\u0012\u0011R\u0001\u0019IV\u0004H.[2bi\u0016$U\r\\5wKJL\b+\u0019;uKJtGCBA1\u0003S\fY\u000fC\u0004\u0002pm\u0001\r!!\u001d\t\u000f\u000558\u00041\u0001\u0002p\u00061\u0001/\u0019:b[N\u0004B!!=\u0002\u00006\u0011\u00111\u001f\u0006\u0005\u0003k\f90A\u0003g_Jl7O\u0003\u0003\u0002z\u0006m\u0018A\u0001<2\u0015\r\tiPO\u0001\u0004CBL\u0017\u0002\u0002B\u0001\u0003g\u0014\u0001\u0004R;qY&\u001c\u0017\r^3EK2Lg/\u001a:z!\u0006$H/\u001a:oQ\rY\u0012\u0011R\u0001\u001aGJ,\u0017\r^3EK2Lg/\u001a:z\rJ|W\u000eU1ui\u0016\u0014h\u000e\u0006\u0004\u0002b\t%!1\u0002\u0005\b\u0003_b\u0002\u0019AA9\u0011\u001d\u0011i\u0001\ba\u0001\u0005\u001f\t!\u0002]1sC6,G/\u001a:t!\u0011\t\tP!\u0005\n\t\tM\u00111\u001f\u0002\u000f\u0007J,\u0017\r^3EK2Lg/\u001a:zQ\ra\u0012\u0011R\u0001\u000fg\u0016\f'o\u00195QCR$XM\u001d8t)\u0019\u0011YBa\u000b\u00036A1!Q\u0004B\u0014\u0003Cj!Aa\b\u000b\t\t\u0005\"1E\u0001\u0005kRLGN\u0003\u0002\u0003&\u0005!!.\u0019<b\u0013\u0011\u0011ICa\b\u0003\t1K7\u000f\u001e\u0005\b\u0005[i\u0002\u0019\u0001B\u0018\u0003\u001d1\u0017\u000e\u001c;feN\u0004B!!=\u00032%!!1GAz\u0005Y!U\r\\5wKJL\b+\u0019;uKJtg)\u001b7uKJ\u001c\bb\u0002B\u001c;\u0001\u0007!\u0011H\u0001\u0005a\u0006<W\rE\u0002Y\u0005wI1A!\u0010Z\u0005\u0011\u0001\u0016mZ3)\u0007u\tI)A\u0005hKR\u001cF/Y4fgR!!Q\tB'!\u0019\u0011iBa\n\u0003HA!\u00111\rB%\u0013\u0011\u0011Y%!\u001a\u0003\u000bM#\u0018mZ3\t\u000f\u0005=d\u00041\u0001\u0002r!\u001aa$!#\u0002\u0011\u0005$Gm\u0015;bO\u0016$bAa\u0012\u0003V\t]\u0003bBA8?\u0001\u0007\u0011\u0011\u000f\u0005\b\u00053z\u0002\u0019\u0001B$\u0003\u0015\u0019H/Y4fQ\ry\u0012\u0011\u0012\u000b\u0007\u0005\u000f\u0012yF!\u0019\t\u000f\u0005%\u0007\u00051\u0001\u0002b!9!\u0011\f\u0011A\u0002\t\u001d\u0003f\u0001\u0011\u0002\n\u0006YQ\u000f\u001d3bi\u0016\u001cF/Y4f)\u0019\u00119E!\u001b\u0003l!9\u0011qN\u0011A\u0002\u0005E\u0004bBAjC\u0001\u0007!q\t\u0015\u0004C\u0005%\u0015a\u00033fY\u0016$Xm\u0015;bO\u0016$b!a7\u0003t\tU\u0004bBA8E\u0001\u0007\u0011\u0011\u000f\u0005\b\u0005o\u0012\u0003\u0019AA9\u0003\u001d\u0019H/Y4f\u0013\u0012D3AIAE\u00035\tG\r\u001a+sC:\u001c\u0018\u000e^5p]RA!q\u0010BC\u0005\u000f\u0013Y\t\u0005\u0003\u0002d\t\u0005\u0015\u0002\u0002BB\u0003K\u0012!\u0002\u0016:b]NLG/[8o\u0011\u001d\tyg\ta\u0001\u0003cBqA!#$\u0001\u0004\t\t(\u0001\bti\u0006<W-\u00133PeRKG\u000f\\3\t\u000f\t55\u00051\u0001\u0003\u0000\u0005QAO]1og&$\u0018n\u001c8)\u0007\r\nI\t\u0006\u0005\u0003\u0000\tM%Q\u0013BL\u0011\u001d\tI\r\na\u0001\u0003CBqA!#%\u0001\u0004\t\t\bC\u0004\u0003\u000e\u0012\u0002\rAa )\u0007\u0011\nI)\u0001\tva\u0012\fG/\u001a+sC:\u001c\u0018\u000e^5p]R1!q\u0010BP\u0005CCq!a\u001c&\u0001\u0004\t\t\bC\u0004\u0002T\u0016\u0002\rAa )\u0007\u0015\nI\t\u0006\u0004\u0003\u0000\t\u001d&\u0011\u0016\u0005\b\u0003\u00134\u0003\u0019AA1\u0011\u001d\t\u0019N\na\u0001\u0005\u007fB3AJAE\u0003A!W\r\\3uKR\u0013\u0018M\\:ji&|g\u000e\u0006\u0004\u0002\\\nE&1\u0017\u0005\b\u0003_:\u0003\u0019AA9\u0011\u001d\u0011)l\na\u0001\u0003c\nA\u0002\u001e:b]NLG/[8o\u0013\u0012D3aJAE\u0003a9WM\\3sCR,G+\u001b;mK&3g*Z2fgN\f'/\u001f\u000b\u0007\u00037\u0014iLa0\t\u000f\te\u0003\u00061\u0001\u0003H!9!\u0011\u0019\u0015A\u0002\t\r\u0017AB:uC\u001e,7\u000f\u0005\u0004\u0003F\n='q\t\b\u0005\u0005\u000f\u0014YM\u0004\u0003\u0002x\t%\u0017\"A#\n\u0007\t5G)A\u0004qC\u000e\\\u0017mZ3\n\t\tE'1\u001b\u0002\u0004'\u0016\f(b\u0001Bg\t\u0006q1\r[3dW&\u001b\b+\u0019;uKJtG\u0003BAn\u00053Da!O\u0015A\u0002\u0005\u0005\u0014a\u0004<bY&$\u0017\r^3QCR$XM\u001d8\u0015\t\u0005m'q\u001c\u0005\u0007s)\u0002\r!!\u0019\u0002IY\fG.\u001b3bi\u0016\u001cF/Y4fg\u0006sG\r\u0016:b]NLG/[8og\u0006sG-\u0013;f[N$B!a7\u0003f\"9\u0011\u0011Z\u0016A\u0002\u0005\u0005\u0014\u0001\u0005<bY&$\u0017\r^3OK^\u001cF/Y4f)!\tYNa;\u0003n\n=\bbBAeY\u0001\u0007\u0011\u0011\r\u0005\b\u00053b\u0003\u0019\u0001B$\u0011\u001d\u0011\t\r\fa\u0001\u0005\u0007\fqC^1mS\u0012\fG/Z*uC\u001e,\u0007K]8qKJ$\u0018.Z:\u0015\r\u0005m'Q\u001fB|\u0011\u001d\tI-\fa\u0001\u0003CBqA!\u0017.\u0001\u0004\u00119%\u0001\u0007sKN,G\u000fU1ui\u0016\u0014h\u000e\u0006\u0004\u0002\\\nu(q \u0005\b\u0003\u0013t\u0003\u0019AA1\u0011%\u0019\tA\fI\u0001\u0002\u0004\tI+A\u0006g_J\u001cWMT3x\u0013\u0012\u001c\u0018A\u0006:fg\u0016$\b+\u0019;uKJtG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r\u001d!\u0006BAU\u0007\u0013Y#aa\u0003\u0011\t\r51QC\u0007\u0003\u0007\u001fQAa!\u0005\u0004\u0014\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003w!\u0015\u0002BB\f\u0007\u001f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0011Xm]3u\u0007>tG-\u001b;j_:$b!a7\u0004\u001e\r}\u0001b\u0002BGa\u0001\u0007!q\u0010\u0005\b\u0007C\u0001\u0004\u0019AB\u0012\u0003%\u0019wN\u001c3ji&|g\u000e\u0005\u0003\u0002d\r\u0015\u0012\u0002BB\u0014\u0003K\u0012\u0011bQ8oI&$\u0018n\u001c8\u0002%\u001d,g.\u001a:bi\u0016|%/\u00169eCR,\u0017\nZ\u000b\u0005\u0007[\u0019)\u0005\u0006\u0006\u00040\r]31LB0\u0007G\"B!!\u001d\u00042!I11G\u0019\u0002\u0002\u0003\u000f1QG\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004CBB\u001c\u0007{\u0019\t%\u0004\u0002\u0004:)\u001911\b#\u0002\u000fI,g\r\\3di&!1qHB\u001d\u0005!\u0019E.Y:t)\u0006<\u0007\u0003BB\"\u0007\u000bb\u0001\u0001B\u0004\u0004HE\u0012\ra!\u0013\u0003\u0003Q\u000bBaa\u0013\u0004RA\u00191i!\u0014\n\u0007\r=CIA\u0004O_RD\u0017N\\4\u0011\u0007\r\u001b\u0019&C\u0002\u0004V\u0011\u00131!\u00118z\u0011\u001d\u0019I&\ra\u0001\u0003c\n!\"\u001a=jgRLgnZ%e\u0011\u001d\u0019i&\ra\u0001\u0003c\n1b\u001c7e!\u0006\u0014XM\u001c;JI\"91\u0011M\u0019A\u0002\u0005E\u0014a\u00038foB\u000b'/\u001a8u\u0013\u0012Dqa!\u00012\u0001\u0004\tI+\u0001\u000bbYJ,\u0017\rZ=Fq&\u001cHo\u001d\"z)&$H.\u001a\u000b\u0007\u0003S\u001bIg!\u001c\t\u000f\r-$\u00071\u0001\u0002r\u0005a\u0001/\u0019;uKJtG+\u001b;mK\"I\u0011q\u000e\u001a\u0011\u0002\u0003\u0007\u0011\u0011O\u0001\u001fC2\u0014X-\u00193z\u000bbL7\u000f^:CsRKG\u000f\\3%I\u00164\u0017-\u001e7uII*\"aa\u001d+\t\u0005E4\u0011B\u0001\u0011G\",7m[%t+B$\u0017\r^1cY\u0016$b!a7\u0004z\ru\u0004bBB>i\u0001\u0007\u0011\u0011M\u0001\u0011KbL7\u000f^5oO\u0012+G.\u001b<fefD\u0011ba 5!\u0003\u0005\r!!\u001d\u0002\r\u0005\u001cG/[8oQ\r\u000111\u0011\t\u0005\u0007\u000b\u001bY)\u0004\u0002\u0004\b*!1\u0011RA#\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0007\u001b\u001b9IA\u0004TKJ4\u0018nY3")
public class DeliveryPatternService
implements DeliveryServiceUtils {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private final DeliveryObjectFactory factory;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String checkIsUpdatable$default$2() {
        return DeliveryServiceUtils.checkIsUpdatable$default$2$(this);
    }

    @Override
    @Timed
    public Delivery getDeliveryOrPattern(String deliveryId) {
        return DeliveryServiceUtils.getDeliveryOrPattern$(this, deliveryId);
    }

    @Override
    @Timed
    public String getFolderId(String deliveryId) {
        return DeliveryServiceUtils.getFolderId$(this, deliveryId);
    }

    @Override
    public Delivery doUpdate(Delivery updated) {
        return DeliveryServiceUtils.doUpdate$(this, updated);
    }

    @Override
    public void doDelete(String deliveryId) {
        DeliveryServiceUtils.doDelete$(this, deliveryId);
    }

    @Override
    public void validate(Delivery delivery) {
        DeliveryServiceUtils.validate$(this, delivery);
    }

    @Override
    public void validateDelivery(Delivery delivery) {
        DeliveryServiceUtils.validateDelivery$(this, delivery);
    }

    @Override
    public void validateTransition(Delivery delivery, Stage stage, Transition transition) {
        DeliveryServiceUtils.validateTransition$(this, delivery, stage, transition);
    }

    @Override
    public void checkIsDelivery(Delivery delivery) {
        DeliveryServiceUtils.checkIsDelivery$(this, delivery);
    }

    @Override
    public Iterable<String> currentPrincipals() {
        return DeliveryServiceUtils.currentPrincipals$(this);
    }

    @Override
    public Buffer<String> currentRoleIds() {
        return DeliveryServiceUtils.currentRoleIds$(this);
    }

    @Override
    public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        DeliveryServiceUtils.computeAndUpdateDates$(this, delivery, durationOpt, startDateOpt, endDateOpt);
    }

    @Override
    public int computeAndUpdateDates$default$2() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$2$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$3() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$3$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$4() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$4$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public DeliveryObjectFactory factory() {
        return this.factory;
    }

    @Override
    public void com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(DeliveryObjectFactory x$1) {
        this.factory = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryPatternService deliveryPatternService = this;
        synchronized (deliveryPatternService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public DeliveryRepository deliveryRepository() {
        return this.deliveryRepository;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    @Override
    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public FolderService folderService() {
        return this.folderService;
    }

    @Override
    public RoleService roleService() {
        return this.roleService;
    }

    @Override
    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    public final String DEFAULT_STAGE_TITLE() {
        return "New Stage";
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPattern(String patternId) {
        void var2_2;
        Delivery pattern = this.getDeliveryOrPattern(patternId);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPatternByIdOrTitle(String patternIdOrTitle) {
        void var3_6;
        Delivery delivery;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.getDeliveryOrPattern(patternIdOrTitle));
        if (try_ instanceof Success) {
            Delivery value;
            Success success = (Success)try_;
            delivery = value = (Delivery)((Object)success.value());
        } else if (try_ instanceof Failure) {
            delivery = this.deliveryRepository().findPatternByTitle(patternIdOrTitle);
        } else {
            throw new MatchError((Object)try_);
        }
        Delivery pattern = delivery;
        this.checkIsPattern(pattern);
        return var3_6;
    }

    @Timed
    public boolean existsPatternWithTitle(String id, String title) {
        return this.alreadyExistsByTitle(title, id);
    }

    @Timed
    public boolean existsPattern(String deliveryId) {
        return this.deliveryRepository().exists(deliveryId);
    }

    @Timed
    public Delivery createDeliveryPattern(Delivery pattern) {
        Checks.checkNotNull((Object)((Object)pattern), (String)"Release delivery");
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Creating new delivery pattern '").append((Object)pattern).append("'").toString());
        pattern.setStatus(DeliveryStatus.TEMPLATE);
        this.validatePattern(pattern);
        this.resetPattern(pattern, this.resetPattern$default$2());
        if (pattern.getStages().isEmpty()) {
            Stage defaultStage = new Stage("New Stage");
            defaultStage.setId(this.factory().stageId(pattern.getId()));
            pattern.addStage(defaultStage);
        }
        this.validateStagesAndTransitionsAndItems(pattern);
        this.deliveryRepository().create(pattern);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(pattern));
        return pattern;
    }

    @Timed
    public Delivery updateDeliveryPattern(Delivery updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Updating delivery pattern '").append((Object)updated).append("'").toString());
        this.validatePattern(updated);
        return this.doUpdate(updated);
    }

    @Timed
    public void deleteDeliveryPattern(String patternId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Deleting release delivery pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.deliveryRepository().read(patternId);
        this.checkIsPattern(pattern);
        this.doDelete(patternId);
    }

    @Timed
    public Delivery duplicateDeliveryPattern(String patternId, DuplicateDeliveryPattern params) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Duplicating delivery pattern '").append(patternId).append("' with parameters '").append(params).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.resetPattern(pattern, true);
        if (params.hasDescription()) {
            pattern.setDescription(params.getDescription());
        }
        if (params.hasTitle()) {
            pattern.setTitle(params.getTitle());
        } else {
            Option option;
            Regex regExp = new StringOps(Predef$.MODULE$.augmentString("\\(([0-9]+)\\)$")).r();
            String[] c = regExp.split((CharSequence)pattern.getTitle());
            if (((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])c)).head()).length() == pattern.getTitle().length()) {
                pattern.setTitle(new StringBuilder(4).append(pattern.getTitle()).append(" (0)").toString());
            }
            if ((option = regExp.findFirstIn((CharSequence)pattern.getTitle())) instanceof Some) {
                Some some = (Some)option;
                String value = (String)some.value();
                int orderNumber = new StringOps(Predef$.MODULE$.augmentString(value.substring(1, value.length() - 1))).toInt();
                do {
                    String newTitle = regExp.replaceAllIn((CharSequence)pattern.getTitle(), new StringBuilder(2).append("(").append(((Object)BoxesRunTime.boxToInteger((int)(++orderNumber))).toString()).append(")").toString());
                    pattern.setTitle(newTitle);
                } while (this.alreadyExistsByTitle(pattern.getTitle(), pattern.getId()) && orderNumber < 100);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
        this.validatePattern(pattern);
        this.deliveryRepository().create(pattern);
        Delivery duplicatedPattern = this.deliveryRepository().read(pattern.getId());
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(duplicatedPattern));
        return duplicatedPattern;
    }

    @Timed
    public Delivery createDeliveryFromPattern(String patternId, CreateDelivery parameters) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Creating new delivery from pattern '").append(patternId).append("' with parameters '").append(parameters).append("'").toString());
        Delivery delivery = this.getPattern(patternId);
        this.resetPattern(delivery, this.resetPattern$default$2());
        delivery.setTitle(parameters.getTitle());
        delivery.setDescription(parameters.getDescription());
        delivery.setOriginPatternId(patternId);
        this.computeAndUpdateDates(delivery, parameters.getDuration(), parameters.getStartDate(), parameters.getEndDate());
        Checks.checkArgument((delivery.getStages() != null && !delivery.getStages().isEmpty() ? 1 : 0) != 0, (String)"Cannot create delivery from pattern without stages", (Object[])new Object[0]);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService());
        Delivery startedDelivery = manager.start();
        this.validateDelivery(startedDelivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatingEvent(startedDelivery));
        this.deliveryRepository().create(startedDelivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(startedDelivery));
        manager.getEvents().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            DeliveryPatternService.$anonfun$createDeliveryFromPattern$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        return startedDelivery;
    }

    @Timed
    public List<Delivery> searchPatterns(DeliveryPatternFilters filters, Page page) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.deliveryRepository().search(filters, page, null, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), (Seq<Permission>)((Seq)Seq$.MODULE$.apply(DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PATTERN_PERMISSION_SET())))).asJava();
    }

    @Timed
    public List<Stage> getStages(String patternId) {
        return this.getPattern(patternId).getStages();
    }

    @Timed
    public Stage addStage(String patternId, Stage stage) {
        return this.addStage(this.getPattern(patternId), stage);
    }

    @Timed
    public Stage addStage(Delivery pattern, Stage stage) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Adding new stage '").append((Object)stage).append("' to pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Buffer stages = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala();
        this.generateTitleIfNecessary(stage, (Seq<Stage>)stages);
        this.validateNewStage(pattern, stage, (Seq<Stage>)stages);
        stage.setId(this.factory().stageId(pattern.getId()));
        stage.setStatus(StageStatus.OPEN);
        stage.setTransition(null);
        stage.setItems(Collections.emptyList());
        pattern.addStage(stage, stages.size());
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageCreatedEvent(stage, pattern));
        return stage;
    }

    @Timed
    public Stage updateStage(String patternId, Stage updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Updating stage '").append((Object)updated).append("' on pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        this.validateNewStage(pattern, updated, (Seq<Stage>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala()));
        Stage original = pattern.getStageByIdOrTitle(updated.getId());
        original.setTitle(updated.getTitle());
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageUpdatedEvent(updated, pattern));
        return original;
    }

    @Timed
    public void deleteStage(String patternId, String stageId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Removing stage '").append(stageId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Stage stage = pattern.getStageByIdOrTitle(stageId);
        if (pattern.isLastStage(stage)) {
            pattern.findPreviousStage(stage).ifPresent(x$1 -> x$1.setTransition(null));
        }
        pattern.removeStage(stage);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageRemovedEvent(stage, pattern));
    }

    @Timed
    public Transition addTransition(String patternId, String stageIdOrTitle, Transition transition) {
        return this.addTransition(this.getPattern(patternId), stageIdOrTitle, transition);
    }

    @Timed
    public Transition addTransition(Delivery pattern, String stageIdOrTitle, Transition transition) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Adding new transition '").append((Object)transition).append("' to pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Stage stage = pattern.getStageByIdOrTitle(stageIdOrTitle);
        this.validateTransition(pattern, stage, transition);
        Checks.checkArgument((stage.getTransition() == null ? 1 : 0) != 0, (String)new StringBuilder(63).append("There is already a transition named '").append(transition.getTitle()).append("' associated with stage '").append(stage.getTitle()).append("'").toString(), (Object[])new Object[0]);
        transition.setId(this.factory().transitionId(stage.getId()));
        transition.getAllConditions().forEach(x$2 -> this.resetCondition(transition, (Condition)((Object)x$2)));
        stage.setTransition(transition);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionCreatedEvent(transition, pattern));
        return transition;
    }

    @Timed
    public Transition updateTransition(String patternId, Transition updated) {
        return this.updateTransition(this.getPattern(patternId), updated);
    }

    @Timed
    public Transition updateTransition(Delivery pattern, Transition updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Updating transition '").append((Object)updated).append("' on pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Checks.checkNotNull((Object)((Object)updated), (String)"Transition");
        Stage stage = pattern.getStageByTransition(updated);
        Transition original = stage.getTransition();
        this.validateTransition(pattern, stage, updated);
        updated.getAllConditions().forEach(x$3 -> this.resetCondition(updated, (Condition)((Object)x$3)));
        stage.setTransition(updated);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionUpdatedEvent(original, updated, pattern));
        return updated;
    }

    @Timed
    public void deleteTransition(String patternId, String transitionId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Removing transition '").append(transitionId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Transition transition = pattern.getTransitionByIdOrTitle(transitionId);
        pattern.getStageByTransition(transition).setTransition(null);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionRemovedEvent(transition, pattern));
    }

    private void generateTitleIfNecessary(Stage stage, Seq<Stage> stages) {
        block1: {
            Checks.checkNotNull((Object)((Object)stage), (String)"Stage");
            if (stage.getTitle() != null) break block1;
            IntRef index = IntRef.create((int)0);
            while (stages.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$generateTitleIfNecessary$1(index, x$4)))) {
                ++index.elem;
            }
            stage.setTitle(DeliveryPatternService.title$1(index));
        }
    }

    private void checkIsPattern(Delivery delivery) {
        Checks.checkArgument((boolean)delivery.isTemplate(), (String)new StringBuilder(27).append(delivery.getId()).append(" must be a Delivery Pattern").toString(), (Object[])new Object[0]);
    }

    private void validatePattern(Delivery delivery) {
        this.validate(delivery);
        this.checkIsPattern(delivery);
        Checks.checkArgument((Predef$.MODULE$.Integer2int(delivery.getPlannedDuration()) <= 73755 ? 1 : 0) != 0, (String)"Duration must be equal or less than 99 months 99 days 99 hours (73755 hours)", (Object[])new Object[0]);
        Checks.checkArgument((!this.alreadyExistsByTitle(delivery.getTitle(), delivery.getId()) ? 1 : 0) != 0, (String)new StringBuilder(36).append("Pattern with title '").append(delivery.getTitle()).append("' already exists").toString(), (Object[])new Object[0]);
    }

    private void validateStagesAndTransitionsAndItems(Delivery pattern) {
        pattern.getStages().forEach(stage -> {
            this.validateStageProperties(pattern, (Stage)((Object)stage));
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable & scala.Serializable)t -> {
                this.validateTransition(pattern, stage, t);
                return BoxedUnit.UNIT;
            });
        });
        Buffer stageTitles = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getTitle(), Buffer$.MODULE$.canBuildFrom());
        Buffer duplicateStages = (Buffer)((SeqLike)stageTitles.diff((GenSeq)stageTitles.distinct())).distinct();
        Checks.checkArgument((boolean)duplicateStages.isEmpty(), (String)new StringBuilder(58).append("Stages with duplicate titles [").append(duplicateStages.mkString(", ")).append("] are not allowed in pattern").toString(), (Object[])new Object[0]);
        Buffer trackedItemTitles = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getTrackedItems()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getTitle().toLowerCase(), Buffer$.MODULE$.canBuildFrom());
        Buffer duplicateItems = (Buffer)((SeqLike)trackedItemTitles.diff((GenSeq)trackedItemTitles.distinct())).distinct();
        Checks.checkArgument((boolean)duplicateItems.isEmpty(), (String)new StringBuilder(65).append("Tracked items with duplicate titles [").append(duplicateItems.mkString(", ")).append("] are not allowed in pattern").toString(), (Object[])new Object[0]);
    }

    private void validateNewStage(Delivery pattern, Stage stage, Seq<Stage> stages) {
        this.validateStageProperties(pattern, stage);
        Checks.checkArgument((stages.count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$validateNewStage$1(stage, x$7))) == 0 ? 1 : 0) != 0, (String)"Stage title already exists in delivery pattern", (Object[])new Object[0]);
    }

    private void validateStageProperties(Delivery pattern, Stage stage) {
        Checks.checkNotNull((Object)((Object)stage), (String)"Stage");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)stage.getTitle()), (String)"Stage title must be set", (Object[])new Object[0]);
        Checks.checkArgument((stage.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Stage title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!stage.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
    }

    private void resetPattern(Delivery pattern, boolean forceNewIds) {
        Date resetDate = new Date();
        String oldDeliveryId = pattern.getId();
        String newDeliveryId = this.factory().deliveryId();
        pattern.setId(newDeliveryId);
        pattern.getStages().forEach(stage -> {
            String oldStageId = stage.getId();
            String newStageId = this.generateOrUpdateId(oldStageId, oldDeliveryId, newDeliveryId, forceNewIds, ClassTag$.MODULE$.apply(Stage.class));
            stage.setId(newStageId);
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable & scala.Serializable)transition -> {
                DeliveryPatternService.$anonfun$resetPattern$2(this, oldStageId, newStageId, forceNewIds, stage, transition);
                return BoxedUnit.UNIT;
            });
        });
        pattern.getTrackedItems().forEach(item -> {
            item.setId(this.factory().trackedItemId(newDeliveryId));
            item.setCreatedDate(resetDate);
            item.setModifiedDate(resetDate);
        });
    }

    private boolean resetPattern$default$2() {
        return false;
    }

    private void resetCondition(Transition transition, Condition condition) {
        condition.setId(this.generateOrUpdateId(condition.getId(), transition.getId(), transition.getId(), false, ClassTag$.MODULE$.apply(Condition.class)));
        condition.reset();
    }

    private <T> String generateOrUpdateId(String existingId, String oldParentId, String newParentId, boolean forceNewIds, ClassTag<T> evidence$1) {
        String typeName = Type.valueOf((Class)((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass()).getName();
        boolean idNotDefined = existingId == null || existingId.trim().isEmpty() || !Ids.getName((String)existingId).startsWith(typeName);
        return forceNewIds || idNotDefined ? this.factory().createUniqueId(newParentId, evidence$1) : existingId.replace((CharSequence)Option$.MODULE$.apply((Object)oldParentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (CharSequence)Option$.MODULE$.apply((Object)newParentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
    }

    private boolean alreadyExistsByTitle(String patternTitle, String patternId) {
        DeliveryPatternFilters filters = new DeliveryPatternFilters();
        filters.withTitle(patternTitle);
        filters.withStrictTitleMatch(true);
        return this.deliveryRepository().searchIds(filters).exists((Function1 & Serializable & scala.Serializable)deliveryId -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$alreadyExistsByTitle$1(patternId, deliveryId)));
    }

    private String alreadyExistsByTitle$default$2() {
        return null;
    }

    @Override
    public void checkIsUpdatable(Delivery existingDelivery, String action) {
        existingDelivery.isTemplate();
    }

    public static final /* synthetic */ void $anonfun$createDeliveryFromPattern$2(DeliveryPatternService $this, XLReleaseEvent x$1) {
        $this.eventBus().publish(x$1);
    }

    private static final String title$1(IntRef index$1) {
        return index$1.elem > 0 ? new StringBuilder(12).append("New Stage").append(" (").append(index$1.elem).append(")").toString() : "New Stage";
    }

    public static final /* synthetic */ boolean $anonfun$generateTitleIfNecessary$1(IntRef index$1, Stage x$4) {
        String string = x$4.getTitle().trim().toLowerCase();
        String string2 = DeliveryPatternService.title$1(index$1).toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateNewStage$1(Stage stage$3, Stage x$7) {
        String string = x$7.getTitle();
        String string2 = stage$3.getTitle();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$resetPattern$2(DeliveryPatternService $this, String oldStageId$1, String newStageId$1, boolean forceNewIds$1, Stage stage$4, Transition transition) {
        String oldTransitionId = transition.getId();
        String newTransitionId = $this.generateOrUpdateId(transition.getId(), oldStageId$1, newStageId$1, forceNewIds$1, ClassTag$.MODULE$.apply(Transition.class));
        transition.setId(newTransitionId);
        transition.setStage(stage$4);
        transition.getAllConditions().forEach(condition -> condition.setId($this.generateOrUpdateId(condition.getId(), oldTransitionId, newTransitionId, forceNewIds$1, ClassTag$.MODULE$.apply(Condition.class))));
    }

    public static final /* synthetic */ boolean $anonfun$alreadyExistsByTitle$1(String patternId$7, String deliveryId) {
        String string = Ids.getName((String)deliveryId);
        String string2 = Ids.getName((String)patternId$7);
        return string == null ? string2 != null : !string.equals(string2);
    }

    @Autowired
    public DeliveryPatternService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        DeliveryServiceUtils.$init$(this);
    }
}

