/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.packager.placeholders;

import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.util.BOM;
import com.xebialabs.deployit.util.DetectBOM$;
import com.xebialabs.deployit.util.TryWith$;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.xldeploy.packager.MustacheScanningReader;
import com.xebialabs.xldeploy.packager.Mustacher;
import com.xebialabs.xldeploy.packager.Mustacher$;
import com.xebialabs.xldeploy.packager.io.ArtifactIOUtils$;
import com.xebialabs.xldeploy.packager.io.StreamEntry;
import com.xebialabs.xldeploy.packager.io.Streamer;
import com.xebialabs.xldeploy.packager.io.StreamerFactory;
import com.xebialabs.xldeploy.packager.placeholders.DigestOnly$;
import com.xebialabs.xldeploy.packager.placeholders.PlaceholdersUtil$;
import com.xebialabs.xldeploy.packager.placeholders.ProcessArchive$;
import com.xebialabs.xldeploy.packager.placeholders.ProcessTextFile$;
import com.xebialabs.xldeploy.packager.placeholders.ProcessingType;
import com.xebialabs.xldeploy.packager.placeholders.SourceArtifactScanner$;
import com.xebialabs.xldeploy.packager.placeholders.StreamFile;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005]s!\u0002\n\u0014\u0011\u0003qb!\u0002\u0011\u0014\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003\u0002\u0003\u0016\u0002\u0005\u0004%\t!A\u0016\t\rQ\n\u0001\u0015!\u0003-\u0011!)\u0014A1A\u0005\u0002\u00051\u0004BB\u001f\u0002A\u0003%q\u0007\u0003\u0005?\u0003\t\u0007I\u0011A\u0001@\u0011\u00199\u0015\u0001)A\u0005\u0001\u001a!\u0001e\u0005\u0001I\u0011!I\u0015B!A!\u0002\u0013Q\u0005\"\u0002\u0015\n\t\u0003i\u0005\"\u0002)\n\t\u0003\t\u0006B\u0002=\nA\u0013%\u0011\u0010\u0003\u0005\u0002\f%\u0001K\u0011BA\u0007\u0011!\t\t#\u0003Q\u0005\n\u0005\r\u0002\u0002CA\u0017\u0013\u0001&I!a\f\t\u0011\u0005u\u0012\u0002)C\u0005\u0003\u007f\tQcU8ve\u000e,\u0017I\u001d;jM\u0006\u001cGoU2b]:,'O\u0003\u0002\u0015+\u0005a\u0001\u000f\\1dK\"|G\u000eZ3sg*\u0011acF\u0001\ta\u0006\u001c7.Y4fe*\u0011\u0001$G\u0001\tq2$W\r\u001d7ps*\u0011!dG\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001H\u0001\u0004G>l7\u0001\u0001\t\u0003?\u0005i\u0011a\u0005\u0002\u0016'>,(oY3BeRLg-Y2u'\u000e\fgN\\3s'\t\t!\u0005\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\ta\u0001\\8hO\u0016\u0014X#\u0001\u0017\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014!B:mMRR'\"A\u0019\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\r\u0018\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nq\u0001Z3w\u001dVdG.F\u00018!\tA4(D\u0001:\u0015\tQT#\u0001\u0002j_&\u0011A(\u000f\u0002\b\t\u00164h*\u001e7m\u0003!!WM\u001e(vY2\u0004\u0013!\u00043fm:+H\u000e\\,sSR,'/F\u0001A!\t\tU)D\u0001C\u0015\tQ4IC\u0001E\u0003\u0011Q\u0017M^1\n\u0005\u0019\u0013%AE(viB,Ho\u0015;sK\u0006lwK]5uKJ\fa\u0002Z3w\u001dVdGn\u0016:ji\u0016\u0014\be\u0005\u0002\nE\u0005y1\u000f\u001e:fC6,'OR1di>\u0014\u0018\u0010\u0005\u00029\u0017&\u0011A*\u000f\u0002\u0010'R\u0014X-Y7fe\u001a\u000b7\r^8ssR\u0011aj\u0014\t\u0003?%AQ!S\u0006A\u0002)\u000ba\"\u001a8sS\u000eD\u0017I\u001d;jM\u0006\u001cG\u000f\u0006\u0003S+\u0016l\u0007CA\u0012T\u0013\t!FE\u0001\u0003V]&$\b\"\u0002,\r\u0001\u00049\u0016AA:b!\tA6-D\u0001Z\u0015\tQ6,\u0001\u0005beRLg-Y2u\u0015\taV,A\u0002vI6T!AX0\u0002\u0007\u0005\u0004\u0018N\u0003\u0002aC\u00061\u0001\u000f\\;hS:T!AY\r\u0002\u0011\u0011,\u0007\u000f\\8zSRL!\u0001Z-\u0003\u001dM{WO]2f\u0003J$\u0018NZ1di\")a\r\u0004a\u0001O\u0006Q1\u000f\u001e:fC64\u0015\u000e\\3\u0011\u0007\rB'.\u0003\u0002jI\t1q\n\u001d;j_:\u0004\"aH6\n\u00051\u001c\"AC*ue\u0016\fWNR5mK\")a\u000e\u0004a\u0001_\u0006iQ.Z:tC\u001e,G)[4fgR\u00042a\t9s\u0013\t\tHEA\u0005Gk:\u001cG/[8oaA\u00111O^\u0007\u0002i*\u0011QoQ\u0001\tg\u0016\u001cWO]5us&\u0011q\u000f\u001e\u0002\u000e\u001b\u0016\u001c8/Y4f\t&<Wm\u001d;\u0002=\r\fGnY;mCR,\u0007\u000b\\1dK\"|G\u000eZ3sg\u0006sG\rR5hKN$HC\u0002*{wr\f)\u0001C\u0003W\u001b\u0001\u0007q\u000bC\u0003g\u001b\u0001\u0007q\rC\u0003~\u001b\u0001\u0007a0A\u0005nkN$\u0018m\u00195feB\u0019q0!\u0001\u000e\u0003UI1!a\u0001\u0016\u0005%iUo\u001d;bG\",'\u000fC\u0004\u0002\b5\u0001\r!!\u0003\u0002\u0013=\u0004H\u000fR5hKN$\bcA\u0012ie\u0006\u00112oY1o\r>dG-\u001a:BeRLg-Y2u)%\u0011\u0016qBA\r\u00037\ty\u0002C\u0004\u0002\u00129\u0001\r!a\u0005\u0002\u0005\u0019\f\u0007c\u0001-\u0002\u0016%\u0019\u0011qC-\u0003\u001d\u0019{G\u000eZ3s\u0003J$\u0018NZ1di\")aM\u0004a\u0001O\"9\u0011Q\u0004\bA\u0002\u0005%\u0011A\u00023jO\u0016\u001cH\u000fC\u0003~\u001d\u0001\u0007a0A\rtG\u0006tg)\u001b7f\u001fJ\f%o\u00195jm\u0016\f%\u000f^5gC\u000e$H#\u0003*\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0011\u00151v\u00021\u0001X\u0011\u00151w\u00021\u0001k\u0011\u001d\tib\u0004a\u0001\u0003\u0013AQ!`\bA\u0002y\f\u0001$\u001e9eCR,G)[4fgR<\u0016\u000e\u001e5GS2,g.Y7f)\u0015\u0011\u0016\u0011GA\u001e\u0011\u001d\t\u0019\u0004\u0005a\u0001\u0003k\tQ!\u001a8uef\u00042\u0001OA\u001c\u0013\r\tI$\u000f\u0002\f'R\u0014X-Y7F]R\u0014\u0018\u0010\u0003\u0004\u0002\u001eA\u0001\rA]\u0001\u0007I>\u001c6-\u00198\u0015\u0013I\u000b\t%a\u0011\u0002F\u0005\u001d\u0003\"\u0002,\u0012\u0001\u00049\u0006bBA\u001a#\u0001\u0007\u0011Q\u0007\u0005\u0006{F\u0001\rA \u0005\b\u0003\u0013\n\u0002\u0019AA&\u0003%!(/\u00198tM>\u0014X\u000eE\u0004$\u0003\u001b\n\t&!\u0015\n\u0007\u0005=CEA\u0005Gk:\u001cG/[8ocA\u0019\u0011)a\u0015\n\u0007\u0005U#IA\u0006J]B,Ho\u0015;sK\u0006l\u0007")
public class SourceArtifactScanner {
    private final StreamerFactory streamerFactory;

    public void enrichArtifact(SourceArtifact sa, Option<StreamFile> streamFile, Function0<MessageDigest> messageDigest) {
        if (!PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).shouldScanPlaceholders() && PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).hasCheckSum()) {
            SourceArtifactScanner$.MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Not enriching ").append(sa).append(" as no placeholders should be scanned and checksum is present").toString());
            return;
        }
        None$ digest = !PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).hasCheckSum() ? new Some(messageDigest.apply()) : None$.MODULE$;
        Mustacher mustacher = Mustacher$.MODULE$.apply(PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).mustacheDelimiters());
        this.calculatePlaceholdersAndDigest(sa, streamFile, mustacher, (Option<MessageDigest>)digest);
        sa.setPlaceholders((Set)JavaConverters$.MODULE$.setAsJavaSetConverter(mustacher.placeholders()).asJava());
        digest.foreach((Function1 & Serializable & scala.Serializable)d -> {
            sa.setProperty("checksum", (Object)Hex.encodeHexString((byte[])d.digest()));
            return BoxedUnit.UNIT;
        });
    }

    private void calculatePlaceholdersAndDigest(SourceArtifact sa, Option<StreamFile> streamFile, Mustacher mustacher, Option<MessageDigest> optDigest) {
        SourceArtifact sourceArtifact = sa;
        if (sourceArtifact instanceof FolderArtifact) {
            FolderArtifact folderArtifact = (FolderArtifact)sourceArtifact;
            SourceArtifactScanner$.MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Going to scan artifact ").append(folderArtifact).append(" as a folder artifact").toString());
            this.scanFolderArtifact(folderArtifact, streamFile, optDigest, mustacher);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (streamFile.isEmpty()) {
            SourceArtifactScanner$.MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Going to scan artifact ").append(sa).toString());
            TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> sa.getFile().getInputStream(), (Function1 & Serializable & scala.Serializable)fis -> {
                this.scanFileOrArchiveArtifact(sa, new StreamFile(sa.getFile().getName(), fis), (Option<MessageDigest>)optDigest, mustacher);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            SourceArtifactScanner$.MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Going to scan artifact ").append(sa).append(" from stream").toString());
            this.scanFileOrArchiveArtifact(sa, (StreamFile)streamFile.get(), optDigest, mustacher);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void scanFolderArtifact(FolderArtifact fa, Option<StreamFile> streamFile, Option<MessageDigest> digest, Mustacher mustacher) {
        Streamer streamer;
        Option<StreamFile> option = streamFile;
        if (option instanceof Some) {
            Some some = (Some)option;
            StreamFile x = (StreamFile)some.value();
            streamer = this.streamerFactory.streamer(x.inputStream(), x.name());
        } else if (None$.MODULE$.equals(option)) {
            streamer = this.streamerFactory.streamer(PlaceholdersUtil$.MODULE$.SourceArtifactUtil((SourceArtifact)fa).toLocalFile());
        } else {
            throw new MatchError(option);
        }
        Streamer streamer2 = streamer;
        streamer2.stream().foreach((Function1 & Serializable & scala.Serializable)entry -> {
            SourceArtifactScanner.$anonfun$scanFolderArtifact$1(this, digest, fa, mustacher, entry);
            return BoxedUnit.UNIT;
        });
    }

    private void scanFileOrArchiveArtifact(SourceArtifact sa, StreamFile streamFile, Option<MessageDigest> digest, Mustacher mustacher) {
        InputStream inputStream = (InputStream)digest.map((Function1 & Serializable & scala.Serializable)x$2 -> new DigestInputStream(streamFile.inputStream(), (MessageDigest)x$2)).getOrElse((Function0 & Serializable & scala.Serializable)() -> streamFile.inputStream());
        if (!PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).shouldScanPlaceholders()) {
            SourceArtifactScanner$.MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Artifact [").append(sa).append("] has disabled placeholder scanning").toString());
        } else {
            this.streamerFactory.streamer(inputStream, streamFile.name()).stream().foreach((Function1 & Serializable & scala.Serializable)entry -> {
                this.doScan(sa, entry, mustacher, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)x -> (InputStream)Predef$.MODULE$.identity(x));
                return BoxedUnit.UNIT;
            });
        }
        OverthereUtils.write((InputStream)inputStream, (OutputStream)SourceArtifactScanner$.MODULE$.devNull());
    }

    private void updateDigestWithFilename(StreamEntry entry, MessageDigest digest) {
        ObjectRef digestPath = ObjectRef.create((Object)new StringBuilder(0).append(entry.getPath()).append((Object)(entry.isDirectory() ? File.separator : "")).toString());
        digestPath.elem = ((String)digestPath.elem).replace("\\", "/");
        SourceArtifactScanner$.MODULE$.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("scanFolderArtifact: update digest with path [").append((String)digestPath$1.elem).append("]").toString());
        digest.update(((String)digestPath.elem).getBytes(StandardCharsets.UTF_8));
    }

    private void doScan(SourceArtifact sa, StreamEntry entry, Mustacher mustacher, Function1<InputStream, InputStream> transform) {
        if (entry.isDirectory()) {
            return;
        }
        TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> entry.getInputStream(), (Function1 & Serializable & scala.Serializable)inputStream -> {
            Try try_;
            InputStream is = (InputStream)transform.apply(inputStream);
            ProcessingType processingType = PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).getScanTypeForEntry(entry, $this.streamerFactory);
            if (DigestOnly$.MODULE$.equals(processingType)) {
                SourceArtifactScanner$.MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append(sa).append(": Skipping ").append(entry.getName()).toString());
                OverthereUtils.write((InputStream)is, (OutputStream)SourceArtifactScanner$.MODULE$.devNull());
                try_ = BoxedUnit.UNIT;
            } else if (ProcessArchive$.MODULE$.equals(processingType)) {
                SourceArtifactScanner$.MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append(sa).append(": Detected archive for ").append(entry.getName()).toString());
                $this.streamerFactory.streamer(is, entry.getName()).stream().foreach((Function1 & Serializable & scala.Serializable)e2 -> {
                    this.doScan(sa, e2, mustacher, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)x -> (InputStream)Predef$.MODULE$.identity(x));
                    return BoxedUnit.UNIT;
                });
                OverthereUtils.write((InputStream)is, (OutputStream)SourceArtifactScanner$.MODULE$.devNull());
                try_ = BoxedUnit.UNIT;
            } else if (ProcessTextFile$.MODULE$.equals(processingType)) {
                InputStreamReader inputStreamReader;
                SourceArtifactScanner$.MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append(sa).append(": ").append(entry.getName()).append(" is a text file.").toString());
                InputStream resettableInputStream = ArtifactIOUtils$.MODULE$.getResettableInputStream(is);
                BOM bOM = DetectBOM$.MODULE$.detect(resettableInputStream);
                if (((Object)((Object)BOM.NONE)).equals((Object)bOM)) {
                    inputStreamReader = new InputStreamReader(resettableInputStream);
                } else if (bOM != null) {
                    BOM bOM2 = bOM;
                    inputStreamReader = new InputStreamReader(resettableInputStream, bOM2.getCharset());
                } else {
                    throw new MatchError((Object)bOM);
                }
                InputStreamReader reader = inputStreamReader;
                try_ = TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> mustacher.newReader(reader), (Function1 & Serializable & scala.Serializable)r -> {
                    SourceArtifactScanner.$anonfun$doScan$9(r);
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError((Object)processingType);
            }
            return try_;
        });
    }

    public static final /* synthetic */ void $anonfun$scanFolderArtifact$1(SourceArtifactScanner $this, Option digest$1, FolderArtifact fa$1, Mustacher mustacher$2, StreamEntry entry) {
        digest$1.foreach((Function1 & Serializable & scala.Serializable)d -> {
            $this.updateDigestWithFilename(entry, d);
            return BoxedUnit.UNIT;
        });
        $this.doScan((SourceArtifact)fa$1, entry, mustacher$2, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> (InputStream)digest$1.map((Function1 & Serializable & scala.Serializable)x$1 -> new DigestInputStream((InputStream)is, (MessageDigest)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> is));
    }

    public static final /* synthetic */ void $anonfun$doScan$9(MustacheScanningReader r) {
        OverthereUtils.write((Reader)r, (Writer)SourceArtifactScanner$.MODULE$.devNullWriter());
    }

    public SourceArtifactScanner(StreamerFactory streamerFactory) {
        this.streamerFactory = streamerFactory;
    }
}

