/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import lombok.Generated;
import lombok.NonNull;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.lang.Nullable;

public class PersistentEntityInformation<T, ID>
implements EntityInformation<T, ID> {
    @NonNull
    private final PersistentEntity<T, ? extends PersistentProperty<?>> persistentEntity;

    @Override
    public boolean isNew(T entity) {
        return this.persistentEntity.isNew(entity);
    }

    @Override
    @Nullable
    public ID getId(T entity) {
        return (ID)this.persistentEntity.getIdentifierAccessor(entity).getIdentifier();
    }

    @Override
    public Class<T> getJavaType() {
        return this.persistentEntity.getType();
    }

    @Override
    public Class<ID> getIdType() {
        return this.persistentEntity.getRequiredIdProperty().getType();
    }

    @Generated
    public PersistentEntityInformation(@NonNull PersistentEntity<T, ? extends PersistentProperty<?>> persistentEntity) {
        if (persistentEntity == null) {
            throw new IllegalArgumentException("persistentEntity is marked @NonNull but is null");
        }
        this.persistentEntity = persistentEntity;
    }
}

