/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.AttachmentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.AttachmentService;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.CloseableUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001\u0002\r\u001a\u0001\tB\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\to\u0001\u0011\t\u0011)A\u0005g!A\u0001\b\u0001BC\u0002\u0013\u0005\u0011\b\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003;\u0011!q\u0004A!b\u0001\n\u0003y\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011\u001d\u0003!Q1A\u0005\u0002!C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\t\u001b\u0002\u0011)\u0019!C\u0001\u001d\"A!\u000b\u0001B\u0001B\u0003%q\n\u0003\u0005T\u0001\t\u0015\r\u0011\"\u0001U\u0011!A\u0006A!A!\u0002\u0013)\u0006\u0002C-\u0001\u0005\u000b\u0007I\u0011\u0001.\t\u0011\u0005\u0004!\u0011!Q\u0001\nmCQA\u0019\u0001\u0005\u0002\rDQa\u001f\u0001\u0005\u0002qDq!!\u000e\u0001\t\u0013\t9\u0004C\u0004\u0002<\u0001!I!!\u0010\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D!9\u0011Q\u0010\u0001\u0005\n\u0005}\u0004bBAG\u0001\u0011E\u0011q\u0012\u0005\b\u0003+\u0003A\u0011CAL\u0011\u001d\ty\n\u0001C\u0005\u0003C\u0013ac\u00115b]\u001e,W\t_3dkRLwN\\*feZL7-\u001a\u0006\u00035m\tqa]3sm&\u001cWM\u0003\u0002\u001d;\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003=}\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0001\n1aY8n\u0007\u0001\u00192\u0001A\u0012*!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fMB\u0011!fL\u0007\u0002W)\u0011A&L\u0001\u0006g24GG\u001b\u0006\u0002]\u0005AqM]5{u2,G-\u0003\u00021W\t9Aj\\4hS:<\u0017AD2p[6,g\u000e^*feZL7-Z\u000b\u0002gA\u0011A'N\u0007\u00023%\u0011a'\u0007\u0002\u000f\u0007>lW.\u001a8u'\u0016\u0014h/[2f\u0003=\u0019w.\\7f]R\u001cVM\u001d<jG\u0016\u0004\u0013!E1ui\u0006\u001c\u0007.\\3oiN+'O^5dKV\t!\b\u0005\u00025w%\u0011A(\u0007\u0002\u0012\u0003R$\u0018m\u00195nK:$8+\u001a:wS\u000e,\u0017AE1ui\u0006\u001c\u0007.\\3oiN+'O^5dK\u0002\na\u0002^1tWJ+\u0007o\\:ji>\u0014\u00180F\u0001A!\t\tE)D\u0001C\u0015\t\u00195$\u0001\u0006sKB|7/\u001b;pefL!!\u0012\"\u0003\u001dQ\u000b7o\u001b*fa>\u001c\u0018\u000e^8ss\u0006yA/Y:l%\u0016\u0004xn]5u_JL\b%\u0001\u000bbiR\f7\r[7f]R\u0014V\r]8tSR|'/_\u000b\u0002\u0013B\u0011\u0011IS\u0005\u0003\u0017\n\u0013A#\u0011;uC\u000eDW.\u001a8u%\u0016\u0004xn]5u_JL\u0018!F1ui\u0006\u001c\u0007.\\3oiJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JLX#A(\u0011\u0005\u0005\u0003\u0016BA)C\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\u0013e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\b%A\rgC\u000e,GOU3q_NLGo\u001c:z\t&\u001c\b/\u0019;dQ\u0016\u0014X#A+\u0011\u0005\u00053\u0016BA,C\u0005e1\u0015mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:\u00025\u0019\f7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM\u001d\u0011\u0002\u0011\u00154XM\u001c;CkN,\u0012a\u0017\t\u00039~k\u0011!\u0018\u0006\u0003=n\ta!\u001a<f]R\u001c\u0018B\u00011^\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\nKZ,g\u000e\u001e\"vg\u0002\na\u0001P5oSRtD\u0003\u00033fM\u001eD\u0017N[6\u0011\u0005Q\u0002\u0001\"B\u0019\u0010\u0001\u0004\u0019\u0004\"\u0002\u001d\u0010\u0001\u0004Q\u0004\"\u0002 \u0010\u0001\u0004\u0001\u0005\"B$\u0010\u0001\u0004I\u0005\"B'\u0010\u0001\u0004y\u0005\"B*\u0010\u0001\u0004)\u0006\"B-\u0010\u0001\u0004Y\u0006FA\bn!\tq\u00170D\u0001p\u0015\t\u0001\u0018/\u0001\u0006b]:|G/\u0019;j_:T!A]:\u0002\u000f\u0019\f7\r^8ss*\u0011A/^\u0001\u0006E\u0016\fgn\u001d\u0006\u0003m^\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002q\u0006\u0019qN]4\n\u0005i|'!C!vi><\u0018N]3e\u00031\t\u0007\u000f\u001d7z\u0007\"\fgnZ3t)\u0015i\u0018\u0011AA\t!\t!c0\u0003\u0002\u0000K\t!QK\\5u\u0011\u001d\t\u0019\u0001\u0005a\u0001\u0003\u000b\tqa\u00195b]\u001e,7\u000f\u0005\u0003\u0002\b\u00055QBAA\u0005\u0015\r\tYaG\u0001\u0007I>l\u0017-\u001b8\n\t\u0005=\u0011\u0011\u0002\u0002\b\u0007\"\fgnZ3t\u0011\u001d\t\u0019\u0002\u0005a\u0001\u0003+\tA!^:feB!\u0011qCA\u000e\u001b\t\tIBC\u0002\u0002\u0014mIA!!\b\u0002\u001a\t!Qk]3sQ\r\u0001\u0012\u0011\u0005\t\u0005\u0003G\t\t$\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\t\u0005-\u0012QF\u0001\u0004gFd'bAA\u00187\u0005\u0011AMY\u0005\u0005\u0003g\t)CA\bJgR\u0013\u0018M\\:bGRLwN\\1m\u00035\u0001(o\\2fgN4\u0015mY3ugR\u0019Q0!\u000f\t\u000f\u0005\r\u0011\u00031\u0001\u0002\u0006\u00059Q\r_3dkR,GcA?\u0002@!9\u00111\u0001\nA\u0002\u0005\u0015\u0011aD2pY2,7\r^\"p[6,g\u000e^:\u0015\r\u0005\u0015\u0013\u0011PA>!!\t9%!\u0016\u0002\\\u0005\u0005d\u0002BA%\u0003#\u00022!a\u0013&\u001b\t\tiEC\u0002\u0002P\u0005\na\u0001\u0010:p_Rt\u0014bAA*K\u00051\u0001K]3eK\u001aLA!a\u0016\u0002Z\t\u0019Q*\u00199\u000b\u0007\u0005MS\u0005\u0005\u0003\u0002\b\u0005u\u0013\u0002BA0\u0003\u0013\u0011A\u0001V1tWB1\u00111MA7\u0003grA!!\u001a\u0002j9!\u00111JA4\u0013\u00051\u0013bAA6K\u00059\u0001/Y2lC\u001e,\u0017\u0002BA8\u0003c\u00121aU3r\u0015\r\tY'\n\t\u0005\u0003\u000f\t)(\u0003\u0003\u0002x\u0005%!aB\"p[6,g\u000e\u001e\u0005\b\u0003\u0007\u0019\u0002\u0019AA\u0003\u0011\u001d\t\u0019b\u0005a\u0001\u0003+\t!cY8mY\u0016\u001cG/\u0011;uC\u000eDW.\u001a8ugR!\u0011\u0011QAF!!\t9%!\u0016\u0002\\\u0005\r\u0005CBA2\u0003[\n)\t\u0005\u0003\u0002\b\u0005\u001d\u0015\u0002BAE\u0003\u0013\u0011!\"\u0011;uC\u000eDW.\u001a8u\u0011\u001d\t\u0019\u0001\u0006a\u0001\u0003\u000b\t!\u0003\u001d:pG\u0016\u001c8/\u0011;uC\u000eDW.\u001a8ugR\u0019Q0!%\t\u000f\u0005MU\u00031\u0001\u0002\u0002\u0006\t\u0012\r\u001e;bG\"lWM\u001c;t\u0005f$\u0016m]6\u0002\u001fA\u0014xnY3tg\u000e{W.\\3oiN$R!`AM\u0003;Cq!a'\u0017\u0001\u0004\t)%\u0001\bd_6lWM\u001c;t\u0005f$\u0016m]6\t\u000f\u0005Ma\u00031\u0001\u0002\u0016\u0005a\u0001O]8dKN\u001cH+Y:lgR\u0019Q0a)\t\u000f\u0005\rq\u00031\u0001\u0002\u0006!\u001a\u0001!a*\u0011\t\u0005%\u0016qV\u0007\u0003\u0003WS1!!,v\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003c\u000bYKA\u0004TKJ4\u0018nY3")
public class ChangeExecutionService
implements Logging {
    private final CommentService commentService;
    private final AttachmentService attachmentService;
    private final TaskRepository taskRepository;
    private final AttachmentRepository attachmentRepository;
    private final ReleaseRepository releaseRepository;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ChangeExecutionService changeExecutionService = this;
        synchronized (changeExecutionService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public CommentService commentService() {
        return this.commentService;
    }

    public AttachmentService attachmentService() {
        return this.attachmentService;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public AttachmentRepository attachmentRepository() {
        return this.attachmentRepository;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @IsTransactional
    public void applyChanges(Changes changes, User user) {
        this.processFacets(changes);
        this.processAttachments(this.collectAttachments(changes));
        this.processComments(this.collectComments(changes, user), user);
        this.processTasks(changes);
        this.execute(changes);
    }

    private void processFacets(Changes changes) {
        Set facets = ((TraversableOnce)((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(changes.getUpdatedItems()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ChangeExecutionService.$anonfun$processFacets$1(x$1)))).map((Function1 & Serializable & scala.Serializable)x$2 -> (Facet)x$2, Set$.MODULE$.canBuildFrom())).toSet();
        facets.foreach((Function1 & Serializable & scala.Serializable)facet -> ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher().liveRepository())).update((Facet)facet));
    }

    private void execute(Changes changes) {
        Set releases = ((TraversableOnce)((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(changes.getUpdatedItems()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ChangeExecutionService.$anonfun$execute$1(x$3)))).map((Function1 & Serializable & scala.Serializable)x$4 -> ((PlanItem)x$4).getRelease(), Set$.MODULE$.canBuildFrom())).toSet();
        releases.foreach((Function1 & Serializable & scala.Serializable)release -> this.releaseRepository().update((Release)release));
    }

    private Map<Task, Seq<Comment>> collectComments(Changes changes, User user) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(changes.getCommentsByTask().asMap()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Task task = (Task)tuple2._1();
            Collection commentTexts = (Collection)tuple2._2();
            Seq userComments = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(commentTexts).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple3 tuple3 = x0$2;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                User u = (User)tuple3._1();
                String text = (String)tuple3._2();
                DateTime date = (DateTime)tuple3._3();
                User actualUser = (User)Option$.MODULE$.apply((Object)u).getOrElse((Function0 & Serializable & scala.Serializable)() -> user);
                Comment comment = this.commentService().buildComment(task, text, actualUser.getName(), date.toDate(), CommentService.COMMENT_PREFIX_MANUAL, CommentService.COMMENT_SUFFIX);
                return comment;
            }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSeq();
            task.getComments().addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(userComments).asJava());
            Tuple2 tuple22 = new Tuple2((Object)task, (Object)userComments);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<Task, Seq<Attachment>> collectAttachments(Changes changes) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(changes.getAttachmentsByTask().asMap()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Task task = (Task)tuple2._1();
            Collection attachments = (Collection)tuple2._2();
            Seq updatedAttachments = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(attachments).asScala()).map((Function1 & Serializable & scala.Serializable)attachment -> (Attachment)CloseableUtils$.MODULE$.using(attachment.getFile().getInputStream(), (Function1 & Serializable & scala.Serializable)is -> this.attachmentService().attachToRelease(task.getRelease(), attachment.getFile().getName(), attachment.getContentType(), (InputStream)is)), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSeq();
            task.getAttachments().addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(updatedAttachments).asJava());
            Tuple2 tuple22 = new Tuple2((Object)task, (Object)updatedAttachments);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public void processAttachments(Map<Task, Seq<Attachment>> attachmentsByTask) {
        attachmentsByTask.groupBy((Function1 & Serializable & scala.Serializable)x$5 -> ((Task)x$5._1()).getRelease()).mapValues((Function1 & Serializable & scala.Serializable)x$6 -> ((TraversableOnce)x$6.flatMap((Function1 & Serializable & scala.Serializable)x$7 -> (Seq)x$7._2(), Iterable$.MODULE$.canBuildFrom())).toSeq()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ChangeExecutionService.$anonfun$processAttachments$4(this, x0$1);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)attachmentsByTask.map((Function1 & Serializable & scala.Serializable)x$8 -> ((Task)x$8._1()).getRelease(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)release -> this.releaseRepository().update((Release)release));
        attachmentsByTask.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ChangeExecutionService.$anonfun$processAttachments$7(this, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public void processComments(Map<Task, Seq<Comment>> commentsByTask, User user) {
        commentsByTask.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ChangeExecutionService.$anonfun$processComments$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void processTasks(Changes changes) {
        Set tasks = ((TraversableOnce)((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(changes.getUpdatedItems()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ChangeExecutionService.$anonfun$processTasks$1(x$9)))).map((Function1 & Serializable & scala.Serializable)x$10 -> (Task)x$10, Set$.MODULE$.canBuildFrom())).toSet();
        tasks.foreach((Function1 & Serializable & scala.Serializable)task -> {
            ChangeExecutionService.$anonfun$processTasks$3(this, task);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$processFacets$1(ConfigurationItem x$1) {
        return x$1 instanceof Facet;
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(ConfigurationItem x$3) {
        return x$3 instanceof PlanItem;
    }

    public static final /* synthetic */ void $anonfun$processAttachments$4(ChangeExecutionService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Release release = (Release)tuple2._1();
        Seq attachments = (Seq)tuple2._2();
        $this.attachmentRepository().batchInsert(release, (Seq<Attachment>)attachments);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$processAttachments$8(ChangeExecutionService $this, Task task$3, Attachment attachment) {
        $this.eventBus().publish((XLReleaseEvent)new AttachmentCreatedEvent(task$3.getId(), attachment));
    }

    public static final /* synthetic */ void $anonfun$processAttachments$7(ChangeExecutionService $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Task task = (Task)tuple2._1();
        Seq attachments = (Seq)tuple2._2();
        attachments.foreach((Function1 & Serializable & scala.Serializable)attachment -> {
            ChangeExecutionService.$anonfun$processAttachments$8($this, task, attachment);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$processComments$1(ChangeExecutionService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Task task = (Task)tuple2._1();
        Seq comments = (Seq)tuple2._2();
        comments.foreach((Function1 & Serializable & scala.Serializable)comment -> $this.commentService().create(task, (Comment)comment));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$processTasks$1(ConfigurationItem x$9) {
        return x$9 instanceof Task;
    }

    public static final /* synthetic */ void $anonfun$processTasks$3(ChangeExecutionService $this, Task task) {
        $this.taskRepository().updateTaskProperties(task);
    }

    @Autowired
    public ChangeExecutionService(CommentService commentService, AttachmentService attachmentService, TaskRepository taskRepository, AttachmentRepository attachmentRepository, ReleaseRepository releaseRepository, FacetRepositoryDispatcher facetRepositoryDispatcher, XLReleaseEventBus eventBus) {
        this.commentService = commentService;
        this.attachmentService = attachmentService;
        this.taskRepository = taskRepository;
        this.attachmentRepository = attachmentRepository;
        this.releaseRepository = releaseRepository;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

