/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;

public class ArchiveCommand
extends GitCommand<OutputStream> {
    private static final ConcurrentMap<String, FormatEntry> formats = new ConcurrentHashMap<String, FormatEntry>();
    private OutputStream out;
    private ObjectId tree;
    private String prefix;
    private String format;
    private Map<String, Object> formatOptions = new HashMap<String, Object>();
    private List<String> paths = new ArrayList<String>();
    private String suffix;

    private static <K, V> boolean replace(ConcurrentMap<K, V> map, K key, V oldValue, V newValue) {
        if (oldValue == null && newValue == null) {
            return true;
        }
        if (oldValue == null) {
            return map.putIfAbsent(key, newValue) == null;
        }
        if (newValue == null) {
            return map.remove(key, oldValue);
        }
        return map.replace(key, oldValue, newValue);
    }

    public static void registerFormat(String name, Format<?> fmt) {
        FormatEntry entry;
        FormatEntry old;
        if (fmt == null) {
            throw new NullPointerException();
        }
        do {
            if ((old = (FormatEntry)formats.get(name)) == null) {
                entry = new FormatEntry(fmt, 1);
                continue;
            }
            if (!old.format.equals(fmt)) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().archiveFormatAlreadyRegistered, name));
            }
            entry = new FormatEntry(old.format, old.refcnt + 1);
        } while (!ArchiveCommand.replace(formats, name, old, entry));
    }

    public static void unregisterFormat(String name) {
        FormatEntry entry;
        FormatEntry old;
        do {
            if ((old = (FormatEntry)formats.get(name)) != null) continue;
            throw new JGitInternalException(MessageFormat.format(JGitText.get().archiveFormatAlreadyAbsent, name));
        } while (!ArchiveCommand.replace(formats, name, old, entry = old.refcnt == 1 ? null : new FormatEntry(old.format, old.refcnt - 1)));
    }

    private static Format<?> formatBySuffix(String filenameSuffix) throws UnsupportedFormatException {
        if (filenameSuffix != null) {
            for (FormatEntry entry : formats.values()) {
                Format<?> fmt = entry.format;
                for (String sfx : fmt.suffixes()) {
                    if (!filenameSuffix.endsWith(sfx)) continue;
                    return fmt;
                }
            }
        }
        return ArchiveCommand.lookupFormat("tar");
    }

    private static Format<?> lookupFormat(String formatName) throws UnsupportedFormatException {
        FormatEntry entry = (FormatEntry)formats.get(formatName);
        if (entry == null) {
            throw new UnsupportedFormatException(formatName);
        }
        return entry.format;
    }

    public ArchiveCommand(Repository repo) {
        super(repo);
        this.setCallable(false);
    }

    /*
     * Exception decompiling
     */
    private <T extends Closeable> OutputStream writeArchive(Format<T> fmt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public OutputStream call() throws GitAPIException {
        this.checkCallable();
        Format<?> fmt = this.format == null ? ArchiveCommand.formatBySuffix(this.suffix) : ArchiveCommand.lookupFormat(this.format);
        return this.writeArchive(fmt);
    }

    public ArchiveCommand setTree(ObjectId tree) {
        if (tree == null) {
            throw new IllegalArgumentException();
        }
        this.tree = tree;
        this.setCallable(true);
        return this;
    }

    public ArchiveCommand setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public ArchiveCommand setFilename(String filename) {
        int slash = filename.lastIndexOf(47);
        int dot = filename.indexOf(46, slash + 1);
        this.suffix = dot == -1 ? "" : filename.substring(dot);
        return this;
    }

    public ArchiveCommand setOutputStream(OutputStream out) {
        this.out = out;
        return this;
    }

    public ArchiveCommand setFormat(String fmt) {
        this.format = fmt;
        return this;
    }

    public ArchiveCommand setFormatOptions(Map<String, Object> options) {
        this.formatOptions = options;
        return this;
    }

    public ArchiveCommand setPaths(String ... paths) {
        this.paths = Arrays.asList(paths);
        return this;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    public static interface Format<T extends Closeable> {
        public T createArchiveOutputStream(OutputStream var1) throws IOException;

        public T createArchiveOutputStream(OutputStream var1, Map<String, Object> var2) throws IOException;

        @Deprecated
        public void putEntry(T var1, String var2, FileMode var3, ObjectLoader var4) throws IOException;

        public void putEntry(T var1, ObjectId var2, String var3, FileMode var4, ObjectLoader var5) throws IOException;

        public Iterable<String> suffixes();
    }

    private static class FormatEntry {
        final Format<?> format;
        final int refcnt;

        public FormatEntry(Format<?> format, int refcnt) {
            if (format == null) {
                throw new NullPointerException();
            }
            this.format = format;
            this.refcnt = refcnt;
        }
    }

    public static class UnsupportedFormatException
    extends GitAPIException {
        private static final long serialVersionUID = 1L;
        private final String format;

        public UnsupportedFormatException(String format) {
            super(MessageFormat.format(JGitText.get().unsupportedArchiveFormat, format));
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

