/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.engine.api.security.RolePrincipals;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.utils.RolePrincipalEventPublisher;
import com.xebialabs.xlrelease.views.RolePrincipalsView;
import com.xebialabs.xlrelease.views.RoleView;
import com.xebialabs.xlrelease.views.UserView;
import com.xebialabs.xlrelease.views.converters.UserViewConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/roles")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class RolePrincipalsResource {
    private static final Logger logger = LoggerFactory.getLogger(RolePrincipalsResource.class);
    private PermissionChecker permissionChecker;
    private RoleService roleService;
    private TeamService teamService;
    private UserViewConverter userViewConverter;
    private DtoWriter dtoWriter = new DtoWriter();
    private DtoReader dtoReader = new DtoReader();

    @Autowired
    public RolePrincipalsResource(PermissionChecker permissionChecker, RoleService roleService, TeamService teamService, UserViewConverter userViewConverter) {
        this.permissionChecker = permissionChecker;
        this.roleService = roleService;
        this.teamService = teamService;
        this.userViewConverter = userViewConverter;
    }

    @GET
    @Timed
    @Path(value="names")
    public List<String> readRoleNames() {
        List<RolePrincipals> assignments = this.getRolePrincipalsList();
        return assignments.stream().map(assignment -> assignment.getRole().getName()).collect(Collectors.toList());
    }

    @GET
    @Timed
    @Path(value="principals")
    public List<RolePrincipalsView> readRolePrincipals() {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        List<RolePrincipals> assignments = this.getRolePrincipalsList();
        HashMap cache = new HashMap();
        return assignments.stream().map(rolePrincipal -> this.getRolePrincipalsView((RolePrincipals)rolePrincipal, cache)).collect(Collectors.toList());
    }

    private RolePrincipalsView getRolePrincipalsView(RolePrincipals rolePrincipal, Map<String, UserView> cache) {
        RoleView roleview = new RoleView(rolePrincipal.getRole());
        List<UserView> rolePrincipalsView = this.userViewConverter.toUserView(rolePrincipal.getPrincipals(), cache, false);
        return new RolePrincipalsView(roleview, rolePrincipalsView);
    }

    @PUT
    @Timed
    @Path(value="principals")
    public void createOrUpdateGlobalRolePermission(RolePrincipalsView rolePrincipalsView) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        RolePrincipals rolePrincipals = rolePrincipalsView.toRolePrincipals();
        this.teamService.generateIdIfNecessary(rolePrincipals.getRole());
        Role role = (Role)this.dtoReader.readRoleAssignments(Collections.singletonList(rolePrincipals)).get(0);
        logger.debug(String.format("createOrUpdateGlobalRolePermission: role := %s / %s", role.getId(), role.getName()));
        Optional<Role> originalRole = this.getRole(role.getId());
        this.roleService.createOrUpdateRole(role);
        RolePrincipalEventPublisher.publishCreateOrUpdate(originalRole, role);
    }

    @DELETE
    @Timed
    @Path(value="principals/{roleId:.*}")
    public void deleteGlobalRolePermission(@PathParam(value="roleId") String roleId) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        Optional<Role> role = this.getRole(roleId);
        this.roleService.deleteById(roleId);
        RolePrincipalEventPublisher.publishDelete(role);
    }

    private List<RolePrincipals> getRolePrincipalsList() {
        List multimap = this.roleService.readRoleAssignments();
        return this.dtoWriter.writeRoleAssignments(multimap);
    }

    private Optional<Role> getRole(String roleId) {
        return this.getRolePrincipalsList().stream().filter(r -> roleId.equals(r.getRole().getId())).findFirst().map(r -> (Role)this.dtoReader.readRoleAssignments(Collections.singletonList(r)).get(0));
    }
}

