/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.vault.authentication.AuthenticationSteps;
import org.springframework.vault.authentication.AuthenticationStepsFactory;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.LoginTokenUtil;
import org.springframework.vault.authentication.VaultLoginException;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

public class ClientCertificateAuthentication
implements ClientAuthentication,
AuthenticationStepsFactory {
    private static final Log logger = LogFactory.getLog(ClientCertificateAuthentication.class);
    private final RestOperations restOperations;

    public ClientCertificateAuthentication(RestOperations restOperations) {
        Assert.notNull((Object)restOperations, (String)"RestOperations must not be null");
        this.restOperations = restOperations;
    }

    public static AuthenticationSteps createAuthenticationSteps() {
        return AuthenticationSteps.just(AuthenticationSteps.HttpRequestBuilder.post("auth/cert/login", new String[0]).as(VaultResponse.class));
    }

    @Override
    public VaultToken login() {
        return this.createTokenUsingTlsCertAuthentication("cert");
    }

    @Override
    public AuthenticationSteps getAuthenticationSteps() {
        return ClientCertificateAuthentication.createAuthenticationSteps();
    }

    private VaultToken createTokenUsingTlsCertAuthentication(String path) {
        try {
            VaultResponse response = (VaultResponse)this.restOperations.postForObject("auth/{mount}/login", Collections.emptyMap(), VaultResponse.class, new Object[]{path});
            Assert.state((response.getAuth() != null ? 1 : 0) != 0, (String)"Auth field must not be null");
            logger.debug((Object)"Login successful using TLS certificates");
            return LoginTokenUtil.from(response.getAuth());
        }
        catch (RestClientException e) {
            throw VaultLoginException.create("TLS Certificates", e);
        }
    }
}

