/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.variables;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.utils.Collectors;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.HashMap;
import java.util.Map;

@PublicApiRef
@ShowOnlyPublicApiMembers
public class MapStringStringVariable
extends Variable.VariableWithValue<Map<String, String>> {
    @PublicApiMember
    @Property(required=false, description="Value of the release variable or default value of the template variable")
    protected Map<String, String> value;

    @Override
    public Map<String, String> getValue() {
        return this.value == null ? null : Maps.newHashMap(this.value);
    }

    @Override
    public Map<String, String> getEmptyValue() {
        return new HashMap<String, String>();
    }

    @Override
    public boolean isValueEmpty() {
        return this.value == null || this.value.isEmpty();
    }

    @Override
    @PublicApiMember
    public void setValue(Map<String, String> value) {
        this.value = value;
    }

    @Override
    public void setUntypedValue(Object newValue) {
        if (newValue == null) {
            this.setValue(Maps.newHashMap());
        } else if (newValue instanceof Map) {
            Map<String, String> value = ((Map)newValue).entrySet().stream().collect(Collectors.toMap(k -> VariableHelper.toString(k.getKey()), v -> VariableHelper.toString(v.getValue())));
            this.setValue(value);
        } else {
            throw new IllegalArgumentException(String.format("Cannot set instance of %s into map of string string variable value: %s", newValue.getClass().getSimpleName(), newValue));
        }
    }

    @Override
    public String getValueAsString() {
        return this.formatValueAsString((Map<String, String>)this.getValue());
    }

    @Override
    public boolean isPassword() {
        return false;
    }

    @Override
    public String getEmptyValueAsString() {
        return this.formatValueAsString((Map<String, String>)this.getEmptyValue());
    }

    @Override
    public boolean isValueAssignableFrom(Object value) {
        return value instanceof Map;
    }

    private String formatValueAsString(Map<String, String> valueToFormat) {
        Map<String, String> mappedValue = valueToFormat.entrySet().stream().collect(Collectors.toMap(k -> String.format("'%s'", this.escapeQuotes((String)k.getKey())), v -> String.format("'%s'", this.escapeQuotes(VariableHelper.toString(v.getValue())))));
        return String.format("{%s}", Joiner.on((String)", ").withKeyValueSeparator(": ").join(mappedValue));
    }
}

