import sys
import urllib
from com.xebialabs.xlrelease.plugin.webhook import JsonPathResult
from com.xebialabs.xlrelease.reports.excel import ExcelSheetWriter
from java.io import IOException
from java.lang import RuntimeException
from java.util import Date
from org.joda.time import Duration
from org.joda.time import PeriodType

import json


def addBuildRecord(response):
    buildData = json.loads(response)
    displayName = buildData.get('displayName', '')
    fullDisplayName = buildData.get('fullDisplayName', '')
    buildRecord = taskReportingApi.newBuildRecord()
    buildRecord.targetId = task.id
    buildRecord.project = fullDisplayName.replace(' {}'.format(displayName), '')
    buildRecord.build = 'Build ' + displayName
    buildRecord.build_url = buildData.get('url')
    buildRecord.serverUrl = jenkinsServer['url']
    buildRecord.serverUser = username or jenkinsServer['username']
    buildRecord.outcome = buildData.get('result', None)
    buildRecord.startDate = Date(long(buildData.get('timestamp')))
    buildRecord.endDate = Date(long(buildData.get('timestamp') + buildData.get('duration')))
    buildRecord.duration = ExcelSheetWriter.PERIOD_FORMATTER.print(Duration.millis(buildData.get('duration')).toPeriod().normalizedStandard(PeriodType.dayTime()))

    taskReportingApi.addRecord(buildRecord, True)


def finishPolling(buildStatus):
    print "\nFinished: %s" % buildStatus
    jenkinsJobURL = jenkinsURL + jobContext + str(buildNumber)
    task.setStatusLine("[Build #%s](%s)" % (str(buildNumber), jenkinsJobURL))
    if buildStatus != 'SUCCESS':
        task.schedule("jenkins/Build.fail.py")


jenkinsURL = jenkinsServer['url']
jobUrl = jenkinsURL

request = HttpRequest(jenkinsServer, username, password)
jobContext = '/job/' + urllib.quote(jobName) + '/'

response = None
buildStatus = None
try:
    response = request.get(jobContext + str(buildNumber) + '/api/json', contentType='application/json')
    if response.isSuccessful():
        buildStatus = JsonPathResult(response.response, 'result').get()
        duration = JsonPathResult(response.response, 'duration').get()
        if buildStatus and duration != 0:
            try:
                addBuildRecord(response.response)
            except RuntimeException as e:
                print "\nCould not add 'Build' attribute: %s\n" % str(e)
            except Exception as e:
                print "\nCould not add 'Build' attribute: %s\n" % str(e)
            finishPolling(buildStatus)
        else:
            task.schedule("jenkins/Build.wait-for-build.py")
    else:
        print "\nFailed to check the job status. Received an error from the Jenkins server: `%s`" % response.response
        if response.getStatus() == 404:
            task.schedule("jenkins/Build.fail.py")
        else:
            task.schedule("jenkins/Build.wait-for-build.py")

except IOException as error:
    print "\nFailed to check the job status due to connection problems. Will retry in the next polling run. Error details: `%s`" % error
    task.schedule("jenkins/Build.wait-for-build.py")