(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[3],{

/***/ 101:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return fetchRiskConfig; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return fetchRiskAssessors; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return fetchRiskProfiles; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return fetchRiskProfile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return createRiskProfile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "j", function() { return updateRiskProfile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return deleteRiskProfile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return copyRiskProfile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return fetchReferences; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return RiskSettingsService; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _common_services_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15);



var riskApi = 'api/v1/risks';
var fetchRiskConfig = function fetchRiskConfig() {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_2__[/* httpGET */ "c"])("".concat(riskApi, "/config"));
};
var fetchRiskAssessors = function fetchRiskAssessors() {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_2__[/* httpGET */ "c"])("".concat(riskApi, "/assessors"));
};
var fetchRiskProfiles = function fetchRiskProfiles() {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_2__[/* httpGET */ "c"])("".concat(riskApi, "/profiles"));
};
var fetchRiskProfile = function fetchRiskProfile(riskProfileId) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_2__[/* httpGET */ "c"])("".concat(riskApi, "/profiles/").concat(riskProfileId));
};
var createRiskProfile = function createRiskProfile(riskProfile) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_2__[/* httpPOST */ "e"])("".concat(riskApi, "/profiles"), riskProfile);
};
var updateRiskProfile = function updateRiskProfile(riskProfile) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_2__[/* httpPUT */ "f"])("".concat(riskApi, "/profiles/").concat(riskProfile.id), riskProfile);
};
var deleteRiskProfile = function deleteRiskProfile(riskProfileId) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_2__[/* httpDELETE */ "b"])("".concat(riskApi, "/profiles/").concat(riskProfileId));
};
var copyRiskProfile = function copyRiskProfile(riskProfileId) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_2__[/* httpPOST */ "e"])("".concat(riskApi, "/profiles/").concat(riskProfileId, "/copy"));
};
var fetchReferences = function fetchReferences(riskProfileId) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_2__[/* httpGET */ "c"])("risks/profiles/".concat(riskProfileId, "/references"));
};
var RiskSettingsService = /*#__PURE__*/function () {
  function RiskSettingsService() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, RiskSettingsService);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(RiskSettingsService, [{
    key: "getAll",
    value: function getAll() {
      return fetchRiskProfiles();
    }
  }]);

  return RiskSettingsService;
}();

/***/ }),

/***/ 105:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return isAtRisk; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return isAttentionNeeded; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return isOnTrack; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return isCompleted; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return getRiskStatus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return isPlanItemOverdueMessage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return getRiskIconClasses; });
/* harmony import */ var _js_releases_list_releases_status_service_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(120);
/* harmony import */ var _js_util_ids__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(64);
/* harmony import */ var _release_overview_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(90);



function isAtRisk(release, riskScore, riskThresholds) {
  return !isCompleted(release) && riskScore >= riskThresholds.atRiskFrom;
}
function isAttentionNeeded(release, riskScore, riskThresholds) {
  return !isCompleted(release) && riskScore >= riskThresholds.attentionNeededFrom && riskScore < riskThresholds.atRiskFrom;
}
function isOnTrack(release, riskScore, riskThresholds) {
  return !isCompleted(release) && riskScore < riskThresholds.attentionNeededFrom;
}
function isCompleted(release) {
  return Object(_js_releases_list_releases_status_service_js__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])().hasCompletedStatus(release) || Object(_js_releases_list_releases_status_service_js__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])().isReleaseAborted(release);
}
function getRiskStatus(release, riskScore, riskThresholds) {
  if (isAtRisk(release, riskScore, riskThresholds)) {
    return _release_overview_constants__WEBPACK_IMPORTED_MODULE_2__[/* AT_RISK */ "b"];
  } else if (isAttentionNeeded(release, riskScore, riskThresholds)) {
    return _release_overview_constants__WEBPACK_IMPORTED_MODULE_2__[/* ATTENTION_NEEDED */ "a"];
  } else if (isOnTrack(release, riskScore, riskThresholds)) {
    return _release_overview_constants__WEBPACK_IMPORTED_MODULE_2__[/* ON_TRACK */ "e"];
  }

  return _release_overview_constants__WEBPACK_IMPORTED_MODULE_2__[/* NONE */ "d"];
}
function isPlanItemOverdueMessage(message) {
  var riskAssessorId = message.riskAssessorId;
  return riskAssessorId && (riskAssessorId === 'Applications/ReleaseDueDateRiskAssessor' || riskAssessorId === 'Applications/TaskDueDateRiskAssessor');
}
function getRiskIconClasses(riskAssessor) {
  if (!riskAssessor.riskAssessorId) {
    return _release_overview_constants__WEBPACK_IMPORTED_MODULE_2__[/* RISK_ON_TRACK_ICON */ "g"];
  }

  var id = Object(_js_util_ids__WEBPACK_IMPORTED_MODULE_1__[/* default */ "a"])().toInternalId(riskAssessor.riskAssessorId).replace('RiskAssessor', '');
  return _release_overview_constants__WEBPACK_IMPORTED_MODULE_2__[/* RISK_ASSESSOR_ICONS */ "f"][id];
}

/***/ }),

/***/ 120:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ReleaseStatusFactory; });
function ReleaseStatusFactory() {
  return {
    isReleaseCompleted: function isReleaseCompleted(release) {
      return release && (release.status === 'COMPLETED' || release.status === 'ABORTED');
    },
    isReleaseAborted: function isReleaseAborted(release) {
      return release && release.status === 'ABORTED';
    },
    isReleasePlanned: function isReleasePlanned(release) {
      return release && release.status === 'PLANNED';
    },
    isReleaseInProgress: function isReleaseInProgress(release) {
      return release && release.status === 'IN_PROGRESS';
    },
    isReleaseFailed: function isReleaseFailed(release) {
      return release && release.status === 'FAILED';
    },
    isReleaseFailing: function isReleaseFailing(release) {
      return release && release.status === 'FAILING';
    },
    isReleasePaused: function isReleasePaused(release) {
      return release && release.status === 'PAUSED';
    },
    hasCompletedStatus: function hasCompletedStatus(release) {
      return release && release.status === 'COMPLETED';
    },
    isTemplate: function isTemplate(release) {
      return release && release.status === 'TEMPLATE';
    },
    isReleaseArchived: function isReleaseArchived(release) {
      return release && release.archived;
    },
    isReleaseActive: function isReleaseActive(release) {
      return release && (release.status === 'IN_PROGRESS' || release.status === "FAILED" || release.status === "FAILING" || release.status === "PAUSED");
    }
  };
}

/***/ }),

/***/ 123:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return fetchDeliveries; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return getDelivery; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return deleteDelivery; });
/* unused harmony export createDelivery */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return createDeliveryFromPattern; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return updateDelivery; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return isDeliveryUpdatable; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return getTrackedItemApprovals; });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(15);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(142);


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var RELEASE_DELIVERY_API = 'api/v1/deliveries';
var RELEASE_DELIVERY_PATTERN_API = 'api/v1/delivery-patterns';
var RELEASE_DELIVERY_ACTIVITY_LOGS_INTERNAL_API = 'activity';

function reduceFilters(filters) {
  var keys = _.keys(filters);

  return _.reduce(keys, function (reduced, key) {
    if (_.has(_constants__WEBPACK_IMPORTED_MODULE_2__[/* RELEASE_STATUS_FILTER_KEY_TO_STATUS */ "c"], key)) {
      filters[key] && reduced.statuses.push(_constants__WEBPACK_IMPORTED_MODULE_2__[/* RELEASE_STATUS_FILTER_KEY_TO_STATUS */ "c"][key]);
    } else {
      reduced[key] = filters[key];
    }

    return reduced;
  }, {
    statuses: []
  });
}

function fetchDeliveries(data, pageNumber) {
  var itemsPerPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _constants__WEBPACK_IMPORTED_MODULE_2__[/* ITEMS_PER_PAGE */ "b"];
  var params = {
    resultsPerPage: itemsPerPage,
    page: pageNumber,
    orderBy: (data.orderBy || _constants__WEBPACK_IMPORTED_MODULE_2__[/* DEFAULT_ORDER_BY */ "a"]).toUpperCase()
  };
  var url = "".concat(RELEASE_DELIVERY_API, "/search?") + $.param(params);
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPOST */ "e"])(url, _objectSpread({}, reduceFilters(data)));
}
var getDelivery = function getDelivery(deliveryId) {
  var hideAlert = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpGET */ "c"])("".concat(RELEASE_DELIVERY_API, "/").concat(deliveryId), hideAlert);
};
var deleteDelivery = function deleteDelivery(deliveryId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpDELETE */ "b"])("".concat(RELEASE_DELIVERY_API, "/").concat(deliveryId));
};
var createDelivery = function createDelivery(delivery) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPOST */ "e"])(RELEASE_DELIVERY_API, delivery);
};
var createDeliveryFromPattern = function createDeliveryFromPattern(patternId, delivery) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPOST */ "e"])("".concat(RELEASE_DELIVERY_PATTERN_API, "/").concat(patternId, "/create"), delivery);
};
var updateDelivery = function updateDelivery(delivery) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPUT */ "f"])("".concat(RELEASE_DELIVERY_API, "/").concat(delivery.id), delivery);
};
var isDeliveryUpdatable = function isDeliveryUpdatable(delivery) {
  return delivery && delivery.status !== 'COMPLETED';
};
var getTrackedItemApprovals = function getTrackedItemApprovals(deliveryId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpGET */ "c"])("".concat(RELEASE_DELIVERY_ACTIVITY_LOGS_INTERNAL_API, "/").concat(deliveryId, "/approvals"));
};

/***/ }),

/***/ 133:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return fetchReleases; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return fetchRisks; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return startReleases; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return abortReleases; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return fetchReleaseTags; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return fetchArchivedReleaseTags; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return fetchCount; });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _common_services_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(15);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(90);


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var fetchReleases = function fetchReleases(filters, pageNumber) {
  var url = "releases/search?depth=3&numberbypage=".concat(_constants__WEBPACK_IMPORTED_MODULE_2__[/* ITEMS_PER_PAGE */ "c"], "&page=").concat(pageNumber, "&filter=").concat(filters.filter) + '&properties=riskScore&extensions=progress';
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpRequest */ "g"])('POST', url, {
    data: filters
  });
};
var fetchRisks = function fetchRisks(releaseId) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpRequest */ "g"])('GET', "api/v1/risks/".concat(releaseId, "/Risk"));
};
var startReleases = function startReleases(releasesIds) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpRequest */ "g"])('POST', "releases/start", {
    data: releasesIds
  });
};
var abortReleases = function abortReleases(releasesIds, abortComment) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpRequest */ "g"])('POST', "releases/abort", {
    data: {
      releasesIds: releasesIds,
      abortComment: abortComment
    }
  });
};
var fetchReleaseTags = function fetchReleaseTags() {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpGET */ "c"])('releases/tags');
};
var fetchArchivedReleaseTags = function fetchArchivedReleaseTags() {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpGET */ "c"])('releases/tags/archived');
};
var fetchCount = function fetchCount(filters) {
  if (filters.onlyArchived) {
    filters.planned = false;
    filters.inProgress = false;
    filters.failing = false;
    filters.failed = false;
    filters.paused = false;
  }

  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPOST */ "e"])('releases/count', _objectSpread({}, filters, {
    onlyArchived: false
  }));
};

/***/ }),

/***/ 1405:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1406:
/***/ (function(module, exports) {

var template = "\n    <form name=\"createTeamForm\" class=\"form-horizontal\" novalidate>\n        <div class=\"modal-header\">\n            <h4 class=\"modal-title pull-left\" id=\"modal-title\">Create a new team</h4>\n            <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.dismiss()\"><i class=\"xl-icon close-icon\"/></button>\n            <div class=\"clearfix\"/>\n        </div>\n        <div class=\"modal-body\" id=\"modal-body\">        \n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\" for=\"team-name\">\n                    Team name <span ng-if=\"createTeamForm.$dirty && createTeamForm.teamName.$error.required\" class=\"error\">*</span>\n                </label>\n                <div class=\"col-sm-9\">\n                    <input type=\"text\" class=\"input-block-level text\" id=\"team-name\" name=\"teamName\"\n                           ng-model=\"$ctrl.teamName\" not-in-list=\"$ctrl.resolve.teams\" case-insensitive required autofocus/>\n                    <span class=\"description\" ng-if=\"!createTeamForm.teamName.$error.notInList\">Unique name for the team.</span>\n                    <div class=\"field-errors\" ng-if=\"createTeamForm.teamName.$dirty\">\n                        <span ng-if=\"createTeamForm.teamName.$error.notInList\">Team with this name already exists</span>\n                    </div>\n                </div>\n            </div>        \n        </div>\n        <div class=\"modal-footer\">\n            <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n            <button class=\"button continue primary\" type=\"submit\" ng-click=\"$ctrl.close({$value: $ctrl.teamName})\" ng-disabled=\"createTeamForm.$invalid\">Create</button>\n        </div>\n    </form>\n    ";
var AddTeamModal = {
  bindings: {
    resolve: '<',
    close: '&',
    dismiss: '&'
  },
  template: template
};
angular.module('xlrelease').component('addTeamModal', AddTeamModal);

/***/ }),

/***/ 1407:
/***/ (function(module, exports) {

(function () {
  var template = "    \n    <sub-nav-content ng-if=\"!$ctrl.breadcrumbs\" sub-menu-items=\"$ctrl.subMenuItems\"></sub-nav-content>\n    <ol class=\"breadcrumb\" ng-if=\"$ctrl.breadcrumbs.length !== 0\">\n        <li ng-repeat='breadcrumb in $ctrl.breadcrumbs'>\n            <div ng-class=\"{'overflow': !$last, 'last-overflow': $last}\" ng-switch=\"$last\" title=\"{{breadcrumb.label}}\">\n                <a ng-switch-when=\"false\" ng-href=\"#/{{breadcrumb.pathSuffix}}\" class=\"bread-crumb\">{{breadcrumb.label}}</a>\n                <span ng-switch-when=\"true\" class=\"last-bread-crumb\">{{breadcrumb.label}}</span>                \n            </div>\n            <span ng-if=\"!$last\" class=\"bread-crumbs-separator\">/</span>\n        </li>\n    </ol>\n    ";
  var Breadcrumbs = {
    bindings: {
      breadcrumbs: '<',
      subMenuItems: '<'
    },
    template: template
  };
  angular.module('xlrelease').component('xlrBreadcrumbs', Breadcrumbs);
})();

/***/ }),

/***/ 1408:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1409:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1410:
/***/ (function(module, exports) {

var template = "\n    <div class=\"modal-header\">\n        <h4 class=\"modal-title pull-left\" id=\"modal-title\">Delete team</h4>\n        <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.close()\"><i class=\"xl-icon close-icon\"/></button>\n        <div class=\"clearfix\"/>\n    </div>\n    <div class=\"modal-body\" id=\"modal-body\">\n        You are about to delete the team <strong>{{$ctrl.resolve.teamName}}</strong>.\n    </div>\n    <div class=\"modal-footer\">\n        <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button class=\"button continue primary\" type=\"button\" focus-on=\"true\" ng-click=\"$ctrl.close({$value: true})\">Delete</button>\n    </div>\n    ";
var DeleteTeamModal = {
  bindings: {
    resolve: '<',
    close: '&',
    dismiss: '&'
  },
  template: template
};
angular.module('xlrelease').component('deleteTeamModal', DeleteTeamModal);

/***/ }),

/***/ 1411:
/***/ (function(module, exports) {

var template = "\n        <div class=\"delete-comment-modal\">\n       <div class=\"modal-header\">\n               <h4 class=\"modal-title pull-left\" id=\"modal-title\">Delete comment</h4>\n               <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.close()\"><i class=\"xl-icon close-icon\"></i></button>\n               <div class=\"clearfix\"></div>\n       </div>\n        <div class=\"modal-body\">\n            <b> Are you sure you want to delete this comment?</b>\n            <div class=\"delete-comment-view\">\n                <i class=\"xl-icon user-icon\"></i>\n                <strong ng-if=\"$ctrl.resolve.comment.author.username\" display-user=\"$ctrl.resolve.comment.author\"></strong>\n                <strong ng-if=\"!$ctrl.resolve.comment.author.username\">SYSTEM</strong>\n                <span class=\"delete-comment-date-format\">{{$ctrl.resolve.comment.date | date:'mediumDate'}} at {{$ctrl.resolve.comment.date | date:'shortTime'}}</span><br/>\n                <span class=\"delete-comment-text-modal\" markdown> <span ng-bind-html=\"$ctrl.resolve.comment.text | markdown\" class=\"markdown\"></span></span>\n            </div>\n        </div>\n         <div class=\"modal-footer\">\n                <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n                <button class=\"button continue primary\" type=\"button\" focus-on=\"true\" ng-click=\"$ctrl.close({$value: true})\">Delete</button>\n         </div>\n         </div>\n     ";
var DeleteCommentOfTaskModal = {
  bindings: {
    resolve: '<',
    close: '&',
    dismiss: '&'
  },
  template: template
};
angular.module('xlrelease').component('deleteCommentOfTaskModal', DeleteCommentOfTaskModal);

/***/ }),

/***/ 1412:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1413:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1414:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1415:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1416:
/***/ (function(module, exports) {

var template = "\n    <div class=\"xl-icon risk-flag-icon dropdown-button {{ $ctrl.flag | lowercase }}\"\n         bs-popover data-content-template=\"static/9.7.16/xlr-components/flag-picker-component/flag-picker-popover-partial.html\" data-placement=\"bottom\" auto-close=\"true\">     \n    </div>\n    ";
var FlagPickerComponent = {
  bindings: {
    flag: '<',
    onUpdate: '&'
  },
  template: template
};
angular.module('xlrelease').component('flagPicker', FlagPickerComponent);

/***/ }),

/***/ 1417:
/***/ (function(module, exports) {

var template = "\n<div id=\"actions-container\">\n    <ul role=\"list\">\n        <li role=\"listitem\"><a class=\"action\" ng-click=\"$ctrl.removeHelpPopover()\" ng-href=\"{{ $ctrl.documentationURL }}\" target=\"_blank\" rel=\"noopener\" aria-describedby=\"new-tab\">Online documentation</a></li>\n        <li role=\"listitem\"><a class=\"action\" ng-click=\"$ctrl.removeHelpPopover()\" href=\"https://docs.xebialabs.com/xl-release/support-request.html\" target=\"_blank\" rel=\"noopener\" aria-describedby=\"new-tab\">Submit a support request</a></li>\n        <li role=\"listitem\"><a class=\"action\" ng-click=\"$ctrl.removeHelpPopover()\" href=\"https://docs.xebialabs.com/xl-release/suggest-feature.html\" target=\"_blank\" rel=\"noopener\" aria-describedby=\"new-tab\">Suggest a feature</a></li>        \n        <li role=\"listitem\"><a class=\"action\" ng-click=\"$ctrl.removeHelpPopover()\" href=\"https://digital.ai/\" target=\"_blank\" rel=\"noopener\" aria-describedby=\"new-tab\">Digital.ai website</a></li>\n    </ul>    \n</div>\n";

var controller = function controller($uibModal, Doc) {
  var $ctrl = this;
  $ctrl.documentationURL = Doc.getURL();

  $ctrl.removeHelpPopover = function () {
    angular.element('.helpPopover').click();
  };
};

controller.$inject = ['$uibModal', 'Doc'];
var helpPopoverComponent = {
  template: template,
  controller: controller
};
angular.module('xlrelease').component('helpPopover', helpPopoverComponent);

/***/ }),

/***/ 1418:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('xlrMultilevelSubmenu', ['$window', function ($window) {
  return {
    scope: {
      isClosed: '<',
      level: '@',
      onClick: '&'
    },
    restrict: 'E',
    templateUrl: 'static/9.7.16/xlr-components/multilevel-dropdown/multilevel-submenu-partial.html',
    link: function link(scope, element, attr) {
      var subscribe = function subscribe() {
        var items = contextMenu.find('.xlr-ctx-menu-item');

        if (items.length) {
          items.off('mouseenter').on('mouseenter', onMouseEnter(container, $window));
        }
      };

      var unsubscribe = function unsubscribe() {
        var items = contextMenu.find('.xlr-ctx-menu-item');

        if (items.length) {
          items.off('mouseenter');
        }
      };

      scope.items = scope.$eval(attr.items);
      scope.level = scope.$eval(attr.level) || 1; // [div.xlr-ctx-menu-container] > [ul.xlr-ctx-menu] > [li.xlr-ctx-menu-item] > [xlr-submenu]

      var contextMenuItem = element.parent();
      var contextMenu = contextMenuItem.parent();
      var container = contextMenu.parent();

      if (container.length) {
        subscribe();
        var contentId = attr.contentId;
        contextMenuItem.attr('data-content-id', contentId);
        var content = element.children();
        content.attr('data-level', scope.level);
        content.attr('data-id', contentId);
        container.append(content);
      }

      element.remove();
      scope.$watch('isClosed', function (isClosed) {
        if (isClosed) {
          resetActiveElements(container, 0);
        }
      });
      scope.$on('$destroy', unsubscribe);
    }
  };
}]);

function onMouseEnter($container, $window) {
  return function (event) {
    var $li = angular.element(event.currentTarget);
    var $ul = $li.parent();
    var level = $ul.data('level') || 0;
    resetActiveElements($container, level);
    var contentId = $li.data('content-id');

    if (contentId) {
      var $contextMenu = $container.find("ul[data-id=\"".concat(contentId, "\"]"));

      if ($contextMenu.length) {
        $li.addClass('active');
        $contextMenu.addClass('active');

        var _getContentCoords = getContentCoords($li, $ul, $contextMenu, $window),
            top = _getContentCoords.top,
            left = _getContentCoords.left;

        $contextMenu.css({
          top: "".concat(top, "px"),
          left: "".concat(left, "px")
        });
      }
    }
  };
}

function getContentCoords($li, $ul, $contextMenu, $window) {
  var ulPaddingTop = parseInt($ul.css('padding-top'), 10);
  var ulBorderTop = parseInt($ul.css('border-top-width'), 10);
  var ulBorderLeft = parseInt($ul.css('border-left-width'), 10);
  var top = $ul.position().top + $li.position().top - ulPaddingTop + ulBorderTop - 1;
  var left = $ul.position().left + $li.position().left + $li.width() + ulBorderLeft;

  if ($li.offset().top + $contextMenu.height() > $window.innerHeight) {
    top = top - $contextMenu.height() + $li.height();
  }

  return {
    top: top,
    left: left
  };
}

function resetActiveElements(contentContainer, level) {
  var lis = level ? contentContainer.find("ul.xlr-ctx-menu[data-level=\"".concat(level, "\"] li")) : contentContainer.find("ul.xlr-ctx-menu li");
  lis.removeClass('active');
  contentContainer.find("ul.xlr-ctx-menu[data-level=\"".concat(level + 1, "\"]")).removeClass('active');
  contentContainer.find("ul.xlr-ctx-menu[data-level=\"".concat(level + 2, "\"]")).removeClass('active');
}

/***/ }),

/***/ 1419:
/***/ (function(module, exports) {

var template = "\n    <div class=\"modal-header\">\n        <h4 class=\"modal-title pull-left\" id=\"modal-title\">Override permissions</h4>\n        <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.close()\"><i class=\"xl-icon close-icon\"/></button>\n        <div class=\"clearfix\"/>\n    </div>\n    <div class=\"modal-body\" id=\"modal-body\">\n        Permissions and teams will now be taken from <b>{{$ctrl.resolve.inheritedFrom.title}}</b>. Current teams and permissions will be discarded.<br/>\n    </div>\n    <div class=\"modal-footer\">\n        <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button class=\"button continue primary\" type=\"button\" ng-click=\"$ctrl.close({$value: true})\">Ok</button>\n    </div>\n    ";
var overridePermissionsModal = {
  bindings: {
    resolve: '<',
    close: '&',
    dismiss: '&'
  },
  template: template
};
angular.module('xlrelease').component('overridePermissionsModal', overridePermissionsModal);

/***/ }),

/***/ 142:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return ITEMS_PER_PAGE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return DEFAULT_ORDER_BY; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return RELEASE_STATUS_FILTER_KEY_TO_STATUS; });
/* unused harmony export ENTITY_ID_PLACEHOLDER */
var ITEMS_PER_PAGE = 15;
var DEFAULT_ORDER_BY = 'start_date';
var RELEASE_STATUS_FILTER_KEY_TO_STATUS = {
  inProgress: 'IN_PROGRESS',
  completed: 'COMPLETED'
};
var ENTITY_ID_PLACEHOLDER = -1;

/***/ }),

/***/ 1420:
/***/ (function(module, exports) {

var template = "\n<div id=\"actions-container\" style=\"right:0\">\n    <ul>        \n        <li ng-if=\"$ctrl.isAdmin()\"><a class=\"action\" href ng-click=\"$ctrl.getSupportData()\">Get data for support</a></li>\n        <li ng-if=\"$ctrl.isAdmin()\"><a class=\"action\" href ng-click=\"$ctrl.showSystemInformation()\">System information</a></li>\n        <li ng-if=\"$ctrl.isAdmin()\"><a class=\"action\" href ng-click=\"$ctrl.configureSystemMessage()\">Configure system message</a></li>\n        <li ng-if=\"$ctrl.isAdmin()\"><a class=\"action\" ng-click=\"$ctrl.removeSettingPopover()\" href=\"productregistration\">Renew license</a></li>\n        <li class=\"about\"><a class=\"action\" href ng-click=\"$ctrl.openAbout()\">About</a></li>\n        <li class=\"divider\"><a class=\"logout action\" ng-click=\"$ctrl.removeSettingPopover()\" ng-href=\"#/login\">Log out</a></li>\n    </ul>\n</div>\n";

var controller = function controller($uibModal, Authenticator, $rootScope, Events) {
  var $ctrl = this;

  $ctrl.isAdmin = function () {
    return Authenticator.isAdminOr();
  };

  $ctrl.showSystemInformation = function () {
    $ctrl.removeSettingPopover();
    $uibModal.open({
      animation: false,
      component: 'systemInformationModal'
    });
  };

  $ctrl.getSupportData = function () {
    $ctrl.removeSettingPopover();
    $uibModal.open({
      animation: false,
      component: 'supportAcceleratorModal'
    });
  };

  $ctrl.openAbout = function () {
    $ctrl.removeSettingPopover();
    $uibModal.open({
      animation: false,
      controller: 'LicenseController',
      templateUrl: 'partials/menu/about.html'
    });
  };

  $ctrl.configureSystemMessage = function () {
    $ctrl.removeSettingPopover();
    $uibModal.open({
      animation: false,
      component: 'systemMessageModal'
    }).result.then(function (systemMessage) {
      $rootScope.$emit(Events.settings.systemMessageUpdated, systemMessage);
    });
  };

  $ctrl.removeSettingPopover = function () {
    angular.element('.settingPopover').click();
  };
};

controller.$inject = ['$uibModal', 'Authenticator', '$rootScope', 'Events'];
var settingsPopoverComponent = {
  template: template,
  controller: controller
};
angular.module('xlrelease').component('settingsPopover', settingsPopoverComponent);

/***/ }),

/***/ 1421:
/***/ (function(module, exports) {

var template = "\n<div class=\"modal-header\">\n    <button type=\"button\" class=\"close\" ng-click=\"$ctrl.dismiss()\"><i class=\"xl-icon close-icon\"/></button>\n    <h5 class=\"modal-title\">Get data for support</h5>  \n</div>\n<div class=\"modal-body\">\n    <p>When you click <b>Download</b>, Digital.ai Release will create a support analytics ZIP file that you can send to Digital.ai Support when troubleshooting issues. The file \n    contains information about your Release installation, including the contents of the conf, ext, plugins, hotfix, and log directories.</p>\n    \n    <p>Digital.ai Release will attempt to remove configuration passwords from the ZIP file. Please inspect the ZIP file contents to ensure that it does not contain \n    passwords or other sensitive data.</p>\n    \n    <p>See <a href=\"https://support.digital.ai/\" target=\"_blank\" rel=\"noopener\">https://support.digital.ai</a> for more information or to open a support request.</p>\n</div>\n<div class=\"modal-footer\">\n    <button class=\"button primary\" ng-click=\"$ctrl.getSupportData()\">Download</button>\n</div>\n";

var controller = function controller(Download) {
  var $ctrl = this;

  $ctrl.getSupportData = function () {
    Download.launch('support/zip');
    $ctrl.close();
  };
};

controller.$inject = ['Download'];
var SupportAcceleratorModalComponent = {
  template: template,
  bindings: {
    close: '&',
    dismiss: '&'
  },
  controller: controller
};
angular.module('xlrelease').component('supportAcceleratorModal', SupportAcceleratorModalComponent);

/***/ }),

/***/ 1422:
/***/ (function(module, exports) {

angular.module('xlrelease').component('xlrTemplateListComponent', {
  bindings: {
    list: '<',
    templatesLoader: '<',
    onChange: '&',
    responsive: '<?',
    folders: '<'
  },
  bindToController: true,
  controllerAs: 'vm',
  templateUrl: 'static/9.7.16/xlr-components/template-list-component/template-list-partial.html'
});

/***/ }),

/***/ 1423:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1424:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1425:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1426:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1440:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1441:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1442:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1443:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1444:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1445:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1446:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1447:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1448:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1449:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1450:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1451:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1452:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1453:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1454:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1455:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1456:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1479:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1480:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1481:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1482:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1484:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1485:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1486:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1487:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1488:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1491:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1492:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1493:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1494:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1495:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1497:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1498:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1499:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 15:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return registerRequestInterceptor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return registerResponseInterceptors; });
/* unused harmony export directHttpRequest */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return httpRequest; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return httpCodes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return httpGET; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return httpPOST; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return httpPUT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return httpDELETE; });
/* unused harmony export httpPOSTBlob */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return httpGETBlob; });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(199);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_http_backend__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(174);


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var instance = axios__WEBPACK_IMPORTED_MODULE_1___default.a.create();
var registerRequestInterceptor = function registerRequestInterceptor(requestInterceptor) {
  instance.interceptors.request.use(requestInterceptor, function (error) {
    return error;
  });
};
var registerResponseInterceptors = function registerResponseInterceptors(successInterceptor, errorInterceptor) {
  instance.interceptors.response.use(successInterceptor, errorInterceptor);
};
var directHttpRequest = function directHttpRequest(method, url, config, headers) {
  var requestObject = _objectSpread({}, config, {
    headers: headers,
    method: method,
    url: url
  });

  return instance.request(requestObject);
};
var httpRequest = function httpRequest(method, url, config) {
  var accept = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'application/json';
  var cancelTokenSource = _js_http_backend__WEBPACK_IMPORTED_MODULE_2__[/* Backend */ "a"].cancelTokenSource();
  config = config || {};
  config.cancelToken = cancelTokenSource.token;
  return directHttpRequest(method, "".concat(url), config, {
    'Accept': accept,
    'Accept-Type': accept,
    'X-HTTP-Auth-Override': 'true'
  });
};
var httpCodes = {
  UNAUTHORIZED: 401,
  PAYMENT_REQUIRED: 402,
  FORBIDDEN: 403,
  VERSION_CHANGED: 410
};
function httpGET(url) {
  var hideAlert = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  return httpRequest('GET', url, {
    hideAlert: hideAlert
  });
}
function httpPOST(url, data) {
  return httpRequest('POST', url, {
    data: data
  });
}
function httpPUT(url, data) {
  return httpRequest('PUT', url, {
    data: data
  });
}
function httpDELETE(url, data) {
  return httpRequest('DELETE', url, {
    data: data
  });
}
function httpPOSTBlob(url, data) {
  var hideAlert = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return httpRequest('POST', url, {
    data: data,
    hideAlert: hideAlert,
    responseType: 'blob'
  }, '*/*');
}
function httpGETBlob(url, data) {
  var hideAlert = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return httpRequest('GET', url, {
    data: data,
    hideAlert: hideAlert,
    responseType: 'blob'
  }, '*/*');
}

/***/ }),

/***/ 1500:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1501:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1502:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 174:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Backend; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(41);
/* harmony import */ var angular__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(angular__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var ngimport__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(84);
/* harmony import */ var ngimport__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(ngimport__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _xlrelease__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(175);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(199);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_6__);




function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }





var Backend;

var BackendServiceImpl = /*#__PURE__*/function () {
  function BackendServiceImpl() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, BackendServiceImpl);

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2___default()(this, "canceller", ngimport__WEBPACK_IMPORTED_MODULE_4__["$q"].defer());

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2___default()(this, "_cancelTokenSource", axios__WEBPACK_IMPORTED_MODULE_6___default.a.CancelToken.source());
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(BackendServiceImpl, [{
    key: "post",
    value: function post(url, data, config) {
      if (Object(angular__WEBPACK_IMPORTED_MODULE_3__["isUndefined"])(data)) {
        data = {};
      }

      return ngimport__WEBPACK_IMPORTED_MODULE_4__["$http"].post(url, data, this._extendWithTimeout(url, config));
    }
  }, {
    key: "get",
    value: function get(url, config) {
      return ngimport__WEBPACK_IMPORTED_MODULE_4__["$http"].get(url, this._extendWithTimeout(url, this._extendWithVersion(this._extendWithCacheBuster(config))));
    }
  }, {
    key: "put",
    value: function put(url, data, config) {
      if (Object(angular__WEBPACK_IMPORTED_MODULE_3__["isUndefined"])(data)) {
        data = {};
      }

      return ngimport__WEBPACK_IMPORTED_MODULE_4__["$http"].put(url, data, this._extendWithTimeout(url, this._extendWithVersion(config)));
    }
  }, {
    key: "del",
    value: function del(url, config) {
      var extendedConfig = Object(angular__WEBPACK_IMPORTED_MODULE_3__["extend"])({}, BackendServiceImpl.DELETE_CONFIG, config);
      extendedConfig.url = url;
      return Object(ngimport__WEBPACK_IMPORTED_MODULE_4__["$http"])(this._extendWithTimeout(url, this._extendWithVersion(extendedConfig)));
    } // overridden in unit tests

  }, {
    key: "_extendWithCacheBuster",
    value: function _extendWithCacheBuster(config) {
      var cacheBuster = {
        cb: new Date().getTime()
      };
      return this.addParams(config, cacheBuster);
    }
  }, {
    key: "_extendWithVersion",
    value: function _extendWithVersion(config) {
      var version = {
        xlrv: _xlrelease__WEBPACK_IMPORTED_MODULE_5__[/* default */ "a"].version
      };
      return this.addParams(config, version);
    }
  }, {
    key: "_extendWithTimeout",
    value: function _extendWithTimeout(url, config) {
      if ((config === null || config === void 0 ? void 0 : config.timeout) != null) {
        return config;
      } else {
        return _objectSpread({}, config, {
          timeout: this.canceller.promise
        });
      }
    }
  }, {
    key: "addParams",
    value: function addParams(config, params) {
      var extendedConfig = config ? Object(angular__WEBPACK_IMPORTED_MODULE_3__["copy"])(config) : {};
      extendedConfig.params = Object(angular__WEBPACK_IMPORTED_MODULE_3__["extend"])({}, extendedConfig.params || {}, params);
      return extendedConfig;
    }
  }, {
    key: "cancel",
    value: function cancel() {
      this._cancelTokenSource.cancel("Cancelled by backend");

      this._cancelTokenSource = axios__WEBPACK_IMPORTED_MODULE_6___default.a.CancelToken.source();
      this.canceller.resolve("Cancelled");
      this.canceller = ngimport__WEBPACK_IMPORTED_MODULE_4__["$q"].defer();
    }
  }, {
    key: "cancelTokenSource",
    value: function cancelTokenSource() {
      return this._cancelTokenSource;
    }
  }]);

  return BackendServiceImpl;
}();

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2___default()(BackendServiceImpl, "DELETE_CONFIG", {
  method: 'DELETE',
  // IE 8 do not support $http.delete()
  data: null,
  // Without data, Content-Type is deleted
  headers: {
    'Content-Type': 'application/json' // Without Content-Type, Browser's default Content-Type is used

  }
});

Object(angular__WEBPACK_IMPORTED_MODULE_3__["module"])('xlrelease').service('Backend', BackendServiceImpl);
Object(angular__WEBPACK_IMPORTED_MODULE_3__["module"])('xlrelease').run(function () {
  return Backend = ngimport__WEBPACK_IMPORTED_MODULE_4__["$injector"].get('Backend');
});

/***/ }),

/***/ 175:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return XLRelease; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__);



var XLRelease = function XLRelease() {
  _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, XLRelease);
};

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(XLRelease, "version", '9.7.16');



/***/ }),

/***/ 180:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return TIME_FRAME_TYPES; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return TIME_FRAME_LABELS; });
var TIME_FRAME_TYPES = {
  LAST_MONTH: 'LAST_MONTH',
  LAST_THREE_MONTHS: 'LAST_THREE_MONTHS',
  LAST_SIX_MONTHS: 'LAST_SIX_MONTHS',
  LAST_YEAR: 'LAST_YEAR',
  RANGE: 'RANGE'
};
var TIME_FRAME_LABELS = {
  LAST_MONTH: 'Last 30 days',
  LAST_THREE_MONTHS: 'Last 3 months',
  LAST_SIX_MONTHS: 'Last 6 months',
  LAST_YEAR: 'Last year',
  RANGE: 'Range'
};

/***/ }),

/***/ 211:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return NoData; });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(0);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _no_data_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(491);
/* harmony import */ var _no_data_less__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_no_data_less__WEBPACK_IMPORTED_MODULE_2__);



var NoData = function NoData(_ref) {
  var className = _ref.className,
      message = _ref.message;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: 'no-data-message' + (className ? " ".concat(className) : '')
  }, message);
};
NoData.propTypes = {
  className: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.string,
  message: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.node.isRequired
};

/***/ }),

/***/ 214:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/constants.js
var angularJsDateFormatToMomentFormat = {
  'd/M/yy': 'D/M/YY',
  'M/d/yy': 'M/D/YY',
  'dd/MM/yy': 'DD/MM/YY',
  'yy/MM/dd': 'YY/MM/DD',
  'MMM d, y': 'MMM DD, YYYY',
  'dd MMM y': 'DD MMM YYYY',
  'y MMM dd': 'YYYY MMM DD'
};
var angularJsTimeFormatToMomentFormat = {
  'HH:mm': 'HH:mm',
  'h:mm a': 'h:mm A'
};
// EXTERNAL MODULE: ./node_modules/moment/moment.js-exposed
var moment_js_exposed = __webpack_require__(43);
var moment_js_exposed_default = /*#__PURE__*/__webpack_require__.n(moment_js_exposed);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/utils.js
/* unused harmony export parseDateTimeFormat */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return formatDateTime; });


function parseDateTimeFormat(date, dateFormat, timeFormat) {
  var format = "".concat(dateFormat, " ").concat(timeFormat);

  if (angularJsDateFormatToMomentFormat[dateFormat]) {
    format = "".concat(angularJsDateFormatToMomentFormat[dateFormat]);

    if (angularJsTimeFormatToMomentFormat[timeFormat]) {
      format = "".concat(format, " ").concat(angularJsTimeFormatToMomentFormat[timeFormat]);
    } else {
      format = "".concat(format, " ").concat(timeFormat);
    }
  } else {
    // can't find an appropriate format, use default
    format = "YYYY-MM-DD h:mm A";
  }

  return format;
}
function formatDateTime(date, dateFormat, timeFormat) {
  return moment_js_exposed_default()(date).format(parseDateTimeFormat(date, dateFormat, timeFormat));
}

/***/ }),

/***/ 215:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return showError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return showServerDownError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AlertsFactory; });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(176);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_isFunction__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85);
/* harmony import */ var lodash_isFunction__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_isFunction__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util_toastrFactory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(51);
/* harmony import */ var pluralize__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(76);
/* harmony import */ var pluralize__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(pluralize__WEBPACK_IMPORTED_MODULE_3__);





function getResponseData(response) {
  var contentType = getHeader(response, 'content-type');

  if (contentType && !contentType.includes('text/html')) {
    if (response.data instanceof Blob) {
      return 'Requested file is not found';
    }

    if (getHeader(response, 'x-validation-exception', "false") === "true") {
      return extractValidationMessages(response);
    }

    return response.data;
  }

  return '';
}

function extractValidationMessages(response) {
  var validationMessages = response.data["validation-messages"];
  var messages = validationMessages.map(function (item) {
    return "<p>".concat(item.message, "</p>");
  });
  return "There ".concat(pluralize__WEBPACK_IMPORTED_MODULE_3___default()('was', validationMessages.length), " ").concat(validationMessages.length, " validation ").concat(pluralize__WEBPACK_IMPORTED_MODULE_3___default()('error', validationMessages.length), ". ").concat(messages.join(""));
}

function getHeader(response, headerName) {
  var defaultVal = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';

  //we need this logic because we are still using different approaches to call a server
  if (lodash_isFunction__WEBPACK_IMPORTED_MODULE_1___default()(response.headers)) {
    //this is true for calls from $http
    return lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(response.headers(), headerName, defaultVal);
  } else {
    return lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(response.headers, headerName, defaultVal); //this is true for calls from axios
  }
}

function getAlertMsg(response) {
  var responseData = getResponseData(response);
  var path = getHeader(response, 'x-path', response.config.url);
  var date = getHeader(response, 'date');
  return "\n        <div class='alert-details'>\n            <p>".concat(responseData, "</p>\n            <p>Status code: ").concat(response.status, "</p>\n            <p><strong>").concat(response.config.method, " ").concat(path, "</strong></p>\n            <p>").concat(date, "</p>\n        </div>").split('\n').join('');
}

var toaster = Object(_js_util_toastrFactory__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])();
function showError(response) {
  toaster.error(getAlertMsg(response), 'An error occurred', {
    escapeHtml: false
  });
}
function showServerDownError() {
  toaster.error('The Release server is not available', 'An error occurred');
}
function AlertsFactory() {
  return {
    error: showError,
    serverDownError: showServerDownError
  };
}

/***/ }),

/***/ 2272:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/@rweda/layout/source/stable/jquery.layout.js
var jquery_layout = __webpack_require__(835);

// EXTERNAL MODULE: ./node_modules/blueimp-file-upload/js/jquery.fileupload.js
var jquery_fileupload = __webpack_require__(836);

// EXTERNAL MODULE: ./node_modules/blueimp-file-upload/js/jquery.iframe-transport.js
var jquery_iframe_transport = __webpack_require__(840);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/classCallCheck.js
var classCallCheck = __webpack_require__(4);
var classCallCheck_default = /*#__PURE__*/__webpack_require__.n(classCallCheck);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/createClass.js
var createClass = __webpack_require__(5);
var createClass_default = /*#__PURE__*/__webpack_require__.n(createClass);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/auth/authentication-registry.js



var authentication_registry_AuthenticationRegistry = /*#__PURE__*/function () {
  function AuthenticationRegistry() {
    classCallCheck_default()(this, AuthenticationRegistry);

    this.providers = new Map();
  }

  createClass_default()(AuthenticationRegistry, [{
    key: "provider",
    value: function provider(name, config) {
      this.providers.set(name, config);
    }
  }, {
    key: "getProvider",
    value: function getProvider(name) {
      return this.providers.get(name);
    }
  }, {
    key: "getProviders",
    value: function getProviders() {
      return _.sortBy(Array.from(this.providers.values()), 'order');
    }
  }, {
    key: "getAutoProviders",
    value: function getAutoProviders() {
      return _.filter(this.getProviders(), 'autoLogin');
    }
  }, {
    key: "getFormProviders",
    value: function getFormProviders() {
      return _.filter(this.getProviders(), 'formLogin');
    }
  }]);

  return AuthenticationRegistry;
}();

angular.module('xlrelease').service('AuthenticationRegistry', authentication_registry_AuthenticationRegistry);
angular.module('xlrelease').run(['AuthenticationRegistry', '$state', 'RedirectOnLoginService', function (AuthenticationRegistry, $state, RedirectOnLoginService) {
  AuthenticationRegistry.provider('default', {
    order: 10,
    autoLogin: true,
    formLogin: false,
    login: function login() {
      RedirectOnLoginService.registerRequestedURL();
      $state.go('login');
      return true;
    }
  });
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/auth/authenticator.js
var authenticator = __webpack_require__(841);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/auth/base64.js
var base64 = __webpack_require__(842);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/auth/redirect-on-login-service.js
var redirect_on_login_service = __webpack_require__(843);

// CONCATENATED MODULE: ./core/xlr-ui/app/features/folders/folder-constants.js
var DEFAULT_FOLDER_TAB = 'templates';
// CONCATENATED MODULE: ./core/xlr-ui/app/js/breadcrumbs/breadcrumbs-service.js




(function () {
  var BreadcrumbsService = /*#__PURE__*/function () {
    function BreadcrumbsService($rootScope, Events, FolderPathService) {
      classCallCheck_default()(this, BreadcrumbsService);

      this._$rootScope = $rootScope;
      this._Events = Events;
      this._FolderPathService = FolderPathService;
    }

    createClass_default()(BreadcrumbsService, [{
      key: "_mapAndUpdateBreadcrumbs",
      value: function _mapAndUpdateBreadcrumbs(folders, ci) {
        var breadcrumbs = [];

        _.forEach(folders, function (folder) {
          breadcrumbs.push({
            pathSuffix: 'folders/' + folder.id + "/".concat(DEFAULT_FOLDER_TAB),
            label: folder.title
          });
        });

        breadcrumbs.push({
          label: ci.title
        });
        this.updateBreadcrumbs(breadcrumbs, false);
      }
    }, {
      key: "updateBreadcrumbs",
      value: function updateBreadcrumbs(breadcrumbs) {
        var dropFirstCrumb = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
        breadcrumbs = breadcrumbs.length > 1 && dropFirstCrumb ? _.drop(breadcrumbs) : breadcrumbs;

        this._$rootScope.$emit(this._Events.breadcrumbs.update, breadcrumbs);
      }
    }, {
      key: "updateBreadcrumbsWithRelease",
      value: function updateBreadcrumbsWithRelease(release) {
        var _this = this;

        this._FolderPathService.getPathFromReleaseId(release.id).then(function (folders) {
          _this._mapAndUpdateBreadcrumbs(folders, release);
        });
      }
    }, {
      key: "updateBreadcrumbsWithEntity",
      value: function updateBreadcrumbsWithEntity(folderId, entity) {
        var _this2 = this;

        this._FolderPathService.getPathFromParentFolderId(folderId).then(function (folders) {
          _this2._mapAndUpdateBreadcrumbs(folders, entity);
        });
      }
    }, {
      key: "updateBreadcrumbsWithDelivery",
      value: function updateBreadcrumbsWithDelivery(delivery) {
        var breadcrumbs = [];
        breadcrumbs.push({
          pathSuffix: 'deliveries',
          label: 'Deliveries'
        });
        breadcrumbs.push({
          label: delivery.title
        });
        this.updateBreadcrumbs(breadcrumbs, false);
      }
    }, {
      key: "updateBreadcrumbsWithFolder",
      value: function updateBreadcrumbsWithFolder(folder) {
        var _this3 = this;

        this._FolderPathService.getPathFromFolderId(folder.id).then(function (folders) {
          _this3._mapAndUpdateBreadcrumbs(folders, folder);
        });
      }
    }, {
      key: "updateBreadcrumbsWithRiskProfile",
      value: function updateBreadcrumbsWithRiskProfile(riskProfile) {
        var breadcrumbs = [];
        breadcrumbs.push({
          pathSuffix: 'risks',
          label: 'Risk profile settings'
        });
        breadcrumbs.push({
          label: riskProfile.title || "Create new risk profile "
        });
        this.updateBreadcrumbs(breadcrumbs, false);
      }
    }, {
      key: "updateBreadcrumbsWithDashboard",
      value: function updateBreadcrumbsWithDashboard(dashboard) {
        var _this4 = this;

        this._FolderPathService.getPathFromParentFolderId(dashboard.parentId).then(function (folders) {
          _this4._mapAndUpdateBreadcrumbs(folders, dashboard);
        });
      }
    }]);

    return BreadcrumbsService;
  }();

  BreadcrumbsService.$inject = ['$rootScope', 'Events', 'FolderPathService'];
  angular.module('xlrelease').service('BreadcrumbsService', BreadcrumbsService);
})();
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/defineProperty.js
var defineProperty = __webpack_require__(1);
var defineProperty_default = /*#__PURE__*/__webpack_require__.n(defineProperty);

// EXTERNAL MODULE: ./node_modules/angular/index.js
var node_modules_angular = __webpack_require__(41);
var angular_default = /*#__PURE__*/__webpack_require__.n(node_modules_angular);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/system-message/system-message-service.js





var system_message_service_SystemMessageService = /*#__PURE__*/function () {
  function SystemMessageService(Backend, $rootScope, Events) {
    classCallCheck_default()(this, SystemMessageService);

    defineProperty_default()(this, "SYSTEM_MESSAGE_ID", 'Configuration/settings/SystemMessageSettings');

    this.Backend = Backend;
    this.$rootScope = $rootScope;
    this.Events = Events;
    this.systemMessage = undefined;
  }

  createClass_default()(SystemMessageService, [{
    key: "saveSystemMessage",
    value: function saveSystemMessage(systemMessage) {
      var _this = this;

      return this.Backend.put("settings/ci/".concat(this.SYSTEM_MESSAGE_ID), systemMessage).then(function (response) {
        _this.systemMessage = response.data;
        return angular_default.a.copy(_this.systemMessage);
      });
    }
  }, {
    key: "loadSystemMessage",
    value: function loadSystemMessage() {
      var _this2 = this;

      return this.Backend.get("settings/system-message").then(function (response) {
        _this2.systemMessage = response.data;
        return angular_default.a.copy(_this2.systemMessage);
      });
    }
  }, {
    key: "emitSystemMessage",
    value: function emitSystemMessage() {
      var _this3 = this;

      if (angular_default.a.isDefined(this.systemMessage)) {
        this.$rootScope.$emit(this.Events.settings.systemMessageUpdated, this.systemMessage);
      } else {
        this.loadSystemMessage().then(function (systemMessage) {
          _this3.$rootScope.$emit(_this3.Events.settings.systemMessageUpdated, systemMessage);
        });
      }
    }
  }, {
    key: "isMessageEnabled",
    value: function isMessageEnabled(systemMessage) {
      if (angular_default.a.isUndefined(systemMessage)) return false;
      return (!!systemMessage.automated && !!systemMessage.enabled && this._isInRange(systemMessage.startDate, systemMessage.endDate) || !systemMessage.automated && !!systemMessage.enabled) && !!systemMessage.message;
    }
  }, {
    key: "_isInRange",
    value: function _isInRange(startDate, endDate) {
      if (startDate === null || endDate === null) return false;
      return moment().isBetween(startDate, endDate);
    }
  }]);

  return SystemMessageService;
}();

defineProperty_default()(system_message_service_SystemMessageService, "$inject", ['Backend', '$rootScope', 'Events']);

angular_default.a.module('xlrelease').service('SystemMessageService', system_message_service_SystemMessageService);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/calendar/calendar-service.js




var calendar_service_CalendarService = /*#__PURE__*/function () {
  function CalendarService(Backend) {
    classCallCheck_default()(this, CalendarService);

    defineProperty_default()(this, "_withinBlackoutUrl", _.constant('calendar/blackouts/withinBlackout'));

    this.Backend = Backend;
  } // BLACKOUTS


  createClass_default()(CalendarService, [{
    key: "getBlackout",
    value: function getBlackout(id) {
      return this.Backend.get(this._blackoutsUrl(id));
    }
  }, {
    key: "getBlackouts",
    value: function getBlackouts(range) {
      var params = {
        from: range.from.valueOf(),
        to: range.to.valueOf()
      };
      return this.Backend.get(this._blackoutsUrl(), {
        params: params
      });
    }
  }, {
    key: "saveBlackout",
    value: function saveBlackout(blackout) {
      return blackout.id ? this._updateBlackout(blackout) : this._createBlackout(blackout);
    }
  }, {
    key: "deleteBlackout",
    value: function deleteBlackout(id) {
      return this.Backend.del(this._blackoutsUrl(id));
    }
  }, {
    key: "_createBlackout",
    value: function _createBlackout(blackout) {
      return this.Backend.post(this._blackoutsUrl(), this._toBlackoutForm(blackout));
    }
  }, {
    key: "_updateBlackout",
    value: function _updateBlackout(blackout) {
      return this.Backend.put(this._blackoutsUrl(blackout.id), this._toBlackoutForm(blackout));
    }
  }, {
    key: "_toBlackoutForm",
    value: function _toBlackoutForm(blackout) {
      return {
        id: blackout.id || null,
        type: 'xlrelease.Blackout',
        label: blackout.label,
        startDate: moment(blackout.startDate).toISOString(),
        endDate: moment(blackout.endDate).toISOString()
      };
    } // SPECIAL DAYS

  }, {
    key: "getSpecialDay",
    value: function getSpecialDay(date) {
      return this.Backend.get(this._specialDaysUrl(date));
    }
  }, {
    key: "setSpecialDay",
    value: function setSpecialDay(date, specialDay) {
      var params = {
        id: null,
        type: 'xlrelease.SpecialDay',
        label: specialDay.label,
        color: specialDay.color
      };
      return this.Backend.put(this._specialDaysUrl(date), params);
    }
  }, {
    key: "getSpecialDays",
    value: function getSpecialDays(range) {
      var params = {
        from: range.from.valueOf(),
        to: range.to.valueOf()
      };
      return this.Backend.get(this._specialDaysUrl(), {
        params: params
      });
    }
  }, {
    key: "specialDayId",
    value: function specialDayId(date) {
      return "Configuration/Calendar/".concat(date.format('YYYYMMDD'));
    }
  }, {
    key: "withinBlackout",
    value: function withinBlackout() {
      return this.Backend.get(this._withinBlackoutUrl());
    } // PRIVATE

  }, {
    key: "_blackoutsUrl",
    value: function _blackoutsUrl(id) {
      return "calendar/blackouts".concat(id ? '/' + id : '');
    }
  }, {
    key: "_specialDaysUrl",
    value: function _specialDaysUrl(date) {
      return "calendar/specialDays".concat(date ? '/' + this.specialDayId(date) : '');
    }
  }]);

  return CalendarService;
}();

defineProperty_default()(calendar_service_CalendarService, "$inject", ['Backend']);

angular.module('xlrelease').service('CalendarService', calendar_service_CalendarService);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/slicedToArray.js
var slicedToArray = __webpack_require__(44);
var slicedToArray_default = /*#__PURE__*/__webpack_require__.n(slicedToArray);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/calendar/calendar-controller.js

angular.module('xlrelease').controller('CalendarController', ['$q', '$scope', '$location', 'CalendarDateService', 'DateService', 'ReleasesService', 'VariablesInterpolator', 'CalendarNavigator', 'ColorService', 'CalendarService', 'month', 'filterSettings', 'Events', 'ClientSettings', 'Filters', 'RegionalSettings', 'EventBus', '$uibModal', 'GlobalPermissions', 'Authenticator', 'TagsService', 'FiltersQueryParams', function ($q, $scope, $location, CalendarDateService, DateService, ReleasesService, VariablesInterpolator, CalendarNavigator, ColorService, CalendarService, month, filterSettings, Events, ClientSettings, Filters, RegionalSettings, EventBus, $uibModal, GlobalPermissions, Authenticator, TagsService, FiltersQueryParams) {
  var URL_DATE_FORMAT = "MM-YYYY";
  var RELEASE_ITEMS_LIMIT = 20;
  $scope.filters = filterSettings;
  $scope.currentDate = moment(month, URL_DATE_FORMAT).locale('en-user').date(1);
  $scope.weekDays = RegionalSettings.weekDays;
  $scope.allTags = [];
  $scope.$on(Events.filters.filterChanged, function (e, filters) {
    load();
    ClientSettings.setCalendarFilters(filters);
  });
  load();

  function load() {
    var calendar = new CalendarDateService($scope.currentDate);
    $scope.calendar = calendar;
    $q.all([getReleases(calendar), getSpecialDays(calendar), getBlackouts(calendar), TagsService.getReleaseTags()]).then(function (_ref) {
      var _ref2 = slicedToArray_default()(_ref, 4),
          releases = _ref2[0],
          specialDays = _ref2[1],
          blackouts = _ref2[2],
          allTags = _ref2[3];

      calendar.updateReleases(releases);
      calendar.updateSpecialDays(specialDays);
      calendar.updateBlackouts(blackouts);
      $scope.months = calendar.months;
      $scope.weeks = calendar.weeks;
      $scope.allTags = allTags;
    });
  }

  function refreshBlackouts() {
    getBlackouts($scope.calendar).then(function (blackouts) {
      $scope.calendar.updateBlackouts(blackouts);
    });
  }

  $scope.refreshBlackouts = refreshBlackouts;

  function getReleases(calendar) {
    var filters = angular.copy($scope.filters);
    filters.from = calendar.from.toDate().getTime();
    filters.to = calendar.to.toDate().getTime();
    $scope.releasesDependencies = {};
    return ReleasesService.searchFull(filters, {
      params: {
        numberbypage: RELEASE_ITEMS_LIMIT
      }
    }).then(function (response) {
      var releases = _.reject(response.data.cis, 'tutorial');

      $scope.maxLimitReached = _.size(response.data.cis) === RELEASE_ITEMS_LIMIT;
      $scope.releasesVariables = _.fromPairs(_.map(releases, function (release) {
        return [release.id, release.variables];
      }));
      return releases;
    });
  }

  function getSpecialDays(calendar) {
    return CalendarService.getSpecialDays({
      from: calendar.from,
      to: calendar.to
    }).then(function (response) {
      return response.data;
    });
  }

  function getBlackouts(calendar) {
    return CalendarService.getBlackouts({
      from: calendar.from,
      to: calendar.to
    }).then(function (response) {
      return response.data;
    });
  }

  $scope.loadReleaseDetails = function (release) {
    if (!_.has($scope.releasesDependencies, release.id)) {
      $scope.loadingDetails = true;
      ReleasesService.getReleaseDependencies(release.id).then(function (response) {
        $scope.releasesDependencies[release.id] = response.data;
        $scope.loadingDetails = false;
      });
    }
  };

  $scope.getIncomingDependencies = function (releaseId) {
    return getDependenciesByType(releaseId, 'incomingDependencies');
  };

  $scope.getOutgoingDependencies = function (releaseId) {
    return getDependenciesByType(releaseId, 'outgoingDependencies');
  };

  function getDependenciesByType(releaseId, property) {
    var releaseDependencies = $scope.releasesDependencies[releaseId];
    return releaseDependencies ? releaseDependencies[property] : [];
  }

  function loadMonth(month) {
    FiltersQueryParams.shouldReload(true);
    $location.search('month', month);
  }

  $scope.showNavigator = CalendarNavigator.isNavigatorOpen();

  $scope.showDate = function (date) {
    loadMonth(date.format(URL_DATE_FORMAT));
  };

  $scope.showToday = function () {
    loadMonth(DateService.getToday().date(1).format(URL_DATE_FORMAT));
  };

  $scope.showPreviousMonth = function () {
    loadMonth(moment($scope.currentDate).subtract(1, "months").format(URL_DATE_FORMAT));
  };

  $scope.showNextMonth = function () {
    loadMonth(moment($scope.currentDate).add(1, "months").format(URL_DATE_FORMAT));
  };

  $scope.isCurrentMonth = function (month) {
    return month.fullDate.month() === $scope.currentDate.month() && month.fullDate.year() === $scope.currentDate.year();
  };

  $scope.interpolate = function (title, releaseId) {
    if (title) {
      return VariablesInterpolator.interpolateInText($scope.releasesVariables[releaseId], title);
    }
  };

  $scope.toggleNavigator = function () {
    $scope.showNavigator = CalendarNavigator.toggleNavigator();
  };

  $scope.openDay = function (day) {
    Filters.getCalendarFilterSettings().then(function (filters) {
      var from = moment(day.fullDate).startOf('day');
      filters = _.assignIn(filters, {
        from: from.toDate().getTime(),
        to: from.add(1, 'days').toDate().getTime(),
        fromCalendar: true
      });
      filters = Filters.asQueryString(filters);
      ReleasesService.redirectToOverview(filters);
    });
  };

  $scope.isReleaseCompleted = ReleasesService.isReleaseCompleted;
  $scope.downloadCalendar = ReleasesService.downloadCalendar;
  $scope.computeDayColor = ColorService.computeDayColor;
  $scope.computePhaseColor = ColorService.computePhaseColor;

  function openSpecialDayModal(data) {
    $uibModal.open({
      animation: false,
      component: 'specialDayModal',
      resolve: {
        day: data.day
      }
    }).result.then(function (specialDay) {
      data.day.label = specialDay.label;
      data.day.color = specialDay.color;
    });
  }

  function openBlackoutModal(data) {
    $uibModal.open({
      animation: false,
      component: 'blackoutEditModal',
      resolve: {
        date: data.day.fullDate
      }
    }).result.then(refreshBlackouts);
  }

  $scope.$on("$destroy", function () {
    EventBus.removeListener(Events.calendar.setLabel, openSpecialDayModal);
    EventBus.removeListener(Events.calendar.setBlackout, openBlackoutModal);
  });
  EventBus.addListener(Events.calendar.setLabel, openSpecialDayModal);
  EventBus.addListener(Events.calendar.setBlackout, openBlackoutModal);

  $scope.getContextMenuOptions = function (day) {
    var contextMenu = [{
      title: day.label ? 'Edit label' : 'Set label',
      eventType: Events.calendar.setLabel,
      data: {
        day: day
      },
      icon: 'xl-icon edit-icon',
      disabled: false
    }];

    if (Authenticator.hasPermission(GlobalPermissions.EDIT_GLOBAL_BLACKOUT)) {
      contextMenu.push({
        title: 'Set blackout period',
        eventType: Events.calendar.setBlackout,
        data: {
          day: day
        },
        icon: 'xl-icon circle-minus-icon',
        disabled: false
      });
    }

    return contextMenu;
  };
}]);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/calendar/calendar-date-service.js


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

angular.module('xlrelease').factory('CalendarDateService', ['DateService', 'ReleasesService', 'Ids', 'CalendarService', 'Planner', function (DateService, ReleasesService, Ids, CalendarService, Planner) {
  var TOTAL_WEEKS_DISPLAYED = 6;
  var TOTAL_MONTHS_DISPLAYED = 20;
  var URL_DATE_FORMAT = "MM-YYYY";

  function CalendarDateService(date) {
    this.weeks = getWeeks(date);
    this.months = getMonths(date);
    this.from = moment(this.weeks[0].days[0].fullDate);
    this.to = moment(this.from).add(TOTAL_WEEKS_DISPLAYED, 'week');
  }

  CalendarDateService.prototype.updateReleases = function (releases) {
    updateReleases(releases, this.weeks);
  };

  CalendarDateService.prototype.updateBlackouts = function (blackouts) {
    updateBlackouts(blackouts, this.weeks);
  };

  CalendarDateService.prototype.updateSpecialDays = function (specialDays) {
    updateSpecialDays(specialDays, this.weeks);
  };

  CalendarDateService.currentMonth = function () {
    return DateService.getToday().date(1).format(URL_DATE_FORMAT);
  }; // Visible for testing


  CalendarDateService.getNumberOfDaysAfter = function (startDate, firstDayOfWeek) {
    var diff = startDate.diff(firstDayOfWeek, 'days', true);
    return diff < 0 ? 0 : diff;
  }; // Visible for testing


  CalendarDateService.getDuration = function (startDate, endDate, firstDay, lastDay) {
    return lastDay.diff(firstDay, 'days') - this.getNumberOfDaysAfter(startDate, firstDay) - this.getNumberOfDaysAfter(lastDay, endDate);
  }; // Visible for testing


  CalendarDateService.isActiveDuringWeek = function (startDate, dueDate, firstDayOfWeek) {
    var lastDayOfWeek = moment(firstDayOfWeek).add(7, 'days');
    return startDate && dueDate && firstDayOfWeek.isBefore(dueDate) && lastDayOfWeek.isAfter(startDate);
  };

  function getWeeks(date) {
    var weeks = [];
    var day = moment(date).weekday(0); // first day of current week

    for (var weekIndex = 0; weekIndex < TOTAL_WEEKS_DISPLAYED; weekIndex++) {
      var firstDayOfWeek = DateService.atMidnight(day.toISOString());
      weeks.push({
        days: getDaysOfTheWeek(firstDayOfWeek),
        releases: [],
        blackouts: []
      });
      day.add(7, 'days');
    }

    return weeks;
  }

  function getDaysOfTheWeek(firstDayOfWeek) {
    var dayInWeek = moment(firstDayOfWeek);
    var days = [];

    for (var dayIndex = 0; dayIndex < 7; dayIndex++) {
      days.push({
        date: dayInWeek.date(),
        month: dayInWeek.format("MMMM"),
        dateStatus: DateService.getDateStatus(dayInWeek),
        fullDate: moment(dayInWeek),
        year: dayInWeek.format("YYYY")
      });
      dayInWeek.add(1, 'days');
    }

    return days;
  }

  function getMonths(date) {
    var firstDayOfCalendar = moment(date).date(1).subtract(TOTAL_MONTHS_DISPLAYED / 2 - 1, 'months');
    return getListOfMonths(TOTAL_MONTHS_DISPLAYED, firstDayOfCalendar);
  }

  function getListOfMonths(numberOfMonths, firstDayOfCalendar) {
    var months = [];
    var firstDayOfMonth = moment(firstDayOfCalendar);

    for (var i = 0; i < numberOfMonths; i++) {
      months.push({
        title: firstDayOfMonth.format("MMMM"),
        year: firstDayOfMonth.format("YYYY"),
        index: firstDayOfMonth.month(),
        fullDate: moment(firstDayOfMonth)
      });
      firstDayOfMonth.add(1, 'months');
    }

    return months;
  }

  function isInsideRelease(release, phase) {
    var releaseStartDate = DateService.getStartOrScheduledDate(release);
    var releaseEndDate = DateService.getEndOrDueDate(release);
    var phaseStartDate = DateService.getStartOrScheduledDate(phase);
    var phaseEndDate = DateService.getEndOrDueDate(phase);
    return moment(phaseStartDate).isBefore(moment(releaseEndDate)) && moment(phaseEndDate).isAfter(moment(releaseStartDate));
  }

  function updateReleases(releases, weeks) {
    var plannedReleases = _.map(releases, function (release) {
      Planner.setRelease(release);
      Planner.setReleaseTree(null);
      var plan = Planner.makePlan(false);
      return angular.extend(release, {
        startDate: plan.displayStartDate,
        endDate: plan.displayEndDate,
        plannedDuration: plan.displayDuration,
        phases: _.map(release.phases, function (phase) {
          var phasePlan = _.find(plan.elements, {
            id: phase.id
          });

          return _objectSpread({}, phase, {}, {
            startDate: phasePlan.displayStartDate,
            endDate: phasePlan.displayEndDate,
            plannedDuration: phasePlan.displayDuration
          });
        })
      });
    });

    _.forEach(weeks, function (week) {
      var firstDayOfWeek = week.days[0].fullDate;
      var lastDayOfWeek = moment(firstDayOfWeek).add(7, 'days');
      week.releases = getReleasesOfTheWeek(plannedReleases, firstDayOfWeek, lastDayOfWeek);
    });
  }

  function updateBlackouts(blackouts, weeks) {
    _.forEach(weeks, function (week) {
      var firstDayOfWeek = week.days[0].fullDate;
      var lastDayOfWeek = moment(firstDayOfWeek).add(7, 'days');
      week.blackouts = getBlackoutsOfTheWeek(blackouts, firstDayOfWeek, lastDayOfWeek);
    });
  }

  function updateSpecialDays(specialDays, weeks) {
    var specialDaysByDate = _.keyBy(specialDays, 'id');

    var days = _.flatMap(weeks, function (week) {
      return week.days;
    });

    _.forEach(days, function (day) {
      var specialDay = specialDaysByDate[CalendarService.specialDayId(day.fullDate)];

      if (specialDay) {
        day.color = specialDay.color;
        day.label = specialDay.label;
      }
    });
  }

  function getReleasesOfTheWeek(releases, firstDayOfWeek, lastDayOfWeek) {
    var releasesOfTheWeek = [];

    _.forEach(releases, function (release) {
      var startDate = moment(DateService.getStartOrScheduledDate(release));
      var endDate = moment(DateService.getEndOrDueDate(release));

      if (CalendarDateService.isActiveDuringWeek(startDate, endDate, firstDayOfWeek)) {
        var enhancedRelease = angular.copy(release);
        angular.extend(enhancedRelease, {
          currentTask: release.currentTask ? release.currentTask.title : undefined,
          leftDayOffset: CalendarDateService.getNumberOfDaysAfter(startDate, firstDayOfWeek),
          numberOfDay: CalendarDateService.getDuration(startDate, endDate, firstDayOfWeek, lastDayOfWeek),
          displayablePhases: getDisplayablePhases(enhancedRelease, firstDayOfWeek, lastDayOfWeek)
        });
        releasesOfTheWeek.push(enhancedRelease);
      }
    });

    return releasesOfTheWeek;
  }

  function getBlackoutsOfTheWeek(blackouts, firstDayOfWeek, lastDayOfWeek) {
    return _.flatMap(blackouts, function (blackout) {
      var startDate = moment(blackout.startDate);
      var endDate = moment(blackout.endDate);

      if (CalendarDateService.isActiveDuringWeek(startDate, endDate, firstDayOfWeek)) {
        var enhancedBlackout = angular.copy(blackout);
        angular.extend(enhancedBlackout, {
          name: Ids.getName(blackout.id),
          leftDayOffset: CalendarDateService.getNumberOfDaysAfter(startDate, firstDayOfWeek),
          numberOfDay: CalendarDateService.getDuration(startDate, endDate, firstDayOfWeek, lastDayOfWeek)
        });
        return [enhancedBlackout];
      } else {
        return [];
      }
    });
  }

  function getDisplayablePhases(release, firstDayOfWeek, lastDayOfWeek) {
    var phases = release.phases;
    var phasesOfTheWeek = [];

    _.forEach(phases, function (phase) {
      if (DateService.getStartOrScheduledDate(phase) && DateService.getEndOrDueDate(phase)) {
        var dates = ReleasesService.cropToReleaseDate(phase, release);
        var startDate = dates.startDate;
        var endDate = dates.endDate;

        if (CalendarDateService.isActiveDuringWeek(startDate, endDate, firstDayOfWeek) && isInsideRelease(release, phase)) {
          phase.leftDayOffset = CalendarDateService.getNumberOfDaysAfter(startDate, firstDayOfWeek);
          phase.numberOfDay = CalendarDateService.getDuration(startDate, endDate, firstDayOfWeek, lastDayOfWeek);
          phasesOfTheWeek.push(phase);
        }
      }
    });

    return phasesOfTheWeek;
  }

  return CalendarDateService;
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/calendar/calendar-directive.js
var calendar_directive = __webpack_require__(848);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/calendar/calendar-resolver.js
var calendar_resolver = __webpack_require__(849);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/calendar/calendar-navigator.js
var calendar_navigator = __webpack_require__(850);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/calendar/calendar-tooltip-directive.js
var calendar_tooltip_directive = __webpack_require__(851);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/calendar/release-title-directive.js
var release_title_directive = __webpack_require__(852);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/calendar/blackout/blackout-delete-modal-component.js




var blackout_delete_modal_component_template = "\n    <div class=\"modal-content\">\n        <div class=\"modal-header\">\n            <button type=\"button\" class=\"close\" ng-click=\"$ctrl.dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n            <h4>Delete Blackout Period</h4>\n        </div>\n        <div class=\"modal-body\">\n            <p>You are about to delete the blackout period <b>{{$ctrl.resolve.blackout.label}}</b>.</p>\n            \n            <p>Tasks with a scheduled start date set by the blackout period will retain the current scheduled start date.</p>\n        </div>\n        <div class=\"modal-footer\">\n            <button type=\"button\" class=\"button cancel\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n            <button type=\"button\" class=\"button continue primary\" focus-on=\"true\" ng-click=\"$ctrl.del()\">Delete</button>\n        </div>\n    </div>\n    ";

var blackout_delete_modal_component_BlackoutDeleteModalController = /*#__PURE__*/function () {
  function BlackoutDeleteModalController(CalendarService) {
    classCallCheck_default()(this, BlackoutDeleteModalController);

    this.CalendarService = CalendarService;
  }

  createClass_default()(BlackoutDeleteModalController, [{
    key: "del",
    value: function del() {
      var _this = this;

      this.CalendarService.deleteBlackout(this.resolve.blackout.id).then(function () {
        return _this.close({
          $value: _this.resolve.blackout
        });
      });
    }
  }]);

  return BlackoutDeleteModalController;
}();

blackout_delete_modal_component_BlackoutDeleteModalController.$inject = ['CalendarService'];
var BlackoutDeleteModal = {
  bindings: {
    resolve: '<',
    close: '&',
    dismiss: '&'
  },
  controller: blackout_delete_modal_component_BlackoutDeleteModalController,
  template: blackout_delete_modal_component_template
};
angular.module('xlrelease').component('blackoutDeleteModal', BlackoutDeleteModal);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/global.constants.js
var global_constants = __webpack_require__(47);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/calendar/blackout/blackout-edit-modal-component.js





var blackout_edit_modal_component_template = "\n    <form name=\"blackoutEditForm\" class=\"form-horizontal\" novalidate>\n        <div class=\"modal-header\">\n            <h4 class=\"modal-title pull-left\" id=\"modal-title\">{{:: $ctrl.resolve.blackout ? 'Edit ' + $ctrl.resolve.blackout.label : 'Set a blackout period' }}</h4>\n            <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.dismiss()\"><i class=\"xl-icon close-icon\"/></button>\n            <div class=\"clearfix\"/>\n        </div>\n        <div class=\"modal-body\" id=\"modal-body\">        \n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\" for=\"label\">\n                    Label <span ng-if=\"blackoutEditForm.label.$touched && blackoutEditForm.label.$error.required\" class=\"error\">*</span>\n                </label>\n                <div class=\"col-sm-9\">\n                    <input type=\"text\" class=\"input-block-level text\" id=\"label\" name=\"label\" ng-model=\"$ctrl.blackout.label\" ng-required=\"true\"/>\n                </div>\n            </div>\n            <div class=\"form-group start-date\">\n                <label class=\"col-sm-3 control-label\" for=\"startDate\">Start date</label>\n                <div class=\"col-sm-9\">\n                    <div date-editor ng-model=\"$ctrl.blackout.startDate\" date-format=\"{{$ctrl.dateFormat}}\" deletable=\"false\" on-change=\"$ctrl.onDateChange($ctrl.blackout.startDate)\"></div>\n                </div>\n            </div>\n            <div class=\"form-group end-date\">\n                <label class=\"col-sm-3 control-label\" for=\"endDate\">End date</label>\n                <div class=\"col-sm-9\">\n                     <div date-editor ng-model=\"$ctrl.blackout.endDate\" date-format=\"{{$ctrl.dateFormat}}\" deletable=\"false\" on-change=\"$ctrl.onDateChange($ctrl.blackout.endDate)\"></div>\n                </div>\n            </div>\n        </div>\n        <div class=\"modal-footer\">\n            <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n            <button class=\"button save primary\" type=\"submit\" ng-click=\"$ctrl.save()\" ng-disabled=\"blackoutEditForm.$invalid\">Save</button>\n        </div>\n    </form>\n    ";

var blackout_edit_modal_component_BlackoutEditModalController = /*#__PURE__*/function () {
  function BlackoutEditModalController(CalendarService) {
    classCallCheck_default()(this, BlackoutEditModalController);

    this.CalendarService = CalendarService;
    this.dateFormat = global_constants["a" /* dateTimeFormat */].ISODateTime;
  }

  createClass_default()(BlackoutEditModalController, [{
    key: "$onInit",
    value: function $onInit() {
      this.blackout = angular.copy(this.resolve.blackout) || {
        startDate: moment(this.resolve.date).startOf('day'),
        endDate: moment(this.resolve.date).endOf('day').milliseconds(0)
      };
    }
  }, {
    key: "save",
    value: function save() {
      var _this = this;

      this.CalendarService.saveBlackout(this.blackout).then(function () {
        return _this.close({
          $value: _this.blackout
        });
      });
    }
  }, {
    key: "onDateChange",
    value: function onDateChange(newDate) {
      if (moment(this.blackout.startDate).isAfter(moment(this.blackout.endDate))) {
        this.blackout.startDate = this.blackout.endDate = newDate;
      }
    }
  }]);

  return BlackoutEditModalController;
}();

blackout_edit_modal_component_BlackoutEditModalController.$inject = ['CalendarService'];
var BlackoutEditModal = {
  bindings: {
    resolve: '<',
    close: '&',
    dismiss: '&'
  },
  controller: blackout_edit_modal_component_BlackoutEditModalController,
  template: blackout_edit_modal_component_template
};
angular.module('xlrelease').component('blackoutEditModal', BlackoutEditModal);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/calendar/blackout/blackout-tooltip-directive.js




var CalendarBlackoutTooltipTemplate = "\n        <div class=\"popover popover-blackout\">\n            <div class=\"arrow\"></div>\n            <div class=\"popover-title\" >\n                <span ng-bind=\"$ctrl.blackout.label\"></span>\n                <a class=\"popover-close\" hide-popover-on-click>\n                  <i class=\"xl-icon close-icon icon-s\" />\n                </a>\n            </div>\n            <div class=\"popover-content\">\n                <table>\n                    <tr><td>Start:</td><td><span class=\"start-date mlm\">{{$ctrl.blackout.startDate | date:'short'}}</span></td></tr>\n                    <tr><td>End:</td><td><span class=\"end-date mlm\">{{$ctrl.blackout.endDate | date:'short'}}</span></td></tr>\n                </table>\n                <div ng-if=\"$ctrl.canEditBlackout\" class=\"popover-actions\">\n                    <a class=\"link edit\" ng-click=\"$ctrl.edit()\" hide-popover-on-click>\n                        <i class=\"xl-icon edit-icon\"></i><span class=\"link\">Edit</span></a>\n                    <a class=\"link delete\" ng-click=\"$ctrl.del()\" hide-popover-on-click>\n                        <i class=\"xl-icon delete-icon\"></i><span>Delete</span></a>\n                </div>\n            </div>\n        </div>\n    ";

var blackout_tooltip_directive_CalendarBlackoutTooltipController = /*#__PURE__*/function () {
  function CalendarBlackoutTooltipController($uibModal, GlobalPermissions, Authenticator) {
    classCallCheck_default()(this, CalendarBlackoutTooltipController);

    this.$uibModal = $uibModal;
    this.canEditBlackout = Authenticator.hasPermission(GlobalPermissions.EDIT_GLOBAL_BLACKOUT);
  }

  createClass_default()(CalendarBlackoutTooltipController, [{
    key: "edit",
    value: function edit() {
      this._openModal('blackoutEditModal');
    }
  }, {
    key: "del",
    value: function del() {
      this._openModal('blackoutDeleteModal');
    }
  }, {
    key: "_openModal",
    value: function _openModal(component) {
      this.$uibModal.open({
        animation: false,
        component: component,
        resolve: {
          blackout: this.blackout
        }
      }).result.then(this.onChange);
    }
  }]);

  return CalendarBlackoutTooltipController;
}();

var CalendarBlackoutTooltipDirective = {
  scope: {
    blackout: '=',
    onChange: '&'
  },
  controller: blackout_tooltip_directive_CalendarBlackoutTooltipController,
  bindToController: true,
  controllerAs: '$ctrl',
  template: CalendarBlackoutTooltipTemplate,
  replace: true
};
angular.module('xlrelease').directive('calendarBlackoutTooltip', ['GlobalPermissions', 'Authenticator', function () {
  return CalendarBlackoutTooltipDirective;
}]);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/calendar/special-day/special-day-modal-component.js




var special_day_modal_component_template = "\n    <div class=\"modal-content\">\n        <div class=\"modal-header\">\n            <button type=\"button\" class=\"close\" ng-click=\"$ctrl.dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n            <h4>Properties for {{ $ctrl.fullDate }}</h4>\n        </div>\n        <div class=\"modal-body\">\n            <form name=\"dayForm\" id=\"dayForm\" class=\"form-horizontal\">\n                <div class=\"form-group\">\n                    <label class=\"col-sm-3 control-label\" for=\"day-label\">Label</label>\n    \n                    <div class=\"col-sm-9\">\n                        <input type=\"text\" class=\"input-block-level\" id=\"day-label\" ng-model=\"$ctrl.editedDay.label\" autofocus/>\n                    </div>\n                </div>\n                <div class=\"form-group\">\n                    <label class=\"col-sm-3 control-label\">Color</label>\n    \n                    <div class=\"col-sm-9\">\n                        <span color-picker colors=\"$ctrl.DayColors\" current-color=\"$ctrl.editedDay.color\" inline=\"true\" tooltip=\"'Select background color'\" class=\"pick-color\"></span>\n                    </div>\n                </div>\n            </form>\n        </div>\n        <div class=\"modal-footer\">\n            <button class=\"button cancel\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n            <button class=\"button save primary\" ng-click=\"$ctrl.save()\">Save</button>\n        </div>\n    </div>\n    ";

var special_day_modal_component_SpecialDayModalController = /*#__PURE__*/function () {
  function SpecialDayModalController(CalendarService, DayColors) {
    classCallCheck_default()(this, SpecialDayModalController);

    this.CalendarService = CalendarService;
    this.DayColors = DayColors;
  }

  createClass_default()(SpecialDayModalController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;

      var day = this.resolve.day;

      if (day) {
        this.editedDay = {
          label: day.label,
          color: day.color
        };
        this.CalendarService.getSpecialDay(day.fullDate).then(function (response) {
          _this.editedDay.label = response.data.label;
          _this.editedDay.color = response.data.color;
        });
        this.fullDate = day.fullDate.format('MMMM Do');
      }
    }
  }, {
    key: "save",
    value: function save() {
      var _this2 = this;

      this.CalendarService.setSpecialDay(this.resolve.day.fullDate, this.editedDay).then(function () {
        return _this2.close({
          $value: _this2.editedDay
        });
      });
    }
  }]);

  return SpecialDayModalController;
}();

special_day_modal_component_SpecialDayModalController.$inject = ['CalendarService', 'DayColors'];
var SpecialDayModal = {
  bindings: {
    resolve: '<',
    close: '&',
    dismiss: '&'
  },
  controller: special_day_modal_component_SpecialDayModalController,
  template: special_day_modal_component_template
};
angular.module('xlrelease').component('specialDayModal', SpecialDayModal);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/calendar/index.js












// EXTERNAL MODULE: ./core/xlr-ui/app/js/configuration/configuration-instances-service.js
var configuration_instances_service = __webpack_require__(853);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/configuration/server-configuration-service.js


var ClusterMode = {
  STANDALONE: 'default'
};
var injectParams = ['$q', 'Backend', 'Authenticator', 'ClusterMode'];

var server_configuration_service_ServerConfigurationService = /*#__PURE__*/function () {
  function ServerConfigurationService($q, Backend, Authenticator) {
    classCallCheck_default()(this, ServerConfigurationService);

    this._$q = $q;
    this._Backend = Backend;
    this._Authenticator = Authenticator;
    this._ClusterMode = ClusterMode;
    this._cachedClusterInfo = undefined;
    this._cachedPromise = undefined;
    this._promiseWasRejected = false;
  }

  createClass_default()(ServerConfigurationService, [{
    key: "_getClusterInfo",
    value: function _getClusterInfo() {
      var _this = this;

      if (!this._Authenticator.isAuthenticated()) {
        this._cachedPromise = undefined;
        this._cachedClusterInfo = undefined;

        var noInfoPromise = this._$q.defer();

        noInfoPromise.resolve({});
        return noInfoPromise.promise;
      }

      if (!this._cachedPromise || this._promiseWasRejected) {
        this._cachedPromise = this._Backend.get('server/cluster').then(function (response) {
          _this._promiseWasRejected = false;
          _this._cachedClusterInfo = response.data;
          return response.data;
        }, function () {
          _this._promiseWasRejected = true;
          _this._cachedClusterInfo = {};
          return {};
        });
      }

      return this._cachedPromise;
    }
  }, {
    key: "isClusterModeStandalone",
    value: function isClusterModeStandalone() {
      var _this2 = this;

      return this._getClusterInfo().then(function (info) {
        return info.clusterMode === _this2._ClusterMode.STANDALONE;
      });
    }
  }]);

  return ServerConfigurationService;
}();

server_configuration_service_ServerConfigurationService.$inject = injectParams;
angular.module('xlrelease').constant('ClusterMode', ClusterMode).service('ServerConfigurationService', server_configuration_service_ServerConfigurationService);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/custom/ui-extensions-service.js





function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var ui_extensions_service_UiExtensionsService = /*#__PURE__*/function () {
  function UiExtensionsService($q, Backend, Authenticator, UiExtensionProperties, ServerConfigurationService) {
    classCallCheck_default()(this, UiExtensionsService);

    this._$q = $q;
    this._Backend = Backend;
    this._Authenticator = Authenticator;
    this._UiExtensionProperties = UiExtensionProperties;
    this._ServerConfigurationService = ServerConfigurationService;
    this._cachedPromise = undefined;
    this._promiseWasRejected = false;
  }

  createClass_default()(UiExtensionsService, [{
    key: "getMainMenuItems",
    value: function getMainMenuItems() {
      return this._$q.all([this.getMenuItems('xlrelease.menu.Main'), this._ServerConfigurationService.isClusterModeStandalone()]).then(function (data) {
        var _data = slicedToArray_default()(data, 2),
            items = _data[0],
            isStandalone = _data[1];

        items.forEach(function (item) {
          if (item.id === "xlrelease.menu.Plugins") {
            angular.extend(item, {
              disabled: !isStandalone
            });
          }
        });
        return items;
      });
    }
  }, {
    key: "getReleaseMenuExtensions",
    value: function getReleaseMenuExtensions(release) {
      return this.getMenuItems('xlrelease.ReleasePageMenu', release);
    }
  }, {
    key: "getMenuItems",
    value: function getMenuItems(menuId, container) {
      var _this = this;

      return this._getAllMenuExtensions().then(function (extensions) {
        return _this._fillDefaultsAndPermissions(_this._findMenu(extensions, menuId).items, container);
      });
    }
  }, {
    key: "findMenuItemForPath",
    value: function findMenuItemForPath(path) {
      var _this2 = this;

      if (path) {
        path = path[0] === '/' ? path.substr(1) : path;
      }

      return this.getMainMenuItems().then(function (items) {
        var allItems = _this2._flattenMenu(items);

        return _(allItems).filter(function (item) {
          return _.startsWith(path, item.pathSuffix);
        }).sortBy(function (item) {
          return -item.pathSuffix.length;
        }).value()[0];
      });
    }
  }, {
    key: "_getAllMenuExtensions",
    value: function _getAllMenuExtensions() {
      var _this3 = this;

      if (!this._Authenticator.isAuthenticated()) {
        this._cachedPromise = undefined;

        var noItemsPromise = this._$q.defer();

        noItemsPromise.resolve([]);
        return noItemsPromise.promise;
      }

      if (!this._cachedPromise || this._promiseWasRejected) {
        this._cachedPromise = this._Backend.get('api/extension/metadata', {
          headers: {
            'Accept': 'application/json'
          }
        }).then(function (response) {
          _this3._promiseWasRejected = false;
          return response.data;
        }, function () {
          _this3._promiseWasRejected = true;
          return [];
        });
      }

      return this._cachedPromise;
    }
  }, {
    key: "_findMenu",
    value: function _findMenu(items, id) {
      return _.find(items, {
        id: id
      }) || {};
    }
  }, {
    key: "_fillDefaultsAndPermissions",
    value: function _fillDefaultsAndPermissions(items, container) {
      var _this4 = this;

      items = items || [];

      this._forAllItems(items, function (item) {
        item.permitted = _this4._isPermitted(item, container);

        if (_.isUndefined(item.pathSuffix) && item.label) {
          item.pathSuffix = item.label.replace(/[^A-Za-z0-9-_]/g, '').toLowerCase();
        }
      });

      return items;
    }
  }, {
    key: "_isPermitted",
    value: function _isPermitted(item, container) {
      var _this5 = this;

      var PROPERTY_PERMISSIONS = this._UiExtensionProperties.PERMISSIONS;
      var isPermitted = true;

      if (item.properties && item.properties[PROPERTY_PERMISSIONS]) {
        var permissions = _.chain(item.properties[PROPERTY_PERMISSIONS]).split(",").map(function (e) {
          return _.trim(e);
        }).filter(function (e) {
          return !_.isEmpty(e);
        }).value();

        isPermitted = _.isEmpty(permissions) || _.some(permissions, function (perm) {
          return container && _this5._Authenticator.hasPermission(perm, container) || _this5._Authenticator.hasPermission(perm);
        });
      }

      return isPermitted;
    }
  }, {
    key: "_flattenMenu",
    value: function _flattenMenu(items) {
      var allItems = [];

      this._forAllItems(items, function (item) {
        return allItems.push(item);
      });

      return allItems;
    }
  }, {
    key: "_forAllItems",
    value: function _forAllItems(items, fnCallback) {
      var _iterator = _createForOfIteratorHelper(items),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var item = _step.value;
          fnCallback(item);

          if (item.items) {
            this._forAllItems(item.items, fnCallback);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }
  }]);

  return UiExtensionsService;
}();

defineProperty_default()(ui_extensions_service_UiExtensionsService, "$inject", ['$q', 'Backend', 'Authenticator', 'UiExtensionProperties', 'ServerConfigurationService']);

var ui_extensions_service_UiExtensionProperties = {
  PERMISSIONS: 'permissions'
};
angular.module('xlrelease').constant('UiExtensionProperties', ui_extensions_service_UiExtensionProperties).service('UiExtensionsService', ui_extensions_service_UiExtensionsService);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/view-container-directive.js





var view_container_directive_ViewContainerController = /*#__PURE__*/function () {
  function ViewContainerController($element) {
    classCallCheck_default()(this, ViewContainerController);

    defineProperty_default()(this, "CLASSES", {
      '#release #navigator.navigator-shifted': 144,
      '.dashboard-sidebar': 92,
      '.view-content': 0,
      '#release #navigator': 93,
      '#release #navigator-toggler': 93,
      '#calendar #navigator-toggler': 93,
      '#calendar #navigator': 93,
      '#delivery-flow .fixed-container': 93,
      '#delivery-flow .fixed-container .content-container #scrollable-content #content #top-left': 153
    });

    this.$element = $element;
    this.viewContainerStyle = undefined;
  }

  createClass_default()(ViewContainerController, [{
    key: "$onInit",
    value: function $onInit() {
      this.body = angular_default.a.element('body');
      this.css = _.map(this.CLASSES, function (fromTop, className) {
        return "".concat(className, "{top: ").concat(fromTop, "px !important;}");
      }).join('');
      this.setViewContainerStyle();
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      if (angular_default.a.isDefined(this.viewContainerStyle)) {
        this.viewContainerStyle.remove();
        this.viewContainerStyle = undefined;
      }
    }
  }, {
    key: "setHeight",
    value: function setHeight(height) {
      this.css = _.map(this.CLASSES, function (fromTop, className) {
        return "".concat(className, "{top: ").concat(fromTop + height, "px !important;}");
      }).join('');
      this.setViewContainerStyle();
    }
  }, {
    key: "setViewContainerStyle",
    value: function setViewContainerStyle() {
      if (angular_default.a.isUndefined(this.viewContainerStyle)) {
        this.viewContainerStyle = angular_default.a.element("<style>".concat(this.css, "</style>")).appendTo(this.body);
      } else if (this.viewContainerStyle.html() !== this.css) {
        this.viewContainerStyle.html(this.css);
      }
    }
  }]);

  return ViewContainerController;
}();

defineProperty_default()(view_container_directive_ViewContainerController, "$inject", ['$element']);

angular_default.a.module('xlrelease').directive('viewContainer', [function () {
  return {
    restrict: 'A',
    controller: view_container_directive_ViewContainerController
  };
}]).directive('headerContainer', ['$window', function ($window) {
  return {
    restrict: 'A',
    require: '^^viewContainer',
    link: function link(scope, element, attrs, ctrl) {
      var windowEl = angular_default.a.element($window);
      windowEl.bind('resize', function () {
        ctrl.setHeight(element.height());
      });
      scope.$watch(function () {
        return element.height();
      }, function (newHeight) {
        ctrl.setHeight(newHeight);
      });
    }
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/colors.js
var colors = __webpack_require__(23);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/color-picker-directive.js
/*
 * Adapted from :
 *
 *   https://github.com/tkrotoff/jquery-simplecolorpicker
 *   Copyright (C) 2012-2013 Tanguy Krotoff <tkrotoff@gmail.com>
 *
 *   Licensed under the MIT license.
 */

angular.module('xlrelease').value('PhaseColors', [{
  name: "Blue",
  value: colors["a" /* default */].blue
}, {
  name: "Green",
  value: colors["a" /* default */].green
}, {
  name: "Orange",
  value: colors["a" /* default */].orange
}, {
  name: "Red",
  value: colors["a" /* default */].red
}, {
  name: "Grey",
  value: colors["a" /* default */].gray
}, {
  name: "Purple",
  value: colors["a" /* default */].purple
}]);
angular.module('xlrelease').value('DayColors', [// TODO UX: discuss this with UX
{
  name: "None",
  value: ''
}, {
  name: "Blue",
  value: colors["a" /* default */].hoverColor
}, {
  name: "Green",
  value: colors["a" /* default */].successBackground
}, {
  name: "Orange",
  value: colors["a" /* default */].warningBackground
}, {
  name: "Red",
  value: colors["a" /* default */].errorBackground
}]);
angular.module('xlrelease').directive('colorPickerSwatch', function () {
  return {
    templateUrl: 'partials/colorpicker/swatch.html',
    replace: true,
    scope: {
      'color': '=cpColor',
      'currentColor': '=cpCurrentColor'
    },
    link: function link(scope, element) {
      scope.clicked = function () {
        if (element.hasClass('button')) {
          scope.$parent.selectColor(scope.color.value);
        }
      };
    }
  };
});
angular.module('xlrelease').directive('colorPicker', function () {
  var bootstrapArrowWidth = 18,
      bootstrapArrowHeight = 6;
  return {
    templateUrl: 'partials/colorpicker/main.html',
    replace: true,
    scope: {
      'colors': '=',
      'currentColor': '=',
      'onChange': '&',
      'inline': '='
    },
    link: function link(scope, element, attrs) {
      if (!scope.currentColor) {
        scope.currentColor = scope.colors[0].value;
      }

      var picker = element.find('.simplecolorpicker');

      if (attrs.inline) {
        picker.addClass('inline');
      } else {
        picker.addClass('popup');
      }

      var toggler = element.find('.toggle-picker');
      var popup = element.find('.popup');

      var showPicker = function showPicker() {
        var pos = toggler.position();
        popup.css({
          left: pos.left + toggler.width() / 2 - bootstrapArrowWidth + 2,
          top: pos.top + toggler.outerHeight() + bootstrapArrowHeight
        });
        popup.show();
      };

      var hidePicker = function hidePicker() {
        popup.hide();
      };

      var togglePicker = function togglePicker() {
        if (popup.is(':visible')) {
          hidePicker();
        } else {
          showPicker();
        }
      };

      var mouseDown = function mouseDown(e) {
        e.stopPropagation();
        e.preventDefault();
      };

      toggler.on('mousedown', togglePicker);
      element.on('mousedown', '.popup, .toggle-picker', mouseDown);
      element.parents('.phase-header').on('mouseleave', hidePicker);

      scope.selectColor = function (color) {
        scope.currentColor = color;
        hidePicker();
        scope.onChange({
          color: color
        });
      };
    }
  };
});
// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/attachments-list.js
var attachments_list = __webpack_require__(854);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/date-editor-directive.js


angular.module('xlrelease').directive('dateEditor', [function () {
  function setValidity(isRequired, value, ngModelCtrl) {
    if (!_.isUndefined(isRequired) && isRequired === true) {
      if (_.isNull(value) || _.isUndefined(value)) {
        ngModelCtrl.$setValidity('ngModel', false);
      } else {
        ngModelCtrl.$setValidity('ngModel', true);
      }
    }
  }

  return {
    templateUrl: "partials/directives/date-editor.html",
    restrict: 'A',
    scope: {
      placeholder: '@',
      onChange: '&',
      ngModel: '=',
      inferredDate: '&',
      deletable: '&',
      readonly: '&',
      dateFormat: '@',
      isRequired: '<'
    },
    require: 'ngModel',
    link: function link(scope, element, attrs, controller) {
      scope.$watch('ngModel', function (newDate, oldDate) {
        setValidity(scope.isRequired, scope.ngModel, controller);

        if (angular.isUndefined(oldDate) && (angular.isUndefined(newDate) || newDate === null)) {
          return;
        }

        if (newDate !== oldDate) {
          scope.onChange();
        }
      });

      scope.deleteDate = function () {
        scope.ngModel = null;
      };

      scope.displayedDate = function () {
        return scope.ngModel || scope.inferredDate();
      };

      scope.hasNoDate = function () {
        return !scope.ngModel;
      };
    }
  };
}]);
angular.module('xlrelease').directive('ganttDateEditor', ['GanttElementsEditor', function (GanttElementsEditor) {
  return {
    scope: true,
    template: "<div date-editor ng-model='date' inferred-date='inferredDate' on-change='setDate(date)' editable='true' deletable='deletable'></div>",
    link: function link(scope, element) {
      var parent = element.parent();
      if (!parent.length) return;
      var timestamp = parent.data('date');
      var id = parent.data('id');
      var type = parent.data('type');
      var date = new Date(parseInt(timestamp, 10));

      if (parent.data('has-own-date')) {
        scope.date = date;
      } else {
        scope.inferredDate = date;
        scope.date = null;
      }

      scope.deletable = parent.data('deletable');
      scope.$watch('date', function (newValue, oldValue) {
        if (newValue !== oldValue) {
          var ganttElement = gantt.getTask(id);

          if (type === 'start') {
            GanttElementsEditor.setStartDate(ganttElement, newValue);
          } else {
            GanttElementsEditor.setEndDate(ganttElement, newValue);
          }
        }
      });
    }
  };
}]);
angular.module('xlrelease').directive('modalDateEditor', function () {
  return {
    templateUrl: "partials/directives/modal-date-editor.html",
    restrict: 'A',
    scope: {
      dateModel: '=',
      readonly: '&',
      dateTitle: '@',
      inferredDate: '&',
      onChange: '&'
    },
    link: function link(scope) {
      scope.removeDate = function () {
        scope.dateModel = null;
      };

      var dateModelWatcher = scope.$watch('dateModel', function (newDate, oldDate) {
        if (angular.isDefined(oldDate) && newDate !== oldDate) {
          scope.onChange();
        }
      });

      scope.displayedDate = function () {
        return scope.dateModel || scope.inferredDate();
      };

      scope.$on('destroy', dateModelWatcher);
    }
  };
});

var date_editor_directive_GridDateEditor = /*#__PURE__*/function () {
  function GridDateEditor() {
    classCallCheck_default()(this, GridDateEditor);

    this.restrict = 'A';
    this.templateUrl = 'partials/directives/grid-date-editor.html';
    this.scope = {
      placeholder: '=',
      date: '=',
      readonly: '&'
    };
  }

  createClass_default()(GridDateEditor, [{
    key: "link",
    value: function link(scope) {
      scope.displayedDate = function () {
        return scope.date;
      };
    }
  }], [{
    key: "factory",
    value: function factory() {
      GridDateEditor.instance = new GridDateEditor();
      return GridDateEditor.instance;
    }
  }]);

  return GridDateEditor;
}();

angular.module('xlrelease').directive('gridDateEditor', date_editor_directive_GridDateEditor.factory);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/date-time-picker-directive.js

angular.module('xlrelease').directive('dateTimePicker', ['$parse', '$locale', 'DateFormatDetector', 'DateService', 'RegionalSettings', function ($parse, $locale, DateFormatDetector, DateService, RegionalSettings) {
  function overrideDatePart(oldDate, componentDate, dateTimeFormatter, dateFormat) {
    var newDate = moment(componentDate.toISOString());

    var _oldDate = moment(oldDate, dateFormat);

    newDate.hour(_oldDate.hour());
    newDate.minute(_oldDate.minute());
    newDate.second(_oldDate.second());
    return dateTimeFormatter(newDate);
  }

  function overrideTimePart(oldDate, time, dateTimeFormatter, dateFormat) {
    var date = moment(oldDate, dateFormat);
    var newHoursMinutes = moment(time.value, "hh:mm a");
    date.hours(newHoursMinutes.hours());
    date.minutes(newHoursMinutes.minutes());
    date.seconds(0);
    date.milliseconds(0);
    return dateTimeFormatter(date);
  }

  function saveDateAndClosePicker(scope, dateGetter, dateSetter, date, dateTimeFormatter, dateFormat) {
    scope.$apply(function () {
      dateSetter.assign(scope, overrideDatePart(getTodayIfDateIsEmpty(scope, dateGetter), date, dateTimeFormatter, dateFormat));
    });
  }

  function _formatShortDate() {
    var shortFormat = $locale.DATETIME_FORMATS.shortDate.toLowerCase();

    if (shortFormat.match(/y/gi).length < 2) {
      shortFormat = shortFormat.replace('y', 'yy');
    }

    return shortFormat;
  }

  function setupDatePicker(element, scope, dateGetter, dateSetter, dateTimeFormatter, dateFormat) {
    var datePickerHolder = element.find('.date-picker-holder');
    datePickerHolder.datepicker({
      format: _formatShortDate(),
      language: $locale.id,
      autoclose: true,
      weekStart: RegionalSettings.currentFirstDayOfWeek
    });

    var onHide = function onHide() {
      var newDate = datePickerHolder.datepicker('getDate');

      if (moment(newDate).isValid()) {
        saveDateAndClosePicker(scope, dateGetter, dateSetter, newDate, dateTimeFormatter, dateFormat);
      } else {
        var selectedDates = datePickerHolder.datepicker('getDates');

        if (selectedDates.length === 0) {
          // if date was deselected by clicking on the already selected date, set it back again
          // (see bootstrap-datepicker:_toggle_multidate for more details)
          newDate = moment(getTodayIfDateIsEmpty(scope, dateGetter)).toDate();
        } else {
          // if date is invalid reset to the current date
          newDate = DateService.getToday().toDate();
        }

        setDateTime(element, scope, dateGetter, dateFormat);
        saveDateAndClosePicker(scope, dateGetter, dateSetter, newDate, dateTimeFormatter, dateFormat);
      }
    };

    datePickerHolder.datepicker().on('hide', onHide);
    var dateHolder = element.find('.date');

    var onClickDatePickerHolder = function onClickDatePickerHolder() {
      return datePickerHolder.datepicker('show');
    };

    dateHolder.on('click', onClickDatePickerHolder);
    return function () {
      dateHolder.datepicker().off('hide', onHide);
      dateHolder.off('click', onClickDatePickerHolder);
    };
  }

  function setupTimePicker(element, scope, dateGetter, dateSetter, dateTimeFormatter, dateFormat) {
    var timePickerHolder = element.find('.time-picker-holder');
    var ESC_KEY = 27;
    timePickerHolder.timepicker({
      showMeridian: DateFormatDetector.isAmPmVisible()
    });

    var timeClickHandler = function timeClickHandler() {
      timePickerHolder.timepicker('showWidget').one('hide.timepicker', function (event) {
        scope.$apply(function () {
          dateSetter.assign(scope, overrideTimePart(getTodayIfDateIsEmpty(scope, dateGetter), event.time, dateTimeFormatter, dateFormat));
        });
      });
    };

    var timeEl = element.find('.time');
    timeEl.on('click', timeClickHandler);

    var hideTimePicker = function hideTimePicker(e) {
      if (e.keyCode === ESC_KEY) {
        timePickerHolder.timepicker('hideWidget');
      }
    };

    var document = angular.element(document);
    timePickerHolder.one('show.timepicker', function () {
      document.on('keydown', hideTimePicker);
    });
    return function () {
      document.off('keydown', hideTimePicker);
      timeEl.off('click', timeClickHandler);
    };
  }

  function getTodayIfDateIsEmpty(scope, dateGetter) {
    if (dateGetter(scope) === null || angular.isUndefined(dateGetter(scope))) {
      var today = new Date();
      today.setSeconds(0);
      today.setMilliseconds(0);
      return today;
    }

    return dateGetter(scope);
  }

  function setDateTime(element, scope, dateGetter, dateFormat) {
    var date = getTodayIfDateIsEmpty(scope, dateGetter);
    var timePickerFormat = DateFormatDetector.isAmPmVisible() ? 'hh:mm A' : 'HH:mm';
    var formattedTime = moment(date, dateFormat).format(timePickerFormat);
    var datePickerHolder = element.find('.date-picker-holder');
    datePickerHolder.datepicker('setDate', DateService.atMidnight(date, dateFormat).toDate());
    var timePickerHolder = element.find('.time-picker-holder');
    timePickerHolder.timepicker('setTime', formattedTime);
  }

  return {
    restrict: 'A',
    link: function link(scope, element, attrs) {
      var parentForm = element.inheritedData('$formController');
      var dateGetter = $parse('displayedDate()');
      var dateSetter = $parse(attrs.date);
      var dateFormat = angular.isDefined(attrs.dateFormat) && !!attrs.dateFormat ? attrs.dateFormat : global_constants["a" /* dateTimeFormat */].unixMillisecondTimestamp;
      var dateSetterWrapper = {
        assign: function assign(scope, value) {
          if (parentForm) {
            parentForm.$setDirty();
          }

          dateSetter.assign(scope, value);
        }
      };

      var dateTimeFormatter = function dateTimeFormatter(dateFormat) {
        return function (dateTime) {
          return angular.isDefined(dateFormat) && !!dateFormat ? moment(dateTime).format(dateFormat) : moment(dateTime).valueOf();
        };
      };

      var clearDatePickerHandlers;
      var clearTimePickerHandlers;
      var readOnlyWatcher = scope.$watch('readonly()', function (isReadOnly) {
        if (!isReadOnly) {
          if (angular.isUndefined(clearDatePickerHandlers)) {
            clearDatePickerHandlers = setupDatePicker(element, scope, dateGetter, dateSetterWrapper, dateTimeFormatter(attrs.dateFormat), dateFormat);
          }

          if (angular.isUndefined(clearTimePickerHandlers)) {
            clearTimePickerHandlers = setupTimePicker(element, scope, dateGetter, dateSetterWrapper, dateTimeFormatter(attrs.dateFormat), dateFormat);
          }
        } else {
          if (angular.isDefined(clearDatePickerHandlers)) {
            clearDatePickerHandlers();
          }

          if (angular.isDefined(clearTimePickerHandlers)) {
            clearTimePickerHandlers();
          }
        }
      });
      var dateWatcher = scope.$watch('displayedDate()', function (newDate) {
        if (angular.isDefined(newDate) && !scope.readonly()) {
          setDateTime(element, scope, dateGetter, dateFormat);
        }
      });
      scope.$on('$destroy', function () {
        element.find('.date').off();
        element.find('.date-picker-holder').datepicker('destroy');
        dateWatcher();
        readOnlyWatcher();

        if (angular.isDefined(clearDatePickerHandlers)) {
          clearDatePickerHandlers();
        }

        if (angular.isDefined(clearTimePickerHandlers)) {
          clearTimePickerHandlers();
        }
      });
    }
  };
}]);
angular.module('xlrelease').factory('DateFormatDetector', ['dateFilter', '$locale', function (dateFilter, $locale) {
  return {
    isAmPmVisible: function isAmPmVisible() {
      var formattedTime = dateFilter(new Date(2013, 0, 1, 14), 'shortTime');
      return !_.includes(formattedTime, '14');
    },
    isMonthDisplayedBeforeDay: function isMonthDisplayedBeforeDay() {
      var shortDate = $locale.DATETIME_FORMATS.shortDate.toLowerCase();
      return shortDate.indexOf('m') < shortDate.indexOf('d');
    }
  };
}]);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/dip-control-directive.js



angular.module('xlrelease').directive('dipControl', [function () {
  return {
    templateUrl: 'partials/directives/dip-control.html',
    controllerAs: 'vm',
    controller: dip_control_directive_DipControlController,
    bindToController: true,
    scope: {
      property: '=',
      container: '=',
      large: '=?',
      readonly: '<',
      useShortId: '<',
      folder: '<?',
      rendererProps: '<?',
      validationMessage: '<'
    },
    require: {
      form: '^'
    }
  };
}]);

var dip_control_directive_DipControlController = /*#__PURE__*/function () {
  function DipControlController($scope, $q, $stateParams, ConfigurationInstances, Ids) {
    var _this = this;

    classCallCheck_default()(this, DipControlController);

    defineProperty_default()(this, "onTypeChange", function (value) {
      if (_this.container[_this.property.name] !== value.selectedId) {
        _this.container[_this.property.name] = value.selectedId;
      }
    });

    this.scope = $scope;
    this.ConfigurationInstances = ConfigurationInstances;
    this.$stateParams = $stateParams;
    this.$q = $q;
    this.Ids = Ids;
    this.configurationInstancesLoaded = false;
    this.value = undefined;
    this.items = [];
    this.supportedRenderers = ['TypeBounds'];
    this.renderer = 'BasicInput';
    this.annotation = undefined;
  }

  createClass_default()(DipControlController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      var foundRenderer = this.supportedRenderers.find(function (annotation) {
        return _this2.hasAnnotation(annotation);
      });

      if (angular.isDefined(foundRenderer)) {
        this.renderer = foundRenderer;
        this.annotation = this.property.annotations[foundRenderer];
      }

      var realValue = this.container[this.property.name];
      var defaultValue = this.property.default;
      this.container[this.property.name] = angular.isDefined(realValue) ? realValue : defaultValue;
      var vm = this;
      this.ciHandlers = {
        onSelect: function onSelect(newVal) {
          vm.container[vm.property.name] = newVal.id;
        },
        removeElement: function removeElement() {
          delete vm.container[vm.property.name];
        },
        addCandidates: function addCandidates(metadata, options) {
          var deferred = vm.$q.defer();

          var candidates = _.filter(vm.items, function (_ref) {
            var title = _ref.title;
            return title.toLowerCase().includes(options.term.toLowerCase());
          });

          deferred.resolve(candidates);
          return deferred.promise;
        }
      };

      if (this.property.kind === 'CI') {
        if (!this.ConfigurationInstances.loaded()) {
          this.loadConfigurationInstances();
        }
      } else if (this.property.kind === 'ENUM') {
        this.enumItems = this.property.enumValues;
      }
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this.ConfigurationInstances.reset();
    }
  }, {
    key: "$onChanges",
    value: function $onChanges(changes) {
      if (changes.folder) {
        this.configurationInstancesLoaded = false;
        this.ConfigurationInstances.reset();
        this.loadConfigurationInstances();
      }
    }
  }, {
    key: "loadConfigurationInstances",
    value: function loadConfigurationInstances() {
      var _this3 = this;

      if (this.property.kind === 'CI') {
        var stateFolderId = this.$stateParams.folderId ? this.$stateParams.folderId : this.Ids.releaseIdToFolderId(this.$stateParams.releaseId);
        var folderId = angular.isUndefined(this.folder) ? stateFolderId : this.folder;
        this.ConfigurationInstances.load(folderId, this.useShortId).then(function (configurationInstances) {
          _this3.configurationInstancesLoaded = true;

          _this3.loadItems();
        });
      }
    }
  }, {
    key: "loadItems",
    value: function loadItems() {
      var _this4 = this;

      this.items = this.ConfigurationInstances.getInstancesByType(this.property.referencedType);
      this.value = this.items.find(function (it) {
        return it.id === _this4.container[_this4.property.name];
      });

      if (this._hasInputHintWithValues()) {
        this.items = this.property.inputHint.values.flatMap(function (hintValue) {
          return hintValue.label === 'configurationTypeHint' ? _this4.ConfigurationInstances.getInstancesByType(hintValue.value) : [];
        });
      }
    }
  }, {
    key: "isError",
    value: function isError(field) {
      return field && (field.$touched || field.$dirty) && field.$invalid;
    }
  }, {
    key: "_hasInputHintWithValues",
    value: function _hasInputHintWithValues() {
      var property = this.property;
      return _.has(property, ['inputHint', 'values']);
    }
  }, {
    key: "hasAnnotation",
    value: function hasAnnotation(annotationName) {
      var property = this.property;
      return property.hasOwnProperty('annotations') && annotationName in property.annotations;
    }
  }]);

  return DipControlController;
}();

defineProperty_default()(dip_control_directive_DipControlController, "$inject", ['$scope', '$q', '$stateParams', 'ConfigurationInstances', 'Ids']);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/hover-menu-directive.js

angular.module('xlrelease').directive('hoverMenu', ['Page', function (Page) {
  return {
    restrict: 'A',
    scope: {
      isActiveItem: '='
    },
    link: function link(scope, element) {
      element.on('mouseenter', function () {
        element.css({
          backgroundColor: Page.theme.headerAccentColor,
          color: Page.theme.headerAccentColor === colors["a" /* default */].orange ? colors["a" /* default */].black : colors["a" /* default */].white
        });
      });
      element.on('mouseleave', function () {
        if (!scope.isActiveItem) {
          element.css({
            backgroundColor: '',
            color: colors["a" /* default */].white
          });
        }
      });
    }
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/display-member-directive.js
var display_member_directive = __webpack_require__(855);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/display-user-directive.js
var display_user_directive = __webpack_require__(856);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/duration-editor-directive.js
var duration_editor_directive = __webpack_require__(857);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/expander-directive.js
var expander_directive = __webpack_require__(858);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/focus-on.js



var focus_on_FocusOnDirective = /*#__PURE__*/function () {
  function FocusOnDirective($timeout) {
    classCallCheck_default()(this, FocusOnDirective);

    this.restrict = 'A';
    this.$timeout = $timeout;
  }

  createClass_default()(FocusOnDirective, [{
    key: "link",
    value: function link(scope, el, attrs) {
      var _this = this;

      scope.$watch(attrs.focusOn, function (val) {
        return _this.$timeout(function () {
          return !!val ? el.focus() : el.blur();
        });
      });
    }
  }]);

  return FocusOnDirective;
}();

angular.module('xlrelease').directive('focusOn', ['$timeout', function ($timeout) {
  return new focus_on_FocusOnDirective($timeout);
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/focus-on-click.js
var focus_on_click = __webpack_require__(859);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/code-editor/ace-editor.less
var ace_editor = __webpack_require__(860);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/code-editor/xlr-jython-mode.js


function xlr_jython_mode_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function xlr_jython_mode_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { xlr_jython_mode_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { xlr_jython_mode_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var MODE_NAME = 'xlr-jython';
var COMPLETION_ITEM_SCORE = 100;

function createMode(metadata) {
  var builtinSupport = _.reduce(metadata, function (acc, variable) {
    var idx = variable.name.lastIndexOf('.');
    var _ref = [variable.name.substring(0, idx), variable.name.substring(idx + 1)],
        packageName = _ref[0],
        className = _ref[1];

    var variableName = _.lowerFirst(className);

    if (/com\.xebialabs\.xlrelease\.(?:.*)(?:api\.v1)/.test(packageName)) {
      acc.variables[variableName] = variable;

      _.reduce(variable.methods, function (acc, m) {
        if (m.annotations.includes('com.xebialabs.xlplatform.documentation.PublicApiMember') && !acc.includes(m.name)) {
          acc.push(m.name);
        }

        return acc;
      }, acc.functions);
    }

    return acc;
  }, {
    variables: {},
    functions: []
  });

  builtinSupport.variables = Object.keys(builtinSupport.variables).sort().reduce(function (acc, key) {
    acc[key] = builtinSupport.variables[key];
    acc[key].methods.sort(byName);
    return acc;
  }, {});

  var builtinSupportVariables = _.keys(builtinSupport.variables);

  var builtinSupportFunctions = builtinSupport.functions;

  var TokenIterator = ace.require('ace/token_iterator').TokenIterator;

  var $modeId = "ace/mode/".concat(MODE_NAME);
  ace.define($modeId, function (require, exports) {
    var oop = require('ace/lib/oop');

    var PythonMode = require('ace/mode/python').Mode;

    var jythonHighlightRules = require("ace/mode/".concat(MODE_NAME, "_highlight_rules")).jythonHighlightRules;

    var Mode = function Mode() {
      this.HighlightRules = jythonHighlightRules;
    };

    oop.inherits(Mode, PythonMode);
    exports.Mode = Mode;
  });
  ace.define("ace/mode/".concat(MODE_NAME, "_highlight_rules"), function (require, exports) {
    var oop = require('ace/lib/oop');

    var PythonHighlightRules = require('ace/mode/python_highlight_rules').PythonHighlightRules;

    var customHighlightRules = function customHighlightRules() {
      PythonHighlightRules.call(this);
      var rules = [{
        token: 'support.variable',
        regex: builtinSupportVariables.join('|')
      }, {
        token: 'support.function',
        regex: builtinSupportFunctions.join('|\.')
      }];

      for (var key in this.$rules) {
        this.$rules[key].unshift.apply(this.$rules[key], rules);
      }
    };

    oop.inherits(customHighlightRules, PythonHighlightRules);
    exports.jythonHighlightRules = customHighlightRules;
  });

  var langTools = ace.require('ace/ext/language_tools');

  var jythonCompleter = {
    getCompletions: function getCompletions(editor, session, pos, prefix, callback) {
      if (session.$modeId !== $modeId) {
        return callback(null, []);
      }

      var stream = new TokenIterator(session, pos.row, pos.column);
      var currToken = stream.getCurrentToken();
      var prevToken = stream.stepBackward();

      if (currToken && currToken.value === '.' && prevToken && prevToken.type === 'support.variable' && builtinSupport.variables[prevToken.value]) {
        var prevValue = undefined;
        var cnt = 0;
        var methods = builtinSupport.variables[prevToken.value].methods;
        var completions = methods.filter(function (it) {
          return it.annotations.includes('com.xebialabs.xlplatform.documentation.PublicApiMember');
        }).map(function (it, index) {
          return {
            value: it.name,
            meta: 'XLRelease API',
            score: COMPLETION_ITEM_SCORE + methods.length - index,
            metadata: it
          };
        })
        /*
            to make autocomplete keep items with the same name
            in sorted array
         */
        .map(function (it) {
          if (angular.isUndefined(prevValue) || it.value !== prevValue) {
            prevValue = it.value;
            cnt = 0;
            return xlr_jython_mode_objectSpread({}, it, {
              caption: it.value
            });
          }

          return xlr_jython_mode_objectSpread({}, it, {
            caption: it.value + ' '.repeat(++cnt)
          });
        });
        return callback(null, completions);
      }

      var maybeVariables = builtinSupportVariables.filter(function (it) {
        return it.startsWith(prefix);
      });

      if (maybeVariables) {
        return callback(null, maybeVariables.map(function (it, index) {
          return {
            value: it,
            meta: 'XLRelease API',
            score: COMPLETION_ITEM_SCORE + maybeVariables.length - index,
            metadata: builtinSupport[it]
          };
        }));
      }
    },
    getDocTooltip: function getDocTooltip(item) {
      var docHTML = [];

      if (item.metadata) {
        docHTML.push('<div>', '<span class="ace_doc-name">', "<span class=\"ace_icon ".concat(item.metadata.constructors ? 'ace_icon-object' : 'ace_icon-method', "\"></span>"), item.metadata.name, '</span>', '</div>', "<div class=\"ace_doc-description\">".concat(item.metadata.description, "</div>"));

        if (item.metadata.parameters) {
          docHTML.push('<ul>', item.metadata.parameters.map(function (p) {
            return '<li>' + "<div class=\"ace_doc-p-type\">".concat(p.type, " <span class=\"ace_doc-p-name\">").concat(p.name, "</span></div>") + "<div class=\"ace_doc-p-comment\">".concat(!!p.comment && p.comment, "</div>") + '</li>';
          }).join(''), '</ul>');
        }
      }

      item.docHTML = docHTML.join('');
    }
  };
  langTools.addCompleter(jythonCompleter);
}

/* harmony default export */ var xlr_jython_mode = ({
  name: MODE_NAME,
  initialized: false,
  init: function init() {
    return $.getJSON("static/9.7.16/metadata/".concat(MODE_NAME, ".json"), function (metadata) {
      return createMode(metadata);
    });
  }
});

function byName(a, b) {
  if (a.name < b.name) return -1;
  if (a.name > b.name) return 1;
  return 0;
}
// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/code-editor/xlr-groovy-mode.js


function xlr_groovy_mode_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function xlr_groovy_mode_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { xlr_groovy_mode_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { xlr_groovy_mode_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var xlr_groovy_mode_MODE_NAME = 'xlr-groovy';
var xlr_groovy_mode_COMPLETION_ITEM_SCORE = 100;

function xlr_groovy_mode_createMode(metadata) {
  var contexts = _.find(metadata, function (m) {
    return !m.plugin;
  }).contexts;

  var builtinDsl = _.chain(contexts).keys().reduce(function (acc, cn) {
    contexts[cn].methods.forEach(function (m) {
      return !acc.includes(m.name) && acc.push(m.name);
    });
    return acc;
  }, ['xlr']).sort().value();

  var $modeId = "ace/mode/".concat(xlr_groovy_mode_MODE_NAME);
  ace.define($modeId, function (require, exports) {
    var oop = require('ace/lib/oop');

    var GroovyMode = require('ace/mode/groovy').Mode;

    var groovyHighlightRules = require("ace/mode/".concat(xlr_groovy_mode_MODE_NAME, "_highlight_rules")).groovyHighlightRules;

    var Mode = function Mode() {
      GroovyMode.call(this);
      this.HighlightRules = groovyHighlightRules;
    };

    oop.inherits(Mode, GroovyMode);
    exports.Mode = Mode;
  });
  ace.define("ace/mode/".concat(xlr_groovy_mode_MODE_NAME, "_highlight_rules"), function (require, exports) {
    var oop = require('ace/lib/oop');

    var GroovyHighlightRules = require('ace/mode/groovy_highlight_rules').GroovyHighlightRules;

    var customHighlightRules = function customHighlightRules() {
      GroovyHighlightRules.call(this);
      var rules = [{
        token: 'support.variable',
        regex: "(".concat(builtinDsl.join('|'), "){1}\\b")
      }];

      for (var key in this.$rules) {
        this.$rules[key].unshift.apply(this.$rules[key], rules);
      }
    };

    oop.inherits(customHighlightRules, GroovyHighlightRules);
    exports.groovyHighlightRules = customHighlightRules;
  });

  var langTools = ace.require('ace/ext/language_tools');

  var groovyCompleter = {
    getCompletions: function getCompletions(editor, session, pos, prefix, callback) {
      if (session.$modeId !== $modeId) {
        return callback(null, []);
      }

      var prevValue = undefined;
      var cnt = 0;
      var vars = builtinDsl.filter(function (m) {
        return m.startsWith(prefix);
      });
      var completions = vars.map(function (m, index) {
        return {
          value: m,
          meta: 'XLRelease DSL',
          score: xlr_groovy_mode_COMPLETION_ITEM_SCORE + vars.length - index
        };
      })
      /*
          to make autocomplete keep items with the same name
          in sorted array
       */
      .map(function (it) {
        if (angular.isUndefined(prevValue) || it.value !== prevValue) {
          prevValue = it.value;
          cnt = 0;
          return xlr_groovy_mode_objectSpread({}, it, {
            caption: it.value
          });
        }

        return xlr_groovy_mode_objectSpread({}, it, {
          caption: it.value + ' '.repeat(++cnt)
        });
      });
      callback(null, completions);
    }
  };
  langTools.addCompleter(groovyCompleter);
}

/* harmony default export */ var xlr_groovy_mode = ({
  name: xlr_groovy_mode_MODE_NAME,
  initialized: false,
  init: function init() {
    return $.getJSON("static/9.7.16/metadata/".concat(xlr_groovy_mode_MODE_NAME, ".json"), function (metadata) {
      return xlr_groovy_mode_createMode(metadata);
    });
  }
});
// EXTERNAL MODULE: ./node_modules/caret-pos/lib/esm2015/main.js
var main = __webpack_require__(787);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/inline-editor-directive.js







angular.module('xlrelease').factory('inlineEditor', ['Doc', function (Doc) {
  var setEnableMode = function setEnableMode(scope) {
    scope.enableAutoComplete = angular.isDefined(scope.enableAutoComplete) ? false : scope.enableAutoComplete;
  };

  var leaveEditMode = function leaveEditMode(scope, editable, refocus) {
    scope.editMode = false;
    setEnableMode(scope);
    variableTerm = "";

    if (angular.isUndefined(refocus) || refocus === true) {
      editable.parents(".modal").focus();
    }
  };

  var leaveAutoComplete = function leaveAutoComplete(scope) {
    scope.$apply(function () {
      variableTerm = "";
      startPosition = -1;
      setEnableMode(scope);
    });
  };

  var enableAutoComplete = function enableAutoComplete(scope, editable) {
    scope.$apply(function () {
      variableTerm = "";
      scope.enableAutoComplete = true;

      if (angular.isDefined(editable.autocomplete().data('ui-autocomplete'))) {
        editable.autocomplete('enable');
      }
    });
  };

  var setVariableKey = function setVariableKey(e) {
    if (e.key !== 'Meta') {
      if (COMBINED_KEY_SET.includes(e.which)) {
        variableTerm = variableTerm + e.key;
      } else if (e.which === 8) {
        variableTerm = variableTerm.substring(0, variableTerm.length - 1);
      }
    }

    return variableTerm;
  };

  function validate(scope) {
    var status = scope.validate({
      'draft': scope.draft
    });
    if (angular.isUndefined(status)) // No validation function provided
      return true;
    scope.$apply(function () {
      scope.validationStatus = status;
    });
    return status;
  }

  function commit(scope, editable, draggablePhase, options, refocus) {
    var canCommit = scope.allowCommitOnInvalid === 'true' || isValid(editable) && validate(scope);

    if (!scope.enableAutoComplete) {
      if (draggablePhase && !draggablePhase.hasClass(scope.phaseSortHandle)) {
        draggablePhase.addClass(scope.phaseSortHandle);
      }

      scope.$apply(function () {
        scope.model = options.getModelFromDraft(canCommit ? scope.draft : scope.tempDraft, scope.model);
        leaveEditMode(scope, editable, refocus);
      }); // Callback must be called in a separate apply call in order to update the text property first.

      scope.$apply(function () {
        scope.onChange();
      });
    }
  }

  function rollback(scope, editable, refocus) {
    scope.$apply(function () {
      if (angular.isDefined(scope.enableAutoComplete)) {
        scope.draft = scope.tempDraft;
        scope.model = scope.tempDraft;
      } else {
        scope.draft = scope.model;
      }

      leaveEditMode(scope, editable, refocus);

      if (angular.isDefined(scope.validationStatus)) {
        scope.validationStatus = true;
      }
    });
  }

  function edit(scope, editable, draggablePhase, options) {
    scope.$apply(function () {
      scope.editMode = true;
      scope.draft = options.getDraftFromModel(scope.model);
      scope.tempDraft = options.getDraftFromModel(scope.model);
    });

    if (draggablePhase) {
      draggablePhase.removeClass(scope.phaseSortHandle);
    }

    if (editable.is('select')) {
      editable.focus();
    } else {
      editable.select();
    }
  }

  function commitOnBlur(scope, element, editable, draggablePhase, options) {
    var onClickHandler = function onClickHandler(event) {
      if (scope.editMode && !angular.element.contains(element[0], event.target)) {
        commit(scope, editable, draggablePhase, options);
      }
    };

    var unbindActionHandlers = function unbindActionHandlers() {
      angular.element(document).off('mousedown', onClickHandler);
    };

    unbindActionHandlers();
    angular.element(document).on('mousedown', onClickHandler);
    element.on('$destroy', unbindActionHandlers);
  }

  function switchOnTab(scope, element, editable, draggablePhase, options) {
    var onFocusHandler = function onFocusHandler(event) {
      edit(scope, editable, draggablePhase, options);
    };

    var onTabHandler = function onTabHandler(event) {
      if (event.which === 9 && scope.editMode) {
        commit(scope, editable, draggablePhase, options, false);
      }
    };

    element.find('.focusable').focus(onFocusHandler);
    editable.keydown(onTabHandler);
  }

  function setupAutocomplete(scope, element, editable, draggablePhase, options) {
    scope.$watch('autocompleteData', function (candidates) {
      if (candidates) {
        var autocomplete = editable.autocomplete({
          autoFocus: true,
          source: options.filterCandidates(candidates),
          delay: 0,
          minLength: 0,
          position: {
            my: "left top",
            at: "left bottom",
            collision: "flip",
            within: ".modal-body"
          },
          classes: {
            'ui-autocomplete': scope.autocompleteClasses
          },
          select: function select(event, ui) {
            scope.$apply(function () {
              scope.draft = options.getModelFromCandidate(ui.item);
            });
            commit(scope, editable, draggablePhase, options, false);
          }
        });

        if (angular.isDefined(options.renderAutocompleteItem)) {
          autocomplete.data('ui-autocomplete')._renderItem = options.renderAutocompleteItem;
        }

        editable.focus(function () {
          autocomplete.autocomplete('widget').position(
          /* eslint-disable lodash/preferred-alias */
          $.extend({
            of: editable
          }, autocomplete.autocomplete('option', 'position'))
          /* eslint-enable lodash/preferred-alias */
          );
        });
      }
    });
  }

  function setupRequired(scope, editable, attrs) {
    scope.$watch(attrs.required, function (value) {
      if (angular.isDefined(attrs.required)) {
        scope.isRequired = angular.isDefined(attrs.required) && attrs.required !== false;
      }
    });
  }

  var getCursorPos = function getCursorPos(input) {
    if ("selectionStart" in input && document.activeElement === input) {
      return {
        start: input.selectionStart,
        end: input.selectionEnd
      };
    } else if (input.createTextRange) {
      var sel = document.selection.createRange();

      if (sel.parentElement() === input) {
        var rng = input.createTextRange();
        rng.moveToBookmark(sel.getBookmark());
        var len;
        var pos;

        for (len = 0; rng.compareEndPoints("EndToStart", rng) > 0; rng.moveEnd("character", -1)) {
          len++;
        }

        rng.setEndPoint("StartToStart", input.createTextRange());

        for (pos = {
          start: 0,
          end: len
        }; rng.compareEndPoints("EndToStart", rng) > 0; rng.moveEnd("character", -1)) {
          pos.start++;
          pos.end++;
        }

        return pos;
      }
    }

    return -1;
  };

  function isValid(editable) {
    return editable.hasClass('ng-valid');
  } // Reference for Key codes : https://www.cambiaresearch.com/articles/15/javascript-char-codes-key-codes


  var ALLOWED_KEYS_SET1 = _.range(48, 91);

  var ALLOWED_KEYS_SET2 = _.range(96, 112);

  var ALLOWED_KEYS_SET3 = _.range(186, 192);

  var ALLOWED_KEYS_SET4 = [32, 219, 220, 221, 222];
  var COMBINED_KEY_SET = ALLOWED_KEYS_SET1.concat(ALLOWED_KEYS_SET2).concat(ALLOWED_KEYS_SET3).concat(ALLOWED_KEYS_SET4);
  var variableTerm = "";
  var startPosition = -1;
  var DEFAULT_OPTIONS = {
    multiline: false,
    // Use autocomplete filtering by default
    filterCandidates: angular.identity,
    getModelFromCandidate: function getModelFromCandidate(item) {
      return item.value;
    },
    // Use model for draft by default
    getDraftFromModel: angular.identity,
    // Use draft for model by default
    getModelFromDraft: angular.identity
  };
  return {
    directive: function directive(template, options) {
      options = _.defaults(options || {}, DEFAULT_OPTIONS);
      return {
        restrict: 'A',
        templateUrl: 'partials/inline-editor/' + template,
        scope: {
          name: '@',
          placeholder: '@',
          maxlength: '=',
          model: '=',
          onChange: '&',
          validate: '&',
          validationStatus: '=',
          selectOptions: '=',
          autocompleteData: '=',
          autocompleteClasses: '@',
          allowCommitOnInvalid: '@',
          enableAutoComplete: '=?',
          position: '=?'
        },
        transclude: true,
        link: function link(scope, element, attrs) {
          var elemScrollTop = 0;
          scope.editMode = false;
          setEnableMode(scope);
          var editable = element.find('.editable');
          var draggablePhase = element.parent();
          scope.phaseSortHandle = 'phase-sort-handle';

          if (!draggablePhase.hasClass(scope.phaseSortHandle)) {
            draggablePhase = null;
          } // On click


          element.find('.display').on('click', function (event) {
            if (options.multiline && !angular.element(event.target).hasClass('edit-icon')) {
              return;
            }

            edit(scope, editable, draggablePhase, options);
          });
          element.on('click', '.display-edit-mode', function () {
            edit(scope, editable, draggablePhase, options);
          });

          if (options.multiline) {
            element.find('.ok').on('click', function () {
              setEnableMode(scope);
              commit(scope, editable, draggablePhase, options);
            });
            element.find('.cancel').on('click', function () {
              setEnableMode(scope);
              rollback(scope, editable);
            });
          } else {
            // On enter
            editable.on('keypress', function (e) {
              if (e.which === 13 && e.ctrlKey === false) {
                setEnableMode(scope);
                commit(scope, editable, draggablePhase, options);
                e.preventDefault();
              }
            });
          }

          setupAutocomplete(scope, element, editable, draggablePhase, options);
          setupRequired(scope, editable, attrs); // On blur

          if (!options.doNotCommitOnBlur) {
            commitOnBlur(scope, element, editable, draggablePhase, options);
          }

          editable.on('change', function (event) {
            if (scope.editMode && event.target.type.includes('select-one')) {
              commit(scope, editable, draggablePhase, options);
            }
          }); // On escape

          editable.on('keyup', function (e) {
            if (e.which === 27) {
              setEnableMode(scope);
              rollback(scope, editable);
              e.stopPropagation();
            }
          });
          editable.on('keydown', function (e) {
            if (options.multiline) {
              var pointerLocation = getCursorPos(editable[0]).start;
              var left, top;
              var off = Object(main["a" /* offset */])(editable[0]);

              if (getCursorPos(editable[0]) !== -1) {
                top = off.top - off.height;
                left = off.left;
              }

              elemScrollTop = editable[0].scrollTop;

              if (angular.isDefined(scope.enableAutoComplete) && !scope.enableAutoComplete && scope.draft && scope.draft.substring(pointerLocation - 2, pointerLocation) === "${" && e.which !== 8 && COMBINED_KEY_SET.includes(e.which)) {
                enableAutoComplete(scope, editable);
                setVariableKey(e);

                if (startPosition < 0) {
                  startPosition = pointerLocation;
                }

                scope.position = {
                  'top': top - elemScrollTop,
                  left: left,
                  startPosition: startPosition,
                  'zindex': 100000,
                  'cursor': pointerLocation,
                  'value': variableTerm
                };
              } else if (angular.isDefined(scope.enableAutoComplete) && scope.enableAutoComplete && e.which !== 27) {
                setVariableKey(e);

                if (scope.draft.substring(pointerLocation - 2, pointerLocation) === "${" && variableTerm.length === 0) {
                  leaveAutoComplete(scope);
                } else {
                  scope.position = {
                    'top': top - elemScrollTop,
                    left: left,
                    startPosition: startPosition,
                    'zindex': 100000,
                    'cursor': pointerLocation,
                    'value': variableTerm
                  };
                }
              } else {
                leaveAutoComplete(scope);
              }

              if (e.which === 27) {
                rollback(scope, editable, true);
              }
            }
          }); // On tab

          switchOnTab(scope, element, editable, draggablePhase, options);
          scope.isNumber = angular.isNumber;

          scope.hasText = function (data) {
            return !_.isEmpty(data);
          };

          if (angular.isDefined(attrs.markdown)) {
            scope.helpUrl = Doc.getMarkdownSyntaxURL();
          } // Populate the draft on link so validation attributes run on the correct state


          scope.$watch('model', function (newModel) {
            if (newModel) {
              scope.draft = options.getDraftFromModel(newModel);
            }
          });

          var isVariableWithValueProvider = _.has(scope, 'model.valueProvider'); // convert enum structure


          if (!isVariableWithValueProvider && scope.selectOptions && angular.isString(scope.selectOptions[0])) {
            scope.selectOptions = scope.selectOptions.map(function (item) {
              return {
                id: item,
                title: item
              };
            });

            if (!attrs.required) {
              scope.selectOptions.unshift({
                title: "",
                id: null
              });
            }
          }
        }
      };
    }
  };
}]);
angular.module('xlrelease').directive('inlineTextEditor', function (inlineEditor) {
  return inlineEditor.directive('text-field.html');
});
angular.module('xlrelease').directive('inlinePasswordEditor', function (inlineEditor) {
  return inlineEditor.directive('password-field.html');
});
angular.module('xlrelease').directive('focusWhen', [function () {
  return {
    restrict: 'A',
    link: function link(scope, element, attrs) {
      scope.$watch(attrs.focusWhen, function (value) {
        if (value) {
          setTimeout(function () {
            angular.element(element).focus();
          });
        }
      });
    }
  };
}]);
angular.module('xlrelease').directive('inlineNumberEditor', function (inlineEditor) {
  return inlineEditor.directive('number-field.html');
});
angular.module('xlrelease').directive('inlineTextareaEditor', function (inlineEditor) {
  return inlineEditor.directive('textarea.html', {
    multiline: true
  });
});
angular.module('xlrelease').directive('inlineTextareaWithVariablesEditor', function (inlineEditor) {
  return inlineEditor.directive('textarea.html', {
    multiline: true,
    doNotCommitOnBlur: true
  });
});
angular.module('xlrelease').directive('inlineSelectEditor', function (inlineEditor) {
  return inlineEditor.directive('select.html');
});
angular.module('xlrelease').directive('inlineSimpleSelectEditor', function (inlineEditor) {
  return inlineEditor.directive('simple-select.html');
});
angular.module('xlrelease').directive('inlineListEditor', function (inlineEditor) {
  return inlineEditor.directive('list.html');
});

function inlineCodeEditor(inlineEditor, mode, VariablesInterpolator, VariablesService) {
  var codeEditor = inlineEditor.directive('code-editor.html', {
    multiline: true,
    doNotCommitOnBlur: true
  });
  return _.assignIn({}, codeEditor, {
    scope: _.assignIn({}, codeEditor.scope, {
      readOnlyMode: '=',
      variables: '=',
      ignoreScriptVariableInterpolation: '<',
      small: '<',
      resizable: '<',
      mode: '<'
    }),
    link: function link(scope, element, attrs) {
      var ESC_KEY_CODE = 27;
      var aceEditor = element.find('.ace-script-editor');
      var aceScriptEditorContainer = element.find('.ace-script-editor-container');
      var resizableModal = angular.element('#resizable-modal');
      scope.isResizable = _.isUndefined(scope.resizable) || scope.resizable === true;

      var _editor;

      var _isFullScreenMode = false;

      if (scope.isResizable) {
        scope.$watch('editMode', function (editMode) {
          if (editMode) {
            scope.aceToggleFullScreenMode();
          }
        });
      }

      Object.defineProperty(scope, 'codeEditorModel', {
        get: function get() {
          if (scope.editMode || scope.ignoreScriptVariableInterpolation) {
            return scope.draft;
          } else {
            return VariablesInterpolator.interpolateInText(VariablesService.convertToMap(scope.variables), scope.model || '');
          }
        },
        set: function set(value) {
          scope.draft = value;
        }
      });

      scope.aceLoaded = function (editor) {
        var scriptEditorCode = element.find('.ace-script-editor-code');
        _editor = editor;
        editor.$blockScrolling = Infinity;
        editor.setOptions({
          enableBasicAutocompletion: true,
          enableLiveAutocompletion: true
        });
        editor.commands.on('afterExec', function (e) {
          if (e.command.name === 'insertstring' && e.args === '.') {
            editor.execCommand('startAutocomplete');
          }
        });

        if (scope.isResizable) {
          editor.commands.addCommand({
            name: 'exitFullScreenMode',
            bindKey: {
              win: 'ESC',
              mac: 'ESC'
            },
            exec: function exec() {
              aceEditor.removeClass('full-screen');
              aceScriptEditorContainer.append(aceEditor);
              aceEditor.off('keyup', handleExitFullScreenMode);
              editor.resize();
              editor.focus();
              _isFullScreenMode = false;
            },
            readOnly: true
          });
          editor.commands.addCommand({
            name: 'enterFullScreenMode',
            bindKey: {
              win: 'Ctrl-Alt-f',
              mac: 'Command-Alt-f'
            },
            exec: function exec() {
              aceEditor.addClass('full-screen');
              resizableModal.append(aceEditor);
              aceEditor.on('keyup', handleExitFullScreenMode);
              editor.resize();
              editor.focus();
              _isFullScreenMode = true;
            },
            readOnly: true
          });
          editor.keyBinding.addKeyboardHandler(function (editor, hashId, keyString, keyCode, event) {
            if (keyCode === ESC_KEY_CODE) {
              event.preventDefault();
              event.stopPropagation();
              return {
                command: 'null'
              }; // prevent modal close when press esc key
            }
          });
        } else {
          editor.focus();
        }

        if (scope.small) {
          scriptEditorCode.addClass('small');
        }
      };

      if (mode) {
        scope.codeEditorModeInitialized = mode.initialized;

        if (!scope.codeEditorModeInitialized) {
          mode.init().always(function () {
            return scope.$apply(function () {
              scope.codeEditorModeInitialized = mode.initialized = true;
            });
          });
        }

        scope.codeEditorMode = mode.name;
      } else {
        scope.codeEditorModeInitialized = true;
        scope.codeEditorMode = scope.mode;
      }

      scope.aceToggleFullscreenBtn = function ($event) {
        if ($event) {
          $event.preventDefault();
          $event.stopPropagation();
        }

        var currentEditModeState = scope.editMode;

        if (!_isFullScreenMode && !scope.readOnlyMode) {
          scope.editMode = true;

          if (currentEditModeState === scope.editMode) {
            scope.aceToggleFullScreenMode();
          }
        } else {
          scope.aceToggleFullScreenMode();
        }
      };

      scope.aceToggleFullScreenMode = function ($event) {
        if ($event) {
          $event.preventDefault();
          $event.stopPropagation();
        }

        if (_editor) {
          _editor.gotoLine(0, 0);

          _editor.session.setScrollTop(-1);

          _editor.session.setScrollLeft(-1);

          _isFullScreenMode ? _editor.execCommand('exitFullScreenMode') : _editor.execCommand('enterFullScreenMode');
        }
      };

      var handleExitFullScreenMode = function handleExitFullScreenMode(event) {
        event.preventDefault();
        event.stopPropagation();

        if (event.keyCode === ESC_KEY_CODE) {
          _editor.execCommand('exitFullScreenMode');
        }
      };

      codeEditor.link(scope, element, attrs);
    }
  });
}

angular.module('xlrelease').directive('inlineJythonEditor', ['inlineEditor', 'VariablesInterpolator', 'VariablesService', function (inlineEditor, VariablesInterpolator, VariablesService) {
  return inlineCodeEditor(inlineEditor, xlr_jython_mode, VariablesInterpolator, VariablesService);
}]);
angular.module('xlrelease').directive('inlineGroovyEditor', ['inlineEditor', 'VariablesInterpolator', 'VariablesService', function (inlineEditor, VariablesInterpolator, VariablesService) {
  return inlineCodeEditor(inlineEditor, xlr_groovy_mode, VariablesInterpolator, VariablesService);
}]);
angular.module('xlrelease').directive('inlineCodeEditor', ['inlineEditor', 'VariablesInterpolator', 'VariablesService', function (inlineEditor, VariablesInterpolator, VariablesService) {
  return inlineCodeEditor(inlineEditor, null, VariablesInterpolator, VariablesService);
}]);
angular.module('xlrelease').directive('inlineUserEditor', ['inlineEditor', 'UserCompletion', function (inlineEditor, UserCompletion) {
  return inlineEditor.directive('user.html', {
    renderAutocompleteItem: UserCompletion.renderItem,
    filterCandidates: UserCompletion.completionMatcher,
    getModelFromCandidate: UserCompletion.getUserFromItem,
    getDraftFromModel: function getDraftFromModel(model) {
      var username = model ? model.username : '';
      return {
        username: username,
        fullName: ''
      };
    },
    getModelFromDraft: function getModelFromDraft(draft, previousModel) {
      if (previousModel && previousModel.username === draft.username) {
        return previousModel;
      }

      return _.isEmpty(draft.username) ? undefined : draft;
    }
  });
}]);

var inline_editor_directive_InlineDropDownListEditorController = /*#__PURE__*/function () {
  function InlineDropDownListEditorController(VariablesService, $q) {
    var _this = this;

    classCallCheck_default()(this, InlineDropDownListEditorController);

    defineProperty_default()(this, "_hasValueWhichIsNotPresentInList", function (values) {
      return _this.variable.value && !values.includes(_this.variable.value);
    });

    this._variablesService = VariablesService;
    this._$q = $q;
    this._values = [];
    this.isLoaded = false;
    this.isListOfObjects = false;
    this.selectedAutocompleteValue = undefined;
    this.autocompleteHandlers = {
      addCandidates: function addCandidates(metadata, options) {
        return _this.addCandidates(metadata, options);
      },
      onSelect: function onSelect(newValue) {
        _this.selectedAutocompleteValue = newValue;
        _this.variable.value = newValue.id;

        _this.onChange({
          variable: _this.variable
        });
      },
      removeElement: function removeElement() {
        _this.selectedAutocompleteValue = undefined;
        _this.variable.value = undefined;

        _this.onChange({
          variable: _this.variable
        });
      }
    };
  }

  createClass_default()(InlineDropDownListEditorController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      this._variablesService.getPossibleValues(this.variable).then(function (response) {
        var values = response.data; // use autocomplete dropdown if response contain list of object with keys 'title' and 'id'

        _this2.isListOfObjects = !_.isEmpty(values) && _.every(values, function (value) {
          return _.isPlainObject(value) && _.has(value, "id") && _.has(value, "title");
        });

        if (_this2._hasValueWhichIsNotPresentInList(values) && !_this2.isListOfObjects) {
          values.unshift(_this2.variable.value);
        }

        if (_this2.isListOfObjects) {
          _this2.selectedAutocompleteValue = values.find(function (item) {
            return item.id === _this2.variable.value;
          });
        }

        _this2._values = values;
        _this2.isLoaded = true;
      });
    }
  }, {
    key: "addCandidates",
    value: function addCandidates(metadata, options) {
      var result = this.values.filter(function (item) {
        return item.title.toLowerCase().includes(options.term.toLowerCase());
      });
      return this._$q.resolve(result);
    }
  }, {
    key: "values",
    get: function get() {
      return this._values;
    },
    set: function set(values) {
      this._values = values;
    }
  }]);

  return InlineDropDownListEditorController;
}();

inline_editor_directive_InlineDropDownListEditorController.$inject = ['VariablesService', '$q'];
angular.module('xlrelease').component('inlineDropDownListEditor', {
  bindings: {
    variable: '=',
    onChange: '&'
  },
  controller: inline_editor_directive_InlineDropDownListEditorController,
  templateUrl: 'partials/inline-editor/inline-drop-down-list.html'
});
// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/not-in-list-directive.js
var not_in_list_directive = __webpack_require__(861);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/pagination-directive.js
var pagination_directive = __webpack_require__(862);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/on-click-outside-directive.js
var on_click_outside_directive = __webpack_require__(863);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/tags-input-directive.js


function tags_input_directive_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function tags_input_directive_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { tags_input_directive_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { tags_input_directive_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * @description
 * Directive to manage tag list input with auto-completion.
 *
 * @example
 * <div tags-input tags="releaseForm.tags" placeholder="Add a tag..." completion-candidates="candidates"></div>
 *
 * @param tags List of values within the scope.
 * @param placeholder Placeholder for the input.
 * @param completion-candidates List of candidates values within the scope.
 * @param readOnly Read only mode.
 * @param on-change Callback when tags is updated.
 */
function tagInputsFactory() {
  return {
    directive: function directive(options) {
      options.scope = options.scope || {};
      return {
        templateUrl: options.templateUrl,
        scope: tags_input_directive_objectSpread({
          tags: '=',
          readOnly: '=',
          strict: '=',
          completionCandidates: '<',
          variables: '=',
          placeholder: '@',
          onChange: '&',
          onType: '&'
        }, options.scope),
        controller: ['$scope', '$element', function (scope, element) {
          var ctrl = this;

          ctrl.add = function (tag) {
            if (!options.tagFormat.isEmpty(tag)) {
              var alreadyExist;
              scope.$apply(function () {
                alreadyExist = options.tagFormat.alreadyExist(scope.tags, tag);
                var canAdd = true;

                if (scope.strict) {
                  canAdd = scope.completionCandidates.find(function (e) {
                    return e.name === tag.name;
                  });
                }

                if (!alreadyExist && canAdd) {
                  scope.tags.push(tag);
                  triggerChange();
                  scope.newTag = '';
                } else {
                  scope.newTag = '';
                }
              });

              if (alreadyExist) {
                highlight(tag);
              }
            }
          };

          ctrl.remove = function (tag) {
            scope.tags = _.without(scope.tags, tag);
            triggerChange();
          };

          ctrl.initAutocomplete = function (candidates) {
            var input = element.find('.tag-input');
            var sortedCandidates = candidates.sort(options.tagFormat.comparator);

            var fixPositioning = function fixPositioning(element) {
              element.autocomplete('widget').position(_.assign({
                of: input
              }, element.autocomplete('option', 'position')));
            };

            var autocomplete = input.autocomplete({
              source: function source(request, response) {
                var onlyUnusedTags = scope.tags && scope.tags.length ? sortedCandidates.filter(function (tag) {
                  return !options.tagFormat.alreadyExist(scope.tags, tag);
                }) : sortedCandidates;
                return response(options.autocomplete.sourceFrom(onlyUnusedTags, request, scope));
              },
              delay: 0,
              autoFocus: true,
              select: function select(event, ui) {
                ctrl.add(options.tagFormat.getTagFromAutocomplete(ui.item));
              },
              close: function close() {
                var ul = angular.element(this).autocomplete('widget');
                input.val(scope.newTag);
                ul.removeClass('tags-input-autocomplete');
                ul.css('width', '');
              },
              open: function open() {
                var ul = angular.element(this).autocomplete('widget');
                var ulW = ul.prop('clientWidth');
                ul.addClass('tags-input-autocomplete');
                ul.width('+=' + (ulW - ul.prop('clientWidth')));
                fixPositioning(angular.element(this));
              },
              position: {
                at: 'left bottom',
                my: 'left top',
                collision: 'fit flip'
              }
            });

            if (angular.isDefined(options.autocomplete.renderItem)) {
              autocomplete.data("ui-autocomplete")._renderItem = options.autocomplete.renderItem;
            }
          };

          function triggerChange() {
            if (scope.onChange) scope.onChange({
              'tags': scope.tags
            });
          }

          function highlight(tag) {
            element.find(".tag-label:contains('" + options.tagFormat.getTagLabel(tag) + "')").parents(".tag").effect('highlight');
          }
        }],
        link: function link(scope, element, attributes, ctrl) {
          var hasAutocompletion = angular.isDefined(attributes.completionCandidates);
          scope.newTag = '';
          scope.remove = ctrl.remove;

          if ('autofocus' in attributes) {
            element.find('.tag-input').focus();
          }

          if (hasAutocompletion && !scope.readOnly) {
            scope.$watch('completionCandidates', function (candidates) {
              if (angular.isDefined(candidates)) {
                ctrl.initAutocomplete(candidates);
              }
            });
          }

          element.find('.tag-input').on('keypress', function (event) {
            // on enter
            if (event.which === 13) {
              ctrl.add(options.tagFormat.getTagFromInput(scope.newTag, attributes.tagType));
              event.preventDefault();
            }
          });
          element.find('.tag-input').on('blur', function (event) {
            ctrl.add(options.tagFormat.getTagFromInput(scope.newTag, attributes.tagType));
            event.preventDefault();
          });
          element.find('.tag-input').on('keydown', function (evt) {
            var val = element.find('.tag-input').val();

            if (evt.which === 8 && val.length === 0) {
              scope.$apply(function () {
                return scope.remove(scope.tags.pop());
              });
            }
          });
        }
      };
    }
  };
}

function tagsInput(TagsInputs) {
  return TagsInputs.directive({
    templateUrl: 'partials/directives/tags-input.html',
    tagFormat: {
      comparator: function comparator(tag1, tag2) {
        return tag1.localeCompare(tag2, undefined, {
          numeric: true
        });
      },
      isEmpty: function isEmpty(tag) {
        return tag === '';
      },
      alreadyExist: function alreadyExist(tags, tag) {
        return _.includes(tags, tag);
      },
      getTagLabel: angular.identity,
      getTagFromAutocomplete: function getTagFromAutocomplete(item) {
        return item.value;
      },
      getTagFromInput: angular.identity
    },
    autocomplete: {
      sourceFrom: function sourceFrom(tags, request) {
        // check https://github.com/jquery/jquery-ui/blob/master/ui/widgets/autocomplete.js#L630
        return angular.element.ui.autocomplete.filter(tags, request.term);
      }
    }
  });
}

function membersInput(TagsInputs, MemberType, memberNameFormatterFilter) {
  return TagsInputs.directive({
    templateUrl: 'partials/directives/members-input.html',
    tagFormat: {
      comparator: function comparator(member1, member2) {
        return member1.name.localeCompare(member2.name, undefined, {
          numeric: true
        });
      },
      isEmpty: function isEmpty(member) {
        return member.name === '';
      },
      alreadyExist: function alreadyExist(members, member) {
        return _.some(members, {
          'name': member.name,
          'type': member.type
        });
      },
      getTagLabel: function getTagLabel(member) {
        return member.name;
      },
      getTagFromAutocomplete: function getTagFromAutocomplete(member) {
        return tags_input_directive_objectSpread({}, member);
      },
      getTagFromInput: function getTagFromInput(value, tagType) {
        if (tagType) {
          return {
            name: value,
            type: tagType
          };
        } else {
          return {
            name: value,
            type: MemberType.PRINCIPAL
          };
        }
      }
    },
    autocomplete: {
      sourceFrom: function sourceFrom(members, request) {
        var search = request.term.toLowerCase();

        function matches(name, search) {
          return name ? name.toLowerCase().includes(search) : false;
        }

        var filteredMembers = _.filter(members, function (member) {
          return matches(member.name, search) || matches(member.fullName, search);
        });

        return filteredMembers.slice(0, 100);
      },
      renderItem: function renderItem(ul, member) {
        var div = angular.element('<div>');
        var a = angular.element("<a class=\"".concat(member.type.toLowerCase(), "\"><span class=\"xl-icon tag-icon\">"));
        var label = angular.element('<span class="tag-label">');
        label.append(document.createTextNode(memberNameFormatterFilter(member)));
        label.appendTo(a);
        a.appendTo(div);
        return angular.element('<li>').attr('data-ui-autocomplete-item', angular.toJson(member)).append(div).appendTo(ul);
      }
    }
  });
}

function filterTagInput(TagsInputs) {
  return TagsInputs.directive({
    templateUrl: 'partials/directives/filter-tag-input.html',
    scope: {
      prepend: '<'
    },
    tagFormat: {
      comparator: function comparator(tag1, tag2) {
        return tag1.id.localeCompare(tag2.id, undefined, {
          numeric: true
        });
      },
      isEmpty: function isEmpty(tag) {
        return !tag || !tag.id;
      },
      alreadyExist: function alreadyExist(tags, tag) {
        return !!tags.find(function (t) {
          return t.id === tag.id;
        });
      },
      getTagLabel: function getTagLabel(tag) {
        return tag.title;
      },
      getTagFromAutocomplete: function getTagFromAutocomplete(tag) {
        return tags_input_directive_objectSpread({}, tag);
      },
      getTagFromInput: angular.identity
    },
    autocomplete: {
      sourceFrom: function sourceFrom(candidates, request, scope) {
        var search = request.term.toLowerCase();

        function matches(title, search) {
          return title ? title.toLowerCase().includes(search) : false;
        }

        return candidates.filter(function (candidate) {
          return matches(candidate.title, search);
        }).slice(0, 100);
      },
      renderItem: function renderItem(ul, tag) {
        var jqLite = angular.element('<li>');

        if (!_.isUndefined(tag.tooltip)) {
          jqLite.tooltip({
            title: tag.tooltip,
            container: 'body',
            placement: 'bottom',
            template: '<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner no-max-width"></div></div>'
          });
        }

        return jqLite.append("<a><span class=\"tag-label\">".concat(tag.title, "</span></a>")).appendTo(ul);
      }
    }
  });
}
filterTagInput.$inject = ['TagsInputs'];
tagsInput.$inject = ['TagsInputs'];
membersInput.$inject = ['TagsInputs', 'MemberType', 'memberNameFormatterFilter'];
angular.module('xlrelease').factory('TagsInputs', tagInputsFactory);
angular.module('xlrelease').directive('tagsInput', tagsInput);
angular.module('xlrelease').directive('membersInput', membersInput);
angular.module('xlrelease').directive('filterTagInput', filterTagInput);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/stop-event-propagation.js
var stop_event_propagation = __webpack_require__(864);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/scroll-item-directive.js
var scroll_item_directive = __webpack_require__(865);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/detect-fully-visible-items-directive.js
var detect_fully_visible_items_directive = __webpack_require__(866);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/task-context-menu-directive.js
var task_context_menu_directive = __webpack_require__(867);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/time-zone-directive.js
var time_zone_directive = __webpack_require__(868);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/tooltip-directive.js
var tooltip_directive = __webpack_require__(869);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/ui-layout-directive.js
var ui_layout_directive = __webpack_require__(870);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/user-completion-service.js
var user_completion_service = __webpack_require__(871);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/xlr-dip-of-inline-with-variables-directive.js
var xlr_dip_of_inline_with_variables_directive = __webpack_require__(872);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/xlr-input-with-variables-directive.js
var xlr_input_with_variables_directive = __webpack_require__(873);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/echarts-directive.js
var echarts_directive = __webpack_require__(874);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/shorten-content-directive.js
var shorten_content_directive = __webpack_require__(875);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/handle-first-tab.js
var handle_first_tab = __webpack_require__(876);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/non-negative.js
var non_negative = __webpack_require__(877);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/documentation/doc-link-directive.js
var doc_link_directive = __webpack_require__(878);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/documentation/doc-service.js
var doc_service = __webpack_require__(879);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/facets/facets-service.js






var facets_service_FacetsService = /*#__PURE__*/function () {
  function FacetsService(Backend) {
    classCallCheck_default()(this, FacetsService);

    this._backend = Backend;
  }

  createClass_default()(FacetsService, [{
    key: "getFacets",
    value: function getFacets(taskId) {
      return this._backend.post("api/v1/facets/search", {
        targetId: taskId
      });
    }
  }, {
    key: "getTypes",
    value: function getTypes(type) {
      return this._backend.get("api/v1/facets/types?baseType=".concat(type));
    }
  }, {
    key: "save",
    value: function save(facet) {
      return this._backend.post('api/v1/facets', facet);
    }
  }, {
    key: "update",
    value: function update(facet) {
      return this._backend.put("api/v1/facets/".concat(facet.id), facet);
    }
  }, {
    key: "remove",
    value: function remove(facetId) {
      return this._backend.del("api/v1/facets/".concat(facetId));
    }
  }, {
    key: "isImmutable",
    value: function isImmutable(facetType) {
      return facetType.superTypes.includes('xlrelease.TaskReportingRecord');
    }
  }]);

  return FacetsService;
}();

defineProperty_default()(facets_service_FacetsService, "$inject", ['Backend']);

angular.module('xlrelease').service('FacetsService', facets_service_FacetsService);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/flags/delayed-line-directive.js
var delayed_line_directive = __webpack_require__(880);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/flags/flag-line-directive.js
var flag_line_directive = __webpack_require__(881);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/flags/flag-service.js
var flag_service = __webpack_require__(882);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/filters/filters-controller.js
var filters_controller = __webpack_require__(883);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/filters/filters-query-params.js


function filters_query_params_createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = filters_query_params_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function filters_query_params_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return filters_query_params_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return filters_query_params_arrayLikeToArray(o, minLen); }

function filters_query_params_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

(function () {
  var FiltersQueryParams = function FiltersQueryParams($rootScope, $location, $state, Events, Filters) {
    var _shouldReload = true;

    var parseSearchParams = function parseSearchParams(searchString) {
      var searchParams = {};

      _.forEach(searchString.split('&'), function (searchSegment) {
        var _searchSegment$split = searchSegment.split('='),
            _searchSegment$split2 = slicedToArray_default()(_searchSegment$split, 2),
            key = _searchSegment$split2[0],
            value = _searchSegment$split2[1];

        if (_.isUndefined(searchParams[key])) {
          searchParams[key] = decodeURIComponent(value); // If second entry with this name
        } else if (_.isString(searchParams[key])) {
          searchParams[key] = [searchParams[key], decodeURIComponent(value)]; // If third or later entry with this name
        } else {
          searchParams[key].push(decodeURIComponent(value));
        }
      });

      return searchParams;
    }; // gets the state and stateParams based on path and search params


    var getStateAndParams = function getStateAndParams(path, searchParams) {
      var _iterator = filters_query_params_createForOfIteratorHelper($state.get()),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var state = _step.value;

          if (angular.isFunction(state.$$state)) {
            var internalState = state.$$state();

            if (internalState.url) {
              var params = internalState.url.exec(path, _.keys(parseSearchParams(searchParams)));

              if (params) {
                return {
                  state: state,
                  params: params
                };
              }
            }
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      return null;
    };

    var getPath = function getPath(url) {
      var start = url.indexOf('#');
      var end = url.indexOf('?') > 0 ? url.indexOf('?') : url.length;
      return url.substring(start + 1, end);
    };

    var getSearchParams = function getSearchParams(url) {
      return url.indexOf('?') > 0 ? url.substring(url.indexOf('?') + 1, url.length) : '';
    };

    var registerRouteListener = function registerRouteListener() {
      var cachedSearchParams = null; // we save the search path on a failed transition if it matches the errors...

      $rootScope.$on('$stateChangeError', function (evt, toState, toParams, fromState, fromParams, error) {
        if (error && (error === 'FILTERS_NOT_SET' || error === 'CALENDAR_MONTH_NOT_SET')) {
          cachedSearchParams = $location.search();
          $state.go(toState.name, toParams);
        }
      }); // and reapply them at the start if available...

      $rootScope.$on('$stateChangeStart', function () {
        if (cachedSearchParams) {
          $location.search(cachedSearchParams).replace();
          _shouldReload = false;
        }
      }); // and reapply them after a successful one because UI router strips them off...

      $rootScope.$on('$stateChangeSuccess', function () {
        if (cachedSearchParams) {
          $location.search(cachedSearchParams).replace();
          cachedSearchParams = null;
          _shouldReload = false;
        }
      }); // this should mimic this functionality of ngRoute...
      // preparedRouteIsUpdateOnly = preparedRoute && lastRoute && preparedRoute.$$route === lastRoute.$$route
      //     && angular.equals(preparedRoute.pathParams, lastRoute.pathParams)
      //     && !preparedRoute.reloadOnSearch && !forceReload;

      $rootScope.$on('$locationChangeStart', function (evt, next, previous) {
        var nextPath = getPath(next);
        var nextSearchParams = getSearchParams(next);
        var nextStateAndParams = getStateAndParams(nextPath, nextSearchParams);

        if (nextStateAndParams) {
          var nextState = nextStateAndParams.state;
          var nextStateParams = nextStateAndParams.params;

          var reloadOnSearch = _.get(nextState, 'reloadOnSearch', true);

          if (!reloadOnSearch) {
            var previousPath = getPath(previous);
            var previousSearchParams = getSearchParams(previous);
            var previousStateAndParams = getStateAndParams(previousPath, previousSearchParams);
            var onlySearchParamsChanged = previousStateAndParams && nextPath === previousPath && nextSearchParams !== previousSearchParams;

            if (onlySearchParamsChanged) {
              if (_shouldReload) {
                $state.transitionTo(nextState, nextStateParams, {
                  reload: nextState.name,
                  inherit: false,
                  location: false
                });
              } else {
                _shouldReload = true;
              }
            }
          }
        }
      });
    };

    return {
      update: function update(filters) {
        _shouldReload = false;
        $location.search(Filters.asQueryString(filters));
        $rootScope.$broadcast(Events.filters.filterChanged, filters);
      },
      shouldReload: function shouldReload(value) {
        _shouldReload = value;
      },
      registerRouteListener: registerRouteListener
    };
  };

  FiltersQueryParams.$inject = ['$rootScope', '$location', '$state', 'Events', 'Filters'];
  angular.module('xlrelease').service('FiltersQueryParams', FiltersQueryParams);
})();
// EXTERNAL MODULE: ./node_modules/redux-persist/es/index.js + 12 modules
var es = __webpack_require__(275);

// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/actions/release-overview-actions.js
var actionTypes = {
  RELEASES_SUCCEEDED: 'RELEASES_SUCCEEDED',
  RELEASES_FAILED: 'RELEASES_FAILED',
  MORE_RELEASES_SUCCEEDED: 'MORE_RELEASES_SUCCEEDED',
  MORE_RELEASES_FAILED: 'MORE_RELEASES_FAILED',
  MORE_RELEASES_REQUESTED: 'MORE_RELEASES_REQUESTED',
  RELEASES_PRE_LOAD: 'RELEASES_PRE_LOAD',
  RISKS_REQUESTED: 'RISKS_REQUESTED',
  RISKS_SUCCEEDED: 'RISKS_SUCCEEDED',
  RISKS_REQUEST_FAILED: 'RISKS_REQUEST_FAILED',
  LOAD_RELEASES: 'LOAD_RELEASES',
  LOAD_RELEASES_IMMEDIATELY: 'LOAD_RELEASES_IMMEDIATELY',
  UPDATE_FILTERS_REQUESTED: 'UPDATE_FILTERS_REQUESTED',
  UPDATE_FILTERS_SUCCEEDED: 'UPDATE_FILTERS_SUCCEEDED',
  TOGGLE_RELEASE: 'TOGGLE_RELEASE',
  START_RELEASES: 'START_RELEASES',
  GROUP_RELEASES: 'GROUP_RELEASES',
  DO_START_RELEASES: 'DO_START_RELEASES',
  ABORT_RELEASES: 'ABORT_RELEASES',
  DO_ABORT_RELEASES: 'DO_ABORT_RELEASES',
  BULK_ACTION_STARTED: 'BULK_ACTION_STARTED',
  BULK_ACTION_STOPPED: 'BULK_ACTION_STOPPED',
  AFTER_BULK_ACTION_EXECUTED: 'AFTER_BULK_ACTION_EXECUTED',
  UNSELECT_ALL: 'UNSELECT_ALL',
  TOGGLE_SELECT_ALL: 'TOGGLE_SELECT_ALL',
  FETCH_TAGS_REQUESTED: 'FETCH_TAGS_REQUESTED',
  FETCH_TAGS_SUCCEEDED: 'FETCH_TAGS_SUCCEEDED',
  COUNT_SUCCEEDED: 'RELEASES_COUNT_SUCCEEDED',
  COUNT_FAILED: 'RELEASES_COUNT_FAILED'
};

var showModalAction = function showModalAction(type) {
  return function (uibModalService) {
    return {
      type: type,
      uibModalService: uibModalService
    };
  };
};

var showModalActionWithPayload = function showModalActionWithPayload(type, payload) {
  return function (uibModalService) {
    return {
      type: type,
      payload: payload,
      uibModalService: uibModalService
    };
  };
};

var release_overview_actions_toggleRelease = function toggleRelease($event, $index, releaseId) {
  return {
    type: actionTypes.TOGGLE_RELEASE,
    payload: {
      $event: $event,
      $index: $index,
      releaseId: releaseId
    }
  };
};
var startReleases = showModalAction(actionTypes.START_RELEASES);
var groupReleases = function groupReleases(uibModalService, selectedReleases) {
  return {
    type: actionTypes.GROUP_RELEASES,
    payload: {
      uibModalService: uibModalService,
      selectedReleases: selectedReleases
    }
  };
};
var release_overview_actions_abortReleases = function abortReleases(uibModalService, abortComment) {
  return showModalActionWithPayload(actionTypes.ABORT_RELEASES, {
    abortComment: abortComment
  })(uibModalService);
};
var getMoreReleases = function getMoreReleases() {
  return {
    type: actionTypes.MORE_RELEASES_REQUESTED
  };
};
var release_overview_actions_getRisks = function getRisks(releaseId) {
  return {
    type: actionTypes.RISKS_REQUESTED,
    payload: releaseId
  };
};
var doAbortAction = function doAbortAction(releaseIds, abortComment) {
  return {
    type: actionTypes.DO_ABORT_RELEASES,
    payload: {
      releaseIds: releaseIds,
      abortComment: abortComment
    }
  };
};
var doStartAction = function doStartAction(releaseIds) {
  return {
    type: actionTypes.DO_START_RELEASES,
    payload: releaseIds
  };
};
var fetchTags = function fetchTags() {
  return {
    type: actionTypes.FETCH_TAGS_REQUESTED
  };
};
var fetchTagsSucceeded = function fetchTagsSucceeded(tags) {
  return {
    type: actionTypes.FETCH_TAGS_SUCCEEDED,
    payload: tags
  };
};
var setFilters = function setFilters(filters) {
  var loadReleases = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var loadImmediately = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return {
    type: actionTypes.UPDATE_FILTERS_REQUESTED,
    payload: {
      filters: filters,
      loadReleases: loadReleases,
      loadImmediately: loadImmediately
    }
  };
};
var release_overview_actions_toggleSelectAll = function toggleSelectAll() {
  return {
    type: actionTypes.TOGGLE_SELECT_ALL
  };
};
var release_overview_actions_unSelectAll = function unSelectAll() {
  return {
    type: actionTypes.UNSELECT_ALL
  };
};
/* harmony default export */ var release_overview_actions = ({
  setFilters: setFilters
});
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/actions/release-groups-actions.js
var release_groups_actions_actionTypes = {
  GROUPS_PRE_LOAD: 'GROUPS_PRE_LOAD',
  GROUPS_SUCCEEDED: 'GROUPS_SUCCEEDED',
  GROUPS_FAILED: 'GROUPS_FAILED',
  MORE_GROUPS_SUCCEEDED: 'MORE_GROUPS_SUCCEEDED',
  MORE_GROUPS_FAILED: 'MORE_GROUPS_FAILED',
  MORE_GROUPS_REQUESTED: 'MORE_GROUPS_REQUESTED',
  UPDATE_FILTERS_REQUESTED: 'UPDATE_GROUPS_FILTERS_REQUESTED',
  UPDATE_FILTERS_SUCCEEDED: 'UPDATE_GROUPS_FILTERS_SUCCEEDED',
  UPDATE_FILTERS_FAILED: 'UPDATE_GROUPS_FILTERS_FAILED',
  DO_ADD_RELEASES_SUCCEEDED: 'DO_ADD_RELEASES_SUCCEEDED',
  DO_ADD_RELEASES_REQUESTED: 'DO_ADD_RELEASES_REQUESTED',
  DO_ADD_RELEASES_FAILED: 'DO_ADD_RELEASES_FAILED',
  DO_DELETE_GROUP: 'DELETE_GROUP',
  CONFIRM_DELETE_GROUP: 'CONFIRM_DELETE_GROUP'
};
var getMoreGroups = function getMoreGroups() {
  return {
    type: release_groups_actions_actionTypes.MORE_GROUPS_REQUESTED
  };
};
var release_groups_actions_setFilters = function setFilters(filters) {
  var loadGroups = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  return {
    type: release_groups_actions_actionTypes.UPDATE_FILTERS_REQUESTED,
    payload: {
      filters: filters,
      loadGroups: loadGroups
    }
  };
};
var doAddRelease = function doAddRelease(groupId, releaseIds, closeModal) {
  return {
    type: release_groups_actions_actionTypes.DO_ADD_RELEASES_REQUESTED,
    payload: {
      groupId: groupId,
      releaseIds: releaseIds,
      closeModal: closeModal
    }
  };
};
var release_groups_actions_deleteGroup = function deleteGroup(id) {
  return {
    type: release_groups_actions_actionTypes.DO_DELETE_GROUP,
    payload: id
  };
};
/* harmony default export */ var release_groups_actions = ({
  setFilters: release_groups_actions_setFilters
});
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/actions/deliveries-actions.js
var deliveries_actions = __webpack_require__(72);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/filters/filters-service.js




/*
 * Handle the filters available on various pages of the application.
 *
 * The filter settings are always reflected in the URL query parameters, in order to make the pages bookmarkable.
 * In addition, the last used settings are remembered, and used if the page is accessed without query parameters.
 *
 * The functions exposed here are used as route "resolve" handlers in app.js.
 */

angular.module('xlrelease').factory('Filters', ['$q', '$location', '$state', 'ClientSettings', '$ngRedux', function ($q, $location, $state, ClientSettings, $ngRedux) {
  // Defines the parameters of a filter (can be either booleans or strings)
  function filterDefinition(defaults) {
    var booleans = _(defaults).pickBy(function (value) {
      return _.isBoolean(value);
    }).keys().value();

    var strings = _(defaults).pickBy(function (value) {
      return angular.isString(value);
    }).keys().value();

    var hasEmptyDefaultQueryString = _(defaults).values().every(function (value) {
      return value === false || value === '';
    });

    return {
      defaults: defaults,
      names: _.keys(defaults),
      eachBoolean: function eachBoolean(callback) {
        _.forEach(booleans, callback);
      },
      eachString: function eachString(callback) {
        _.forEach(strings, callback);
      },
      hasEmptyDefaultQueryString: hasEmptyDefaultQueryString
    };
  } // Generic algorithm to resolve the filter for a route.


  function generateGetter(defaults, getFromLocalStorage, putInLocalStorage, rules, paths, actionToDispatch) {
    var definition = filterDefinition(defaults);
    return function () {
      var deferred = $q.defer(); // if filter params are provided in the URL, use that

      var queryFilters = fromQueryString($location.search(), definition);

      if (queryFilters) {
        if (rules) {
          queryFilters = rules(queryFilters);
        }

        if (isReduxCompatible(paths)) {
          if (actionToDispatch) {
            $ngRedux.dispatch(actionToDispatch(queryFilters));
          }
        } else {
          putInLocalStorage(queryFilters);
        }

        deferred.resolve(queryFilters);
      } else {
        // have to reject or the state will be loaded twice
        if (isReduxCompatible(paths)) {
          restoreFromRedux(rules, deferred, paths[0]);
        } else {
          useSavedOrDefaultsFilters(rules);
          deferred.reject('FILTERS_NOT_SET');
        }
      }

      return deferred.promise;
    };

    function isReduxCompatible(paths) {
      return paths && paths.includes($location.path());
    }

    function restoreFromRedux(rules, deferred, path) {
      Object(es["c" /* getStoredState */])({
        keyPrefix: 'filters:'
      }, function (err, loaded) {
        var filters = definition.defaults;

        if (!err) {
          var state = $state.get().find(function (state) {
            return state.url === path;
          });
          var stateName = state.name === 'default' ? 'releaseOverview' : state.name;

          if (loaded[stateName]) {
            filters = loaded[stateName].filters;
          }
        }

        if (rules) {
          filters = rules(filters);
        }

        $location.search(asQueryString(filters)).replace();
        deferred.reject('FILTERS_NOT_SET');
      });
    }

    function useSavedOrDefaultsFilters(rules) {
      var queryString = $location.search();
      var filters = getFromLocalStorage() || definition.defaults;

      if (rules) {
        filters = rules(filters);
      }

      _.assign(queryString, asQueryString(filters));

      $location.search(queryString).replace();
    }
  }

  function generateMapItemGetter(defaults, getFromLocalStorage, putInLocalStorage, rules) {
    return function (id) {
      return generateGetter(defaults, _.partial(getFromLocalStorage, id), _.partial(putInLocalStorage, id), rules)();
    };
  } // Used to mark the URL once we have applied filters retrieved from local storage.
  // Without this param we would not be able to differentiate the following cases:
  // 1) 'empty' configuration (all booleans false and all strings empty) that was
  //    previously set by the user
  // 2) no configuration at all (first access to the page)


  var HAS_FILTER = "has_filter";
  var MUST_NOT_BE_EMPTY = ["timeFrame", "orderBy"];

  function fromQueryString(queryString, definition) {
    if (!queryString[HAS_FILTER]) {
      return null;
    }

    var filter = _.pick(queryString, definition.names);

    definition.eachBoolean(function (name) {
      filter[name] = !!filter[name];
    });
    definition.eachString(function (name) {
      if (!filter[name]) {
        if (_.includes(MUST_NOT_BE_EMPTY, name)) {
          filter[name] = definition.defaults[name];
        } else {
          filter[name] = "";
        }
      }
    });
    return filter;
  }

  function asQueryString(filters) {
    var queryString = {};
    queryString[HAS_FILTER] = true;

    _.forEach(filters, function (value, key) {
      if (value === true) {
        queryString[key] = true;
      } else if (angular.isString(value) && value.length > 0) {
        queryString[key] = value;
      } else if (angular.isNumber(value)) {
        queryString[key] = value;
      } else if (angular.isArray(value)) {
        queryString[key] = value;
      }
    });

    return queryString;
  }

  function dateFromFilter(dateFilter) {
    return dateFilter ? moment.utc(parseInt(dateFilter, 10)).local().toDate() : null;
  }

  function dateForFilter(date) {
    return date ? moment(date).valueOf() : null;
  }

  var groupsDefaults = {
    planned: false,
    inProgress: true,
    paused: true,
    failing: true,
    failed: true,
    aborted: false,
    completed: false,
    title: '',
    orderBy: 'risk'
  };
  var deliveryDefaults = {
    inProgress: true,
    completed: true,
    title: '',
    orderBy: 'start_date'
  };
  var groupsDetailsDefaults = {
    title: '',
    orderBy: 'risk'
  };
  var releasesDefaults = {
    planned: false,
    inProgress: true,
    paused: true,
    failing: true,
    failed: true,
    aborted: false,
    completed: false,
    onlyArchived: false,
    onlyMine: false,
    onlyFlagged: false,
    title: '',
    from: null,
    to: null,
    orderBy: 'risk',
    tags: [],
    parentId: null
  };
  var calendarDefaults = {
    active: true,
    planned: true,
    inactive: false,
    onlyMine: false,
    onlyFlagged: false,
    title: '',
    tags: [],
    from: null,
    to: null
  };
  var tasksDefaults = {
    planned: true,
    inProgress: true,
    pending: true,
    failed: true,
    assignedToMe: true,
    assignedToMyTeams: false,
    assignedToAnybody: false,
    filter: '',
    from: null,
    to: null,
    tags: [],
    folderId: null,
    orderBy: 'due_date'
  };
  var reportsDefaults = {
    timeFrame: 'LAST_SIX_MONTHS',
    tags: [],
    from: null,
    to: null
  };
  var templatesDefaults = {
    title: '',
    tags: []
  };
  var releaseValueStreamDefaults = {
    title: '',
    from: null,
    to: null,
    tags: [],
    timeFrame: 'LAST_MONTH'
  };
  var logsDefaults = {
    filter: '',
    from: null,
    to: null,
    important: true,
    releaseEdit: false,
    taskEdit: false,
    deliveryEdit: false,
    comments: false,
    lifecycle: false,
    reassign: false,
    security: false,
    other: false,
    dateAsc: false
  };
  var dashboardDefaults = {
    title: ''
  };
  var folderTriggersDefaults = {
    orderBy: null,
    dir: null,
    triggerTitle: null,
    triggerType: [],
    templateTitle: null
  };

  function calendarRules(filters) {
    return _(filters).thru(convertTagsToArray).thru(fixTitle).value();
  }

  function reportRules(filters) {
    return _(filters).thru(convertTimestampsToNumber).thru(convertTagsToArray).thru(fixTitle).value();
  }

  function templateRules(filters) {
    return _(filters).thru(fixTitle).thru(convertTagsToArray).value();
  }

  function triggerRules(filters) {
    return _(filters).thru(convertPropertyToArray('triggerType')).value();
  }

  function fixTitle(filters) {
    if (filters && filters.filter && !filters.title) {
      filters.title = filters.filter;
      delete filters.filter;
    } else if (_.has(filters, 'filter')) {
      delete filters.filter;
    }

    return filters;
  }

  function convertTimestampsToNumber(filters) {
    if (filters && filters.from && _.isString(filters.from)) {
      filters.from = _.toNumber(filters.from);
    }

    if (filters && filters.to && _.isString(filters.to)) {
      filters.to = _.toNumber(filters.to);
    }

    return filters;
  }

  function convertTagsToArray(filters) {
    return convertPropertyToArray('tags')(filters);
  }

  function convertPropertyToArray(propertyName) {
    return function (filters) {
      if (filters) {
        filters[propertyName] = _.isString(filters[propertyName]) ? filters[propertyName].split(',') : filters[propertyName] || [];
      }

      return filters;
    };
  }

  function fixOrderBy(filters) {
    if (filters && !['start_date', 'end_date', 'risk'].includes(filters.orderBy)) {
      filters.orderBy = 'risk';
    }

    return filters;
  }

  function taskRules(filters) {
    return _(filters).thru(convertTimestampsToNumber).thru(convertTagsToArray).value();
  }

  function releaseRules(filters) {
    return _(filters).thru(convertTimestampsToNumber).thru(fixOrderBy).thru(fixTitle).thru(convertTagsToArray).value();
  }

  function deliveryRules(filters) {
    return _.thru(filters, fixTitle);
  }

  function groupRules(filters) {
    return _(filters).thru(fixOrderBy).thru(fixTitle).value();
  }

  function groupsDetailsRules(filters) {
    return _(filters).thru(fixOrderBy).thru(fixTitle).value();
  }

  return {
    getTasksFilterSettings: generateGetter(tasksDefaults, ClientSettings.getTasksFilters, ClientSettings.setTasksFilters, taskRules),
    getReleasesFilterSettings: generateGetter(releasesDefaults, ClientSettings.getReleasesListFilters, ClientSettings.setReleasesListFilters, releaseRules, ['/default', '/releases'], release_overview_actions.setFilters),
    // TODO bdevic: MOVE THIS TO MODULE
    getDeliveriesFilterSettings: generateGetter(deliveryDefaults, ClientSettings.getDeliveryListFilters, ClientSettings.setDeliveryListFilters, deliveryRules, ['/deliveries'], deliveries_actions["b" /* default */].setFilters),
    getGroupsFilterSettings: generateGetter(groupsDefaults, ClientSettings.getGroupsListFilters, ClientSettings.setGroupsListFilters, groupRules, ['/groups'], release_groups_actions.setFilters),
    getGroupsDetailsFilterSettings: generateGetter(groupsDetailsDefaults, angular.noop, angular.noop, groupsDetailsRules),
    getCalendarFilterSettings: generateGetter(calendarDefaults, ClientSettings.getCalendarFilters, ClientSettings.setCalendarFilters, calendarRules),
    getReportsFiltersSettings: generateGetter(reportsDefaults, ClientSettings.getReportsFilters, ClientSettings.setReportsFilters, reportRules),
    getTemplatesFilterSettings: generateGetter(templatesDefaults, ClientSettings.getTemplatesListFilters, ClientSettings.setTemplatesListFilters, templateRules),
    getReleaseValueStreamFilterSettings: generateGetter(releaseValueStreamDefaults, ClientSettings.getReleaseValueStreamFilters, ClientSettings.setReleaseValueStreamFilters, reportRules),
    getLogsFiltersSettings: generateMapItemGetter(logsDefaults, ClientSettings.getLogsFilters, ClientSettings.setLogsFilters, convertTimestampsToNumber),
    getDashboardsFilterSettings: generateGetter(dashboardDefaults, ClientSettings.getFolderDashboardListFilters, ClientSettings.setFolderDashboardListFilters),
    getFolderTriggersFilterSettings: generateGetter(folderTriggersDefaults, ClientSettings.getFolderTriggersFilters, ClientSettings.setFolderTriggersFilters, triggerRules),
    asQueryString: asQueryString,
    dateFromFilter: dateFromFilter,
    dateForFilter: dateForFilter
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/http/backend.ts
var backend = __webpack_require__(174);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/http/http-interceptor.js
var http_interceptor = __webpack_require__(901);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/xlrelease.ts
var xlrelease = __webpack_require__(175);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/http/version-enforcer.js



angular.module('xlrelease').factory('VersionEnforcer', [function () {
  return {
    addPrefix: function addPrefix(request) {
      if (request.url.match(/^partials\//)) {
        request.url = 'static/' + xlrelease["a" /* default */].version + '/' + request.url;
      }
    }
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/index/default-route-controller.js
var default_route_controller = __webpack_require__(902);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/index/license-controller.js



angular.module('xlrelease').controller('LicenseController', ['$scope', 'Backend', 'DateService', 'Authenticator', function ($scope, Backend, DateService, Authenticator) {
  var DAYS_BEFORE_EXPIRATION_WARNING = 5;
  var expirationDate = null;
  $scope.version = xlrelease["a" /* default */].version;
  Backend.get('server/license').then(function (resp) {
    $scope.license = resp.data;
    expirationDate = moment($scope.license.expiresAfter);
  });

  $scope.licenseIsExpired = function () {
    return expirationDate !== null && expirationDate.isBefore(DateService.getToday());
  };

  $scope.licenseIsAlmostExpired = function () {
    return expirationDate !== null && !$scope.licenseIsExpired() && expirationDate.isBefore(DateService.getToday().add(DAYS_BEFORE_EXPIRATION_WARNING, 'days'));
  };

  $scope.showLicenseInfo = function () {
    return $scope.isAdmin() && ($scope.licenseIsAlmostExpired() || $scope.licenseIsExpired() && $scope.license.repositoryId);
  };

  $scope.isAdmin = function () {
    return Authenticator.isAdminOr();
  };
}]);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/index/main-controller.js





var main_controller_MainController = /*#__PURE__*/function () {
  function MainController($scope, Authenticator, ClientSettings, Page, UiExtensionsService, $rootScope, Events, Backend, $state, SystemMessageService) {
    var _this = this;

    classCallCheck_default()(this, MainController);

    defineProperty_default()(this, "ensureMainMenuLoaded", function () {
      if (!_this.$scope.mainMenuItems.length) {
        _this.loadMainMenu();
      }
    });

    defineProperty_default()(this, "loadMainMenu", function () {
      _this.UiExtensionsService.getMainMenuItems().then(function (items) {
        _this.$scope.mainMenuItems = items;

        _this.loadSubMenu();
      });
    });

    defineProperty_default()(this, "loadSubMenu", function (event, data) {
      _this.Page.fetchSubNavMenuItems().then(function (items) {
        _this.$scope.subMenuItems = items;

        if (data && _.isFunction(data.onRefresh)) {
          data.onRefresh();
        }
      });
    });

    this.UiExtensionsService = UiExtensionsService;
    this.Authenticator = Authenticator;
    this.$rootScope = $rootScope;
    this.Events = Events;
    this.Page = Page;
    this.$scope = $scope;
    this.Backend = Backend;
    $scope.version = xlrelease["a" /* default */].version;

    $scope.logout = function () {
      return Authenticator.logout();
    };

    $scope.clearClientSettings = function () {
      return ClientSettings.clear();
    };

    $scope.getPageTitle = function () {
      return Page.getTitle();
    };

    $scope.isFullPage = function () {
      return Page.isFullPage();
    };

    $scope.isPage = function (path, isRootPath) {
      return Page.isOnPage(path, isRootPath);
    };

    $scope.isLoginPage = function () {
      return Page.isLoginPage();
    };

    $scope.isTemplateDetailsPage = function () {
      return Page.isTemplateDetailsPage();
    };

    $scope.isDeliveryPatternDetails = function () {
      return $state.is('deliveryPatternsDetails') || $state.is('deliveryPatternsDetailsPageExtension');
    };

    $scope.isReleaseFlowPage = function () {
      return Page.isReleaseFlowPage();
    };

    $scope.isTemplateReleaseFlowPage = function () {
      return Page.isTemplateReleaseFlowPage();
    };

    $scope.isRolePage = function () {
      return Page.isRolePage();
    };

    $scope.isDashboardsPages = function () {
      return Page.isDashboardsPages();
    };

    $scope.isGlobalDashboardsPages = function () {
      return Page.isGlobalDashboardsPages();
    };

    $scope.isReportsPages = function () {
      return Page.isReportsPages();
    };

    $scope.isAuditReportPages = function () {
      return Page.isAuditReportPages();
    };

    $scope.hasActionButton = function () {
      return Page.isGlobalDashboardsPages() || Page.isReportsPages() || Page.isAuditReportPages();
    };

    $scope.isDefinitionPage = function () {
      return Page.isDefinitionPage();
    };

    $scope.refreshPage = function () {
      return Page.refresh();
    };

    $scope.isSystemMessageEnabled = function () {
      return SystemMessageService.isMessageEnabled(_this.$scope.systemMessage);
    };

    $scope.mainMenuItems = [];
    $scope.subMenuItems = [];
  }

  createClass_default()(MainController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      this.listeners = [this.$rootScope.$on(this.Events.permission.loggedIn, this.loadMainMenu), this.$rootScope.$on(this.Events.ui.ensureMainMenuLoaded, this.ensureMainMenuLoaded), this.$rootScope.$on(this.Events.ui.subMenuRefresh, this.loadSubMenu), this.$rootScope.$on(this.Events.ui.themeRefresh, function () {
        return _this2.$scope.theme = _this2.Page.theme;
      }), this.$rootScope.$on(this.Events.ui.customLogoRefresh, function () {
        return _this2.$scope.customLogoSrc = _this2.Page.customLogoSrc;
      }), this.$rootScope.$on(this.Events.breadcrumbs.update, function (event, breadcrumbs) {
        return _this2.$scope.breadcrumbs = breadcrumbs;
      }), this.$rootScope.$on(this.Events.settings.systemMessageUpdated, function (event, systemMessageSettings) {
        return _this2.$scope.systemMessage = systemMessageSettings;
      })];

      if (this.Authenticator.isAuthenticated()) {
        this.loadMainMenu();
      }

      this.Backend.get('server/logo/xl-release', {
        hideAlert: true
      }).then(function () {
        return _this2.$scope.productLogoSrc = 'server/logo/xl-release';
      }, function () {
        return _this2.$scope.productLogoSrc = 'static/9.7.16/styles/img/digital-ai-release.svg';
      });
      this.Page.initTheme();
      this.Page.initCustomLogo();
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this.listeners.forEach(function (listener) {
        return listener();
      });
    }
  }]);

  return MainController;
}();

defineProperty_default()(main_controller_MainController, "$inject", ['$scope', 'Authenticator', 'ClientSettings', 'Page', 'UiExtensionsService', '$rootScope', 'Events', 'Backend', '$state', 'SystemMessageService']);

angular.module('xlrelease').controller('MainController', main_controller_MainController);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/index/main-menu-extension-controller.js
var main_menu_extension_controller = __webpack_require__(903);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/index/menu-items-provider-registry.js



var menu_items_provider_registry_MenuItemsProviderRegistry = /*#__PURE__*/function () {
  function MenuItemsProviderRegistry() {
    classCallCheck_default()(this, MenuItemsProviderRegistry);

    this.providers = new Map();
  }

  createClass_default()(MenuItemsProviderRegistry, [{
    key: "hasProvider",
    value: function hasProvider(name) {
      return this.providers.has(name);
    }
  }, {
    key: "addProvider",
    value: function addProvider(name, config) {
      this.providers.set(name, config);
    }
  }, {
    key: "getProvider",
    value: function getProvider(name) {
      return this.providers.get(name);
    }
  }]);

  return MenuItemsProviderRegistry;
}();

angular.module('xlrelease').service('MenuItemsProviderRegistry', menu_items_provider_registry_MenuItemsProviderRegistry);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/toConsumableArray.js
var toConsumableArray = __webpack_require__(25);
var toConsumableArray_default = /*#__PURE__*/__webpack_require__.n(toConsumableArray);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/index/page-service.js





/**
 * @deprecated Since we use ui-router, use states!
 */

var PageUrls = {
  START_PAGE: '/tasks',
  LOGIN_PAGE: '/login',
  FORBIDDEN_CONTENT_PAGE: '/forbidden-access',
  INVALID_LICENSE_PAGE: '/invalid-license',
  TEMPLATE: /templates\/.*Release[^\/]*/
};
var CUSTOM_LOGO_SRC = 'settings/custom-logo/download';

var page_service_Page = /*#__PURE__*/function () {
  function Page($rootScope, $location, $state, UiExtensionsService, BreadcrumbsService, Backend, Events, MenuItemsProviderRegistry, $uibModal, SystemMessageService, Authenticator) {
    var _this = this;

    classCallCheck_default()(this, Page);

    this._$uibModal = $uibModal;
    this._MenuItemsProviderRegistry = MenuItemsProviderRegistry;
    this._$rootScope = $rootScope;
    this._$location = $location;
    this._$state = $state;
    this._UiExtensionsService = UiExtensionsService;
    this._BreadcrumbsService = BreadcrumbsService;
    this._activeMenuItems = [];
    this._currentTitle = '';
    this._folder = null;
    this._breadcrumbsSet = false;
    this._Backend = Backend;
    this._Events = Events;
    this._SystemMessageService = SystemMessageService;
    this._Authenticator = Authenticator;
    this._theme = {
      headerAccentColor: colors["a" /* default */].green,
      headerName: ''
    };
    this._customLogoSrc = CUSTOM_LOGO_SRC;

    this._$rootScope.$on('$stateChangeSuccess', function () {
      _this._updateCurrentPage();

      _this._breadcrumbsSet = false;

      _this._$rootScope.$emit(_this._Events.ui.subMenuRefresh);

      if (_this._Authenticator.isAuthenticated()) {
        _this._SystemMessageService.emitSystemMessage();
      }
    });
  }

  createClass_default()(Page, [{
    key: "_updateCurrentPage",
    value: function _updateCurrentPage() {
      var _this2 = this;

      this._UiExtensionsService.getMainMenuItems().then(function (menuItems) {
        if (_this2._breadcrumbsSet) {
          return;
        }

        var newActiveMenuItems = _this2._findActiveMenuPath(menuItems);

        var activeMenuHasChanged = !_.isEqual(newActiveMenuItems, _this2._activeMenuItems);

        var isAtRootPath = _this2.isOnPage(_this2._getLeafActiveMenu(newActiveMenuItems).pathSuffix, true);

        if (activeMenuHasChanged || isAtRootPath) {
          if (!_.isEmpty(newActiveMenuItems)) {
            _this2._currentTitle = _.last(newActiveMenuItems).label;
          } else {
            _this2._currentTitle = '';
          }
        }

        _this2._activeMenuItems = newActiveMenuItems;

        _this2._BreadcrumbsService.updateBreadcrumbs('');
      });
    }
  }, {
    key: "_findActiveMenuPath",
    value: function _findActiveMenuPath(allItems) {
      for (var i = 0; i < allItems.length; i++) {
        var item = allItems[i];

        var subItems = this._findActiveMenuPath(item.items || []);

        if (subItems.length || this.isOnPage(item.pathSuffix)) {
          return [item].concat(subItems);
        }
      }

      return [];
    }
  }, {
    key: "_getLeafActiveMenu",
    value: function _getLeafActiveMenu() {
      return _.last(this._activeMenuItems) || {};
    }
  }, {
    key: "_isFolderPresent",
    value: function _isFolderPresent() {
      return this._folder;
    } // public methods

  }, {
    key: "initTheme",
    value: function initTheme() {
      var _this3 = this;

      this._Backend.get("settings/theme", {
        hideAlert: true
      }).then(function (resp) {
        return _this3.applyTheme(resp.data);
      });
    }
  }, {
    key: "applyTheme",
    value: function applyTheme(data) {
      this._theme = data;

      this._$rootScope.$emit(this._Events.ui.themeRefresh);
    }
  }, {
    key: "initCustomLogo",
    value: function initCustomLogo() {
      this.applyCustomLogo(true);
    }
  }, {
    key: "applyCustomLogo",
    value: function applyCustomLogo(apply) {
      this._customLogoSrc = apply ? CUSTOM_LOGO_SRC + "?cb=" + new Date().valueOf() : null;

      this._$rootScope.$emit(this._Events.ui.customLogoRefresh);
    }
  }, {
    key: "getTitle",
    value: function getTitle() {
      return _.isEmpty(this._currentTitle) ? 'Digital.ai Release' : [this._currentTitle, 'Digital.ai Release'].join(' - ');
    }
  }, {
    key: "addToTitle",
    value: function addToTitle(subtitle) {
      this._currentTitle = subtitle;
    }
  }, {
    key: "setReleaseOpened",
    value: function setReleaseOpened(release) {
      this.addToTitle(release.title);
      this._breadcrumbsSet = true;

      this._BreadcrumbsService.updateBreadcrumbsWithRelease(release);
    }
  }, {
    key: "setFolderOpened",
    value: function setFolderOpened(folder) {
      this.addToTitle(folder.title);
    }
  }, {
    key: "setRiskProfileOpened",
    value: function setRiskProfileOpened(riskProfile) {
      this.addToTitle(riskProfile.title);
      this._breadcrumbsSet = true;

      this._BreadcrumbsService.updateBreadcrumbsWithRiskProfile(riskProfile);

      this._updateCurrentPage();
    }
  }, {
    key: "setFolderEntityOpened",
    value: function setFolderEntityOpened(folderId, entity) {
      this.addToTitle(entity.title);
      this._breadcrumbsSet = true;

      this._BreadcrumbsService.updateBreadcrumbsWithEntity(folderId, entity);

      this._updateCurrentPage();
    }
  }, {
    key: "setDeliveryOpened",
    value: function setDeliveryOpened(delivery) {
      this.addToTitle(delivery.title);
      this._breadcrumbsSet = true;

      this._BreadcrumbsService.updateBreadcrumbsWithDelivery(delivery);

      this._updateCurrentPage();
    }
  }, {
    key: "setDashboardOpened",
    value: function setDashboardOpened(dashboard) {
      this.addToTitle(dashboard.title);
      this._breadcrumbsSet = true;

      this._BreadcrumbsService.updateBreadcrumbsWithDashboard(dashboard);

      this._updateCurrentPage();
    }
  }, {
    key: "fetchSubNavMenuItems",
    value: function fetchSubNavMenuItems() {
      var _this4 = this;

      return this._UiExtensionsService.getMainMenuItems().then(function (items) {
        var activeMenu = _this4._findActiveMenuPath(items);

        if (activeMenu.length > 1) {
          return _.head(activeMenu).items.filter(function (item) {
            return item.permitted;
          });
        }

        return activeMenu;
      }).then(function (menuItems) {
        return _this4.useMenuItemsProviders(menuItems);
      });
    }
  }, {
    key: "useMenuItemsProviders",
    value: function useMenuItemsProviders(menuItems) {
      var _this5 = this;

      var promises = _.reduce(menuItems, function (replacements, item) {
        var providerId = _.get(item, ['properties', 'itemProvider']);

        if (providerId && _this5._MenuItemsProviderRegistry.hasProvider(providerId)) {
          var provider = _this5._MenuItemsProviderRegistry.getProvider(providerId);

          replacements.push(provider().then(function (dynamicItems) {
            return {
              dynamicItems: dynamicItems,
              item: item
            };
          }));
        }

        return replacements;
      }, []);

      return Promise.all(promises).then(function (replacements) {
        replacements.forEach(function (replacement) {
          var index = _.findIndex(menuItems, replacement.item);

          menuItems = [].concat(toConsumableArray_default()(menuItems.slice(0, index)), toConsumableArray_default()(replacement.dynamicItems), toConsumableArray_default()(menuItems.slice(index + 1)));
        });
        return menuItems;
      });
    }
  }, {
    key: "isFullPage",
    value: function isFullPage() {
      return this.isLoginPage() || this.isOnPage(PageUrls.INVALID_LICENSE_PAGE);
    }
  }, {
    key: "isLoginPage",
    value: function isLoginPage() {
      return this.isOnPage(PageUrls.LOGIN_PAGE);
    }
  }, {
    key: "isTemplateDetailsPage",
    value: function isTemplateDetailsPage() {
      return PageUrls.TEMPLATE.test(this._$location.path());
    }
  }, {
    key: "isReleaseFlowPage",
    value: function isReleaseFlowPage() {
      return this._$state.is('release');
    }
  }, {
    key: "isTemplateReleaseFlowPage",
    value: function isTemplateReleaseFlowPage() {
      return this._$state.is('template');
    }
  }, {
    key: "isRolePage",
    value: function isRolePage() {
      return this._$state.is('roles');
    }
  }, {
    key: "isDashboardsPages",
    value: function isDashboardsPages() {
      return this.isGlobalDashboardsPages() || this.isFolderDashboardPage();
    }
  }, {
    key: "isGlobalDashboardsPages",
    value: function isGlobalDashboardsPages() {
      return this._$state.is('dashboards') || this._$state.is('defaultDashboard');
    }
  }, {
    key: "isFolderDashboardPage",
    value: function isFolderDashboardPage() {
      return this._$state.is('folderDashboards');
    }
  }, {
    key: "isReportsPages",
    value: function isReportsPages() {
      return this._$state.is('reports') || this._$state.is('releaseValueStream');
    }
  }, {
    key: "isAuditReportPages",
    value: function isAuditReportPages() {
      return this.isOneOfStates('auditReport', 'auditReportManagement', 'auditReportDownload');
    }
  }, {
    key: "isOneOfStates",
    value: function isOneOfStates() {
      var _this6 = this;

      for (var _len = arguments.length, states = new Array(_len), _key = 0; _key < _len; _key++) {
        states[_key] = arguments[_key];
      }

      return !!states.find(function (state) {
        return _this6._$state.is(state);
      });
    }
  }, {
    key: "isDefinitionPage",
    value: function isDefinitionPage() {
      return this._$state.is('deliveryDefsDetails');
    }
  }, {
    key: "refresh",
    value: function refresh() {
      document.location.reload(true);
    }
  }, {
    key: "isOnPage",
    value: function isOnPage(path, isRootPath) {
      if (!path) return false;
      path = path[0] === '/' ? path.substr(1) : path;

      var currentPath = this._$location.path().substr(1);

      var firstPathSegment = currentPath.substr(0, path.length);

      if (!isRootPath) {
        return firstPathSegment === path;
      }

      return firstPathSegment === path && !currentPath.substr(0, path.length + 1).match(/\/$/);
    }
  }, {
    key: "theme",
    get: function get() {
      return this._theme;
    }
  }, {
    key: "customLogoSrc",
    get: function get() {
      return this._customLogoSrc;
    }
  }]);

  return Page;
}();

defineProperty_default()(page_service_Page, "$inject", ['$rootScope', '$location', '$state', 'UiExtensionsService', 'BreadcrumbsService', 'Backend', 'Events', 'MenuItemsProviderRegistry', '$uibModal', 'SystemMessageService', 'Authenticator']);

angular.module('xlrelease').constant('PageUrls', PageUrls).service('Page', page_service_Page);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/index/system-message-modal.js





var system_message_modal_template = "\n<form id=\"system-message-modal\" name=\"systemMessageForm\" novalidate>\n    <div class=\"modal-header\">\n        <h4 class=\"modal-title pull-left\" id=\"modal-title\">System message</h4>\n        <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.dismiss()\"><i class=\"xl-icon close-icon\"/></button>\n        <div class=\"clearfix\"/>\n    </div>\n    <div class=\"modal-body\" id=\"modal-body\">\n        <div class=\"form-group\">\n            <div class=\"checkbox\">\n                <label for=\"enabled\">\n                    <input type=\"checkbox\" id=\"enabled\" name=\"enabled\" data-ng-model=\"$ctrl.systemMessage.enabled\" />\n                    Enable system message\n                </label>\n            </div>\n        </div>\n        <div class=\"form-group\">\n            <label for=\"message\">\n                System message text \n            </label>        \n             <rich-editor\n                name=\"message\"\n                data-ng-if=\"$ctrl.isLoaded\"\n                content=\"$ctrl.systemMessage.message\"\n                data-disabled=\"!$ctrl.systemMessage.enabled\"\n                toolbar-config=\"$ctrl.DEFAULT_TOOLBAR_CONFIG\"\n                on-content-change=\"$ctrl.onMessageChange\"/>\n        </div>\n        <div class=\"form-group\">\n            <div class=\"checkbox\">\n                <label for=\"automated\">\n                    <input type=\"checkbox\" id=\"automated\" name=\"automated\" data-ng-model=\"$ctrl.systemMessage.automated\" />\n                    Automatically enable/disable system message\n                </label>\n            </div>\n        </div>       \n        <div data-ng-if=\"$ctrl.systemMessage.automated\" class=\"form-inline\">\n            <div class=\"form-group\">\n                <label for=\"startDate\">\n                    Start date\n                </label>\n                <div date-editor\n                     data-ng-model=\"$ctrl.systemMessage.startDate\"\n                     data-deletable=\"true\"\n                     class=\"date-picker\"\n                     is-required=\"$ctrl.systemMessage.automated\"\n                     date-format=\"{{::$ctrl.DEFAULT_DATE_TIME_FORMAT}}\">\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label for=\"endDate\">\n                    End date\n                </label>\n                <div date-editor\n                     data-ng-model=\"$ctrl.systemMessage.endDate\"\n                     data-deletable=\"true\"\n                     class=\"date-picker\"\n                     is-required=\"$ctrl.systemMessage.automated\"\n                     date-format=\"{{::$ctrl.DEFAULT_DATE_TIME_FORMAT}}\">\n                </div>\n            </div>\n            <div ng-if=\"$ctrl.systemMessage.startDate && $ctrl.systemMessage.endDate && !$ctrl.isStartDateBeforeEndDate()\">\n                <span class=\"error\">Start date must be before end date</span>\n            </div>\n        </div>\n    </div>\n    <div class=\"modal-footer\">\n        <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button class=\"button save primary\" type=\"submit\" ng-click=\"$ctrl.save()\" ng-disabled=\"!$ctrl.isFormValid() || systemMessageForm.$invalid\">Save</button>\n    </div>\n</div>\n";

var system_message_modal_SystemMessageController = /*#__PURE__*/function () {
  function SystemMessageController(SystemMessageService, ConfirmLeaveService, $scope, $timeout) {
    var _this = this;

    classCallCheck_default()(this, SystemMessageController);

    defineProperty_default()(this, "DEFAULT_DATE_TIME_FORMAT", global_constants["a" /* dateTimeFormat */].ISODateTime);

    defineProperty_default()(this, "DEFAULT_TOOLBAR_CONFIG", {
      display: ['INLINE_STYLE_BUTTONS'],
      INLINE_STYLE_BUTTONS: [{
        label: 'Bold',
        style: 'BOLD'
      }, {
        label: 'Italic',
        style: 'ITALIC'
      }, {
        label: 'Underline',
        style: 'UNDERLINE'
      }]
    });

    defineProperty_default()(this, "onMessageChange", function (value) {
      _this.$timeout(function () {
        value = this._removeHtmlHeadings(value);
        this.systemMessage.message = value;
      }.bind(_this));
    });

    this.SystemMessageService = SystemMessageService;
    this.ConfirmLeaveService = ConfirmLeaveService;
    this.$scope = $scope;
    this.$timeout = $timeout;
    this.isLoaded = false;
    this.systemMessageCopy = {};
    this.systemMessage = {};
  }

  createClass_default()(SystemMessageController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      this.$scope.$on('modal.closing', function (event) {
        if (!_this2._isUnchanged()) {
          event.preventDefault();

          _this2.ConfirmLeaveService.openConfirmationDialog().then(function () {
            _this2.systemMessage = angular_default.a.copy(_this2.systemMessageCopy);

            _this2.dismiss();
          });
        }
      });
      this.SystemMessageService.loadSystemMessage().then(function (systemMessage) {
        _this2.systemMessage = systemMessage;

        if (angular_default.a.isUndefined(_this2.systemMessage.message)) {
          _this2.systemMessage.message = '';
        }

        if (angular_default.a.isUndefined(_this2.systemMessage.startDate)) {
          _this2.systemMessage.startDate = moment().format(_this2.DEFAULT_DATE_TIME_FORMAT);
        }

        if (angular_default.a.isUndefined(_this2.systemMessage.endDate)) {
          _this2.systemMessage.endDate = moment().add(1, 'days').format(_this2.DEFAULT_DATE_TIME_FORMAT);
        }

        _this2.systemMessageCopy = angular_default.a.copy(_this2.systemMessage);
        _this2.isLoaded = true;
      });
    }
  }, {
    key: "_isUnchanged",
    value: function _isUnchanged() {
      return angular_default.a.equals(this.systemMessage, this.systemMessageCopy);
    }
  }, {
    key: "save",
    value: function save() {
      var _this3 = this;

      this.SystemMessageService.saveSystemMessage(this.systemMessage).then(function (systemMessage) {
        _this3.ConfirmLeaveService.disableConfirmation();

        _this3.systemMessage = angular_default.a.copy(systemMessage);
        _this3.systemMessageCopy = angular_default.a.copy(systemMessage);

        _this3.close({
          $value: systemMessage
        });
      });
    }
  }, {
    key: "_removeHtmlHeadings",
    value: function _removeHtmlHeadings(value) {
      return value.replace(/<h[1-6]>/gi, '<p>').replace(/<\/h[1-6]>/gi, '</p>');
    }
  }, {
    key: "isFormValid",
    value: function isFormValid() {
      return !this.systemMessage.enabled && !this.systemMessage.automated || this.systemMessage.enabled && !this.isSystemMessageEmpty() && (!this.systemMessage.automated || this.isStartDateBeforeEndDate());
    }
  }, {
    key: "isStartDateBeforeEndDate",
    value: function isStartDateBeforeEndDate() {
      return moment(this.systemMessage.startDate).isBefore(this.systemMessage.endDate);
    }
  }, {
    key: "isSystemMessageEmpty",
    value: function isSystemMessageEmpty() {
      return this.systemMessage.message.replace(/<p>|<br>|<\/p>|\n|\r|\r\n|&nbsp;/gi, '') === '';
    }
  }]);

  return SystemMessageController;
}();

defineProperty_default()(system_message_modal_SystemMessageController, "$inject", ['SystemMessageService', 'ConfirmLeaveService', '$scope', '$timeout']);

var SystemMessageModal = {
  bindings: {
    close: '&',
    dismiss: '&'
  },
  controller: system_message_modal_SystemMessageController,
  template: system_message_modal_template
};
angular_default.a.module('xlrelease').component('systemMessageModal', SystemMessageModal);
// EXTERNAL MODULE: ./node_modules/ngimport/index.js
var ngimport = __webpack_require__(84);

// EXTERNAL MODULE: ./node_modules/moment/moment.js-exposed
var moment_js_exposed = __webpack_require__(43);
var moment_js_exposed_default = /*#__PURE__*/__webpack_require__.n(moment_js_exposed);

// EXTERNAL MODULE: ./node_modules/lodash/lodash.js
var lodash = __webpack_require__(106);
var lodash_default = /*#__PURE__*/__webpack_require__.n(lodash);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/locale/regional-settings.ts







var DATE_FORMATS = {
  // Month first
  'M/d/yy': {
    shortDate: 'M/d/yy',
    mediumDate: 'MMM d, y',
    longDate: 'MMMM d, y',
    fullDate: 'EEEE, MMMM d, y',
    name: 'Month first'
  },
  // Day first
  'dd/MM/yy': {
    shortDate: 'dd/MM/yy',
    mediumDate: 'dd MMM y',
    longDate: 'dd MMMM y',
    fullDate: 'EEEE dd MMMM y',
    name: 'Day first'
  },
  // Year first
  'yy/MM/dd': {
    shortDate: 'yy/MM/dd',
    mediumDate: 'y MMM dd',
    longDate: 'y MMMM dd',
    fullDate: 'y MMMM dd EEEE',
    name: 'Year first'
  }
};
var TIME_FORMATS = {
  // 24h format
  'HH:mm': {
    shortTime: 'HH:mm',
    mediumTime: 'HH:mm:ss',
    name: '24 hours'
  },
  // 12h format
  'h:mm a': {
    shortTime: 'h:mm a',
    mediumTime: 'h:mm:ss a',
    name: '12 hours'
  }
};
var MONTHS = [{
  short: 'Jan',
  long: 'January'
}, {
  short: 'Feb',
  long: 'February'
}, {
  short: 'Mar',
  long: 'March'
}, {
  short: 'Apr',
  long: 'April'
}, {
  short: 'May',
  long: 'May'
}, {
  short: 'Jun',
  long: 'June'
}, {
  short: 'Jul',
  long: 'July'
}, {
  short: 'Aug',
  long: 'August'
}, {
  short: 'Sep',
  long: 'September'
}, {
  short: 'Oct',
  long: 'October'
}, {
  short: 'Nov',
  long: 'November'
}, {
  short: 'Dec',
  long: 'December'
}];
var DAYS = [{
  short: 'Sun',
  long: 'Sunday'
}, {
  short: 'Mon',
  long: 'Monday'
}, {
  short: 'Tue',
  long: 'Tuesday'
}, {
  short: 'Wed',
  long: 'Wednesday'
}, {
  short: 'Thu',
  long: 'Thursday'
}, {
  short: 'Fri',
  long: 'Friday'
}, {
  short: 'Sat',
  long: 'Saturday'
}];
var AMPMS = ['AM', 'PM'];
var regional_settings_RegionalSettings;

var regional_settings_RegionalSettingsImpl = /*#__PURE__*/function () {
  function RegionalSettingsImpl() {
    classCallCheck_default()(this, RegionalSettingsImpl);

    defineProperty_default()(this, "WEEK_DAYS", lodash_default.a.map(DAYS, 'long'));

    defineProperty_default()(this, "DEFAULT_DATE_FORMATS", ['M/d/yy', 'dd/MM/yy', 'yy/MM/dd']);

    defineProperty_default()(this, "DEFAULT_TIME_FORMATS", ['HH:mm', 'h:mm a']);

    defineProperty_default()(this, "DEFAULT_FIRST_DAY_OF_WEEK_FORMATS", [0, 1]);

    defineProperty_default()(this, "_browserLocale", {
      id: ngimport["$locale"].id,
      firstDayOfWeek: this._detectFirstDayOfWeek(moment_js_exposed_default.a.localeData(ngimport["$locale"].id)),
      dateFormat: {
        shortDate: ngimport["$locale"].DATETIME_FORMATS.shortDate,
        mediumDate: ngimport["$locale"].DATETIME_FORMATS.mediumDate,
        longDate: ngimport["$locale"].DATETIME_FORMATS.longDate,
        fullDate: ngimport["$locale"].DATETIME_FORMATS.fullDate
      },
      timeFormat: {
        shortTime: ngimport["$locale"].DATETIME_FORMATS.shortTime,
        mediumTime: ngimport["$locale"].DATETIME_FORMATS.mediumTime
      }
    });

    defineProperty_default()(this, "_firstDayOfWeek", this._detectFirstDayOfWeek());

    defineProperty_default()(this, "$locale", this._setEnUserLocale(ngimport["$locale"]));
  }

  createClass_default()(RegionalSettingsImpl, [{
    key: "update",
    value: function update(userProfile) {
      if (userProfile) {
        this._updateNgLocale(userProfile);

        this._updateMomentLocale(userProfile);
      }
    }
  }, {
    key: "_setEnUserLocale",
    value: function _setEnUserLocale(locale) {
      locale.id = 'en-user';
      locale.DATETIME_FORMATS.DAY = lodash_default.a.map(DAYS, 'long');
      locale.DATETIME_FORMATS.SHORTDAY = lodash_default.a.map(DAYS, 'short');
      locale.DATETIME_FORMATS.STANDALONEMONTH = lodash_default.a.map(MONTHS, 'long');
      locale.DATETIME_FORMATS.MONTH = lodash_default.a.map(MONTHS, 'long');
      locale.DATETIME_FORMATS.SHORTMONTH = lodash_default.a.map(MONTHS, 'short');
      locale.DATETIME_FORMATS.AMPMS = AMPMS;
      return locale;
    }
  }, {
    key: "_updateNgLocale",
    value: function _updateNgLocale(userProfile) {
      this._updateNgDates(DATE_FORMATS[userProfile.dateFormat] || this._browserLocale.dateFormat);

      this._updateNgTimes(TIME_FORMATS[userProfile.timeFormat] || this._browserLocale.timeFormat);

      this.$locale.DATETIME_FORMATS.short = this.$locale.DATETIME_FORMATS.shortDate + ' ' + this.$locale.DATETIME_FORMATS.shortTime;
      this.$locale.DATETIME_FORMATS.medium = this.$locale.DATETIME_FORMATS.mediumDate + ' ' + this.$locale.DATETIME_FORMATS.mediumTime;
    }
  }, {
    key: "_updateNgDates",
    value: function _updateNgDates(overrides) {
      var _this = this;

      ['shortDate', 'mediumDate', 'longDate', 'fullDate'].forEach(function (property) {
        if (overrides[property]) {
          _this.$locale.DATETIME_FORMATS[property] = overrides[property];
        }
      });
    }
  }, {
    key: "_updateNgTimes",
    value: function _updateNgTimes(overrides) {
      var _this2 = this;

      ['shortTime', 'mediumTime'].forEach(function (property) {
        if (overrides[property]) {
          _this2.$locale.DATETIME_FORMATS[property] = overrides[property];
        }
      });
    }
  }, {
    key: "_updateMomentLocale",
    value: function _updateMomentLocale(userProfile) {
      if (this.isValidFirstDayOfWeek(userProfile.firstDayOfWeek)) {
        var localeConfig = {
          parentLocale: 'en',
          ordinalParse: /\d{1,2}(st|nd|rd|th)/,
          // remove these ordinal overrides once we upgrade to a 2.12+ version
          ordinal: function ordinal(number) {
            var b = number % 10;
            var output = ~~(number % 100 / 10) === 1 ? 'th' : b === 1 ? 'st' : b === 2 ? 'nd' : b === 3 ? 'rd' : 'th';
            return number + output;
          },
          week: {
            dow: userProfile.firstDayOfWeek,
            doy: 4 // https://github.com/moment/momentjs.com/issues/279

          }
        };

        if (moment_js_exposed_default.a.locale('en-user') !== 'en-user') {
          moment_js_exposed_default.a.defineLocale('en-user', localeConfig);
        } else {
          moment_js_exposed_default.a.updateLocale('en-user', localeConfig);
        }
      } else {
        moment_js_exposed_default.a.locale(this._browserLocale.id);
      }

      this._firstDayOfWeek = this._detectFirstDayOfWeek();
    }
  }, {
    key: "_detectFirstDayOfWeek",
    value: function _detectFirstDayOfWeek(date) {
      return (date || moment_js_exposed_default()().localeData()).firstDayOfWeek();
    }
  }, {
    key: "isValidFirstDayOfWeek",
    value: function isValidFirstDayOfWeek(format) {
      return lodash_default.a.isInteger(format) && format >= 0 && format <= 6;
    }
  }, {
    key: "getDateFormats",
    value: function getDateFormats(format) {
      return DATE_FORMATS[format] || this._browserLocale.dateFormat;
    }
  }, {
    key: "getTimeFormats",
    value: function getTimeFormats(format) {
      return TIME_FORMATS[format] || this._browserLocale.timeFormat;
    }
  }, {
    key: "browserDateFormat",
    get: function get() {
      return this._browserLocale.dateFormat.shortDate;
    }
  }, {
    key: "browserTimeFormat",
    get: function get() {
      return this._browserLocale.timeFormat.shortTime;
    }
  }, {
    key: "browserFirstDayOfWeek",
    get: function get() {
      return this._browserLocale.firstDayOfWeek;
    }
  }, {
    key: "currentDateFormat",
    get: function get() {
      return this.$locale.DATETIME_FORMATS.shortDate;
    }
  }, {
    key: "currentTimeFormat",
    get: function get() {
      return this.$locale.DATETIME_FORMATS.shortTime;
    }
  }, {
    key: "currentMediumDateFormat",
    get: function get() {
      return this.$locale.DATETIME_FORMATS.mediumDate;
    }
  }, {
    key: "currentFirstDayOfWeek",
    get: function get() {
      return this._firstDayOfWeek;
    }
  }, {
    key: "weekDays",
    get: function get() {
      return this.WEEK_DAYS.slice(this.currentFirstDayOfWeek).concat(this.WEEK_DAYS.slice(0, this.currentFirstDayOfWeek));
    }
  }]);

  return RegionalSettingsImpl;
}();

Object(node_modules_angular["module"])('xlrelease').service('RegionalSettings', regional_settings_RegionalSettingsImpl);
Object(node_modules_angular["module"])('xlrelease').run(function () {
  return regional_settings_RegionalSettings = ngimport["$injector"].get('RegionalSettings');
});
// EXTERNAL MODULE: ./core/xlr-ui/app/js/login/login-controller.js
var login_controller = __webpack_require__(909);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/menu/navigation-menu-component.js




(function () {
  var NavigationMenu = {
    bindings: {
      items: '<',
      level: '@'
    },
    templateUrl: 'partials/menu/navigation-menu.html'
  };

  var NavigationMenuItemCtrl = /*#__PURE__*/function () {
    function NavigationMenuItemCtrl($location, $state, $uibModal, Page, ConfirmLeaveService) {
      classCallCheck_default()(this, NavigationMenuItemCtrl);

      this._$location = $location;
      this._$state = $state;
      this._$uibModal = $uibModal;
      this._Page = Page;
      this._ConfirmLeaveService = ConfirmLeaveService;
    }

    createClass_default()(NavigationMenuItemCtrl, [{
      key: "$onInit",
      value: function $onInit() {
        this._isMenuItem = _.isUndefined(this.item.items);
      }
    }, {
      key: "isItemActive",
      value: function isItemActive(item) {
        var _this = this;

        return this._Page.isOnPage(item.pathSuffix) || _.some(item.items, function (subItem) {
          return _this.isItemActive(subItem);
        });
      }
    }, {
      key: "goToRoute",
      value: function goToRoute() {
        var _this2 = this;

        if (!this._ConfirmLeaveService.isConfirmationRequired()) {
          return this._goToRouteInternal();
        }

        var promise = this._ConfirmLeaveService.openConfirmationDialog();

        promise.then(function () {
          return _this2._goToRouteInternal();
        });
      }
    }, {
      key: "isPermitted",
      value: function isPermitted(item) {
        if (!_.isEmpty(item.items)) {
          return _.some(item.items, this.isPermitted);
        }

        return item.permitted;
      }
    }, {
      key: "_goToRouteInternal",
      value: function _goToRouteInternal() {
        var url = this.getTransition(this.item);

        if (this._$location.path() === "/".concat(url.pathSuffix)) {
          // we basically say stay in this state, but just reload while preserving the current location path...
          // if the only goal is to keep the location, only the location flag is needed!
          this._$state.transitionTo(this._$state.current, {}, {
            reload: true,
            inherit: false,
            notify: true,
            location: false
          });
        } else {
          this._$location.url("".concat(url.pathSuffix));
        }
      }
    }, {
      key: "getTransition",
      value: function getTransition(item) {
        if (item && item.items) {
          var permittedItems = item.items.filter(function (itemElement) {
            return itemElement.permitted;
          });
          return permittedItems[0];
        } else {
          return item;
        }
      }
    }, {
      key: "getHoverColor",
      value: function getHoverColor() {
        return this._Page.theme.headerAccentColor;
      }
    }, {
      key: "getTextColor",
      value: function getTextColor() {
        return this._Page.theme.headerAccentColor === colors["a" /* default */].orange ? colors["a" /* default */].black : colors["a" /* default */].white;
      }
    }, {
      key: "hasSubItems",
      get: function get() {
        return this._hasSubItems;
      }
    }]);

    return NavigationMenuItemCtrl;
  }();

  NavigationMenuItemCtrl.$inject = ['$location', '$state', '$uibModal', 'Page', 'ConfirmLeaveService'];
  var NavigationMenuItem = {
    bindings: {
      item: '<'
    },
    controller: NavigationMenuItemCtrl,
    templateUrl: 'partials/menu/navigation-menu-item.html'
  };
  angular.module('xlrelease').component('navigationMenu', NavigationMenu).component('navigationMenuItem', NavigationMenuItem);
})();
// CONCATENATED MODULE: ./core/xlr-ui/app/js/profile/profile-controller.js



(function () {
  var ProfileController = /*#__PURE__*/function () {
    function ProfileController($filter, UsersService, UserProfile, RegionalSettings, Authenticator, ConfirmLeaveService) {
      classCallCheck_default()(this, ProfileController);

      this._UsersService = UsersService;
      this._UserProfile = UserProfile;
      this._$filter = $filter;
      this._RegionalSettings = RegionalSettings;
      this._ConfirmLeaveService = ConfirmLeaveService;
      this._lastSavedDate = null;
      this._username = Authenticator.getUsername();
      this._previousPasswordIsInvalid = false;
      this._saveError = false;
      this.isInternalUser = UsersService.isInternalUser;
      this.now = new Date();
      this.passwordStatus = {};

      this._loadProfile();
    }

    createClass_default()(ProfileController, [{
      key: "save",
      value: function save() {
        var _this = this;

        var profileForm = {
          email: this._profile.email,
          fullName: this._profile.fullName,
          timeFormat: this._profile.timeFormat,
          dateFormat: this._profile.dateFormat,
          firstDayOfWeek: this._profile.firstDayOfWeek
        };

        if (this._profile.password) {
          profileForm.password = this._profile.password;
          profileForm.previousPassword = this._profile.previousPassword;
        }

        var error = function error(response) {
          if (_this._profile.password && response.status === 400) {
            _this._previousPasswordIsInvalid = response.data && response.data.includes('Failed to change password: Old password does not match');
            _this._saveError = !_this._previousPasswordIsInvalid && response.data;
          }
        };

        var success = function success() {
          _this._lastSavedDate = moment().toDate();

          if (_this._profile.password) {
            delete _this._profile.password;
            delete _this._profile.passwordConfirmation;
            delete _this._profile.previousPassword;
          }

          _this._previousPasswordIsInvalid = false;
          _this._saveError = false;

          _this._ConfirmLeaveService.disableConfirmation();
        };

        this._UserProfile.save(profileForm).then(success, error);
      }
    }, {
      key: "getDateLabel",
      value: function getDateLabel(format) {
        var formats = this._RegionalSettings.getDateFormats(format);

        return "".concat(formats.name || 'Browser setting', " \u2013 ").concat(this._formatDate(formats.mediumDate));
      }
    }, {
      key: "getTimeLabel",
      value: function getTimeLabel(format) {
        var formats = this._RegionalSettings.getTimeFormats(format);

        return "".concat(formats.name || 'Browser setting', " \u2013 ").concat(this._formatDate(formats.shortTime));
      }
    }, {
      key: "getFirstDayOfWeekLabel",
      value: function getFirstDayOfWeekLabel(format) {
        return this._RegionalSettings.isValidFirstDayOfWeek(format) ? this._RegionalSettings.WEEK_DAYS[format] : 'Browser setting – ' + this._RegionalSettings.WEEK_DAYS[this._RegionalSettings.browserFirstDayOfWeek];
      }
    }, {
      key: "_loadProfile",
      value: function _loadProfile() {
        var _this2 = this;

        this._UserProfile.load().then(function (profile) {
          _this2._profile = profile;
        });
      }
    }, {
      key: "_formatDate",
      value: function _formatDate(format) {
        return "".concat(this._$filter('date')(this.now, format));
      }
    }, {
      key: "username",
      get: function get() {
        return this._username;
      }
    }, {
      key: "profile",
      get: function get() {
        return this._profile;
      }
    }, {
      key: "previousPasswordIsInvalid",
      get: function get() {
        return this._previousPasswordIsInvalid;
      }
    }, {
      key: "saveError",
      get: function get() {
        return this._saveError;
      }
    }, {
      key: "lastSavedDate",
      get: function get() {
        return this._lastSavedDate;
      }
    }, {
      key: "dateFormats",
      get: function get() {
        return this._RegionalSettings.DEFAULT_DATE_FORMATS.concat([null]);
      }
    }, {
      key: "timeFormats",
      get: function get() {
        return this._RegionalSettings.DEFAULT_TIME_FORMATS.concat([null]);
      }
    }, {
      key: "firstDayOfWeekFormats",
      get: function get() {
        return this._RegionalSettings.DEFAULT_FIRST_DAY_OF_WEEK_FORMATS.concat([-1]);
      }
    }]);

    return ProfileController;
  }();

  ProfileController.$inject = ['$filter', 'UsersService', 'UserProfile', 'RegionalSettings', 'Authenticator', 'ConfirmLeaveService'];
  angular.module('xlrelease').controller('ProfileController', ProfileController);
})();
// CONCATENATED MODULE: ./core/xlr-ui/app/js/profile/user-profile.ts








var user_profile_UserProfile;

var user_profile_UserProfileImpl = /*#__PURE__*/function () {
  function UserProfileImpl($state, ClientSettings) {
    classCallCheck_default()(this, UserProfileImpl);

    defineProperty_default()(this, "$state", void 0);

    defineProperty_default()(this, "ClientSettings", void 0);

    defineProperty_default()(this, "userProfile", undefined);

    this.$state = $state;
    this.ClientSettings = ClientSettings;
  }

  createClass_default()(UserProfileImpl, [{
    key: "applyProfile",
    value: function applyProfile(resp) {
      this.userProfile = resp.data;
      regional_settings_RegionalSettings.update(this.userProfile);
      return this.userProfile;
    }
  }, {
    key: "isProfileOutdated",
    value: function isProfileOutdated(authenticationData, userProfile) {
      var path = 'username.toLowerCase';
      return authenticationData && lodash_default.a.invoke(authenticationData, path) !== lodash_default.a.invoke(userProfile, path);
    }
  }, {
    key: "load",
    value: function load() {
      var _this = this;

      return backend["a" /* Backend */].get('profile').then(function (response) {
        return _this.applyProfile(response);
      }).then(function () {
        var authenticationData = _this.ClientSettings.getAuthenticationData();

        if (_this.isProfileOutdated(authenticationData, _this.userProfile)) {
          // Cannot load profile because of outdated authenticationData, reload it
          _this.$state.go('login', {
            reloadUserDetails: true
          });
        } else {
          return _this.userProfile;
        }
      });
    }
  }, {
    key: "save",
    value: function save(profile) {
      var _this2 = this;

      return backend["a" /* Backend */].put('profile', profile, {
        hideAlert: true
      }).then(function (response) {
        return _this2.applyProfile(response);
      });
    }
  }, {
    key: "getCurrentUser",
    value: function getCurrentUser() {
      return this.userProfile ? {
        username: this.userProfile.username,
        fullName: this.userProfile.fullName
      } : undefined;
    }
  }, {
    key: "clear",
    value: function clear() {
      this.userProfile = null;
    }
  }]);

  return UserProfileImpl;
}();

defineProperty_default()(user_profile_UserProfileImpl, "$inject", ['$state', 'ClientSettings']);

Object(node_modules_angular["module"])('xlrelease').service('UserProfile', user_profile_UserProfileImpl);
Object(node_modules_angular["module"])('xlrelease').run(function () {
  return user_profile_UserProfile = ngimport["$injector"].get('UserProfile');
});
// CONCATENATED MODULE: ./core/xlr-ui/app/features/common/services/type-bound-renderer.service.js


var annotationName = 'TypeBounds';

var type_bound_renderer_service_typeBoundRenderer = function typeBoundRenderer($q, ConfigurationServices, MetadataService) {
  var getCIPropertiesKey = function getCIPropertiesKey(instance, key) {
    if (instance === null) return undefined;

    if (instance.hasOwnProperty('properties') && instance.properties.hasOwnProperty(key)) {
      return 'properties';
    } else if (instance.hasOwnProperty('inputProperties') && instance.inputProperties.hasOwnProperty(key)) {
      return 'inputProperties';
    } else if (instance.hasOwnProperty('outputProperties') && instance.outputProperties.hasOwnProperty(key)) {
      return 'outputProperties';
    }

    return undefined;
  };

  var getCurrentAndNextJsonPathValue = function getCurrentAndNextJsonPathValue(jsonPath) {
    var firstDotIndex = jsonPath.indexOf(".");
    var currentPath = jsonPath.substr(0, firstDotIndex !== -1 ? firstDotIndex : jsonPath.length);
    var nextPath = jsonPath.substr(firstDotIndex !== -1 ? firstDotIndex + 1 : jsonPath.length, jsonPath.length);
    return [currentPath, nextPath];
  };

  var getDefaultValueFromMetadata = function getDefaultValueFromMetadata(type, propertyName, defaultValue) {
    if (angular.isUndefined(type)) return $q.resolve(defaultValue);
    return MetadataService.getDescriptor(type).then(function (descriptor) {
      var propertyDescriptor = descriptor.properties.find(function (property) {
        return property.name === propertyName;
      });

      if (angular.isDefined(propertyDescriptor) && propertyDescriptor.default !== "") {
        return propertyDescriptor.default;
      }

      return defaultValue;
    });
  };

  var getRenderer = function getRenderer(descriptor, instance) {
    return descriptor.properties.filter(function (p) {
      return p.hasOwnProperty('annotations') && annotationName in p.annotations;
    }).flatMap(function (p) {
      var propertyName = p.name;
      var annotation = p.annotations[annotationName];

      var result = defineProperty_default()({}, propertyName, {
        topType: annotation.topType,
        focusType: annotation.focusType,
        canSelectVirtualType: annotation.canBeVirtual
      });

      var getPropsByJsonPath = function getPropsByJsonPath(jsonPathToWatch, configuration, rendererPropertyName) {
        var _getCurrentAndNextJso = getCurrentAndNextJsonPathValue(jsonPathToWatch),
            _getCurrentAndNextJso2 = slicedToArray_default()(_getCurrentAndNextJso, 2),
            currentPropertyName = _getCurrentAndNextJso2[0],
            nextPath = _getCurrentAndNextJso2[1];

        var cIPropertiesKey = getCIPropertiesKey(configuration, currentPropertyName);
        var valueOrConfiguration = angular.isDefined(cIPropertiesKey) ? configuration[cIPropertiesKey][currentPropertyName] : !_.isUndefined(_.get(configuration, currentPropertyName)) ? configuration[currentPropertyName] : undefined;

        if (_.isEmpty(nextPath) || angular.isUndefined(valueOrConfiguration)) {
          if (angular.isUndefined(valueOrConfiguration)) {
            if (configuration === null) {
              result[propertyName][rendererPropertyName] = annotation[rendererPropertyName];
              return $q.resolve(result);
            } // get default value from metadata


            return getDefaultValueFromMetadata(configuration.type, currentPropertyName, annotation[rendererPropertyName]).then(function (value) {
              result[propertyName][rendererPropertyName] = value || annotation[rendererPropertyName];
              return result;
            });
          } // we have nested CI(set the value)


          result[propertyName][rendererPropertyName] = valueOrConfiguration;
          return $q.resolve(result);
        } else {
          if (_.isString(valueOrConfiguration)) {
            // current property is a string and not an object so we need to load them
            return ConfigurationServices.getConfiguration(ConfigurationServices.formatShortIdToLong(valueOrConfiguration)).then(function (response) {
              return getPropsByJsonPath(nextPath, response, rendererPropertyName);
            });
          } else {
            // go deeper
            return getPropsByJsonPath(nextPath, valueOrConfiguration, rendererPropertyName);
          }
        }
      };

      var rendererPropsFn = function rendererPropsFn(jsonPathToWatch, rendererPropertyName) {
        return function () {
          return getPropsByJsonPath(jsonPathToWatch, instance, rendererPropertyName);
        };
      };

      var renderers = {
        defaultProps: result,
        watchers: []
      };

      if (annotation.focusProperty !== null) {
        renderers.watchers.push({
          propToWatch: annotation.focusProperty.split('.')[0],
          loadDependentProps: rendererPropsFn(annotation.focusProperty, 'focusType')
        });
      }

      if (annotation.topProperty !== null) {
        renderers.watchers.push({
          propToWatch: annotation.topProperty.split('.')[0],
          loadDependentProps: rendererPropsFn(annotation.topProperty, 'topType')
        });
      }

      return renderers;
    });
  };

  return {
    getRenderer: getRenderer,
    getDefaultValueFromMetadata: getDefaultValueFromMetadata
  };
};

type_bound_renderer_service_typeBoundRenderer.$inject = ['$q', 'ConfigurationService', 'MetadataService'];
angular.module('xlrelease').service('TypeBoundRenderer', type_bound_renderer_service_typeBoundRenderer);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/editor/release-editor-collapse-service.js
var release_editor_collapse_service = __webpack_require__(910);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/editor/release-editor-controller.js
var release_editor_controller = __webpack_require__(911);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/editor/release-editor-task-filter-service.js
var release_editor_task_filter_service = __webpack_require__(912);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/releases/editor/restart-phases-controller.js




var restart_phases_controller_RestartPhasesController = /*#__PURE__*/function () {
  function RestartPhasesController($scope, Authenticator, Backend, ClientSettings, PhasesService, TasksService, VariablesInterpolator) {
    classCallCheck_default()(this, RestartPhasesController);

    this._$scope = $scope;
    this._authenticator = Authenticator;
    this._backend = Backend;
    this._clientSettings = ClientSettings;
    this._phasesService = PhasesService;
    this._tasksService = TasksService;
    this._variablesInterpolator = VariablesInterpolator;
    this.dismiss = this._$scope.dismiss;
    this.resumeRelease = this._$scope.resumeRelease;
    this.restartPhaseTypes = [{
      label: 'Original',
      type: 'ORIGINAL'
    }, {
      label: 'Latest',
      type: 'LATEST'
    }];
  }

  createClass_default()(RestartPhasesController, [{
    key: "$onInit",
    value: function $onInit() {
      this.releaseRestored = false;
      this.phaseRestartInProgress = false;
      this.phaseType = this._getInitialPhaseType();
      this.phases2restart = this._getPhases2Restart(this.phaseType.type);
      this.fromPhase = this.phases2restart && this.phases2restart[0];
      this.fromTask = this._getFirstTask(this.fromPhase);
      this.tasks2restart = this._getTasks2Restart(this.fromPhase);
    }
  }, {
    key: "onTypeChange",
    value: function onTypeChange() {
      this.phases2restart = this._getPhases2Restart(this.phaseType.type);
      var fromPhase = this.phases2restart && this.phases2restart[0];

      if (fromPhase.id !== this.fromPhase.id) {
        this.fromPhase = fromPhase;
        this.tasks2restart = this._getTasks2Restart(this.fromPhase);
        this.fromTask = this._getFirstTask(this.fromPhase);
      }
    }
  }, {
    key: "onPhaseChange",
    value: function onPhaseChange() {
      this.tasks2restart = this._getTasks2Restart(this.fromPhase);
      this.fromTask = this._getFirstTask(this.fromPhase);
    }
  }, {
    key: "restartPhasesFrom",
    value: function restartPhasesFrom(phaseType) {
      var _this = this;

      if (phaseType) {
        this._clientSettings.setRestartPhaseVersion(phaseType.type);
      }

      this.phaseRestartInProgress = true;
      this.numberOfPhaseRestarted = this.phases2restart.length - _.indexOf(this.phases2restart, this.fromPhase);

      this._backend.post("releases/".concat(this._$scope.release.id, "/restartPhases"), undefined, {
        params: {
          fromPhaseId: this.fromPhase.id,
          fromTaskId: this.fromTask ? this.fromTask.id : undefined,
          phaseVersion: phaseType ? phaseType.type : ''
        }
      }).then(function () {
        _this.phaseRestartInProgress = false;

        _this._$scope.loadRelease();

        _this.releaseRestored = true;
      }, function () {
        _this.phaseRestartInProgress = false;
        _this.releaseRestored = false;

        _this._$scope.dismiss();
      });
    }
  }, {
    key: "interpolate",
    value: function interpolate(title) {
      return this._variablesInterpolator.interpolateInText(this._$scope.release.variables, title);
    }
  }, {
    key: "canSelectTasks",
    value: function canSelectTasks() {
      var _this2 = this;

      if (!this.fromPhase || !this.fromPhase.tasks) {
        return false;
      }

      if (this._getTasks2Restart(this.fromPhase).length <= 1) {
        return false;
      }

      var tasks = this.fromPhase.tasks;

      var currentTaskIndex = _.findIndex(tasks, {
        id: this._$scope.release.currentTask.id
      });

      var tasksToSkips = tasks.slice(0, currentTaskIndex);
      return _.every(tasksToSkips, function (task) {
        return _this2._authenticator.hasPermissionToWorkOnTask(_this2._$scope.release, task);
      });
    }
  }, {
    key: "_getInitialPhaseType",
    value: function _getInitialPhaseType() {
      var phaseTypeId = this._clientSettings.getRestartPhaseVersion();

      if (!phaseTypeId) {
        return this.restartPhaseTypes[1];
      }

      var phaseType = this.restartPhaseTypes.find(function (type) {
        return type.type.toUpperCase() === phaseTypeId.toUpperCase();
      });
      return phaseType || this.restartPhaseTypes[1];
    }
  }, {
    key: "_getPhases2Restart",
    value: function _getPhases2Restart(phaseType) {
      var phases = this._$scope.release.phases;

      if (phaseType === 'ORIGINAL') {
        return _.reject(phases, this._phasesService.isPlannedOrNotOriginal); // notice, this is rejecting, not filtering!
      }

      return _.reject(phases, this._phasesService.isPlannedOrNotMostRecentCopy); // notice, this is rejecting, not filtering!
    }
  }, {
    key: "_getTasks2Restart",
    value: function _getTasks2Restart(fromPhase) {
      var _this3 = this;

      if (!fromPhase || !fromPhase.tasks.length) {
        return [];
      }

      return fromPhase.tasks.filter(function (task) {
        return _this3._tasksService.isActive(task) || _this3._tasksService.isDone(task);
      });
    }
  }, {
    key: "_getFirstTask",
    value: function _getFirstTask(fromPhase) {
      return fromPhase && fromPhase.tasks.length ? fromPhase.tasks[0] : null;
    }
  }]);

  return RestartPhasesController;
}();

defineProperty_default()(restart_phases_controller_RestartPhasesController, "$inject", ['$scope', 'Authenticator', 'Backend', 'ClientSettings', 'PhasesService', 'TasksService', 'VariablesInterpolator']);

angular.module('xlrelease').controller('restartPhasesController', restart_phases_controller_RestartPhasesController);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/editor/sortable-directive.js
var sortable_directive = __webpack_require__(913);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/editor/worksheet-scrolling-directive.js
var worksheet_scrolling_directive = __webpack_require__(914);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/editor/worksheet-service.js
var worksheet_service = __webpack_require__(915);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/gantt/gantt.js
var gantt_gantt = __webpack_require__(916);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/gantt/gantt-controller.js
var gantt_controller = __webpack_require__(917);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/gantt/gantt-directive.js
var gantt_directive = __webpack_require__(918);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/gantt/gantt-elements-editor.js
var gantt_elements_editor = __webpack_require__(919);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/gantt/gantt-wrapper.js
var gantt_wrapper = __webpack_require__(920);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/gantt/gantt-zoom.js
var gantt_zoom = __webpack_require__(921);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/releases/gantt/planner-service.js

angular.module('xlrelease').factory('Planner', ['TasksService', 'TopologicalSort', 'VariablesInterpolator', 'PhaseColors', 'GanttCssClasses', 'PhasesService', 'ClientSettings', 'ReleasesService', 'taskTypeCssClassFilter', 'DateService', 'Ids', function (TasksService, TopologicalSort, VariablesInterpolator, PhaseColors, GanttCssClasses, PhasesService, ClientSettings, ReleasesService, taskTypeCssClassFilter, DateService, Ids) {
  var MANUAL_TASK_DURATION = 60;
  var AUTOMATED_TASK_DURATION = 1;

  var PHASE_COLORS = _.keyBy(PhaseColors, 'value');

  var DEFAULT_PHASE_COLOR = PhaseColors[0].name;
  var FROM_END_TO_START = '0';
  var RELEASE_TYPE = "xlrelease.Release";
  var release, releaseTree;

  function makeLinkId(sourceId, targetId) {
    return sourceId + '|' + targetId;
  }

  function hasPlannedDuration(planItem) {
    return planItem.plannedDuration !== null && angular.isDefined(planItem.plannedDuration);
  }

  function flattenPlan(plan) {
    var elements = [plan];

    _.forEach(plan.children, function (child) {
      elements = elements.concat(flattenPlan(child));
    });

    return elements;
  }

  var getCollapseState = function getCollapseState(item) {
    var states = ClientSettings.getGanttElementsCollapseState();
    var isOpenByDefault = ReleasesService.isRelease(item) || TasksService.isTask(item) && !TasksService.isTaskGroup(item);
    return states === null || angular.isUndefined(states[item.id]) ? isOpenByDefault : states[item.id];
  };

  return {
    makePlan: function makePlan(showAdditionalProperties) {
      if (_.isUndefined(showAdditionalProperties)) {
        showAdditionalProperties = true;
      }

      var releaseTreeById = flattenReleaseTree(releaseTree, release);
      var now = DateService.getTodayWithTime();
      var processingStack = [];
      var plannedReleaseIds = new Set();
      var plan = makePlan(release, now, now, null, showAdditionalProperties);
      var elements = flattenPlan(plan);
      return {
        plan: plan,
        elements: elements,
        plannedEndDate: findMaxDisplayEndDate(elements)
      };

      function makePlan(item, proposedStartDate, now, parent, enrichPlan) {
        var plan = {
          id: item.id,
          type: item.type,
          displayStartDate: computeStartDate(item, proposedStartDate),
          displayDueDate: computeDueDate(item),
          children: [],
          locked: item.locked
        };

        if (_.includes(processingStack, item.id)) {
          plan.displayEndDate = plan.displayStartDate;
          plan.displayDuration = 0;
          cacheDisplayDates(plan, releaseTreeById);
          return plan;
        }

        processingStack.push(item.id);

        if (TasksService.isParallelGroup(item)) {
          plan.children = makeSubTaskPlans(item, plan.displayStartDate, now, item, enrichPlan);
          var proposedDate = findMaxDisplayEndDate(plan.children) || plan.displayStartDate;
          plan.displayEndDate = computeEndDate(item, proposedDate, plan.displayStartDate);
        } else if (TasksService.isGateTask(item)) {
          plan.displayEndDate = computeEndDate(item, computeDependenciesEndDate(plan, item), plan.displayStartDate, now);
        } else {
          var currentDate = plan.displayStartDate;

          _.forEach(getChildren(item), function (child) {
            var childPlan = makePlan(child, currentDate, now, item, enrichPlan);
            plan.children.push(childPlan);

            if (!TasksService.isTaskDoneInAdvance(child)) {
              currentDate = childPlan.displayEndDate;
            }
          });

          plan.displayEndDate = computeEndDate(item, currentDate, plan.displayStartDate, now);
        }

        plan.displayDuration = plan.displayEndDate.diff(plan.displayStartDate, 'milliseconds');

        if (enrichPlan) {
          addAdditionalProperties(plan, item, parent);
        }

        cacheDisplayDates(plan, releaseTreeById);
        processingStack.pop();
        return plan;
      }

      function addAdditionalProperties(plan, item, parent) {
        plan.hasBeenStarted = item.hasBeenStarted;
        plan.text = getItemText(plan, item);
        plan.plainText = VariablesInterpolator.interpolateInText(release.variables, item.title);
        plan.childrenIds = toIds(plan.children);
        plan.cssClass = GanttCssClasses.DEFAULT + ' ' + getCssClass(item);
        plan.isUpdatable = item.updatable;
        plan.open = getCollapseState(item);
        plan.start_date = plan.displayStartDate.toDate();
        plan.end_date = plan.displayEndDate.toDate();
        plan.parent = getParentId(parent);
        plan.planItem = item;
        plan.hasOwnStartDate = hasOwnStartDate(item);
        plan.hasOwnEndDate = hasOwnEndDate(item);
        plan.status = item.status;
      }

      function getItemText(plan, item) {
        if (plan && plan.type !== RELEASE_TYPE) {
          var titleEligibleVariables = _.pickBy(_.get(release, 'variables'), function (v) {
            return _.isString(v) && !!v.trim();
          });

          return VariablesInterpolator.interpolateInHtml(titleEligibleVariables, item.title);
        }

        return VariablesInterpolator.interpolateInHtml(release.variables, item.title);
      }

      function hasOwnStartDate(planItem) {
        return planItem.scheduledStartDate || planItem.startDate;
      }

      function hasOwnEndDate(planItem) {
        return planItem.dueDate || planItem.endDate;
      }

      function getParentId(parentElement) {
        return parentElement ? parentElement.id : undefined;
      }

      function getCssClass(item) {
        if (ReleasesService.isRelease(item)) {
          return GanttCssClasses.RELEASE;
        } else if (PhasesService.isPhase(item)) {
          return getPhaseCssClass(item);
        } else {
          return getTaskCssClass(item);
        }
      }

      function getPhaseCssClass(phase) {
        var cssClass = GanttCssClasses.PHASE;

        if (phase.color && PHASE_COLORS[phase.color]) {
          cssClass += ' ' + GanttCssClasses.PHASE_PREFIX + PHASE_COLORS[phase.color].name;
        } else {
          cssClass += ' ' + GanttCssClasses.PHASE_PREFIX + DEFAULT_PHASE_COLOR;
        }

        return cssClass;
      }

      function getTaskCssClass(task) {
        var cssClasses = GanttCssClasses.TASK + ' ' + taskTypeCssClassFilter(task.type);

        if (task.status) {
          cssClasses += ' ' + GanttCssClasses.TASK_STATUS_PREFIX + task.status.toLowerCase();
        }

        return cssClasses;
      }

      function toIds(planItems) {
        return _.map(planItems, 'id');
      }

      function makeSubTaskPlans(item, currentDate, now, parent, enrichPlan) {
        var tasks = getChildren(item);
        var taskIds = toIds(tasks);
        var orderedTaskIds = TopologicalSort.sort({
          adjacencyList: item.links,
          vertices: taskIds
        });
        var orderedTasks = mapIdsToObjects(orderedTaskIds, tasks);
        var orderedPlans = [];
        orderedTasks.forEach(function (task) {
          var predecessors = mapIdsToObjects(findPredecessorsIds(item.links, task.id), orderedPlans);
          var startDate = predecessors.length ? findMaxDisplayEndDate(predecessors) : currentDate;
          var childPlan = makePlan(task, startDate, now, parent, enrichPlan);
          orderedPlans.push(childPlan);
        });
        return mapIdsToObjects(taskIds, orderedPlans);
      }
      /* eslint-disable lodash/chain-style */


      function findPredecessorsIds(links, taskId) {
        var directPredecessorsIds = _.chain(links).filter({
          targetId: taskId
        }).map('sourceId').value();

        var predecessorsIds = [];

        _.forEach(directPredecessorsIds, function (predecessorId) {
          predecessorsIds = predecessorsIds.concat(findPredecessorsIds(links, predecessorId));
        });

        return _.uniq(predecessorsIds.concat(directPredecessorsIds));
      }
      /* eslint-enable lodash/chain-style */


      function getChildren(item) {
        return item.phases || item.tasks || item.children;
      }

      function computeStartDate(item, proposedDate) {
        if (item.startDate) {
          return moment(item.startDate).startOf('minute');
        }

        if (item.scheduledStartDate) {
          return moment(item.scheduledStartDate).startOf('minute');
        }

        if (item.dueDate && hasPlannedDuration(item)) {
          return moment(item.dueDate).subtract(item.plannedDuration, 'milliseconds').startOf('minute');
        }

        return moment(proposedDate).startOf('minute');
      }

      function computeEndDate(item, proposedDate, displayStartDate, now) {
        var endDate;

        if (item.endDate) {
          endDate = moment(item.endDate);
        } else if (item.dueDate) {
          endDate = moment(item.dueDate);
        } else if (hasPlannedDuration(item)) {
          endDate = moment(displayStartDate).add(item.plannedDuration, 'milliseconds');
        } else if (isAutomatedTask(item)) {
          endDate = moment(proposedDate).add(AUTOMATED_TASK_DURATION, 'minutes');
        } else if (isManualTask(item) && !isDependentTask(item)) {
          endDate = moment(proposedDate).add(MANUAL_TASK_DURATION, 'minutes');
        } else {
          endDate = moment(proposedDate);
        }

        if (endDate.isBefore(displayStartDate)) {
          endDate = moment(displayStartDate);
        }

        if (isActiveLeafTask(item) && endDate.isBefore(now)) {
          endDate = moment(now);
        }

        return endDate.startOf('minute');
      }

      function computeDueDate(item) {
        if (!item.dueDate && !!item.startDate && !!item.plannedDuration) {
          return moment(item.startDate).add(item.plannedDuration, 'milliseconds').valueOf();
        } else {
          return item.dueDate;
        }
      }

      function cacheDisplayDates(plan, releaseTreeById) {
        if (_.has(releaseTreeById, plan.id)) {
          var cachedItem = releaseTreeById[plan.id];
          cachedItem.startDate = plan.displayStartDate;
          cachedItem.endDate = plan.displayEndDate;
        }
      }

      function computeDependenciesEndDate(plan, item) {
        var proposedEndDate = plan.displayStartDate;

        if (!hasOwnEndDate(item) && !hasPlannedDuration(item) && item.dependencies) {
          item.dependencies.filter(isDependencyUnresolved).forEach(function (dependency) {
            var calculatedEndDate = computeDependencyEndDate(dependency);

            if (calculatedEndDate && calculatedEndDate.isAfter(proposedEndDate)) {
              proposedEndDate = calculatedEndDate;
            }
          });
        }

        return proposedEndDate;
      }

      function isDependencyUnresolved(dependency) {
        return !dependency.resolved && !dependency.archived && _.has(dependency, ['variableOrTarget', 'value', 'id']);
      }

      function computeDependencyEndDate(dependency) {
        var dependencyNode = dependency.variableOrTarget.value;
        var calculatedEndDate = null;

        if (hasOwnEndDate(dependencyNode)) {
          calculatedEndDate = moment(dependencyNode.endDate || dependencyNode.dueDate);
        } else {
          var target = _.get(releaseTreeById, dependencyNode.id);

          var targetRelease = _.get(releaseTreeById, dependencyNode.id && Ids.releaseIdFrom(dependencyNode.id));

          if (targetRelease && target) {
            if (!plannedReleaseIds.has(targetRelease.id)) {
              makePlan(targetRelease, now, now);
              plannedReleaseIds.add(targetRelease.id);
            }

            calculatedEndDate = moment(target.endDate);
          }
        }

        return calculatedEndDate;
      }

      function isAutomatedTask(item) {
        return TasksService.isTask(item) && TasksService.isAutomated(item);
      }

      function isManualTask(item) {
        return !TasksService.isTaskGroup(item) && TasksService.isTask(item) && !TasksService.isAutomated(item);
      }

      function isDependentTask(item) {
        return TasksService.isGateTask(item) && !_.isEmpty(item.dependencies);
      }

      function isActiveLeafTask(item) {
        return item.active && TasksService.isTask(item) && !TasksService.isTaskGroup(item);
      }

      function findMaxDisplayEndDate(items) {
        return findMaxDate(items, 'displayEndDate');
      }

      function findMaxDate(items, dateProperty) {
        if (!items || _.isEmpty(items)) {
          return null;
        }

        return _.maxBy(items, function (child) {
          var date = child[dateProperty] || 0;
          return _.isNumber(date) ? date : date.valueOf();
        })[dateProperty];
      }

      function mapIdsToObjects(ids, objects) {
        return _.map(ids, function (id) {
          return _.find(objects, {
            id: id
          });
        });
      }

      function flattenReleaseTree(releaseTree, release) {
        if (_.isEmpty(releaseTree)) {
          return {};
        }

        return _([release].concat(toConsumableArray_default()(Object.values(releaseTree.dependentReleases)))).map(function (releaseTreeItem) {
          return flattenPlan(angular.copy(releaseTreeItem));
        }).flatten().groupBy('id').mapValues(function (items) {
          return _.head(items);
        }).value();
      }
    },
    getLinks: function getLinks() {
      var links = [];
      addLinksBetweenPhases();
      addLinksBetweenTasks();
      addLinksWithinTaskGroups();
      return links;

      function addLinksBetweenPhases() {
        for (var i = 0; i < release.phases.length - 1; i++) {
          addLink(release.phases[i].id, release.phases[i + 1].id, true);
        }
      }

      function addLinksBetweenTasks() {
        _.forEach(release.phases, function (phase) {
          for (var i = 0; i < phase.tasks.length - 1; i++) {
            addLink(phase.tasks[i].id, phase.tasks[i + 1].id, true);
          }
        });
      }

      function addLinksWithinTaskGroups() {
        _.forEach(release.phases, function (phase) {
          _.forEach(phase.tasks, addLinkWithinTaskGroup);
        });
      }

      function addLinkWithinTaskGroup(task) {
        if (TasksService.isTaskGroup(task)) {
          if (TasksService.isParallelGroup(task)) {
            _.forEach(task.links, function (link) {
              var readonly = !!task.hasBeenStarted || task.locked;
              addLink(link.sourceId, link.targetId, readonly, link.id);
            });
          } else {
            for (var i = 0; i < task.tasks.length - 1; i++) {
              addLink(task.tasks[i].id, task.tasks[i + 1].id, true);
            }
          }

          _.forEach(task.tasks, addLinkWithinTaskGroup);
        }
      }

      function addLink(sourceId, targetId, readOnly, linkId) {
        links.push({
          id: makeLinkId(sourceId, targetId),
          source: sourceId,
          target: targetId,
          type: FROM_END_TO_START,
          readOnly: readOnly,
          linkId: linkId
        });
      }
    },
    makeLinkId: makeLinkId,
    setRelease: function setRelease(newRelease) {
      release = newRelease;

      if (!_.isEmpty(releaseTree) && releaseTree.releaseId !== release.id) {
        releaseTree = null;
      }
    },
    setReleaseTree: function setReleaseTree(newReleaseTree) {
      releaseTree = newReleaseTree;
    }
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/gantt/planning-data-editor.js
var planning_data_editor = __webpack_require__(922);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/gantt/planning-data-editor-mixin.js
var planning_data_editor_mixin = __webpack_require__(923);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/releases/grid/release-grid-controller.js



var release_grid_controller_ReleaseGridController = /*#__PURE__*/function () {
  function ReleaseGridController($scope, $location, releasePromise, Page, ViewStorage, ReleasesService, Events) {
    classCallCheck_default()(this, ReleaseGridController);

    this.ReleasesService = ReleasesService;
    this.Events = Events;
    this.$scope = $scope;
    this.release = $scope.release = releasePromise.data;
    ViewStorage.setView(this.release.id, $location.path());
    Page.setReleaseOpened(this.release);

    this._createScopeBindings();
  }

  createClass_default()(ReleaseGridController, [{
    key: "_createScopeBindings",
    value: function _createScopeBindings() {
      var _this = this;

      this.$scope.startRelease = function (release) {
        return _this.ReleasesService.startRelease(release).then(function () {
          return _this.refreshGrid();
        });
      };

      this.$scope.abortRelease = function (release, abortComment) {
        return _this.ReleasesService.abortRelease(release, abortComment).then(function () {
          return _this.refreshGrid();
        });
      };
    } // view model

  }, {
    key: "canAbortRelease",
    value: function canAbortRelease(release) {
      return !this.ReleasesService.isTemplate(release) && this.$scope.security.hasPermission('release#abort', release) && !this.ReleasesService.isReleaseCompleted(release) && !this.ReleasesService.hasAutomatedTaskInProgress(release);
    }
  }, {
    key: "canStartRelease",
    value: function canStartRelease(release) {
      return this.ReleasesService.isReleasePlanned(release) && this.$scope.security.hasPermission('release#start', release);
    }
  }, {
    key: "canRefreshGrid",
    value: function canRefreshGrid(release) {
      return !this.ReleasesService.isTemplate(release) && !this.ReleasesService.isReleaseCompleted(release);
    }
  }, {
    key: "refreshGrid",
    value: function refreshGrid() {
      var _this2 = this;

      this.ReleasesService.getRelease(this.release.id).then(function (resp) {
        var updatedRelease = resp.data;
        _this2.release = _this2.$scope.release = updatedRelease;

        _this2.$scope.$broadcast(_this2.Events.grid.refresh, {
          release: updatedRelease
        });
      });
    }
  }]);

  return ReleaseGridController;
}();

release_grid_controller_ReleaseGridController.$inject = ['$scope', '$location', 'releasePromise', 'Page', 'ViewStorage', 'ReleasesService', 'Events'];
angular.module('xlrelease').controller('releaseGridController', release_grid_controller_ReleaseGridController);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/releases/grid/release-grid-edit-controller.js





(function () {
  var ReleaseGridEditController = /*#__PURE__*/function () {
    function ReleaseGridEditController($scope, TasksService, Authenticator, Events, TaskDetailsUpdates, PhaseDetailsUpdates, PhasesService, ReleasesService) {
      classCallCheck_default()(this, ReleaseGridEditController);

      this._scope = $scope;
      this._events = Events;
      this._taskDetailsUpdates = TaskDetailsUpdates;
      this._phaseDetailsUpdates = PhaseDetailsUpdates;
      this._phasesService = PhasesService;
      this._releasesService = ReleasesService;
      this.bindEvents(Events);
      this.bindContext(TasksService, Authenticator);
    }

    createClass_default()(ReleaseGridEditController, [{
      key: "bindEvents",
      value: function bindEvents(events) {
        this._scope.$on(events.grid.edit, this.editItem.bind(this));
      }
    }, {
      key: "bindContext",
      value: function bindContext(tasksService, authenticator) {
        var _this = this;

        var reloadRelease = function reloadRelease() {
          return _this.loadRelease(true);
        };

        this._scope.security = authenticator;

        this._scope.deleteTask = function (container, taskToDelete) {
          return tasksService.deleteTask(container, taskToDelete);
        };

        this._scope.changeType = function (container, taskToConvert, convertToType) {
          return tasksService.changeTaskType(container, taskToConvert, convertToType);
        };

        this._scope.duplicateTask = function (release, container, task) {
          return tasksService.duplicateTask(release, task, container);
        };

        this._scope.completeTask = function (task, commentText) {
          return tasksService.completeTask(task.id, commentText).then(reloadRelease);
        };

        this._scope.skipTask = function (task, commentText) {
          return tasksService.skipTask(task.id, commentText).then(reloadRelease);
        };

        this._scope.failTask = function (task, commentText) {
          return tasksService.failTask(task.id, commentText).then(reloadRelease);
        };

        this._scope.abortTask = function (task, commentText) {
          return tasksService.abortTask(task.id, commentText).then(reloadRelease);
        };

        this._scope.retryTask = function (task, commentText) {
          return tasksService.retryTask(task.id, commentText).then(reloadRelease);
        };

        this._scope.cancelTask = function (task, commentText) {
          return tasksService.cancelTask(task.id, commentText).then(reloadRelease);
        };

        this._scope.startNow = function (task, commentText) {
          return tasksService.startNow(task.id, commentText).then(reloadRelease);
        };

        this._scope.startTaskWithInput = function (task, variables) {
          return tasksService.startTaskWithInput(task.id, variables).then(reloadRelease);
        };

        this._scope.reopenTask = function (task, commentText) {
          return tasksService.reopenTask(task.id, commentText).then(reloadRelease);
        };
      } //

    }, {
      key: "endEditTask",
      value: function endEditTask(task) {
        this.editTask = false;

        if (this._taskDetailsUpdates.planningDataChanged || this._taskDetailsUpdates.assigneeChanged || this.previousTitle !== task.title) {
          this.loadRelease();

          this._taskDetailsUpdates.reset();
        }
      }
    }, {
      key: "endEditPhase",
      value: function endEditPhase(phase) {
        this.editPhase = false;

        if (this._phaseDetailsUpdates.planningDataChanged || this.previousTitle !== phase.title) {
          this.loadRelease();

          this._phaseDetailsUpdates.reset();
        }
      }
    }, {
      key: "loadRelease",
      value: function loadRelease() {
        var reload = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

        this._scope.$emit(this._events.grid.refresh, {
          reload: reload
        });
      }
    }, {
      key: "editItem",
      value: function editItem(event, args) {
        if (!args.planItem) {
          return;
        }

        this._scope.release = args.release;
        this.previousTitle = args.planItem.title;

        if (this._phasesService.isPhase(args.planItem)) {
          this._scope.phase = args.planItem;
          this.editPhase = true;
        } else if (!this._releasesService.isRelease(args.planItem) && !this._releasesService.isTemplate(args.planItem)) {
          this._scope.task = args.planItem;
          this.editTask = true;
        }
      }
    }]);

    return ReleaseGridEditController;
  }();

  ReleaseGridEditController.$inject = ['$scope', 'TasksService', 'Authenticator', 'Events', 'TaskDetailsUpdates', 'PhaseDetailsUpdates', 'PhasesService', 'ReleasesService'];
  angular.module('xlrelease').controller('releaseGridEditController', ReleaseGridEditController);
})();
// CONCATENATED MODULE: ./core/xlr-ui/app/js/releases/grid/release-grid-service.js





(function () {
  var GridItem = /*#__PURE__*/function () {
    function GridItem(planItem, treeLevel, container) {
      classCallCheck_default()(this, GridItem);

      this.container = container;
      this.planItem = planItem;
      this.id = planItem.id;
      this.$$treeLevel = treeLevel;
      this.status = planItem.status;
      this.title = planItem.title;
      this.type = planItem.type;
      this.typeDisplayName = GridItem.getTypeDisplayName(planItem);
      this.assignedTo = GridItem.getAssignedTo(planItem);
      this.duration = this.startDate = this.endDate = this.dueDate = null;
      this.editable = planItem.editable;
      this.tags = planItem.tags;
    }

    createClass_default()(GridItem, null, [{
      key: "getAssignedTo",
      value: function getAssignedTo(planItem) {
        if (planItem.owner) {
          return planItem.owner.fullName || planItem.owner.username;
        } else if (planItem.team) {
          return planItem.team;
        }

        return null;
      }
    }, {
      key: "getTypeDisplayName",
      value: function getTypeDisplayName(planItem) {
        if (planItem.type === 'xlrelease.Release' || planItem.type === 'xlrelease.ScmConnectedTemplate') {
          return 'Release';
        } else if (planItem.type === 'xlrelease.Phase') {
          return 'Phase';
        } else if (planItem.typeDisplayGroup === 'Core') {
          return planItem.typeDisplayName;
        }

        return planItem.typeDisplayGroup + ': ' + planItem.typeDisplayName;
      }
    }]);

    return GridItem;
  }();

  var ReleaseGridService = /*#__PURE__*/function () {
    function ReleaseGridService(planner, variablesInterpolator) {
      classCallCheck_default()(this, ReleaseGridService);

      this.planner = planner;
      this.variablesInterpolator = variablesInterpolator;
    }

    createClass_default()(ReleaseGridService, [{
      key: "getGridItems",
      value: function getGridItems(release, releaseTree) {
        var gridItems = this._toGridItems(0, release);

        this._calculateDates(release, releaseTree, gridItems);

        this._interpolateVariables(release, gridItems);

        return gridItems;
      }
    }, {
      key: "_toGridItems",
      value: function _toGridItems(level, planItem, container) {
        var _this = this;

        var children = planItem.phases ? planItem.phases : planItem.tasks ? planItem.tasks : [];
        return _.flatten([new GridItem(planItem, level, container)].concat(_.map(children, function (child) {
          return _this._toGridItems(level + 1, child, planItem);
        })));
      }
    }, {
      key: "_interpolateVariables",
      value: function _interpolateVariables(release, gridItems) {
        var _this2 = this;

        gridItems.forEach(function (item) {
          if (_.isString(item.assignedTo)) {
            item.assignedTo = _this2.variablesInterpolator.interpolateInText(release.variables, item.assignedTo);
          }
        });
      }
    }, {
      key: "_calculateDates",
      value: function _calculateDates(release, releaseTree, gridItems) {
        this.planner.setRelease(release);
        this.planner.setReleaseTree(releaseTree);
        var plan = this.planner.makePlan(false);
        gridItems.forEach(function (item) {
          var itemPlan = _.find(plan.elements, {
            'id': item.id
          });

          if (!_.isUndefined(itemPlan)) {
            item.startDate = itemPlan.displayStartDate.toDate();
            item.endDate = itemPlan.displayEndDate.toDate();
            item.dueDate = itemPlan.displayDueDate;
            item.duration = itemPlan.displayDuration;
          }
        });
      }
    }]);

    return ReleaseGridService;
  }();

  ReleaseGridService.$inject = ['Planner', 'VariablesInterpolator'];
  angular.module('xlrelease').service('ReleaseGridService', ReleaseGridService);
})();
// EXTERNAL MODULE: ./core/xlr-ui/app/features/common/services/risk-detector.js
var risk_detector = __webpack_require__(105);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/releases/list/releases-service.js



angular.module('xlrelease').factory('ReleasesService', ['Backend', 'ReleasesStatusService', 'DependenciesService', 'TasksService', 'PhasesService', 'DateService', '$q', 'Download', '$location', 'UserProfile', 'FlagService', 'VariablesService', 'CiLoaderSettings', 'Ids', function (Backend, ReleasesStatusService, DependenciesService, TasksService, PhasesService, DateService, $q, Download, $location, UserProfile, FlagService, VariablesService, CiLoaderSettings, Ids) {
  var DEFAULT_START_HOUR = 9;
  var DEFAULT_DUE_HOUR = 17;

  function mapSelectedReleasesToDomainId(selectedReleases) {
    return Array.from(selectedReleases).map(function (item) {
      return Ids.toDomainId(item);
    });
  }

  function getLeafTasks(release) {
    return _.flattenDeep(_.map(release.phases, PhasesService.getLeafTasks));
  }

  function getAllTasks(release) {
    return _.flattenDeep(_.map(release.phases, function (phase) {
      return _.map(phase.tasks, TasksService.getAllSubTasks);
    }));
  }

  function downloadRelease(release, format) {
    Download.get('export/' + format + '/' + release.id);
  }

  function downloadReleaseReport(release, reportType) {
    Download.get("api/v1/reports/download/".concat(reportType, "/").concat(release.id));
  }

  function hasAutomatedTaskInProgress(release) {
    return _.some(release.currentSimpleTasks, function (task) {
      return TasksService.isTaskInProgress(task) && TasksService.isAutomated(task);
    });
  }

  function computeGroupedReleases(releases, filters) {
    var releasesByMonth = _.groupBy(releases, function (release) {
      var dateFormatter = 'MMMM YYYY';

      if (filters.completed) {
        return moment(release.endDate).format(dateFormatter);
      } else {
        return formatReleaseStartDate(release, dateFormatter);
      }
    });

    return _.map(_.keys(releasesByMonth), function (month) {
      return {
        month: month,
        releases: releasesByMonth[month]
      };
    });
  }

  function formatReleaseStartDate(release, dateFormatter) {
    if (release.startDate) {
      return moment(release.startDate).format(dateFormatter);
    } else if (release.scheduledStartDate) {
      return moment(release.scheduledStartDate).format(dateFormatter);
    }
  }

  function search(filters, config) {
    return Backend.post('releases/search', filters, config);
  }

  function searchFull(filters, config) {
    return search(filters, _.merge({
      params: {
        depth: CiLoaderSettings.itemsMaxDepth
      }
    }, config));
  }

  var getRelease = function getRelease(releaseId, config) {
    return Backend.get('releases/' + releaseId, config);
  };

  var getTemplateDuration = function getTemplateDuration(templateId) {
    return Backend.get('releases/templates/' + templateId + '/duration');
  };

  return {
    getLeafTasks: getLeafTasks,
    getAllTasks: getAllTasks,
    isReleaseCompleted: ReleasesStatusService.isReleaseCompleted,
    hasCompletedStatus: ReleasesStatusService.hasCompletedStatus,
    isReleaseAborted: ReleasesStatusService.isReleaseAborted,
    isReleasePlanned: ReleasesStatusService.isReleasePlanned,
    isReleaseInProgress: ReleasesStatusService.isReleaseInProgress,
    isReleaseFailed: ReleasesStatusService.isReleaseFailed,
    isReleaseFailing: ReleasesStatusService.isReleaseFailing,
    isReleasePaused: ReleasesStatusService.isReleasePaused,
    isReleaseArchived: ReleasesStatusService.isReleaseArchived,
    isReleaseInsideFolder: function isReleaseInsideFolder(release) {
      return release.id.includes('Folder');
    },
    computeGroupedReleases: computeGroupedReleases,
    startRelease: function startRelease(release) {
      return Backend.post('releases/' + release.id + '/start');
    },
    abortRelease: function abortRelease(release, abortComment) {
      return Backend.post('releases/' + release.id + '/abort', {
        abortComment: abortComment
      });
    },
    downloadCalendar: function downloadCalendar(release) {
      downloadRelease(release, 'calendar');
    },
    downloadExcel: function downloadExcel(release) {
      downloadReleaseReport(release, 'xlrelease.ReleaseAuditExcelReport');
    },
    exportZip: function exportZip(release) {
      downloadRelease(release, 'zip');
    },
    exportDsl: function exportDsl(release) {
      Download.launch("api/v1/dsl/export/".concat(Ids.toDomainId(release.id), "?exportTemplate=true"));
    },
    getReleasePermissions: function getReleasePermissions(releaseId) {
      return Backend.get("releases/".concat(releaseId, "/permissions"));
    },
    getReleaseDependencies: function getReleaseDependencies(releaseId, params) {
      return Backend.get('dependencies/' + releaseId, {
        params: params
      });
    },
    getRelease: getRelease,
    getTemplateDuration: getTemplateDuration,
    getTemplateWithDuration: function getTemplateWithDuration(templateId) {
      return getRelease(templateId).then(function (releaseResponse) {
        return getTemplateDuration(templateId).then(function (durationResponse) {
          releaseResponse.data.computed_duration = durationResponse.data;
          return releaseResponse;
        });
      });
    },
    getReleaseWithDependencies: function getReleaseWithDependencies(releaseId, config) {
      return Backend.get("releases/".concat(releaseId), config).then(function (response) {
        var tree = DependenciesService.getReleaseTree(response.data);
        var release = Promise.resolve(response);
        return Promise.all([tree, release]);
      }).then(function (values) {
        var _values = slicedToArray_default()(values, 2),
            tree = _values[0],
            release = _values[1];

        release.tree = tree;
        return release;
      });
    },
    search: search,
    searchFull: searchFull,
    searchArchived: function searchArchived(filters, config) {
      return searchFull(_.merge(filters, {
        onlyArchived: true
      }), config);
    },
    cropToReleaseDate: function cropToReleaseDate(phase, release) {
      var phaseStartDate = DateService.getStartOrScheduledDate(phase);
      var releaseStartDate = DateService.getStartOrScheduledDate(release);
      var phaseEndDate = DateService.getEndOrDueDate(phase);
      var releaseEndDate = DateService.getEndOrDueDate(release);
      return {
        startDate: moment(phaseStartDate).isBefore(moment(releaseStartDate)) ? moment(releaseStartDate) : moment(phaseStartDate),
        endDate: moment(phaseEndDate).isAfter(moment(releaseEndDate)) ? moment(releaseEndDate) : moment(phaseEndDate)
      };
    },
    countPhasesDone: function countPhasesDone(release) {
      return release ? _.filter(release.phases, PhasesService.isPhaseReadOnly).length : undefined;
    },
    hasAttachments: function hasAttachments(release) {
      if (release.attachments && release.attachments.length > 0) {
        return true;
      }

      return _(getAllTasks(release)).map('attachments').flatten().value().length > 0;
    },
    redirectToSummary: function redirectToSummary(release) {
      $location.url('/releases/' + release.id + '/summary');
    },
    redirectToOverview: function redirectToOverview(filters) {
      $location.url('/releases');
      $location.search(filters);
    },
    redirectToEditor: function redirectToEditor(release) {
      $location.url('/releases/' + release.id);
    },
    isRelease: function isRelease(planItem) {
      return planItem.type === 'xlrelease.Release';
    },
    isTemplate: function isTemplate(release) {
      return ReleasesStatusService.isTemplate(release);
    },
    hasAutomatedTaskInProgress: hasAutomatedTaskInProgress,
    isNewRelease: function isNewRelease(release) {
      return !release.id;
    },
    initNewTemplate: function initNewTemplate() {
      return {
        title: '',
        status: 'TEMPLATE',
        tags: [],
        scheduledStartDate: DateService.getToday().hours(DEFAULT_START_HOUR).toDate(),
        dueDate: null,
        plannedDuration: null,
        type: 'xlrelease.Release',
        allowConcurrentReleasesFromTrigger: true
      };
    },
    initNewReleaseFromTemplate: function initNewReleaseFromTemplate(templateId) {
      var _this = this;

      return this.getTemplateWithDuration(templateId).then(function (templateResponse) {
        return VariablesService.getReleaseVariables(templateId).then(function (variablesResponse) {
          var newRelease = _this.initNewRelease();

          var template = templateResponse.data;
          var variables = variablesResponse.data;
          var now = DateService.getTodayWithTime();
          var due = moment(now).add(template.computed_duration / 60, 'minutes');
          newRelease.templateId = template.id;

          _.assign(newRelease, {
            scheduledStartDate: now,
            dueDate: due,
            description: template.description,
            tags: template.tags,
            abortOnFailure: template.abortOnFailure,
            allowPasswordsInAllFields: template.allowPasswordsInAllFields,
            scriptUsername: template.scriptUsername,
            scriptUserPassword: template.scriptUserPassword,
            syntheticProperties: {
              riskProfile: template.syntheticProperties.riskProfile
            },
            variables: variables
          });

          return newRelease;
        });
      });
    },
    initNewRelease: function initNewRelease() {
      return {
        title: '',
        owner: UserProfile.getCurrentUser(),
        scriptUsername: null,
        scriptUserPassword: null,
        scheduledStartDate: DateService.getToday().hours(DEFAULT_START_HOUR).toDate(),
        dueDate: DateService.getToday().hours(DEFAULT_DUE_HOUR).toDate(),
        plannedDuration: null,
        tags: [],
        variables: [],
        type: 'xlrelease.Release',
        flag: {
          status: FlagService.NOT_FLAGGED_STATUS
        },
        syntheticProperties: {}
      };
    },
    getReleaseWithVariables: function getReleaseWithVariables(releaseId) {
      return this.getRelease(releaseId).then(function (releaseResponse) {
        var release = releaseResponse.data;
        return VariablesService.getReleaseVariables(releaseId).then(function (variablesResponse) {
          release.variables = variablesResponse.data;
          return release;
        });
      });
    },
    startReleases: function startReleases(selectedReleases) {
      return Backend.post('releases/start', mapSelectedReleasesToDomainId(selectedReleases));
    },
    abortReleases: function abortReleases(selectedReleases, abortComment) {
      return Backend.post('releases/abort', {
        releasesIds: mapSelectedReleasesToDomainId(selectedReleases),
        abortComment: abortComment
      });
    },
    getRiskStatusIcon: function getRiskStatusIcon(release, riskScore, riskConfig) {
      var _ref;

      var iconSize = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'icon-xl';
      return _ref = {}, defineProperty_default()(_ref, "xl-icon circle-cross-icon ".concat(iconSize), risk_detector["c" /* isAtRisk */](release, riskScore, riskConfig)), defineProperty_default()(_ref, "xl-icon circle-exclamation-icon ".concat(iconSize), risk_detector["d" /* isAttentionNeeded */](release, riskScore, riskConfig)), defineProperty_default()(_ref, "xl-icon circle-check-icon ".concat(iconSize), risk_detector["f" /* isOnTrack */](release, riskScore, riskConfig)), defineProperty_default()(_ref, "xl-icon circle-check-icon completed ".concat(iconSize), this.hasCompletedStatus(release) || this.isReleaseAborted(release)), _ref;
    }
  };
}]);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/releases/permissions/release-permissions-controller.js





function release_permissions_controller_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function release_permissions_controller_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { release_permissions_controller_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { release_permissions_controller_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var release_permissions_controller_ReleasePermissionsController = /*#__PURE__*/function () {
  function ReleasePermissionsController($stateParams, $uibModal, ReleasesService, TeamsService, MemberType, Page, release, teams, users, roles, Ids, permissionTableUtils, FolderPathService, AvailableGroupedReleasePermission, PermissionLabels) {
    var _this = this;

    classCallCheck_default()(this, ReleasePermissionsController);

    this._$stateParams = $stateParams;
    this._$uibModal = $uibModal;
    this._ReleasesService = ReleasesService;
    this._TeamsService = TeamsService;
    this._MemberType = MemberType;
    this._Page = Page;
    this._release = release;
    this._loadedTeams = teams;
    this._users = users;
    this._roles = roles;
    this._Ids = Ids;
    this._permissionTableUtils = permissionTableUtils;
    this._FolderPathService = FolderPathService;
    this._AvailableGroupedReleasePermission = AvailableGroupedReleasePermission;
    this._PermissionLabels = PermissionLabels;
    this._readOnly = ReleasesService.isReleaseCompleted(release) || ReleasesService.isReleaseInsideFolder(release);
    this._permissionsCollapsed = 0;
    this._teamsCollapsed = 0;

    this._mapTeamToContainer = function (team) {
      return {
        name: team.teamName,
        type: _this._MemberType.TEAM
      };
    };

    this._Page.setReleaseOpened(release);

    this._loadData();
  }

  createClass_default()(ReleasePermissionsController, [{
    key: "_loadData",
    value: function _loadData() {
      var _this2 = this;

      this._teams = this._loadedTeams.map(function (team) {
        var validTeam = release_permissions_controller_objectSpread({}, team);

        validTeam.valid = true;
        return validTeam;
      });

      this._ReleasesService.getReleasePermissions(this._$stateParams.releaseId).then(function (response) {
        _this2._initPermissionsTableData(response.data);

        _this2._initTeamsTableData();
      });

      this._inherited = this.isInherited();
      this._dirty = false;
    }
  }, {
    key: "_initTeamsTableData",
    value: function _initTeamsTableData() {
      var _context;

      this._teamsTableColumns = [{
        title: 'Team name',
        key: 'teamName'
      }, {
        title: 'Global roles',
        key: 'globalRoles',
        suggestionData: this._roles,
        type: this._MemberType.ROLE
      }, {
        title: 'Users',
        key: 'users',
        suggestionData: this._users,
        type: this._MemberType.PRINCIPAL
      }];
      this._teamsPermissionsContainer = this._teams.map((_context = this._permissionTableUtils).teamPermissionsToContainer.bind(_context));
    }
  }, {
    key: "_initPermissionsTableData",
    value: function _initPermissionsTableData(releasePermissionsView) {
      var _this3 = this;

      this._permissions = releasePermissionsView.permissions;
      this._permissionsTableColumns = [{
        title: 'Action',
        key: 'action'
      }, {
        title: 'Teams',
        key: 'teams',
        suggestionData: this._teams.map(this._mapTeamToContainer),
        type: this._MemberType.TEAM
      }];
      this._permissionsContainer = [];

      this._AvailableGroupedReleasePermission.filter(function (group) {
        return !_this3.isTemplate() && group.label !== 'Templates' || _this3.isTemplate();
      }).forEach(function (group) {
        var permissions = group.permissions;
        var permissionsMap = permissions.map(function (permission) {
          return {
            action: _this3._PermissionLabels[permission].label,
            clazz: defineProperty_default()({}, _this3._PermissionLabels[permission].clazz, true),
            value: permission,
            description: _this3._PermissionLabels[permission].description,
            teams: _this3._teams.filter(function (team) {
              return team.permissions.includes(permission);
            }).map(_this3._mapTeamToContainer)
          };
        });

        var sortTeam = function sortTeam(teams) {
          return _this3._sortBy(teams, "name");
        };

        var formattedPermissionMap = permissionsMap.map(function (p) {
          return release_permissions_controller_objectSpread({}, p, {
            teams: sortTeam(p.teams)
          });
        });

        _this3._permissionsContainer.push({
          label: group.label,
          icon: group.icon,
          permissions: formattedPermissionMap
        });
      });
    }
  }, {
    key: "save",
    value: function save() {
      var _this4 = this;

      var teams = this._teams.map(function (t) {
        return _this4._mapTeamToTeamWithPermissions(t);
      });

      this._TeamsService.updateTeams(this._$stateParams.releaseId, teams).then(function () {
        _this4._lastSavedDate = moment().toDate();
        _this4._dirty = false;
      });
    }
  }, {
    key: "reset",
    value: function reset() {
      this._loadData();

      this._lastSavedDate = null;
      this._dirty = false;
    }
  }, {
    key: "isInherited",
    value: function isInherited() {
      var _this5 = this;

      if (this._teams.length === 0) return false;
      var team = this._teams[0];

      var parentId = this._Ids.getParentIdGeneral(team.id, '-');

      var isInherited = parentId !== this._release.id;

      if (isInherited) {
        this._FolderPathService.getPathFromRelativeFolderId(parentId).then(function (paths) {
          _this5._inheritedFrom = _.last(paths);
        });
      }

      return isInherited;
    }
  }, {
    key: "setDirty",
    value: function setDirty() {
      this._dirty = true;
    }
  }, {
    key: "openAddTeamModal",
    value: function openAddTeamModal() {
      var _this6 = this;

      var modal = this._$uibModal.open({
        animation: false,
        resolve: {
          teams: function teams() {
            return _this6._teams.map(function (t) {
              return t.teamName;
            });
          }
        },
        component: 'addTeamModal'
      });

      modal.result.then(function (teamName) {
        if (teamName) {
          var newTeam = {
            teamName: teamName,
            members: [],
            permissions: []
          };

          _this6._teams.push(newTeam);

          _this6._teamsPermissionsContainer.push(_this6._permissionTableUtils.teamPermissionsToContainer(newTeam));

          _this6.updateTeamsSuggestions();

          _this6.setDirty();
        }
      });
    }
  }, {
    key: "updateTeamsSuggestions",
    value: function updateTeamsSuggestions() {
      this._permissionsTableColumns[1].suggestionData = this._teams.map(this._mapTeamToContainer);
    }
  }, {
    key: "onRemoveTeam",
    value: function onRemoveTeam(team) {
      var _this7 = this;

      var modal = this._$uibModal.open({
        animation: false,
        component: 'deleteTeamModal',
        resolve: {
          teamName: function teamName() {
            return team.teamName;
          }
        }
      });

      modal.result.then(function (pressedDelete) {
        if (pressedDelete) {
          _.remove(_this7._teams, {
            teamName: team.teamName
          });

          _this7._permissionsContainer.map(function (permission) {
            return _.remove(permission.teams, {
              name: team.teamName
            });
          });

          _.remove(_this7._teamsPermissionsContainer, {
            teamName: team.teamName
          });

          _this7.updateTeamsSuggestions();

          _this7.setDirty();
        }
      });
    }
  }, {
    key: "validate",
    value: function validate(newName, team) {
      return !this._nameAlreadyUsed(newName, team);
    }
  }, {
    key: "isReleaseCompleted",
    value: function isReleaseCompleted() {
      return this._ReleasesService.isReleaseCompleted(this._release);
    }
  }, {
    key: "isTemplate",
    value: function isTemplate() {
      return this._ReleasesService.isTemplate(this._release);
    }
  }, {
    key: "_nameAlreadyUsed",
    value: function _nameAlreadyUsed(teamName, teamToIgnore) {
      return _.some(this._teams, function (team) {
        return team.teamName === teamName && team !== teamToIgnore;
      });
    }
  }, {
    key: "_mapTeamToTeamWithPermissions",
    value: function _mapTeamToTeamWithPermissions(team) {
      team.permissions = _.flatMap(this._permissionsContainer, 'permissions').filter(function (p) {
        return _.find(p.teams, {
          name: team.teamName
        });
      }).map(function (permission) {
        return permission.value;
      });
      team.members = _.flatMap(this._teamsPermissionsContainer.filter(function (c) {
        return c.teamName === team.teamName;
      }), function (c) {
        return [].concat(toConsumableArray_default()(c.globalRoles), toConsumableArray_default()(c.users));
      });
      return _.omit(team, 'valid');
    }
  }, {
    key: "_sortBy",
    value: function _sortBy(collection, prop) {
      return _.sortBy(collection, [this._sortProperty(prop)]);
    }
  }, {
    key: "_sortProperty",
    value: function _sortProperty(prop) {
      var valueToLowerCase = function valueToLowerCase(val) {
        return val ? val.toLowerCase() : '';
      };

      var sortProperty = function sortProperty(property) {
        return function (obj) {
          return valueToLowerCase(obj[property]);
        };
      };

      return sortProperty(prop);
    }
  }, {
    key: "release",
    get: function get() {
      return this._release;
    }
  }, {
    key: "permissions",
    get: function get() {
      return this._permissions;
    }
  }, {
    key: "lastSavedDate",
    get: function get() {
      return this._lastSavedDate;
    }
  }, {
    key: "dirty",
    get: function get() {
      return this._dirty;
    }
  }, {
    key: "teams",
    get: function get() {
      return this._teams;
    }
  }, {
    key: "users",
    get: function get() {
      return this._users;
    }
  }, {
    key: "roleNames",
    get: function get() {
      return this._roleNames;
    }
  }, {
    key: "permissionsTableColumns",
    get: function get() {
      return this._permissionsTableColumns;
    }
  }, {
    key: "permissionsContainers",
    get: function get() {
      return this._permissionsContainer;
    }
  }, {
    key: "teamsTableColumns",
    get: function get() {
      return this._teamsTableColumns;
    }
  }, {
    key: "teamsPermissionsContainer",
    get: function get() {
      return this._teamsPermissionsContainer;
    }
  }, {
    key: "readOnly",
    get: function get() {
      return this._readOnly;
    }
  }, {
    key: "permissionsCollapsed",
    get: function get() {
      return this._permissionsCollapsed;
    },
    set: function set(permissionsCollapsed) {
      this._permissionsCollapsed = permissionsCollapsed;
    }
  }, {
    key: "teamsCollapsed",
    get: function get() {
      return this._teamsCollapsed;
    },
    set: function set(teamsCollapsed) {
      this._teamsCollapsed = teamsCollapsed;
    }
  }, {
    key: "inherited",
    get: function get() {
      return this._inherited;
    }
  }, {
    key: "inheritedFrom",
    get: function get() {
      return this._inheritedFrom;
    }
  }]);

  return ReleasePermissionsController;
}();

defineProperty_default()(release_permissions_controller_ReleasePermissionsController, "$inject", ['$stateParams', '$uibModal', 'ReleasesService', 'TeamsService', 'MemberType', 'Page', 'release', 'teams', 'users', 'roles', 'Ids', 'permissionTableUtils', 'FolderPathService', 'AvailableGroupedReleasePermission', 'PermissionLabels']);

angular.module('xlrelease').controller('releasePermissionsController', release_permissions_controller_ReleasePermissionsController);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/releases/phase-details-controller.js




function phase_details_controller_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function phase_details_controller_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { phase_details_controller_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { phase_details_controller_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

angular.module('xlrelease').controller('phaseDetailsController', ['$scope', 'Backend', 'PhasesService', 'PhaseDetailsUpdates', 'PlanningDataEditorMixin', 'VariablesService', function ($scope, Backend, PhasesService, PhaseDetailsUpdates, PlanningDataEditorMixin, VariablesService) {
  $scope.$watch('phase.scheduledStartDate + phase.dueDate', validatePhaseDates);
  $scope.$watch('phase.title', loadVariablesOnPhaseSaved);
  angular.extend($scope, PlanningDataEditorMixin.withSaveCallback(function (phase) {
    $scope.updatePhase(phase);
    PhaseDetailsUpdates.planningDataChanged = true;
  }));
  $scope.planning.initPlanningData($scope.phase, $scope.release);

  function validatePhaseDates() {
    if (!$scope.phase) return;
    $scope.warning = {
      displayScheduledStartDateBefore: $scope.phase.scheduledStartDate !== null && $scope.release.scheduledStartDate !== null && moment($scope.phase.scheduledStartDate).isBefore(moment($scope.release.scheduledStartDate), 'minutes'),
      displayScheduledStartDateAfter: $scope.phase.scheduledStartDate !== null && $scope.release.dueDate !== null && moment($scope.phase.scheduledStartDate).isAfter(moment($scope.release.dueDate), 'minutes'),
      displayDueDateBefore: $scope.phase.dueDate !== null && $scope.release.scheduledStartDate !== null && moment($scope.phase.dueDate).isBefore(moment($scope.release.scheduledStartDate), 'minutes'),
      displayDueDateAfter: $scope.phase.dueDate !== null && $scope.release.dueDate !== null && moment($scope.phase.dueDate).isAfter(moment($scope.release.dueDate), 'minutes')
    };
    loadVariables();
  }

  function loadVariablesOnPhaseSaved() {
    var VARIABLE_MATCHER = /(\$\{[^}]+\})/g;

    var variables = _.uniq($scope.phase.title.match(VARIABLE_MATCHER));

    variables.filter(function (var1) {
      return !($scope.allVariables ? $scope.allVariables.some(function (var2) {
        return var1 === var2.key;
      }) : true);
    }).forEach(function (newVar) {
      return $scope.allVariablesWithReleaseVars.push({
        'displayName': newVar,
        'id': '',
        'key': newVar.replace('${', '').replace('}', ''),
        'requiresValue': false,
        'showOnReleaseStart': false,
        'type': "xlrelease.StringVariable",
        'variableName': newVar
      });
    });
  }

  function loadAllVariablesWithSpecialRelVars(allVariables, release) {
    if (release.variables) {
      var specialVariables = Object.keys(release.variables).filter(function (key) {
        return key.includes('release.');
      }).reduce(function (obj, key) {
        return phase_details_controller_objectSpread({}, obj, defineProperty_default()({}, key, release.variables[key]));
      }, {});
      Object.keys(specialVariables).forEach(function (key) {
        var obj = {
          'displayName': key,
          'id': '',
          'key': key.replace('${', '').replace('}', ''),
          'requiresValue': false,
          'showOnReleaseStart': false,
          'type': "xlrelease.StringVariable",
          'value': specialVariables[key],
          'variableName': key
        };
        allVariables.push(obj);
      });
    }

    return allVariables;
  }

  function loadVariables() {
    VariablesService.getAllVariables($scope.release.id).then(function (allVariables) {
      $scope.allVariables = allVariables;
      $scope.allVariablesWithReleaseVars = loadAllVariablesWithSpecialRelVars(allVariables, $scope.release);
    });
  }

  $scope.isEditable = function () {
    return !$scope.isPhaseReadOnly($scope.phase) && $scope.security.hasEditPermission($scope.release);
  };

  $scope.updatePhase = PhasesService.updatePhase;
  $scope.isPhaseInProgress = PhasesService.isPhaseInProgress;
  $scope.isPhaseReadOnly = PhasesService.isPhaseReadOnly;
  $scope.isPhasePlanned = PhasesService.isPhasePlanned;
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/phase-details-updates.js
var phase_details_updates = __webpack_require__(928);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/release-flow-header-directive.js
var release_flow_header_directive = __webpack_require__(929);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/releases/release-header-controller.js



var release_header_controller_ReleaseSubpages = /*#__PURE__*/function () {
  function ReleaseSubpages(ViewStorage) {
    classCallCheck_default()(this, ReleaseSubpages);

    this.ViewStorage = ViewStorage;
  }

  createClass_default()(ReleaseSubpages, [{
    key: "getSubpages",
    value: function getSubpages(releaseId) {
      return {
        editor: {
          path: this._getEditorPath(releaseId),
          label: 'Release flow',
          weight: 20
        },
        grid: {
          path: '/table',
          label: 'Release flow',
          weight: 25,
          hidden: true
        },
        gantt: {
          path: '/planner',
          label: 'Release flow',
          weight: 30,
          hidden: true
        },
        releaseXfile: {
          path: '/releasefile',
          label: 'Release flow',
          weight: 40,
          hidden: true
        },
        properties: {
          path: '/properties',
          label: 'Properties',
          weight: 45
        },
        variables: {
          path: '/variables',
          label: 'Variables',
          weight: 50
        },
        permissions: {
          path: '/permissions',
          label: 'Teams & Permissions',
          weight: 70,
          displayIf: 'security.hasEditSecurityPermission(release)',
          class: 'release-permissions'
        }
      };
    }
  }, {
    key: "_getEditorPath",
    value: function _getEditorPath(releaseId) {
      var editorPath = '/';

      if (this.ViewStorage.getView(releaseId)) {
        var storedView = this.ViewStorage.getView(releaseId);
        editorPath += storedView.substr(storedView.lastIndexOf(releaseId) + releaseId.length + 1);
      }

      return editorPath === '/' ? '' : editorPath; // UI router doesn't like trailing slashes
    }
  }]);

  return ReleaseSubpages;
}();

release_header_controller_ReleaseSubpages.$inject = ['ViewStorage'];
angular.module('xlrelease').service('ReleaseSubpages', release_header_controller_ReleaseSubpages); // Allows the release header to be customized according to the current location

var release_header_controller_injectParams = ['$scope', '$location', 'ReleaseSubpages', '$parse', '$stateParams', 'Authenticator', 'ReleasesService', 'UiExtensionsService', '$ngRedux', 'Ids'];

var ReleaseHeaderController = function ReleaseHeaderController($scope, $location, ReleaseSubpages, $parse, $stateParams, Authenticator, ReleasesService, UiExtensionsService, $ngRedux, Ids) {
  $scope.isSubpageDropdownAvailable = false;
  $scope.getSubpageLink = getSubpageLink;
  init(); // TODO: refactor. onDestroy...

  $scope.unsubscribe = $ngRedux.connect(mapStateToThis)($scope);

  function mapStateToThis(state) {
    var releaseGrid = state.releaseGrid;
    return {
      selectedCount: releaseGrid.selectedItems.length
    };
  }

  function init() {
    $scope.releaseId = $stateParams.releaseId;
    $scope.security = Authenticator;
    $scope.releaseTemplateVariable = _.includes($location.path(), '/templates/') ? 'templates' : 'releases';

    if ($scope.releasePageExtensionCtrl) {
      $scope.release = $scope.releasePageExtensionCtrl.release;
    }

    if ($scope.release) {
      generateReleaseSubpages($scope.release);
    } else if ($scope.releaseId) {
      ReleasesService.getRelease($scope.releaseId).then(function (response) {
        generateReleaseSubpages(response.data);
      });
    }
  }

  function generateReleaseSubpages(release) {
    $scope.release = release;
    $scope.isSubpageDropdownAvailable = angular.isDefined($scope.release) && !!$scope.release;
    $scope.releaseSubpages = ReleaseSubpages.getSubpages($scope.releaseId); // to avoid errors while extended subpages are being fetched

    extendReleaseSubpages($scope.release).then(function (extendedSubpages) {
      $scope.releaseSubpages = extendedSubpages;

      var notDefaultPages = _.omit($scope.releaseSubpages, 'editor');

      $scope.page = _.find(notDefaultPages, function (aPage) {
        var regexp = new RegExp(aPage.path, 'i');
        return $location.path().match(regexp); // if current location ends with one of the subpages
      });
      $scope.page = $scope.page || $scope.releaseSubpages.editor;
    });
    $scope.isSubpageDisplayed = isSubpageDisplayed;
    $scope.showNewReleaseButton = showNewReleaseButton; //

    $scope.isActive = function (viewMode) {
      if ($scope.page && $scope.page.path !== null) {
        return $scope.page.path === viewMode;
      } else {
        return false;
      }
    };
  }

  function isSubpageDisplayed(subpage) {
    if (_.isString(subpage.displayIf)) {
      var displayFunction = $parse(subpage.displayIf);
      return displayFunction($scope);
    }

    return !subpage.hidden;
  }

  function showNewReleaseButton() {
    var isProperPage = angular.isDefined($scope.release) && $scope.release.status === 'TEMPLATE' && ($scope.releaseSubpages.editor === $scope.page || $scope.releaseSubpages.properties === $scope.page);
    var isInFolder = _.isEmpty(_.get($scope.release, 'id')) ? false : Ids.isInFolder($scope.release.id);
    var isAllowed = isInFolder ? $scope.security.hasPermission('template#create_release', $scope.release) : $scope.security.hasPermission('release#create');
    return isProperPage && isAllowed;
  }

  function extendReleaseSubpages(release) {
    return UiExtensionsService.getReleaseMenuExtensions(release).then(function (extensions) {
      /* eslint-disable lodash/no-extra-args */
      var extendedSubpages = _.clone(ReleaseSubpages.getSubpages(release.id), false);
      /* eslint-enable lodash/no-extra-args */


      _(extensions).filter({
        permitted: true
      }).filter(function (extension) {
        if (extension.properties && extension.properties.showOnlyOnTemplate) {
          return release.status === 'TEMPLATE';
        }

        return true;
      }).forEach(function (extension) {
        extendedSubpages[extension.pathSuffix] = {
          path: '/' + extension.pathSuffix,
          label: extension.label,
          weight: extension.weight
        };
      });

      extendedSubpages = _(extendedSubpages).toPairs().sortBy(function (keyValue) {
        return keyValue[1].weight;
      }).fromPairs().value();
      return extendedSubpages;
    });
  }

  function getSubpageLink(subpage) {
    return "#/".concat($scope.release.status === 'TEMPLATE' ? 'templates' : 'releases', "/").concat($scope.releaseId).concat(subpage.path);
  }
};

ReleaseHeaderController.$inject = release_header_controller_injectParams;
angular.module('xlrelease').controller('releaseHeaderController', ReleaseHeaderController);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/release-header-directive.js
var release_header_directive = __webpack_require__(930);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/release-page-extension-controller.js
var release_page_extension_controller = __webpack_require__(931);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/variables/release-variables-controller.js
var release_variables_controller = __webpack_require__(932);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/reports/echarts-reports-service.js




function echarts_reports_service_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function echarts_reports_service_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { echarts_reports_service_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { echarts_reports_service_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }


var sizes = {
  SYMBOL: 5,
  LINE: 1,
  LEGEND: 11,
  LABEL: 11,
  BAR: 20,
  BAR_VERTICAL: 45
};
var position = {
  CENTER: 'center'
};
var echarts_reports_service_defaults = {
  TITLE_TEXT_STYLE: {
    color: colors["a" /* default */].black,
    fontSize: 30,
    fontWeight: '600',
    fontFamily: 'OpenSans'
  },
  SUB_TITLE_TEXT_STYLE: {
    color: colors["a" /* default */].black,
    fontSize: 12,
    fontFamily: 'OpenSans'
  }
};
var pieChartSmallSizeSettings = {
  title: {
    show: true,
    textStyle: {
      fontSize: 17
    },
    subtextStyle: {
      fontSize: 9
    },
    y: '38%'
  },
  legend: {
    show: true,
    bottom: 0
  },
  tooltip: {
    position: [0, '12%']
  },
  series: {
    radius: [35, '65%']
  }
};
var pieChartSmallHeightSettings = {
  title: {
    show: true,
    textStyle: {
      fontSize: 22
    },
    subtextStyle: {
      fontSize: 10
    },
    y: '35%'
  },
  legend: {
    show: true,
    bottom: 0
  },
  series: {
    radius: [45, '70%']
  }
};
var pieChartSmallWidthSettings = {
  title: {
    show: true,
    textStyle: {
      fontSize: 20
    },
    subtextStyle: {
      fontSize: 9
    },
    y: '45%'
  },
  tooltip: {
    position: [0, '30%']
  },
  series: {
    radius: [42, '80%']
  }
};
var HORIZONTAL_BAR_NUMS = 10;

var echarts_reports_service_EchartsReportsService = /*#__PURE__*/function () {
  function EchartsReportsService(durationFilter) {
    classCallCheck_default()(this, EchartsReportsService);

    this.durationFilter = durationFilter;
  }
  /** Report configurations **/


  createClass_default()(EchartsReportsService, [{
    key: "taskEfficiency",
    value: function taskEfficiency(releaseEfficiency) {
      var _this = this;

      var that = this;
      return this.automationTaskReport(releaseEfficiency.totalAutomatedTasks, releaseEfficiency.totalManualTasks, releaseEfficiency.totalTasks, 'tasks executed', function (params) {
        return _this.automationTaskReportTooltip(params.data.name, params.color, params.data.value, _this.formatPercentage(params.data.value, releaseEfficiency.totalTasks));
      });
    }
  }, {
    key: "taskTimeSpent",
    value: function taskTimeSpent(releaseEfficiency) {
      var _this2 = this;

      var that = this;
      var durationFormatter = this.getDurationFormatter(releaseEfficiency.totalTimeSpent);
      return this.automationTaskReport(releaseEfficiency.totalAutomatedTimeSpent, releaseEfficiency.totalManualTimeSpent, "".concat(durationFormatter.format(releaseEfficiency.totalTimeSpent), " ").concat(durationFormatter.name.charAt(0)), 'in total', function (params) {
        return _this2.automationTaskReportTooltip(params.data.name, params.color, _this2.durationFilter(params.data.value), _this2.formatPercentage(params.data.value, releaseEfficiency.totalTimeSpent));
      });
    }
  }, {
    key: "longestReleases",
    value: function longestReleases(_longestReleases) {
      return this.longestItemsHorizontalBarReport('release', _longestReleases);
    }
  }, {
    key: "longestTasks",
    value: function longestTasks(_longestTasks) {
      return this.longestItemsHorizontalBarReport('task', _longestTasks);
    }
  }, {
    key: "longestPhases",
    value: function longestPhases(_longestPhases) {
      return this.longestItemsHorizontalBarReport('phase', _longestPhases);
    }
  }, {
    key: "releaseEfficiency",
    value: function releaseEfficiency(averageDurationAndAutomation) {
      var _this3 = this;

      return {
        grid: {
          bottom: 80
        },
        tooltip: {
          trigger: 'axis',
          backgroundColor: 'transparent',
          formatter: function formatter(params) {
            return _this3.getReleaseEfficiencyTooltip(params);
          }
        },
        legend: {
          bottom: 25,
          itemWidth: 10,
          data: ['Automation', 'Manual'],
          selectedMode: false,
          textStyle: {
            color: colors["a" /* default */].gray,
            fontSize: sizes.LEGEND
          }
        },
        xAxis: {
          type: 'category',
          boundaryGap: false,
          data: averageDurationAndAutomation.releasesAutomation.map(function (it) {
            return _this3.formatMonth(it.name);
          }),
          axisTick: {
            show: false
          },
          axisLine: {
            show: false,
            lineStyle: {
              color: colors["a" /* default */].gray
            }
          },
          axisLabel: {
            fontSize: sizes.LABEL
          }
        },
        yAxis: {
          type: 'value',
          axisTick: {
            show: false
          },
          axisLine: {
            show: false,
            lineStyle: {
              color: colors["a" /* default */].gray
            }
          },
          axisLabel: {
            fontSize: sizes.LABEL,
            formatter: function formatter(value) {
              return value > 0 ? "".concat(value, "%") : value;
            }
          }
        },
        series: [{
          type: 'line',
          name: 'Automation',
          data: averageDurationAndAutomation.releasesAutomation.map(function (it) {
            return it.y;
          }),
          lineStyle: {
            normal: {
              color: colors["a" /* default */].purple,
              width: sizes.LINE
            }
          },
          itemStyle: {
            normal: {
              color: colors["a" /* default */].purple
            }
          },
          symbol: 'circle',
          symbolSize: sizes.SYMBOL
        }, {
          type: 'line',
          name: 'Manual',
          data: averageDurationAndAutomation.releasesAutomation.map(function (it) {
            return 100 - it.y;
          }),
          lineStyle: {
            normal: {
              color: colors["a" /* default */].yellow,
              width: sizes.LINE
            }
          },
          itemStyle: {
            normal: {
              color: colors["a" /* default */].yellow
            }
          },
          symbol: 'circle',
          symbolSize: sizes.SYMBOL
        }, {
          type: 'line',
          name: 'Duration',
          show: false,
          data: averageDurationAndAutomation.releasesDuration.map(function (it) {
            return _this3.durationFilter(it.y);
          })
        }]
      };
    }
  }, {
    key: "numberOfReleasesPerMonth",
    value: function numberOfReleasesPerMonth(releaseEfficiency) {
      var _this4 = this;

      return {
        axisPointer: {
          show: false
        },
        color: [colors["a" /* default */].blue],
        tooltip: {
          trigger: 'axis',
          backgroundColor: 'transparent',
          formatter: this.getNumberOfReleasesPerMonth.bind(this),
          axisPointer: {
            lineStyle: {
              opacity: 0
            }
          }
        },
        xAxis: {
          type: 'category',
          data: releaseEfficiency.numberOfReleasesPerMonth.map(function (it) {
            return _this4.formatMonth(it.name);
          }),
          axisTick: {
            show: false
          },
          axisLine: {
            show: false,
            lineStyle: {
              color: colors["a" /* default */].gray
            }
          },
          axisLabel: {
            fontSize: sizes.LABEL
          }
        },
        yAxis: {
          type: 'value',
          axisTick: {
            show: false
          },
          axisLine: {
            show: false,
            lineStyle: {
              color: colors["a" /* default */].gray
            }
          }
        },
        series: [{
          type: 'bar',
          barWidth: sizes.BAR_VERTICAL,
          name: 'Releases',
          data: releaseEfficiency.numberOfReleasesPerMonth.map(function (it) {
            return it.y;
          })
        }, {
          type: 'line',
          show: false,
          name: 'Automation',
          data: releaseEfficiency.releasesAutomation.map(function (it) {
            return "".concat(it.y, "%");
          })
        }, {
          type: 'line',
          show: false,
          name: 'Avg. release duration',
          data: releaseEfficiency.releasesDuration.map(function (it) {
            return _this4.durationFilter(it.y);
          })
        }]
      };
    }
  }, {
    key: "releaseDuration",
    value: function releaseDuration(averageDurationAndAutomation) {
      var _this5 = this;

      var durations = averageDurationAndAutomation.releasesDuration.map(function (it) {
        return it.y;
      });

      var maxDuration = _.max(durations);

      var durationFormatter = this.getDurationFormatter(maxDuration);
      return {
        tooltip: {
          trigger: 'axis',
          backgroundColor: 'transparent',
          // Note: passing in first element of array since the value is taken from the axis
          formatter: function formatter(params) {
            return _this5.wrapTooltipTextContext(_this5.getAverageReleaseDuration(_this5.durationFilter(params[0].value)));
          }
        },
        xAxis: {
          type: 'category',
          boundaryGap: false,
          data: averageDurationAndAutomation.releasesDuration.map(function (it) {
            return _this5.formatMonth(it.name);
          }),
          axisTick: {
            show: false
          },
          axisLine: {
            show: false,
            lineStyle: {
              color: colors["a" /* default */].gray
            }
          }
        },
        yAxis: {
          name: durationFormatter.name,
          nameLocation: 'start',
          type: 'value',
          axisTick: {
            show: false
          },
          axisLine: {
            show: false,
            lineStyle: {
              color: colors["a" /* default */].gray
            }
          },
          axisLabel: {
            formatter: durationFormatter.format
          }
        },
        series: {
          type: 'line',
          lineStyle: {
            normal: {
              color: colors["a" /* default */].blue,
              width: sizes.LINE
            }
          },
          itemStyle: {
            normal: {
              color: colors["a" /* default */].blue
            }
          },
          symbol: 'circle',
          symbolSize: sizes.SYMBOL,
          areaStyle: {
            normal: {
              color: colors["a" /* default */].lightblue
            }
          },
          data: durations
        }
      };
    }
    /** Helper methods **/

  }, {
    key: "formatPercentage",
    value: function formatPercentage(num, total) {
      var round10 = parseFloat((num / total * 100).toFixed(2));

      if (round10 === 0) {
        return '<0.01';
      }

      return "".concat(round10);
    }
  }, {
    key: "getReleaseEfficiencyTooltip",
    value: function getReleaseEfficiencyTooltip(params) {
      var _this6 = this;

      return this.wrapTooltipTextContext(params.map(function (param) {
        if (param.seriesName === 'Duration') {
          return "<div class=\"tooltip-text-offset\">".concat(_this6.getAverageReleaseDuration(param.value), "</div>");
        }

        return "<div><span class=\"tooltip-text-circle\" style=\"background: ".concat(param.color, "\">&nbsp;</span>\n                    <span>").concat(param.seriesName, ": ").concat(param.value, "%</span></div>");
      }).join(''));
    }
  }, {
    key: "getNumberOfReleasesPerMonth",
    value: function getNumberOfReleasesPerMonth(params) {
      return this.wrapTooltipTextContext(params.map(function (param) {
        return "<div>".concat(param.seriesName, ": ").concat(param.data, "</div>");
      }).join(''));
    }
  }, {
    key: "automationTaskReportTooltip",
    value: function automationTaskReportTooltip(name, color, value, percentage) {
      return this.wrapTooltipTextContext("<span class=\"tooltip-text-circle\" style=\"background: ".concat(color, "\">&nbsp;</span>\n             <span>").concat(name, ": ").concat(value, " (").concat(percentage, "%)</span>"));
    }
  }, {
    key: "automationTaskReport",
    value: function automationTaskReport(automatedValue, manualValue, text, subtext, tooltipFormatter) {
      var automatedName = 'Automated task';
      var manualName = 'Manual task';
      return {
        title: {
          text: text,
          subtext: subtext,
          x: position.CENTER,
          y: '42%',
          textStyle: echarts_reports_service_defaults.TITLE_TEXT_STYLE,
          subtextStyle: echarts_reports_service_defaults.SUB_TITLE_TEXT_STYLE
        },
        tooltip: {
          trigger: 'item',
          backgroundColor: 'transparent',
          formatter: tooltipFormatter
        },
        color: [colors["a" /* default */].purple, colors["a" /* default */].yellow],
        legend: {
          selectedMode: false,
          left: position.CENTER,
          bottom: 15,
          itemWidth: 10,
          data: [{
            name: automatedName,
            icon: 'circle',
            textStyle: {
              color: colors["a" /* default */].gray,
              fontSize: sizes.LEGEND
            }
          }, {
            name: manualName,
            icon: 'circle',
            textStyle: {
              color: colors["a" /* default */].gray,
              fontSize: sizes.LEGEND
            }
          }]
        },
        label: {
          normal: {
            show: true
          }
        },
        series: {
          type: 'pie',
          radius: [70, 100],
          avoidLabelOverlap: false,
          label: {
            normal: {
              show: false,
              position: position.CENTER
            },
            emphasis: {
              show: false,
              textStyle: {
                fontSize: '16'
              }
            }
          },
          labelLine: {
            normal: {
              show: false
            }
          },
          data: [{
            value: automatedValue,
            name: automatedName
          }, {
            value: manualValue,
            name: manualName
          }]
        }
      };
    }
  }, {
    key: "sortOnDuration",
    value: function sortOnDuration(a, b) {
      if (a.duration < b.duration) return -1;
      if (a.duration > b.duration) return 1;
      return 0;
    }
  }, {
    key: "getDurationFormatter",
    value: function getDurationFormatter(durationInMs) {
      var round10 = function round10(val) {
        return parseFloat(val.toFixed(2));
      };

      var durationInSec = function durationInSec(durationInMs) {
        return round10(durationInMs / 1000);
      };

      if (durationInSec(durationInMs) < 60) {
        return {
          format: durationInSec,
          name: 'sec'
        };
      }

      var durationInMin = function durationInMin(durationInMs) {
        return round10(durationInSec(durationInMs) / 60);
      };

      if (durationInMin(durationInMs) < 60) {
        return {
          format: durationInMin,
          name: 'min'
        };
      }

      var durationInHours = function durationInHours(durationInMs) {
        return round10(Math.ceil(durationInMin(durationInMs) / 6) / 10);
      };

      if (durationInHours(durationInMs) < 24) {
        return {
          format: durationInHours,
          name: 'hours'
        };
      }

      return {
        format: function format(durationInMs) {
          return round10(durationInHours(durationInMs) / 24);
        },
        name: 'days'
      };
    }
  }, {
    key: "longestItemsHorizontalBarReport",
    value: function longestItemsHorizontalBarReport(seriesName, data) {
      var _this7 = this;

      // sort the data before using it
      data = data.sort(this.sortOnDuration); // add placeholders if needed

      if (data.length < HORIZONTAL_BAR_NUMS) {
        data = _.times(HORIZONTAL_BAR_NUMS - data.length, _.constant({
          title: '',
          duration: 0,
          isPlaceholder: true
        })).concat(data);
      }

      var durations = data.map(function (it) {
        return it.duration;
      });

      var maxDuration = _.max(durations);

      var durationFormatter = this.getDurationFormatter(maxDuration);
      return {
        sortedData: data,
        color: [colors["a" /* default */].blue],
        grid: {
          left: 220
        },
        sort: 'descending',
        tooltip: {
          trigger: 'axis',
          axisPointer: {
            lineStyle: {
              opacity: 0
            }
          },
          backgroundColor: 'transparent',
          formatter: function formatter(params) {
            return _this7.getHorizontalBarTooltip(data, params[0]);
          }
        },
        yAxis: {
          type: 'category',
          data: data.map(function (it) {
            return it.title;
          }),
          axisTick: {
            show: false
          },
          axisLine: {
            show: false
          },
          axisLabel: {
            color: colors["a" /* default */].black,
            margin: 200,
            textStyle: {
              align: 'left'
            },
            formatter: function formatter(label) {
              return _this7.wrapText(label, 30);
            }
          }
        },
        xAxis: {
          name: durationFormatter.name,
          nameTextStyle: {
            fontSize: sizes.LABEL,
            color: colors["a" /* default */].gray
          },
          type: 'value',
          axisTick: {
            show: false
          },
          axisLine: {
            show: false,
            lineStyle: {
              color: colors["a" /* default */].gray
            }
          },
          axisLabel: {
            formatter: durationFormatter.format
          }
        },
        series: {
          type: 'bar',
          barWidth: sizes.BAR,
          name: seriesName,
          data: durations
        }
      };
    }
  }, {
    key: "getAverageReleaseDuration",
    value: function getAverageReleaseDuration(avg) {
      return "Avg. release duration: ".concat(avg);
    }
  }, {
    key: "getHorizontalBarTooltip",
    value: function getHorizontalBarTooltip(data, params) {
      var item = data[params.dataIndex];
      if (item.isPlaceholder) return '';
      var wrapTextNum = 40;
      var context = [];

      if (params.seriesName === 'release') {
        context.push("<div class=\"tooltip-release-title\" >Release: ".concat(item.title, "</div>"));
        context.push("<span>Duration: ".concat(this.durationFilter(item.duration), "</span>"));
      }

      if (params.seriesName === 'phase') {
        context.push("<div>Phase: ".concat(this.wrapText(item.title, wrapTextNum), "</div>"));
        context.push("<div>Duration: ".concat(this.durationFilter(item.duration), "</div>"));
        context.push("<div>Belongs to: ".concat(this.wrapText(item.release, wrapTextNum), "</div>"));
      }

      if (params.seriesName === 'task') {
        context.push("<div>Task: ".concat(this.wrapText(item.title, wrapTextNum), "</div>"));
        context.push("<div>Duration: ".concat(this.durationFilter(item.duration), "</div>"));
        context.push("<div>Belongs to: ".concat(this.wrapText(item.release, wrapTextNum), "</div>"));
        context.push("<div>Owner: ".concat(item.owner.username || 'Not assigned', "</div>"));
      }

      return this.wrapTooltipTextContext(context.join(''));
    }
  }, {
    key: "wrapTooltipTextContext",
    value: function wrapTooltipTextContext(context) {
      return "<div class=\"tooltip-text-content\">".concat(context, "</div>");
    }
  }, {
    key: "wrapText",
    value: function wrapText(string, len) {
      return string.length < len ? string : "".concat(string.substring(0, len - 3), "...");
    }
  }, {
    key: "formatMonth",
    value: function formatMonth(month) {
      return month.substr(0, 3);
    }
  }, {
    key: "responsivePie",
    value: function responsivePie(options) {
      var responsiveOptions = {};
      var mediaOptions = angular.copy(options);
      responsiveOptions.baseOption = angular.copy(options);
      responsiveOptions.media = [// Media queries order matters
      {
        query: {
          maxWidth: 290
        },
        option: echarts_reports_service_objectSpread({}, mediaOptions, {}, pieChartSmallWidthSettings)
      }, {
        query: {
          maxHeight: 300
        },
        option: echarts_reports_service_objectSpread({}, mediaOptions, {}, pieChartSmallHeightSettings)
      }, {
        query: {
          maxHeight: 300,
          maxWidth: 290
        },
        option: echarts_reports_service_objectSpread({}, mediaOptions, {}, pieChartSmallSizeSettings)
      }, {
        option: options
      }];
      return responsiveOptions;
    }
  }]);

  return EchartsReportsService;
}();

defineProperty_default()(echarts_reports_service_EchartsReportsService, "$inject", ['durationFilter']);

angular.module('xlrelease').service('EchartsReportsService', echarts_reports_service_EchartsReportsService);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/reports/duration-filter.js
var duration_filter = __webpack_require__(933);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/reports/most-recent-releases-report.js
var most_recent_releases_report = __webpack_require__(934);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/reports/phase-duration.js
var phase_duration = __webpack_require__(935);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/reports/release-efficiency.js
var release_efficiency = __webpack_require__(936);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/reports/release-number-report.js

angular.module('xlrelease').directive('releaseNumberReport', ['reportConfigurationService', function (reportConfigurationService) {
  return function (scope, element) {
    scope.$watch('reports.numberOfReleasesPerMonth.data', function (numberOfReleasesPerMonth) {
      if (element.highcharts()) {
        element.highcharts().destroy();
      }

      if (numberOfReleasesPerMonth && numberOfReleasesPerMonth.length) {
        var categories = _.map(_.map(numberOfReleasesPerMonth, 'x'), function (date) {
          return moment(date).format("MMMM YYYY");
        });

        var data = _.map(numberOfReleasesPerMonth, 'y');

        element.highcharts(reportConfigurationService.getHighchartsOptions({
          tooltip: {
            enabled: false
          },
          legend: {
            enabled: false
          },
          xAxis: {
            categories: categories
          },
          yAxis: {
            title: {
              text: 'Number'
            },
            min: 0
          },
          series: [{
            type: 'column',
            name: 'Number',
            data: data,
            dataLabels: {
              enabled: true,
              color: colors["a" /* default */].white,
              align: 'center',
              y: 30
            }
          }]
        }));
      }
    });
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/reports/report-configuration-service.js
var report_configuration_service = __webpack_require__(937);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/reports/report-container-directive.js
var report_container_directive = __webpack_require__(938);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/reports/reports-controller.js




var reports_controller_ReportsController = /*#__PURE__*/function () {
  function ReportsController($scope, TagsService, $location, ReportsService, filterSettings, Events, ClientSettings, DateService, durationFilter, $state, TaskDefinitionsService) {
    classCallCheck_default()(this, ReportsController);

    this.scope = $scope;
    this.ClientSettings = ClientSettings;
    this.Events = Events;
    this.DateService = DateService;
    this.durationFilter = durationFilter;
    this.ReportsService = ReportsService;
    this.TagsService = TagsService;
    this.state = $state;
    this.TaskDefinitionsService = TaskDefinitionsService;
    $scope.filters = filterSettings;
    $scope.reportType = $location.path().substring(1);
    $scope.allTags = [];
    $scope.exportReport = ReportsService.exportReport;
    $scope.goToRelease = this.goToRelease.bind(this);
    $scope.formatDuration = this.formatDuration.bind(this);
    $scope.getTaskNameByType = this.getTaskNameByType.bind(this);
    ReportsService.setFilterSettings(filterSettings);
  }

  createClass_default()(ReportsController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;

      this.scope.$on(this.Events.filters.filterChanged, function (evt, filters) {
        _this.loadReports();

        _this.ClientSettings.setReportsFilters(filters);
      });
      this.loadTaskDefinitions();
      this.loadTags();
      this.loadReports();
    }
  }, {
    key: "formatDuration",
    value: function formatDuration(durationInMs) {
      return this.DateService.getReportDuration(durationInMs);
    }
  }, {
    key: "goToRelease",
    value: function goToRelease(params, data) {
      var release = data[params.dataIndex];

      if (release && release.releaseId) {
        this.state.go('release', {
          releaseId: release.releaseId
        });
      }
    }
  }, {
    key: "loadReports",
    value: function loadReports() {
      this.ReportsService.loadReports(this.scope.reportType);
      this.scope.reports = this.ReportsService.getReports();
    }
  }, {
    key: "loadTags",
    value: function loadTags() {
      var _this2 = this;

      this.TagsService.getArchivedReleaseTags().then(function (tags) {
        _this2.scope.allTags = tags;
      });
    }
  }, {
    key: "loadTaskDefinitions",
    value: function loadTaskDefinitions() {
      var _this3 = this;

      this.TaskDefinitionsService.getTaskDefinitions().then(function (resp) {
        _this3.scope.taskDefinitions = _.reduce(resp.data, function (result, value) {
          result[value.typeName] = _.omit(value, 'typeName');
          return result;
        }, {});
      });
    }
  }, {
    key: "getTaskNameByType",
    value: function getTaskNameByType(taskType) {
      var taskDefs = this.scope.taskDefinitions;
      var isDefExist = angular.isDefined(taskDefs) && angular.isDefined(taskDefs[taskType]);
      return isDefExist ? "".concat(taskDefs[taskType].displayGroup, ": ").concat(taskDefs[taskType].displayName) : taskType;
    }
  }]);

  return ReportsController;
}();

defineProperty_default()(reports_controller_ReportsController, "$inject", ['$scope', 'TagsService', '$location', 'ReportsService', 'filterSettings', 'Events', 'ClientSettings', 'DateService', 'durationFilter', '$state', 'TaskDefinitionsService']);

angular.module('xlrelease').controller('ReportsController', reports_controller_ReportsController);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/reports/reports-service.js
var reports_service = __webpack_require__(939);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/reports/tile-container.js
var tile_container = __webpack_require__(940);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/security/display-permission-filter.js
var display_permission_filter = __webpack_require__(941);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/security/forbidden-access-controller.js
var forbidden_access_controller = __webpack_require__(942);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/security/forbidden-access-service.js
var forbidden_access_service = __webpack_require__(943);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/security/limited-users-service.js
var limited_users_service = __webpack_require__(944);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/security/permissions-constants.js
var permissions_constants = __webpack_require__(97);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/security/permissions-controller.js



(function () {
  var PermissionsController = /*#__PURE__*/function () {
    function PermissionsController($scope, Backend, MemberType, displayPermissionFilter, ConfirmLeaveService, Events) {
      classCallCheck_default()(this, PermissionsController);

      this._$scope = $scope;
      this._Backend = Backend;
      this._MemberType = MemberType;
      this._displayPermissionFilter = displayPermissionFilter;
      this._ConfirmLeaveService = ConfirmLeaveService;
      this._Events = Events;
      this._roles = null;
      this._permissionsTableColumns = null;
      this._permissionsContainer = null;
      this._lastSavedDate = null;
      this._dirty = false;

      this._loadPermissions();
    }

    createClass_default()(PermissionsController, [{
      key: "save",
      value: function save() {
        var _this = this;

        var permissionsContainer = this._roles.map(function (role) {
          return {
            role: role,
            permissions: _this._permissionsContainer.filter(function (permission) {
              return permission.roles.find(function (r) {
                return role.name === r.name;
              });
            }).map(function (permission) {
              return permission.value;
            })
          };
        });

        this._Backend.put('roles/permissions/global', permissionsContainer).then(function () {
          _this._lastSavedDate = moment().toDate();
          _this._dirty = false;

          _this._ConfirmLeaveService.disableConfirmation();

          _this._$scope.$emit(_this._Events.permission.refresh);
        });
      }
    }, {
      key: "reset",
      value: function reset() {
        this._loadPermissions();

        this._lastSavedDate = null;
        this._dirty = false;

        this._ConfirmLeaveService.disableConfirmation();
      }
    }, {
      key: "setDirty",
      value: function setDirty() {
        this._dirty = true;

        this._ConfirmLeaveService.requireConfirmation();
      }
    }, {
      key: "_loadPermissions",
      value: function _loadPermissions() {
        var _this2 = this;

        this._Backend.get('roles/permissions/global').then(function (resp) {
          var rolePermissionsView = resp.data;
          _this2._roles = rolePermissionsView.rolePermissions.map(function (rolePermission) {
            return rolePermission.role;
          });
          _this2._permissionsTableColumns = [{
            title: 'Action',
            key: 'action'
          }, {
            title: 'Roles',
            key: 'roles',
            suggestionData: _this2._roles.map(function (role) {
              return {
                name: role.name,
                type: _this2._MemberType.ROLE
              };
            }),
            type: _this2._MemberType.ROLE
          }];
          _this2._permissionsContainer = rolePermissionsView.permissions.filter(function (permission) {
            return _this2._displayPermissionFilter(permission);
          }).map(function (permission) {
            return {
              action: _this2._displayPermissionFilter(permission).label,
              value: permission,
              description: _this2._displayPermissionFilter(permission).description,
              roles: rolePermissionsView.rolePermissions.filter(function (rolePermission) {
                return rolePermission.permissions.includes(permission);
              }).map(function (rolePermission) {
                return {
                  name: rolePermission.role.name,
                  type: _this2._MemberType.ROLE
                };
              })
            };
          });
        });
      }
    }, {
      key: "permissionsTableColumns",
      get: function get() {
        return this._permissionsTableColumns;
      }
    }, {
      key: "permissionsContainer",
      get: function get() {
        return this._permissionsContainer;
      }
    }, {
      key: "lastSavedDate",
      get: function get() {
        return this._lastSavedDate;
      }
    }, {
      key: "dirty",
      get: function get() {
        return this._dirty;
      }
    }]);

    return PermissionsController;
  }();

  PermissionsController.$inject = ['$scope', 'Backend', 'MemberType', 'displayPermissionFilter', 'ConfirmLeaveService', 'Events'];
  angular.module('xlrelease').controller('PermissionsController', PermissionsController);
})();
// EXTERNAL MODULE: ./core/xlr-ui/app/js/security/roles-service.js
var roles_service = __webpack_require__(945);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/security/task-access-controller.js


var task_access_controller_injectParams = ['Backend', 'RolesService', 'ConfirmLeaveService'];

var task_access_controller_TaskAccessController = /*#__PURE__*/function () {
  function TaskAccessController(Backend, RolesService, ConfirmLeaveService) {
    var _this = this;

    classCallCheck_default()(this, TaskAccessController);

    this._Backend = Backend;
    this._RolesService = RolesService;
    this._ConfirmLeaveService = ConfirmLeaveService;
    this._taskAccesses = [];
    this._taskAccessesMaster = [];
    this._groupedTaskAccesses = [];

    this._RolesService.getRoleNames().then(function (roleNames) {
      _this._roleNames = roleNames.data;
    });

    this._loadTaskAccesses();
  }

  createClass_default()(TaskAccessController, [{
    key: "_loadTaskAccesses",
    value: function _loadTaskAccesses() {
      var ctx = this;

      this._Backend.get('tasks/types-access').then(function (resp) {
        var taskAccesses = resp.data;
        ctx._groupedTaskAccesses = _.groupBy(taskAccesses, function (taskAccess) {
          return taskAccess.taskGroup;
        });
        ctx._taskAccesses = taskAccesses;
        ctx._taskAccessesMaster = angular.copy(taskAccesses);
      });
    }
  }, {
    key: "save",
    value: function save() {
      var ctx = this;

      ctx._Backend.put('tasks/types-access', ctx._taskAccesses).then(function () {
        ctx._loadTaskAccesses();

        ctx._lastSavedDate = moment().toDate();

        ctx._ConfirmLeaveService.disableConfirmation();
      });
    }
  }, {
    key: "isUnchanged",
    value: function isUnchanged() {
      return angular.equals(this._taskAccesses, this._taskAccessesMaster);
    }
  }, {
    key: "reset",
    value: function reset() {
      var _this2 = this;

      // works much faster than copying the entire object
      _.forEach(this._taskAccesses, function (task, i) {
        task.allowedToAll = _this2._taskAccessesMaster[i].allowedToAll;
        task.roles = angular.copy(_this2._taskAccessesMaster[i].roles);
      });

      this._ConfirmLeaveService.disableConfirmation();
    }
  }, {
    key: "onCheckboxAllowToAllChange",
    value: function onCheckboxAllowToAllChange(taskAccess) {
      if (taskAccess.allowedToAll) {
        taskAccess.roles = [];
      }
    }
  }, {
    key: "groupedTaskAccesses",
    get: function get() {
      return this._groupedTaskAccesses;
    }
  }, {
    key: "allRoles",
    get: function get() {
      return this._roleNames;
    }
  }, {
    key: "lastSavedDate",
    get: function get() {
      return this._lastSavedDate;
    }
  }]);

  return TaskAccessController;
}();

task_access_controller_TaskAccessController.$inject = task_access_controller_injectParams;
angular.module('xlrelease').controller('taskAccessController', task_access_controller_TaskAccessController);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/security/users-controller.js
var users_controller = __webpack_require__(946);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/security/users-service.js




function users_service_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function users_service_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { users_service_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { users_service_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

angular.module('xlrelease').factory('UsersService', ['Backend', 'MemberType', '$q', function (Backend, MemberType, $q) {
  var _this = this;

  var ADMINISTRATOR = 'admin';

  function isUserNameAdmin(user) {
    return user && user.toLowerCase() === ADMINISTRATOR;
  }

  this.mapUsersToObject = function (usersList) {
    return usersList.map(function (o) {
      return {
        name: o.username,
        fullName: o.fullName,
        type: MemberType.PRINCIPAL
      };
    });
  };

  return {
    isUserNameAdmin: isUserNameAdmin,
    isInternalUser: function isInternalUser(user) {
      return user.external === false;
    },
    getAllUsers: function getAllUsers() {
      return Backend.get('users/names');
    },
    getAllUsersAsObjects: function getAllUsersAsObjects() {
      return Backend.get('users/names').then(function (v) {
        return v.data;
      }).then(_this.mapUsersToObject);
    },
    getAllUsersAsObject: function getAllUsersAsObject() {
      return Backend.get('users/names').then(function (v) {
        return v.data.reduce(function (acc, user) {
          return users_service_objectSpread({}, acc, defineProperty_default()({}, user.username, user));
        }, {});
      });
    }
  };
}]);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/settings/general-settings-controller.js




function general_settings_controller_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function general_settings_controller_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { general_settings_controller_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { general_settings_controller_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

angular.module('xlrelease').controller('generalSettingsController', ['$scope', 'MetadataService', 'CIManager', 'ValueStreamMapping', 'PollingSettings', 'ConfirmLeaveService', 'PhaseColors', 'Page', 'UploadService', 'ContentTypeService', function ($scope, MetadataService, CIManager, ValueStreamMapping, PollingSettings, ConfirmLeaveService, PhaseColors, Page, UploadService, ContentTypeService) {
  var _reportsSettingsCICopy = {};
  var _pollingSettingsCICopy = {};
  var _themeSettingsCICopy = {};
  var _customLogoSettingsCICopy = {};
  var _pluginCICopies = {};
  $scope.UploadService = UploadService;
  UploadService.reset();
  $scope.pluginsInitialized = false;
  $scope.pluginSettings = [{
    title: 'Track changes in template version control',
    help: 'Release will use these settings to enable automatic versioning of template edits. Settings will take effect after 1 minute.',
    descriptorType: 'xlrelease.TemplateVersioningSettings',
    isPresent: false,
    ciManagerSettings: {
      type: 'TemplateVersioningSettings',
      directory: 'Configuration/settings'
    }
  }];
  $scope.pluginCIs = {};
  $scope.allowedContentType = "";

  _initPluginsSettings();

  _initContentTypes();

  $scope.PhaseColors = PhaseColors;

  var _reportsSettingsSaveCallback = function _reportsSettingsSaveCallback() {
    ValueStreamMapping.refreshReportsSettings();
    _reportsSettingsCICopy = angular.copy($scope.reportsSettings.ci);
  };

  var _pollingSettingsSaveCallback = function _pollingSettingsSaveCallback() {
    PollingSettings.refresh();
    _pollingSettingsCICopy = angular.copy($scope.pollingSettings.ci);
  };

  var _themeSettingsSaveCallback = function _themeSettingsSaveCallback() {
    return _themeSettingsCICopy = angular.copy($scope.themeSettings.ci);
  };

  var _customLogoSettingsDeleteCallback = function _customLogoSettingsDeleteCallback() {
    _customLogoSettingsCICopy = angular.copy($scope.customLogoSettings.ci);
    Page.applyCustomLogo(false);
  };

  $scope.reportsSettings = new CIManager({
    type: 'ReportsSettings',
    directory: 'Configuration/reports',
    saveCallback: _reportsSettingsSaveCallback
  });
  $scope.pollingSettings = new CIManager({
    type: 'PollingSettings',
    directory: 'Configuration/settings',
    saveCallback: _pollingSettingsSaveCallback
  });
  $scope.auditReportSettings = new CIManager({
    type: 'AuditReportSettings',
    directory: 'Configuration/settings'
  });
  $scope.archivingSettings = new CIManager({
    type: 'ArchivingSettings',
    directory: 'Configuration/settings'
  });
  $scope.themeSettings = new CIManager({
    type: 'ThemeSettings',
    directory: 'Configuration/settings',
    saveCallback: _themeSettingsSaveCallback
  });
  $scope.customLogoSettings = new CIManager({
    type: 'CustomLogoSettings',
    directory: 'Configuration/settings',
    deleteCallback: _customLogoSettingsDeleteCallback
  });
  $scope.archivingSettingsAge = 0;
  $scope.archivingSettingsAgeCopy = $scope.archivingSettingsAge;
  $scope.archivingSettingsAgeUnit = 'Days';
  $scope.auditReportRetentionPeriod = 0;
  $scope.$watch('archivingSettings.ci.releaseAgeToDeleteFromJcr', function (hours) {
    _setArchiving(hours);
  });
  $scope.$watch('auditReportSettings.ci.reportsRetentionPeriod', function (days) {
    _setAuditReport(days);
  });

  $scope.setHeaderColor = function (color) {
    $scope.themeSettings.ci.headerAccentColor = color;
  };

  $scope.changeUnitType = function () {
    if ($scope.archivingSettingsAgeUnit === 'Days') {
      $scope.archivingSettingsAge = Math.round($scope.archivingSettingsAge / 24);
    } else {
      $scope.archivingSettingsAge = $scope.archivingSettingsAge * 24;
    }
  };

  function convertAgeToHours() {
    if ($scope.archivingSettingsAgeUnit === 'Days') {
      $scope.archivingSettings.ci.releaseAgeToDeleteFromJcr = 24 * $scope.archivingSettingsAge;
    } else {
      $scope.archivingSettings.ci.releaseAgeToDeleteFromJcr = $scope.archivingSettingsAge;
    }
  }

  $scope.save = function () {
    UploadService.reset();

    _setArchivingCI();

    _setAuditReportsCI();

    $scope.reportsSettings.save();
    $scope.pollingSettings.save();
    $scope.archivingSettings.save();
    $scope.themeSettings.save();
    $scope.auditReportSettings.save();

    _savePluginSettings();

    if ($scope.file) {
      $scope.upload();
    } else if (angular.isDefined(_customLogoSettingsCICopy.filename) && angular.isUndefined($scope.customLogoSettings.ci.filename)) {
      $scope.customLogoSettings.deleteCi();
    }

    $scope.lastSavedDate = moment().toDate();
    ConfirmLeaveService.disableConfirmation();
    Page.applyTheme($scope.themeSettings.ci);
  };

  $scope.customLogoAddedCallback = function (result) {
    $scope.file = null;
    $scope.customLogoSettings.ci = result;
    _customLogoSettingsCICopy = angular.copy($scope.customLogoSettings.ci);
    Page.applyCustomLogo(true);
  };

  $scope.isCustomLogoImageUndefined = function () {
    return angular.isUndefined($scope.customLogoSettings.ci.filename) && (angular.isUndefined($scope.file) || $scope.file === null || $scope.file === '');
  };

  $scope.getProperty = function (ciManager, propertyName) {
    if (ciManager.type) {
      return _.find(ciManager.type.properties, {
        name: propertyName
      });
    }

    return null;
  };

  $scope.reset = function () {
    $scope.reportsSettings.ci = angular.copy(_reportsSettingsCICopy);
    $scope.pollingSettings.ci = angular.copy(_pollingSettingsCICopy);
    $scope.themeSettings.ci = angular.copy(_themeSettingsCICopy);
    $scope.customLogoSettings.ci = angular.copy(_customLogoSettingsCICopy);
    $scope.file = null;
    UploadService.reset();

    _resetPluginSettings();

    _setArchiving($scope.archivingSettings.ci.releaseAgeToDeleteFromJcr);

    _setAuditReport($scope.auditReportSettings.ci.reportsRetentionPeriod);

    ConfirmLeaveService.disableConfirmation();
  };

  $scope.isUnchanged = function () {
    return angular.equals(_reportsSettingsCICopy, $scope.reportsSettings.ci) && angular.equals(_pollingSettingsCICopy, $scope.pollingSettings.ci) && angular.equals(_themeSettingsCICopy, $scope.themeSettings.ci) && angular.equals(_customLogoSettingsCICopy, $scope.customLogoSettings.ci) && (angular.isUndefined($scope.file) || $scope.file === null || $scope.file === "") && _isPluginSettingsUnchanged() && angular.equals($scope.archivingSettingsAgeCopy, $scope.archivingSettings.ci.releaseAgeToDeleteFromJcr) && angular.equals($scope.auditReportRetentionPeriod, $scope.auditReportSettings.ci.reportsRetentionPeriod);
  };

  $scope.removeLoadedImage = function () {
    UploadService.reset();
    $scope.customLogoSettings.ci = {};
    $scope.file = null;
  };

  $scope.$watch('reportsSettings.ciLoaded', function (newVal) {
    if (newVal) {
      _reportsSettingsCICopy = angular.copy($scope.reportsSettings.ci);
    }
  });
  $scope.$watch('pollingSettings.ciLoaded', function (newVal) {
    if (newVal) {
      _pollingSettingsCICopy = angular.copy($scope.pollingSettings.ci);
    }
  });
  $scope.$watch('themeSettings.ciLoaded', function (newVal) {
    if (newVal) {
      _themeSettingsCICopy = angular.copy($scope.themeSettings.ci);
    }
  });
  $scope.$watch('customLogoSettings.ciLoaded', function (newVal) {
    if (newVal) {
      _customLogoSettingsCICopy = angular.copy($scope.customLogoSettings.ci);
    }
  });
  $scope.$watch('auditReportSettings.ciLoaded', function (newVal) {
    if (newVal) {
      $scope.auditReportRetentionPeriod = angular.copy($scope.auditReportSettings.ci.reportsRetentionPeriod);
    }
  });
  $scope.$watch('archivingSettingsAge', function (newVal) {
    $scope.archivingSettingsAgeCopy = _convertAgeToHours(newVal, $scope.archivingSettingsAgeUnit);
  });

  var _setArchivingCI = function _setArchivingCI() {
    $scope.archivingSettings.ci.releaseAgeToDeleteFromJcr = _convertAgeToHours($scope.archivingSettingsAge, $scope.archivingSettingsAgeUnit);
  };

  var _setAuditReportsCI = function _setAuditReportsCI() {
    $scope.auditReportSettings.ci.reportsRetentionPeriod = $scope.auditReportRetentionPeriod;
  };

  var _convertAgeToHours = function _convertAgeToHours(archivingSettingsAge, archivingSettingsAgeUnit) {
    if (archivingSettingsAgeUnit === 'Days') {
      return archivingSettingsAge * 24;
    }

    return archivingSettingsAge;
  };

  var _setArchiving = function _setArchiving(hours) {
    if (!_.isUndefined(hours)) {
      if (hours % 24 === 0) {
        $scope.archivingSettingsAgeUnit = 'Days';
        $scope.archivingSettingsAge = hours / 24;
      } else {
        $scope.archivingSettingsAgeUnit = 'Hours';
        $scope.archivingSettingsAge = hours;
      }
    }
  };

  var _setAuditReport = function _setAuditReport(days) {
    if (!_.isUndefined(days)) {
      $scope.auditReportRetentionPeriod = angular.copy(days);
    }
  };

  function _initPluginsSettings() {
    $scope.pluginSettings.forEach(function (plugin) {
      MetadataService.isTypePresent(plugin.descriptorType).then(function (isPresent) {
        if (isPresent) {
          plugin.isPresent = isPresent;
          $scope.pluginCIs[plugin.descriptorType] = new CIManager(general_settings_controller_objectSpread({
            saveCallback: function saveCallback() {
              return _pluginCICopies[plugin.descriptorType] = angular.copy($scope.pluginCIs[plugin.descriptorType].ci);
            },
            loadCallback: function loadCallback(ci) {
              _pluginCICopies[plugin.descriptorType] = angular.copy(ci);
            }
          }, plugin.ciManagerSettings));
        }
      });
    });
  }

  function _savePluginSettings() {
    $scope.pluginSettings.filter(function (plugin) {
      return plugin.isPresent;
    }).forEach(function (plugin) {
      $scope.pluginCIs[plugin.descriptorType].save();
    });
  }

  function _resetPluginSettings() {
    $scope.pluginSettings.filter(function (plugin) {
      return plugin.isPresent;
    }).forEach(function (plugin) {
      $scope.pluginCIs[plugin.descriptorType].ci = angular.copy(_pluginCICopies[plugin.descriptorType]);
    });
  }

  function _isPluginSettingsUnchanged() {
    return $scope.pluginSettings.filter(function (plugin) {
      return plugin.isPresent;
    }).every(function (plugin) {
      return angular.equals(_pluginCICopies[plugin.descriptorType], $scope.pluginCIs[plugin.descriptorType].ci);
    });
  }

  function _initContentTypes() {
    ContentTypeService.getContentTypesForImage().then(function (resp) {
      $scope.allowedContentType = resp.data.toString();
    });
  }
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/toastrFactory.js
var toastrFactory = __webpack_require__(51);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/smtp/smtp-controller.js



angular.module('xlrelease').controller('SmtpController', ['$scope', '$parse', 'Backend', 'CIManager', 'UserProfile', 'ConfirmLeaveService', function ($scope, $parse, Backend, CIManager, UserProfile, ConfirmLeaveService) {
  var init = function init() {
    var ciManager = new CIManager({
      type: 'SmtpServer',
      directory: 'Configuration/mail',
      saveCallback: function saveCallback() {
        return ConfirmLeaveService.disableConfirmation();
      }
    });

    if (!ciManager.ci.testAddress) {
      UserProfile.load().then(function (profile) {
        ciManager.ci.testAddress = profile.email;
      });
    }

    return ciManager;
  };

  $scope.smtp = init();
  var toaster = Object(toastrFactory["a" /* default */])();

  $scope.testConfiguration = function () {
    $scope.isBusy = true;
    $scope.smtp.ci.type = 'xlrelease.SmtpServer';
    $scope.smtp.ci.id = 'Configuration/mail/SmtpServer';
    var URL = 'settings/smtp/checkConfig';
    Backend.post(URL, $scope.smtp.ci).then(function (resp) {
      if (resp) {
        toaster.success("Successfully sent the notification");
      }
    }).finally(function () {
      $scope.isBusy = false;
    });
  };

  $scope.invalidTestAddress = function (testAddress) {
    if (testAddress) {
      return testAddress.length === 0;
    } else return true;
  };
}]);
// EXTERNAL MODULE: ./node_modules/copy-text-to-clipboard/index.js
var copy_text_to_clipboard = __webpack_require__(231);
var copy_text_to_clipboard_default = /*#__PURE__*/__webpack_require__.n(copy_text_to_clipboard);

// CONCATENATED MODULE: ./core/xlr-ui/app/features/groovy/dsl-template-controller.js




var dsl_template_controller_DslTemplateController = /*#__PURE__*/function () {
  function DslTemplateController(Page, releasePromise, Backend, Ids, Download, Toastr, renderAsTemplate) {
    classCallCheck_default()(this, DslTemplateController);

    this.release = releasePromise.data;
    this.Ids = Ids;
    this.Backend = Backend;
    this.Download = Download;
    this.Toastr = Toastr;
    this.templateDsl = "";
    this.renderAsTemplate = renderAsTemplate;
    Page.setReleaseOpened(this.release);
  }

  createClass_default()(DslTemplateController, [{
    key: "$onInit",
    value: function $onInit() {
      this.loadDsl();
    }
  }, {
    key: "loadDsl",
    value: function loadDsl() {
      var _this = this;

      this.Backend.get(this.getExportUrl(true, this.renderAsTemplate)).then(function (response) {
        return _this.templateDsl = response.data;
      });
    }
  }, {
    key: "exportDsl",
    value: function exportDsl() {
      this.Download.launch(this.getExportUrl(false, true));
    }
  }, {
    key: "getExportUrl",
    value: function getExportUrl() {
      var preview = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      var renderAsTemplate = arguments.length > 1 ? arguments[1] : undefined;
      return "api/v1/dsl".concat(preview ? '/preview' : '/export', "/").concat(this.Ids.toDomainId(this.release.id), "?exportTemplate=").concat(renderAsTemplate);
    }
  }, {
    key: "copyDsl",
    value: function copyDsl() {
      copy_text_to_clipboard_default()(this.templateDsl);
      this.Toastr.success('Releasefile was copied to the clipboard!', {
        preventDuplicates: true
      });
    }
  }]);

  return DslTemplateController;
}();


dsl_template_controller_DslTemplateController.$inject = ['Page', 'releasePromise', 'Backend', 'Ids', 'Download', 'Toastr', 'renderAsTemplate'];
// CONCATENATED MODULE: ./core/xlr-ui/app/features/groovy/dsl-tpl.html
/* harmony default export */ var dsl_tpl = ("<div release-flow-header>\n    <div class=\"buttons\">\n        <a ng-click=\"$ctrl.exportDsl()\" class=\"button\">Export</a>\n        <span doc-icon=\"xfile.html\"></span>\n    </div>\n</div>\n<div class=\"content-under-header\">\n    <div class=\"form-horizontal\">\n        <div class=\"form-group\">\n            <div class=\"col-sm-6\">\n                <label class=\"radio-inline\" style=\"padding-left: 0\">\n                    Generate as:\n                </label>\n                <label class=\"radio-inline\">\n                    <input type=\"radio\" ng-value=\"true\" ng-model=\"$ctrl.renderAsTemplate\" ng-change=\"$ctrl.loadDsl()\">Template\n                </label>\n                <label class=\"radio-inline\">\n                    <input type=\"radio\" ng-value=\"false\" ng-model=\"$ctrl.renderAsTemplate\" ng-change=\"$ctrl.loadDsl()\">Release\n                </label>\n            </div>\n            <div class=\"col-sm-6\">\n                <a ng-click=\"$ctrl.copyDsl()\" class=\"button btn-copy pull-right\">\n                    <i class=\"menu-item-icon copy-icon\"></i> Copy to clipboard\n                </a>\n            </div>\n        </div>\n    </div>\n\n    <div id=\"dsl-content\" ng-if=\"$ctrl.templateDsl\" hljs hljs-source=\"$ctrl.templateDsl\" hljs-language=\"groovy\"></div>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/js/states.js



angular.module('xlrelease').config(['$urlMatcherFactoryProvider', '$stateProvider', '$urlRouterProvider', function ($urlMatcherFactoryProvider, $stateProvider, $urlRouterProvider) {
  // add this to have "pretty" URLs, by default UI Router encodes '/' to '~2F'
  $urlMatcherFactoryProvider.type('RiskProfileId', {
    raw: true
  }); // see https://stackoverflow.com/questions/29892353/angular-ui-router-resolve-state-from-url/30926025#30926025

  $stateProvider.decorator('parent', function (internalStateObj, parentFn) {
    internalStateObj.self.$$state = function () {
      return internalStateObj;
    };

    return parentFn(internalStateObj);
  });
  $stateProvider.state('login', {
    url: '/login?reloadUserDetails',
    templateUrl: 'partials/login/login.html',
    controller: 'LoginController',
    resolve: {
      configuration: ['Backend', function (Backend) {
        return Backend.get("server/configuration").then(function (response) {
          return response.data;
        });
      }],
      auth: ['Backend', 'Authenticator', '$stateParams', 'ClientSettings', function (Backend, Authenticator, $stateParams, ClientSettings) {
        if (Authenticator.isAuthenticated() && !$stateParams.reloadUserDetails) {
          // FIXME: Tech debt from LoginController: should always call logout.
          return Authenticator.logout();
        }

        delete $stateParams.reloadUserDetails;
        return Authenticator.tryLoginByIdentityProvider().then(function () {
          if (!ClientSettings.getIdentityProvider()) {
            return Authenticator.logout();
          }
        });
      }]
    }
  }).state('tasks', {
    url: '/tasks',
    reloadOnSearch: false,
    templateUrl: 'partials/tasks/tasks.html',
    controller: 'TasksController',
    resolve: {
      filterSettings: ['Filters', function (Filters) {
        return Filters.getTasksFilterSettings();
      }]
    }
  }).state('task', {
    url: '/tasks/:taskId?showDetails',
    templateUrl: 'partials/tasks/task.html',
    controller: 'TaskController'
  }).state('releaseCreate', {
    url: '/releases/create?fromTemplateId',
    template: '<release-properties release="$resolve.release"></release-properties>',
    resolve: {
      release: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        if ($stateParams.fromTemplateId) {
          return ReleasesService.initNewReleaseFromTemplate($stateParams.fromTemplateId);
        } else {
          return ReleasesService.initNewRelease();
        }
      }]
    }
  }).state('release', {
    url: '/releases/:releaseId',
    templateUrl: 'partials/releases/release-editor.html',
    controller: 'releaseEditorController',
    resolve: {
      release: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId).then(function (response) {
          return response.data;
        });
      }]
    }
  }).state('releasePlanner', {
    url: '/releases/:releaseId/planner',
    templateUrl: 'partials/releases/gantt/gantt.html',
    controller: 'GanttController',
    resolve: {
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId);
      }]
    }
  }).state('releaseTable', {
    url: '/releases/:releaseId/table',
    templateUrl: 'partials/releases/grid/release-grid.html',
    controller: 'releaseGridController',
    controllerAs: 'pageCtrl',
    resolve: {
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId);
      }]
    }
  }).state('releasePermissions', {
    url: '/{page:releases|templates}/:releaseId/{optional:permissions|teams}',
    templateUrl: 'partials/releases/release-permissions.html',
    controller: 'releasePermissionsController',
    controllerAs: '$ctrl',
    resolve: {
      release: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId).then(function (response) {
          return response.data;
        });
      }],
      teams: ['$stateParams', 'TeamsService', function ($stateParams, TeamsService) {
        return TeamsService.getTeams($stateParams.releaseId).then(function (response) {
          return response.data;
        });
      }],
      users: ['UsersService', function (UsersService) {
        return UsersService.getAllUsersAsObjects();
      }],
      roles: ['RolesService', function (RolesService) {
        return RolesService.getRoles();
      }]
    }
  }).state('releaseProperties', {
    url: '/releases/:releaseId/properties',
    template: '<release-properties release="$resolve.release"></release-properties>',
    resolve: {
      release: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getReleaseWithVariables($stateParams.releaseId);
      }]
    }
  }).state('releaseVariables', {
    url: '/releases/:releaseId/variables',
    templateUrl: 'partials/releases/release-variables.html',
    controller: 'releaseVariablesController',
    resolve: {
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId);
      }]
    }
  }).state('releasePageExtension', {
    url: '/releases/:releaseId/:extensionPath',
    templateUrl: 'partials/releases/release-page-extension-container.html',
    controller: 'releasePageExtensionController',
    controllerAs: 'releasePageExtensionCtrl',
    resolve: {
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getReleaseWithDependencies($stateParams.releaseId);
      }]
    }
  }).state('templates', {
    url: '/templates',
    reloadOnSearch: false,
    templateUrl: 'partials/templates/templates.html',
    controller: 'TemplatesController',
    resolve: {
      filters: ['Filters', function (Filters) {
        return Filters.getTemplatesFilterSettings();
      }]
    }
  }).state('templateCreate', {
    url: '/templates/create',
    template: '<template-properties template="$resolve.template"></template-properties>',
    resolve: {
      template: ['ReleasesService', function (ReleasesService) {
        return ReleasesService.initNewTemplate();
      }]
    }
  }).state('template', {
    url: '/templates/:releaseId',
    templateUrl: 'partials/releases/release-editor.html',
    controller: 'releaseEditorController',
    resolve: {
      release: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId).then(function (response) {
          return response.data;
        });
      }]
    }
  }).state('templateTable', {
    url: '/templates/:releaseId/table',
    templateUrl: 'partials/releases/grid/release-grid.html',
    controller: 'releaseGridController',
    controllerAs: 'pageCtrl',
    resolve: {
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId);
      }]
    }
  }).state('templateProperties', {
    url: '/templates/:releaseId/properties',
    template: '<template-properties template="$resolve.template"></template-properties>',
    resolve: {
      template: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getReleaseWithVariables($stateParams.releaseId);
      }]
    }
  }).state('templateVariables', {
    url: '/templates/:releaseId/variables',
    templateUrl: 'partials/releases/release-variables.html',
    controller: 'releaseVariablesController',
    resolve: {
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId);
      }]
    }
  }).state('templatePlanner', {
    url: '/templates/:releaseId/planner',
    templateUrl: 'partials/releases/gantt/gantt.html',
    controller: 'GanttController',
    resolve: {
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId);
      }]
    }
  }).state('templateDsl', {
    url: '/templates/:releaseId/releasefile?renderAsTemplate',
    params: {
      renderAsTemplate: "false"
    },
    controller: dsl_template_controller_DslTemplateController,
    controllerAs: '$ctrl',
    template: dsl_tpl,
    resolve: {
      renderAsTemplate: ['$stateParams', function ($stateParams) {
        return $stateParams.renderAsTemplate === "true";
      }],
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId);
      }]
    }
  }).state('templatePageExtension', {
    url: '/templates/:releaseId/:extensionPath',
    templateUrl: 'partials/releases/release-page-extension-container.html',
    controller: 'releasePageExtensionController',
    controllerAs: 'releasePageExtensionCtrl',
    resolve: {
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getReleaseWithDependencies($stateParams.releaseId);
      }]
    }
  }).state('profile', {
    url: '/profile',
    templateUrl: 'partials/profile/profile.html',
    controller: 'ProfileController',
    controllerAs: '$ctrl'
  }).state('users', {
    url: '/users',
    templateUrl: 'partials/security/users.html',
    controller: 'UsersController',
    controllerAs: 'users'
  }).state('permissions', {
    url: '/permissions',
    templateUrl: 'partials/security/permissions.html',
    controller: 'PermissionsController',
    controllerAs: '$ctrl'
  }).state('taskAccess', {
    url: '/task-access',
    templateUrl: 'partials/security/task-access.html',
    controller: 'taskAccessController',
    controllerAs: '$pageCtrl'
  }).state('generalSettings', {
    url: '/general-settings',
    templateUrl: 'partials/settings/general-settings.html',
    controller: 'generalSettingsController'
  }).state('globalVariables', {
    url: '/global-variables',
    templateUrl: 'partials/variables/global-variables.html',
    controller: 'globalVariablesController'
  }).state('calendar', {
    url: '/calendar',
    reloadOnSearch: false,
    templateUrl: 'partials/calendar/calendar.html',
    controller: 'CalendarController',
    resolve: {
      filterSettings: ['Filters', function (Filters) {
        return Filters.getCalendarFilterSettings();
      }],
      month: ['CalendarResolver', function (CalendarResolver) {
        return CalendarResolver.initCurrentMonth();
      }]
    }
  }).state('reports', {
    url: '/reports',
    reloadOnSearch: false,
    templateUrl: 'partials/reports/dashboard.html',
    controller: 'ReportsController',
    resolve: {
      filterSettings: ['Filters', function (Filters) {
        return Filters.getReportsFiltersSettings();
      }]
    }
  }).state('releaseValueStream', {
    url: '/release-value-stream',
    permissions: [permissions_constants["b" /* GlobalPermissions */].VIEW_REPORTS],
    reloadOnSearch: false,
    templateUrl: 'partials/value-stream-mapping/release-value-stream.html',
    controller: 'releaseValueStreamController',
    resolve: {
      filterSettings: ['Filters', function (Filters) {
        return Filters.getReleaseValueStreamFilterSettings();
      }]
    }
  }).state('smtp', {
    url: '/smtp',
    templateUrl: 'partials/smtp/smtp.html',
    controller: 'SmtpController'
  }).state('riskSettings', {
    url: '/risks',
    params: {
      edit: null
    },
    templateUrl: 'partials/risks/risk-settings.html',
    controller: 'riskSettingsController',
    controllerAs: 'ctrl'
  }).state('riskProfile', {
    url: '/risks/riskProfile/{riskProfileId:RiskProfileId}',
    templateUrl: 'partials/risks/risk-profile/risk-profile.html',
    controller: 'riskProfileController',
    controllerAs: 'ctrl'
  }).state('configuration', {
    url: '/configuration',
    permissions: [permissions_constants["b" /* GlobalPermissions */].ADMINISTRATOR, permissions_constants["b" /* GlobalPermissions */].AUDIT_ALL],
    templateUrl: 'partials/configuration/configuration.html'
  }).state('forbiddenAccess', {
    url: '/forbidden-access',
    templateUrl: 'partials/server-error/forbidden-access.html',
    controller: 'forbiddenAccessController'
  }).state('invalidLicense', {
    url: '/invalid-license',
    templateUrl: 'partials/licenses/invalid-license.html',
    controller: 'LicenseController'
  }).state('default', {
    url: '/default',
    template: '<div></div>',
    controller: 'defaultRouteController'
  }).state('mainMenuExtensions', {
    templateUrl: 'partials/index/main-menu-extension-container.html',
    controller: 'mainMenuExtensionController',
    controllerAs: 'vm'
  });
  $urlRouterProvider.when(/(^$|\/$)/, '/default').otherwise(function ($injector) {
    var $state = $injector.get('$state');
    $state.go('mainMenuExtensions', {}, {
      location: false,
      reload: true
    });
  });
}]).run(['$rootScope', '$state', 'Authenticator', 'Events', 'RedirectOnLoginService', function ($rootScope, $state, Authenticator, Events, RedirectOnLoginService) {
  $rootScope.$on('$stateChangeError', function (event, toState, toParams, fromState) {
    if (fromState && fromState.name === 'login') {
      $state.go('releaseOverview');
    }
  });
  $rootScope.$on('$stateChangeStart', function (event, toState) {
    if (toState && !['login', 'loginSpnego', 'default'].includes(toState.name) && !Authenticator.isAuthenticated()) {
      // if user is not logged in, we should redirect to login page instead of "not authorized" page
      event.preventDefault(); // save toState url into RedirectOnLoginService.redirectOnLoginURL

      RedirectOnLoginService.registerRequestedURL();
      return Authenticator.loadUserDetailsByAuth().catch(function () {
        $state.go('login');
      });
    }

    if (toState.permissions) {
      var hasAny = Authenticator.hasAnyOfPermissions(toState.permissions);

      if (!hasAny) {
        event.preventDefault();
        var errorMessage = "Permission ".concat(toState.permissions, " is not granted to you");
        $rootScope.$emit(Events.permission.forbidden, errorMessage);
      }
    }
  });
}]);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/tags/tags-service.js



var tags_service_TagsService = /*#__PURE__*/function () {
  function TagsService(Backend) {
    classCallCheck_default()(this, TagsService);

    this._Backend = Backend;
  }

  createClass_default()(TagsService, [{
    key: "getReleaseTags",
    value: function getReleaseTags() {
      return this._Backend.get('releases/tags').then(function (response) {
        return response.data;
      });
    }
  }, {
    key: "getArchivedReleaseTags",
    value: function getArchivedReleaseTags() {
      return this._Backend.get('releases/tags/archived').then(function (response) {
        return response.data;
      });
    }
  }]);

  return TagsService;
}();

tags_service_TagsService.$inject = ['Backend'];
angular.module('xlrelease').service('TagsService', tags_service_TagsService);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/assignee-directive.js
var assignee_directive = __webpack_require__(947);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/component/facet-form-component.js





function facet_form_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function facet_form_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { facet_form_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { facet_form_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var facet_form_component_FacetFormController = /*#__PURE__*/function () {
  function FacetFormController(FacetsService) {
    classCallCheck_default()(this, FacetFormController);

    this.FacetsService = FacetsService;
  }

  createClass_default()(FacetFormController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;

      this.facetTemplateUrl = '';
      this.selectedType = null;

      if (!this.facet) {
        this.facet = {};
      } else {
        this.selectedType = this.facet.type;

        this._fetchFacetProperties();
      }

      this.facetTypeNames = this.facetTypes.filter(function (facet) {
        return !_this.FacetsService.isImmutable(_this.facetTypes.find(function (t) {
          return t.type === facet.type;
        }));
      }).map(function (t) {
        return {
          id: t.type,
          title: t.label
        };
      });
    }
  }, {
    key: "onFacetTypeChange",
    value: function onFacetTypeChange() {
      if (this.readonly) {
        return;
      }

      this.facet = {
        id: this.facet.id,
        targetId: this.facet.targetId
      };

      this._fetchFacetProperties();
    }
  }, {
    key: "_fetchFacetProperties",
    value: function _fetchFacetProperties() {
      var _this2 = this;

      var facetType = this.facetTypes.find(function (t) {
        return t.type === _this2.selectedType;
      });
      this.facet.type = this.selectedType;
      this.facetSelected = facetType.properties.filter(function (prop) {
        return prop.name === 'configurationUri';
      })[0];
      this.facetTemplateUrl = "static/9.7.16/".concat(this.facetSelected.default || 'include/Facets/dip-facet-config.html');

      if (!this.facetSelected.default) {
        this.facetPropertyDefinitions = _.filter(facetType.properties, function (p) {
          return p.category === 'input' && p.hidden !== true;
        });
        this.facetProperties = this._expandProperties(this.facet, this.facetPropertyDefinitions);
      }
    }
  }, {
    key: "onFormSubmit",
    value: function onFormSubmit() {
      if (this.readonly) {
        return;
      }

      if (this.facetProperties) {
        this._collapseProperties(this.facet, this.facetProperties);
      }

      if (!this.facet.id) {
        this.facet.id = '-1';
      }

      this.onSubmit({
        facet: facet_form_component_objectSpread({}, this.facet)
      });
    }
  }, {
    key: "_expandProperties",
    value: function _expandProperties(ci, definitions) {
      return definitions.reduce(function (properties, prop) {
        properties[prop.name] = {
          value: ci[prop.name],
          variable: (ci.variableMapping || {})[prop.name]
        };
        return properties;
      }, {});
    }
  }, {
    key: "_collapseProperties",
    value: function _collapseProperties(ci, properties) {
      var _this3 = this;

      Object.entries(properties).forEach(function (_ref) {
        var _ref2 = slicedToArray_default()(_ref, 2),
            name = _ref2[0],
            variableOrValue = _ref2[1];

        if (variableOrValue && _.isObject(variableOrValue)) {
          ci[name] = variableOrValue.value;

          var propDef = _this3.facetPropertyDefinitions.find(function (p) {
            return p.name === name;
          });

          if (propDef && propDef.kind === "DATE") {
            ci[name] = new Date(variableOrValue.value);
          }

          ci.variableMapping = ci.variableMapping || {};

          if (variableOrValue.variable) {
            ci.variableMapping[name] = variableOrValue.variable;
          } else {
            delete ci.variableMapping[name];
          }
        } else {
          ci[name] = variableOrValue;
        }
      });
    }
  }]);

  return FacetFormController;
}();

defineProperty_default()(facet_form_component_FacetFormController, "$inject", ['FacetsService']);

var FacetFormComponent = {
  bindings: {
    facet: '<',
    facetTypes: '<',
    onCancel: '&',
    onSubmit: '&',
    readonly: '<',
    variables: '<',
    resolvedVariables: '<',
    onNewVariable: '&'
  },
  controller: facet_form_component_FacetFormController,
  templateUrl: 'partials/tasks/details/component/facet-form-component.html'
};
angular.module('xlrelease').component('facetForm', FacetFormComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/component/task-icon-component.js



var task_icon_component_template = "\n    <!--Core tasks-->\n    <i ng-if=\"$ctrl.TasksService.isUserInputTask($ctrl.task)\" class=\"xl-icon keyboard-icon\" title=\"User Input\"></i>\n    <i ng-if=\"$ctrl.TasksService.isNotificationTask($ctrl.task)\" class=\"xl-icon mail-icon\" title=\"Notification\"></i>\n    <i ng-if=\"$ctrl.TasksService.isScriptTask($ctrl.task)\" class=\"xl-icon script-icon\" title=\"Script\"></i>\n    <i ng-if=\"$ctrl.TasksService.isGateTask($ctrl.task)\" class=\"xl-icon check-icon\" title=\"Gate\"></i>\n    <i ng-if=\"$ctrl.TasksService.isParallelGroup($ctrl.task)\" class=\"xl-icon parallel-icon\" title=\"Parallel Group\"></i>\n    <i ng-if=\"$ctrl.TasksService.isSequentialGroup($ctrl.task)\" class=\"xl-icon sequential-icon\" title=\"Sequential Group\"></i>\n    <i ng-if=\"$ctrl.TasksService.isCreateReleaseTask($ctrl.task)\" class=\"xl-icon add-icon\" title=\"Create Release\"></i>\n    \n    <!--Manual task-->\n    <i ng-if=\"$ctrl.TasksService.isManualTask($ctrl.task) && $ctrl.taskOwner\" class=\"xl-icon user-icon\" title=\"Manual\"></i>\n    <i ng-if=\"$ctrl.TasksService.isManualTask($ctrl.task) && !$ctrl.taskOwner\" class=\"xl-icon users-icon\" title=\"Manual\"></i>\n    \n    <!--Custom script tasks-->\n    <i ng-if=\"$ctrl.TasksService.isCustomScriptTask($ctrl.task) && !$ctrl.task.customIconLocation && !$ctrl.task.customIconClass\" class=\"xl-icon script-icon\"></i>\n    <i ng-if=\"$ctrl.TasksService.isCustomScriptTask($ctrl.task) && $ctrl.task.customIconClass\" class=\"xl-icon {{$ctrl.task.customIconClass}}\"></i>\n    <i ng-if=\"$ctrl.TasksService.isCustomScriptTask($ctrl.task) && $ctrl.task.customIconLocation && !$ctrl.task.customIconClass\" class=\"custom-script-image\">\n      <img ng-src=\"static/9.7.16/{{ $ctrl.task.customIconLocation }}\">\n    </i>\n";

var task_icon_component_TaskIconController = /*#__PURE__*/function () {
  function TaskIconController(TasksService) {
    classCallCheck_default()(this, TaskIconController);

    this.TasksService = TasksService;
  }

  createClass_default()(TaskIconController, [{
    key: "$onInit",
    value: function $onInit() {
      this.task = {
        type: this.taskType,
        taskOwner: this.taskOwner,
        customIconLocation: this.customIconLocation,
        customIconClass: this.customIconClass
      };
    }
  }]);

  return TaskIconController;
}();

defineProperty_default()(task_icon_component_TaskIconController, "$inject", ['TasksService']);

var TaskIconComponent = {
  bindings: {
    taskType: '<',
    taskOwner: '<',
    customIconLocation: '<',
    customIconClass: '<'
  },
  controller: task_icon_component_TaskIconController,
  template: task_icon_component_template
};
angular.module('xlrelease').component('taskIcon', TaskIconComponent);
// EXTERNAL MODULE: ./core/xlr-ui/app/features/common/services/http.js
var http = __webpack_require__(15);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/create-release-details-controller.js





function create_release_details_controller_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function create_release_details_controller_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { create_release_details_controller_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { create_release_details_controller_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }


var DEFAULT_RISK_PROFILE_ID = "Configuration/riskProfiles/RiskProfileDefault";
var CHANGE_TEMPLATE_MSGS = {
  default: 'Are you sure you want to change the template to "${targetTemplate}"?',
  noPermission: 'You do not have the permissions required to revert this change. Are you sure you want to select "${targetTemplate}"?',
  variableChanged: 'Template variables have been changed. Are you sure you want to select "${targetTemplate}"?',
  blank: 'Are you sure you want to remove this template from the task?',
  blankVarChanged: 'Template variables have been changed. Are you sure you want to remove this template from the task?',
  both: 'Template variables have been changed and reverting this template will not be possible. Are you sure you want to select "${targetTemplate}"?'
}; // TODO: check text

var CHANGE_FOLDER_MSGS = {
  default: 'Are you sure you want to change the folder to "${targetFolderTitle}"?',
  noPermission: "You won't be able to select the previously selected folder again since you lack permissions"
};
var EMPTY_VARIABLES = [];

var create_release_details_controller_CreateReleaseDetailsController = /*#__PURE__*/function () {
  function CreateReleaseDetailsController($scope, $q, $timeout, TemplatesService, Backend, VariablesService, TasksService, FoldersService, Ids) {
    var _this = this;

    classCallCheck_default()(this, CreateReleaseDetailsController);

    defineProperty_default()(this, "updateSelectedFolder", function (folder) {
      if (_this._selectedFolder.id) {
        var selected = _this._findFolderById(folder.selectedId, _this._folders, 1000);

        if (selected) {
          _this._newSelectedFolder = selected;
          _this._showFolderConfirmation = true;

          _this.$scope.$apply(function () {
            return _this._showFolderConfirmation;
          });
        }
      } else {
        _this._selectedFolder = _this._findFolderById(folder.selectedId, _this._folders, 1000);
        _this.folderId = _this._selectedFolder.id;

        _this.$scope.$apply(function () {
          return _this.folderId;
        });
      }
    });

    this._propertiesWithVars = ['templateVariables[]', 'startRelease'];
    this.$scope = $scope;
    this.TemplatesService = TemplatesService;
    this.Backend = Backend;
    this.VariablesService = VariablesService;
    this.TasksService = TasksService;
    this.$q = $q;
    this.$timeout = $timeout;
    this.FoldersService = FoldersService;
    this.Ids = Ids;
    this._templates = [];
    this._riskProfiles = [];
    this._folders = [];
    this.templateVariablesPending = 0; // prevent tree-select component from rendering until this._folders is actually populated

    this.foldersReady = false;
    this._templateVariablesLoading = false;
    this._release = $scope.release;
    this._task = $scope.task;

    if (!this._task.releaseTags) {
      this._task.releaseTags = [];
    }
  }

  createClass_default()(CreateReleaseDetailsController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      this._readOnly = !this.TasksService.canEditTaskConfigurationPropertiesAndTaskNotInProgress(this._release, this._task);
      this._selectedTemplateHasPermission = true;
      this._variableChanged = false;
      this._showTemplateConfirmation = false;
      this.hiddenVariables = false;
      this.hasTemplateViewPermission = true;
      this.templateVariables = [];
      var templateIdIsFromVariable = this.VariablesService.containsOnlyVariable(this._task.templateId);
      var templateIdIsFromValue = !templateIdIsFromVariable;
      this.$scope.$watchCollection(function () {
        return _this2.$scope.allVariables;
      }, function (allVariables) {
        if (allVariables) {
          _this2.templateVariables = allVariables.filter(function (v) {
            return !v.key.startsWith('release.');
          });

          if (templateIdIsFromVariable) {
            // need allVariables loaded for this
            _this2.setTemplateIdAsVariable(_this2._task.templateId, _this2._task.variables);
          }
        }
      });
      this._changeTemplateMsg = CHANGE_TEMPLATE_MSGS.default;
      this._changeFolderConfirmationMsg = CHANGE_FOLDER_MSGS.default;
      this._selectedFolder = {
        id: this._task.folderId,
        title: this._task.folderId ? this.Ids.getName(this._task.folderId) : "",
        enabled: false
      };
      this._newSelectedFolder = undefined;
      this._showFolderConfirmation = false;

      this._expandTask(this._task);

      this._fetchTemplates().then(function () {
        _this2._selectedTemplate = {
          variable: undefined,
          value: undefined
        };

        if (templateIdIsFromVariable) {
          _this2.setTemplateIdAsVariable(_this2._task.templateId, _this2._task.variables);
        } else {
          // find template by its (unique) id, disregarding the folder it's in:
          var id = _this2.Ids.getName(_this2.Ids.toDomainId(_this2._task.templateId));

          var templateWithTitle = id ? _.find(_this2._templates, function (t) {
            return t.id.endsWith(id);
          }) : undefined;

          if (id && angular.isUndefined(templateWithTitle)) {
            _this2._fetchTemplateById(id).then(function (template) {
              templateWithTitle = template;

              _this2._setTemplateDescription(templateWithTitle, id);
            });
          } else {
            _this2._setTemplateDescription(templateWithTitle, id);
          }
        }
      });

      this._fetchRiskProfiles().then(function () {
        var profile = _this2._getSelectedRiskProfile(_this2._riskProfiles);

        _this2._selectedRiskProfile = profile;
        _this2._task.riskProfileId = profile && profile.id;
      });

      if (!this._readOnly && templateIdIsFromValue) {
        this._fetchTemplateVariables(this._task.templateId).then(function (vars) {
          if (vars) {
            _this2._processVariables(vars);

            _this2._originalVariables = _.cloneDeep(vars);
          }
        });
      }

      this._createListHandlers(); // this one is used to indicate that user have clicked "inherit the value from template" icon or link


      this.resetCounter = {};

      var stubFolder = function stubFolder(folderName) {
        return {
          id: folderName,
          title: folderName,
          type: 'xlrelease.Folder',
          children: [],
          stub: true,
          enabled: false
        };
      };

      var stubFolderTree = function stubFolderTree(path) {
        if (path && path.length > 0) {
          var root = _.head(path);

          if (root.stub && root.stub === true) {
            root.id = 'Applications/' + root.id;
          }

          var curr = root;

          _.forEach(_.tail(path), function (segment) {
            if (curr.stub && curr.stub === true) {
              segment.id = curr.id + '/' + segment.id;
            }

            if (curr.stub && curr.stub === true || segment.stub && segment.stub === true) {
              curr.children.push(segment);
            }

            curr = segment;
          });

          return root;
        } else {
          return undefined;
        }
      }; // preparing a stub structure from the task.folderId populated with fake folders


      this._path = _.map(this._task.folderId ? this.Ids.noApplications(this._task.folderId).split('/') : [], function (folderName) {
        return stubFolder(folderName);
      }); // combine folder tree from server with our stub path

      var resolvePath = function resolvePath(folder) {
        var depth = _this2.Ids.folderDepth(folder.id); // if it might fall into the depth of our task.folderId path...


        if (_this2._path.length >= depth) {
          var segment = _this2._path[depth]; // and it matches one of our stub segment...

          if (segment && segment.id === _this2.Ids.getName(folder.id)) {
            // update the stub with the real thing.
            _this2._path[depth] = folder;

            _.forEach(folder.children, function (child) {
              return resolvePath(child);
            });

            return depth === 0;
          }
        }

        return false;
      }; // fetch all the folders this user can see from the server.
      // Note that this set might be very different for each user and especially for the script user of this release.


      this.FoldersService.list().then(function (result) {
        var foundFirstLevelFolder = false;
        var folders = [];

        _.forEach(result.data, function (folder) {
          // try to see if one of the folders is part of the task.folderId path...
          foundFirstLevelFolder = resolvePath(folder) || foundFirstLevelFolder;
          folders.push(folder);
        }); // still missing some part of the full path?


        if (_.filter(_this2._path, {
          stub: true
        }).length > 0) {
          var root = stubFolderTree(_this2._path);

          if (!foundFirstLevelFolder) {
            // ah, the selected folder is inside a first level folder we cannot see!
            if (root) {
              // let's add the stub-mixed-with-the-real-thing to the list of folders...
              folders.push(root);
            }
          }
        }

        if (_this2._task.folderId) {
          _this2._selectedFolder = _this2._findFolderById(_this2._task.folderId, folders, 1000);
        }

        _this2._folders = folders;
        _this2.foldersReady = true;

        _this2._fetchFolder();
      });
    }
  }, {
    key: "_fetchTemplates",
    value: function _fetchTemplates(matchTitle) {
      var _this3 = this;

      return this.TemplatesService.getAllIds(matchTitle).then(function (templates) {
        _this3._templates = _.reject(templates.data.cis, {
          id: _this3.release.id
        });
        return _this3._templates;
      });
    }
  }, {
    key: "_fetchTemplateById",
    value: function _fetchTemplateById(templateId) {
      return this.TemplatesService.getTemplateTitleById(templateId).then(function (template) {
        return _.head(template.data.cis, {
          id: templateId
        });
      }).catch(function (err) {
        if (err.status === http["a" /* httpCodes */].FORBIDDEN) {
          return undefined;
        }
      });
    }
  }, {
    key: "_setTemplateDescription",
    value: function _setTemplateDescription(templateWithTitle, id) {
      // if not found it might be either deleted or user has no permission.
      this.hasTemplateViewPermission = templateWithTitle ? true : false;
      var templateWithId = {
        id: this._task.templateId,
        title: id
      };
      this._selectedTemplate.value = templateWithTitle || templateWithId;
    }
  }, {
    key: "_fixTaskFolder",
    value: function _fixTaskFolder() {
      var _this4 = this;

      var parentFolder = this.Ids.getParentFolderIdFrom(this._task.id);

      if (parentFolder) {
        var folderId = "Applications/".concat(this.Ids.getName(parentFolder));
        this.FoldersService.get(folderId).then(function (folder) {
          if (_this4._selectedFolder) {
            _this4._selectedFolder.enabled = true;
          } else {
            _this4._selectedFolder = folder;
          }

          _this4.folderTitle = folder.title;
          _this4.folderId = folder.id;
        });
      }
    }
  }, {
    key: "_fetchFolder",
    value: function _fetchFolder() {
      var _this5 = this;

      if (this._task.folderId) {
        this.FoldersService.getSilent(this._task.folderId).then(function (folder) {
          if (_this5.folderId !== folder.id) {
            _this5._selectedFolder.enabled = folder.enabled;
            _this5.folderTitle = folder.title;
            _this5.folderId = folder.id;
          }
        }).catch(function (err) {
          // for 403 'forbidden', we should keep the original folderId as it was likely set by someone else
          if (err.status === 404 && !_this5._release.archived) {
            _this5._fixTaskFolder();
          } else {
            if (_this5._selectedFolder) {
              _this5._selectedFolder.enabled = false;
            } else {
              _this5._selectedFolder = {
                id: _this5._task.folderId,
                title: _this5.Ids.getName(_this5._task.folderId),
                enabled: false
              };
            }
          }
        });
      } else {
        this._fixTaskFolder();
      }
    }
  }, {
    key: "_findFolderById",
    value: function _findFolderById(folderId, folders, maxDepth) {
      if (maxDepth <= 0) {
        return undefined;
      }

      var found = _.find(folders, {
        id: folderId
      });

      if (!found) {
        var allTheChildren = _.flatMap(folders, function (folder) {
          return folder.children;
        });

        return this._findFolderById(folderId, allTheChildren, maxDepth - 1);
      } else {
        return found;
      }
    }
  }, {
    key: "_fetchRiskProfiles",
    value: function _fetchRiskProfiles() {
      var _this6 = this;

      return this.Backend.get('api/v1/risks/profiles').then(function (response) {
        return _this6._riskProfiles = response.data;
      });
    }
  }, {
    key: "_fetchTemplateVariables",
    value: function _fetchTemplateVariables(templateId) {
      var _this7 = this;

      if (templateId) {
        this._templateVariablesLoading = true;
        return this.VariablesService.getReleaseVariables(templateId, {
          dontRedirectWhenForbidden: true,
          hideAlertOnCodes: [403, 404, 500]
        }).then(function (r) {
          _this7.hiddenVariables = false;
          _this7._templateVariablesLoading = false;
          return r.data;
        }).catch(function (err) {
          if ([403].includes(err.status)) {
            _this7._selectedTemplateHasPermission = false;
            _this7._changeTemplateMsg = CHANGE_TEMPLATE_MSGS.noPermission;
            _this7.hiddenVariables = true;
            _this7._templateVariablesLoading = false;
          }
        });
      }

      var deferred = this.$q.defer();
      deferred.resolve([]);
      return deferred.promise;
    }
  }, {
    key: "_processVariables",
    value: function _processVariables(vars) {
      this._expandTask(this._task);

      var templateVariables = vars;
      var taskVariables = this.variables;
      this.variables = _(templateVariables).filter(function (templateVariable) {
        return !!templateVariable.showOnReleaseStart;
      }).map(function (templateVariable) {
        templateVariable.id = '';
        templateVariable.inherited = true;

        var taskVariable = _.find(taskVariables, {
          key: templateVariable.key,
          type: templateVariable.type
        });

        var omitted = ['valueProvider'];

        if (taskVariable && taskVariable.inherited) {
          omitted.push('value');
        }

        return create_release_details_controller_objectSpread({}, templateVariable, {}, _.omit(taskVariable, omitted));
      }).value();
      return this.variables;
    }
  }, {
    key: "_expandTask",
    value: function _expandTask(task) {
      var variableMapping = _.mapKeys(task.variableMapping, function (value, key) {
        return _.includes(key, 'templateVariables') ? _.trim(key, '.value') : key;
      });

      this._expandedTask = this.VariablesService.expandProperties(_.mapKeys(task, function (value, key) {
        return key.replace('variables', 'templateVariables');
      }), variableMapping, this._propertiesWithVars);
      this._expandedTask.createdReleaseId = {
        variable: task.createdReleaseId,
        value: null
      };
    }
  }, {
    key: "_updateTaskFromExpandedTask",
    value: function _updateTaskFromExpandedTask(task, expandedTask) {
      var transformTemplateVarsToTaskVars = function transformTemplateVarsToTaskVars(variable) {
        var newTaskVariable = _.omit(variable, '$token');

        if (_.has(variable, 'valueProvider')) {
          newTaskVariable = create_release_details_controller_objectSpread({}, newTaskVariable, {
            'valueProvider': variable.valueProvider.id
          });
        }

        return newTaskVariable;
      };

      var _this$VariablesServic = this.VariablesService.collapseProperties(expandedTask, this._propertiesWithVars),
          _this$VariablesServic2 = slicedToArray_default()(_this$VariablesServic, 2),
          collapsedTask = _this$VariablesServic2[0],
          variableMapping = _this$VariablesServic2[1];

      task.variables = this.hiddenVariables ? this._task.variables : collapsedTask.templateVariables.map(transformTemplateVarsToTaskVars);
      task.startRelease = collapsedTask.startRelease;
      task.variableMapping = _.mapKeys(variableMapping, function (value, key) {
        return _.includes(key, 'templateVariables') ? key + '.value' : key;
      });
      task.createdReleaseId = this._expandedTask.createdReleaseId.variable;
    }
  }, {
    key: "_createListHandlers",
    value: function _createListHandlers() {
      var _this8 = this;

      var templateAutocompleteHandler = function templateAutocompleteHandler(term) {
        var deferred = _this8.$q.defer();

        var result = _this8._fetchTemplates(term);

        deferred.resolve(result);
        return deferred.promise;
      };

      var riskAutocompleteHandler = function riskAutocompleteHandler(items, term) {
        var deferred = _this8.$q.defer();

        var candidates = _.filter(items, function (item) {
          return item.title.includes(term);
        });

        deferred.resolve(candidates);
        return deferred.promise;
      };

      this._templateListHandlers = {
        addCandidates: function addCandidates(metadata, options) {
          return templateAutocompleteHandler(options.term);
        },
        onSelect: function onSelect(newTemplate) {
          return _this8._onTemplateValueSelect(newTemplate);
        },
        removeElement: function removeElement() {
          return _this8._onTemplateValueRemove();
        }
      };
      this._riskProfileListHandlers = {
        addCandidates: function addCandidates(metadata, options) {
          return riskAutocompleteHandler(_this8._riskProfiles, options.term);
        }
      };
    }
  }, {
    key: "_getSelectedRiskProfile",
    value: function _getSelectedRiskProfile(riskProfiles) {
      var selected;

      if (this._task.riskProfileId) {
        selected = _.find(riskProfiles, {
          id: this._task.riskProfileId
        });

        if (selected) {
          return selected;
        }
      }

      var syntheticValue = this._release.syntheticProperties && this._release.syntheticProperties.riskProfile;

      if (syntheticValue) {
        selected = _.find(riskProfiles, {
          id: syntheticValue
        });

        if (selected) {
          return selected;
        }
      }

      return _.find(riskProfiles, {
        id: DEFAULT_RISK_PROFILE_ID
      });
    }
  }, {
    key: "updateReleaseTags",
    value: function updateReleaseTags(tags) {
      this.releaseTags = tags;
      this.saveTask();
    }
  }, {
    key: "saveTask",
    value: function saveTask() {
      var _this9 = this;

      this._variableChanged = false;

      this._updateTaskFromExpandedTask(this._task, this._expandedTask);

      return this.TasksService.updateTask(this._task).then(function (resp) {
        var savedTask = resp.data; // update task variables

        _this9._task.variables = savedTask.variables; // update expanded task variables and set them to non-initial state

        savedTask.variables.forEach(function (updatedVariable) {
          return _.assign(_.find(_this9.variables, {
            key: updatedVariable.key
          }), _.omit(updatedVariable, 'valueProvider'));
        });
      });
    }
  }, {
    key: "createVariable",
    value: function createVariable(name, variableType, createdCallback, isRequired) {
      if (isRequired) {
        this.$scope.createRequiredVariable(this._task, name, variableType, createdCallback);
      } else {
        this.$scope.createOptionalVariable(this._task, name, variableType, createdCallback);
      }
    }
  }, {
    key: "connectToInheritDefaultValue",
    value: function connectToInheritDefaultValue(variable) {
      if (variable) {
        var taskVariable = _.find(this.variables, {
          key: variable.key,
          type: variable.type
        });

        if (taskVariable) {
          taskVariable.inherited = true;

          var orig = this._originalVariables.find(function (o) {
            return o.key === variable.key;
          });

          if (orig) {
            taskVariable.value = orig.value;
          } else {
            taskVariable.value = undefined;
          }

          this.resetCounter[taskVariable.key] = (this.resetCounter[taskVariable.key] || 0) + 1;
          this.saveTask();
        }
      }
    }
  }, {
    key: "isTemplateFromVariable",
    value: function isTemplateFromVariable(template) {
      return angular.isDefined(template) && angular.isDefined(template.variable) && this.VariablesService.containsOnlyVariable(template.variable);
    }
  }, {
    key: "_isTemplateFromValue",
    value: function _isTemplateFromValue(template) {
      return angular.isDefined(template) && angular.isDefined(template.value) && template.value !== null;
    }
  }, {
    key: "getReleaseIdFromVariable",
    value: function getReleaseIdFromVariable(variableName) {
      var variable = this.allVariables.find(function (variable) {
        return variable.variableName === variableName;
      });

      if (angular.isDefined(variable) && angular.isDefined(variable.value) && variable.value.includes('Release')) {
        return this.Ids.toInternalId(variable.value);
      }

      return undefined;
    }
  }, {
    key: "setTemplateIdAsVariable",
    value: function setTemplateIdAsVariable(variableName, variables) {
      var _this10 = this;

      var templateId = this.getReleaseIdFromVariable(variableName);

      if (angular.isDefined(templateId)) {
        this._fetchTemplateVariables(templateId).then(function (vars) {
          _this10._processVariables(vars);

          _this10.saveTask();

          _this10._originalVariables = _.cloneDeep(vars);
        });
      } else {
        this._processVariables(variables);

        this.saveTask();
        this._originalVariables = _.cloneDeep(variables);
      }

      this.selectedTemplate = {
        variable: variableName,
        value: undefined
      };
    }
  }, {
    key: "_onTemplateValueSelect",
    value: function _onTemplateValueSelect(newValue) {
      this._newSelectedTemplate = {
        value: newValue,
        variable: undefined
      };

      if (this._task.templateId) {
        this.enableTemplateConfirmation();
      } else {
        this.confirmTemplateChange(false);
      }
    }
  }, {
    key: "onTemplateVariableChange",
    value: function onTemplateVariableChange() {
      if (this.isTemplateFromVariable(this._selectedTemplate)) {
        this.confirmTemplateChange(true);
      } else {
        //Switcher/Remove event
        this._resetAllTemplateValues();
      }
    }
  }, {
    key: "_onTemplateValueRemove",
    value: function _onTemplateValueRemove() {
      var _this11 = this;

      var currentSelectedValue = this._selectedTemplate.value;
      this.$timeout(function () {
        return _this11.selectedTemplate = {
          value: currentSelectedValue,
          variable: undefined
        };
      });
      this.enableTemplateConfirmation();
    }
  }, {
    key: "_resetAllTemplateValues",
    value: function _resetAllTemplateValues() {
      this._oldSelectedTemplate = {
        value: undefined,
        variable: undefined
      };
      this.selectedTemplate = {
        value: undefined,
        variable: undefined
      };
      this._newSelectedTemplate = {
        value: undefined,
        variable: undefined
      };
      this.confirmTemplateChange(true);
    }
  }, {
    key: "_getNewTemplateId",
    value: function _getNewTemplateId() {
      if (this.isTemplateFromVariable(this._newSelectedTemplate)) {
        return this._newSelectedTemplate.variable;
      } else if (this._isTemplateFromValue(this._newSelectedTemplate)) {
        return this._newSelectedTemplate.value.id;
      } else {
        return null;
      }
    }
  }, {
    key: "_getNewTemplateTitle",
    value: function _getNewTemplateTitle() {
      if (this.isTemplateFromVariable(this._newSelectedTemplate)) {
        return this._newSelectedTemplate.variable;
      } else if (this._isTemplateFromValue(this._newSelectedTemplate)) {
        return this._newSelectedTemplate.value.title;
      } else {
        return null;
      }
    }
  }, {
    key: "addNewVariable",
    value: function addNewVariable() {
      this.saveTask();
    }
  }, {
    key: "removeVariable",
    value: function removeVariable() {
      this.saveTask();
    }
  }, {
    key: "confirmTemplateChange",
    value: function confirmTemplateChange(fromVariable) {
      var _this12 = this;

      this._task.templateId = fromVariable ? this._selectedTemplate.variable : this._getNewTemplateId();

      if (fromVariable) {
        this.setTemplateIdAsVariable(this._task.templateId, []);
      } else {
        this._fetchTemplateVariables(this._task.templateId).then(function (vars) {
          _this12._processVariables(vars);

          _this12.saveTask();

          _this12._originalVariables = _.cloneDeep(vars);
        });
      }

      this._oldSelectedTemplate = fromVariable ? angular.copy(this._selectedTemplate) : this._newSelectedTemplate;
      this.selectedTemplate = fromVariable ? this._selectedTemplate : this._newSelectedTemplate;
      this._showTemplateConfirmation = false;
      this._changeTemplateMsg = CHANGE_TEMPLATE_MSGS.default;
      this._newSelectedTemplate = {
        value: undefined,
        variable: undefined
      };
      this.hasTemplateViewPermission = true;
      this.hiddenVariables = false;
    }
  }, {
    key: "cancelTemplateChange",
    value: function cancelTemplateChange() {
      var _this13 = this;

      var isTemplateFromBackend = false;

      if (this._isTemplateRestoreFromCurrent() || !this._oldSelectedTemplate.value.id) {
        this._oldSelectedTemplate = {
          value: _.find(this._templates, {
            id: this._task.templateId
          })
        };

        if (angular.isUndefined(this._oldSelectedTemplate.value)) {
          isTemplateFromBackend = true;
          var templateId = this.Ids.getName(this.Ids.toDomainId(this._task.templateId));

          this._fetchTemplateById(templateId).then(function (template) {
            _this13._oldSelectedTemplate = {
              value: template
            };

            _this13._setSelectedTemplate();
          });
        }
      }

      if (!isTemplateFromBackend) {
        this._setSelectedTemplate();
      }
    }
  }, {
    key: "_setSelectedTemplate",
    value: function _setSelectedTemplate() {
      if (!!this._oldSelectedTemplate.value) {
        this._selectedTemplate = angular.copy(this._oldSelectedTemplate);
      }

      this._newSelectedTemplate = undefined;
      this._showTemplateConfirmation = false;
    }
  }, {
    key: "_isTemplateRestoreFromCurrent",
    value: function _isTemplateRestoreFromCurrent() {
      return (!this._oldSelectedTemplate || !this._oldSelectedTemplate.value) && this._task.templateId;
    }
  }, {
    key: "confirmFolderChange",
    value: function confirmFolderChange() {
      this._selectedFolder = this._newSelectedFolder;
      this.folderId = this._selectedFolder.id;
      this._showFolderConfirmation = false;
    }
  }, {
    key: "cancelFolderChange",
    value: function cancelFolderChange() {
      this._newSelectedFolder = undefined;
      this._showFolderConfirmation = false;
      this.folderId = this._selectedFolder.id;
    } // view model
    // task properties

  }, {
    key: "enableTemplateConfirmation",
    value: function enableTemplateConfirmation() {
      var newMessage;

      if (this._variableChanged && this._selectedTemplateHasPermission) {
        newMessage = CHANGE_TEMPLATE_MSGS.variableChanged;
      } else if (this._variableChanged && !this._selectedTemplateHasPermission) {
        newMessage = CHANGE_TEMPLATE_MSGS.both;
      } else if (!this._selectedTemplateHasPermission) {
        newMessage = CHANGE_TEMPLATE_MSGS.noPermission;
      } else {
        newMessage = CHANGE_TEMPLATE_MSGS.default;
      }

      if (this._variableChanged) {
        this._changeTemplateMsg = this._getNewTemplateTitle() !== null ? newMessage.replace('${targetTemplate}', this._getNewTemplateTitle()) : CHANGE_TEMPLATE_MSGS.blankVarChanged;
      } else {
        this._changeTemplateMsg = this._getNewTemplateTitle() !== null ? newMessage.replace('${targetTemplate}', this._getNewTemplateTitle()) : CHANGE_TEMPLATE_MSGS.blank;
      }

      this._showTemplateConfirmation = true;
    }
  }, {
    key: "onVariableChanged",
    value: function onVariableChanged(variable) {
      var _this14 = this;

      var orig = this._originalVariables.find(function (o) {
        return o.key === variable.key;
      });

      if (orig && orig.value !== variable.value) {
        variable.inherited = false;
      }

      if (variable.value && variable.type === 'xlrelease.DateVariable') {
        variable.value = moment(variable.value).format();
      }

      this.saveTask().then(function () {
        if (orig && orig.value !== variable.value) {
          _this14._variableChanged = true;
        }
      });
    }
  }, {
    key: "newReleaseTitle",
    get: function get() {
      return this._task.newReleaseTitle;
    },
    set: function set(title) {
      this._task.newReleaseTitle = title;
      this.saveTask();
    }
  }, {
    key: "selectedTemplate",
    get: function get() {
      return this._selectedTemplate;
    },
    set: function set(template) {
      this._selectedTemplate = template;
    }
  }, {
    key: "changeTemplateErrorMsg",
    get: function get() {
      return this._changeTemplateMsg;
    }
  }, {
    key: "folderId",
    get: function get() {
      return this._task.folderId;
    },
    set: function set(folderId) {
      this._task.folderId = folderId;
      this._selectedFolder.id = folderId;
      this.saveTask();
    }
  }, {
    key: "folderTitle",
    get: function get() {
      return this._selectedFolder.title;
    },
    set: function set(folderTitle) {
      this._selectedFolder.title = folderTitle;
    }
  }, {
    key: "hiddenFolder",
    get: function get() {
      if (this._selectedFolder && this._selectedFolder.id) {
        return !this._selectedFolder.enabled;
      } else {
        return false;
      }
    }
  }, {
    key: "selectedRiskProfile",
    get: function get() {
      return this._selectedRiskProfile;
    },
    set: function set(profile) {
      this._selectedRiskProfile = profile;
      this._task.riskProfileId = profile && profile.id;
      this.saveTask();
    }
  }, {
    key: "variables",
    get: function get() {
      return this._templateVariablesLoading ? EMPTY_VARIABLES : this._expandedTask.templateVariables;
    },
    set: function set(vars) {
      return this._expandedTask.templateVariables = vars;
    }
  }, {
    key: "startRelease",
    get: function get() {
      return this._expandedTask.startRelease;
    },
    set: function set(startRelease) {
      this._expandedTask.startRelease = startRelease;
    }
  }, {
    key: "createdReleaseId",
    get: function get() {
      return this._expandedTask.createdReleaseId;
    },
    set: function set(createdReleaseId) {
      this._expandedTask.createdReleaseId = createdReleaseId;
    } // codelist properties

  }, {
    key: "readOnly",
    get: function get() {
      return this._readOnly;
    }
  }, {
    key: "readOnlyOrLocked",
    get: function get() {
      return this.readOnly || this.TasksService.isLocked(this._task);
    }
  }, {
    key: "showTemplateConfirmation",
    get: function get() {
      return this._showTemplateConfirmation;
    }
  }, {
    key: "showFolderConfirmation",
    get: function get() {
      return this._showFolderConfirmation;
    }
  }, {
    key: "changeFolderConfirmationMsg",
    get: function get() {
      return this._changeFolderConfirmationMsg.replace('${targetFolderTitle}', this._newSelectedFolder.title);
    }
  }, {
    key: "release",
    get: function get() {
      return this._release;
    }
  }, {
    key: "task",
    get: function get() {
      return this._task;
    }
  }, {
    key: "releaseVariables",
    get: function get() {
      return this._release.variables;
    }
  }, {
    key: "templateListHandlers",
    get: function get() {
      return this._templateListHandlers;
    }
  }, {
    key: "riskProfileListHandlers",
    get: function get() {
      return this._riskProfileListHandlers;
    }
  }, {
    key: "allVariables",
    get: function get() {
      return this.$scope.allVariables;
    }
  }, {
    key: "editableReleaseVariables",
    get: function get() {
      return this.$scope.editableReleaseVariables;
    }
  }, {
    key: "templates",
    get: function get() {
      return this._templates;
    }
  }, {
    key: "riskProfiles",
    get: function get() {
      return this._riskProfiles;
    }
  }, {
    key: "releaseTags",
    get: function get() {
      return this._task.releaseTags;
    },
    set: function set(value) {
      this._task.releaseTags = value;
    }
  }, {
    key: "folders",
    get: function get() {
      return this._folders;
    }
  }]);

  return CreateReleaseDetailsController;
}();

defineProperty_default()(create_release_details_controller_CreateReleaseDetailsController, "$inject", ['$scope', '$q', '$timeout', 'TemplatesService', 'Backend', 'VariablesService', 'TasksService', 'FoldersService', 'Ids']);

angular.module('xlrelease').controller('xlrelease.CreateReleaseDetailsController', create_release_details_controller_CreateReleaseDetailsController);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/dependencies-service.js





(function () {
  var DependenciesService = /*#__PURE__*/function () {
    function DependenciesService(Backend, $q, ReleasesStatusService) {
      classCallCheck_default()(this, DependenciesService);

      this.backend = Backend;
      this.$q = $q;
      this.releasesStatusService = ReleasesStatusService;
      this.cachedReleaseTreePromise = null;
      this.cachedReleaseId = null;
    }

    createClass_default()(DependenciesService, [{
      key: "getReleaseTree",
      value: function getReleaseTree(release) {
        if (this.releasesStatusService.isReleaseCompleted(release)) {
          var deferred = this.$q.defer();
          deferred.resolve(null);
          this.cachedReleaseTreePromise = deferred.promise;
        } else if (!this.cachedReleaseTreePromise || this.cachedReleaseId !== release.id) {
          this.cachedReleaseTreePromise = this.backend.get('dependencies/' + release.id + '/tree').then(function (result) {
            return result.data;
          });
        }

        this.cachedReleaseId = release.id;
        return this.cachedReleaseTreePromise;
      }
    }, {
      key: "clearCache",
      value: function clearCache() {
        this.cachedReleaseId = null;
        this.cachedReleaseTreePromise = null;
      }
    }]);

    return DependenciesService;
  }();

  DependenciesService.$inject = ['Backend', '$q', 'ReleasesStatusService'];
  angular.module('xlrelease').service('DependenciesService', DependenciesService);
})();
// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/display-with-separators.js
var display_with_separators = __webpack_require__(948);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/gate/gate-details-controller.js
var gate_details_controller = __webpack_require__(949);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/gate/gate-service.js



(function () {
  'use strict';

  var GateService = /*#__PURE__*/function () {
    function GateService($q, Backend) {
      classCallCheck_default()(this, GateService);

      this._$q = $q;
      this._Backend = Backend;
      this._dependencyTargetCandidatesCache = new Map();
    }

    createClass_default()(GateService, [{
      key: "fetchDependencyTargetCandidates",
      value: function fetchDependencyTargetCandidates(taskId) {
        var _this = this;

        return this._fetchData(function () {
          return _this._Backend.get("gates/".concat(taskId, "/dependency-target-candidates"));
        }, 'DEPENDENCY_TARGET_CANDIDATES');
      }
    }, {
      key: "fetchDependencyTargetCandidate",
      value: function fetchDependencyTargetCandidate(taskId, releaseId) {
        var _this2 = this;

        return this._fetchData(function () {
          return _this2._Backend.get("gates/".concat(taskId, "/dependency-target-candidates/").concat(releaseId));
        }, releaseId);
      }
    }, {
      key: "clearDependencyTargetCache",
      value: function clearDependencyTargetCache() {
        this._dependencyTargetCandidatesCache.clear();
      }
    }, {
      key: "getDependencies",
      value: function getDependencies(taskId) {
        return this._Backend.get("gates/".concat(taskId, "/dependencies")).then(function (response) {
          return response.data;
        });
      }
    }, {
      key: "getDependenciesTargetStatuses",
      value: function getDependenciesTargetStatuses(taskId) {
        return this._Backend.get("gates/".concat(taskId, "/dependency-target-statuses")).then(function (response) {
          return response.data;
        });
      } ////

    }, {
      key: "_fetchData",
      value: function _fetchData(call, cacheKey) {
        var _this3 = this;

        var deferred = this._$q.defer();

        if (this._dependencyTargetCandidatesCache.has(cacheKey)) {
          deferred.resolve(this._dependencyTargetCandidatesCache.get(cacheKey));
        } else {
          call().then(function (response) {
            var data = response.data;

            _this3._dependencyTargetCandidatesCache.set(cacheKey, data);

            deferred.resolve(data);
          });
        }

        return deferred.promise;
      }
    }]);

    return GateService;
  }();

  GateService.$inject = ['$q', 'Backend'];
  angular.module('xlrelease').service('GateService', GateService);
})();
// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/quick-task-generator-directive.js


function quick_task_generator_directive_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function quick_task_generator_directive_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { quick_task_generator_directive_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { quick_task_generator_directive_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

angular.module('xlrelease').directive('quickTaskGenerator', ['TaskDefinitionsService', function (TaskDefinitionsService) {
  function enableForm(scope) {
    scope.$apply(function () {
      scope.showForm = true;
    });
  }

  function submitTask(scope) {
    scope.$apply(function () {
      if (angular.isDefined(scope.title) && scope.title !== null && scope.title !== '') {
        var taskForm = {
          title: scope.title,
          taskType: scope.taskType
        };
        scope.addTask({
          taskForm: taskForm
        });
        scope.title = '';
      }
    });
  }

  function disableForm(scope) {
    scope.$apply(function () {
      scope.showForm = false;
      scope.title = '';
    });
  }

  return {
    templateUrl: 'partials/tasks/quick-task-generator.html',
    scope: {
      'addTask': '&',
      'taskDefinitions': '='
    },
    link: function link(scope, element) {
      scope.showForm = false;
      scope.title = '';

      scope.onSelect = function (item) {
        if (item) {
          scope.taskTypeName = getTaskTypeName(item.group, item.text);
          scope.taskType = item.id;
        }
      };

      scope.$watch('taskDefinitions', function (taskDefinitions) {
        if (!taskDefinitions) return;
        var groupedTaskDefs = TaskDefinitionsService.groupTaskDefinitions(taskDefinitions);

        _.forEach(groupedTaskDefs.groups, function (value, key) {
          _.remove(value, function (v) {
            return !v.isAllowed;
          });

          var founded = _.find(value, {
            isAllowed: true
          });

          if (!founded) {
            delete groupedTaskDefs.groups[key];
          }
        });

        scope.groupedTaskDefinitions = getGroupedTasks(groupedTaskDefs.groups);
        var defaultValue = groupedTaskDefs.defaultValue;
        scope.taskType = defaultValue && defaultValue.typeName;
        scope.taskTypeName = defaultValue ? getTaskTypeName(defaultValue.displayGroup, defaultValue.displayName) : null;

        if (!defaultValue) {
          scope.taskGeneratorDisabled = true;
        }
      });
      var input = element.find('input');
      element.find('.add-task').bind('click', function () {
        enableForm(scope);
        input.focus();
      });
      element.find('.add').bind('click', function () {
        submitTask(scope);
        input.focus();
      });
      element.find('.cancel').bind('click', function () {
        disableForm(scope);
      });
      input.bind('keyup', function (e) {
        if (e.which === 27) {
          // on escape
          disableForm(scope);
        }

        if (e.which === 13) {
          // on enter
          submitTask(scope);
          input.focus();
        }
      });
    }
  };
}]);
var topGroups = ['Core', 'Delivery', 'Script', 'Remote Script', 'Webhook'];

var getGroupedTasks = _.flow([convert, sort, addDivider(topGroups.length), applyItemTypes]);

function getTaskTypeName(groupName, taskName) {
  return "".concat(groupName, " > ").concat(taskName);
}

function addDivider(position) {
  return function (groupedTasks) {
    groupedTasks.splice(position, 0, {
      divider: true
    });
    return groupedTasks;
  };
}

function applyItemTypes(groupedTasks) {
  return groupedTasks.map(function (item) {
    return quick_task_generator_directive_objectSpread({}, item, {
      items: item.items && applyItemTypes(item.items),
      type: getItemType(item)
    });
  });
}

function getItemType(item) {
  if (item.items) {
    return 'submenu';
  }

  if (item.divider) {
    return 'divider';
  }

  return 'common';
}

function convert(groupedTasks) {
  return Object.keys(groupedTasks).map(function (key) {
    var tasks = groupedTasks[key];
    return {
      id: key,
      text: key,
      items: tasks.map(function (task) {
        return {
          id: task.typeName,
          text: task.displayName,
          group: key
        };
      })
    };
  });
}

function sort(groupedTasks) {
  return groupedTasks.sort(byGroupName(topGroups)).map(function (group) {
    return quick_task_generator_directive_objectSpread({}, group, {
      items: group.items.sort(byTaskType)
    });
  });
}

function byGroupName(topGroups) {
  return function (a, b) {
    var aIdx = topGroups.indexOf(a.text);
    var bIdx = topGroups.indexOf(b.text);

    if (aIdx > -1 && bIdx > -1) {
      return aIdx - bIdx;
    }

    if (aIdx > -1 && bIdx === -1) {
      return -1;
    }

    if (aIdx === -1 && bIdx > -1) {
      return 1;
    }

    if (a.text < b.text) {
      return -1;
    }

    if (a.text > b.text) {
      return 1;
    }

    return 0;
  };
}

function byTaskType(a, b) {
  if (a.text < b.text) return -1;
  if (a.text > b.text) return 1;
  return 0;
}
// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/scheduled-start-date-tooltip-directive.js
var scheduled_start_date_tooltip_directive = __webpack_require__(950);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/ids.js
var ids = __webpack_require__(64);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/task-context-menu-service.js


var task_context_menu_service_Ids = Object(ids["a" /* default */])();
angular.module('xlrelease').factory('TaskContextMenuService', ['Authenticator', 'TasksService', 'ReleasesService', '$state', '$location', 'ViewStorage', function (Authenticator, TasksService, ReleasesService, $state, $location, ViewStorage) {
  function controlFlowActions(task, release, withinBlackout) {
    var items = [];

    if (!TasksService.isTaskReadOnly(task)) {
      items.push({
        text: 'Assign to me',
        disabled: !TasksService.canAssignTaskToCurrentUser(task, release),
        click: function click() {
          return TasksService.assignToCurrentUser(task);
        }
      });
    }

    if (TasksService.isTaskPending(task)) {
      items.push({
        text: 'Start now',
        disabled: !TasksService.canStartTask(release, task) || task.delayDuringBlackout && withinBlackout && !TasksService.canEditBlackout(release, task),
        modal: 'partials/tasks/start-task-modal.html'
      });
    }

    if (TasksService.isTaskInProgress(task) && !TasksService.isAutomated(task) && !TasksService.isTaskGroup(task)) {
      items = items.concat([{
        text: 'Complete',
        disabled: !TasksService.canCompleteTask(release, task),
        modal: 'partials/tasks/complete-task-modal.html'
      }, {
        text: 'Skip',
        disabled: !TasksService.canSkipTask(release, task),
        modal: 'partials/tasks/skip-task-modal.html'
      }, {
        text: 'Fail',
        disabled: !TasksService.canFailTask(release, task),
        modal: 'partials/tasks/fail-task-modal.html'
      }]);
    }

    if (TasksService.isInProgressScriptTask(task) || TasksService.isQueuedScriptTask(task) || TasksService.isTaskPreconditionInProgress(task) || TasksService.isTaskFailureHandlerInProgress(task) || TasksService.isTaskAbortScriptInProgress(task) || TasksService.isTaskFacetInProgress(task)) {
      items.push({
        text: 'Abort',
        disabled: !TasksService.canAbortTask(release, task),
        modal: 'partials/tasks/abort-task-modal.html'
      });
    }

    if (TasksService.isTaskFailed(task) && (!TasksService.isTaskGroup(task) || TasksService.isTaskGroupSkippableOrRetriable(task))) {
      items.push({
        text: 'Skip',
        disabled: !TasksService.canSkipTask(release, task),
        modal: 'partials/tasks/skip-task-modal.html'
      });

      if (!TasksService.isUnknownTask(task)) {
        items.push({
          text: 'Retry',
          disabled: !TasksService.canRetryTask(release, task),
          modal: 'partials/tasks/retry-task-modal.html'
        });
      }
    }

    if (TasksService.isTaskPlanned(task) && !TasksService.isTaskGroup(task) && (ReleasesService.isReleaseInProgress(release) || ReleasesService.isReleaseFailed(release) || ReleasesService.isReleaseFailing(release) || ReleasesService.isReleasePaused(release))) {
      if (!TasksService.isAutomated(task)) {
        items.push({
          text: 'Complete',
          disabled: !TasksService.canCompleteTask(release, task),
          modal: 'partials/tasks/complete-task-modal.html'
        });
      }

      items.push({
        text: 'Skip',
        disabled: !TasksService.canSkipTask(release, task),
        modal: 'partials/tasks/skip-task-modal.html'
      });
    }

    if ((ReleasesService.isReleaseInProgress(release) || ReleasesService.isReleaseFailed(release) || ReleasesService.isReleaseFailing(release) || ReleasesService.isReleasePaused(release)) && TasksService.isTaskDoneInAdvance(task) && !TasksService.isTaskGroup(task)) {
      items.push({
        text: 'Reopen',
        disabled: !TasksService.canReopenTask(release, task),
        modal: 'partials/tasks/reopen-task-modal.html'
      });
    }

    return items;
  }

  function lockActions(task, release) {
    var items = [];

    var setTaskLock = function setTaskLock(lock) {
      var flatten = function flatten(t) {
        return [t].concat(toConsumableArray_default()(TasksService.isTaskGroup(t) ? _.flatMap(t.tasks, flatten) : []));
      };

      flatten(task).forEach(function (t) {
        return t.locked = lock;
      });
    };

    if (!task.locked) {
      items.push({
        text: 'Lock',
        disabled: !Authenticator.hasLockTaskPermission(release),
        click: function click() {
          return TasksService.lock(task.id).then(function () {
            setTaskLock(true);
          });
        }
      });
    } else {
      items.push({
        text: 'Unlock',
        disabled: !Authenticator.hasLockTaskPermission(release),
        click: function click() {
          return TasksService.unlock(task.id).then(function () {
            setTaskLock(false);
          });
        }
      });
    }

    if (items.length) {
      items.push({
        divider: true
      });
    }

    return items;
  }

  function editActions(task, release, container) {
    return [{
      text: 'Duplicate',
      disabled: !TasksService.isDuplicateEnabled(task, release, container),
      click: function click() {
        if (TasksService.isDuplicateEnabled(task, release, container)) {
          return TasksService.duplicateTask(release, task, container);
        }
      }
    }, {
      text: 'Delete',
      disabled: !TasksService.isRemoveEnabled(task, release, container),
      modal: 'partials/releases/delete-task-modal.html',
      cssClass: 'remove-task-button'
    }];
  }

  function changeTypeSubmenu(task, release, container, groupedTaskDefinitions) {
    if (TasksService.isTaskPlanned(task) && !TasksService.isTaskGroup(task) && Authenticator.hasEditTaskPermission(release)) {
      var mapTaskToType = function mapTaskToType(taskDefinition) {
        var isSameType = TasksService.isOfType(task, taskDefinition);
        return {
          templateUrl: 'partials/tasks/change-type-submenu-item.html',
          isSameType: isSameType,
          taskDefinition: taskDefinition
        };
      };

      var topGroups = ['Core', 'Delivery', 'Script', 'Remote Script', 'Webhook'];

      var types = _.map(groupedTaskDefinitions, function (taskDefinitions, group) {
        return {
          text: group,
          items: taskDefinitions.filter(function (taskDefinition) {
            return taskDefinition.isAllowed;
          }).sort(function (a, b) {
            var aDisplayName = a.displayName.toUpperCase();
            var bDisplayName = b.displayName.toUpperCase();

            if (aDisplayName < bDisplayName) {
              return -1;
            }

            if (aDisplayName > bDisplayName) {
              return 1;
            }

            return 0;
          }).map(function (taskDefinition) {
            return mapTaskToType(taskDefinition);
          })
        };
      }).sort(function (a, b) {
        var aIdx = topGroups.indexOf(a.text);
        var bIdx = topGroups.indexOf(b.text);

        if (aIdx > -1 && bIdx > -1) {
          return aIdx - bIdx;
        }

        if (aIdx > -1 && bIdx === -1) {
          return -1;
        }

        if (aIdx === -1 && bIdx > -1) {
          return 1;
        }

        if (a.text < b.text) {
          return -1;
        }

        if (a.text > b.text) {
          return 1;
        }

        return 0;
      });

      types.splice(topGroups.length, 0, {
        divider: true
      });
      return [{
        text: 'Change type',
        disabled: !TasksService.isChangeTypeEnabled(task, release, container),
        items: types,
        filter: true
      }];
    } else {
      return [];
    }
  }

  function typeOf(item) {
    if (item.modal) return 'modal';
    if (item.click) return 'click';
    if (item.divider) return 'divider';
    if (item.templateUrl) return 'template';
    if (item.items) return 'submenu';
    return 'noAction';
  }

  function enhanceMenuItemsWithType(items) {
    _.map(items, function (item) {
      if (item.items) {
        enhanceMenuItemsWithType(item.items);
      }

      return _.assignIn(item, {
        type: typeOf(item)
      });
    });
  }

  function getReleaseUrl(releaseId) {
    var internalId = task_context_menu_service_Ids.toInternalId(releaseId);
    return "#".concat(ViewStorage.getView(internalId, "/releases/".concat(internalId)));
  }

  function getTaskUrl(releaseId, phaseTaskId) {
    var internalId = task_context_menu_service_Ids.toInternalId(phaseTaskId);
    return "".concat(getReleaseUrl(releaseId), "?openTaskDetailsModal=").concat(internalId);
  }

  return {
    getMenuItems: function getMenuItems(task, release, container, groupedTaskDefinitions, withinBlackout) {
      var res = controlFlowActions(task, release, withinBlackout);
      res = res.concat(lockActions(task, release));
      res = res.concat(changeTypeSubmenu(task, release, container, groupedTaskDefinitions));
      res = res.concat(editActions(task, release, container));
      enhanceMenuItemsWithType(res);
      return res;
    },
    getTaskCardMenuItems: function getTaskCardMenuItems(task, release, withinBlackout) {
      var res = controlFlowActions(task, release, withinBlackout);

      if (Authenticator.hasViewPermission(release)) {
        res.push({
          text: 'View in Release',
          click: function click() {
            $state.go('release', {
              releaseId: task.releaseId
            });
          }
        });
      }

      enhanceMenuItemsWithType(res);
      return res;
    },
    getTaskReleaseFlowUrl: function getTaskReleaseFlowUrl(task) {
      var releaseId = task_context_menu_service_Ids.releaseIdFrom(task.id);
      var phaseTaskId = task_context_menu_service_Ids.phaseTaskIdFrom(task.id);
      var hostUrl = $location.$$absUrl.split('/#/')[0];
      var taskUrl = getTaskUrl(releaseId, phaseTaskId);
      return hostUrl + '/' + taskUrl;
    },
    getTaskReleaseTableUrl: function getTaskReleaseTableUrl(task) {
      var releaseId = task_context_menu_service_Ids.releaseIdFrom(task.id);
      var phaseTaskId = task_context_menu_service_Ids.phaseTaskIdFrom(task.id);
      var taskUrl = getTaskUrl(releaseId, phaseTaskId);
      taskUrl = $location.$$absUrl.split('/#/')[0] + '/' + taskUrl;
      return taskUrl.replace("/table", "");
    }
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/task-controller.js
var task_controller = __webpack_require__(951);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/task-definitions-service.js
var task_definitions_service = __webpack_require__(952);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/task-details-controller.js





function task_details_controller_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function task_details_controller_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { task_details_controller_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { task_details_controller_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }


angular.module('xlrelease').controller('taskDetailsController', ['$scope', 'ModalService', 'Backend', 'Toastr', 'TasksService', 'ReleasesService', '$location', 'Authenticator', 'FlagService', 'TaskDetailsUpdates', 'UsersService', 'UserProfile', 'PlanningDataEditorMixin', 'ConfigurationInstances', 'ReleaseEditorCollapse', 'VariablesService', 'TaskContextMenuService', 'CalendarService', '$stateParams', 'Ids', 'ViewStorage', '$uibModal', '$q', function ($scope, ModalService, Backend, Toastr, TasksService, ReleasesService, $location, Authenticator, FlagService, TaskDetailsUpdates, UsersService, UserProfile, PlanningDataEditorMixin, ConfigurationInstances, ReleaseEditorCollapse, VariablesService, TaskContextMenuService, CalendarService, $stateParams, Ids, ViewStorage, $uibModal, $q) {
  $scope.data = {
    newComment: '',
    showCommentForm: false
  };

  if ($scope.task) {
    if (TasksService.isTaskGroup($scope.task)) {
      $scope.isCollapsed = ReleaseEditorCollapse.isTaskGroupCollapsed($scope.task);
    }
  }

  $scope.ctrl = $scope;
  $scope.ctrlScope = $scope;
  $scope.tasksServices = TasksService;
  $scope.taskRecoverOps = [{
    id: "Skip task",
    title: "Skip task"
  }, {
    id: "Run script",
    title: "Define additional action"
  }];

  $scope.getPhaseTitle = function () {
    return $scope.phase && $scope.phase.title || $scope.task.phaseTitle;
  };

  $scope.formValid = true;

  $scope.findRelease = function (task, releases) {
    return releases.find(function (r) {
      return r.id === task.releaseId;
    });
  };

  function loadModalScope(task) {
    return CalendarService.withinBlackout().then(function (response) {
      var modalScope = $scope.$new();
      modalScope.withinBlackout = response.data;

      modalScope.canStartTaskWithinBlackout = function (release) {
        return task.delayDuringBlackout && TasksService.canEditBlackout(release, task) && modalScope.withinBlackout || TasksService.canWorkOnTask(release, task) && (!task.delayDuringBlackout || !modalScope.withinBlackout);
      };

      return modalScope;
    });
  }

  $scope.openTaskDetailsModal = function (task) {
    if (isTaskDisabledInView(task)) {
      return;
    }

    loadModalScope(task).then(function (modalScope) {
      ModalService.open(modalScope, "'partials/tasks/details/task-details-modal.html'", "editTask(task, release)", "loadReleaseAfterTaskUpdate()", true, true);
      modalScope.showModal();
    });
  };

  $scope.openTaskDetailsModalIfRequested = function () {
    if ($location.search().openTaskDetailsModal && Ids.phaseTaskIdFrom($location.search().openTaskDetailsModal) === Ids.phaseTaskIdFrom($scope.task.id)) {
      $scope.openTaskDetailsModal($scope.task);
    }
  };

  function decorateWithReleaseLoading(menuItems) {
    menuItems.forEach(function (i) {
      if (i.text === 'Duplicate') {
        var oldFn = i.click;

        i.click = function () {
          return oldFn().then($scope.loadRelease);
        }; //it is a dirty hack but I cannot find a proper one

      }
    });
    return menuItems;
  }

  function copyUrlToClipboard(task) {
    var status = copy_text_to_clipboard_default()(TaskContextMenuService.getTaskReleaseFlowUrl(task));

    if (status) {
      Toastr.success('Task url was copied to the clipboard!');
    } else {
      Toastr.error('Can not access clipboard to copy task url. Please check if you have given this browser sufficient permissions to copy data to clipboard.');
    }
  }

  $scope.taskContextMenuItems = function (task, release, container, groupedTaskDefinitions, withinBlackout) {
    var items = TaskContextMenuService.getMenuItems(task, release, container, groupedTaskDefinitions, withinBlackout);
    var dividerIndex = items.indexOf({
      divider: true
    });
    items.splice(dividerIndex, 0, {
      text: 'Copy URL',
      type: 'click',
      disabled: false,
      click: function click() {
        copyUrlToClipboard(task);
      }
    });

    if (!$scope.isTaskContextMenuAvailable(task)) {
      items = items.filter(function (item, index, arr) {
        return item.text === 'Copy URL';
      });
    }

    return decorateWithReleaseLoading(items);
  };

  $scope.createOptionalVariable = function (task, name, variableType, createdCallback) {
    var variable = {
      key: name,
      requiresValue: false,
      showOnReleaseStart: false,
      type: variableType
    };
    $scope.createReleaseVariable(task, variable, createdCallback);
  };

  $scope.createRequiredVariable = function (task, name, variableType, createdCallback) {
    var variable = {
      key: name,
      type: variableType
    };
    $scope.createReleaseVariable(task, variable, createdCallback);
  };

  $scope.createReleaseVariable = function (task, variable, createdCallback) {
    VariablesService.createReleaseVariable(task.releaseId, variable).then(function (resp) {
      if (createdCallback) {
        createdCallback(resp.data);
      }
    });
  };

  $scope.updateTags = function (tags, task) {
    task.tags = tags;
    $scope.saveTask(task);
    TaskDetailsUpdates.tagsChanged = true;
  };

  $scope.initTaskRecoverOp = function (task) {
    if (!task.taskRecoverOp) {
      task.taskRecoverOp = 'Skip task';
      $scope.saveTask(task);
    }
  };

  $scope.saveTask = function (task, saveCallback) {
    return TasksService.updateTask(task).then(function (resp) {
      var savedTask = resp.data;
      task.password = savedTask.password;
      task.outputProperties = savedTask.outputProperties;
      task.inputProperties = savedTask.inputProperties;
      task.variables = savedTask.variables;
      loadVariablesOnTaskSaved(task.releaseId);

      if (saveCallback) {
        saveCallback(task);
      }
    });
  };

  angular.extend($scope, PlanningDataEditorMixin.withSaveCallback(function (task) {
    resetWaitForScheduledStartDate(task);
    $scope.saveTask(task);
    TaskDetailsUpdates.planningDataChanged = true;
  }));

  function resetWaitForScheduledStartDate(task) {
    if (!task.scheduledStartDate) {
      task.waitForScheduledStartDate = true; // reset to default value
    }
  }

  $scope.reloadTaskVariablesCallback = function (release) {
    return function (task) {
      loadVariables(task, release);
    };
  };

  $scope.loadReleaseForEditTask = function (task, release) {
    $scope.isPartialLoad = true;
    ReleasesService.getRelease(release.id, {
      dontRedirectWhenForbidden: true,
      hideAlert: true
    }).then(function (result) {
      $scope.release.variables = result.data.variables;
      $scope.editTask(task, result.data);
    }).catch(function (response) {
      if (response.status === 403) {
        Backend.get("tasks/".concat(task.id, "/release")).then(function (resp) {
          return $scope.editTask(task, resp.data);
        });
      }
    });
  };

  $scope.editTask = function (task, release) {
    loadModalScope(task).then(function (modalScope) {
      $scope.withinBlackout = modalScope.withinBlackout;
      $scope.canStartTaskWithinBlackout = modalScope.canStartTaskWithinBlackout;
    });

    if ('type' in release) {
      $scope.planning.initPlanningData(task, release);
    }

    loadVariables(task, release);
    loadUsernames(release).then(function () {
      loadWatchers(task);
    });
    loadTeams(task.id, release);
    loadComments(task.id);
    loadCustomType(task);
    var folderId = Ids.releaseIdToFolderId($stateParams.releaseId);
    ConfigurationInstances.load(folderId);
  };

  $scope.ConfigurationInstances = ConfigurationInstances;

  function loadVariables(task, release) {
    $scope.variables = undefined;
    $scope.allVariables = undefined;
    $scope.releaseVariables = undefined;
    $scope.editableReleaseVariables = undefined;

    if (TasksService.isTaskWaitingForInput(task) && TasksService.canWorkOnTask(release, task)) {
      TasksService.getTaskVariables(task).then(function (resp) {
        return $scope.variables = resp.data;
      });
    }

    if (canViewRelease(release)) {
      VariablesService.getAllVariables(release.id).then(function (allVariables) {
        $scope.allVariables = allVariables;
        $scope.allVariablesWithReleaseVars = loadAllVariablesWithSpecialRelVars(allVariables, release);
        $scope.releaseVariables = _.filter(allVariables, function (v) {
          return !VariablesService.isFolderOrGlobalVariable(v.key);
        });
        $scope.editableReleaseVariables = _.filter($scope.releaseVariables, function (v) {
          return !VariablesService.isCiPropertyVariableName(v.key);
        });
      });
    }
  }

  function loadVariablesOnTaskSaved(releaseId) {
    VariablesService.getAllVariables(releaseId).then(function (allVariables) {
      allVariables.filter(function (var1) {
        return !$scope.allVariables.some(function (var2) {
          return var1.key === var2.key;
        });
      }).forEach(function (newVar) {
        return $scope.allVariablesWithReleaseVars.push(newVar);
      });
    });
  }

  function loadAllVariablesWithSpecialRelVars(allVariables, release) {
    if (release.variables) {
      var specialVariables = Object.keys(release.variables).filter(function (key) {
        return key.includes('release.') === true;
      }).reduce(function (obj, key) {
        return task_details_controller_objectSpread({}, obj, defineProperty_default()({}, key, release.variables[key]));
      }, {});
      Object.keys(specialVariables).forEach(function (key) {
        allVariables.push({
          'displayName': key,
          'id': '',
          'key': key.replace('${', '').replace('}', ''),
          'requiresValue': false,
          'showOnReleaseStart': false,
          'type': "xlrelease.StringVariable",
          'value': specialVariables[key],
          'variableName': key
        });
      });
    }

    return allVariables;
  }

  function loadUsernames(release) {
    $scope.allUsers = [];

    if (Authenticator.hasEditTaskPermission(release) || Authenticator.hasReassignTaskPermission(release)) {
      return UsersService.getAllUsers().then(function (resp) {
        $scope.allUsers = _.sortBy(resp.data, [function (rp) {
          return rp.username.toLowerCase();
        }]);
      });
    } else {
      return $q.resolve([]);
    }
  }

  function loadTeams(taskId, release) {
    $scope.teams = [];

    if (Authenticator.hasEditTaskPermission(release) || Authenticator.hasReassignTaskPermission(release)) {
      Backend.get("releases/".concat(release.id, "/teams/assignable")).then(function (resp) {
        return $scope.teams = _(resp.data).map(function (team) {
          return {
            id: team.teamName,
            title: team.teamName
          };
        }).sortBy(function (t) {
          return t.title.toLowerCase();
        }).value();
      });
    }
  }

  function loadComments(taskId) {
    $scope.comments = [];
    Backend.get("tasks/".concat(taskId, "/comments")).then(function (resp) {
      return $scope.comments = resp.data;
    });
  }

  function loadCustomType(task) {
    $scope.scriptDefinition = null;

    if (task.scriptDefinitionType) {
      Backend.get("tasks/task-definitions/".concat(task.scriptDefinitionType)).then(function (resp) {
        return $scope.scriptDefinition = resp.data;
      });
    }
  }

  $scope.saveComment = function (comment) {
    Backend.put("comments/".concat(comment.id), comment).then(function (resp) {
      var updatedComment = resp.data;
      comment.date = updatedComment.date;
      comment.text = updatedComment.text;
    });
  };

  $scope.openDeleteCommentModal = function (_comment) {
    $uibModal.open({
      animation: false,
      component: 'deleteCommentOfTaskModal',
      windowClass: 'delete-comment-window',
      backdropClass: 'delete-comment-backdrop',
      resolve: {
        comment: function comment() {
          return _comment;
        }
      }
    }).result.then(function (pressedDelete) {
      if (pressedDelete) {
        Backend.del("comments/".concat(_comment.id), {
          data: _comment
        }).then(function (resp) {
          var index = $scope.comments.indexOf(_comment);
          $scope.comments.splice(index, 1);
          task.numberOfComments--;
        });
      }
    });
  };

  $scope.addComment = function (task, commentText) {
    var newComment = {
      text: commentText
    };
    Backend.post("tasks/".concat(task.id, "/comments"), newComment).then(function (resp) {
      $scope.data.newComment = '';
      $scope.comments.push(resp.data);
      task.numberOfComments++;
      $scope.data.showCommentForm = false;
    });
  };

  $scope.flag = function (flagStatus) {
    $scope.task.flag.status = flagStatus;

    if (!FlagService.isTaskFlagged($scope.task)) {
      $scope.task.flag.comment = '';
    }

    $scope.saveTask($scope.task);
  };

  $scope.removeOwner = function () {
    $scope.task.owner = null;
    Backend.del('tasks/' + $scope.task.id + '/owner');
    TaskDetailsUpdates.assigneeChanged = true;
  };

  $scope.updateOwner = function (task) {
    if (task.owner) {
      Backend.put('tasks/' + task.id + '/owner', TasksService.toTaskFullView(task));
      TaskDetailsUpdates.assigneeChanged = true;
    } else {
      $scope.removeOwner();
    }
  };

  $scope.removeTeam = function () {
    $scope.task.team = null;
    Backend.del('tasks/' + $scope.task.id + '/team');
    TaskDetailsUpdates.assigneeChanged = true;
  };

  $scope.updateTeam = function (task) {
    Backend.put('tasks/' + task.id + '/team', TasksService.toTaskFullView(task));
    TaskDetailsUpdates.assigneeChanged = true;
  };

  $scope.viewTaskInRelease = function (releaseId) {
    $location.url('releases/' + releaseId);
  };

  $scope.canWorkOnTask = function (release) {
    return TasksService.canWorkOnTask(release, $scope.task);
  };

  $scope.canUpdateCommentOnTask = function (release, comment) {
    return TasksService.canUpdateCommentOnTask(release, $scope.task, comment);
  };

  $scope.canWorkOnReadOnlyTask = function (release) {
    return TasksService.canWorkOnReadOnlyTask(release, $scope.task);
  };

  function canEditTask(release, task) {
    return TasksService.canEditTask(release, task || $scope.task);
  }

  function canEditTaskConfigurationFacet(release) {
    return TasksService.canEditTaskConfigurationFacet(release);
  }

  $scope.canEditTaskConfigurationPropertiesAndIsUnlocked = function () {
    return !TasksService.isLocked($scope.task) && TasksService.canEditTaskConfigurationPropertiesAndTaskNotInProgress($scope.release, $scope.task);
  };

  $scope.canEditTaskAttachment = function () {
    return TasksService.canEditTaskAttachment($scope.release, $scope.task);
  };

  $scope.canEditGateTaskConfigurationPropertiesAndIsUnlocked = function () {
    return !TasksService.isLocked($scope.task) && TasksService.canEditTaskConfigurationProperties($scope.release, $scope.task);
  };

  $scope.canClaimTask = function (task, release) {
    return TasksService.canAssignTaskToCurrentUser(task, release);
  };

  $scope.canCompleteTask = function (release, task) {
    return TasksService.canCompleteTask(release, task);
  };

  $scope.canSkipTask = function (release, task) {
    return TasksService.canSkipTask(release, task);
  };

  $scope.$on('formValidityChanged', function (event, validity) {
    $scope.formValid = validity;
  });

  $scope.isPlannedOrPending = function (task) {
    return TasksService.isTaskPlanned(task) || TasksService.isTaskPending(task);
  };

  $scope.isTaskPostponedDueToBlackout = function (task) {
    return task.postponedDueToBlackout;
  };

  $scope.getOriginalScheduledStartDate = function (task) {
    if ($scope.isTaskPostponedDueToBlackout(task)) {
      return task.originalScheduledStartDate;
    } else {
      return null;
    }
  };

  $scope.isTaskInFinishedState = function (task) {
    return TasksService.isTaskCompleted(task) || TasksService.isTaskFailed(task) || TasksService.isTaskSkipped(task) || TasksService.isTaskAborted(task);
  };

  $scope.assignToMe = function (task) {
    task.owner = UserProfile.getCurrentUser();
    $scope.updateOwner(task);
  };

  $scope.deleteAttachment = function (release, task, attachment) {
    Backend.del("releases/".concat(release.id, "/").concat(task.id, "/attachments/").concat(attachment.id)).then(function () {
      return _.remove(task.attachments, {
        id: attachment.id
      });
    });
  };

  function isTaskDisabledInView(task) {
    return task.disabledInView;
  }

  $scope.isTaskDisabledInView = isTaskDisabledInView;

  $scope.isTaskContextMenuAvailable = function (task) {
    return (!TasksService.isTaskReadOnly(task) || TasksService.isTaskDoneInAdvance(task)) && !isTaskDisabledInView(task);
  }; // Task Watchers


  var sortWatchers = function sortWatchers(watchers) {
    var currentUser = UserProfile.getCurrentUser();

    var users = _.remove(watchers, {
      username: currentUser.username
    });

    var sortedWatchers = _.orderBy(watchers, [function (w) {
      return _.toLower(w.fullName);
    }, function (w) {
      return w.username.toLowerCase();
    }], ['asc', 'asc']);

    return [].concat(toConsumableArray_default()(users), toConsumableArray_default()(sortedWatchers));
  };

  var excludeWatchersFromAllUsers = function excludeWatchersFromAllUsers(allUsers, watchers) {
    return _.differenceWith(allUsers, watchers, function (u1, u2) {
      return u1.username === u2.username;
    });
  };

  var handleWatcherResponse = function handleWatcherResponse(response) {
    $scope.watchers = sortWatchers(response.data);
    $scope.nonWatchingUsers = excludeWatchersFromAllUsers($scope.allUsers, $scope.watchers);
  };

  var loadWatchers = function loadWatchers(task) {
    $scope.watchers = [];
    Backend.get("tasks/".concat(task.id, "/watchers")).then(handleWatcherResponse);
  };

  var isWatchingTask = function isWatchingTask(watcher) {
    return _.some($scope.watchers, {
      username: watcher.username
    });
  };

  var addWatcher = function addWatcher(task, watcher) {
    var found = _.find($scope.watchers, {
      username: watcher.username
    });

    if (!found) {
      Backend.post("tasks/".concat(task.id, "/watchers"), watcher).then(handleWatcherResponse);
    }
  };

  var removeWatcher = function removeWatcher(task, watcher) {
    Backend.del("tasks/".concat(task.id, "/watchers/").concat(watcher.username)).then(handleWatcherResponse);
  };

  $scope.isUserWatchingTask = function () {
    return isWatchingTask(UserProfile.getCurrentUser());
  };

  $scope.addMeAsWatcher = function (task) {
    addWatcher(task, UserProfile.getCurrentUser());
  };

  $scope.canRemoveWatcher = function (release, watcher) {
    var currentUser = UserProfile.getCurrentUser();
    return $scope.canEditTask(release) || currentUser.username === watcher.username;
  };

  $scope.removeWatcher = function (task, watcher) {
    removeWatcher(task, watcher);
  };

  $scope.watcherContainer = {
    watcher: null
  };

  $scope.handleWatcherChange = function (task) {
    var watcher = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
      username: ''
    };
    $scope.nonWatchingUsers.forEach(function (user) {
      if (watcher.username === user.username) {
        addWatcher(task, watcher);
      }

      $scope.watcherContainer.watcher = null;
    });
  };

  $scope.watchersTooltip = {
    placement: 'auto bottom',
    text: 'Assigning a watcher role to a user will allow him to receive notifications for this tasks events'
  };
  $scope.canEditTask = canEditTask;
  $scope.canEditBlackout = TasksService.canEditBlackout;
  $scope.canDelayTask = TasksService.canDelayTask;
  $scope.canWorkOnFailedTask = TasksService.canWorkOnFailedTask;
  $scope.isStatusUpdatable = TasksService.isStatusUpdatable;
  $scope.canUpdateInProgressStatus = TasksService.canUpdateInProgressStatus;
  $scope.canUpdatePlannedStatus = TasksService.canUpdatePlannedStatus;
  $scope.canUpdateFailedStatus = TasksService.canUpdateFailedStatus;
  $scope.isTaskDoneInAdvance = TasksService.isTaskDoneInAdvance;
  $scope.isStatusUpdatable = TasksService.isStatusUpdatable;
  $scope.isTaskInProgress = TasksService.isTaskInProgress;
  $scope.isTaskQueued = TasksService.isTaskQueued;
  $scope.isGateTask = TasksService.isGateTask;
  $scope.isUserInputTask = TasksService.isUserInputTask;
  $scope.isNotificationTask = TasksService.isNotificationTask;
  $scope.isScriptTask = TasksService.isScriptTask;
  $scope.isTaskGroup = TasksService.isTaskGroup;
  $scope.isParallelGroup = TasksService.isParallelGroup;
  $scope.isSequentialGroup = TasksService.isSequentialGroup;
  $scope.isCustomScriptTask = TasksService.isCustomScriptTask;
  $scope.isCreateReleaseTask = TasksService.isCreateReleaseTask;
  $scope.isInProgressScriptTask = TasksService.isInProgressScriptTask;
  $scope.isGateClosed = TasksService.isGateClosed;
  $scope.isTaskReadOnly = TasksService.isTaskReadOnly;
  $scope.isTaskFailed = TasksService.isTaskFailed;
  $scope.isTaskFailing = TasksService.isTaskFailing;
  $scope.isTaskPending = TasksService.isTaskPending;
  $scope.isTaskAborted = TasksService.isTaskAborted;
  $scope.isTaskCompleted = TasksService.isTaskCompleted;
  $scope.isTaskPreconditionInProgress = TasksService.isTaskPreconditionInProgress;
  $scope.isTaskFacetInProgress = TasksService.isTaskFacetInProgress;
  $scope.hasDeploymentFacet = TasksService.hasDeploymentFacet;
  $scope.isTaskFailureHandlerInProgress = TasksService.isTaskFailureHandlerInProgress;
  $scope.isTaskAbortScriptInProgress = TasksService.isTaskAbortScriptInProgress;
  $scope.isTaskGroupSkippableOrRetriable = TasksService.isTaskGroupSkippableOrRetriable;
  $scope.isTaskCompletedInAdvance = TasksService.isTaskCompletedInAdvance;
  $scope.isTaskSkippedInAdvance = TasksService.isTaskSkippedInAdvance;
  $scope.isTaskSkipped = TasksService.isTaskSkipped;
  $scope.isDone = TasksService.isDone;
  $scope.isDoneInAdvance = TasksService.isTaskDoneInAdvance;
  $scope.isAutomated = TasksService.isAutomated;
  $scope.isTaskDelayedDuringBlackout = TasksService.isTaskDelayedDuringBlackout;
  $scope.hasOwner = TasksService.hasOwner;
  $scope.isReleaseInProgress = ReleasesService.isReleaseInProgress;
  $scope.hasConfigurationUri = TasksService.hasConfigurationUri;
  $scope.getConfigurationUri = TasksService.getConfigurationUri;
  $scope.isPreConditionCollapsed = ReleaseEditorCollapse.isPreConditionCollapsed;
  $scope.togglePreConditionState = ReleaseEditorCollapse.togglePreConditionState;
  $scope.areTaskPropertiesReadonly = areTaskPropertiesReadonly;
  $scope.areFacetsCollapsed = ReleaseEditorCollapse.areFacetsCollapsed;
  $scope.toggleFacetsState = ReleaseEditorCollapse.toggleFacetsState;
  $scope.isFailureHandlerCollapsed = ReleaseEditorCollapse.isFailureHandlerCollapsed;
  $scope.toggleFailureHandlerState = ReleaseEditorCollapse.toggleFailureHandlerState;
  $scope.isCommentsCollapsed = ReleaseEditorCollapse.isCommentsCollapsed;
  $scope.toggleCommentsState = ReleaseEditorCollapse.toggleCommentsState;
  $scope.isAttachmentsCollapsed = ReleaseEditorCollapse.isAttachmentsCollapsed;
  $scope.toggleAttachmentsState = ReleaseEditorCollapse.toggleAttachmentsState;

  $scope.toggleTaskGroupCollapseState = function (task) {
    $scope.isCollapsed = !$scope.isCollapsed;
    ReleaseEditorCollapse.toggleTaskGroupCollapseState(task);
  };

  $scope.hasLockPermission = function (release) {
    return Authenticator.hasLockTaskPermission(release);
  };

  $scope.isLocked = function () {
    return TasksService.isLocked($scope.task);
  };

  $scope.isUnknownTask = function () {
    return TasksService.isUnknownTask($scope.task);
  };

  $scope.canEditAndIsUnlocked = function () {
    return !$scope.isLocked() && canEditTask($scope.release, $scope.task);
  };

  $scope.canEditTaskTags = function () {
    return !$scope.isLocked() && TasksService.canEditTaskTags($scope.release, $scope.task);
  };

  $scope.canEditFacet = function () {
    return !$scope.isLocked() && (canEditTask($scope.release, $scope.task) || canEditTaskConfigurationFacet($scope.release));
  };

  $scope.canEditFailureHandler = function () {
    return !$scope.isLocked() && TasksService.canEditFailureHandler($scope.release, $scope.task);
  };

  $scope.canEditPrecondition = function () {
    return !$scope.isLocked() && TasksService.canEditPrecondition($scope.release, $scope.task);
  };

  $scope.canEditScriptAndIsUnlocked = function () {
    return TasksService.canEditTaskScript($scope.release, $scope.task) && !$scope.isLocked();
  };

  $scope.areTaskPropertiesReadonlyOrLocked = function () {
    return areTaskPropertiesReadonly() || $scope.isLocked();
  };

  $scope.unlock = function (task) {
    return TasksService.unlock(task.id).then(function () {
      setTaskLock(task, false);
    });
  };

  $scope.canEditWaitForScheduledStartDate = function () {
    return TasksService.canEditWaitForScheduledStartDate($scope.release);
  };

  $scope.canEditEnvironmentAvailability = function () {
    return TasksService.canEditEnvironmentAvailability($scope.release);
  };

  function setTaskLock(task, lock) {
    var flatten = function flatten(t) {
      return [t].concat(toConsumableArray_default()(TasksService.isTaskGroup(t) ? _.flatMap(t.tasks, flatten) : []));
    };

    flatten(task).forEach(function (t) {
      t.locked = lock;
    });
  }

  function areTaskPropertiesReadonly() {
    var release = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : $scope.release;
    var task = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : $scope.task;
    return TasksService.areTaskPropertiesReadonly(release, task);
  }

  function canViewRelease(release) {
    return Authenticator.hasViewPermission(release);
  }

  $scope.$on('$destroy', function () {
    ConfigurationInstances.reset();
  });

  $scope.getEnvironmentAvailabilityTooltip = function (task) {
    if (TasksService.isTaskReadOnly(task)) {
      return undefined;
    } else if (TasksService.hasDeploymentFacet(task)) {
      return 'If the environment is not available, this option will fail the task';
    } else {
      return 'To use this feature, you must add deployment attributes';
    }
  };

  $scope.getTaskStatusTooltip = function () {
    $scope.statusTooltip = "";
    TasksService.getLatestTaskActivityLog($scope.release.id, Ids.toDomainId($scope.task.id)).then(function (logEntry) {
      var displayedName = !logEntry.user.fullName || 0 === logEntry.user.fullName.length ? logEntry.user.username : "".concat(logEntry.user.fullName, " (").concat(logEntry.user.username, ")");

      if (["TASK_COMPLETED", "TASK_COMPLETED_IN_ADVANCE"].includes(logEntry.activityType)) {
        $scope.statusTooltip = "Completed by ".concat(displayedName);
      } else if (["TASK_SKIPPED", "TASK_SKIPPED_IN_ADVANCE"].includes(logEntry.activityType)) {
        $scope.statusTooltip = "Skipped by ".concat(displayedName);
      } else if (["TASK_FAILED"].includes(logEntry.activityType)) {
        $scope.statusTooltip = "Failed by ".concat(displayedName);
      }
    });
  };

  $scope.canEditTaskTitleAndDescription = function () {
    return TasksService.canEditTaskTitleAndDescription($scope.release, $scope.task) && !$scope.isLocked();
  };

  $scope.canEditTaskDates = function () {
    return TasksService.canEditTaskDates($scope.release, $scope.task) && !$scope.isLocked();
  };

  $scope.canEditTaskFlag = function () {
    return TasksService.canEditTaskFlag($scope.release, $scope.task);
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/task-details-updates.js
var task_details_updates = __webpack_require__(953);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/task-list-controller.js
var task_list_controller = __webpack_require__(954);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/task-polling-service.js
var task_polling_service = __webpack_require__(955);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/task-status-css-class-filter.js
var task_status_css_class_filter = __webpack_require__(956);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/task-type-css-class-filter.js
var task_type_css_class_filter = __webpack_require__(957);

// CONCATENATED MODULE: ./core/xlr-ui/app/features/common/ci-statuses.js

var CommonStatuses = [{
  label: 'Planned',
  value: 'Planned',
  color: colors["a" /* default */].gray
}, {
  label: 'In progress',
  value: 'In progress',
  color: colors["a" /* default */].blue
}, {
  label: 'Failed',
  value: 'Failed',
  color: colors["a" /* default */].red
}];
var ReleaseStatuses = [].concat(CommonStatuses, [{
  label: 'Paused',
  value: 'Paused',
  color: colors["a" /* default */].gray
}, {
  label: 'Failing',
  value: 'Failing',
  color: colors["a" /* default */].orange
}, {
  label: 'Aborted',
  value: 'Aborted',
  color: colors["a" /* default */].gray
}, {
  label: 'Completed',
  value: 'Completed',
  color: colors["a" /* default */].green
}]);
var TaskStatuses = [].concat(CommonStatuses, [{
  label: 'Pendind',
  value: 'Pending',
  color: colors["a" /* default */].gray
}, {
  label: 'Queued',
  value: 'Queued',
  color: colors["a" /* default */].blue
}]);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/tasks-controller.js


angular.module('xlrelease').controller('TasksController', ['$scope', 'filterSettings', 'Backend', 'TaskPolling', 'Events', 'Modal', 'TaskDetailsUpdates', 'ClientSettings', 'TaskConstants', 'UsersService', 'FoldersService', 'Timeout', 'PollingSettings', function ($scope, filterSettings, Backend, TaskPolling, Events, Modal, TaskDetailsUpdates, ClientSettings, TaskConstants, UsersService, FoldersService, Timeout, PollingSettings) {
  var allTasksPromise = null;
  $scope.statuses = TaskStatuses;
  $scope.filters = filterSettings;
  $scope.orderByValues = _.values(global_constants["d" /* taskOrderValues */]);
  $scope.assigneeOptions = global_constants["c" /* taskAssigneeOptions */];
  $scope.filters = filterSettings;
  $scope.foldersReady = false;
  $scope.folders = [];
  $scope.expanderState = {};
  $scope.onGroupTasksByRelease = onGroupTasksByRelease;
  $scope.onFiltersChanged = onFiltersChanged;
  $scope.onTaskChange = onTaskChange;
  $scope.onTaskDetailsClosed = onTaskDetailsClosed;
  $scope.isHeaderExpanded = isHeaderExpanded;
  $scope.switchView = switchView;

  $scope.isListView = function () {
    return $scope.viewMode === 'list';
  };

  $scope.isGridView = function () {
    return $scope.viewMode === 'grid';
  };

  init();
  $scope.$on('$destroy', cancelAllTasksPolling);

  function init() {
    var layout = ClientSettings.getTaskFiltersLayout();
    $scope.isGroupedByRelease = !!layout && !_.isUndefined(layout.isGroupedByRelease) ? layout.isGroupedByRelease : true;
    $scope.viewMode = !!layout && !_.isUndefined(layout.viewMode) ? layout.viewMode : 'list';
    loadTasks();
    loadTaskTags();
    loadUsers();
    loadFolders();
  }

  function loadFolders() {
    FoldersService.list().then(function (result) {
      $scope.folders = result.data;
      $scope.foldersReady = true;
    });
  }

  function loadTasks() {
    $scope.$emit(Events.permission.refresh);
    var config = {
      params: {
        limitTasksHint: TaskConstants.LIMIT_TASKS_HINT
      }
    };
    Backend.post('tasks/search', $scope.filters, config).then(function (resp) {
      var taskSearchView = resp.data;
      $scope.releases = taskSearchView.releaseTasks;
      $scope.tasks = _.flatten($scope.releases.map(function (r) {
        return r.tasks;
      }));
      orderTasksInReleases($scope.filters.orderBy);
      $scope.limitReached = taskSearchView.limitReached;
      startPolling();
    });
  }

  function loadTaskTags() {
    Backend.get('tasks/tags').then(function (resp) {
      $scope.allTags = resp.data;
    });
  }

  function loadUsers() {
    UsersService.getAllUsersAsObject().then(function (users) {
      $scope.users = users;
    });
  }

  function onFiltersChanged(filters) {
    loadTasks();
    ClientSettings.setTasksFilters(filters);
  }

  function onGroupTasksByRelease() {
    ClientSettings.updateTaskFiltersLayout({
      isGroupedByRelease: $scope.isGroupedByRelease
    });
  }

  function orderTasksInReleases(orderBy) {
    var originalReleases = $scope.releases;
    var order = orderBy ? orderBy : $scope.orderBy;
    $scope.orderBy = order;
    var orderFunc = null;

    if (order === global_constants["d" /* taskOrderValues */].startDate.orderBy) {
      orderFunc = function orderFunc(tasks) {
        return _.orderBy(tasks, ['startDate', 'scheduledStartDate'], ['asc', 'asc']);
      };
    } else if (order === global_constants["d" /* taskOrderValues */].status.orderBy) {
      orderFunc = function orderFunc(tasks) {
        return _.sortBy(tasks, function (task) {
          return global_constants["e" /* taskStatusPriorities */][task.status.toLowerCase()];
        });
      };
    } else {
      orderFunc = function orderFunc(tasks) {
        return _.orderBy(tasks, 'dueDate', 'asc');
      };
    }

    _.forEach(originalReleases, function (release) {
      return release.tasks = orderFunc(release.tasks);
    });

    $scope.tasks = orderFunc($scope.tasks);
  }

  function onTaskChange() {
    loadTasks();
  }

  function onTaskDetailsClosed() {
    if (TaskDetailsUpdates.assigneeChanged || TaskDetailsUpdates.planningDataChanged || TaskDetailsUpdates.tagsChanged) {
      if (TaskDetailsUpdates.tagsChanged) {
        loadTaskTags();
      }

      loadTasks();
      TaskDetailsUpdates.reset();
    }
  }

  function switchView(mode) {
    $scope.viewMode = mode;
    ClientSettings.updateTaskFiltersLayout({
      viewMode: mode
    });
  }

  function startPolling() {
    TaskPolling.startTaskPolling($scope.tasks, $scope).then(loadTasks);
    startAllTasksPolling();
    Modal.withScope($scope).onNextOpen(stopPolling).onNextClose(startPolling);
  }

  function startAllTasksPolling() {
    if (!$scope.$$destroyed) {
      allTasksPromise = Timeout(function () {
        if (allTasksPromise !== null) {
          stopPolling();
          loadTasks();
        }
      }, PollingSettings.getListInterval());
    }
  }

  function cancelAllTasksPolling() {
    Timeout.cancel(allTasksPromise);
    allTasksPromise = null;
  }

  function stopPolling() {
    cancelAllTasksPolling();
    $scope.$broadcast(Events.polling.stop);
  }

  function isHeaderExpanded() {
    var layout = ClientSettings.getTaskFiltersLayout();
    return layout ? layout.expanded : false;
  }
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/date-service.js
var date_service = __webpack_require__(266);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/list/releases-status-service.js
var releases_status_service = __webpack_require__(120);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/tasks-service.js



var tasks_service_DateService = Object(date_service["a" /* default */])();
var tasks_service_ReleasesStatusService = Object(releases_status_service["a" /* default */])();
var tasks_service_Ids = Object(ids["a" /* default */])();

function TaskService(Backend, Authenticator, UserProfile, TaskDetailsUpdates, VariablesService) {
  function isTaskPlanned(task) {
    return isStatusOneOf(task, 'PLANNED');
  }

  function isTaskPending(task) {
    return isStatusOneOf(task, 'PENDING');
  }

  function isTaskInProgress(task) {
    return isStatusOneOf(task, 'IN_PROGRESS');
  }

  function isTaskQueued(task) {
    return isStatusOneOf(task, 'QUEUED', 'FAILURE_HANDLER_QUEUED', 'ABORT_SCRIPT_QUEUED');
  }

  function isTaskPreconditionInProgress(task) {
    return isStatusOneOf(task, 'PRECONDITION_IN_PROGRESS');
  }

  function isTaskFacetInProgress(task) {
    return isStatusOneOf(task, 'FACET_CHECK_IN_PROGRESS');
  }

  function isTaskFailureHandlerInProgress(task) {
    return isStatusOneOf(task, 'FAILURE_HANDLER_IN_PROGRESS');
  }

  function isTaskAbortScriptInProgress(task) {
    return isStatusOneOf(task, 'ABORT_SCRIPT_IN_PROGRESS');
  }

  function isTaskOrPreconditionInProgress(task) {
    return isTaskInProgress(task) || isTaskPreconditionInProgress(task) || isTaskFailureHandlerInProgress(task) || isTaskAbortScriptInProgress(task) || isTaskFacetInProgress(task);
  }

  function isTaskCompleted(task) {
    return isStatusOneOf(task, 'COMPLETED', 'ABORTED');
  }

  function isTaskCompletedInAdvance(task) {
    return isStatusOneOf(task, 'COMPLETED_IN_ADVANCE');
  }

  function isTaskSkippedInAdvance(task) {
    return isStatusOneOf(task, 'SKIPPED_IN_ADVANCE');
  }

  function isTaskDraggable(task, container) {
    var isReorderable = isTaskPlannedOrDoneInAdvance;

    if (container && isLocked(container)) {
      return false;
    }

    if (!isReorderable(task)) {
      return false;
    }

    return !(container && isParallelGroup(container) && !isReorderable(container));
  }

  function isTaskGroupDroppable(container) {
    if (!isTaskGroup(container) || isLocked(container)) {
      return false;
    }

    if (isParallelGroup(container)) {
      return isTaskPlanned(container) || isTaskPending(container);
    }

    if (isSequentialGroup(container)) {
      return !isTaskReadOnly(container);
    }
  }

  function isTaskSkipped(task) {
    return isStatusOneOf(task, 'SKIPPED');
  }

  function areAllRequiredValuesPresent(task) {
    var isRequiredAndEmpty = function isRequiredAndEmpty(v) {
      return v.requiresValue === true && (v.value === null || v.value === angular.undefined);
    };

    var emptyRequiredVariables = _.find(task.variables, function (v) {
      return isRequiredAndEmpty(v);
    });

    return !_.isObject(emptyRequiredVariables);
  }

  function noInProgressVariableUpdate(task) {
    return !task.updatingVariablesCount || task.updatingVariablesCount === 0;
  }

  function isTaskFailed(task) {
    return isStatusOneOf(task, 'FAILED');
  }

  function isTaskFailing(task) {
    return isStatusOneOf(task, 'FAILING');
  }

  function isTaskDoneInAdvance(task) {
    return isTaskCompletedInAdvance(task) || isTaskSkippedInAdvance(task);
  }

  function isTaskPlannedOrDoneInAdvance(task) {
    return isTaskPlanned(task) || isTaskDoneInAdvance(task);
  }

  function isTaskWaitingForInput(task) {
    return isStatusOneOf(task, 'WAITING_FOR_INPUT');
  }

  function isUserInputTask(task) {
    return 'xlrelease.UserInputTask' === task.type;
  }

  function hasConfigurationUri(task) {
    return task.configurationUri;
  }

  function getConfigurationUri(task) {
    return 'static/9.7.16/' + task.configurationUri;
  }

  function isGateTask(task) {
    return 'xlrelease.GateTask' === task.type;
  }

  function isNotificationTask(task) {
    return 'xlrelease.NotificationTask' === task.type;
  }

  function isScriptTask(task) {
    return 'xlrelease.ScriptTask' === task.type || 'xlrelease.GroovyScriptTask' === task.type || 'xlrelease.ExternalScriptTask' === task.type;
  }

  function isTaskGroup(task) {
    return isParallelGroup(task) || isSequentialGroup(task);
  }

  function isUnknownTask(task) {
    return "Unknown Type" === task.typeDisplayName;
  }

  function isParallelGroup(task) {
    return 'xlrelease.ParallelGroup' === task.type;
  }

  function isSequentialGroup(task) {
    return 'xlrelease.SequentialGroup' === task.type;
  }

  function isManualTask(task) {
    return 'xlrelease.Task' === task.type;
  }

  function isCustomScriptTask(task) {
    return 'xlrelease.CustomScriptTask' === task.type;
  }

  function isTaskGroupInProgress(task) {
    return isTaskGroup(task) && isTaskInProgress(task);
  }

  function isCreateReleaseTask(task) {
    return 'xlrelease.CreateReleaseTask' === task.type;
  }

  function isParallelGroupInProgress(task) {
    return isParallelGroup(task) && isTaskInProgress(task);
  }

  function isTaskGroupSkippableOrRetriable(group) {
    var subTasks = _.flattenDeep(getSubTasks(group));

    return isTaskGroup(group) && isTaskFailed(group) && _.every(subTasks, isTaskPlannedOrDoneInAdvance);
  }

  function canUserInputTaskBeCompleted(task) {
    return isUserInputTask(task) && isTaskInProgress(task) && areAllRequiredValuesPresent(task) && noInProgressVariableUpdate(task);
  }

  function someGateConditionUnchecked(task) {
    return _.some(task.conditions, {
      checked: false
    });
  }

  function someGateDependencyUnresolved(task) {
    return _.some(task.dependencies, {
      resolved: false
    });
  }

  function isGateClosed(task) {
    return isGateTask(task) && (someGateConditionUnchecked(task) || someGateDependencyUnresolved(task));
  }

  function hasOwner(task) {
    return angular.isDefined(task.owner) && task.owner !== null;
  }

  function hasTeam(task) {
    return angular.isDefined(task.team) && task.team !== null;
  }

  function updateTaskStatusTo(status, id, commentText) {
    var comment = {
      text: commentText
    };
    return Backend.post("tasks/".concat(id, "/").concat(status), comment);
  }

  function startTaskWithInput(id, variables) {
    return Backend.post("api/v1/tasks/".concat(tasks_service_Ids.toDomainId(id), "/start"), {
      variables: variables
    });
  }

  function updateReleaseVariable(variable) {
    VariablesService.updateReleaseVariable(variable);
  }

  function isAutomated(task) {
    return task.automated;
  }

  function getSubTasks(task) {
    if (isTaskGroup(task)) {
      return _.map(task.tasks, getSubTasks);
    }

    return [task];
  }

  function getAllSubTasks(task) {
    var subTasks = [];

    if (isTaskGroup(task)) {
      subTasks = _.map(task.tasks, getAllSubTasks);
    }

    return [subTasks, task];
  }

  function isDone(task) {
    return isStatusOneOf(task, 'COMPLETED', 'SKIPPED');
  }

  function isActive(task) {
    return isStatusOneOf(task, 'PENDING', 'PRECONDITION_IN_PROGRESS', 'WAITING_FOR_INPUT', 'IN_PROGRESS', 'QUEUED', 'FAILURE_HANDLER_QUEUED', 'ABORT_SCRIPT_QUEUED', 'FAILING', 'FAILED');
  }

  function isStatusOneOf(task) {
    return _.includes(arguments, task.status);
  }

  function canDelayTask(task) {
    return isTaskPlanned(task) || isTaskPending(task) || isTaskFailed(task) || isTaskWaitingForInput(task);
  }

  function isTaskDelayedDuringBlackout(task) {
    return task.delayDuringBlackout && canDelayTask(task);
  }

  function isTask(task) {
    return task.type !== 'xlrelease.ScmConnectedTemplate' && task.type !== 'xlrelease.Release' && task.type !== 'xlrelease.Phase';
  }

  function isTaskReadOnly(task) {
    return isTaskCompleted(task) || isTaskSkipped(task) || isTaskDoneInAdvance(task);
  }

  function isRemoveEnabled(task, release, container) {
    return canExecuteActionOnLockedTask(task, container) && !isTaskReadOnly(task) && !isTaskPending(task) && !isTaskWaitingForInput(task) && !isTaskInProgress(task) && !isTaskFailed(task) && !isParallelGroupInProgress(container) && !isTaskFailureHandlerInProgress(task) && !isTaskAbortScriptInProgress(task) && !isTaskFacetInProgress(task) && Authenticator.hasEditPermission(release);
  }

  function isDuplicateEnabled(task, release, container) {
    return canExecuteActionOnLockedTask(task, container) && (!isTaskReadOnly(task) || isTaskDoneInAdvance(task)) && Authenticator.hasEditPermission(release) && !isParallelGroupInProgress(container);
  }

  function hasPermissionToWorkOnTask(release, task) {
    return Authenticator.hasPermissionToWorkOnTask(release, task);
  }

  function canWorkOnReadOnlyTask(release, task) {
    return hasPermissionToWorkOnTask(release, task);
  }

  function canUpdateFailedStatus(task) {
    return isTaskFailed(task) && (isAutomated(task) || hasOwner(task) || hasTeam(task));
  }

  function canWorkOnTask(release, task) {
    if (isTaskReadOnly(task)) {
      return false;
    }

    return hasPermissionToWorkOnTask(release, task);
  }

  function canStartTask(release, task) {
    return !isTaskReadOnly(task) && (hasPermissionToWorkOnTask(release, task) || Authenticator.hasTaskTransitionPermission(release));
  }

  function canCompleteTask(release, task) {
    if (!isTaskGroup(task) && !isAutomated(task)) {
      var canPerformTaskTransition = !isTaskReadOnly(task) && (hasPermissionToWorkOnTask(release, task) || Authenticator.hasTaskTransitionPermission(release));

      if (isTaskPlanned(task) && tasks_service_ReleasesStatusService.isReleaseActive(release) && canPerformTaskTransition) {
        return canExecuteActionOnLockedTask(task) && canUpdatePlannedStatus(task) && !isGateClosed(task);
      }

      if (isTaskInProgress(task) && canUpdateInProgressStatus(task) && !isGateClosed(task) && canPerformTaskTransition) {
        return isUserInputTask(task) ? canUserInputTaskBeCompleted(task) : true;
      }
    }

    return false;
  }

  function canEditTask(release, task) {
    return Authenticator.hasEditTaskPermission(release) && !isTaskReadOnly(task) && task.editable;
  }

  function canEditTaskTitleAndDescription(release, task) {
    var isEditable = !isTaskReadOnly(task) && task.editable;
    return isEditable && (Authenticator.hasEditTaskPermission(release) || Authenticator.hasEditTaskDescription(release));
  }

  function canEditTaskDates(release, task) {
    var isEditable = !isTaskReadOnly(task) && task.editable;
    return isEditable && (Authenticator.hasEditTaskPermission(release) || Authenticator.hasEditTaskDatesPermission(release));
  }

  function canEditTaskFlag(release, task) {
    var isEditable = !isTaskReadOnly(task) && task.editable;
    return isEditable && (Authenticator.hasEditTaskPermission(release) || Authenticator.hasEditTaskFlagPermission(release));
  }

  function canEditTaskConfigurationPropertiesAndTaskNotInProgress(release, task) {
    return !isTaskInProgress(task) && canEditTaskConfigurationProperties(release, task);
  }

  function canEditTaskTags(release, task) {
    var hasPermissionToEditTaskTag = Authenticator.hasEditTaskPermission(release) || Authenticator.hasEditTaskTagsPermission(release);
    return !isTaskReadOnly(task) && task.editable && hasPermissionToEditTaskTag;
  }

  function canEditTaskConfigurationProperties(release, task) {
    return task.editable && (Authenticator.hasEditTaskConfigurationPropertiesPermission(release) || canEditTask(release, task));
  }

  function canEditTaskAttachment(release, task) {
    return task.editable && (Authenticator.hasEditTaskAttachmentPermission(release) || canEditTask(release, task));
  }

  function canEditTaskConfigurationFacet(release) {
    return Authenticator.hasEditTaskConfigurationFacetPermission(release);
  }

  function canEditTaskScript(release, task) {
    return !isTaskInProgress(task) && task.editable && (Authenticator.hasEditTaskScriptPermission(release) || canEditTask(release, task));
  }

  function canEditBlackout(release, task) {
    return Authenticator.hasEditBlackoutPermission(release) || canEditTask(release, task);
  }

  function canEditFailureHandler(release, task) {
    var canWorkOnTask = !isTaskReadOnly(task) && task.editable;
    return canWorkOnTask && (Authenticator.hasEditFailureHandlerPermission(release) || release.status !== 'TEMPLATE' && Authenticator.hasEditTaskPermission(release));
  }

  function canEditPrecondition(release, task) {
    var canWorkOnTask = !isTaskReadOnly(task) && task.editable;
    return canWorkOnTask && (Authenticator.hasEditPreconditionPermission(release) || release.status !== 'TEMPLATE' && Authenticator.hasEditTaskPermission(release));
  }

  function areTaskPropertiesReadonly(release, task) {
    return !canEditTask(release, task) || isTaskInProgress(task);
  }

  function canUpdateCommentOnTask(release, task, comment) {
    return canEditTask(release, task) || comment.author.username === Authenticator.getUsername();
  }

  function canAddTask(release, taskGroup) {
    if (isLocked(taskGroup) || !Authenticator.hasEditPermission(release)) {
      return false;
    }

    if (isParallelGroup(taskGroup)) {
      return isTaskPlanned(taskGroup);
    }

    if (isSequentialGroup(taskGroup)) {
      return !isTaskReadOnly(taskGroup);
    }

    return false;
  }

  function canEditWaitForScheduledStartDate(release) {
    return Authenticator.hasEditTaskOrEditDatesPermission(release);
  }

  function canEditEnvironmentAvailability(release) {
    return Authenticator.hasEditTaskOrEditBlackoutPermission(release);
  }

  function addTask(container, taskForm) {
    return Backend.post("tasks/".concat(container.id), taskForm).then(function (addedTaskResp) {
      var addedTask = addedTaskResp.data;

      if (taskForm.taskType === 'xlrelease.ParallelGroup' || taskForm.taskType === 'xlrelease.SequentialGroup') {
        addedTask.wasJustAdded = true;
      }

      container.tasks.push(addedTask);
      return addedTask;
    });
  }

  function deleteTask(container, taskToDelete) {
    return Backend.del("tasks/".concat(taskToDelete.id)).then(function () {
      container.tasks = _.reject(container.tasks, {
        id: taskToDelete.id
      });
    });
  }

  function updateTask(task) {
    var taskForm = toTaskFullView(task);
    return Backend.put("tasks/".concat(taskForm.id), taskForm);
  }

  function duplicateTask(release, task, container) {
    return Backend.put("releases/".concat(release.id, "/tasks/duplicate/").concat(task.id)).then(function (duplicatedTaskResp) {
      var duplicatedTask = duplicatedTaskResp.data;

      _.forEach(container.tasks, function (aTask, index) {
        if (aTask.id === task.id) {
          container.tasks.splice(index + 1, 0, duplicatedTask);
        }
      });

      return duplicatedTask;
    });
  }

  function changeTaskType(container, task, convertToType) {
    task.disabledInView = true;
    return Backend.post("tasks/".concat(task.id, "/changeType?targetType=").concat(convertToType)).then(function (newTaskResp) {
      task.disabledInView = false;
      var newTask = newTaskResp.data;
      newTask.$$hashKey = task.$$hashKey; //otherwise angular data-binding will be broken

      container.tasks[container.tasks.indexOf(task)] = newTask;
      return newTask;
    }).catch(function () {
      return task.disabledInView = false;
    });
  }

  function getTaskVariables(task) {
    return Backend.get("api/v1/tasks/".concat(tasks_service_Ids.toDomainId(task.id), "/variables"));
  }

  function isAssignedToUser(task, user) {
    return hasOwner(task) && user && task.owner.username.toLowerCase() === user.username.toLowerCase();
  }

  function canAssignTaskToCurrentUser(task, release) {
    var taskNotAssignedToCurrentUser = !isAssignedToUser(task, UserProfile.getCurrentUser());
    var taskIsEditable = !isTaskReadOnly(task) && task.editable;
    var userHasReassignTaskPermission = Authenticator.hasEditTaskPermission(release) || Authenticator.hasReassignTaskPermission(release);
    var userInTeam = release.security.teams.includes(task.team);
    return taskNotAssignedToCurrentUser && taskIsEditable && (Authenticator.isAdmin() || userHasReassignTaskPermission && !isLocked(task) || userInTeam);
  }

  function canReassignTask(release, task) {
    var taskIsNotReadOnly = !isTaskReadOnly(task);
    var userHasReassignPermission = Authenticator.hasEditTaskPermission(release) || Authenticator.hasReassignTaskPermission(release);
    return canExecuteActionOnLockedTask(task) && userHasReassignPermission && taskIsNotReadOnly && task.editable;
  }

  function canExecuteActionOnLockedTask(task, container) {
    if (angular.isDefined(container) && isTaskGroup(container) && container.locked) {
      return false;
    }

    return !task.locked;
  }

  function assignToCurrentUser(task) {
    task.owner = UserProfile.getCurrentUser();
    return Backend.put("tasks/".concat(task.id, "/owner"), toTaskFullView(task)).then(function () {
      TaskDetailsUpdates.assigneeChanged = true;
    });
  }

  function getTask(taskId) {
    return Backend.get("tasks/".concat(taskId));
  }

  function toTaskFullView(task) {
    return {
      checkAttributes: task.checkAttributes,
      cc: task.cc,
      bcc: task.bcc,
      replyTo: task.replyTo,
      from: task.from,
      mailPriority: task.mailPriority,
      addresses: task.addresses,
      body: task.body,
      createdReleaseId: task.createdReleaseId,
      delayDuringBlackout: task.delayDuringBlackout,
      deploymentPackage: task.deploymentPackage,
      description: task.description,
      dueDate: task.dueDate,
      environment: task.environment,
      failureHandler: task.failureHandler,
      taskFailureHandlerEnabled: task.taskFailureHandlerEnabled,
      taskRecoverOp: task.taskRecoverOp,
      flag: task.flag,
      gateId: task.gateId,
      id: task.id,
      inputProperties: task.inputProperties,
      newReleaseTitle: task.newReleaseTitle,
      outputProperties: task.outputProperties,
      owner: task.owner,
      password: task.password,
      plannedDuration: task.plannedDuration,
      precondition: task.precondition,
      releaseTags: task.releaseTags,
      riskProfileId: task.riskProfileId,
      scheduledStartDate: task.scheduledStartDate,
      script: task.script,
      scriptDefinitionType: task.scriptDefinitionType,
      server: task.server,
      startRelease: task.startRelease,
      subject: task.subject,
      tags: task.tags,
      team: task.team,
      templateId: task.templateId,
      folderId: task.folderId,
      title: task.title,
      type: task.type,
      username: task.username,
      variableMapping: task.variableMapping,
      variables: VariablesService.toSerializableVariables(task.variables),
      waitForScheduledStartDate: task.waitForScheduledStartDate,
      ignoreScriptVariableInterpolation: task.ignoreScriptVariableInterpolation,
      keepPreviousOutputPropertiesOnRetry: angular.isDefined(task.keepPreviousOutputPropertiesOnRetry) ? task.keepPreviousOutputPropertiesOnRetry : false
    };
  }

  function canUpdateInProgressStatus(task) {
    return isTaskInProgress(task) && !isAutomated(task) && (hasOwner(task) || hasTeam(task));
  }

  function canUpdatePlannedStatus(task) {
    return isTaskPlanned(task) && (hasOwner(task) || hasTeam(task));
  }

  function canSkipTask(release, task) {
    if (!task.locked && !isUserInputTask(task)) {
      if (isTaskInProgress(task) && !isAutomated(task)) {
        var canPerformTaskTransition = canUpdateInProgressStatus(task) && !isTaskReadOnly(task);
        return canPerformTaskTransition && (hasPermissionToWorkOnTask(release, task) || Authenticator.hasTaskTransitionPermission(release));
      }

      if (isTaskPlanned(task) && tasks_service_ReleasesStatusService.isReleaseActive(release) && !isTaskGroup(task)) {
        var _canPerformTaskTransition = canUpdatePlannedStatus(task) && !isTaskReadOnly(task);

        return _canPerformTaskTransition && (hasPermissionToWorkOnTask(release, task) || Authenticator.hasTaskTransitionPermission(release));
      }

      if (isTaskFailed(task) && (!isTaskGroup(task) || isTaskGroupSkippableOrRetriable(task))) {
        var _canPerformTaskTransition2 = canUpdateFailedStatus(task) && !isTaskReadOnly(task) && (!isTaskGroup(task) || isTaskGroupSkippableOrRetriable(task));

        return _canPerformTaskTransition2 && (hasPermissionToWorkOnTask(release, task) || Authenticator.hasTaskTransitionPermission(release));
      }
    } else {
      return false;
    }
  }

  function canFailTask(release, task) {
    if (!isTaskReadOnly(task) && isTaskInProgress(task) && !isAutomated(task) && !isTaskGroup(task)) {
      var canPerformTaskTransition = canUpdateInProgressStatus(task) && !isTaskReadOnly(task);
      return canPerformTaskTransition && (hasPermissionToWorkOnTask(release, task) || Authenticator.hasTaskTransitionPermission(release));
    }

    return false;
  }

  function canRetryTask(release, task) {
    if (isTaskFailed(task) && (!isTaskGroup(task) && !isUnknownTask(task) || isTaskGroupSkippableOrRetriable(task))) {
      var canPerformTaskTransition = canUpdateFailedStatus(task) && !isTaskReadOnly(task) && (!isTaskGroup(task) || isTaskGroupSkippableOrRetriable(task));
      return canPerformTaskTransition && (Authenticator.hasTaskTransitionPermission(release) || Authenticator.isAdminOr(task.releaseOwner) || hasPermissionToWorkOnTask(release, task));
    }

    return false;
  }

  function canAbortTask(release, task) {
    if (isInProgressScriptTask(task) || isQueuedScriptTask(task) || isTaskPreconditionInProgress(task) || isTaskFailureHandlerInProgress(task) || isTaskFacetInProgress(task) || isTaskAbortScriptInProgress(task)) {
      var canPerformTaskTransition = !isTaskReadOnly(task);
      return canPerformTaskTransition && (hasPermissionToWorkOnTask(release, task) || Authenticator.hasTaskTransitionPermission(release));
    }

    return false;
  }

  function canReopenTask(release, task) {
    if (tasks_service_ReleasesStatusService.isReleaseActive(release) && isTaskDoneInAdvance(task) && !isTaskGroup(task)) {
      return canWorkOnReadOnlyTask(release, task) || Authenticator.hasTaskTransitionPermission(release);
    }

    return false;
  }

  function canWorkOnFailedTask(release, task) {
    return canUpdateFailedStatus(task) && canWorkOnTask(release, task) && (!isTaskGroup(task) || isTaskGroupSkippableOrRetriable(task));
  }

  function isInProgressScriptTask(task) {
    return (isScriptTask(task) || isCustomScriptTask(task)) && isTaskInProgress(task);
  }

  function isQueuedScriptTask(task) {
    return (isScriptTask(task) || isCustomScriptTask(task)) && isTaskQueued(task);
  }

  var isLocked = function isLocked(task) {
    return task.locked;
  };

  var lock = function lock(taskId) {
    return Backend.put("api/v1/tasks/".concat(tasks_service_Ids.toDomainId(taskId), "/lock"));
  };

  var unlock = function unlock(taskId) {
    return Backend.del("api/v1/tasks/".concat(tasks_service_Ids.toDomainId(taskId), "/lock"));
  };

  var toInternalId = function toInternalId(releaseId) {
    return tasks_service_Ids.toInternalId(releaseId);
  };

  var hasDeploymentFacet = function hasDeploymentFacet(task) {
    return task.facets.filter(function (f) {
      return f.type === 'udm.DeploymentTaskFacet';
    }).length > 0;
  };

  var getLatestTaskActivityLog = function getLatestTaskActivityLog(releaseId, taskId) {
    var filters = {
      "important": false,
      "releaseEdit": false,
      "taskEdit": false,
      "comments": false,
      "lifecycle": true,
      "reassign": false,
      "security": false,
      "other": false,
      "dateAsc": false,
      "filter": "",
      "targetId": taskId
    };
    return Backend.post("activity/".concat(releaseId, "/logs/search"), filters).then(function (resp) {
      return _.head(resp.data);
    });
  };

  return {
    toInternalId: toInternalId,
    hasOwner: hasOwner,
    hasTeam: hasTeam,
    isTaskPlanned: isTaskPlanned,
    isTaskPending: isTaskPending,
    isTaskInProgress: isTaskInProgress,
    isTaskQueued: isTaskQueued,
    isTaskFacetInProgress: isTaskFacetInProgress,
    isTaskPreconditionInProgress: isTaskPreconditionInProgress,
    isTaskFailureHandlerInProgress: isTaskFailureHandlerInProgress,
    isTaskAbortScriptInProgress: isTaskAbortScriptInProgress,
    isTaskOrPreconditionInProgress: isTaskOrPreconditionInProgress,
    isTaskCompleted: isTaskCompleted,
    isTaskCompletedInAdvance: isTaskCompletedInAdvance,
    isTaskSkippedInAdvance: isTaskSkippedInAdvance,
    isTaskDraggable: isTaskDraggable,
    isTaskGroupDroppable: isTaskGroupDroppable,
    isTaskSkipped: isTaskSkipped,
    isTaskFailed: isTaskFailed,
    isTaskFailing: isTaskFailing,
    isTaskDoneInAdvance: isTaskDoneInAdvance,
    isTaskWaitingForInput: isTaskWaitingForInput,
    isUserInputTask: isUserInputTask,
    isAutomated: isAutomated,
    canDelayTask: canDelayTask,
    isTaskDelayedDuringBlackout: isTaskDelayedDuringBlackout,
    isGateTask: isGateTask,
    isNotificationTask: isNotificationTask,
    isScriptTask: isScriptTask,
    isCustomScriptTask: isCustomScriptTask,
    isManualTask: isManualTask,
    isUnknownTask: isUnknownTask,
    isTaskGroup: isTaskGroup,
    isParallelGroup: isParallelGroup,
    isSequentialGroup: isSequentialGroup,
    isTaskGroupInProgress: isTaskGroupInProgress,
    isCreateReleaseTask: isCreateReleaseTask,
    isParallelGroupInProgress: isParallelGroupInProgress,
    isGateClosed: isGateClosed,
    getSubTasks: getSubTasks,
    getAllSubTasks: getAllSubTasks,
    isTaskGroupSkippableOrRetriable: isTaskGroupSkippableOrRetriable,
    canUserInputTaskBeCompleted: canUserInputTaskBeCompleted,
    areAllRequiredValuesPresent: areAllRequiredValuesPresent,
    isActive: isActive,
    isDone: isDone,
    isTaskReadOnly: isTaskReadOnly,
    isRemoveEnabled: isRemoveEnabled,
    isDuplicateEnabled: isDuplicateEnabled,
    hasPermissionToWorkOnTask: hasPermissionToWorkOnTask,
    canUpdateFailedStatus: canUpdateFailedStatus,
    canWorkOnReadOnlyTask: canWorkOnReadOnlyTask,
    canWorkOnTask: canWorkOnTask,
    canEditTask: canEditTask,
    canEditTaskConfigurationProperties: canEditTaskConfigurationProperties,
    canEditTaskAttachment: canEditTaskAttachment,
    canEditTaskConfigurationFacet: canEditTaskConfigurationFacet,
    canEditTaskScript: canEditTaskScript,
    canEditTaskConfigurationPropertiesAndTaskNotInProgress: canEditTaskConfigurationPropertiesAndTaskNotInProgress,
    canEditBlackout: canEditBlackout,
    canEditFailureHandler: canEditFailureHandler,
    canEditPrecondition: canEditPrecondition,
    canReassignTask: canReassignTask,
    areTaskPropertiesReadonly: areTaskPropertiesReadonly,
    canUpdateCommentOnTask: canUpdateCommentOnTask,
    canAddTask: canAddTask,
    canEditWaitForScheduledStartDate: canEditWaitForScheduledStartDate,
    canEditEnvironmentAvailability: canEditEnvironmentAvailability,
    addTask: addTask,
    deleteTask: deleteTask,
    duplicateTask: duplicateTask,
    updateTask: updateTask,
    changeTaskType: changeTaskType,
    startTaskWithInput: startTaskWithInput,
    getTaskVariables: getTaskVariables,
    assignToCurrentUser: assignToCurrentUser,
    getTask: getTask,
    isAssignedToUser: isAssignedToUser,
    canAssignTaskToCurrentUser: canAssignTaskToCurrentUser,
    toTaskFullView: toTaskFullView,
    hasConfigurationUri: hasConfigurationUri,
    getConfigurationUri: getConfigurationUri,
    canCompleteTask: canCompleteTask,
    canStartTask: canStartTask,
    canSkipTask: canSkipTask,
    canFailTask: canFailTask,
    canRetryTask: canRetryTask,
    canAbortTask: canAbortTask,
    canReopenTask: canReopenTask,
    canEditTaskTags: canEditTaskTags,
    canExecuteActionOnLockedTask: canExecuteActionOnLockedTask,
    canEditTaskTitleAndDescription: canEditTaskTitleAndDescription,
    canEditTaskDates: canEditTaskDates,
    canEditTaskFlag: canEditTaskFlag,
    updateReleaseVariable: updateReleaseVariable,
    isTaskAborted: function isTaskAborted(task) {
      return 'ABORTED' === task.status;
    },
    canUpdateInProgressStatus: canUpdateInProgressStatus,
    canWorkOnFailedTask: canWorkOnFailedTask,
    canUpdatePlannedStatus: canUpdatePlannedStatus,
    isInProgressScriptTask: isInProgressScriptTask,
    isQueuedScriptTask: isQueuedScriptTask,
    isStatusUpdatable: function isStatusUpdatable(task) {
      return isTaskInProgress(task) && !isAutomated(task) && (hasOwner(task) || hasTeam(task));
    },
    completeTask: function completeTask(taskId, commentText) {
      return updateTaskStatusTo('complete', taskId, commentText);
    },
    failTask: function failTask(taskId, commentText) {
      return updateTaskStatusTo('fail', taskId, commentText);
    },
    abortTask: function abortTask(taskId, commentText) {
      return updateTaskStatusTo('abort', taskId, commentText);
    },
    skipTask: function skipTask(taskId, commentText) {
      return updateTaskStatusTo('skip', taskId, commentText);
    },
    retryTask: function retryTask(taskId, commentText) {
      return updateTaskStatusTo('retry', taskId, commentText);
    },
    cancelTask: function cancelTask(taskId, commentText) {
      return updateTaskStatusTo('cancel', taskId, commentText);
    },
    startNow: function startNow(taskId, commentText) {
      return updateTaskStatusTo('startNow', taskId, commentText);
    },
    reopenTask: function reopenTask(taskId, commentText) {
      return updateTaskStatusTo('reopen', taskId, commentText);
    },
    isTaskDelayed: function isTaskDelayed(task) {
      if (!isTaskPlanned(task)) return false;
      return tasks_service_DateService.isOverdue(task.scheduledStartDate) || tasks_service_DateService.isOverdue(task.dueDate);
    },
    isAssignedToTeam: function isAssignedToTeam(task, team) {
      return hasTeam(task) && task.team === team;
    },
    isTask: isTask,
    isChangeTypeEnabled: function isChangeTypeEnabled(task, release, container) {
      return canExecuteActionOnLockedTask(task, container) && isRemoveEnabled(task, release, container) && !isTaskGroup(task);
    },
    isOfType: function isOfType(task, taskDefinition) {
      return taskDefinition.typeName === task.type || taskDefinition.typeName === task.scriptDefinitionType;
    },
    isValidCollapsedState: function isValidCollapsedState(state) {
      return _.isBoolean(state);
    },
    isLocked: isLocked,
    lock: lock,
    unlock: unlock,
    hasDeploymentFacet: hasDeploymentFacet,
    getLatestTaskActivityLog: getLatestTaskActivityLog
  };
}

TaskService.$inject = ['Backend', 'Authenticator', 'UserProfile', 'TaskDetailsUpdates', 'VariablesService'];
angular.module('xlrelease').constant('TaskConstants', {
  LIMIT_TASKS_HINT: 50
});
angular.module('xlrelease').factory('TasksService', TaskService);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/user-input-details-controller.js
var user_input_details_controller = __webpack_require__(958);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/templates/templates-controller.js
var templates_controller = __webpack_require__(959);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/templates/templates-service.js



(function () {
  'use strict';

  var DEFAULT_TEMPLATE_LIST_SIZE = 100;
  var DEFAULT_TEMPLATE_LIST_DEPTH = 1;

  var TemplatesService = /*#__PURE__*/function () {
    function TemplatesService(Backend) {
      classCallCheck_default()(this, TemplatesService);

      this._backend = Backend;
    }

    createClass_default()(TemplatesService, [{
      key: "getAll",
      value: function getAll() {
        return this._backend.post('releases/templates/search', {}, {
          params: {
            numberbypage: DEFAULT_TEMPLATE_LIST_SIZE,
            depth: DEFAULT_TEMPLATE_LIST_DEPTH
          }
        });
      }
    }, {
      key: "getById",
      value: function getById(releaseId) {
        return this._backend.get("releases/".concat(releaseId));
      }
    }, {
      key: "getTemplateTitleById",
      value: function getTemplateTitleById(templateId) {
        return this._backend.get('releases/template/search', {
          params: {
            matchTemplate: templateId
          }
        });
      }
    }, {
      key: "getAllIds",
      value: function getAllIds(matchTitle) {
        return this._backend.get('releases/templates/search', {
          params: {
            numberbypage: DEFAULT_TEMPLATE_LIST_SIZE,
            matchTemplate: matchTitle
          }
        });
      }
    }, {
      key: "getAllIdsWithPermission",
      value: function getAllIdsWithPermission(permission) {
        var folderId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
        var params = {
          params: {
            numberbypage: DEFAULT_TEMPLATE_LIST_SIZE,
            permission: permission
          }
        };

        if (!_.isUndefined(folderId)) {
          params.params.folderId = folderId;
        }

        return this._backend.get('releases/templates/search', params);
      }
    }, {
      key: "search",
      value: function search(filters, config) {
        return this._backend.post('releases/templates/search', filters, config);
      }
    }, {
      key: "create",
      value: function create(template) {
        var templateForm = {
          title: template.title,
          description: template.description,
          tags: template.tags,
          scheduledStartDate: template.scheduledStartDate,
          dueDate: template.dueDate,
          plannedDuration: template.plannedDuration,
          abortOnFailure: template.abortOnFailure,
          allowPasswordsInAllFields: template.allowPasswordsInAllFields,
          allowConcurrentReleasesFromTrigger: template.allowConcurrentReleasesFromTrigger,
          scriptUsername: template.scriptUsername,
          scriptUserPassword: template.scriptUserPassword,
          variables: template.variables,
          syntheticProperties: template.syntheticProperties,
          parentId: template.parentId
        };
        return this._backend.post('releases/templates', templateForm);
      }
    }, {
      key: "update",
      value: function update(templateId, template) {
        var templateForm = {
          title: template.title,
          description: template.description,
          tags: template.tags,
          scheduledStartDate: template.scheduledStartDate,
          dueDate: template.dueDate,
          plannedDuration: template.plannedDuration,
          abortOnFailure: template.abortOnFailure,
          allowPasswordsInAllFields: template.allowPasswordsInAllFields,
          allowConcurrentReleasesFromTrigger: template.allowConcurrentReleasesFromTrigger,
          scriptUsername: template.scriptUsername,
          scriptUserPassword: template.scriptUserPassword,
          variables: template.variables,
          syntheticProperties: template.syntheticProperties
        };
        return this._backend.put('releases/templates/' + templateId, templateForm);
      }
    }]);

    return TemplatesService;
  }();

  TemplatesService.$inject = ['Backend'];
  angular.module('xlrelease').service('TemplatesService', TemplatesService);
})();
// EXTERNAL MODULE: ./core/xlr-ui/app/js/upload/upload-controller.js
var upload_controller = __webpack_require__(960);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/upload/upload-directive.js
var upload_directive = __webpack_require__(961);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/upload/upload-service.js
var upload_service = __webpack_require__(962);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/upload/content-type-service.js




var content_type_service_ContentTypeService = /*#__PURE__*/function () {
  function ContentTypeService(Backend) {
    classCallCheck_default()(this, ContentTypeService);

    this._Backend = Backend;
  }

  createClass_default()(ContentTypeService, [{
    key: "getContentTypesForImage",
    value: function getContentTypesForImage() {
      return this._Backend.get('settings/content-type/image');
    }
  }]);

  return ContentTypeService;
}();

defineProperty_default()(content_type_service_ContentTypeService, "$inject", ['Backend']);

angular.module('xlrelease').service('ContentTypeService', content_type_service_ContentTypeService);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/bootstrap-modal-patch.js
var bootstrap_modal_patch = __webpack_require__(451);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/ci-manager.js
var ci_manager = __webpack_require__(963);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/cis-loader.js
var cis_loader = __webpack_require__(964);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/util/client-settings.js


function client_settings_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function client_settings_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { client_settings_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { client_settings_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

angular.module('xlrelease').factory('ClientSettings', ['LocalStorageWrapper', 'DateService', function (LocalStorageWrapper, DateService) {
  var localStorageCache = {};
  var knownItems = [{
    name: 'AttachmentsState',
    mapItem: true,
    daysValidity: 8
  }, {
    name: 'AuthenticationData'
  }, {
    name: 'CalendarFilters'
  }, {
    name: 'CommentsState',
    mapItem: true,
    daysValidity: 8
  }, {
    name: 'FacetsCollapseState',
    mapItem: true,
    daysValidity: 8
  }, {
    name: 'FailureHandlerCollapseState',
    mapItem: true,
    daysValidity: 8
  }, {
    name: 'FolderLayoutCache'
  }, {
    name: 'FolderListCache'
  }, {
    name: 'FolderReleaseFiltersLayout'
  }, {
    name: 'GanttDatesColumnsCollapseState'
  }, {
    name: 'GanttElementsCollapseState'
  }, {
    name: 'GanttZoomLevel'
  }, {
    name: 'GroupsListFilters'
  }, {
    name: 'DeliveryListFilters'
  }, {
    name: 'IdentityProvider'
  }, {
    name: 'LogsFilters',
    mapItem: true,
    daysValidity: 30
  }, {
    name: 'Permissions'
  }, {
    name: 'PreConditionCollapseState',
    mapItem: true,
    daysValidity: 8
  }, {
    name: 'ReleaseEditorCollapseState',
    mapItem: true,
    daysValidity: 30
  }, {
    name: 'ReleaseEditorTaskFilters',
    mapItem: true,
    daysValidity: 30
  }, {
    name: 'ReleaseFiltersLayout'
  }, {
    name: 'TaskFiltersLayout'
  }, {
    name: 'ReleaseGridCache'
  }, {
    name: 'ReleasesListFilters'
  }, {
    name: 'ReleaseValueStreamFilters'
  }, {
    name: 'ReportsFilters'
  }, {
    name: 'RestartPhaseVersion'
  }, {
    name: 'TasksFilters'
  }, {
    name: 'TemplatesListFilters'
  }, {
    name: 'FolderDashboardListFilters'
  }, {
    name: 'FolderTriggersFilters'
  }];

  function generateGetter(name) {
    return function () {
      var data = localStorageCache[name];

      if (angular.isUndefined(data) || data === null) {
        data = LocalStorageWrapper.getItem(name);

        if (data) {
          localStorageCache[name] = data;
        }
      }

      return data ? angular.fromJson(data) : null;
    };
  }

  function generateMapItemGetter(name) {
    return function (id) {
      var data;
      var rawMap = localStorageCache[name];

      if (rawMap) {
        var map = angular.fromJson(rawMap);
        data = map[id];

        if (angular.isUndefined(data) || data === null) {
          data = fromRefreshedCache(name, id);
        }
      } else {
        data = fromRefreshedCache(name, id);
      }

      return data;
    };
  }

  function fromRefreshedCache(name, id) {
    var rawMap = LocalStorageWrapper.getItem(name);
    localStorageCache[name] = rawMap;

    if (rawMap) {
      var map = angular.fromJson(rawMap);
      return map ? map[id] : null;
    }

    return null;
  }

  function generateSetter(name) {
    return function (value) {
      localStorageCache[name] = angular.toJson(value);
      LocalStorageWrapper.setItem(name, angular.toJson(value));
    };
  }

  function generateUpdater(name) {
    return function (value) {
      var rawValue = LocalStorageWrapper.getItem(name);

      if (_.isEmpty(rawValue)) {
        localStorageCache[name] = angular.toJson(value);
        LocalStorageWrapper.setItem(name, angular.toJson(value));
      } else {
        var savedValue = angular.fromJson(rawValue);

        var newValue = client_settings_objectSpread({}, savedValue, {}, value);

        localStorageCache[name] = angular.toJson(newValue);
        LocalStorageWrapper.setItem(name, angular.toJson(newValue));
      }
    };
  }

  function generateMapItemSetter(name, daysValidity) {
    return function (id, value) {
      var rawMap = localStorageCache[name];
      var map = rawMap ? angular.fromJson(rawMap) : {
        validities: {}
      };
      map[id] = value;

      if (daysValidity) {
        storeValidity(map, id);
        cleanInvalids(map);
      }

      localStorageCache[name] = angular.toJson(map);
      LocalStorageWrapper.setItem(name, angular.toJson(map));
    };

    function storeValidity(map, id) {
      map.validities[id] = DateService.getTodayWithTime().add(daysValidity, 'days').valueOf();
    }

    function cleanInvalids(map) {
      var now = DateService.getTodayWithTime().valueOf();

      _.forOwn(map.validities, function (timestamp, id) {
        if (parseInt(timestamp, 10) < now) {
          delete map[id];
          delete map.validities[id];
        }
      });
    }
  }

  function generateMapItemRemover(name) {
    return function (id) {
      var rawMap = localStorageCache[name];

      if (!rawMap) {
        rawMap = LocalStorageWrapper.getItem(name);
      }

      var map = angular.fromJson(rawMap);
      delete map[id];
      localStorageCache[name] = angular.toJson(map);
      LocalStorageWrapper.setItem(name, angular.toJson(map));
    };
  }

  function generateRemover(name) {
    return function () {
      LocalStorageWrapper.removeItem(name);
      delete localStorageCache[name];
    };
  }

  var result = {
    clear: function clear() {
      _.forEach(knownItems, function (item) {
        LocalStorageWrapper.removeItem(item.name);
        delete localStorageCache[item.name];
      });

      ['filters:releaseOverview'].forEach(function (item) {
        LocalStorageWrapper.removeItem(item);
      });
    }
  };

  _.forEach(knownItems, function (item) {
    result["get".concat(item.name)] = item.mapItem ? generateMapItemGetter(item.name) : generateGetter(item.name);
    result["set".concat(item.name)] = item.mapItem ? generateMapItemSetter(item.name, item.daysValidity) : generateSetter(item.name);
    result["update".concat(item.name)] = item.mapItem ? generateMapItemSetter(item.name, item.daysValidity) : generateUpdater(item.name);
    result["remove".concat(item.name)] = item.mapItem ? generateMapItemRemover(item.name) : generateRemover(item.name);
  });

  return result;
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/color-service.js
var color_service = __webpack_require__(965);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/configuration-item-service.js
var configuration_item_service = __webpack_require__(966);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/delayed-watch.js
var delayed_watch = __webpack_require__(967);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/download-helper.js
var download_helper = __webpack_require__(232);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/util/download.js

angular.module('xlrelease').factory('Download', ['Backend', function (Backend) {
  var addTimestamp = function addTimestamp(url) {
    // Added cache buster to make repeated downloads possible
    var timestamp = new Date().getTime();

    if (url.includes('?')) {
      url = url + '&';
    } else {
      url = url + '?';
    }

    url = url + $.param({
      cb: timestamp
    });
    return url;
  };

  return {
    url: null,
    launch: function launch(url) {
      // Set the iframe URL, which triggers the download
      this.url = addTimestamp(url);
    },
    get: function get(url) {
      Backend.get(addTimestamp(url), {
        headers: {
          'Accept': '*/*'
        },
        responseType: 'blob'
      }).then(function (result) {
        download_helper["a" /* DownloadHelper */].download(result);
      });
    },
    post: function post(url, data) {
      Backend.post(url, data, {
        headers: {
          'Accept': '*/*'
        },
        responseType: 'blob'
      }).then(function (result) {
        download_helper["a" /* DownloadHelper */].download(result);
      });
    }
  };
}]);
angular.module('xlrelease').directive('downloader', ['Download', function (Download) {
  return {
    template: '<iframe ng-src="{{ Download.url }}" style="display: none;"></iframe>',
    link: function link(scope) {
      scope.Download = Download;
    }
  };
}]);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/util/event-bus.js

angular.module('xlrelease').service('EventBus', ['$timeout', function ($timeout) {
  var EventBus = function EventBus() {
    classCallCheck_default()(this, EventBus);

    this.registry = [];
  };

  EventBus.prototype = Object.create(EventEmitter.prototype);
  var eventBus = new EventBus(); // methods to manage registry of wrappers

  EventBus.prototype.addWrapper = function (listener, wrapper) {
    eventBus.registry.push({
      listener: listener,
      wrapper: wrapper
    });
  };

  EventBus.prototype.getWrapper = function (listener) {
    return _.find(eventBus.registry, {
      listener: listener
    }).wrapper;
  };

  EventBus.prototype.removeWrapper = function (wrapper) {
    _.remove(eventBus.registry, {
      wrapper: wrapper
    });
  }; // overriding EventEmitter methods


  EventBus.prototype.addListener = function (event, listener) {
    var wrapper = function wrapper(params) {
      $timeout(function () {
        return listener(params);
      }, 0);
    };

    eventBus.addWrapper(listener, wrapper);
    EventEmitter.prototype.addListener.call(eventBus, event, wrapper);
  };

  EventBus.prototype.removeListener = function (event, listener) {
    var wrapper = eventBus.getWrapper(listener);
    EventEmitter.prototype.removeListener.call(eventBus, event, wrapper);
    eventBus.removeWrapper(wrapper);
  };

  return eventBus;
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/events.js
var util_events = __webpack_require__(968);

// EXTERNAL MODULE: ./node_modules/marked/lib/marked.js
var marked = __webpack_require__(570);
var marked_default = /*#__PURE__*/__webpack_require__.n(marked);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/util/filters.js

angular.module('xlrelease').filter('dateFormatter', ['dateFilter', function (dateFilter) {
  return function (inputDate, format) {
    if (_.isUndefined(inputDate) || _.isNull(inputDate)) {
      return undefined;
    }

    var momentDate = moment(inputDate);

    if (moment().isSame(momentDate, 'day')) {
      return "Today";
    }

    return dateFilter(momentDate.toDate(), format || 'shortDate');
  };
}]).filter('timeFormatter', ['dateFilter', function (dateFilter) {
  return function (inputDate) {
    if (_.isUndefined(inputDate) || _.isNull(inputDate)) {
      return undefined;
    }

    return dateFilter(inputDate, 'shortTime');
  };
}]).filter('statusFormatter', function () {
  var statuses = {
    "TEMPLATE": "Template",
    "PLANNED": "Planned",
    "IN_PROGRESS": "In progress",
    "COMPLETED": "Completed",
    "FAILED": "Failed"
  };
  return function (inputStatus) {
    return statuses[inputStatus];
  };
}).filter('newlines', function () {
  function repeat(string, times) {
    return new Array(times + 1).join(string);
  }

  return function (text) {
    if (_.isUndefined(text) || _.isNull(text)) {
      return text;
    }

    return text.replace(/\t/g, '  ').replace(/^([^\S\n]+)/gm, function (ignored, match) {
      return repeat("&nbsp;", match.length);
    }).replace(/\n/g, '<br/>');
  };
}).filter('noHTML', function () {
  return function (text) {
    if (_.isUndefined(text) || _.isNull(text)) {
      return text;
    }

    return text.replace(/&/g, '&amp;').replace(/>/g, '&gt;').replace(/</g, '&lt;');
  };
}).filter('markdown', function () {
  marked_default.a.setOptions({
    sanitize: true,
    breaks: true
  });
  return function (text) {
    if (!text) {
      return '';
    }

    return marked_default()(text);
  };
}).filter('userFormatter', function () {
  return function (user) {
    if (!user || !user.username) {
      return '';
    }

    return user.fullName ? user.fullName : user.username;
  };
}).filter('usernameFormatter', function () {
  return function (user) {
    if (!user || !user.username) {
      return '';
    }

    return user.fullName ? user.fullName + ' (' + user.username + ')' : user.username;
  };
}).filter('memberFormatter', function () {
  return function (member) {
    if (!member || !member.name) {
      return '';
    }

    return member.fullName ? member.fullName : member.name;
  };
}).filter('memberNameFormatter', function () {
  return function (member) {
    if (!member || !member.name) {
      return '';
    }

    return member.fullName ? member.fullName + ' (' + member.name + ')' : member.name;
  };
}).filter('configurationItemTypeFormatter', function (StringService) {
  return function (type) {
    if (!type) {
      return '';
    }

    var prefix = type.substring(0, type.indexOf('.'));
    var typeName = type.substring(type.indexOf('.') + 1);
    return StringService.capitalizeFirstLetter(prefix) + ': ' + StringService.capitalizeFirstLetter(StringService.deCamelize(typeName).toLowerCase());
  };
}).filter('shortConfigurationItemTypeFormatter', function (StringService) {
  return function (type) {
    if (!type) {
      return '';
    }

    var typeName = type.substring(type.indexOf('.') + 1);
    return StringService.capitalizeFirstLetter(StringService.deCamelize(typeName).toLowerCase());
  };
}).filter('prettyConfigurationItemLabelFormatter', function () {
  return function (label) {
    if (!label) {
      return '';
    }

    return label.split(':').join('');
  };
}).filter('toDate', function () {
  return function (date) {
    return moment.isMoment(date) ? date.toDate() : date;
  };
}).filter('capitalize', function (StringService) {
  return function (input) {
    if (!input) {
      return '';
    }

    return StringService.capitalizeFirstLetter(StringService.deCamelize(input).toLowerCase());
  };
}).filter('normalize', function () {
  return function (input) {
    if (!input) {
      return '';
    }

    return input.replace(/_/g, ' ').toLowerCase();
  };
}).filter('toArray', function () {
  return function (obj, addKey) {
    if (!angular.isObject(obj)) return obj;

    if (addKey === false) {
      return Object.keys(obj).map(function (key) {
        return obj[key];
      });
    } else {
      return Object.keys(obj).map(function (key) {
        var value = obj[key];
        return angular.isObject(value) ? Object.defineProperty(value, '$key', {
          enumerable: false,
          value: key
        }) : {
          $key: key,
          $value: value
        };
      });
    }
  };
});
// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/jq-util.js
var jq_util = __webpack_require__(969);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/util/grid-state-service.js




var grid_state_service_GridStateService = /*#__PURE__*/function () {
  function GridStateService(ClientSettings) {
    classCallCheck_default()(this, GridStateService);

    this._ClientSettings = ClientSettings;
  }

  createClass_default()(GridStateService, [{
    key: "saveState",
    value: function saveState(grid, cacheName, qualifier) {
      var rowCache = _.map(this._getGridRows(grid), function (row) {
        return {
          id: row.entity.id,
          state: row.treeNode.state
        };
      });

      var currentCache = this._getCache(cacheName);

      currentCache[qualifier] = rowCache;

      this._setCache(cacheName, currentCache);
    }
  }, {
    key: "loadState",
    value: function loadState(grid, cacheName, qualifier) {
      if (!this._hasCache(cacheName, qualifier)) {
        return;
      }

      var rowCache = this._getCache(cacheName)[qualifier];

      _.forEach(this._getGridRows(grid), function (row) {
        var cachedRow = _.find(rowCache, {
          'id': row.entity.id
        });

        if (!_.isEmpty(cachedRow)) {
          row.treeNode.state = cachedRow.state;
        }
      });

      grid.queueGridRefresh();
    } ////

  }, {
    key: "_setCache",
    value: function _setCache(cacheName, cache) {
      return this._ClientSettings['set' + cacheName](cache);
    }
  }, {
    key: "_getCache",
    value: function _getCache(cacheName) {
      var cache = this._ClientSettings['get' + cacheName]();

      return _.isEmpty(cache) ? {} : cache;
    }
  }, {
    key: "_hasCache",
    value: function _hasCache(cacheName, qualifier) {
      return _.has(this._getCache(cacheName, qualifier), qualifier);
    }
  }, {
    key: "_getGridRows",
    value: function _getGridRows(grid) {
      var _this = this;

      var tree = grid.treeBase.tree;

      if (!_.isArray(tree)) {
        return [];
      }

      var container = [];
      tree.forEach(function (r) {
        container = container.concat(_.flatten(_this._getRowChildrenRecursive(r.row, [])));
      });
      return container;
    }
  }, {
    key: "_getRowChildrenRecursive",
    value: function _getRowChildrenRecursive(row, children) {
      var _this2 = this;

      children.push(row);

      _.forEach(row.treeNode.children, function (child) {
        _this2._getRowChildrenRecursive(child.row, children);
      });

      return children;
    }
  }]);

  return GridStateService;
}();

defineProperty_default()(grid_state_service_GridStateService, "$inject", ['ClientSettings']);

angular.module('xlrelease').service('GridStateService', grid_state_service_GridStateService);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/layout-constants.js
var layout_constants = __webpack_require__(970);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/local-storage-wrapper.js
var local_storage_wrapper = __webpack_require__(971);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/metadata-service.js
var metadata_service = __webpack_require__(972);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/modal.js
var modal = __webpack_require__(973);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/phases-service.js
var phases_service = __webpack_require__(974);

// EXTERNAL MODULE: ./node_modules/immutable/dist/immutable.js
var immutable = __webpack_require__(40);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/util/releases-shift-key-select.js

function selectReleases(releaseId, isShiftKeyDown, selectedIndex, releases, currentlySelectedReleases, savedSelectIndex, _security, _releaseService, _allowedActions) {
  var newAllowedActions = _allowedActions;
  var toggleFn = !currentlySelectedReleases.has(releaseId) ? addCheckedSubset(currentlySelectedReleases) : removeCheckedSubset(currentlySelectedReleases);

  if (currentlySelectedReleases.isEmpty()) {
    var firstRelease = isShiftKeyDown ? releases.get(savedSelectIndex) : releases.get(selectedIndex);
    newAllowedActions = Object(immutable["Map"])({
      start: isStartActionAvailable(_security, _releaseService, firstRelease),
      abort: isAbortActionAvailable(_security, _releaseService, firstRelease),
      group: true
    });
  }

  if (!isShiftKeyDown || selectedIndex === savedSelectIndex) {
    return {
      newSelectedReleases: toggleFn(immutable["Set"].of(releaseId)),
      newAllowedActions: newAllowedActions
    };
  } else {
    var selectedReleases = Object(immutable["Set"])(releases.slice(Math.min(selectedIndex, savedSelectIndex), Math.max(selectedIndex, savedSelectIndex) + 1)).filter(function (release) {
      return bulkSelectReleasesFilter(release, newAllowedActions, _security, _releaseService);
    }).map(function (release) {
      return release.id;
    });
    return {
      newSelectedReleases: toggleFn(selectedReleases),
      newAllowedActions: newAllowedActions
    };
  }
}
function selectAllReleases(releases, security, releaseService, allowedActions) {
  var selectableReleases = releases.skipUntil(function (release) {
    return bulkSelectReleasesFilter(release, allowedActions, security, releaseService);
  });

  if (!selectableReleases.isEmpty()) {
    var firstRelease = selectableReleases.first();
    var newAllowedActions = Object(immutable["Map"])({
      start: isStartActionAvailable(security, releaseService, firstRelease),
      abort: isAbortActionAvailable(security, releaseService, firstRelease),
      group: true
    });
    var selectedReleases = filterSelectableReleases(selectableReleases, allowedActions, security, releaseService);
    return {
      selectedReleases: selectedReleases,
      newAllowedActions: newAllowedActions
    };
  }

  return {
    selectedReleases: Object(immutable["Set"])(),
    newAllowedActions: allowedActions
  };
}
function filterSelectableReleases(releases, allowedActions, security, releaseService) {
  return releases.filter(function (release) {
    return bulkSelectReleasesFilter(release, allowedActions, security, releaseService);
  });
}
var bulkSelectReleasesFilter = function bulkSelectReleasesFilter(release, allowedActions, security, releaseService) {
  if (allowedActions.get('start') && allowedActions.get('abort') && !allowedActions.get('group')) {
    return isStartActionAvailable(security, releaseService, release) && isAbortActionAvailable(security, releaseService, release);
  }

  return allowedActions.get('start') && isStartActionAvailable(security, releaseService, release) || allowedActions.get('abort') && isAbortActionAvailable(security, releaseService, release) || allowedActions.get('group');
};

var isStartActionAvailable = function isStartActionAvailable(security, releaseService, release) {
  return releaseService.isReleasePlanned(release) && security.hasPermission('release#start', release);
};

var isAbortActionAvailable = function isAbortActionAvailable(security, releaseService, release) {
  return security.hasPermission('release#abort', release) && !releaseService.isReleaseCompleted(release);
};

var addCheckedSubset = function addCheckedSubset(current) {
  return function (add) {
    return current.union(add);
  };
};
var removeCheckedSubset = function removeCheckedSubset(current) {
  return function (remove) {
    return current.subtract(remove);
  };
};
// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/string-service.js
var string_service = __webpack_require__(975);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/timeout.js
var timeout = __webpack_require__(976);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/topological-sort.js
var topological_sort = __webpack_require__(977);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/view-storage.js
var view_storage = __webpack_require__(978);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/window.js
var util_window = __webpack_require__(979);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/value-stream-mapping/release-value-stream-controller.js
var release_value_stream_controller = __webpack_require__(980);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/value-stream-mapping/task-counters-tpl.html
/* harmony default export */ var task_counters_tpl = ("<div>\n    <span class=\"flag-count counter-item\"\n          ng-if=\"$ctrl.flagsCount == 1\"\n          tooltip=\"'1 flagged task'\">\n        <i class=\"xl-icon flag-none-icon icon-s\" />\n        1\n    </span>\n    <span class=\"flag-count counter-item\"\n          ng-if=\"$ctrl.flagsCount > 1\"\n          tooltip=\"$ctrl.flagsCount + ' flagged tasks'\">\n        <i class=\"xl-icon flag-none-icon icon-s\" />\n        {{ $ctrl.flagsCount }}\n    </span>\n\n    <span class=\"failure-count counter-item\"\n          ng-if=\"$ctrl.failuresCount == 1\"\n          tooltip=\"'1 task failure'\">\n        <i class=\"xl-icon lightning-icon icon-s\" />\n        1\n    </span>\n    <span class=\"failure-count counter-item\"\n          ng-if=\"$ctrl.failuresCount > 1\"\n          ng-class=\"{'count-warning': $ctrl.failuresCount >= $ctrl.getWarningThreshold(), 'count-error': $ctrl.failuresCount >= $ctrl.getErrorThreshold()}\"\n          tooltip=\"$ctrl.failuresCount + ' task failures'\">\n        <i class=\"xl-icon lightning-icon icon-s\" />\n        {{ $ctrl.failuresCount }}\n    </span>\n\n    <span class=\"delay-count counter-item\"\n          ng-if=\"$ctrl.delaysCount == 1\"\n          tooltip=\"'1 delayed task'\">\n        <i class=\"xl-icon delay-icon icon-s\" />\n        1\n    </span>\n    <span class=\"delay-count counter-item\"\n          ng-if=\"$ctrl.delaysCount > 1\"\n          ng-class=\"{'count-warning': $ctrl.delaysCount >= $ctrl.getWarningThreshold(), 'count-error': $ctrl.delaysCount >= $ctrl.getErrorThreshold()}\"\n          tooltip=\"$ctrl.delaysCount + ' delayed tasks'\">\n        <i class=\"xl-icon delay-icon icon-s\" />\n        {{ $ctrl.delaysCount }}\n    </span>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/js/value-stream-mapping/task-counters-component.js




var task_counters_component_TaskCountersController = /*#__PURE__*/function () {
  function TaskCountersController(ValueStreamMapping) {
    classCallCheck_default()(this, TaskCountersController);

    this._ValueStreamMapping = ValueStreamMapping;
  }

  createClass_default()(TaskCountersController, [{
    key: "getWarningThreshold",
    value: function getWarningThreshold() {
      return this._ValueStreamMapping.getWarningThreshold();
    }
  }, {
    key: "getErrorThreshold",
    value: function getErrorThreshold() {
      return this._ValueStreamMapping.getErrorThreshold();
    }
  }]);

  return TaskCountersController;
}();

task_counters_component_TaskCountersController.$inject = ['ValueStreamMapping'];
angular.module('xlrelease').component('taskCounters', {
  bindings: {
    flagsCount: '<',
    delaysCount: '<',
    failuresCount: '<'
  },
  controller: task_counters_component_TaskCountersController,
  template: task_counters_tpl
});
// EXTERNAL MODULE: ./core/xlr-ui/app/js/value-stream-mapping/value-stream-mapping-service.js
var value_stream_mapping_service = __webpack_require__(981);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/variables/variable-types.js


function variable_types_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function variable_types_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { variable_types_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { variable_types_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var variableTypes = {
  GLOBAL: 'GLOBAL',
  FOLDER: 'FOLDER'
};

var isGlobalOrFolder = function isGlobalOrFolder(type) {
  return variableTypes.FOLDER === type || variableTypes.GLOBAL === type;
};

/* harmony default export */ var variable_types = (variable_types_objectSpread({}, variableTypes, {
  isGlobalOrFolder: isGlobalOrFolder
}));
// CONCATENATED MODULE: ./core/xlr-ui/app/js/variables/delete-variable-directive.js


angular.module('xlrelease').directive('deleteVariable', function () {
  return {
    template: "<span class=\"action delete\" modal=\"'partials/variables/delete-variable-modal.html'\" init=\"initDeleteVariableDialog()\">\n                <i class=\"xl-icon delete-icon\"></i>\n                <span class=\"action-label\">{{ !VARIABLE_TYPES.isGlobalOrFolder(pageType) ? 'Delete / Replace' : 'Delete' }}</span>\n            </span>",
    restrict: 'A',
    scope: {
      model: '=',
      pageType: '=',
      onDelete: '&',
      supportsNew: '&?',
      onNewVariable: '&?',
      allVariables: '='
    },
    controller: 'deleteVariableController'
  };
});
angular.module('xlrelease').controller('deleteVariableController', ['$scope', 'VariablesService', function ($scope, VariablesService) {
  $scope.initDeleteVariableDialog = initDeleteVariableDialog;
  $scope.deleteVariable = deleteVariable;
  $scope.createVariable = createVariable;
  $scope.checksUsage = checksUsage;
  $scope.handlers = {};
  $scope.getKey = VariablesService.getKey;
  $scope.VARIABLE_TYPES = variable_types; //////

  function initDeleteVariableDialog() {
    var variable = $scope.variable = angular.copy($scope.model);

    if ($scope.allVariables && $scope.allVariables.length > 0) {
      $scope.allVariables = _.reject($scope.allVariables, {
        id: $scope.model.id
      });
    }

    if (checksUsage()) {
      VariablesService.isReleaseVariableUsed(variable).then(function (resp) {
        $scope.isUsed = resp.data;

        if ($scope.isUsed) {
          $scope.replacement = [{
            key: variable.key,
            label: 'Replace it with',
            description: 'Replace all occurrences of the variable with a static value or replace them with a different variable. Leave empty to replace occurrences with a blank.',
            type: variable.type,
            requiresValue: false,
            value: variable.value,
            variable: null
          }];
        }
      });
    }
  }

  function deleteVariable(variable, dismiss) {
    if ($scope.replacement) {
      delete $scope.variable.variable;
      var replacement = $scope.replacement[0];

      if (replacement.variable) {
        $scope.variable.variable = replacement.variable;
      } else if (VariablesService.containsOnlyVariable(replacement.value)) {
        $scope.variable.variable = replacement.value;
      } else {
        if (replacement.type === 'xlrelease.DateVariable') {
          $scope.variable.value = moment(replacement.value, global_constants["a" /* dateTimeFormat */].ISODateTime).valueOf();
        } else {
          $scope.variable.value = replacement.value;
        }
      }
    }

    $scope.onDelete({
      variable: $scope.variable,
      callback: dismiss
    });
  }

  function createVariable(name, variableType, createdCallback) {
    $scope.onNewVariable()({
      key: name,
      type: variableType
    }, createdCallback);
  }

  function checksUsage() {
    return !variable_types.isGlobalOrFolder($scope.pageType);
  }
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/variables/display-variables-directive.js
var display_variables_directive = __webpack_require__(982);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/variables/variable-constants.js
var variable_constants = __webpack_require__(57);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/variables/edit-variable-directive.js




angular.module('xlrelease').directive('editVariable', ['$compile', '$parse', 'MetadataService', 'VariablesService', function ($compile, $parse, MetadataService, VariablesService) {
  return {
    restrict: 'A',
    // scope: shared,
    link: function link($scope, element, attrs) {
      var initFunctionExpr = $parse(attrs.initVariable);
      var saveFunction = $parse(attrs.save)($scope);
      var onNewVariableFunction = $parse(attrs.onNewVariable)($scope);
      var allVariablesExpr = $parse(attrs.allVariables);
      $scope.VARIABLE_TYPES = variable_types;
      $scope.isNew = $parse(attrs.isNew)($scope);
      $scope.isReadonly = $parse(attrs.isReadonly)($scope);
      $scope.pageType = $parse(attrs.pageType)($scope);
      $scope.isRenameEnabled = $parse(attrs.isRenameEnabled)($scope);
      $scope.dateFormat = global_constants["a" /* dateTimeFormat */].ISODateTime;
      $scope.folderId = $parse(attrs.pageData)($scope);
      $scope.listBoxValueProviderType = variable_constants["a" /* VariableConstants */].basicValueProvider;
      $scope.predefinedVariableType = variable_constants["a" /* VariableConstants */].type;
      $scope.selectedValueProviderType = $scope.listBoxValueProviderType.listOfStringConfiguration;
      $scope.emptyValue = '-';
      $scope.isPasswordInvalid = false;
      $scope.isExternalPassword = false;

      $scope.initEditVariableDialog = function () {
        $scope.var = initFunctionExpr($scope);
        $scope.variableType = VariablesService.getVariableType($scope.var);

        if (allVariablesExpr) {
          if (variable_types.isGlobalOrFolder($scope.pageType)) {
            $scope.allVariables = allVariablesExpr($scope);
          }

          if ($scope.pageType === 'FOLDER' && $scope.folderId) {
            var folderVariables = _.filter($scope.allVariables, function (v) {
              return v.folderId === $scope.folderId;
            });

            $scope.existingVariableKeys = variableKeys($scope.pageType, folderVariables, $scope.var);
          } else {
            $scope.existingVariableKeys = variableKeys($scope.pageType, $scope.allVariables, $scope.var);
          }
        }

        MetadataService.getDescriptor(variable_constants["a" /* VariableConstants */].basicValueProvider.scriptConfiguration).then(function (ci) {
          $scope.ciTypeDescriptor = ci;

          if (VariablesService.isDropDownListBox($scope.var)) {
            if (!$scope.var.valueProvider) {
              $scope.var.valueProvider = VariablesService.initValueProvider($scope.var.type);
            }

            if ($scope.listBoxValueProviderType.listOfStringConfiguration === $scope.var.valueProvider.type) {
              $scope.selectedValueProviderType = $scope.var.valueProvider.type;
              loadValuesFromListOfStringValueProvider();
            } else {
              $scope.selectedValueProviderType = $scope.listBoxValueProviderType.scriptConfiguration;
            }
          }
        });
      };

      function initValueProviderForCiTypeDescriptor(ciTypeDescriptor) {
        // set something up in case getSubDescriptors(ciTypeDescriptor) is the empty list
        $scope.var.valueProvider = VariablesService.initValueProvider(ciTypeDescriptor.type);
        MetadataService.getSubDescriptors(ciTypeDescriptor).then(function (subDescriptors) {
          $scope.var.valueProvider = VariablesService.initValueProvider(subDescriptors[0].type);
        });
      }

      $scope.changeValueProvider = changeValueProvider;

      function changeValueProvider(selectedValueProviderType) {
        if (selectedValueProviderType === $scope.listBoxValueProviderType.listOfStringConfiguration) {
          $scope.var.valueProvider = VariablesService.initValueProvider(selectedValueProviderType);
          loadValuesFromListOfStringValueProvider();
        } else {
          initValueProviderForCiTypeDescriptor($scope.ciTypeDescriptor);
          resetValues();
        }
      }

      $scope.validateNumberInput = function (keyDownEvent) {
        if (keyDownEvent.target.value === "" && keyDownEvent.keyCode === 189) {// allow - at the start
          // ok
        } else if ([69, 187, 188, 189, 190].includes(keyDownEvent.keyCode)) {
          // disallow e . , -
          event.preventDefault();
        }
      };

      $scope.invalidValueProvider = function () {
        var p = $scope.var.valueProvider;

        if (!p) {
          // not a value provider
          return false;
        }

        if (!p.type) {
          // value provider with no type?
          return true;
        } // invalid: value provider but no script selected


        return p.type === variable_constants["a" /* VariableConstants */].basicValueProvider.scriptConfiguration && !p.script;
      };

      $scope.invalidPassword = function () {
        return $scope.var.type === $scope.predefinedVariableType.passwordString.key ? $scope.isPasswordInvalid : false;
      };

      $scope.onPasswordValidityChange = function (isValid) {
        $scope.$evalAsync(function () {
          return $scope.isPasswordInvalid = !isValid;
        });
      };

      $scope.onPasswordToggle = function (isExternalPassword) {
        $scope.isExternalPassword = isExternalPassword;

        if ($scope.isExternalPassword) {
          $scope.var.requiresValue = false;
          $scope.var.showOnReleaseStart = false;
        }
      };

      $scope.saveVariable = _.debounce(function (updatedVariable, dismiss) {
        if (angular.isUndefined(updatedVariable.value)) {
          switch (updatedVariable.type) {
            case variable_constants["a" /* VariableConstants */].type.boolean.key:
              updatedVariable.value = false;
              break;

            case variable_constants["a" /* VariableConstants */].type.integer.key:
              updatedVariable.value = 0;
              break;

            default:
              _.noop();

          }
        }

        if (saveFunction) {
          saveFunction(updatedVariable, dismiss);
        } else if (dismiss) {
          dismiss();
        }
      }, global_constants["b" /* debounceTime */]);

      $scope.onNewVariablePF = function (name, variableType, createdCallback) {
        var variableToCreate = {
          key: name,
          type: variableType
        };
        onNewVariableFunction(variableToCreate, createdCallback);
      };

      $scope.typeSelected = function (oldId, newId) {
        var variableTypeList = VariablesService.getVariableTypeList();

        var newType = _.find(variableTypeList, {
          id: newId
        });

        if (newId !== oldId) {
          $scope.var.value = undefined;
          $scope.var.type = newType.key;
          $scope.var.multiline = newType.multiline;

          if (newType.passwordString) {
            $scope.var.externalVariableValue = undefined;
          } else {
            delete $scope.var.externalVariableValue;
          }

          if (newType.valueProvider) {
            $scope.var.valueProvider = VariablesService.initValueProvider(newType.valueProvider);
            loadValuesFromListOfStringValueProvider();
          } else {
            delete $scope.var.valueProvider;
          }
        }
      };

      $scope.saveProviderAndPopulateValues = saveListOfStringValueProviderAndPopulateValues;

      $scope.isValueEmpty = function (object) {
        return Object.keys(object).length === 0;
      };

      function loadValuesFromListOfStringValueProvider() {
        var provider = $scope.var.valueProvider;
        $scope.expandedValueProvider = VariablesService.expandProperties(provider, provider.variableMapping, ["values"]);
        saveListOfStringValueProviderAndPopulateValues();
      }

      function resetValues() {
        $scope.possibleValues = [];
      }

      function saveListOfStringValueProviderAndPopulateValues() {
        var possibleValues = [];

        if ($scope.expandedValueProvider.values.variable) {
          var variableWithValues = _.find($scope.allVariables, {
            key: VariablesService.withoutVariableSyntax($scope.expandedValueProvider.values.variable)
          });

          if (variableWithValues) {
            possibleValues = variableWithValues.value;
          } else {
            $scope.expandedValueProvider.values.variable = undefined;
          }
        } else {
          possibleValues = $scope.expandedValueProvider.values.value || [];
        }

        $scope.possibleValues = possibleValues;

        var _VariablesService$col = VariablesService.collapseProperties($scope.expandedValueProvider, ["values"]),
            _VariablesService$col2 = slicedToArray_default()(_VariablesService$col, 2),
            collapsedValueProvider = _VariablesService$col2[0],
            variableMapping = _VariablesService$col2[1];

        collapsedValueProvider.variableMapping = variableMapping;

        if (collapsedValueProvider.values === null) {
          collapsedValueProvider.values = undefined;
        }

        $scope.var.valueProvider = collapsedValueProvider;

        if (possibleValues.indexOf($scope.var.value) === -1) {
          /* eslint-disable-line lodash/prefer-includes */
          $scope.var.value = undefined;
        }
      }

      function variableKeys(pageType, variables, currentVariable) {
        return _.flatMap(variables, function (variable) {
          if (variable.key === currentVariable.key) {
            return [];
          }

          if (pageType === variable_types.GLOBAL && VariablesService.isGlobalVariableName(variable.key)) {
            return [variable.key.replace(/^global\./, '')];
          }

          if (pageType === variable_types.FOLDER && VariablesService.isFolderVariable(variable.key)) {
            return [variable.key.replace(/^folder\./, '')];
          }

          return [VariablesService.withoutVariableSyntax(variable.key), VariablesService.withVariableSyntax(variable.key)];
        });
      }

      var getVariableKeyPrefix = function getVariableKeyPrefix(key) {
        var regexMatch = (key || '').match(/(folder\.|global\.)/);
        return regexMatch !== null ? regexMatch[0] : null;
      };

      var getVariableKeyWithoutPrefix = function getVariableKeyWithoutPrefix(key) {
        return (key || '').replace(/(folder\.|global\.)/, '');
      };

      $scope.getKey = VariablesService.getKey;
      $scope.getValue = VariablesService.getValue;
      $scope.isStringVariable = VariablesService.isStringVariable;
      $scope.isDropDownListBox = VariablesService.isDropDownListBox;
      $scope.getVariableType = VariablesService.getVariableType;
      $scope.variableTypes = VariablesService.getVariableTypeList();
      $scope.allowedKeyPattern = /^(?!((\$\{)?(release|global|folder))\.).*$/i;
      $scope.getVariableKeyPrefix = getVariableKeyPrefix;
      $scope.getVariableKeyWithoutPrefix = getVariableKeyWithoutPrefix;

      $scope.shouldDisplayMultiline = function () {
        return angular.isDefined(VariablesService.getVariableType($scope.var).multiline);
      };

      element.removeAttr('edit-variable');
      element.attr('init', 'initEditVariableDialog()');
      element.attr('modal', "'partials/variables/edit-variable-modal.html'");
      $compile(element)($scope);
    }
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/variables/global-variables-controller.js
var global_variables_controller = __webpack_require__(983);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/variables/variables-editor-directive.js

angular.module('xlrelease').directive('variablesEditor', ['VariablesService', function (VariablesService) {
  var defaultDateTimeFormat = global_constants["a" /* dateTimeFormat */].ISODateTime;
  return {
    templateUrl: 'partials/variables/variables-editor.html',
    restrict: 'A',
    controller: function controller($scope) {
      $scope.dateFormat = angular.isDefined($scope.dateFormat) && !!$scope.dateFormat ? $scope.dateFormat : defaultDateTimeFormat;

      function isEmpty(value) {
        if (_.isBoolean(value)) {
          return false;
        } else if (_.isNumber(value)) {
          var stringed = "" + value;

          if (stringed.length === 0 || stringed.includes(".")) {
            return true;
          }
        } else if (_.isEmpty(value)) {
          return true;
        }

        return false;
      }

      $scope.validateNumberInput = function (keyDownEvent) {
        if (keyDownEvent.target.value === "" && keyDownEvent.keyCode === 189) {// allow - at the start
          // ok
        } else if ([69, 187, 188, 189, 190].includes(keyDownEvent.keyCode)) {
          // disallow e . , -
          event.preventDefault();
        }
      };

      $scope.getVariableControlLabelClass = function (variable) {
        if (!variable.requiresValue) {
          return '';
        }

        return isEmpty(variable.value) && isEmpty(variable.variable) ? 'error' : '';
      };

      $scope.removeVariable = function (variable) {
        var indexOfVarToDelete = $scope.variables.findIndex(function (v) {
          return v.key === variable.key;
        });
        $scope.variables.splice(indexOfVarToDelete, 1);
        $scope.onRemove({
          variable: variable
        });
      };

      $scope.connectToInheritDefaultValue = function (variable) {
        $scope.onConnectToInheritDefaultValue({
          variable: variable
        });
      };

      $scope.getDisplayName = VariablesService.getDisplayName;
      $scope.getKey = VariablesService.getKey;
      $scope.isStringVariable = VariablesService.isStringVariable;
      $scope.isDropDownListBox = VariablesService.isDropDownListBox;

      $scope.showInheritedLink = function (variable) {
        return $scope.showInheritedHint && !$scope.readonly && !variable.inherited;
      };
    },
    scope: {
      form: '=',
      variables: '=',
      readonly: '=',
      dateFormat: '@',
      filter: '=',
      onChange: '&?',
      allVariables: '=',
      replaceVariables: '=',
      allVariablesReplaceable: '=',
      supportsNewVariable: '=',
      onNewVariable: '&?',
      enableRemove: '<',
      onRemove: '&?',
      showInheritedHint: '=',
      onConnectToInheritDefaultValue: '&?',
      resetCounter: '='
    }
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/variables/variables-interpolator.js
var variables_interpolator = __webpack_require__(984);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/variables/variables-list-directive.js

angular.module('xlrelease').directive('variablesList', function () {
  return {
    templateUrl: "partials/variables/variables-list.html",
    restrict: 'A',
    scope: {
      variables: '=',
      allVariables: '=',
      filter: '=',
      isReadonly: '=',
      pageType: '=',
      onChange: '&',
      onDelete: '&',
      onReorder: '&',
      onNewVariable: '&',
      isRenameEnabled: '=',
      showFolderPath: '<',
      folderId: '<'
    },
    controller: 'variablesListController'
  };
});
angular.module('xlrelease').controller('variablesListController', ['$scope', '$filter', 'VariablesService', function ($scope, $filter, VariablesService) {
  $scope.getKey = VariablesService.getKey;
  $scope.getValue = VariablesService.getValue;
  $scope.getVariableType = VariablesService.getVariableType;
  $scope.sortableOptions = {
    tolerance: 'pointer',
    containment: 'parent',
    //helper function comes from https://bugzilla.mozilla.org/show_bug.cgi?id=787944
    helper: function helper(event, ui) {
      var $clone = angular.element(ui).clone();
      $clone.css('position', 'absolute');
      return $clone.get(0);
    },
    disabled: variable_types.isGlobalOrFolder($scope.pageType) || $scope.isReadonly,
    update: function update() {
      $scope.onReorder($scope.variables);
    }
  };
  $scope.filterOnVisibleFields = _.memoize(function (filter) {
    function containsFilter(string) {
      if (!filter) {
        return true;
      }

      return angular.isString(string) && string.toLowerCase().includes(filter.toLowerCase());
    }

    return function (value) {
      return containsFilter(VariablesService.getKey(value)) || containsFilter(VariablesService.getValue(value)) || containsFilter(VariablesService.getVariableType(value).label) || containsFilter(value.label);
    };
  });

  $scope.filteredVariables = function () {
    return $filter('filter')($scope.variables, $scope.filterOnVisibleFields($scope.filter));
  };

  $scope.editVariable = function (variable) {
    return angular.copy(variable);
  };

  $scope.saveVariable = function (updatedVariable, onSuccess) {
    var oldVariable = _.find($scope.variables, {
      id: updatedVariable.id
    });

    var variable = _.assignIn(oldVariable, updatedVariable);

    if ($scope.onChange && $scope.onChange()) {
      $scope.onChange()(variable, onSuccess);
    } else if (onSuccess) {
      onSuccess();
    }
  };

  $scope.createVariable = function (variable, onSuccess) {
    if ($scope.onNewVariable && $scope.onNewVariable()) {
      $scope.onNewVariable()(variable, onSuccess);
    } else if (onSuccess) {
      onSuccess(variable);
    }
  };
}]);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/typeof.js
var helpers_typeof = __webpack_require__(87);
var typeof_default = /*#__PURE__*/__webpack_require__.n(helpers_typeof);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/variables/variables-service.js




function variables_service_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function variables_service_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { variables_service_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { variables_service_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }


angular.module('xlrelease').factory('VariablesService', ['$filter', '$q', '$sce', 'Backend', 'Ids', function ($filter, $q, $sce, Backend, Ids) {
  function containsOnlyVariable(value) {
    return /^\$\{[^\}]+\}$/.test(value);
  }

  function getAllVariables(releaseId, folderId) {
    folderId = Ids.getInternalFolderId(folderId || releaseId);
    var promises = releaseId ? [getReleaseVariables(releaseId)] : [];
    promises.push(getGlobalVariables());

    if (folderId) {
      promises.push(listFolderVariables(folderId));
    }

    return $q.all(promises).then(function (results) {
      return _(results).map('data').flatten().map(decorateVariable).value();
    });
  }

  function getAllVariableValues(releaseId, folderId) {
    folderId = Ids.getInternalFolderId(folderId || releaseId);
    var promises = folderId ? [getFolderVariableValues(folderId)] : [];
    promises.push(getGlobalVariableValues());
    return releaseId ? getReleaseVariableValues(releaseId).then(function (response) {
      return response.data;
    }) : $q.all(promises).then(function (results) {
      return _(results).map('data').reduce(_.assign);
    });
  }

  function decorateVariable(variable) {
    return _.chain(variable).cloneDeep().assignIn({
      displayName: getLongDisplayName(variable),
      variableName: getKey(variable)
    }).value();
  }

  function listFolderOnlyVariables(folderId) {
    var params = {
      folderOnly: true
    };
    return Backend.get("api/v1/folders/".concat(Ids.toDomainId(Ids.getInternalFolderId(folderId)), "/variables"), {
      params: params
    });
  }

  function listFolderVariables(folderId) {
    return Backend.get("api/v1/folders/".concat(Ids.toDomainId(Ids.getInternalFolderId(folderId)), "/variables"));
  }

  function getFolderVariableValues(folderId) {
    return Backend.get("api/v1/folders/".concat(Ids.toDomainId(Ids.getInternalFolderId(folderId)), "/variableValues"));
  }

  function createFolderVariable(folderId, variable) {
    return Backend.post("api/v1/folders/".concat(Ids.toDomainId(Ids.getInternalFolderId(folderId)), "/variables"), removeEmptyValue(variable));
  }

  function updateFolderVariable(variable) {
    return Backend.put("api/v1/folders/".concat(variable.folderId, "/").concat(variable.id), removeEmptyValue(variable));
  }

  function deleteFolderVariable(variable) {
    return Backend.del("api/v1/folders/".concat(variable.folderId, "/").concat(variable.id));
  }

  function serializeVariable(variable) {
    var cloned = _.cloneDeep(variable);

    delete cloned.displayName;
    delete cloned.variableName;
    return cloned;
  }

  function toSerializableVariables(variables) {
    if (!variables) return variables;
    return variables.map(serializeVariable);
  }

  function getReleaseVariables(releaseId, config) {
    return Backend.get('api/v1/releases/' + Ids.toDomainId(releaseId) + '/variables', config).then(function (variableResp) {
      var promiseList = [];
      variableResp.data.forEach(function (variable) {
        if (isExternalPasswordVariable(variable)) {
          promiseList.push(Backend.get("api/v1/config/".concat(variable.externalVariableValue.server)));
        }
      });

      if (promiseList.length > 0) {
        return $q.all(promiseList).then(function (configRespList) {
          var variableList = variableResp.data.map(function (variable) {
            if (isExternalPasswordVariable(variable)) {
              return variables_service_objectSpread({}, variable, {
                externalVariableValue: {
                  server: variable.externalVariableValue.server,
                  serverType: _.get(configRespList.find(function (item) {
                    return item.data.id === variable.externalVariableValue.server;
                  }), 'data.type'),
                  path: variable.externalVariableValue.path,
                  externalKey: variable.externalVariableValue.externalKey
                }
              });
            } else {
              return variable;
            }
          });
          return {
            data: variableList
          };
        });
      }

      var deferred = $q.defer();
      deferred.resolve(variableResp);
      return deferred.promise;
    });
  }

  function getReleaseVariableValues(releaseId) {
    return Backend.get('api/v1/releases/' + Ids.toDomainId(releaseId) + '/variableValues');
  }

  function createReleaseVariable(releaseId, variable) {
    return Backend.post('api/v1/releases/' + Ids.toDomainId(releaseId) + '/variables', removeEmptyValue(variable));
  }

  function updateReleaseVariables(releaseId, variables) {
    return Backend.put('api/v1/releases/' + Ids.toDomainId(releaseId) + '/variables', variables);
  }

  function updateReleaseVariable(variable) {
    return Backend.put('api/v1/releases/' + variable.id, removeEmptyValue(variable));
  }

  function replaceReleaseVariable(oldVariable, newVariable) {
    return Backend.post('api/v1/releases/' + oldVariable.id + '/replace', removeEmptyValue(newVariable));
  }

  function deleteReleaseVariable(variable) {
    return Backend.del('api/v1/releases/' + variable.id);
  }

  function isReleaseVariableUsed(variable) {
    return Backend.get('api/v1/releases/' + variable.id + '/used');
  }

  function getGlobalVariables() {
    return Backend.get('api/v1/config/Configuration/variables/global');
  }

  function getGlobalVariableValues() {
    return Backend.get('api/v1/config/Configuration/variableValues/global');
  }

  function createGlobalVariable(variable) {
    return Backend.post('api/v1/config/Configuration/variables/global', removeEmptyValue(variable));
  }

  function updateGlobalVariable(variable) {
    return Backend.put('api/v1/config/' + variable.id, removeEmptyValue(variable));
  }

  function deleteGlobalVariable(variable) {
    return Backend.del('api/v1/config/' + variable.id, removeEmptyValue(variable)); // TODO why passing json to delete
  }

  function convertToMap(variables) {
    if (_.isArray(variables)) {
      return _(variables).reject(isPasswordVariable).map(function (variable) {
        return [withVariableSyntax(variable.key), getValue(variable)];
      }).fromPairs().value();
    }

    return variables;
  }

  function isPasswordVariable(variable) {
    return variable && variable.type === variable_constants["a" /* VariableConstants */].type.passwordString.key;
  }

  function isExternalPasswordVariable(variable) {
    return isPasswordVariable(variable) && angular.isDefined(variable.externalVariableValue);
  }

  function isCiPropertyVariableName(key) {
    return !_.isEmpty(key) && /^release\..*$/.test(withoutVariableSyntax(key));
  }

  function isGlobalVariableName(key) {
    return !_.isEmpty(key) && /^global\..*$/.test(withoutVariableSyntax(key));
  }

  function isFolderVariable(key) {
    return !_.isEmpty(key) && /^folder\..*$/.test(withoutVariableSyntax(key));
  }

  function isFolderOrGlobalVariable(key) {
    return isFolderVariable(key) || isGlobalVariableName(key);
  }

  function hasVariableSyntax(key) {
    return /^\$\{.*$/.test(key);
  }

  function withVariableSyntax(key) {
    return '${' + withoutVariableSyntax(key) + '}';
  }

  function withoutVariableSyntax(key) {
    return key.replace(/^\$\{([^}]+)\}$/, "$1");
  }

  function getKey(variable) {
    if (variable.key) {
      return '${' + withoutVariableSyntax(variable.key) + '}';
    }

    return variable.key;
  }

  function getVariableType(variable) {
    var variableTypeList = getVariableTypeList();
    return _.find(variableTypeList, function (type) {
      return type.key === variable.type && (angular.isDefined(variable.valueProvider) && angular.isDefined(type.valueProvider) || angular.isUndefined(variable.valueProvider) && angular.isUndefined(type.valueProvider));
    });
  }

  function getValue(variable) {
    if (variable && variable.value !== null && angular.isDefined(variable.value)) {
      if (variable.type === variable_constants["a" /* VariableConstants */].type.passwordString.key) {
        return '******';
      } else if (variable.type === variable_constants["a" /* VariableConstants */].type.setString.key) {
        return 'set([' + _.map(variable.value, function (v) {
          return '"' + v + '"';
        }).join(', ') + '])';
      } else if (variable.type === variable_constants["a" /* VariableConstants */].type.boolean.key) {
        return variable.value ? 'True' : 'False';
      } else if (variable.type === variable_constants["a" /* VariableConstants */].type.date.key) {
        return $filter('date')(variable.value, 'short');
      } else if (variable.type === variable_constants["a" /* VariableConstants */].type.listString.key || variable.type === variable_constants["a" /* VariableConstants */].type.mapStringString.key || variable.type === variable_constants["a" /* VariableConstants */].type.integer.key) {
        return angular.toJson(variable.value, false);
      }
    }

    return variable.value;
  }

  function getDisplayName(variable) {
    return variable.label || variable.key;
  }

  function getLongDisplayName(variable) {
    return $sce.getTrustedHtml(getKey(variable) + (variable.label ? ' - ' + variable.label : ''));
  }

  function removeEmptyValue(variable) {
    if (['boolean', 'number'].includes(typeof_default()(variable.value))) {
      return variable;
    }

    if (_.isEmpty(variable.value)) {
      return _.assign({}, variable, {
        value: undefined
      });
    }

    return serializeVariable(variable);
  }

  function expandProperties(container, variableMapping, paths) {
    var updatedContainer = angular.copy(container);

    var objectCallback = function objectCallback(item, fqPath, variableMapping) {
      return _.assign(item, _toVariableOrValue(fqPath, variableMapping, item.value));
    };

    var propertyCallback = function propertyCallback(container, fqPath, path, variableMapping) {
      return _.set(container, path, _toVariableOrValue(fqPath, variableMapping, _.get(container, path)));
    };

    _.forEach(paths, function (path) {
      return _walkPropertyPath(updatedContainer, variableMapping, "", path, objectCallback, propertyCallback);
    });

    return updatedContainer;
  }

  function collapseProperties(container, paths) {
    var updatedContainer = angular.copy(container);
    var variableMapping = {};

    var objectCallback = function objectCallback(item, fqPath, variableMapping) {
      if (item.variable) {
        variableMapping[fqPath] = item.variable;
        item.value = null;
      } else {
        delete variableMapping[fqPath];
      }

      delete item.variable;
    };

    var propertyCallback = function propertyCallback(container, fqPath, path, variableMapping) {
      var item = _.get(container, path, {});

      if (item.variable) {
        variableMapping[fqPath] = item.variable;

        _.set(container, path, null);
      } else {
        delete variableMapping[fqPath];

        _.set(container, path, item.value);
      }
    };

    _.forEach(paths, function (path) {
      return _walkPropertyPath(updatedContainer, variableMapping, "", path, objectCallback, propertyCallback);
    });

    return [updatedContainer, variableMapping];
  }

  function _walkPropertyPath(container, variableMapping, fqParentPath, path, objectCallback, propertyCallback) {
    if (_.includes(path, '[]')) {
      var _path$split = path.split('[]', 2),
          _path$split2 = slicedToArray_default()(_path$split, 2),
          currentPath = _path$split2[0],
          _path$split2$ = _path$split2[1],
          childPath = _path$split2$ === void 0 ? null : _path$split2$;

      var target = _.get(container, currentPath, []);

      _.forEach(_.filter(target, _.isObject), function (item, index) {
        var fqPath = _combinePath(fqParentPath, currentPath) + '[' + index + ']';

        if (childPath) {
          _walkPropertyPath(item, variableMapping, fqPath, _.trim(childPath, '.'), objectCallback, propertyCallback);
        } else {
          objectCallback(item, fqPath, variableMapping);
        }
      });
    } else {
      var fqPath = _combinePath(fqParentPath, path);

      propertyCallback(container, fqPath, path, variableMapping);
    }
  }

  function _toVariableOrValue(fqPropertyName, variableMapping, value) {
    var variableName = _.get(variableMapping, fqPropertyName, null);

    return {
      variable: variableName,
      value: value
    };
  }

  function _combinePath(parentPath, childPath) {
    return parentPath ? parentPath + '.' + childPath : childPath;
  }

  function isStringVariable(variable) {
    return _.get(getVariableType(variable), 'id') === variable_constants["a" /* VariableConstants */].type.string.id;
  }

  function isDropDownListBox(variable) {
    return _.get(getVariableType(variable), 'id') === variable_constants["a" /* VariableConstants */].type.dropDownListBox.id;
  }

  function initValueProvider(valueProviderType) {
    var baseValueProvider = {
      id: 'null',
      type: valueProviderType
    };

    if (valueProviderType === variable_constants["a" /* VariableConstants */].basicValueProvider.listOfStringConfiguration) {
      return _.assign({}, baseValueProvider, {
        values: []
      });
    } else {
      return baseValueProvider;
    }
  }

  function getPossibleValues(variable) {
    if (!_.isEmpty(variable.valueProvider)) {
      var valueProvider = variable.valueProvider;

      var getVariableId = function getVariableId(valueProviderId) {
        return valueProviderId.split('/valueProvider')[0];
      };

      var templateVariableId;

      if (angular.isString(valueProvider)) {
        templateVariableId = getVariableId(valueProvider);
      } else {
        templateVariableId = getVariableId(valueProvider.id);
      }

      return Backend.get("api/v1/releases/".concat(templateVariableId, "/possibleValues"), {
        dontRedirectWhenForbidden: true,
        hideAlertOnCode: 403
      });
    }

    return Backend.get("api/v1/releases/".concat(variable.id, "/possibleValues"), {
      dontRedirectWhenForbidden: true,
      hideAlertOnCode: 403
    });
  }

  function getVariableTypeById(variableTypeId) {
    var variableTypeList = getVariableTypeList();
    return _.find(variableTypeList, {
      id: variableTypeId
    });
  }

  function sortVariables(variables, sortedVariablesList) {
    return _(variables).filter(function (variable) {
      return _.some(sortedVariablesList, {
        id: variable.id
      });
    }).sortBy(function (variable) {
      return _.findIndex(sortedVariablesList, {
        id: variable.id
      });
    }).value();
  }

  function getVariableTypeList() {
    var variableTypeObject = variable_constants["a" /* VariableConstants */].type;
    var variableTypeList = Object.keys(variableTypeObject).map(function (key) {
      return variableTypeObject[key];
    });
    return variableTypeList;
  }

  return {
    containsOnlyVariable: containsOnlyVariable,
    getAllVariables: getAllVariables,
    toSerializableVariables: toSerializableVariables,
    getReleaseVariables: getReleaseVariables,
    createReleaseVariable: createReleaseVariable,
    deleteReleaseVariable: deleteReleaseVariable,
    replaceReleaseVariable: replaceReleaseVariable,
    isReleaseVariableUsed: isReleaseVariableUsed,
    updateReleaseVariable: updateReleaseVariable,
    updateReleaseVariables: updateReleaseVariables,
    getGlobalVariables: getGlobalVariables,
    getAllVariableValues: getAllVariableValues,
    createGlobalVariable: createGlobalVariable,
    updateGlobalVariable: updateGlobalVariable,
    deleteGlobalVariable: deleteGlobalVariable,
    convertToMap: convertToMap,
    getKey: getKey,
    getValue: getValue,
    getDisplayName: getDisplayName,
    getLongDisplayName: getLongDisplayName,
    isCiPropertyVariableName: isCiPropertyVariableName,
    isGlobalVariableName: isGlobalVariableName,
    hasVariableSyntax: hasVariableSyntax,
    withVariableSyntax: withVariableSyntax,
    withoutVariableSyntax: withoutVariableSyntax,
    expandProperties: expandProperties,
    collapseProperties: collapseProperties,
    getVariableType: getVariableType,
    isStringVariable: isStringVariable,
    isDropDownListBox: isDropDownListBox,
    isExternalPasswordVariable: isExternalPasswordVariable,
    initValueProvider: initValueProvider,
    getPossibleValues: getPossibleValues,
    getVariableTypeById: getVariableTypeById,
    decorateVariable: decorateVariable,
    sortVariables: sortVariables,
    getVariableTypeList: getVariableTypeList,
    isFolderOrGlobalVariable: isFolderOrGlobalVariable,
    isFolderVariable: isFolderVariable,
    listFolderVariables: listFolderVariables,
    listFolderOnlyVariables: listFolderOnlyVariables,
    createFolderVariable: createFolderVariable,
    updateFolderVariable: updateFolderVariable,
    deleteFolderVariable: deleteFolderVariable
  };
}]);
// EXTERNAL MODULE: ./node_modules/react2angular/index.js
var react2angular = __webpack_require__(62);

// EXTERNAL MODULE: ./node_modules/xl-react-components/dist/index.js
var dist = __webpack_require__(21);

// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/index.js + 25 modules
var components = __webpack_require__(27);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/assertThisInitialized.js
var assertThisInitialized = __webpack_require__(6);
var assertThisInitialized_default = /*#__PURE__*/__webpack_require__.n(assertThisInitialized);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/inherits.js
var inherits = __webpack_require__(12);
var inherits_default = /*#__PURE__*/__webpack_require__.n(inherits);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js
var possibleConstructorReturn = __webpack_require__(11);
var possibleConstructorReturn_default = /*#__PURE__*/__webpack_require__.n(possibleConstructorReturn);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/getPrototypeOf.js
var getPrototypeOf = __webpack_require__(9);
var getPrototypeOf_default = /*#__PURE__*/__webpack_require__.n(getPrototypeOf);

// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(0);
var react_default = /*#__PURE__*/__webpack_require__.n(react);

// EXTERNAL MODULE: ./node_modules/react-rte/dist/react-rte.js
var react_rte = __webpack_require__(359);
var react_rte_default = /*#__PURE__*/__webpack_require__.n(react_rte);

// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__(2);
var prop_types_default = /*#__PURE__*/__webpack_require__.n(prop_types);

// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__(13);
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: ./core/xlr-ui/app/components/react2angular/react-rte/rich-text-editor.less
var rich_text_editor = __webpack_require__(1405);

// CONCATENATED MODULE: ./core/xlr-ui/app/components/react2angular/react-rte/rich-text-editor-service.js
var rteEmptyValue = '<p><br></p>';
var defaultToolbarConfig = {
  display: ['INLINE_STYLE_BUTTONS', 'LINK_BUTTONS'],
  INLINE_STYLE_BUTTONS: [{
    label: 'Bold',
    style: 'BOLD'
  }, {
    label: 'Italic',
    style: 'ITALIC'
  }, {
    label: 'Underline',
    style: 'UNDERLINE'
  }]
};
var richToHTML = function richToHTML(richValue) {
  var formattedRichToHTML = richValue.toString('html');
  return formattedRichToHTML;
};
var isRteEmpty = function isRteEmpty(richValue) {
  return richToHTML(richValue) === rteEmptyValue;
};
// CONCATENATED MODULE: ./core/xlr-ui/app/components/react2angular/react-rte/rich-text-editor-component.js








function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }








var rich_text_editor_component_RichTextEditorComponent = /*#__PURE__*/function (_React$Component) {
  inherits_default()(RichTextEditorComponent, _React$Component);

  var _super = _createSuper(RichTextEditorComponent);

  function RichTextEditorComponent() {
    var _this;

    classCallCheck_default()(this, RichTextEditorComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "state", {
      richValue: react_rte_default.a.createValueFromString(_this.props.content, 'html'),
      stagedContent: _this.props.content
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onChange", function (rteValue) {
      _this.setState({
        rteValue: rteValue
      });

      if (_this.props.onChange) {
        _this.props.onChange(rteValue.toString('html'));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleChange", function (richValue) {
      if (_this.props.disabled) {
        _this.setState({
          richValue: react_rte_default.a.createValueFromString(_this.state.stagedContent, 'html')
        });
      } else {
        var htmlValue = richToHTML(richValue);

        _this.setState({
          richValue: richValue,
          stagedContent: htmlValue
        }, function () {
          _this.props.onContentChange(htmlValue);
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleErase", function () {
      var richValue = react_rte_default.a.createEmptyValue();
      var htmlValue = richToHTML(richValue);

      _this.setState({
        richValue: richValue,
        stagedContent: htmlValue
      }, function () {
        _this.props.onContentChange(htmlValue);
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "closeField", function () {
      return !_this.props.disabled && !isRteEmpty(_this.state.richValue) ? /*#__PURE__*/react_default.a.createElement("div", {
        className: "xl-react-components"
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon close-icon icon-s",
        onClick: function onClick() {
          return _this.handleErase();
        }
      })) : null;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "rteOverlay", function () {
      return _this.props.disabled ? /*#__PURE__*/react_default.a.createElement("div", {
        className: "rte-overlay"
      }) : null;
    });

    return _this;
  }

  createClass_default()(RichTextEditorComponent, [{
    key: "render",
    value: function render() {
      var toolbarConfig = this.props.toolbarConfig || defaultToolbarConfig;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: classnames_default()('rich-text-editor-component', this.props.disabled ? 'disabled' : '')
      }, /*#__PURE__*/react_default.a.createElement(react_rte_default.a, {
        autoFocus: !this.props.disabled,
        onChange: this.handleChange,
        toolbarConfig: toolbarConfig,
        value: this.state.richValue,
        placeholder: "Type here..."
      }), this.closeField(), this.rteOverlay());
    }
  }]);

  return RichTextEditorComponent;
}(react_default.a.Component);

defineProperty_default()(rich_text_editor_component_RichTextEditorComponent, "propTypes", {
  content: prop_types_default.a.string.isRequired,
  disabled: prop_types_default.a.oneOfType([prop_types_default.a.bool, prop_types_default.a.object]),
  onContentChange: prop_types_default.a.func.isRequired,
  toolbarConfig: prop_types_default.a.object
});

/* harmony default export */ var rich_text_editor_component = (rich_text_editor_component_RichTextEditorComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/components/react2angular/react-rte/index.js


angular.module('xlrelease').component('richEditor', Object(react2angular["react2angular"])(rich_text_editor_component));
// CONCATENATED MODULE: ./core/xlr-ui/app/components/react2angular/index.js




angular.module('xlrelease').component('xlReactWidgetTreeSelect', Object(react2angular["react2angular"])(dist["XlReactWidgetTreeSelect"])).component('selectTreeComponent', Object(react2angular["react2angular"])(components["n" /* SelectTreeComponent */])).component('xlReactWidgetAutocomplete', Object(react2angular["react2angular"])(dist["XlReactWidgetAutocomplete"])).component('xlReactWidgetTags', Object(react2angular["react2angular"])(dist["XlReactWidgetTags"]));
// EXTERNAL MODULE: ./core/xlr-ui/app/features/risk-settings/services/index.js
var services = __webpack_require__(101);

// CONCATENATED MODULE: ./core/xlr-ui/app/features/risk-settings/risk-profile-controller.js








var risk_profile_controller_RiskProfileController = function RiskProfileController($stateParams, $scope, orderBy, Page, $state, $timeout, Authenticator, GlobalPermissions, ConfirmLeaveService) {
  var _this = this;

  classCallCheck_default()(this, RiskProfileController);

  this.Authenticator = Authenticator;
  this.GlobalPermissions = GlobalPermissions;
  this.$scope = $scope;
  this._ConfirmLeaveService = ConfirmLeaveService;
  var vm = this;
  vm.toaster = Object(toastrFactory["a" /* default */])();
  vm.riskProfileId = $stateParams.riskProfileId;
  vm.loading = true;
  vm.barLoading = true;
  vm.riskAssessorChanged = false;
  vm.references = [];
  var colorClass = {
    'red': 'red',
    'green': 'green',
    'orange': 'orange'
  };

  function colorBasedOnSliderPosition(value, light) {
    var disabled = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    if (value < vm.thresholdConfig.attentionNeededFrom) return disabled ? colors["a" /* default */].gray : light ? colors["a" /* default */].successBackground : colorClass.green;
    if (value < vm.thresholdConfig.atRiskFrom) return disabled ? colors["a" /* default */].gray : light ? colors["a" /* default */].warningBackground : colorClass.orange;
    return disabled ? colors["a" /* default */].gray : light ? colors["a" /* default */].errorBackground : colorClass.red;
  }

  var init = function init(thresholdConfig, riskProfile, riskProfileAssessors) {
    // Setting breadcrumbs to the new value
    Page.setRiskProfileOpened(riskProfile);
    vm.thresholdConfig = thresholdConfig;
    vm.riskProfile = riskProfile;
    vm.riskProfileAssessors = []; // sort the risk profile assessors based on group and then on order.

    var prevGroup = '';
    riskProfileAssessors = orderBy(riskProfileAssessors, 'group', false);
    riskProfileAssessors = orderBy(riskProfileAssessors, 'order', false);
    var counter = 0;
    riskProfileAssessors.forEach(function (riskProfileAssessor) {
      var existingScore = vm.riskProfile.riskProfileAssessors[riskProfileAssessor.type];

      if (existingScore) {
        riskProfileAssessor.score = existingScore;
        riskProfileAssessor.enabled = true;
      }

      if (prevGroup === riskProfileAssessor.group) {
        riskProfileAssessor.group = '';
        counter++;
      } else {
        // Add empty risk profile assessors to display a line break after each group
        if (prevGroup !== '' && (counter > 1 || riskProfileAssessor.title !== riskProfileAssessor.group)) {
          vm.riskProfileAssessors.push({
            id: ''
          });
        }

        prevGroup = riskProfileAssessor.group;
      }

      vm.riskProfileAssessors.push(riskProfileAssessor);
    }); // To determine whether the risk profile is editable or not.

    vm.editable = !riskProfile.defaultProfile && _this.Authenticator.hasPermission(_this.GlobalPermissions.EDIT_RISK_PROFILE);

    vm.riskProfileChangeListener = function () {
      _this._ConfirmLeaveService.requireConfirmation();

      vm.riskAssessorChanged = true;
    };

    vm.riskGlobalSlider = {
      minValue: thresholdConfig.attentionNeededFrom,
      maxValue: thresholdConfig.atRiskFrom - 1,
      options: {
        floor: 0,
        ceil: 100,
        step: 1,
        disabled: true,
        getSelectionBarColor: function getSelectionBarColor() {
          return colors["a" /* default */].warningBackground;
        },
        showTicks: true,
        translate: function translate(value, _, label) {
          return label === 'high' ? value + 1 : value;
        },
        getTickColor: function getTickColor(value) {
          return colorBasedOnSliderPosition(value, true);
        }
      }
    };
    vm.riskProfileSlider = {
      options: {
        floor: 0,
        ceil: 100,
        step: 1,
        getSelectionBarColor: function getSelectionBarColor() {
          return colors["a" /* default */].orange;
        },
        showTicks: true,
        getTickColor: function getTickColor(value) {
          return colorBasedOnSliderPosition(value, true);
        },
        getPointerColor: function getPointerColor(value) {
          return colorBasedOnSliderPosition(value, false);
        },
        onChange: vm.riskProfileChangeListener
      }
    };
    vm.riskProfileSliderDisabled = angular.copy(vm.riskProfileSlider);
    vm.riskProfileSliderDisabled.options.disabled = true;

    vm.riskProfileSliderDisabled.options.getTickColor = function (value) {
      return colorBasedOnSliderPosition(value, true, vm.editable);
    };

    vm.riskProfileSliderDisabled.options.getPointerColor = _.constant('grey');
    finishLoading();
  };

  function finishLoading() {
    $timeout(function () {
      // Simulates loading
      vm.loading = false;
    }, 1500);
  }

  vm.rpEnabled = function (riskAssessor) {
    riskAssessor.enabled = !riskAssessor.enabled;

    _this.riskProfileChangeListener();
  };

  Object(services["g" /* fetchRiskConfig */])().then(function (configResponse) {
    Object(services["h" /* fetchRiskProfile */])(vm.riskProfileId).then(function (riskProfileResponse) {
      Object(services["f" /* fetchRiskAssessors */])().then(function (riskProfileAssessor) {
        init(configResponse.data, riskProfileResponse.data, riskProfileAssessor.data);

        if (riskProfileResponse.data.id) {
          Object(services["e" /* fetchReferences */])(vm.riskProfileId).then(function (references) {
            vm.references = references.data;

            if (vm.references.length) {
              vm.toaster.clearLastToast();
              vm.toaster.info("Modifying risk profile will recalculate the associated releases' risk scores and may display incorrect risk scores in release overview until calculated.", 0);
            }
          });
        }
      });
    });
  });
  this.$scope.$on('$destroy', function () {
    if (vm.references.length > 0) {
      vm.toaster.clearLastToast();
    }
  });

  vm.save = function () {
    var riskProfile = {
      id: vm.riskProfile.id,
      title: vm.riskProfile.title,
      type: vm.riskProfile.type,
      riskProfileAssessors: {}
    };
    vm.riskProfileAssessors.filter(function (riskProfileAssessor) {
      return riskProfileAssessor.enabled;
    }).map(function (riskProfileAssessor) {
      return riskProfile.riskProfileAssessors[riskProfileAssessor.type] = riskProfileAssessor.score;
    });

    if (riskProfile.id) {
      Object(services["j" /* updateRiskProfile */])(riskProfile).then(function (resp) {
        vm.toaster.success("Risk Profile Updated Successfully");

        vm._ConfirmLeaveService.disableConfirmation();

        $state.go('riskSettings');
      });
    } else {
      Object(services["c" /* createRiskProfile */])(riskProfile).then(function (resp) {
        vm.toaster.success("Risk Profile Created Successfully");

        vm._ConfirmLeaveService.disableConfirmation();

        $state.go('riskSettings');
      });
    }
  };
};

defineProperty_default()(risk_profile_controller_RiskProfileController, "$inject", ['$stateParams', '$scope', 'orderByFilter', 'Page', '$state', '$timeout', 'Authenticator', 'GlobalPermissions', 'ConfirmLeaveService']);


// CONCATENATED MODULE: ./core/xlr-ui/app/features/risk-settings/actions/risk-settings-actions.js
var risk_settings_actions_actionTypes = {
  COPY_RISK_PROFILE: 'COPY_RISK_PROFILE',
  COPY_RISK_PROFILE_SUCCEEDED: 'COPY_RISK_PROFILE_SUCCEEDED',
  COPY_RISK_PROFILE_FAILED: 'COPY_RISK_PROFILE_FAILED',
  DELETE_RISK_PROFILE: 'DELETE_RISK_PROFILE',
  DELETE_RISK_PROFILE_FAILED: 'DELETE_RISK_PROFILE_FAILED',
  DELETE_RISK_PROFILE_SUCCEEDED: 'DELETE_RISK_PROFILE_SUCCEEDED',
  LOAD_RISK_PROFILES: 'LOAD_RISK_PROFILES',
  LOAD_RISK_PROFILES_SUCCEEDED: 'LOAD_RISK_PROFILES_SUCCEEDED',
  LOAD_RISK_PROFILES_FAILED: 'LOAD_RISK_PROFILES_FAILED',
  LOAD_REFERENCES: 'LOAD_REFERENCES',
  LOAD_REFERENCES_SUCCEEDED: 'LOAD_REFERENCES_SUCCEEDED'
};
var copyRiskProfile = function copyRiskProfile(riskProfileId) {
  return {
    type: risk_settings_actions_actionTypes.COPY_RISK_PROFILE,
    payload: riskProfileId
  };
};

var risk_settings_actions_showModalAction = function showModalAction(type) {
  return function (uibModalService) {
    return {
      type: type,
      uibModalService: uibModalService
    };
  };
};

var deleteProfile = risk_settings_actions_showModalAction(risk_settings_actions_actionTypes.DELETE_RISK_PROFILE);
var deleteRiskProfile = function deleteRiskProfile(riskProfileId) {
  return {
    type: risk_settings_actions_actionTypes.DELETE_RISK_PROFILE,
    payload: riskProfileId
  };
};
var risk_settings_actions_loadRiskProfiles = function loadRiskProfiles() {
  return {
    type: risk_settings_actions_actionTypes.LOAD_RISK_PROFILES
  };
};
var risk_settings_actions_loadReferences = function loadReferences(riskProfileId) {
  return {
    type: risk_settings_actions_actionTypes.LOAD_REFERENCES,
    payload: riskProfileId
  };
};
var loadReferencesSucceeded = function loadReferencesSucceeded(references) {
  return {
    type: risk_settings_actions_actionTypes.LOAD_REFERENCES_SUCCEEDED,
    payload: references
  };
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/risk-settings/risk-settings-controller.js






function risk_settings_controller_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function risk_settings_controller_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { risk_settings_controller_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { risk_settings_controller_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }




var risk_settings_controller_GlobalRiskThresholdsWrapper = /*#__PURE__*/function () {
  function GlobalRiskThresholdsWrapper(CIManager, _saveCallback, ConfirmLeaveService) {
    var _this = this;

    classCallCheck_default()(this, GlobalRiskThresholdsWrapper);

    defineProperty_default()(this, "_manager", null);

    defineProperty_default()(this, "_loadedThresholds", null);

    this._saveCallback = _saveCallback;
    this._ConfirmLeaveService = ConfirmLeaveService;
    this._manager = new CIManager({
      type: 'RiskGlobalThresholds',
      customURL: 'api/v1/risks/config',
      saveCallback: function saveCallback() {
        _this._loadedThresholds = risk_settings_controller_objectSpread({}, _this._manager.ci);

        if (_saveCallback) {
          _saveCallback();
        }
      },
      loadCallback: function loadCallback(ci) {
        _.defaults(ci, _this.GLOBAL_THRESHOLD_DEFAULTS);

        _this._loadedThresholds = risk_settings_controller_objectSpread({}, ci);
      }
    });
  }

  createClass_default()(GlobalRiskThresholdsWrapper, [{
    key: "save",
    value: function save() {
      this._manager.save();
    }
  }, {
    key: "reset",
    value: function reset() {
      this._manager.ci = risk_settings_controller_objectSpread({}, this._loadedThresholds);
    }
  }, {
    key: "isInitialized",
    get: function get() {
      var res = this._manager && this._manager.ci && angular.isDefined(this._manager.ci.atRiskFrom) && angular.isDefined(this._manager.ci.attentionNeededFrom);
      return res;
    }
  }, {
    key: "atRiskFrom",
    get: function get() {
      return this._manager.ci.atRiskFrom - 1;
    },
    set: function set(value) {
      return this._manager.ci.atRiskFrom = value + 1;
    }
  }, {
    key: "attentionNeededFrom",
    get: function get() {
      return this._manager.ci.attentionNeededFrom;
    },
    set: function set(value) {
      return this._manager.ci.attentionNeededFrom = value;
    }
  }, {
    key: "lastSavedDate",
    get: function get() {
      return this._manager.lastSavedDate;
    },
    set: function set(value) {
      return this._manager.lastSavedDate = value;
    }
  }]);

  return GlobalRiskThresholdsWrapper;
}();

defineProperty_default()(risk_settings_controller_GlobalRiskThresholdsWrapper, "GLOBAL_THRESHOLD_DEFAULTS", {
  attentionNeededFrom: 10,
  atRiskFrom: 50
});

var risk_settings_controller_RiskSettingsController = /*#__PURE__*/function () {
  function RiskSettingsController($state, $stateParams, $ngRedux, CIManager, ConfirmLeaveService, $uibModal, $filter, Authenticator, GlobalPermissions) {
    var _this2 = this;

    classCallCheck_default()(this, RiskSettingsController);

    defineProperty_default()(this, "editRisk", function () {
      _this2.editable = true;
      _this2.globalRiskThresholds.lastSavedDate = null;
      _this2.sliderOptions.disabled = false;
    });

    defineProperty_default()(this, "cancelRiskEdit", function () {
      _this2.editable = false;
      _this2.changeListener = false;
      _this2.sliderOptions.disabled = true;

      _this2.ConfirmLeaveService.disableConfirmation();

      _this2.globalRiskThresholds.reset();
    });

    defineProperty_default()(this, "saveRisk", function () {
      _this2.editable = false;
      _this2.changeListener = false;
      _this2.sliderOptions.disabled = true;

      _this2.ConfirmLeaveService.disableConfirmation();

      _this2.globalRiskThresholds.save();
    });

    defineProperty_default()(this, "deleteRiskProfile", function (_riskProfile) {
      _this2.$uibModal.open({
        animation: false,
        component: 'deleteRiskSettingsModal',
        resolve: {
          riskProfile: function riskProfile() {
            return _riskProfile;
          }
        }
      }).result.then(function (confirm) {
        if (confirm) {
          _this2.delete(_riskProfile.id);
        }
      });
    });

    defineProperty_default()(this, "editRiskProfile", function (rp) {
      if (_this2.changeListener) {
        _this2.ConfirmLeaveService.openConfirmationDialog().then(function (o) {
          return _this2.$state.go("riskProfile", {
            riskProfileId: rp.id
          });
        });
      } else {
        _this2.$state.go("riskProfile", {
          riskProfileId: rp.id
        });
      }
    });

    defineProperty_default()(this, "filteredRiskProfiles", function () {
      return _this2.$filter('orderBy')(_this2.$filter('filter')(_this2.riskProfiles, _this2.filterByTitle(_this2.searchQuery)), _this2.sortAsc);
    });

    defineProperty_default()(this, "filterByTitle", function (filter) {
      return function (ci) {
        if (!filter) return true;
        return angular.isString(ci.title) && ci.title.toLowerCase().includes(filter.toLowerCase());
      };
    });

    defineProperty_default()(this, "sortAsc", function (ci) {
      return ci.defaultProfile ? -1 : ci.title.toLowerCase();
    });

    defineProperty_default()(this, "canEdit", function () {
      return _this2.editable && !_this2.globalRiskThresholds.lastSavedDate;
    });

    defineProperty_default()(this, "hasEditRiskProfilePermission", function () {
      return _this2.Authenticator.hasPermission(_this2.GlobalPermissions.EDIT_RISK_PROFILE);
    });

    defineProperty_default()(this, "hasAdminPermission", function () {
      return _this2.Authenticator.isAdminOr();
    });

    defineProperty_default()(this, "notDefaultAndHasEditRiskProfilePermission", function (riskProfile) {
      return !riskProfile.defaultProfile && _this2.hasEditRiskProfilePermission();
    });

    defineProperty_default()(this, "canEditAsAdmin", function () {
      return _this2.canEdit() && _this2.hasAdminPermission();
    });

    this.Authenticator = Authenticator;
    this.GlobalPermissions = GlobalPermissions;
    this.$filter = $filter;
    this.$uibModal = $uibModal;
    this.$stateParams = $stateParams;
    this.$state = $state;
    this.ConfirmLeaveService = ConfirmLeaveService;
    this.unsubscribe = $ngRedux.connect(this._mapStateToThis, this._mapDispatchToThis)(this);
    this.changeListener = false;
    this.globalRiskThresholds = new risk_settings_controller_GlobalRiskThresholdsWrapper(CIManager, function () {
      return _this2.ConfirmLeaveService.disableConfirmation();
    });
    this.sliderOptions = {
      floor: 0,
      ceil: 99,
      step: 1,
      noSwitching: true,
      minRange: 9,
      draggableRange: true,
      getSelectionBarColor: function getSelectionBarColor() {
        return colors["a" /* default */].warningBackground;
      },
      disabled: true,
      showTicks: true,
      translate: function translate(value, _, label) {
        return label === 'high' || label === 'ceil' ? value + 1 : value;
      },
      getTickColor: function getTickColor(value) {
        if (value < _this2.globalRiskThresholds.attentionNeededFrom) return colors["a" /* default */].successBackground;
        if (value < _this2.globalRiskThresholds.atRiskFrom) return colors["a" /* default */].warningBackground;
        return colors["a" /* default */].errorBackground;
      },
      onChange: function onChange() {
        _this2.changeListener = true;

        _this2.ConfirmLeaveService.requireConfirmation();
      }
    };
  }

  createClass_default()(RiskSettingsController, [{
    key: "$onInit",
    value: function $onInit() {
      this.editable = !!this.$stateParams.edit;
      this.sliderOptions.disabled = !this.editable;
      this.loadRiskProfiles();
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this.unsubscribe();
    }
  }, {
    key: "_mapStateToThis",
    value: function _mapStateToThis(_ref) {
      var riskSettings = _ref.riskSettings;
      var loading = riskSettings.loading,
          riskProfiles = riskSettings.profiles;
      return {
        loading: loading,
        riskProfiles: riskProfiles
      };
    }
  }, {
    key: "_mapDispatchToThis",
    value: function _mapDispatchToThis(dispatch) {
      return {
        copy: function copy(riskProfileId) {
          return dispatch(copyRiskProfile(riskProfileId));
        },
        delete: function _delete(riskProfileId) {
          return dispatch(deleteRiskProfile(riskProfileId));
        },
        loadRiskProfiles: function loadRiskProfiles() {
          return dispatch(risk_settings_actions_loadRiskProfiles());
        }
      };
    }
  }]);

  return RiskSettingsController;
}();

defineProperty_default()(risk_settings_controller_RiskSettingsController, "$inject", ['$state', '$stateParams', '$ngRedux', 'CIManager', 'ConfirmLeaveService', '$uibModal', '$filter', 'Authenticator', 'GlobalPermissions']);


// CONCATENATED MODULE: ./core/xlr-ui/app/features/risk-settings/components/delete-risk-settings-modal-component.js




var deleteRiskSettingsModalTemplate = "\n    <div class=\"modal-header\">\n        <h4 class=\"modal-title pull-left\" id=\"modal-title\" data-ng-if=\"$ctrl.references.length\">Risk profile cannot be deleted</h4>\n        <h4 class=\"modal-title pull-left\" id=\"modal-title\" data-ng-if=\"!$ctrl.references.length\">Delete risk profile</h4>\n        <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.dismiss()\"><i class=\"xl-icon close-icon\"/></button>\n        <div class=\"clearfix\"></div>\n    </div>\n    <div class=\"modal-body actions-modal drp-modal-body\">\n        <p data-ng-if=\"!$ctrl.references.length\">You are about to delete the risk profile \"{{$ctrl.resolve.riskProfile.title}}\".</p>\n        <p data-ng-if=\"$ctrl.references.length\">\"{{$ctrl.resolve.riskProfile.title}}\" risk profile cannot be deleted because it is in use. Please remove risk profile from items below.</p>\n        <p data-ng-if=\"!$ctrl.references.length\">Are you sure you want to delete this risk profile?</p>\n        <div data-ng-if=\"$ctrl.references.length\" data-bs-collapse data-ng-model=\"$ctrl.referencesCollapsed\" class=\"drp-references\">\n            <h6 class=\"title collapsible\" data-bs-collapse-toggle>\n                <i class=\"collapse-button xl-icon\" data-ng-class=\"{'arrow-down-icon': !$ctrl.referencesCollapsed, 'arrow-right-icon': $ctrl.referencesCollapsed}\"></i>\n                {{!$ctrl.referencesCollapsed ? 'Hide' : 'Show'}} affected items ({{$ctrl.references.length}})\n            </h6>\n            <ul class=\"drp-references-list\" data-bs-collapse-target>\n                <li data-ng-repeat=\"release in $ctrl.references\" class=\"drp-references-list__row\">\n                    <a class=\"drp-references-list__link\" href data-ng-click=\"$ctrl.goToRelease(release)\">{{release.title}}</a>\n                </li>\n            </ul>\n        </div>\n    </div>\n    <div class=\"modal-footer\">\n        <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\" data-ng-if=\"!$ctrl.references.length\">Cancel</button>\n        <button class=\"button primary save\" type=\"button\" ng-click=\"$ctrl.dismiss()\" data-ng-if=\"$ctrl.references.length\">Close</button>\n        <button data-ng-if=\"!$ctrl.references.length\" class=\"button save primary\" type=\"submit\" ng-click=\"$ctrl.close({$value: true})\">Delete risk profile</button>\n    </div>\n";

var delete_risk_settings_modal_component_DeleteRiskProfileController = /*#__PURE__*/function () {
  function DeleteRiskProfileController($ngRedux, $state, Ids) {
    classCallCheck_default()(this, DeleteRiskProfileController);

    this._Ids = Ids;
    this._$state = $state;
    this.unsubscribe = $ngRedux.connect(this.mapStateToProps, this.mapDispatchToProps)(this);
  }

  createClass_default()(DeleteRiskProfileController, [{
    key: "goToRelease",
    value: function goToRelease(release) {
      this._$state.go('release', {
        releaseId: this._Ids.toInternalId(release.id)
      });

      this.dismiss();
    }
  }, {
    key: "mapStateToProps",
    value: function mapStateToProps(state) {
      return {
        references: state.riskSettings.references
      };
    }
  }, {
    key: "mapDispatchToProps",
    value: function mapDispatchToProps(dispatch) {
      return {
        loadReferences: function loadReferences(riskProfileId) {
          return dispatch(risk_settings_actions_loadReferences(riskProfileId));
        }
      };
    }
  }, {
    key: "$onInit",
    value: function $onInit() {
      this.referencesCollapsed = false;
      this.loadReferences(this.resolve.riskProfile.id);
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this.unsubscribe();
    }
  }]);

  return DeleteRiskProfileController;
}();

defineProperty_default()(delete_risk_settings_modal_component_DeleteRiskProfileController, "$inject", ['$ngRedux', '$state', 'Ids']);

var DeleteRiskSettingsModal = {
  bindings: {
    close: '&',
    dismiss: '&',
    resolve: '<'
  },
  controller: delete_risk_settings_modal_component_DeleteRiskProfileController,
  template: deleteRiskSettingsModalTemplate
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/risk-settings/index.js




/* harmony default export */ var risk_settings = (angular.module('xlrelease.riskSettings', []).controller('riskProfileController', risk_profile_controller_RiskProfileController).controller('riskSettingsController', risk_settings_controller_RiskSettingsController).component('deleteRiskSettingsModal', DeleteRiskSettingsModal).service('RiskSettingsService', services["a" /* RiskSettingsService */]).name);
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/add-team-modal-component/add-team-modal-component.js
var add_team_modal_component = __webpack_require__(1406);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/alert-component/alert-component.js




var alert_component_AlertController = /*#__PURE__*/function () {
  function AlertController() {
    classCallCheck_default()(this, AlertController);

    defineProperty_default()(this, "alertIconsClasses", {
      'info': 'info-icon',
      'warning': 'warning-icon'
    });

    defineProperty_default()(this, "alertType", void 0);
  }

  createClass_default()(AlertController, [{
    key: "$onInit",
    value: function $onInit() {}
  }]);

  return AlertController;
}();

var AlertComponent = {
  bindings: {
    alertType: '@' // warning, info

  },
  controller: alert_component_AlertController,
  templateUrl: 'static/9.7.16/xlr-components/alert-component/alert-component-partial.html',
  transclude: true
};
angular.module('xlrelease').component('xlrAlert', AlertComponent);
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/breadcrumbs-component/xlr-breadcrumbs-component.js
var xlr_breadcrumbs_component = __webpack_require__(1407);

// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/system-message-component/system-message-component.less
var system_message_component = __webpack_require__(1408);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/system-message-component/system-message-component.js





var system_message_component_template = "\n<div>\n    <div data-ng-if=\"$ctrl.displayMessage()\" class=\"system-message\">\n        <div class=\"xlr-alert-info\">\n            <div class=\"icon\">\n                <i class=\"xl-icon info-icon\" />\n            </div>\n            <div class=\"message\">\n                <div ng-bind-html=\"$ctrl.getSystemMessage()\"></div>\n            </div>\n            <span data-ng-class=\"{'chevron-down-icon': !$ctrl.isExpanded, 'chevron-up-icon': $ctrl.isExpanded}\" \n                data-ng-if=\"$ctrl.isMessageCut()\"\n                class=\"expand-system-message xl-icon\" \n                data-ng-click=\"$ctrl.toggleMessage()\" />\n        </div>\n    </div>    \n</div>\n";

var system_message_component_SystemMessageController = /*#__PURE__*/function () {
  function SystemMessageController(SystemMessageService, $scope, $element) {
    classCallCheck_default()(this, SystemMessageController);

    defineProperty_default()(this, "COLLAPSED_TEXT_LIMIT", 450);

    this.SystemMessageService = SystemMessageService;
    this.$scope = $scope;
    this.$element = $element;
    this.isExpanded = false;
  }

  createClass_default()(SystemMessageController, [{
    key: "$onInit",
    value: function $onInit() {
      var el = this.$element.find('.xlr-alert-info').first();
    }
  }, {
    key: "isMessageCut",
    value: function isMessageCut() {
      return this.systemMessage && this.systemMessage.message && this.COLLAPSED_TEXT_LIMIT < this.systemMessage.message.length;
    }
  }, {
    key: "getSystemMessage",
    value: function getSystemMessage() {
      if (this.isMessageCut() && !this.isExpanded) {
        return this.systemMessage.message.substring(0, this.COLLAPSED_TEXT_LIMIT) + '...';
      }

      return this.systemMessage.message;
    }
  }, {
    key: "toggleMessage",
    value: function toggleMessage() {
      this.isExpanded = !this.isExpanded;
    }
  }, {
    key: "displayMessage",
    value: function displayMessage() {
      return this.SystemMessageService.isMessageEnabled(this.systemMessage);
    }
  }]);

  return SystemMessageController;
}();

defineProperty_default()(system_message_component_SystemMessageController, "$inject", ['SystemMessageService', '$scope', '$element']);

var SystemMessageComponent = {
  bindings: {
    systemMessage: '<'
  },
  controller: system_message_component_SystemMessageController,
  template: system_message_component_template
};
angular_default.a.module('xlrelease').component('xlrSystemMessage', SystemMessageComponent);
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/system-information-modal-component/system-information-modal-component.less
var system_information_modal_component = __webpack_require__(1409);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/system-information-modal-component/system-information-modal-component.js



var system_information_modal_component_template = "\n<div class=\"modal-header\">\n    <button type=\"button\" class=\"close\" ng-click=\"$ctrl.dismiss()\"><i class=\"xl-icon close-icon\"></i></button>\n    <h5 class=\"modal-title\">System information</h5>\n</div>\n<div class=\"modal-body\">\n    <div class=\"system-information\">\n      <div ng-if=\"$ctrl.loading\" class=\"spinner\" >\n          <img src=\"static/9.7.16/styles/img/big-ajax-loader.gif\" alt=\"Loading...\" />\n          <p>Generating report, please wait...</p>\n      </div>\n      <div ng-if=\"!$ctrl.loading\" ng-bind-html=\"$ctrl.trustAsHtml($ctrl.content)\" class=\"data\">\n      </div>\n    </div>\n</div>\n<div class=\"modal-footer\">\n    <button class=\"button primary\" ng-click=\"$ctrl.close()\">Close</button>\n</div>\n";

var system_information_modal_component_SystemInformationModalController = /*#__PURE__*/function () {
  function SystemInformationModalController(Backend, $sce) {
    classCallCheck_default()(this, SystemInformationModalController);

    this.Backend = Backend;
    this.$sce = $sce;
  }

  createClass_default()(SystemInformationModalController, [{
    key: "trustAsHtml",
    value: function trustAsHtml(html) {
      return this.$sce.trustAsHtml(html);
    }
  }, {
    key: "$onInit",
    value: function $onInit() {
      var _this = this;

      this.loading = true;
      this.Backend.get('support/system-information', {
        headers: {
          'Accept': 'text/html'
        }
      }).then(function (resp) {
        _this.content = resp.data;
      }).finally(function () {
        return _this.loading = false;
      });
    }
  }]);

  return SystemInformationModalController;
}();

system_information_modal_component_SystemInformationModalController.$inject = ['Backend', '$sce'];
var SystemInformationModalComponent = {
  template: system_information_modal_component_template,
  bindings: {
    close: '&',
    dismiss: '&'
  },
  controller: system_information_modal_component_SystemInformationModalController
};
angular.module('xlrelease').component('systemInformationModal', SystemInformationModalComponent);
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/checkbox-status-component/checkbox-statuses-const.js
var checkbox_statuses_const = __webpack_require__(88);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/checkbox-status-component/checkbox-status.js


function checkboxStatus() {
  return {
    compile: function compile(element, attribute) {
      if (!attribute.type || attribute.type.toLowerCase() !== 'checkbox') {
        return angular.noop;
      }

      return function ($scope, element, attribute) {
        $scope.$watch(attribute.checkboxStatus, function (newVal) {
          element.prop('checked', false);
          element.prop('indeterminate', false);

          if (newVal === checkbox_statuses_const["a" /* default */].INDETERMINATE) {
            element.prop('indeterminate', true);
          } else if (newVal === checkbox_statuses_const["a" /* default */].CHECKED) {
            element.prop('checked', true);
          }
        });
      };
    }
  };
}

angular.module('xlrelease').directive('checkboxStatus', checkboxStatus);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/ci-control-component/ci-control-component.js




/*
 This component renders CI and shows properties of kind=='CI' as nested components (other components force us to select existing references)
*/
var ci_control_component_DipCIControlController = /*#__PURE__*/function () {
  function DipCIControlController(MetadataService, $q, $scope) {
    var _this = this;

    classCallCheck_default()(this, DipCIControlController);

    defineProperty_default()(this, "doesNotHaveRenderer", function (property) {
      var propertyTypes = _this.getPropertyTypes(property);

      return angular.isUndefined(_this.renderers) || _.isEmpty(_.pick(_this.renderers, propertyTypes));
    });

    defineProperty_default()(this, "getRenderer", function (property) {
      var propertyTypes = _this.getPropertyTypes(property);

      return _.values(_.pick(_this.renderers, propertyTypes))[0];
    });

    defineProperty_default()(this, "getPropertyTypes", function (property) {
      var propertyType = _this.MetadataService.getCiType(property);

      var propertyDescriptor = _this.descriptors.find(function (descriptor) {
        return descriptor.type === propertyType;
      });

      return angular.isDefined(propertyDescriptor) ? _.compact(_.concat([], propertyDescriptor.superTypes, propertyDescriptor.type)) : [];
    });

    defineProperty_default()(this, "onRadioButtonChange", function () {
      _this.onSelect(_this.selectedTypeDescriptor);

      if (_this.onChange) {
        _this.onChange();
      }
    });

    defineProperty_default()(this, "onSelect", function (descriptor) {
      _this.unsetForm();

      descriptor.properties.filter(function (property) {
        return property.kind === 'CI' && !property.asContainment;
      }).forEach(function (property) {
        if (angular.isDefined(_this.ignoredCategories) && _.includes(_this.ignoredCategories, property.category)) {
          _this.configurationItem[property.name] = null;
        } else {
          _this.configurationItem[property.name] = {};
        }
      });
      _this._properties = descriptor.properties;

      if (!_.has(_this.configurationItem, 'id')) {
        _this.configurationItem.id = null;
      }

      _this.configurationItem.type = descriptor.type;
    });

    defineProperty_default()(this, "unsetForm", function () {
      _.forOwn(_this.configurationItem, function (value, key) {
        if (key !== 'id') {
          delete _this.configurationItem[key];
        }
      });

      _this._properties = [];
    });

    defineProperty_default()(this, "initializeForm", function (configurationItemType) {
      if (_this.autocompleteCandidates.length > 0) {
        _this.MetadataService.getDescriptors().then(function (descriptors) {
          _this.selectedTypeDescriptor = descriptors.find(function (descriptor) {
            return descriptor.type === configurationItemType;
          });
          _this._properties = _this.selectedTypeDescriptor.properties;
        });
      }
    });

    defineProperty_default()(this, "getValidationMessage", function (path) {
      return _.get(_this.validationMessages, path);
    });

    this.MetadataService = MetadataService;
    this.$q = $q;
    this.$scope = $scope;
    this.selectedTypeDescriptor = this.forceTypeDescriptor || null;
    this.autocompleteCandidates = [];
    this._properties = [];
    this.descriptors = [];
  }

  createClass_default()(DipCIControlController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      this.MetadataService.getDescriptors().then(function (descriptors) {
        _this2.descriptors = descriptors;
        _this2.autocompleteCandidates = descriptors.filter(function (descriptor) {
          if (_this2.forceTypeDescriptor) {
            return descriptor.type === _this2.forceTypeDescriptor.type;
          }

          return !_.isUndefined(descriptor.superTypes) && _.includes(descriptor.superTypes, _this2.MetadataService.getCiType(_this2.ciTypeDescriptor)) && descriptor.virtual === false;
        });

        _this2.initializeForm(_this2.configurationItem.type);
      });
    }
  }, {
    key: "$onChanges",
    value: function $onChanges(changes) {
      if (angular.isDefined(changes.useRadioButtons)) {
        this.useRadioButtons = angular.isDefined(changes.useRadioButtons.currentValue) ? changes.useRadioButtons.currentValue : true;
      } else {
        this.useRadioButtons = true;
      }

      if (angular.isDefined(changes.showDescriptionForSelectedTypeDescriptor)) {
        this.showDescriptionForSelectedTypeDescriptor = angular.isDefined(changes.showDescriptionForSelectedTypeDescriptor.currentValue) ? changes.showDescriptionForSelectedTypeDescriptor.currentValue : false;
      } else {
        this.showDescriptionForSelectedTypeDescriptor = false;
      }

      if (changes.reinitializeFormTrigger && this.configurationItem && this.configurationItem.type) {
        this.initializeForm(this.configurationItem.type);
      }
    }
  }, {
    key: "descriptorDropdownLabel",
    get: function get() {
      return this.selectedTypeDescriptor && this.selectedTypeDescriptor.label || (this.autocompleteCandidates.length ? 'Select' : 'No items available');
    }
  }, {
    key: "defaultDescriptionLabel",
    get: function get() {
      return this.defaultDescription || '';
    }
  }, {
    key: "properties",
    get: function get() {
      var _this3 = this;

      return this._properties.filter(function (property) {
        return angular.isUndefined(_this3.ignoredCategories) || !_.includes(_this3.ignoredCategories, property.category);
      }).filter(function (property) {
        return angular.isUndefined(_this3.includedCategories) || !_.isEmpty(_this3.includedCategories) && _.includes(_this3.includedCategories, property.category);
      });
    }
  }]);

  return DipCIControlController;
}();

ci_control_component_DipCIControlController.$inject = ['MetadataService', '$q', '$scope'];
var DipCIControlComponent = {
  bindings: {
    ciTypeDescriptor: '<',
    configurationItem: '=',
    readonly: '<',
    reinitializeFormTrigger: '<',
    ignoredCategories: '<',
    includedCategories: '<',
    useRadioButtons: '<',
    showDescriptionForSelectedTypeDescriptor: '<',
    renderers: '<',
    defaultDescription: '<',
    onChange: '&',
    forceTypeDescriptor: '<',
    validationMessages: '<'
  },
  controller: ci_control_component_DipCIControlController,
  require: {
    formCtrl: '^form'
  },
  templateUrl: "static/9.7.16/xlr-components/ci-control-component/ci-control-component-partial.html"
};
angular.module('xlrelease').component('dipCiControl', DipCIControlComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/context-menu/xlr-context-menu.js



var xlr_context_menu_template = "\n        <ul class=\"dropdown-menu\" role=\"menu\">\n            <li ng-repeat=\"item in $ctrl.items\" ng-class=\"{'disabled': item.disabled, 'item-with-icon': item.icon}\" role=\"menuitem\">\n                <a tabindex=\"-1\" ng-click=\"!item.disabled && $ctrl.executeAction(item)\" hide-popover-on-click>\n                    <i ng-if=\"item.icon\" ng-class=\"item.icon\"></i>\n                    <span>{{item.title}}</span>\n                </a>\n            </li>\n        </ul>\n    ";

var xlr_context_menu_ContextMenuCtrl = /*#__PURE__*/function () {
  function ContextMenuCtrl(EventBus, ModalService, $uibModal) {
    classCallCheck_default()(this, ContextMenuCtrl);

    this._EventBus = EventBus;
    this._ModalService = ModalService;
    this._$uibModal = $uibModal;
  }

  createClass_default()(ContextMenuCtrl, [{
    key: "executeAction",
    value: function executeAction(item) {
      if (item.eventType) {
        this._EventBus.emit(item.eventType, item.data);
      } else if (item.modal) {
        var modal = this._$uibModal.open({
          animation: false,
          component: item.modal,
          resolve: {
            data: function data() {
              return item.data;
            }
          }
        });

        if (item.refresh) {
          modal.result.then(function (value) {
            return item.refresh(value);
          });
        }
      } else if (item.modalTemplate) {
        this._$uibModal.open({
          animation: false,
          templateUrl: item.modalTemplate,
          controller: function controller() {
            return item.data.ctrl;
          },
          controllerAs: 'ctrl'
        });
      } else if (item.action) {
        item.action();
      }
    }
  }]);

  return ContextMenuCtrl;
}();

defineProperty_default()(xlr_context_menu_ContextMenuCtrl, "$inject", ['EventBus', 'ModalService', '$uibModal']);

angular.module('xlrelease').component('xlrContextMenu', {
  controller: xlr_context_menu_ContextMenuCtrl,
  template: xlr_context_menu_template,
  bindings: {
    items: '<'
  }
});
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/delete-team-modal-component/delete-team-modal-component.js
var delete_team_modal_component = __webpack_require__(1410);

// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/delete-comment-modal-component/delete-comment-modal-component.js
var delete_comment_modal_component = __webpack_require__(1411);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/dependency-selector/dependency-selector-component.js





function dependency_selector_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function dependency_selector_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { dependency_selector_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { dependency_selector_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var dependency_selector_component_DependencySelectorController = /*#__PURE__*/function () {
  function DependencySelectorController($q, $timeout, GateService, VariablesInterpolator) {
    var _this = this;

    classCallCheck_default()(this, DependencySelectorController);

    defineProperty_default()(this, "_getSelectedReleasePhases", function () {
      return _.get(_this._fullRelease, 'phases', []);
    });

    defineProperty_default()(this, "_getSelectedPhaseTasks", function () {
      var selectedPhase = _this._getSelectedReleasePhases().find(function (p) {
        return p.id === _this.model.phaseId;
      });

      return _.get(selectedPhase, 'tasks', []);
    });

    this._$q = $q;
    this._$timeout = $timeout;
    this._GateService = GateService;
    this._VariablesInterpolator = VariablesInterpolator;
    this._fetchingCandidates = false;
    this._fetchingRelease = false;
    this._accessible = true;
    this._dependencyTargetCandidates = [];
    this._showLoadingIndicator = false;
    this._selectedRelease = null;
    this._selectedPhase = null;
    this._selectedTask = null;
    this._fullRelease = null;
  }

  createClass_default()(DependencySelectorController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      if (this.model.releaseId || this.model.archived) {
        this._convertDependencyNodeToRelease(this.model);
      }

      if (!this.model.archived) {
        this._fetchDependencyTargetCandidates().then(function (candidates) {
          _this2._accessible = _this2._isAccessible(candidates, _this2.model);

          if (_this2._accessible) {
            _this2._dependencyTargetCandidates = candidates;

            _this2._updateFullRelease(_this2.model.releaseId);
          }
        });
      }

      this._createListHandlers();
    }
  }, {
    key: "_convertDependencyNodeToRelease",
    value: function _convertDependencyNodeToRelease(target) {
      if (target.archived) {
        var _target$releaseTitle$ = target.releaseTitle.split('/').map(function (pi) {
          return pi.trim();
        }),
            _target$releaseTitle$2 = slicedToArray_default()(_target$releaseTitle$, 3),
            releaseTitle = _target$releaseTitle$2[0],
            phaseTitle = _target$releaseTitle$2[1],
            taskTitle = _target$releaseTitle$2[2];

        this._selectedRelease = {
          id: null,
          title: releaseTitle
        };

        if (phaseTitle) {
          this._selectedPhase = {
            id: null,
            title: phaseTitle
          };

          if (taskTitle) {
            this._selectedTask = {
              id: null,
              title: taskTitle
            };
          }
        }
      } else {
        this._selectedRelease = {
          id: target.releaseId,
          title: target.releaseTitle
        };

        if (target.phaseId) {
          this._selectedPhase = {
            id: target.phaseId,
            title: target.phaseTitle
          };

          if (target.taskId) {
            this._selectedTask = {
              id: target.taskId,
              title: target.taskTitle
            };
          }
        }
      }

      this._fullRelease = {
        id: this.selectedRelease.id,
        title: this.selectedRelease.title,
        phases: this.selectedPhase ? [{
          id: this.selectedPhase.id,
          title: this.selectedPhase.title,
          tasks: this.selectedTask ? [{
            id: this.selectedTask.id,
            title: this.selectedTask.title
          }] : []
        }] : [],
        variables: []
      };
      this._dependencyTargetCandidates = [this._fullRelease];
    }
  }, {
    key: "_scheduleLoadingIndicator",
    value: function _scheduleLoadingIndicator(condition) {
      var _this3 = this;

      this._$timeout(function () {
        if (condition()) {
          _this3._showLoadingIndicator = true;
        }
      }, 1000);
    }
  }, {
    key: "_fetchDependencyTargetCandidates",
    value: function _fetchDependencyTargetCandidates() {
      var _this4 = this;

      this._scheduleLoadingIndicator(function () {
        return _this4._fetchingCandidates;
      });

      this._fetchingCandidates = true;
      return this._GateService.fetchDependencyTargetCandidates(this.taskId).then(function (candidates) {
        _this4._showLoadingIndicator = false;
        _this4._fetchingCandidates = false;
        return candidates;
      });
    }
  }, {
    key: "_fetchRelease",
    value: function _fetchRelease(releaseId) {
      var _this5 = this;

      this._scheduleLoadingIndicator(function () {
        return _this5._fetchingRelease;
      });

      this._fetchingRelease = true;
      return this._GateService.fetchDependencyTargetCandidate(this.taskId, releaseId).then(function (release) {
        _this5._showLoadingIndicator = false;
        _this5._fetchingRelease = false;
        return release;
      });
    }
  }, {
    key: "_updateFullRelease",
    value: function _updateFullRelease(releaseId) {
      var _this6 = this;

      if (releaseId) {
        this._fetchRelease(releaseId).then(function (release) {
          _this6._fullRelease = release;
        });
      } else {
        this._fullRelease = null;
      }
    }
  }, {
    key: "_isAccessible",
    value: function _isAccessible(candidates, target) {
      return target.releaseId ? _.some(candidates, {
        id: target.releaseId
      }) : true;
    }
  }, {
    key: "_createListHandlers",
    value: function _createListHandlers() {
      var _this7 = this;

      var autocompleteHandler = function autocompleteHandler(items, term) {
        var deferred = _this7._$q.defer();

        var candidates = items.filter(function (item) {
          return item.title.includes(term);
        });
        deferred.resolve(candidates);
        return deferred.promise;
      };

      var interpolate = function interpolate(title) {
        var variables = _.get(_this7._fullRelease, 'variables', []);

        return _this7._VariablesInterpolator.interpolateInText(variables, title);
      };

      this._releaseListHandlers = {
        addCandidates: function addCandidates(metadata, options) {
          return autocompleteHandler(_this7._dependencyTargetCandidates, options.term);
        }
      };
      this._phaseListHandlers = {
        addCandidates: function addCandidates(metadata, options) {
          return autocompleteHandler(_this7._getSelectedReleasePhases().map(function (phase) {
            return dependency_selector_component_objectSpread({}, phase, {
              title: interpolate(phase.title)
            });
          }), options.term);
        }
      };
      this._taskListHandlers = {
        addCandidates: function addCandidates(metadata, options) {
          return autocompleteHandler(_this7._getSelectedPhaseTasks().map(function (task) {
            return dependency_selector_component_objectSpread({}, task, {
              title: interpolate(task.title)
            });
          }), options.term);
        }
      };
    }
  }, {
    key: "fetchingData",
    get: function get() {
      return this._fetchingCandidates || this._fetchingRelease;
    }
  }, {
    key: "showLoadingIndicator",
    get: function get() {
      return this._showLoadingIndicator;
    }
  }, {
    key: "accessible",
    get: function get() {
      return !this.model.archived && this._accessible;
    }
  }, {
    key: "releaseListHandlers",
    get: function get() {
      return this._releaseListHandlers;
    }
  }, {
    key: "phaseListHandlers",
    get: function get() {
      return this._phaseListHandlers;
    }
  }, {
    key: "taskListHandlers",
    get: function get() {
      return this._taskListHandlers;
    }
  }, {
    key: "selectedRelease",
    get: function get() {
      return this._selectedRelease;
    },
    set: function set(release) {
      this._selectedRelease = release;
      var releaseId = release ? release.id : null;

      if (releaseId !== this.model.releaseId) {
        this.model.releaseId = releaseId;
        this.model.releaseTitle = release ? release.title : null;
        this.selectedPhase = null;

        this._updateFullRelease(releaseId);

        this.onChange();
      }
    }
  }, {
    key: "selectedPhase",
    get: function get() {
      return this._selectedPhase;
    },
    set: function set(phase) {
      this._selectedPhase = phase;
      var phaseId = phase ? phase.id : null;

      if (phaseId !== this.model.phaseId) {
        this.model.phaseId = phaseId;
        this.model.phaseTitle = phase ? phase.title : null;
        this.selectedTask = null;
        this.onChange();
      }
    }
  }, {
    key: "selectedTask",
    get: function get() {
      return this._selectedTask;
    },
    set: function set(task) {
      this._selectedTask = task;
      var taskId = task ? task.id : null;

      if (taskId !== this.model.taskId) {
        this.model.taskId = task ? task.id : null;
        this.model.taskTitle = task ? task.title : null;
        this.onChange();
      }
    }
  }]);

  return DependencySelectorController;
}();

dependency_selector_component_DependencySelectorController.$inject = ['$q', '$timeout', 'GateService', 'VariablesInterpolator'];
var DependencySelectorComponent = {
  bindings: {
    taskId: '<',
    model: '<',
    onChange: '&'
  },
  controller: dependency_selector_component_DependencySelectorController,
  templateUrl: 'static/9.7.16/xlr-components/dependency-selector/dependency-selector-partial.html'
};
angular.module('xlrelease').component('dependencySelector', DependencySelectorComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/dropdown/dropdown-component.html
/* harmony default export */ var dropdown_component = ("<div class=\"xlr-dropdown\">\n    <span uib-dropdown class=\"btn-block\">\n        <button type=\"button\" class=\"btn btn-flat btn-fixed\" uib-dropdown-toggle ng-disabled=\"$ctrl.readonly\">\n            <span class=\"dropdown-label\">{{$ctrl.title || $ctrl.placeholder}}</span>\n            <span class=\"caret\"></span>\n        </button>\n        <ul uib-dropdown-menu>\n            <li ng-repeat=\"option in $ctrl.options\"\n                ng-class=\"{active: $ctrl.isActive(option)}\">\n                <a ng-click=\"$ctrl.onSelect(option.id)\" data-test=\"option\">\n                   {{option.title}}\n                </a>\n            </li>\n        </ul>\n    </span>\n</div>\n");
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/dropdown/dropdown.less
var dropdown = __webpack_require__(1412);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/dropdown/dropdown-component.js





var dropdown_component_DropdownController = /*#__PURE__*/function () {
  function DropdownController() {
    classCallCheck_default()(this, DropdownController);

    this.options = this.options || [];
  }

  createClass_default()(DropdownController, [{
    key: "$onInit",
    value: function $onInit() {
      var self = this;

      this.model.$render = function () {
        self.value = self.model.$viewValue;
      };
    }
  }, {
    key: "isActive",
    value: function isActive(option) {
      return option.id === this.value;
    }
  }, {
    key: "onSelect",
    value: function onSelect(optionId) {
      this.value = optionId;
      this.model.$setViewValue(optionId);

      if (this.onChange) {
        this.onChange();
      }
    }
  }, {
    key: "title",
    get: function get() {
      var _this = this;

      var found = this.options.find(function (op) {
        return op.id === _this.value;
      });
      return found ? found.title : '';
    }
  }]);

  return DropdownController;
}();

var dropdownComponent = {
  bindings: {
    onChange: '&',
    options: '<',
    placeholder: '<',
    readonly: '<'
  },
  require: {
    model: 'ngModel'
  },
  controller: dropdown_component_DropdownController,
  template: dropdown_component
};
angular.module('xlrelease').component('xlrDropdown', dropdownComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/facet-selector/facet-list-component.html
/* harmony default export */ var facet_list_component = ("<div class=\"xl-facet-selector\">\n    <facet-list-item ng-repeat=\"facet in $ctrl.facets\"\n                     expanded=\"$index === $ctrl.expandedIndex\"\n                     facet=\"facet\"\n                     facet-types=\"$ctrl.facetTypes\"\n                     on-cancel=\"$ctrl.onCancel()\"\n                     on-change=\"$ctrl.onFacetUpdateInternal(facet)\"\n                     on-click=\"$ctrl.onItemClick($index)\"\n                     on-delete=\"$ctrl.onFacetDeleteInternal(facetId)\"\n                     readonly=\"$ctrl.readonly\"\n                     variables=\"$ctrl.variables\"\n                     resolved-variables=\"$ctrl.resolvedVariables\"\n                     on-new-variable=\"$ctrl.onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"></facet-list-item>\n    <facet-form ng-if=\"!!$ctrl.addingMode\"\n                facet-types=\"$ctrl.facetTypes\"\n                variables=\"$ctrl.variables\"\n                resolved-variables=\"$ctrl.resolvedVariables\"\n                on-new-variable=\"$ctrl.onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"\n                on-cancel=\"$ctrl.onCancel()\"\n                on-submit=\"$ctrl.onFacetCreateInternal(facet)\"></facet-form>\n    <button class=\"button\"\n            data-test=\"add-facet\"\n            ng-if=\"$ctrl.showAddButton()\"\n            ng-click=\"$ctrl.onAddFacetClick()\">Add attribute\n    </button>\n</div>\n");
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/facet-selector/facet-list.less
var facet_list = __webpack_require__(690);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/facet-selector/facet-list-component.js






var facet_list_component_FacetListController = /*#__PURE__*/function () {
  function FacetListController(Authenticator) {
    classCallCheck_default()(this, FacetListController);

    this.Authenticator = Authenticator;
  }

  createClass_default()(FacetListController, [{
    key: "$onInit",
    value: function $onInit() {
      this._closeAddingMode();
    }
  }, {
    key: "onAddFacetClick",
    value: function onAddFacetClick() {
      this.addingMode = true;
      this.expandedIndex = null;
    }
  }, {
    key: "onItemClick",
    value: function onItemClick(idx) {
      this.addingMode = false;
      this.expandedIndex = idx;
    }
  }, {
    key: "onFacetCreateInternal",
    value: function onFacetCreateInternal(facet) {
      this._closeAddingMode();

      this.onFacetCreate({
        facet: facet
      });
    }
  }, {
    key: "onFacetUpdateInternal",
    value: function onFacetUpdateInternal(facet) {
      this._closeAddingMode();

      this.onFacetUpdate({
        facet: facet
      });
    }
  }, {
    key: "onFacetDeleteInternal",
    value: function onFacetDeleteInternal(facetId) {
      this._closeAddingMode();

      this.onFacetDelete({
        facetId: facetId
      });
    }
  }, {
    key: "onCancel",
    value: function onCancel() {
      this._closeAddingMode();
    }
  }, {
    key: "_closeAddingMode",
    value: function _closeAddingMode() {
      this.addingMode = false;
      this.expandedIndex = null;
    }
  }, {
    key: "showAddButton",
    value: function showAddButton() {
      if (this.readonly) {
        return false;
      }

      return (angular.isUndefined(this.expandedIndex) || this.expandedIndex === null) && !this.addingMode;
    }
  }]);

  return FacetListController;
}();

defineProperty_default()(facet_list_component_FacetListController, "$inject", ['Authenticator']);

var FacetListComponent = {
  bindings: {
    facets: '<',
    facetTypes: '<',
    onFacetCreate: '&',
    onFacetUpdate: '&',
    onFacetDelete: '&',
    readonly: '<',
    variables: '<',
    resolvedVariables: '<',
    onNewVariable: '&'
  },
  controller: facet_list_component_FacetListController,
  template: facet_list_component
};
angular.module('xlrelease').component('facetList', FacetListComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/facet-selector/facet-list-container.js





var facet_list_container_FacetListContainerController = /*#__PURE__*/function () {
  function FacetListContainerController(FacetsService, Ids, TasksService) {
    classCallCheck_default()(this, FacetListContainerController);

    this._facetsService = FacetsService;
    this._tasksService = TasksService;
    this._ids = Ids;
  }

  createClass_default()(FacetListContainerController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;

      this._updateFacetsList();

      this._facetsService.getTypes('xlrelease.ConfigurationFacet').then(function (resp) {
        _this.facetTypes = resp.data;
      });
    }
  }, {
    key: "onFacetCreate",
    value: function onFacetCreate(facet) {
      var _this2 = this;

      facet.targetId = this._ids.toDomainId(this.task.id);

      this._facetsService.save(facet).then(function (resp) {
        _this2.task.facets = [].concat(toConsumableArray_default()(_this2.task.facets), [resp.data]);

        _this2._updateFacetsList();
      });
    }
  }, {
    key: "_updateFacetsList",
    value: function _updateFacetsList() {
      this.facets = this.task.facets; // reset the flag

      if (this.task.checkAttributes && !this._tasksService.hasDeploymentFacet(this.task)) {
        this.task.checkAttributes = false;
      }
    }
  }, {
    key: "onFacetUpdate",
    value: function onFacetUpdate(facet) {
      var _this3 = this;

      this._facetsService.update(facet).then(function (resp) {
        _this3.task.facets = _this3.task.facets.map(function (f) {
          return f.id === facet.id ? resp.data : f;
        });

        _this3._updateFacetsList();
      });
    }
  }, {
    key: "onFacetDelete",
    value: function onFacetDelete(facetId) {
      var _this4 = this;

      this._facetsService.remove(facetId).then(function () {
        _this4.task.facets = _this4.task.facets.filter(function (f) {
          return f.id !== facetId;
        });

        _this4._updateFacetsList();
      });
    }
  }]);

  return FacetListContainerController;
}();

defineProperty_default()(facet_list_container_FacetListContainerController, "$inject", ['FacetsService', 'Ids', 'TasksService']);

var FacetListContainerComponent = {
  bindings: {
    task: '=',
    readonly: '<',
    variables: '<',
    resolvedVariables: '<',
    onNewVariable: '&'
  },
  controller: facet_list_container_FacetListContainerController,
  template: "<div ng-if=\"!$ctrl.readonly\">Additional information about task execution that is used in dashboards and reports:</div>\n               <div ng-if=\"$ctrl.readonly && $ctrl.facets.length == 0\">No attributes defined</div>\n               <facet-list ng-if=\"$ctrl.facets && $ctrl.facetTypes\"\n                           facets=\"$ctrl.facets\" \n                           facet-types=\"$ctrl.facetTypes\" \n                           on-facet-create=\"$ctrl.onFacetCreate(facet)\"  \n                           on-facet-update=\"$ctrl.onFacetUpdate(facet)\"\n                           on-facet-delete=\"$ctrl.onFacetDelete(facetId)\"\n                           readonly=\"$ctrl.readonly\"\n                           variables=\"$ctrl.variables\"\n                           resolved-variables=\"$ctrl.resolvedVariables\"\n                           on-new-variable=\"$ctrl.onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"\n               ></facet-list>"
};
angular.module('xlrelease').component('facetListContainer', FacetListContainerComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/facet-selector/facet-list-item-component.html
/* harmony default export */ var facet_list_item_component = ("<div class=\"facet-list\">\n    <facet-form ng-if=\"$ctrl.expanded\"\n                facet=\"$ctrl.facet\"\n                facet-types=\"$ctrl.facetTypes\"\n                on-cancel=\"$ctrl.onCancelInternal()\"\n                on-submit=\"$ctrl.onChangeInternal(facet)\"\n                readonly=\"$ctrl.readonly\"\n                variables=\"$ctrl.variables\"\n                resolved-variables=\"$ctrl.resolvedVariables\"\n                on-new-variable=\"$ctrl.onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"></facet-form>\n    <div ng-if=\"!$ctrl.expanded\" ng-click=\"$ctrl.onClick()\" class=\"list-item\">\n        {{$ctrl.facetTypeNames.get($ctrl.facet.type)}}\n        <span class=\"facet-actions\" ng-if=\"!$ctrl.readonly\">\n            <span id=\"edit\">\n                <i title=\"Edit\" class=\"menu-item-icon xl-icon edit-icon\"></i>\n                <span class=\"action-label\">Edit</span>\n            </span>\n            <span id=\"delete\">\n                <i title=\"Delete\" class=\"menu-item-icon xl-icon delete-icon\"></i>\n                <span ng-click=\"$ctrl.deleteFacet($event)\" class=\"action-label\" data-test=\"delete\">Delete</span>\n            </span>\n        </span>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/facet-selector/facet-list-item-component.js






var facet_list_item_component_FacetListItemController = /*#__PURE__*/function () {
  function FacetListItemController(Authenticator) {
    classCallCheck_default()(this, FacetListItemController);

    this.Authenticator = Authenticator;
  }

  createClass_default()(FacetListItemController, [{
    key: "$onInit",
    value: function $onInit() {
      this.backup = angular.copy(this.facet);
      this.facetTypeNames = new Map(this.facetTypes.map(function (t) {
        return [t.type, t.label];
      }));
    }
  }, {
    key: "onChangeInternal",
    value: function onChangeInternal(facet) {
      if (this.readonly) {
        return;
      }

      this.backup = angular.copy(this.facet);
      this.onChange({
        facet: facet
      });
    }
  }, {
    key: "onCancelInternal",
    value: function onCancelInternal() {
      this.facet = angular.copy(this.backup);
      this.onCancel();
    }
  }, {
    key: "deleteFacet",
    value: function deleteFacet($event) {
      $event.stopPropagation();

      if (this.readonly) {
        return;
      }

      this.onDelete({
        facetId: this.facet.id
      });
    }
  }]);

  return FacetListItemController;
}();

defineProperty_default()(facet_list_item_component_FacetListItemController, "$inject", ['Authenticator']);

var FacetListItemComponent = {
  bindings: {
    expanded: '<',
    facet: '<',
    facetTypes: '<',
    onCancel: '&',
    onChange: '&',
    onClick: '&',
    onDelete: '&',
    readonly: '<',
    variables: '<',
    resolvedVariables: '<',
    onNewVariable: '&'
  },
  controller: facet_list_item_component_FacetListItemController,
  template: facet_list_item_component
};
angular.module('xlrelease').component('facetListItem', FacetListItemComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/facet-selector/index.js



// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/button-toggle-filter-component.js



var button_toggle_filter_component_template = "\n    <button type=\"button\" class=\"btn btn-flat btn-fixed button-toggle-filter\" ng-class=\"{'active': $ctrl.value}\" ng-click=\"$ctrl.update()\" \n            ng-disabled=\"$ctrl.disabled()\">\n         <ng-transclude></ng-transclude>\n    </button>\n    ";

var button_toggle_filter_component_ButtonToggleFilterController = /*#__PURE__*/function () {
  function ButtonToggleFilterController() {
    classCallCheck_default()(this, ButtonToggleFilterController);
  }

  createClass_default()(ButtonToggleFilterController, [{
    key: "update",
    value: function update() {
      var newValue = !this.filterCtrl.getValue(this.filter);
      this.filterCtrl.update(defineProperty_default()({}, this.filter, newValue));
    }
  }, {
    key: "value",
    get: function get() {
      return this.filterCtrl.getValue(this.filter);
    }
  }]);

  return ButtonToggleFilterController;
}();

var ButtonToggleFilter = {
  bindings: {
    filter: '<',
    disabled: '&'
  },
  controller: button_toggle_filter_component_ButtonToggleFilterController,
  require: {
    filterCtrl: '^filter'
  },
  template: button_toggle_filter_component_template,
  transclude: true
};
angular.module('xlrelease').component('buttonToggleFilter', ButtonToggleFilter);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/date-filter-component.js


var date_filter_component_template = "\n    <div class=\"from-to-date-filters\">\n        <div class=\"date-filter from-date\">\n            <strong>From:</strong>\n            <div date-editor data-ng-model=\"$ctrl.from\" data-deletable=\"true\" class=\"date-filter_date\"></div>\n        </div>\n        <div class=\"date-filter to-date\">\n            <strong>To:</strong>\n            <div date-editor data-ng-model=\"$ctrl.to\" data-deletable=\"true\" class=\"date-filter_date\"></div>\n        </div>\n    </div>\n    ";

var date_filter_component_DateFilterController = /*#__PURE__*/function () {
  function DateFilterController() {
    classCallCheck_default()(this, DateFilterController);
  }

  createClass_default()(DateFilterController, [{
    key: "_updateValue",
    value: function _updateValue(prop, value) {
      var change = _.set({}, prop, value);

      this.filterCtrl.update(change);
    }
  }, {
    key: "from",
    get: function get() {
      return this.filterCtrl.getValue('from');
    },
    set: function set(value) {
      this._updateValue('from', value);
    }
  }, {
    key: "to",
    get: function get() {
      return this.filterCtrl.getValue('to');
    },
    set: function set(value) {
      this._updateValue('to', value);
    }
  }]);

  return DateFilterController;
}();

var DateFilter = {
  controller: date_filter_component_DateFilterController,
  require: {
    filterCtrl: '^filter'
  },
  template: date_filter_component_template
};
angular.module('xlrelease').component('dateFilter', DateFilter);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/filter-component.js


var FilterControllerTemplate = "\n    <div class=\"filters\" ng-transclude></ng-transclude>\n    ";

var filter_component_FilterController = /*#__PURE__*/function () {
  function FilterController(FiltersQueryParams) {
    classCallCheck_default()(this, FilterController);

    this._FiltersQueryParams = FiltersQueryParams;
  }

  createClass_default()(FilterController, [{
    key: "applyFilter",
    value: function applyFilter() {
      this._FiltersQueryParams.update(this.filters);

      this.onChange({
        filters: this.filters
      });
    }
  }, {
    key: "update",
    value: function update(values) {
      if (!this.filters) {
        this.filters = {};
      }

      Object.assign(this.filters, values);
      this.applyFilter();
    }
  }, {
    key: "getValue",
    value: function getValue(prop) {
      return _.get(this.filters, prop);
    }
  }]);

  return FilterController;
}();

filter_component_FilterController.$inject = ['FiltersQueryParams'];
var FilterComponent = {
  bindings: {
    filters: '<',
    onChange: '&'
  },
  controller: filter_component_FilterController,
  template: FilterControllerTemplate,
  transclude: true
};
angular.module('xlrelease').component('filter', FilterComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/order-by-filter-component.js



// TODO: [REL-5759] change <span> to <a href="javascript:void(0)"> after getting rid of karma e2e
(function (module) {
  var DEFAULT_ORDER_OPTIONS = [{
    label: 'Risk',
    filter: 'risk'
  }, {
    label: 'Start date',
    filter: 'start_date'
  }, {
    label: 'End date',
    filter: 'end_date'
  }];

  var OrderByFilterController = /*#__PURE__*/function () {
    function OrderByFilterController() {
      classCallCheck_default()(this, OrderByFilterController);
    }

    createClass_default()(OrderByFilterController, [{
      key: "$onInit",
      value: function $onInit() {
        if (!this.orderOptions) {
          this.orderOptions = DEFAULT_ORDER_OPTIONS;
        }
      }
    }, {
      key: "isActive",
      value: function isActive(order) {
        return this.filterCtrl.getValue('orderBy') === order;
      }
    }, {
      key: "onChange",
      value: function onChange(order) {
        this.filterCtrl.update({
          orderBy: order
        });
      }
    }, {
      key: "activeOrder",
      get: function get() {
        var _this = this;

        return this.orderOptions.find(function (orderOption) {
          return _this.isActive(orderOption.filter);
        });
      }
    }]);

    return OrderByFilterController;
  }();

  var html = "\n        <span class=\"filter-title\">Order By</span>\n        <span uib-dropdown class=\"order-by-filter\">\n            <button type=\"button\" class=\"btn btn-flat btn-fixed\" uib-dropdown-toggle>\n                <span class=\"dropdown-label\">{{$ctrl.activeOrder.label}}</span>\n                <i class=\"xl-icon arrow-down-icon icon-s\" />\n            </button>\n            <ul uib-dropdown-menu>\n                <li ng-repeat=\"orderOption in $ctrl.orderOptions\">\n                    <span\n                        class=\"bootstrap-link\"\n                        ng-class=\"{'filter-active': $ctrl.isActive(orderOption.filter)}\" \n                        ng-click=\"!$ctrl.isDisabled(orderOption.filter) && $ctrl.onChange(orderOption.filter)\">\n                        {{orderOption.label}}\n                    </span>\n                </li>\n            </ul>\n        </span>";
  var OrderByFilterComponent = {
    require: {
      filterCtrl: '^filter'
    },
    bindings: {
      orderOptions: '<?'
    },
    controller: OrderByFilterController,
    template: html
  };
  module.component('orderByFilter', OrderByFilterComponent);
})(angular.module('xlrelease'));
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/filter-component/search-filter-component.less
var search_filter_component = __webpack_require__(1413);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/search-filter-component.js




function search_filter_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function search_filter_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { search_filter_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { search_filter_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }


var search_filter_component_template = "\n<button type=\"button\" class=\"btn btn-flat btn-fixed button-toggle-filter toggle-search-filter\" ng-class=\"{'active': $ctrl.isActive}\" ng-click=\"$ctrl.toggle()\">\n    <i class=\"button-toggle-filter-icon xl-icon search-icon\"></i> <span class=\"button-toggle-filter-label\">{{$ctrl.label || 'Search'}}</span>\n</button>\n";

var search_filter_component_SearchFilterController = /*#__PURE__*/function () {
  function SearchFilterController(ClientSettings) {
    classCallCheck_default()(this, SearchFilterController);

    this._ClientSettings = ClientSettings;
  }

  createClass_default()(SearchFilterController, [{
    key: "toggle",
    value: function toggle() {
      this._isActive = !this._isActive;
      this.updateLayout(this._isActive);
    }
  }, {
    key: "$onInit",
    value: function $onInit() {
      this._isActive = this.getLayout().expanded;
    }
  }, {
    key: "getLayout",
    value: function getLayout() {
      return this._ClientSettings['get' + this.layout + 'FiltersLayout']() || {
        expanded: false
      };
    }
  }, {
    key: "updateLayout",
    value: function updateLayout(expanded) {
      this._ClientSettings['set' + this.layout + 'FiltersLayout'](search_filter_component_objectSpread({}, this.getLayout(), {
        expanded: expanded
      }));
    }
  }, {
    key: "isActive",
    get: function get() {
      return this._isActive;
    }
  }, {
    key: "label",
    get: function get() {
      var items = [this.filterCtrl.getValue('title')].concat([this.filterCtrl.getValue('filter')]).concat(this.filterCtrl.getValue('tags'));
      return items.filter(function (item) {
        return !_.isEmpty(item);
      }).join('; ');
    }
  }]);

  return SearchFilterController;
}();

var searchFilter = {
  controller: search_filter_component_SearchFilterController,
  bindings: {
    layout: '<'
  },
  require: {
    filterCtrl: '^filter'
  },
  template: search_filter_component_template
};
angular.module('xlrelease').component('searchFilter', searchFilter);
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/filter-component/tag-filter-component.less
var tag_filter_component = __webpack_require__(1414);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/tag-filter-component.js



var tag_filter_component_template = "\n    <div id=\"tags\" focus-on-click class=\"transparent green-tags\" tags-input tags=\"$ctrl.tags\" \n         on-change=\"$ctrl.updateTags(tags)\" placeholder=\"Filter by tags...\" completion-candidates=\"$ctrl.allTags\"></div>\n";

var tag_filter_component_TagFilterController = /*#__PURE__*/function () {
  function TagFilterController() {
    classCallCheck_default()(this, TagFilterController);
  }

  createClass_default()(TagFilterController, [{
    key: "updateTags",
    value: function updateTags(tags) {
      this.filterCtrl.update({
        tags: tags
      });
    }
  }, {
    key: "tags",
    get: function get() {
      return this.filterCtrl.getValue('tags');
    }
  }]);

  return TagFilterController;
}();

var tagFilter = {
  bindings: {
    allTags: '<?'
  },
  controller: tag_filter_component_TagFilterController,
  require: {
    filterCtrl: '^filter'
  },
  template: tag_filter_component_template
};
angular.module('xlrelease').component('tagFilter', tagFilter);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/text-filter-component.js


var text_filter_component_template = "\n    <input class=\"searchFilter\" autofocus type=\"search\"\n           id=\"{{$ctrl.elementId}}\"\n           placeholder=\"{{$ctrl.placeholder}}\" \n           ng-model=\"$ctrl.value\"\n           ng-model-options=\"$ctrl.modelOptions\"\n           focus-on=\"$ctrl.focusOn()\">\n    ";

var text_filter_component_TextFilterController = /*#__PURE__*/function () {
  function TextFilterController() {
    classCallCheck_default()(this, TextFilterController);
  }

  createClass_default()(TextFilterController, [{
    key: "$onInit",
    value: function $onInit() {
      this.field = this.field || 'filter';
    }
  }, {
    key: "modelOptions",
    get: function get() {
      return {
        debounce: 1200
      };
    }
  }, {
    key: "value",
    get: function get() {
      return this.filterCtrl.getValue(this.field);
    },
    set: function set(value) {
      this.filterCtrl.update(_.set({}, this.field, value));
    }
  }]);

  return TextFilterController;
}();

var TextFilter = {
  bindings: {
    placeholder: '<',
    elementId: '<',
    field: '<',
    focusOn: '&'
  },
  controller: text_filter_component_TextFilterController,
  require: {
    filterCtrl: '^filter'
  },
  template: text_filter_component_template
};
angular.module('xlrelease').component('textFilter', TextFilter);
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/filter-component/composite-filter/composite-filter-component.js + 1 modules
var composite_filter_component = __webpack_require__(353);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/composite-filter/composite-filter-service.js



var COMPOSITE_FILTER_TYPE = 'xlrelease.CompositeFilter';
var ENTITY_ID_PLACEHOLDER = "-1";
var composite_filter_service_CompositeFilterService = /*#__PURE__*/function () {
  function CompositeFilterService($q) {
    classCallCheck_default()(this, CompositeFilterService);

    this.$q = $q;
    this.filters = {};
  }

  createClass_default()(CompositeFilterService, [{
    key: "registerFilter",
    value: function registerFilter(type, definition) {
      if (!definition.fromStored) {
        definition.fromStored = this.fromStoredDefault.bind(this);
      }

      if (!definition.toStored) {
        definition.toStored = this.toStoredDefault.bind(this);
      }

      this.filters[type] = definition;
    }
  }, {
    key: "getFilter",
    value: function getFilter(type) {
      return this.filters[type];
    }
  }, {
    key: "loadCandidates",
    value: function loadCandidates(availableTypes, forceLoad) {
      var _this = this;

      var filters = availableTypes.map(function (availableType) {
        return _this.getFilter(availableType);
      }).filter(Boolean);
      return this.$q.all(filters.map(function (f) {
        return f.autocompleteCandidates(forceLoad);
      })).then(function (results) {
        return _.forEach(results, function (result, index) {
          return filters[index].loadedAutocompleteCandidates = result;
        });
      });
    }
  }, {
    key: "convertFromStored",
    value: function convertFromStored(storedFilters, availableTypes) {
      var _this2 = this;

      if (storedFilters) {
        return storedFilters.reduce(function (acc, storedFilter) {
          var definition = _this2.getFilter(storedFilter.type);

          if (definition && availableTypes.includes(storedFilter.type)) {
            acc.push(definition.fromStored(storedFilter, definition));
          } else if (storedFilter.type === COMPOSITE_FILTER_TYPE) {
            var type = storedFilter.filters[0].type;
            acc.push({
              type: type,
              operator: 'OR',
              values: storedFilter.filters.map(function (nestedFilter) {
                var nestedDefinition = _this2.getFilter(nestedFilter.type);

                return nestedDefinition.fromStored(nestedFilter, nestedDefinition).values[0];
              })
            });
          }

          return acc;
        }, []);
      }

      return [];
    }
  }, {
    key: "convertToStored",
    value: function convertToStored(uiFilters) {
      var _this3 = this;

      return uiFilters.reduce(function (acc, _ref) {
        var type = _ref.type,
            operator = _ref.operator,
            values = _ref.values;

        var definition = _this3.getFilter(type);

        if (definition && !_.isEmpty(values)) {
          acc.push(definition.toStored({
            type: type,
            operator: operator,
            values: values
          }, definition));
        }

        return acc;
      }, []);
    }
  }, {
    key: "toStoredDefault",
    value: function toStoredDefault(uiFilter, definition) {
      var mapper = function mapper(value) {
        return defineProperty_default()({
          id: ENTITY_ID_PLACEHOLDER,
          type: uiFilter.type
        }, definition.property, value);
      };

      if (uiFilter.values.length === 1) {
        return mapper(uiFilter.values[0].id);
      } else {
        return {
          id: ENTITY_ID_PLACEHOLDER,
          type: COMPOSITE_FILTER_TYPE,
          operator: 'OR',
          filters: uiFilter.values.map(function (v) {
            return mapper(v.id);
          })
        };
      }
    }
  }, {
    key: "fromStoredDefault",
    value: function fromStoredDefault(storedFilter, definition) {
      return {
        type: storedFilter.type,
        operator: 'OR',
        values: [{
          id: storedFilter[definition.property],
          title: this.getFilterTitle(definition.loadedAutocompleteCandidates, storedFilter[definition.property])
        }]
      };
    }
  }, {
    key: "getFilterTitle",
    value: function getFilterTitle(autocompleteCandidates, id) {
      return _.chain(autocompleteCandidates).find({
        id: id
      }).get('title').value();
    }
  }]);

  return CompositeFilterService;
}();

defineProperty_default()(composite_filter_service_CompositeFilterService, "$inject", ['$q']);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/composite-filter/index.js


angular.module('xlrelease').component('compositeFilter', composite_filter_component["a" /* compositeFilterComponent */]);
angular.module('xlrelease').service('CompositeFilterService', composite_filter_service_CompositeFilterService);
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/filter-component/date-range/date-range-component.js + 1 modules
var date_range_component = __webpack_require__(423);

// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/filter-component/date-range/date-range-constants.js
var date_range_constants = __webpack_require__(180);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/date-range-label/date-range-label-component.js




var date_range_label_component_template = "<span class=\"card-filter-item\"><i class=\"xl-icon calendar-icon\"></i>{{$ctrl.rangeText}}</span>";

var date_range_label_component_TileDateRangeLabelController = /*#__PURE__*/function () {
  function TileDateRangeLabelController($dateFilter) {
    classCallCheck_default()(this, TileDateRangeLabelController);

    this.$dateFilter = $dateFilter;
  }

  createClass_default()(TileDateRangeLabelController, [{
    key: "$onInit",
    value: function $onInit() {
      this.rangeText = this.getDateFilterText();
    }
  }, {
    key: "getDateFilterText",
    value: function getDateFilterText() {
      if (this.timeFrame === 'RANGE') {
        if (this.from && this.to) {
          return "Range ".concat(this.formatDate(this.from), " - ").concat(this.formatDate(this.to));
        } else if (this.from && !this.to) {
          return "After ".concat(this.formatDate(this.from));
        } else if (!this.from && this.to) {
          return "Before ".concat(this.formatDate(this.to));
        } else {
          return "Any time";
        }
      } else {
        return date_range_constants["a" /* TIME_FRAME_LABELS */][this.timeFrame];
      }
    }
  }, {
    key: "formatDate",
    value: function formatDate(date) {
      return this.$dateFilter(date, 'short');
    }
  }]);

  return TileDateRangeLabelController;
}();

defineProperty_default()(date_range_label_component_TileDateRangeLabelController, "$inject", ['dateFilter']);

var tileDateRangeLabel = {
  bindings: {
    timeFrame: '<',
    from: '<',
    to: '<'
  },
  controller: date_range_label_component_TileDateRangeLabelController,
  template: date_range_label_component_template
};
angular.module('xlrelease').component('xlrDateRangeLabel', tileDateRangeLabel);
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/filter-component/btn-group-filter.less
var btn_group_filter = __webpack_require__(1415);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/button-group-filter-component.js




function button_group_filter_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function button_group_filter_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { button_group_filter_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { button_group_filter_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }


var button_group_filter_component_template = "\n     <div class=\"btn-group-filter btn-group\" data-toggle=\"buttons\">\n        <button type=\"button\" class=\"btn btn-flat\" ng-repeat=\"item in $ctrl.items\"\n            ng-class=\"{'active': item.value}\" ng-style=\"{'width': (100/$ctrl.items.length) + '%' }\"\n            ng-attr-title=\"{{item.tooltip}}\"\n            ng-click=\"$ctrl.update(item.filter)\">\n            <i ng-if=\"item.icon !== null\" class=\"xl-icon\" ng-class=\"item.icon\"/>\n            <span ng-if=\"item.label !== null\" class=\"btn-label\">{{item.label}}</span>\n        </button>\n    </div>\n    ";

var button_group_filter_component_ButtonGroupFilterController = /*#__PURE__*/function () {
  function ButtonGroupFilterController() {
    classCallCheck_default()(this, ButtonGroupFilterController);
  }

  createClass_default()(ButtonGroupFilterController, [{
    key: "$onInit",
    value: function $onInit() {
      this.items = this._getValuesForOptions();
    }
  }, {
    key: "update",
    value: function update(filter) {
      this.items.forEach(function (value) {
        return value.value = value.filter === filter;
      });

      this._updateFilters(this.items);
    }
  }, {
    key: "_updateFilters",
    value: function _updateFilters(items) {
      var filterData = items.reduce(function (result, item) {
        result[item.filter] = item.value;
        return result;
      }, {});
      this.filterCtrl.update(filterData);
    }
  }, {
    key: "_getValuesForOptions",
    value: function _getValuesForOptions() {
      var _this = this;

      var counter = 0;
      var items = this.options.map(function (item) {
        var value = _this.filterCtrl.getValue(item.filter);

        if (value) {
          counter++;
        }

        return button_group_filter_component_objectSpread({}, item, {
          value: value
        });
      });

      if (counter > 1) {
        // reset filter, set first as default
        items.forEach(function (item) {
          return item.value = !_.isUndefined(item.default) && item.default;
        });

        this._updateFilters(items);
      }

      return items;
    }
  }]);

  return ButtonGroupFilterController;
}();

var ButtonGroupFilter = {
  bindings: {
    options: '<'
  },
  controller: button_group_filter_component_ButtonGroupFilterController,
  require: {
    filterCtrl: '^filter'
  },
  template: button_group_filter_component_template
};
angular.module('xlrelease').component('buttonGroupFilter', ButtonGroupFilter);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/folder-filter-component.js



var folder_filter_component_template = "\n    <xl-react-widget-tree-select\n            data=\"$ctrl.allFolders\"\n            on-model-change=\"$ctrl.updateSelectedFolder\"\n            selected-folder-id=\"$ctrl.folderId\">\n    </xl-react-widget-tree-select>\n";

var folder_filter_component_FolderFilterController = /*#__PURE__*/function () {
  function FolderFilterController() {
    var _this = this;

    classCallCheck_default()(this, FolderFilterController);

    defineProperty_default()(this, "updateSelectedFolder", function (folder) {
      _this.filterCtrl.update({
        'folderId': folder.selectedId
      });
    });
  }

  createClass_default()(FolderFilterController, [{
    key: "folderId",
    get: function get() {
      return this.filterCtrl.getValue('folderId');
    }
  }]);

  return FolderFilterController;
}();

var folderFilter = {
  bindings: {
    allFolders: '<?'
  },
  controller: folder_filter_component_FolderFilterController,
  require: {
    filterCtrl: '^filter'
  },
  template: folder_filter_component_template
};
angular.module('xlrelease').component('folderFilter', folderFilter);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/index.js












// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/flag-picker-component/flag-picker-component.js
var flag_picker_component = __webpack_require__(1416);

// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/help-popover/help-popover-component.js
var help_popover_component = __webpack_require__(1417);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/infinite-scroll-component/infinite-scroll-component.js


var infiniteScrollWrapperTemplate = "\n<div>\n    <ng-transclude></ng-transclude>\n</div>\n<div id=\"cisLoader\">\n    <div ng-show=\"vm.showLoaderWhen\">\n        <img src=\"static/9.7.16/styles/img/big-ajax-loader.gif\" alt=\"Loading...\"/>\n    </div>\n</div>\n";

var infinite_scroll_component_InfiniteScrollWrapperController = /*#__PURE__*/function () {
  function InfiniteScrollWrapperController($element, $timeout, $scope) {
    classCallCheck_default()(this, InfiniteScrollWrapperController);

    this._element = $element;
    this._$timeout = $timeout;
    this._$scope = $scope;
  }

  createClass_default()(InfiniteScrollWrapperController, [{
    key: "$onInit",
    value: function $onInit() {
      this.canScroll = false;
      this.scrollableContainer = angular.element(this._element).scrollParent();
      this.scrollableNode = this.scrollableContainer[0];
      this.delay = 300; // milliseconds

      this.bottomDistance = 20; // px (how far from bottom action onShowMore should be triggered)

      this.scrollableContainer.on('scroll', this.throttle(this.doScroll));
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this.scrollableContainer.off('scroll', this.throttle(this.doScroll));

      if (this.timeOutWatcher) {
        this._$timeout.cancel(this.timeOutWatcher);
      }
    }
  }, {
    key: "contentChanged",
    value: function contentChanged() {
      this.scrollableContainer.scrollTop(0);
      this.canScroll = false;
    }
  }, {
    key: "reRenderCompleted",
    value: function reRenderCompleted() {
      var _this = this;

      if (this.canScroll) return;

      if (this.timeOutWatcher) {
        this._$timeout.cancel(this.timeOutWatcher);
      }

      this.timeOutWatcher = this._$timeout(function () {
        if (!_this.disableWhen && !_this.scrollableContainer.hasVerticalScrollBar()) {
          _this.onShowMore();
        } else if (_this.scrollableContainer.hasVerticalScrollBar()) {
          _this.canScroll = true;
        }
      }, 0);
    }
  }, {
    key: "doScroll",
    value: function doScroll() {
      if (!this.disableWhen && this.scrollableNode.scrollTop + this.scrollableNode.clientHeight + this.bottomDistance >= this.scrollableNode.scrollHeight) {
        this.onShowMore();
      }
    }
  }, {
    key: "throttle",
    value: function throttle(fn) {
      var _arguments = arguments,
          _this2 = this;

      var lastExec, now, timer, context, args;

      var execute = function execute() {
        fn.apply(context, args);
        lastExec = now;
      };

      return function () {
        context = _this2;
        args = _arguments;
        now = Date.now();

        if (timer) {
          _this2._$timeout.cancel(timer);

          timer = null;
        }

        if (lastExec) {
          var diff = _this2.delay - (now - lastExec);

          if (diff < 0) {
            execute();
          } else {
            timer = _this2._$timeout(execute, diff);
          }
        } else {
          execute();
        }
      };
    }
  }]);

  return InfiniteScrollWrapperController;
}();

infinite_scroll_component_InfiniteScrollWrapperController.$inject = ['$element', '$timeout', '$scope'];

var InfiniteScrollWrapperDirective = function InfiniteScrollWrapperDirective() {
  return {
    restrict: 'EA',
    controller: infinite_scroll_component_InfiniteScrollWrapperController,
    controllerAs: 'vm',
    template: infiniteScrollWrapperTemplate,
    transclude: true,
    scope: {
      onShowMore: '&',
      disableWhen: '<',
      showLoaderWhen: '<'
    },
    bindToController: true
  };
};

var InfiniteScrollDirective = function InfiniteScrollDirective($parse) {
  return {
    restrict: 'A',
    require: '^xlrInfiniteScrollWrapper',
    compile: function compile(element, attrs) {
      var registered = false;
      return function (scope, element, attrs, ctrl) {
        if (!registered) {
          scope.$on("$destroy", function () {
            registered = false;
            ctrl.contentChanged();
          });
          registered = true;
        }

        if (scope.$last === true) {
          ctrl.reRenderCompleted();
        }
      };
    }
  };
};

angular.module('xlrelease').directive('xlrInfiniteScrollWrapper', InfiniteScrollWrapperDirective).directive('xlrInfiniteScroll', InfiniteScrollDirective);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/move-template-permissions-modal-component/move-template-permissions-modal-component.js


var move_template_permissions_modal_component_template = "\n        <div class=\"modal-content\">\n            <form name=\"permissionsModalForm\">\n              <div class=\"modal-header\">\n                <h4>Move template to</h4>\n              </div>\n              <div class=\"modal-body move-template-permissions\">\n                <p>\n                  The <strong>{{$ctrl.resolve.template.title}}</strong> template may have different teams and permissions from <strong>{{$ctrl.resolve.selectedFolder.title}}</strong>\n                </p>\n                <p ng-if=\"$ctrl.inherited\">\n                    The <strong>{{$ctrl.resolve.selectedFolder.title}}</strong> folder takes its permissions from <strong>{{$ctrl.inheritedFromTitle}}</strong>\n                </p>\n                <div class=\"options-padding\">\n                    <p class=\"merge-action\">\n                      <label ng-class=\"{'grey-out': !$ctrl.isMergeEnabled}\">\n                        <input ng-disabled=\"!$ctrl.isMergeEnabled\" type=\"radio\" ng-model=\"$ctrl.mergeSelected\" value=\"merge\">\n                        <span>\n                            <strong>Add</strong> teams and permissions from <strong>{{$ctrl.resolve.template.title}}</strong> into the <strong>{{$ctrl.inheritedFromTitle}}</strong> folder.\n                        </span>\n                      </label>\n                        <p ng-if=\"!$ctrl.isRootTemplate\" class=\"info-message\">This option is not available when moving a template from another folder</p>\n                        <p ng-if=\"$ctrl.isRootTemplate && !$ctrl.hasFolderSecurityPermission\" class=\"info-message\">This option is not available because you do not have <strong>Edit Security</strong> permission on <strong>{{$ctrl.resolve.selectedFolder.title}}</strong></p>\n                    </p>\n                    <p class=\"replace-action\">\n                        <label>\n                            <input type=\"radio\" ng-model=\"$ctrl.mergeSelected\" value=\"replace\" autofocus>\n                            <span>\n                                <strong>Remove</strong> teams and permissions of <strong>{{$ctrl.resolve.template.title}}</strong> and inherit them from the <strong>{{$ctrl.inheritedFromTitle}}</strong> folder.\n                            </span>\n                        </label>\n                    </p>\n                </div>\n              </div>\n              <div class=\"modal-footer\">\n                  <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n                  <button class=\"button continue primary\" type=\"submit\" ng-click=\"$ctrl.close({$value: $ctrl.mergeSelected})\">Move</button>\n              </div>\n          </form>\n        </div>\n    ";

var move_template_permissions_modal_component_MoveTemplatePermissionsCtrl = /*#__PURE__*/function () {
  function MoveTemplatePermissionsCtrl(Ids, Authenticator, FolderPermissionsService, TeamsService) {
    classCallCheck_default()(this, MoveTemplatePermissionsCtrl);

    this._Ids = Ids;
    this._Security = Authenticator;
    this._FolderPermissionsService = FolderPermissionsService;
    this._TeamsService = TeamsService;
    this.mergeSelected = 'replace';
  }

  createClass_default()(MoveTemplatePermissionsCtrl, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;

      var selectedFolder = this.resolve.selectedFolder;
      var templateId = this.resolve.template.id;
      this.hasFolderSecurityPermission = this._Security.hasPermission('folder#edit_security', selectedFolder.$metadata);
      this.isRootTemplate = this._isRootTemplate(templateId);
      this.isMergeEnabled = this.isRootTemplate && this.hasFolderSecurityPermission;

      var internalId = this._Ids.toInternalId(this.resolve.selectedFolder.id);

      this._TeamsService.getTeams(internalId).then(function (teams) {
        _this._FolderPermissionsService.findPermissionsHolder(teams.data, _this.resolve.selectedFolder.id).then(function (result) {
          _this.inheritedFromTitle = result.inherited ? result.inheritedFrom.title : _this.resolve.selectedFolder.title;
          _this.inherited = result.inherited;
        });
      });
    }
  }, {
    key: "_isRootTemplate",
    value: function _isRootTemplate(templateId) {
      return this._Ids.isRoot(this._Ids.getParentId(this._Ids.toDomainId(templateId)));
    }
  }]);

  return MoveTemplatePermissionsCtrl;
}();

move_template_permissions_modal_component_MoveTemplatePermissionsCtrl.$inject = ['Ids', 'Authenticator', 'FolderPermissionsService', 'TeamsService'];
var MoveTemplatePermissionsComponent = {
  bindings: {
    resolve: '<',
    close: '&',
    dismiss: '&'
  },
  controller: move_template_permissions_modal_component_MoveTemplatePermissionsCtrl,
  template: move_template_permissions_modal_component_template
};
angular.module('xlrelease').component('moveTemplatePermissions', MoveTemplatePermissionsComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/multilevel-dropdown/multilevel-dropdown.component.js






var multilevel_dropdown_component_MultilevelDropdownController = /*#__PURE__*/function () {
  function MultilevelDropdownController($element, $scope, $window) {
    classCallCheck_default()(this, MultilevelDropdownController);

    this._$element = $element;
    this._$window = $window;
    this.id = $scope.$id;
    this.dropup = false;
  }

  createClass_default()(MultilevelDropdownController, [{
    key: "$onInit",
    value: function $onInit() {
      this.appendToEl = this.appendTo && angular.element(document.querySelector(this.appendTo));
      this.isClosed = true;
    }
  }, {
    key: "$onChanges",
    value: function $onChanges(changesObj) {
      if (changesObj.items && changesObj.items.currentValue && this.selectedItemId) {
        var item = getItemById(changesObj.items.currentValue, this.selectedItemId);

        if (item) {
          this.selectedItem = item.text;
        }
      }
    }
  }, {
    key: "$doCheck",
    value: function $doCheck() {
      var $container = getDropdownContainerElement(this.id);

      if ($container.length) {
        this.dropup = this._$element.offset().top + this._$element.height() + $container.height() > this._$window.innerHeight;
      }
    }
  }, {
    key: "hasSubitems",
    value: function hasSubitems(item) {
      return _.has(item, 'items.length');
    }
  }, {
    key: "onClick",
    value: function onClick(_ref) {
      var event = _ref.event,
          item = _ref.item;

      if (event) {
        event.stopPropagation();
      }

      if (item.items) {
        return;
      }

      this.onSelect(item);
      this.selectedItem = item.text;
      this.open = false;
    }
  }, {
    key: "onToggle",
    value: function onToggle(open) {
      this.isClosed = !open;
    }
  }, {
    key: "onToggleClick",
    value: function onToggleClick() {
      var $container = getDropdownContainerElement(this.id);

      if ($container.length && this.dropup) {
        var top = this._$element.offset().top - $container.height() - 6;
        $container[0].style.top = "".concat(top, "px");
      }
    }
  }]);

  return MultilevelDropdownController;
}();

defineProperty_default()(multilevel_dropdown_component_MultilevelDropdownController, "$inject", ['$element', '$scope', '$window']);

var MultilevelDropdownComponent = {
  bindings: {
    appendTo: '@',
    items: '<',
    onSelect: '&',
    selectedItem: '@',
    selectedItemId: '@'
  },
  controller: multilevel_dropdown_component_MultilevelDropdownController,
  templateUrl: 'static/9.7.16/xlr-components/multilevel-dropdown/multilevel-dropdown-partial.html'
};
angular.module('xlrelease').component('xlrMultilevelDropdown', MultilevelDropdownComponent);

function getDropdownContainerElement(id) {
  return angular.element(".xlr-ctx-menu-container[data-id=\"".concat(id, "\"]"));
}

function getItemById(items, itemId) {
  var i = 0;

  while (i < items.length) {
    var item = items[i];

    if (item.id === itemId) {
      return item;
    }

    if (item.items) {
      var res = getItemById(item.items, itemId);
      if (res) return res;
    }

    i++;
  }
}
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/multilevel-dropdown/multilevel-submenu.directive.js
var multilevel_submenu_directive = __webpack_require__(1418);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/multilevel-dropdown/index.js


// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/override-permissions-modal-component/override-permissions-modal-component.js
var override_permissions_modal_component = __webpack_require__(1419);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/permission-table-component/permission-table-component.js


var permission_table_component_template = "\n    <div class=\"permissions-table-v2\">\n        <table class=\"table table-rounded table-striped permissions-table\">\n            <thead>\n                <tr>\n                    <th ng-repeat=\"column in $ctrl.columns\">\n                        <table-filter title=\"column.title\" key=\"column.key\" on-change=\"$ctrl.onFilterChange(columnKey, newValue)\"></table-filter>\n                    </th>\n                </tr>\n            </thead>\n            <tbody ng-if=\"$ctrl.permissions\">\n                <tr ng-repeat=\"entry in $ctrl.permissions | filter:$ctrl.filters:$ctrl.comparator\" \n                    ng-include=\"'static/9.7.16/xlr-components/permission-table-component/permission-table-row-data-partial.html'\"></tr>\n            </tbody>\n            <tbody ng-if=\"$ctrl.groupedPermissions\" ng-repeat=\"permissionGroup in $ctrl.groupedPermissions\">\n                <tr class=\"group-label\">\n                    <td colspan=\"{{$ctrl.columns.length}}\">\n                        <div class=\"text-column\"><i class=\"xl-icon\" ng-class=\"permissionGroup.icon\"></i><strong>{{permissionGroup.label}}</strong></div>\n                    </td>\n                </tr>    \n                <tr class=\"group-permission\" ng-repeat=\"entry in permissionGroup.permissions | filter:$ctrl.filters:$ctrl.comparator\" \n                    ng-include=\"'static/9.7.16/xlr-components/permission-table-component/permission-table-row-data-partial.html'\"></tr>\n            </tbody>\n        </table>\n    </div>\n    ";

var permission_table_component_PermissionTableController = /*#__PURE__*/function () {
  function PermissionTableController(MemberType) {
    classCallCheck_default()(this, PermissionTableController);

    this._MemberType = MemberType;
    this._filters = {};
  }

  createClass_default()(PermissionTableController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;

      this.getFullName = function (obj) {
        if (obj.type === _this._MemberType.PRINCIPAL) {
          return "".concat(obj.name, " ").concat(obj.fullName);
        } else {
          return obj.name;
        }
      };

      this.comparator = function (actual, expected) {
        var name = angular.isString(actual) ? actual : _this.getFullName(actual);
        return name.toLowerCase().includes(expected.toLowerCase());
      };
    }
  }, {
    key: "updateData",
    value: function updateData(tags) {
      this.onUpdate({
        tags: tags
      });
    }
  }, {
    key: "onFilterChange",
    value: function onFilterChange(columnKey, newValue) {
      this._filters[columnKey] = newValue;
    }
  }, {
    key: "isString",
    value: function isString(entryProperty) {
      return angular.isString(entryProperty);
    }
  }, {
    key: "isColumnStrict",
    value: function isColumnStrict(columnType) {
      return columnType === "ROLE";
    }
  }, {
    key: "filters",
    get: function get() {
      return this._filters;
    }
  }, {
    key: "readonly",
    get: function get() {
      return this._readonly;
    },
    set: function set(readonly) {
      this._readonly = readonly;
    }
  }]);

  return PermissionTableController;
}();

permission_table_component_PermissionTableController.$inject = ['MemberType'];
var PermissionTable = {
  bindings: {
    columns: '<',
    permissions: '<',
    groupedPermissions: '<',
    onUpdate: '&',
    onRemove: '&',
    onAction: '&',
    readOnly: '<',
    showActions: '<',
    strict: '<'
  },
  controller: permission_table_component_PermissionTableController,
  template: permission_table_component_template
};
angular.module('xlrelease').component('permissionTableV2', PermissionTable);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/permission-table-component/permission-table-utils.js



var permission_table_utils_PermissionTableUtils = /*#__PURE__*/function () {
  function PermissionTableUtils(TeamsService, MemberType) {
    classCallCheck_default()(this, PermissionTableUtils);

    this._TeamsService = TeamsService;
    this._MemberType = MemberType;
  }

  createClass_default()(PermissionTableUtils, [{
    key: "teamPermissionsToContainer",
    value: function teamPermissionsToContainer(team) {
      var _this = this;

      return {
        teamName: team.teamName,
        globalRoles: team.members.filter(function (t) {
          return t.type === _this._MemberType.ROLE;
        }),
        users: team.members.filter(function (t) {
          return t.type === _this._MemberType.PRINCIPAL;
        }),
        removable: !this._TeamsService.isSystemTeam(team)
      };
    }
  }]);

  return PermissionTableUtils;
}();

permission_table_utils_PermissionTableUtils.$inject = ['TeamsService', 'MemberType'];
angular.module('xlrelease').service('permissionTableUtils', permission_table_utils_PermissionTableUtils);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/permission-table-component/index.js


// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/release-properties-component/release-properties-component.js



var release_properties_component_ReleasePropertiesController = /*#__PURE__*/function () {
  function ReleasePropertiesController($location, $window, Authenticator, Backend, ReleasesService) {
    classCallCheck_default()(this, ReleasePropertiesController);

    this._$location = $location;
    this._$window = $window;
    this._Authenticator = Authenticator;
    this._Backend = Backend;
    this._ReleasesService = ReleasesService;
  }

  createClass_default()(ReleasePropertiesController, [{
    key: "canEditRelease",
    value: function canEditRelease() {
      return this._ReleasesService.isNewRelease(this.release) || !this._ReleasesService.isReleaseCompleted(this.release) && this._Authenticator.hasEditPermission(this.release);
    }
  }, {
    key: "onSave",
    value: function onSave(release) {
      var _this = this;

      var _release = {
        title: release.title,
        description: release.description,
        owner: release.owner,
        scheduledStartDate: release.scheduledStartDate,
        autoStart: release.autoStart,
        dueDate: release.dueDate,
        plannedDuration: release.plannedDuration,
        tags: release.tags,
        flag: release.flag,
        calendarPublished: release.calendarPublished,
        abortOnFailure: release.abortOnFailure,
        allowPasswordsInAllFields: release.allowPasswordsInAllFields,
        scriptUsername: release.scriptUsername,
        scriptUserPassword: release.scriptUserPassword,
        variables: release.variables,
        attachments: release.attachments,
        parentId: release.parentId,
        syntheticProperties: release.syntheticProperties
      };
      var completionPromise;

      if (this._ReleasesService.isNewRelease(this.release)) {
        _release.templateId = release.templateId;
        var fallback = _release.templateId ? '/templates' : '/releases';
        completionPromise = this._Backend.post('releases', _release).then(function (createReleaseResponse) {
          var createdRelease = createReleaseResponse.data;

          _this._$location.url("/releases/".concat(createdRelease.id, "?fallback=").concat(fallback));
        });
      } else {
        completionPromise = this._Backend.put("releases/".concat(release.id), _release).then(function (_ref) {
          var data = _ref.data;
          _this.release = _.assign({}, _this.release, _release, {
            syntheticProperties: data.syntheticProperties
          });
        });
      }

      return completionPromise;
    }
  }, {
    key: "onCancel",
    value: function onCancel() {
      this._$window.history.back();
    }
  }]);

  return ReleasePropertiesController;
}();

release_properties_component_ReleasePropertiesController.$inject = ['$location', '$window', 'Authenticator', 'Backend', 'ReleasesService'];
var ReleasePropertiesComponent = {
  bindings: {
    release: '<'
  },
  controller: release_properties_component_ReleasePropertiesController,
  templateUrl: 'static/9.7.16/xlr-components/release-properties-component/release-properties-partial.html'
};
angular.module('xlrelease').component('releaseProperties', ReleasePropertiesComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/release-properties-container-component/release-properties-container-component.js


var release_properties_container_component_template = "\n    <div>\n        <!-- this is the same for templates and releases... -->\n        <div ng-if=\"!$ctrl.isNewRelease()\" release-header>\n            <div class=\"buttons\">\n                <a ng-if=\"showNewReleaseButton()\" class=\"new-release button primary\" ng-href=\"#/releases/create?fromTemplateId={{ release.id }}\">New release</a>             \n                <span doc-icon=\"release-properties.html\"></span>\n            </div>\n        </div>\n        <!-- this is the variable part... -->\n        <div class=\"header\" ng-if=\"$ctrl.isNewRelease()\" ng-transclude=\"header\"></div>\n        <div class=\"content-under-header form-content\" ng-class=\"{'new-release': $ctrl.isNewRelease()}\" ng-transclude=\"content\"></div>\n    </div>\n    ";

var release_properties_container_component_ReleasePropertiesContainerController = /*#__PURE__*/function () {
  function ReleasePropertiesContainerController(Page, ReleasesService) {
    classCallCheck_default()(this, ReleasePropertiesContainerController);

    this._Page = Page;
    this._ReleasesService = ReleasesService;
  }

  createClass_default()(ReleasePropertiesContainerController, [{
    key: "$onInit",
    value: function $onInit() {
      if (!this.isNewRelease()) {
        this.setupHeader();
      }
    }
  }, {
    key: "$onChanges",
    value: function $onChanges(changes) {
      if (!this.isNewRelease() && changes.release) {
        this.setupHeader();
      }
    }
  }, {
    key: "setupHeader",
    value: function setupHeader() {
      this._Page.setReleaseOpened(this.release);
    }
  }, {
    key: "isNewRelease",
    value: function isNewRelease() {
      return this._ReleasesService.isNewRelease(this.release);
    }
  }]);

  return ReleasePropertiesContainerController;
}();

release_properties_container_component_ReleasePropertiesContainerController.$inject = ['Page', 'ReleasesService'];
var ReleasePropertiesContainerComponent = {
  bindings: {
    release: '<'
  },
  controller: release_properties_container_component_ReleasePropertiesContainerController,
  template: release_properties_container_component_template,
  transclude: {
    'header': 'header',
    'content': 'content'
  }
};
angular.module('xlrelease').component('releasePropertiesContainer', ReleasePropertiesContainerComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/release-properties-form-component/release-properties-form-component.js



var release_properties_form_component_DEFAULT_RISK_PROFILE_ID = 'Configuration/riskProfiles/RiskProfileDefault';
var NO_OP_SCM_CONNECTOR = 'xlrelease.NoScmConnectorConfig';

var release_properties_form_component_ReleasePropertiesFormController = /*#__PURE__*/function () {
  function ReleasePropertiesFormController(Backend, CurrentTimeZone, FlagService, Ids, PlanningDataEditorMixin, ReleasesService, DateService, UsersService, VariablesService, TemplatesService, ConfirmLeaveService, $scope, TagsService, $q, FoldersService) {
    var _this = this;

    classCallCheck_default()(this, ReleasePropertiesFormController);

    defineProperty_default()(this, "loadTemplates", function (matchTitle) {
      if (_this.isRelease()) {
        return _this._TemplatesService.getAllIds(matchTitle).then(function (response) {
          _this.templates = _.sortBy(response.data.cis, 'title');
        });
      } else {
        return _this._$q.resolve();
      }
    });

    defineProperty_default()(this, "loadRiskProfiles", function () {
      return _this._Backend.get('api/v1/risks/profiles');
    });

    defineProperty_default()(this, "updateSelectedFolder", function (folder) {
      _this.releaseForm.parentId = folder.selectedId;

      _this.$scope.$digest();
    });

    this.$scope = $scope;
    this._$q = $q;
    this._Backend = Backend;
    this._CurrentTimeZone = CurrentTimeZone;
    this._FlagService = FlagService;
    this._Ids = Ids;
    this._ReleasesService = ReleasesService;
    this._DateService = DateService;
    this._TemplatesService = TemplatesService;
    this._UsersService = UsersService;
    this._VariablesService = VariablesService;
    this._ConfirmLeaveService = ConfirmLeaveService;
    this._TagsService = TagsService;
    this._FoldersService = FoldersService;
    angular.extend(this, PlanningDataEditorMixin.withSaveCallback(_.noop)); // this really sucks... [oh, yeah...]

    this.lastUpdatedAt = null;
    this.variablesFilter = {
      showOnReleaseStart: true
    };
    this.allUsers = [];
    this.templates = [];
    this.riskProfiles = [];
    this.allTags = [];
    this._folders = [];
    this.foldersReady = false;
    this.templateTitle = undefined;
    this.ICS_ENDPOINT = 'calendar/subscribe/';
    this._selectedRiskProfile = undefined;
    this.updateFormWithTemplate = this.updateFormWithTemplate.bind(this);
    this.updateRiskProfile = this.updateRiskProfile.bind(this);
    this.onTemplateSelected = this.onTemplateSelected.bind(this);
  }

  createClass_default()(ReleasePropertiesFormController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      this.releaseForm = angular.copy(this.release);

      this._FoldersService.list().then(function (result) {
        _this2._folders = result.data;
        _this2._enabledFolders = {};

        _this2._populateEnabledFoldersHash(_this2._folders);

        if (_this2.releaseForm.templateId && _this2._Ids.isInFolder(_this2.releaseForm.templateId)) {
          var defaultFolder = _this2._Ids.getParentId(_this2._Ids.toDomainId(_this2.releaseForm.templateId));

          if (_this2._isFolderEnabled(defaultFolder)) {
            _this2.releaseForm.parentId = defaultFolder;
          }
        }

        _this2.foldersReady = true;
      });

      this.planning.initPlanningData(this.releaseForm, this.release); // create copy of release to be used as the form?

      this._UsersService.getAllUsers().then(function (response) {
        _this2.allUsers = response.data;
      });

      this._TagsService.getReleaseTags().then(function (allTags) {
        _this2.allTags = allTags;
      });

      if (this.isRelease() && !this.isNewRelease()) {
        this._initTemplateAndParentReleaseProperties(this.release);

        this._initCalendarURL(this.release);
      }

      this._allVariables = [];
      this.loadVariables(this.release);
      this.loadRiskProfiles().then(function (riskProfilesResponse) {
        _this2.riskProfiles = _.sortBy(riskProfilesResponse.data, ['title']);

        _this2.refreshRiskProfiles();
      });
      this.loadTemplatesAndRiskProfiles();
      this.setTemplateTitle();
      this.templateHandlers = {
        addCandidates: this._addTplCandidates.bind(this)
      };
      this.riskProfileHandlers = {
        addCandidates: this._addRiskProfileCandidates.bind(this)
      };
    }
  }, {
    key: "refreshRiskProfiles",
    value: function refreshRiskProfiles() {
      var _this3 = this;

      this.riskProfiles.forEach(function () {
        var hasValidRiskProfile = function hasValidRiskProfile() {
          var riskProfile = _.get(_this3.releaseForm, ['syntheticProperties', 'riskProfile']);

          return _.some(_this3.riskProfiles, {
            id: riskProfile
          });
        };

        var getTemplateRiskProfileOrDefault = function getTemplateRiskProfileOrDefault() {
          var maybeTemplate = _.find(_this3.templates, {
            id: _this3.releaseForm.templateId
          });

          return _.get(maybeTemplate, ['syntheticProperties', 'riskProfile'], release_properties_form_component_DEFAULT_RISK_PROFILE_ID);
        };

        if (!hasValidRiskProfile()) {
          var riskProfile = _this3.isRelease() ? getTemplateRiskProfileOrDefault() : release_properties_form_component_DEFAULT_RISK_PROFILE_ID;

          _.set(_this3.releaseForm, ['syntheticProperties', 'riskProfile'], riskProfile);
        }

        _this3.releaseFormOrig = angular.copy(_this3.releaseForm);
      });
    }
  }, {
    key: "loadTemplatesAndRiskProfiles",
    value: function loadTemplatesAndRiskProfiles(matchTitle) {
      var _this4 = this;

      this.loadTemplates(matchTitle).then(function () {
        _this4.refreshRiskProfiles();
      });
    }
  }, {
    key: "setTemplateTitle",
    value: function setTemplateTitle() {
      var _this5 = this;

      this.templateTitle = this.templates.find(function (t) {
        return t.id === _this5.releaseForm.templateId;
      });

      if (_.isUndefined(this.templateTitle)) {
        this._fetchTemplateById(this.releaseForm.templateId).then(function (template) {
          _this5.templateTitle = template;
        });
      }
    }
  }, {
    key: "_fetchTemplateById",
    value: function _fetchTemplateById(templateId) {
      if (_.includes(templateId, '-')) {
        //discard the folder id to search the template
        templateId = _.split(templateId, '-')[1];
      }

      return this._TemplatesService.getTemplateTitleById(templateId).then(function (template) {
        return _.head(template.data.cis, {
          id: templateId
        });
      }).catch(function (err) {
        if (err.status === httpCodes.FORBIDDEN) {
          return undefined;
        }
      });
    }
  }, {
    key: "_populateEnabledFoldersHash",
    value: function _populateEnabledFoldersHash(folders) {
      var _this6 = this;

      folders.forEach(function (folder) {
        _this6._enabledFolders[folder.id] = folder.enabled;

        if (_.isArray(folder.children)) {
          _this6._populateEnabledFoldersHash(folder.children);
        }
      });
    }
  }, {
    key: "_isFolderEnabled",
    value: function _isFolderEnabled(folderId) {
      return this._enabledFolders[folderId];
    }
  }, {
    key: "_addTplCandidates",
    value: function _addTplCandidates(_ref) {
      var metadata = _ref.metadata,
          objLabel = _ref.objLabel,
          value = _ref.value;
      return Promise.resolve(this.templates.filter(function (item) {
        return item.title.toLowerCase().includes(value.toLowerCase());
      }));
    }
  }, {
    key: "_addRiskProfileCandidates",
    value: function _addRiskProfileCandidates(_ref2) {
      var metadata = _ref2.metadata,
          objLabel = _ref2.objLabel,
          value = _ref2.value;
      return Promise.resolve(this.riskProfiles.filter(function (item) {
        return item.title.toLowerCase().includes(value.toLowerCase());
      }));
    }
  }, {
    key: "$onChanges",
    value: function $onChanges(changes) {
      if (changes.release) {
        _.assign(this.releaseFormOrig, changes.release.currentValue);

        angular.copy(this.releaseForm, this.releaseFormOrig);
      }
    }
  }, {
    key: "isTemplate",
    value: function isTemplate() {
      return this._ReleasesService.isTemplate(this.release);
    }
  }, {
    key: "isRelease",
    value: function isRelease() {
      //NOTE: Do not use the following:
      //this._ReleasesService.isRelease(this.release);
      return !this.isTemplate(); // Yes this is the correct statement!
    }
  }, {
    key: "isNewRelease",
    value: function isNewRelease() {
      return this._ReleasesService.isNewRelease(this.release);
    }
  }, {
    key: "isReleaseArchived",
    value: function isReleaseArchived() {
      return this._ReleasesService.isReleaseArchived(this.release);
    }
  }, {
    key: "isReleaseStarted",
    value: function isReleaseStarted() {
      return this.release.status ? !this._ReleasesService.isReleasePlanned(this.releaseForm) : false;
    }
  }, {
    key: "hasValidDates",
    value: function hasValidDates() {
      return !!this.releaseForm.scheduledStartDate && !!this.releaseForm.dueDate ? this.releaseForm.scheduledStartDate <= this.releaseForm.dueDate : true;
    }
  }, {
    key: "updateFormWithTemplate",
    value: function updateFormWithTemplate(title, pristine) {
      if (!pristine) {
        this.loadTemplatesAndRiskProfiles(title);

        if (!title) {
          this.updateFormWithoutTemplate();
        }
      }
    }
  }, {
    key: "onTemplateSelected",
    value: function onTemplateSelected(template) {
      var _this7 = this;

      var templateId = template.id;

      this._ReleasesService.getTemplateDuration(templateId).then(function (response) {
        var now = _this7._DateService.getTodayWithTime();

        var due = moment(now).add(response.data / 60, 'minutes');
        _this7.release.dueDate = due;
        _this7.release.scheduledStartDate = now;

        _this7._ReleasesService.getRelease(templateId).then(function (resp) {
          var fromTemplate = resp.data;
          var riskProfileFromTemplate = fromTemplate.syntheticProperties.riskProfile || release_properties_form_component_DEFAULT_RISK_PROFILE_ID; // if no longer found, fall back to default

          if (!_.find(_this7.riskProfiles, {
            id: riskProfileFromTemplate
          })) {
            riskProfileFromTemplate = release_properties_form_component_DEFAULT_RISK_PROFILE_ID;
          }

          var parentId = _this7.releaseForm.parentId;
          _this7.releaseForm = _.assign({}, _this7.release, {
            title: _this7.releaseForm.title,
            templateId: fromTemplate.id,
            syntheticProperties: {
              riskProfile: riskProfileFromTemplate
            },
            description: fromTemplate.description,
            tags: fromTemplate.tags,
            abortOnFailure: fromTemplate.abortOnFailure,
            allowPasswordsInAllFields: fromTemplate.allowPasswordsInAllFields,
            scriptUsername: fromTemplate.scriptUsername,
            scriptUserPassword: fromTemplate.scriptUserPassword,
            variables: [],
            parentId: parentId
          });

          _this7._VariablesService.getReleaseVariables(templateId).then(function (variablesResponse) {
            _this7.releaseForm.variables = variablesResponse.data;
          });
        });
      });
    }
  }, {
    key: "loadVariables",
    value: function loadVariables(release) {
      var _this8 = this;

      this._VariablesService.getAllVariables(release.id).then(function (allVariables) {
        _this8.allVariables = allVariables;
      });
    }
  }, {
    key: "updateFormWithoutTemplate",
    value: function updateFormWithoutTemplate() {
      this.releaseForm = this._ReleasesService.initNewRelease();
      this.releaseForm.syntheticProperties = {
        riskProfile: release_properties_form_component_DEFAULT_RISK_PROFILE_ID
      };
      if (!this.$scope.$$phase) this.$scope.$apply(); // for clear template operation (it doesn't reevaluate scope if called from react context)
    }
  }, {
    key: "resetForm",
    value: function resetForm() {
      this.releaseForm = angular.copy(this.releaseFormOrig);

      this._ConfirmLeaveService.disableConfirmation();
    }
  }, {
    key: "downloadCalendar",
    value: function downloadCalendar() {
      this._ReleasesService.downloadCalendar(this.releaseForm);
    }
  }, {
    key: "deleteAttachment",
    value: function deleteAttachment(attachment) {
      var _this9 = this;

      this._Backend.del("releases/".concat(this.releaseForm.id, "/attachments/").concat(attachment.id)).then(function () {
        _.remove(_this9.releaseForm.attachments, {
          id: attachment.id
        });
      });
    }
  }, {
    key: "onFlagUpdate",
    value: function onFlagUpdate(flag) {
      this.releaseForm.flag.status = flag;

      if (!this._FlagService.isItemFlagged(this.releaseForm)) {
        this.releaseForm.flag.comment = '';
      }
    }
  }, {
    key: "onUpdate",
    value: function onUpdate(releasePropertiesForm) {
      var _this10 = this;

      // Set as read only to prevent multiple clicks (but just for new releases)
      this.readOnly = this.isNewRelease();
      var updatePromise = this.onSave({
        release: this.releaseForm
      });

      if (updatePromise) {
        updatePromise.then(function () {
          _this10.lastUpdatedAt = moment().toDate();

          _this10._ConfirmLeaveService.disableConfirmation();

          releasePropertiesForm.$setPristine();
        }, function () {
          _this10.readOnly = false;
        });
      } else {
        this.readOnly = false;
      }
    }
  }, {
    key: "isTargetFolderEnabled",
    value: function isTargetFolderEnabled() {
      if (this.releaseForm.parentId) {
        return this._isFolderEnabled(this.releaseForm.parentId);
      } else {
        // no folder specified, if template is coming from a folder, then, by default
        // the release will be created in the folder of template, so, check it
        if (this.releaseForm.templateId && this._Ids.isInFolder(this.releaseForm.templateId)) {
          var templateFolder = this._Ids.getParentId(this._Ids.toDomainId(this.releaseForm.templateId));

          return this._isFolderEnabled(templateFolder);
        } else {
          // either no template or template is not in a folder -
          // we hope that user has permissions to create release in root (not a folder)
          return true;
        }
      }
    } // private...

  }, {
    key: "_initTemplateAndParentReleaseProperties",
    value: function _initTemplateAndParentReleaseProperties(release) {
      var startedFromTaskId = release.startedFromTaskId;

      if (startedFromTaskId) {
        this.releaseForm.startedFromReleaseId = this._Ids.releaseIdFrom(startedFromTaskId);
        this.releaseForm.startedFromReleaseTitle = release.startedFromTaskReleaseTitle;
      }

      var templateId = release.originTemplateId;

      if (templateId) {
        this.releaseForm.createdFromTemplateId = templateId;
        this.releaseForm.createdFromTemplateTitle = release.originTemplateTitle;
      }
    }
  }, {
    key: "_initCalendarURL",
    value: function _initCalendarURL(release) {
      var _this11 = this;

      this._Backend.get('server/host').then(function (serverInfoResponse) {
        var host = serverInfoResponse.data.url;

        if (!host.match(/\/$/)) {
          host += '/';
        }

        _this11.calendarUrl = host + _this11.ICS_ENDPOINT + release.calendarLinkToken;
      });
    } // getter/setters...

  }, {
    key: "updateRiskProfile",
    value: function updateRiskProfile(title) {
      if (title) {
        var rp = this.riskProfiles.find(function (profile) {
          return profile.title === title;
        });

        if (rp && rp.id !== this.releaseForm.syntheticProperties.riskProfile) {
          this.releaseForm.syntheticProperties.riskProfile = rp.id;
        }
      }
    } // arrow functions for react2angular

  }, {
    key: "allVariables",
    get: function get() {
      return this._allVariables;
    },
    set: function set(allVariables) {
      this._allVariables = allVariables;
    }
  }, {
    key: "timeZone",
    get: function get() {
      return this._CurrentTimeZone.timeZone;
    }
  }, {
    key: "attachmentUploadUrl",
    get: function get() {
      return "upload/attachment/".concat(this.releaseForm.id);
    }
  }, {
    key: "riskProfileTitleOfThisRelease",
    get: function get() {
      var _this12 = this;

      var maybeProfile = this.riskProfiles.find(function (profile) {
        return profile.id === _this12.releaseForm.syntheticProperties.riskProfile;
      });
      return maybeProfile ? maybeProfile.title : null;
    }
  }, {
    key: "fetchTemplateTitle",
    get: function get() {
      return this.templateTitle ? this.templateTitle.title : null;
    }
  }, {
    key: "selectedRiskProfile",
    get: function get() {
      return this._selectedRiskProfile;
    },
    set: function set(riskProfile) {
      this._selectedRiskProfile = riskProfile;

      var riskProfileId = _.get(riskProfile, 'id');

      _.set(this.releaseForm, ['syntheticProperties', 'riskProfile'], riskProfileId);

      this.$scope.releasePropertiesForm.riskProfile.$setValidity('required', !!riskProfileId);
    }
  }, {
    key: "folders",
    get: function get() {
      return this._folders;
    }
  }]);

  return ReleasePropertiesFormController;
}();

release_properties_form_component_ReleasePropertiesFormController.$inject = ['Backend', 'CurrentTimeZone', 'FlagService', 'Ids', 'PlanningDataEditorMixin', 'ReleasesService', 'DateService', 'UsersService', 'VariablesService', 'TemplatesService', 'ConfirmLeaveService', '$scope', 'TagsService', '$q', 'FoldersService'];
var ReleasePropertiesFormComponent = {
  bindings: {
    release: '<',
    readOnly: '<',
    onSave: '&',
    onCancel: '&'
  },
  controller: release_properties_form_component_ReleasePropertiesFormController,
  templateUrl: 'static/9.7.16/xlr-components/release-properties-form-component/release-properties-form-partial.html'
};
angular.module('xlrelease').component('releasePropertiesForm', ReleasePropertiesFormComponent);
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/settings-popover/settings-popover-component.js
var settings_popover_component = __webpack_require__(1420);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/sub-nav-content/sub-nav-content.js



var MOVE_LEFT = -1;
var MOVE_RIGHT = 1;
var STEP = 300;
var NAV_IN_HEADER_CLASS = 'nav-in-header';
var sub_nav_content_template = "\n    <div class=\"sub-nav-content\" role=\"tablist\" aria-label=\"Sub navigation\">\n        <i class=\"xl-icon chevron-left-icon scroll-arrow-left scroll-icon\" ng-click=\"$ctrl.scrollTo(".concat(MOVE_LEFT, ")\" ng-if=\"$ctrl.hasLeftOverflow()\"></i>\n        <ul class=\"").concat(NAV_IN_HEADER_CLASS, "\" role=\"presentation\">\n           <li ng-repeat=\"item in $ctrl.subMenuItems track by $index\"\n               ng-class=\"{ active: $ctrl.isItemActive(item) }\"\n               \n               class=\"sub-nav-item\"\n               role=\"tab\"\n               aria-selected=\"{{$ctrl.isItemActive(item)}}\">\n               <button ng-click=\"$ctrl.goToRoute(item)\"\n                       ng-class=\"{ active: $ctrl.isItemActive(item) }\"\n                       ng-style=\"{'border-bottom-color': $ctrl.getHoverColor(item)}\"\n                       ><span>{{item.label}}</span>\n               </button>\n           </li>\n        </ul>\n        <i class=\"xl-icon chevron-right-icon scroll-arrow-right scroll-icon\" ng-click=\"$ctrl.scrollTo(").concat(MOVE_RIGHT, ")\"  ng-if=\"$ctrl.hasRightOverflow()\"></i>\n    </div>\n");

var sub_nav_content_SubNavContentCtrl = /*#__PURE__*/function () {
  function SubNavContentCtrl($location, $state, Page, ConfirmLeaveService, $element, $scope, $stateParams) {
    var _this = this;

    classCallCheck_default()(this, SubNavContentCtrl);

    defineProperty_default()(this, "isItemActive", function (item) {
      return _this._Page.isOnPage(item.pathSuffix) || _.some(item.items, function (subItem) {
        return _this.isItemActive(subItem);
      });
    });

    this._$location = $location;
    this._$state = $state;
    this._Page = Page;
    this._ConfirmLeaveService = ConfirmLeaveService;
    this._$element = $element;
    this._navs = this._$element.find(".".concat(NAV_IN_HEADER_CLASS));
    this._$scope = $scope;
    this._$stateParams = $stateParams;
  }

  createClass_default()(SubNavContentCtrl, [{
    key: "scrollTo",
    value: function scrollTo(direction) {
      var $scope = this._$scope;

      this._navs.animate({
        scrollLeft: this._navs.scrollLeft() + direction * STEP
      }, function () {
        $scope.$digest();
      });
    }
  }, {
    key: "hasRightOverflow",
    value: function hasRightOverflow() {
      return this._navs.get(0).scrollWidth - this._navs.get(0).offsetWidth - this._navs.scrollLeft() > 0;
    }
  }, {
    key: "hasLeftOverflow",
    value: function hasLeftOverflow() {
      return this._navs.scrollLeft() > 0;
    }
  }, {
    key: "goToRoute",
    value: function goToRoute(item) {
      var _this2 = this;

      if (!this._ConfirmLeaveService.isConfirmationRequired()) {
        return this._goToRouteInternal(item);
      }

      var promise = this._ConfirmLeaveService.openConfirmationDialog();

      promise.then(function () {
        return _this2._goToRouteInternal(item);
      });
    }
  }, {
    key: "_goToRouteInternal",
    value: function _goToRouteInternal(item) {
      if (this._$location.path() === "/".concat(item.pathSuffix)) {
        // we basically say stay in this state, but just reload while preserving the current location path...
        // if the only goal is to keep the location, only the location flag is needed!
        this._$state.transitionTo(this._$state.current, this._$stateParams, {
          reload: true,
          inherit: false,
          notify: true,
          location: false
        });
      } else {
        this._$location.url("".concat(item.pathSuffix));
      }
    }
  }, {
    key: "getHoverColor",
    value: function getHoverColor(item) {
      return this._Page.theme.headerAccentColor;
    }
  }]);

  return SubNavContentCtrl;
}();

defineProperty_default()(sub_nav_content_SubNavContentCtrl, "$inject", ['$location', '$state', 'Page', 'ConfirmLeaveService', '$element', '$scope', '$stateParams']);

var subNavContent = {
  bindings: {
    item: '<',
    subMenuItems: '<'
  },
  controller: sub_nav_content_SubNavContentCtrl,
  template: sub_nav_content_template
};
angular.module('xlrelease').component('subNavContent', subNavContent);
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/support-accelerator-modal-component/support-accelerator-modal-component.js
var support_accelerator_modal_component = __webpack_require__(1421);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/table-filter-component/table-filter-component.js


var table_filter_component_template = "\n    <div class=\"table-filter\">\n        <h4 class=\"filter-title\">{{$ctrl.title}}</h4>\n        <div class=\"input-group input-group-sm\">\n            <span class=\"input-group-addon\">\n                <i class=\"xl-icon search-icon\"></i>\n            </span>\n            <input type=\"text\" title=\"{{$ctrl.title}}\" class=\"form-control\" ng-model=\"$ctrl.value\">\n        </div>\n    </div>\n    ";

var table_filter_component_TableFilterController = /*#__PURE__*/function () {
  function TableFilterController() {
    classCallCheck_default()(this, TableFilterController);

    this._value = null;
  }

  createClass_default()(TableFilterController, [{
    key: "$onInit",
    value: function $onInit() {
      this.onChange({
        columnKey: this.key,
        newValue: undefined
      });
    }
  }, {
    key: "value",
    get: function get() {
      return this._value;
    },
    set: function set(value) {
      this._value = value;
      this.onChange({
        columnKey: this.key,
        newValue: _.isEmpty(value) ? undefined : value
      });
    }
  }]);

  return TableFilterController;
}();

table_filter_component_TableFilterController.$inject = [];
var TableFilter = {
  bindings: {
    title: '<',
    key: '<',
    onChange: '&'
  },
  controller: table_filter_component_TableFilterController,
  template: table_filter_component_template
};
angular.module('xlrelease').component('tableFilter', TableFilter);
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/template-list-component/xlr-template-list-component.js
var xlr_template_list_component = __webpack_require__(1422);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/template-properties-component/template-properties-component.js



var template_properties_component_TemplatePropertiesController = /*#__PURE__*/function () {
  function TemplatePropertiesController($location, $window, Authenticator, Permissions, ReleasesService, TemplatesService, ConfirmLeaveService) {
    classCallCheck_default()(this, TemplatePropertiesController);

    this._$location = $location;
    this._$window = $window;
    this._Authenticator = Authenticator;
    this._Permissions = Permissions;
    this._ReleasesService = ReleasesService;
    this._TemplatesService = TemplatesService;
    this._ConfirmLeaveService = ConfirmLeaveService;
  }

  createClass_default()(TemplatePropertiesController, [{
    key: "isNewTemplate",
    value: function isNewTemplate() {
      return this._ReleasesService.isNewRelease(this.template);
    }
  }, {
    key: "canEditTemplate",
    value: function canEditTemplate() {
      if (this.isNewTemplate()) {
        return this._Authenticator.hasPermission(this._Permissions.CREATE_TEMPLATE);
      } else if (this.template.security) {
        return this._Authenticator.hasPermission(this._Permissions.EDIT_TEMPLATE, this.template);
      } else {
        return false;
      }
    }
  }, {
    key: "onSave",
    value: function onSave(release, onSaveCallback) {
      var _this = this;

      // do this to prevent flicker of form when updating...
      var template = _.assign({}, release);

      delete template.status;
      delete template.type;
      var completionPromise = null;

      if (this._ReleasesService.isNewRelease(this.template)) {
        var redirectToRelease = function redirectToRelease(templateId) {
          return _this._$location.url("/templates/".concat(templateId));
        };

        var onSuccess = function onSuccess(response) {
          if (onSaveCallback) {
            onSaveCallback(response);
          }

          var templateView = response.data;

          _this._ConfirmLeaveService.disableConfirmation();

          return templateView.id;
        };

        completionPromise = this._TemplatesService.create(template).then(onSuccess).then(redirectToRelease);
      } else {
        completionPromise = this._TemplatesService.update(template.id, template).then(function (response) {
          if (onSaveCallback) {
            onSaveCallback(response);
          }

          _this.template = _.assign({}, _this.template, template);

          _this._ConfirmLeaveService.disableConfirmation();
        });
      }

      return completionPromise;
    }
  }, {
    key: "onCancel",
    value: function onCancel() {
      this._$window.history.back();
    }
  }]);

  return TemplatePropertiesController;
}();

template_properties_component_TemplatePropertiesController.$inject = ['$location', '$window', 'Authenticator', 'Permissions', 'ReleasesService', 'TemplatesService', 'ConfirmLeaveService'];
var TemplatePropertiesComponent = {
  bindings: {
    template: '<' // should be injected via resolve blocks...

  },
  controller: template_properties_component_TemplatePropertiesController,
  templateUrl: 'static/9.7.16/xlr-components/template-properties-component/template-properties-partial.html'
};
angular.module('xlrelease').component('templateProperties', TemplatePropertiesComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/template-row-component/xlr-template-row-component.js



var xlr_template_row_component_XlrTemplateRowComponent = /*#__PURE__*/function () {
  function XlrTemplateRowComponent(Authenticator, $location, ViewStorage, Backend, FoldersService, $uibModal, Ids) {
    classCallCheck_default()(this, XlrTemplateRowComponent);

    this._security = Authenticator;
    this._location = $location;
    this._viewStorage = ViewStorage;
    this._backend = Backend;
    this._foldersService = FoldersService;
    this._$uibModal = $uibModal;
    this._ids = Ids;
  }

  createClass_default()(XlrTemplateRowComponent, [{
    key: "$onInit",
    value: function $onInit() {
      this.copyOfTemplate = this.makeTemplateCopy();
      this.contextMenuItems = [{
        title: 'Meta information',
        modal: 'xlrSCMModal',
        data: {
          title: this.template.title,
          scmId: this.template.$scmTraceabilityDataId
        }
      }];
    }
  }, {
    key: "makeTemplateCopy",
    value: function makeTemplateCopy() {
      var copy = angular.copy(this.template); //check for unit testing

      if (copy && copy.title) {
        //replace (x) with (x+1) on copy template name
        //this won't work if the name contains several (x)
        var regExp = /\(([0-9]+)\)$/;

        if (regExp.test(copy.title)) {
          copy.title = copy.title.replace(regExp, function (s, m1) {
            var nextNumber = parseInt(m1) + 1;
            return "(".concat(nextNumber, ")");
          });
        } else {
          copy.title = copy.title + " (1)";
        }
      }

      return copy;
    }
  }, {
    key: "getTemplateEditorURL",
    value: function getTemplateEditorURL() {
      return "#".concat(this._viewStorage.getView(this.template.id, '/templates/' + this.template.id));
    }
  }, {
    key: "hasPermissionToCreate",
    value: function hasPermissionToCreate() {
      return !this.isInsideFolder() ? this._security.hasPermission('release#create') : this._security.hasPermission('template#create_release', this.template);
    }
  }, {
    key: "hasPermissionToCopy",
    value: function hasPermissionToCopy() {
      return !this.isInsideFolder() ? this._security.hasPermission('template#create') : this._security.hasPermission('template#edit', this.template);
    }
  }, {
    key: "hasPermissionToEdit",
    value: function hasPermissionToEdit() {
      return this._security.hasEditPermission(this.template);
    }
  }, {
    key: "hasPermissionToMove",
    value: function hasPermissionToMove() {
      return this.hasPermissionToEdit();
    }
  }, {
    key: "hasPermissionToDelete",
    value: function hasPermissionToDelete() {
      return this.hasPermissionToEdit();
    }
  }, {
    key: "deleteTemplate",
    value: function deleteTemplate() {
      var _this = this;

      this._backend.del('releases/templates/' + this.template.id).then(function () {
        _this.onDelete();
      });
    }
  }, {
    key: "onFolderSelect",
    value: function onFolderSelect(folder) {
      this._selectedFolder = folder;
      this._canMove = !!this._selectedFolder;
    }
  }, {
    key: "moveTemplate",
    value: function moveTemplate(dismiss) {
      var _this2 = this;

      var modal = this._$uibModal.open({
        animation: false,
        component: 'moveTemplatePermissions',
        resolve: {
          template: this.template,
          selectedFolder: this._selectedFolder
        }
      });

      modal.result.then(function (mergeSelected) {
        _this2._foldersService.moveTemplate(_this2.template.id, _this2._selectedFolder.id, mergeSelected === 'merge').then(function () {
          return _this2.onMove();
        });
      });
      if (dismiss) dismiss();
    }
  }, {
    key: "_convertToTemplateForm",
    value: function _convertToTemplateForm(template) {
      return {
        templateId: template.id,
        title: template.title,
        description: template.description,
        scheduledStartDate: template.scheduledStartDate,
        parentId: this._ids.getParentId(this._ids.toDomainId(template.id, '-'))
      };
    }
  }, {
    key: "copyTemplate",
    value: function copyTemplate(dismiss) {
      var _this3 = this;

      this._backend.post('releases/templates', this._convertToTemplateForm(this.copyOfTemplate)).then(function (resp) {
        _this3._location.url('/templates/' + resp.data.id);

        dismiss();
      });
    }
  }, {
    key: "isInsideFolder",
    value: function isInsideFolder() {
      return this._ids.isInFolder(this.template.id);
    } ///

  }, {
    key: "containsUnclickableRows",
    value: function containsUnclickableRows() {
      return this._foldersService.containsUnclickableRows;
    }
  }, {
    key: "canMove",
    get: function get() {
      return this._canMove;
    }
  }]);

  return XlrTemplateRowComponent;
}();

xlr_template_row_component_XlrTemplateRowComponent.$inject = ['Authenticator', '$location', 'ViewStorage', 'Backend', 'FoldersService', '$uibModal', 'Ids'];
angular.module('xlrelease').component('xlrTemplateRowComponent', {
  bindings: {
    template: '<',
    onDelete: '&',
    onMove: '&',
    responsive: '<?'
  },
  bindToController: true,
  controllerAs: 'vm',
  controller: xlr_template_row_component_XlrTemplateRowComponent,
  templateUrl: 'static/9.7.16/xlr-components/template-row-component/template-row-partial.html'
});
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/template-scm-properties-component/template-scm-properties-component.js






var template_scm_properties_component_TemplateScmPropertiesController = /*#__PURE__*/function () {
  function TemplateScmPropertiesController(MetadataService, Backend, Toastr) {
    var _this = this;

    classCallCheck_default()(this, TemplateScmPropertiesController);

    defineProperty_default()(this, "SCM_CONNECTOR_CONFIG_TYPE", 'xlrelease.ScmConnectorConfig');

    defineProperty_default()(this, "toaster", Object(toastrFactory["a" /* default */])());

    defineProperty_default()(this, "testConnection", function () {
      _this.isBusy = true;

      _this.Backend.post("scm/status", _this.configurationItemForm).then(function (resposne) {
        if (resposne.status === 200 && resposne.data.success === true) {
          _this.Toastr.success("Successfully connected to the SCM.");
        } else {
          _this.Toastr.error(resposne.data.errorText);
        }
      }).finally(function () {
        _this.isBusy = false;
      });
    });

    defineProperty_default()(this, "isSelectedScmOption", function () {
      return !(angular.isUndefined(_this.configurationItemForm.type) || NO_OP_SCM_CONNECTOR === _this.configurationItemForm.type);
    });

    this.MetadataService = MetadataService;
    this.Backend = Backend;
    this.Toastr = Toastr;
    this.ciTypeDescriptor = undefined;
    this.isBusy = false;
    this.scmConnectionStatusMessage = '';
  }

  createClass_default()(TemplateScmPropertiesController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      this.MetadataService.getDescriptor(this.SCM_CONNECTOR_CONFIG_TYPE).then(function (ci) {
        _this2.ciTypeDescriptor = ci;
      });
    }
  }]);

  return TemplateScmPropertiesController;
}();

template_scm_properties_component_TemplateScmPropertiesController.$inject = ['MetadataService', 'Backend', 'Toastr'];
var TemplateScmPropertiesComponent = {
  bindings: {
    readonly: '<',
    configurationItemForm: '=',
    reinitializeFormTrigger: '<'
  },
  require: {
    formCtrl: '^form'
  },
  controller: template_scm_properties_component_TemplateScmPropertiesController,
  templateUrl: 'static/9.7.16/xlr-components/template-scm-properties-component/template-scm-properties-partial.html'
};
angular.module('xlrelease').component('templateScmPropertiesComponent', TemplateScmPropertiesComponent);
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/add-variable-component/add-variable-component.less
var add_variable_component = __webpack_require__(1423);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/add-variable-component/add-variable-component.js





var add_variable_component_template = "\n<div class=\"add-variable\">\n    <div data-ng-if=\"$ctrl.inProgress\">\n        <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\">Variable name <span class=\"error\">*</span></label>\n            <div class=\"col-sm-9\">\n                 <input type=\"text\" name=\"variableName\" data-ng-model=\"$ctrl.addVariableForm.variableName\" placeholder=\"Variable name\" autocomplete=\"off\">\n                 <div data-ng-if=\"$ctrl.isVariableAlreadyExist()\" class=\"error\">The variable with key='{{$ctrl.addVariableForm.variableName}}' is already defined.</div>\n            </div>\n        </div>\n        <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\">Variable type <span class=\"error\">*</span></label>\n            <div class=\"col-sm-9\">\n                <select class=\"input-block-level\" \n                    data-ng-model=\"$ctrl.addVariableForm.variableType\"\n                    data-ng-options=\"type as type.label for type in $ctrl.variableTypes track by type.id\">\n                </select>  \n            </div>\n        </div>\n    </div>\n    <div class=\"actions\">\n        <button \n            class=\"button\"\n            data-ng-if=\"!$ctrl.inProgress\"\n            data-ng-click=\"$ctrl.inProgress = true;\">Add Variable</button>\n        <div data-ng-if=\"$ctrl.inProgress\">\n            <button data-ng-click=\"$ctrl.addVariable()\" data-ng-disabled=\"$ctrl.isInvalid()\" class=\"button primary\">Add</button>\n            <button data-ng-click=\"$ctrl.cancel()\" class=\"button\">Cancel</button>\n        </div>\n    </div>\n</div>\n";

var add_variable_component_AddVariableController = /*#__PURE__*/function () {
  function AddVariableController(VariablesService) {
    classCallCheck_default()(this, AddVariableController);

    this.VariablesService = VariablesService;
    this.inProgress = false;
    this.variables = [];
    this.addVariableForm = {};
  }

  createClass_default()(AddVariableController, [{
    key: "$onInit",
    value: function $onInit() {
      this.variableTypes = this.VariablesService.getVariableTypeList();
    }
  }, {
    key: "addVariable",
    value: function addVariable() {
      if (this.isInvalid()) return;
      this.variables.push({
        id: '',
        key: this.addVariableForm.variableName,
        requiresValue: true,
        showOnReleaseStart: true,
        type: this.addVariableForm.variableType.key
      });
      this.onAddVariable();
      this.addVariableForm = {};
      this.inProgress = false;
    }
  }, {
    key: "isInvalid",
    value: function isInvalid() {
      return angular_default.a.isUndefined(this.addVariableForm.variableName) || this.addVariableForm.variableName === '' || this.isVariableAlreadyExist() || angular_default.a.isUndefined(this.addVariableForm.variableType);
    }
  }, {
    key: "isVariableAlreadyExist",
    value: function isVariableAlreadyExist() {
      var _this = this;

      return angular_default.a.isDefined(this.variables.find(function (variable) {
        return variable.key === _this.addVariableForm.variableName;
      }));
    }
  }, {
    key: "cancel",
    value: function cancel() {
      this.addVariableForm = {};
      this.inProgress = false;
    }
  }]);

  return AddVariableController;
}();

defineProperty_default()(add_variable_component_AddVariableController, "$inject", ['VariablesService']);

var AddVariableComponent = {
  bindings: {
    allVariables: '<',
    variables: '<',
    onAddVariable: '&?'
  },
  controller: add_variable_component_AddVariableController,
  template: add_variable_component_template
};
angular_default.a.module('xlrelease').component('addVariable', AddVariableComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/type-select-tree-component/type-select-tree-component.js





var type_select_tree_component_template = "<div class=\"type-select-tree-component\">\n    <select-tree-component\n            ng-if=\"$ctrl.typeTree !== undefined\"\n            data=\"$ctrl.typeTree\"\n            on-model-change=\"$ctrl.onModelChangeWrapper\"\n            selected-item-id=\"$ctrl.selectedType\" />\n</div>";

var type_select_tree_component_TypeSelectTreeComponentController = /*#__PURE__*/function () {
  function TypeSelectTreeComponentController($scope, Backend) {
    var _this = this;

    classCallCheck_default()(this, TypeSelectTreeComponentController);

    defineProperty_default()(this, "loadTreeDebounced", _.debounce(function () {
      _this.typeTree = undefined;

      _this.Backend.get("metadata/types-hierarchy?focusType=".concat(_this.focusType, "&topType=").concat(_this.topType)).then(function (response) {
        _this.typeTree = [_this.mapTypeHierarchyToView(response.data)];
      });
    }, global_constants["b" /* debounceTime */]));

    defineProperty_default()(this, "mapTypeHierarchyToView", function (parent) {
      return {
        id: parent.typeName,
        title: parent.label,
        enabled: !!_this.canSelectVirtualType ? true : !parent.virtual,
        children: parent.subtypes.map(function (it) {
          return _this.mapTypeHierarchyToView(it);
        })
      };
    });

    defineProperty_default()(this, "onModelChangeWrapper", function (value) {
      _this.$scope.$apply(function () {
        _this.setValidity(!_.isUndefined(value.selectedId));

        _this.onTypeChange()(value);
      });
    });

    defineProperty_default()(this, "setValidity", function (isValid) {
      if (_this.required) {
        _this.model.$setValidity('required', isValid);
      }
    });

    this.$scope = $scope;
    this.Backend = Backend;
  }

  createClass_default()(TypeSelectTreeComponentController, [{
    key: "$onChanges",
    value: function $onChanges(change) {
      if (change.focusType || change.topType) {
        this.loadTreeDebounced();
      }
    }
  }]);

  return TypeSelectTreeComponentController;
}();

defineProperty_default()(type_select_tree_component_TypeSelectTreeComponentController, "$inject", ['$scope', 'Backend']);

var typeSelectTreeComponent = {
  bindings: {
    canSelectVirtualType: '<',
    focusType: '<',
    onTypeChange: '&',
    selectedType: '<',
    topType: '<',
    required: '<'
  },
  bindToController: true,
  controller: type_select_tree_component_TypeSelectTreeComponentController,
  controllerAs: '$ctrl',
  require: {
    model: 'ngModel'
  },
  template: type_select_tree_component_template
};
angular_default.a.module('xlrelease').component('typeSelectTreeComponent', typeSelectTreeComponent);
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/trigger-variable-component/const/index.js
var trigger_variable_component_const = __webpack_require__(71);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/trigger-variable-component/property-mapping.service.js





var updateAcc = function updateAcc(acc, kind, value) {
  var includePassword = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

  if (includePassword && kind === 'STRING') {
    (acc.PASSWORD || (acc.PASSWORD = [])).push(value);
  }

  (acc[kind] || (acc[kind] = [])).push(value);
};

var property_mapping_service_propertyMappingService = function propertyMappingService(MetadataService, VariablesService) {
  var flatterWebhookCI = function flatterWebhookCI(ciType) {
    if (isUntypedEvent(ciType)) {
      return [];
    }

    var isCI = function isCI(pd) {
      return pd.kind === 'CI';
    };

    var mapProperties = function mapProperties(pd, prefix) {
      var path = "".concat(!_.isUndefined(prefix) ? "".concat(prefix, ".") : '').concat(pd.name);
      return {
        autocompleteType: trigger_variable_component_const["a" /* AUTOCOMPLETE_ACTION_TYPE */].SELECT_WEBHOOK,
        kind: pd.kind,
        label: pd.label,
        mappingType: trigger_variable_component_const["c" /* MAPPING_TYPES */].PROPERTY_VALUE,
        path: path,
        description: path
      };
    };

    var resolveNestedCIs = function resolveNestedCIs(prefix, propertyDescriptor) {
      return MetadataService.getDescriptor(propertyDescriptor.referencedType).then(function (descriptor) {
        var _$partition = _.partition(descriptor.properties, function (pd) {
          return isCI(pd);
        }),
            _$partition2 = slicedToArray_default()(_$partition, 2),
            cis = _$partition2[0],
            properties = _$partition2[1];

        var nestedCIs = cis.filter(_.matches({
          asContainment: false
        })).map(function (pd) {
          return resolveNestedCIs("".concat(prefix, ".").concat(pd.name), pd);
        });
        return _.concat(properties.map(function (pd) {
          return mapProperties(pd, prefix);
        }), nestedCIs);
      });
    };

    var resolveNestedPromises = function resolveNestedPromises(promises) {
      var flattenPromises = _.flattenDeep(promises);

      if (flattenPromises.find(function (p) {
        return _.isFunction(p.then);
      })) {
        return Promise.all(flattenPromises).then(function (result) {
          return resolveNestedPromises(result);
        });
      }

      return Promise.all(flattenPromises);
    };

    if (_.isEmpty(ciType)) return Promise.resolve({});
    return MetadataService.getDescriptor(ciType, true).then(function (descriptor) {
      var _$partition3 = _.partition(descriptor.properties, function (pd) {
        return isCI(pd);
      }),
          _$partition4 = slicedToArray_default()(_$partition3, 2),
          cis = _$partition4[0],
          properties = _$partition4[1];

      var nestedCis = cis.map(function (pd) {
        return resolveNestedCIs(pd.name, pd);
      });

      var result = _.concat(properties.map(function (pd) {
        return mapProperties(pd);
      }), nestedCis);

      return resolveNestedPromises(result).then(function (result) {
        return _.reduce(result, function (acc, pd) {
          updateAcc(acc, pd.kind, pd, true);
          return acc;
        }, {});
      });
    }).catch(function () {
      return {};
    });
  };

  var getGlobalAndFolderVariables = function getGlobalAndFolderVariables(folderId) {
    var variableList = !_.isEmpty(folderId) ? [VariablesService.listFolderOnlyVariables(folderId)] : [];
    variableList.push(VariablesService.getGlobalVariables());
    return Promise.all(variableList).then(function (results) {
      return _(results).map('data').flatten().map(function (variable) {
        return _.chain(variable).cloneDeep().assignIn({
          autocompleteType: trigger_variable_component_const["a" /* AUTOCOMPLETE_ACTION_TYPE */].SELECT_VARIABLE,
          label: VariablesService.getKey(variable),
          mappingType: trigger_variable_component_const["c" /* MAPPING_TYPES */].VARIABLE_VALUE,
          path: VariablesService.withoutVariableSyntax(variable.key)
        }).value();
      }).reduce(function (acc, variable) {
        var key = trigger_variable_component_const["e" /* VARIABLE_TYPE_TO_PROPERTY_KIND */][variable.type];
        updateAcc(acc, key, variable);
        return acc;
      }, {});
    });
  };

  var getCIPropertiesAndVariables = function getCIPropertiesAndVariables(webhookOutputEventType, folderId) {
    return Promise.all([flatterWebhookCI(webhookOutputEventType), getGlobalAndFolderVariables(folderId)]).then(function (result) {
      var _result = slicedToArray_default()(result, 2),
          webhooks = _result[0],
          variables = _result[1];

      return _.mergeWith(webhooks, variables, function (webhook, variable) {
        return [].concat(toConsumableArray_default()(webhook || []), toConsumableArray_default()(variable || []));
      });
    });
  };

  var getReferencedEventVariables = function getReferencedEventVariables(mappedProperties) {
    return _(mappedProperties).map(function (property) {
      return collectEventVariables(_.get(property, 'variableKey', _.get(property, 'value', '')));
    }).flatten().map(function (variableKey) {
      return {
        autocompleteType: trigger_variable_component_const["a" /* AUTOCOMPLETE_ACTION_TYPE */].SELECT_VARIABLE,
        label: VariablesService.withVariableSyntax(variableKey),
        mappingType: trigger_variable_component_const["c" /* MAPPING_TYPES */].VARIABLE_VALUE,
        path: VariablesService.withoutVariableSyntax(variableKey)
      };
    }).uniqBy('path').orderBy('path').value();
  };

  var isUntypedEvent = function isUntypedEvent(webhookOutputEventType) {
    return webhookOutputEventType === 'events.HttpRequestEvent';
  };

  var isEventVariable = function isEventVariable(value) {
    return _.isString(value) && trigger_variable_component_const["d" /* ONLY_EVENT_VARIABLE_REGEX */].test(value);
  };

  var collectEventVariables = function collectEventVariables(value) {
    return _.isString(value) ? [].concat(toConsumableArray_default()(value.match(trigger_variable_component_const["d" /* ONLY_EVENT_VARIABLE_REGEX */]) || []), toConsumableArray_default()(value.match(trigger_variable_component_const["b" /* CONTAINS_EVENT_VARIABLE_REGEX */]) || [])) : [];
  };

  return {
    getCIPropertiesAndVariables: getCIPropertiesAndVariables,
    getReferencedEventVariables: getReferencedEventVariables,
    isUntypedEvent: isUntypedEvent,
    isEventVariable: isEventVariable
  };
};

property_mapping_service_propertyMappingService.$inject = ['MetadataService', 'VariablesService'];
angular_default.a.module('xlrelease').service('propertyMappingService', property_mapping_service_propertyMappingService);
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/trigger-variable-component/property-mapping/property-mapping.component.less
var property_mapping_component = __webpack_require__(1424);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/trigger-variable-component/property-mapping/property-mapping.component.js








var property_mapping_component_template = "<div class=\"property-mapping-component\" ng-if=\"$ctrl.isInitialized\">\n    <button class=\"button property-mapping-component--switch-button\" type=\"button\"\n            id=\"{{$ctrl.fieldId}}\"\n            ng-click=\"$ctrl.setToggle(!$ctrl.isToggled)\"\n            ng-attr-uib-tooltip=\"{{$ctrl.isToggled ? 'Switch to manual entry' : 'Switch to variable or incoming property value'}}\"\n            ng-attr-tooltip-placement=\"bottom\"\n            ng-class=\"{'primary': $ctrl.isToggled}\"><i class='xl-icon list-add-icon'/></button>\n    <div ng-if=\"$ctrl.isToggled\" class=\"property-mapping-component--input\">\n        <xl-react-widget-autocomplete\n            id=\"auto-complete\"\n            disable-sorting=\"true\"\n            handlers=\"$ctrl.options.handlers\"\n            model=\"$ctrl.internalModel\"\n            obj-label=\"$ctrl.options.label\"\n            on-model-change=\"$ctrl.onModelChange\"\n            on-suggestion-selected=\"$ctrl.onSuggestionSelected\"\n            suggestion-behavior=\"$ctrl.suggestionBehavior\"\n            ng-keypress=\"$ctrl.handleEnterPress($event)\">\n        </xl-react-widget-autocomplete>\n    </div>\n    <ng-transclude ng-if=\"!$ctrl.isToggled\" class=\"property-mapping-component--input\"></ng-transclude>\n</div>";

var property_mapping_component_PropertyMappingController = /*#__PURE__*/function () {
  function PropertyMappingController($scope, $timeout) {
    var _this = this;

    classCallCheck_default()(this, PropertyMappingController);

    defineProperty_default()(this, "setToggle", function (value) {
      _this.isToggled = value;

      if (_this.isToggled && _.isPlainObject(_this.internalModel)) {
        _this.onSuggestionSelected(_this.internalModel);
      }

      _this.model.$setViewValue(undefined);

      _.defaultTo(_.invoke(_this, 'onToggle'), _.noop)(_this.isToggled);
    });

    defineProperty_default()(this, "onSuggestionSelected", function (value) {
      if (_.isPlainObject(value)) {
        _this.internalModel = value;

        _this.$scope.$evalAsync(function () {
          _this.model.$setViewValue(value.path);

          _this.setValidity(true);

          var result = _.assign(value, {
            targetName: _this.model.$name
          });

          _.get(_this, ['options', 'onSuggestionSelected'], _.noop)(result);
        });
      }
    });

    defineProperty_default()(this, "onModelChange", function (value) {
      if (_.isEmpty(value)) {
        _this.$scope.$evalAsync(function () {
          _this.model.$setViewValue(undefined);

          _this.setValidity(false);

          var result = {
            targetName: _this.model.$name,
            mappingType: value.mappingType,
            value: undefined
          };

          _.get(_this, ['options', 'onSuggestionSelected'], _.noop)(result);
        });
      }
    });

    defineProperty_default()(this, "setValidity", function (isRequired) {
      if (_this.ngRequired) {
        _this.model.$setValidity('required', isRequired);
      }
    });

    defineProperty_default()(this, "handleEnterPress", function (keyEvent) {
      if (keyEvent.which === 13) {
        var optionEl = angular_default.a.element(document.querySelector('.autocomplete-option.autocomplete-create_variable'));
        var switchButtonEl = angular_default.a.element(document.querySelector("#".concat(_this.fieldId))); // select option to create variable

        optionEl.click();

        _this.$timeout(function () {
          // close option dropdown
          // note: component dropdown can't be closed automatically, component bug. needs to be re rendered
          switchButtonEl.click();
          switchButtonEl.click();
        });
      }
    });

    this.$scope = $scope;
    this.$timeout = $timeout;
    this.isToggled = false;
    this.isInitialized = false;
  }

  createClass_default()(PropertyMappingController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      this.$scope.$evalAsync(function () {
        _.get(_this2, ['options', 'handlers', 'addCandidates'], function () {
          return Promise.all([]);
        })({
          value: _this2.model.$viewValue,
          objLabel: 'path'
        }).then(function (result) {
          _this2.internalModel = _.chain(result).cloneDeep().reject({
            autocompleteType: trigger_variable_component_const["a" /* AUTOCOMPLETE_ACTION_TYPE */].LABEL
          }).reject({
            autocompleteType: trigger_variable_component_const["a" /* AUTOCOMPLETE_ACTION_TYPE */].SECTION
          }).find({
            path: _this2.model.$viewValue
          }).value();

          if (!_.isUndefined(_this2.internalModel)) {
            _this2.setToggle(true);
          }

          _this2.$scope.$evalAsync(function () {
            _this2.isInitialized = true;
          });
        });
      });
      this.suggestionBehavior = {
        handleOnSuggestionClick: _.curry(function (component, event, suggestion) {
          if (suggestion.autocompleteType === 'LABEL' || suggestion.autocompleteType === 'SECTION') {
            event.preventDefault();
            return;
          }

          var _component$props = component.props,
              handleSuggestionSelected = _component$props.handleSuggestionSelected,
              model = _component$props.model,
              objLabel = _component$props.objLabel;
          var newValue = _.isPlainObject(model) ? _.get(suggestion, objLabel) : suggestion;
          handleSuggestionSelected(event, {
            suggestion: suggestion
          });
          component.notifyOnChange(event, newValue, 'ON_SUGGESTION_CLICK');
          component.setState({
            inputValue: _.get(suggestion, objLabel, '')
          });
          component.closeSuggestions();
          setTimeout(function () {
            _this2.suggestionBehavior.handleOnFocus(component, event);

            component.justSelectedSuggestion = false;
          });
        }),
        handleOnFocus: _.curry(function (component, event) {
          var _component$props2 = component.props,
              handleGetSuggestions = _component$props2.handleGetSuggestions,
              inputProps = _component$props2.inputProps,
              model = _component$props2.model;
          var typing = component.state.typing;
          var justClickedOnSuggestionsContainer = component.justClickedOnSuggestionsContainer,
              justSelectedSuggestion = component.justSelectedSuggestion;

          if (!justClickedOnSuggestionsContainer && !justSelectedSuggestion) {
            handleGetSuggestions(typing ? model : '', 'ON_INPUT_FOCUS');
            component.setState({
              isCollapsed: false,
              isFocused: true
            });
          }

          _.invoke(event, 'onFocus', [inputProps]);
        }),
        renderSuggestion: _.curry(function (component, data, value) {
          var icon = data.icon ? /*#__PURE__*/react_default.a.createElement("i", {
            className: data.icon
          }) : '';
          var rowClasses = classnames_default()('autocomplete-option', "autocomplete-".concat((data.autocompleteType || '').toLowerCase()));
          var description = !_.isUndefined(data.description) ? /*#__PURE__*/react_default.a.createElement("em", null, data.description) : /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null);
          return /*#__PURE__*/react_default.a.createElement("div", {
            className: rowClasses
          }, icon, /*#__PURE__*/react_default.a.createElement("span", null, data.label), description);
        })
      };
    }
  }, {
    key: "fieldId",
    get: function get() {
      return _.camelCase(this.name);
    }
  }]);

  return PropertyMappingController;
}();
/*
* options: {
*   handlers: {
*       addCandidates: () => Promise.all([{
*           type: 'LABEL', 'SELECT_VARIABLE', 'SELECT_PROPERTY',
*           label: 'label',
*           iconClass: ''
*       }]);
*   },
*   label: 'label',
*   onSuggestionSelected: (value) => ,
* }
* */


defineProperty_default()(property_mapping_component_PropertyMappingController, "$inject", ['$scope', '$timeout']);

var propertyMappingComponent = {
  bindings: {
    options: '<',
    onToggle: '&',
    ngRequired: '<',
    name: '@'
  },
  controller: property_mapping_component_PropertyMappingController,
  transclude: true,
  require: {
    model: 'ngModel'
  },
  template: property_mapping_component_template
};
angular_default.a.module('xlrelease').component('propertyMappingComponent', propertyMappingComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/trigger-variable-component/trigger-variable-renderer.component.js






var trigger_variable_renderer_component_template = "<div class=\"form-group\" ng-if=\"$ctrl.isInitialized && $ctrl.isSupported()\">\n        <label class=\"col-sm-3 control-label\">\n            {{$ctrl.variable.label || $ctrl.variable.key}}\n            <span ng-if=\"$ctrl.variable.requiresValue\" class=\"error\">*</span>\n        </label>\n        <div class=\"trigger-variable-mapping--renderer col-sm-9\">\n            <div class=\"trigger-variable-mapping--renderer--input\" \n                ng-switch=\"$ctrl.variableType\" \n                ng-class=\"{'has-error': ($ctrl.form[$ctrl.variable.key].$invalid || $ctrl.variable.hasInvalidName), 'no-switch': !$ctrl.displaySwitchOption()}\">\n            <div ng-switch-when=\"xlrelease.StringVariable\">\n                <property-mapping-component \n                    options=\"$ctrl.autocompleteOptions[$ctrl.getVariableKind()]\" \n                    name=\"{{::$ctrl.variable.key}}\" \n                    ng-model=\"$ctrl.model\"\n                    ng-required=\"$ctrl.variable.requiresValue\"\n                    on-toggle=\"$ctrl.onToggle\">\n                    <input ng-if=\"!$ctrl.variable.multiline\" \n                        type=\"text\"\n                        autocomplete=\"off\"\n                        name=\"{{::$ctrl.variable.key}}\"\n                        class=\"input-block-level\" \n                        ng-disabled=\"$ctrl.isReadOnly\"\n                        ng-required=\"$ctrl.variable.requiresValue\"\n                        ng-model=\"$ctrl.model\"\n                        ng-change=\"$ctrl.onModelChangeInternally()\" />\n                    <textarea ng-if=\"$ctrl.variable.multiline\" \n                        class=\"input-block-level\"\n                        rows=\"4\"\n                        name=\"{{::$ctrl.variable.key}}\"\n                        autocomplete=\"off\"\n                        ng-required=\"$ctrl.variable.requiresValue\"\n                        ng-model=\"$ctrl.model\"\n                        ng-change=\"$ctrl.onModelChangeInternally()\"\n                        ng-disabled=\"$ctrl.isReadOnly\"></textarea>\n                </property-mapping-component>\n            </div>\n            <div ng-switch-when=\"xlrelease.PasswordStringVariable\">\n                <property-mapping-component \n                    options=\"$ctrl.autocompleteOptions[$ctrl.getVariableKind()]\" \n                    name=\"{{::$ctrl.variable.key}}\"\n                    ng-model=\"$ctrl.model\"\n                    ng-required=\"$ctrl.variable.requiresValue\"\n                    on-toggle=\"$ctrl.onToggle\">\n                    <input type=\"password\"\n                            name=\"{{::$ctrl.variable.key}}\"\n                            class=\"input-block-level\"\n                            autocomplete=\"off\"\n                            ng-disabled=\"$ctrl.isReadOnly\"\n                            ng-required=\"$ctrl.variable.requiresValue\"\n                            ng-model=\"$ctrl.model\"\n                            ng-change=\"$ctrl.onModelChangeInternally()\" />\n                </property-mapping-component>\n            </div>\n            <div ng-switch-when=\"xlrelease.IntegerVariable\">\n                <property-mapping-component \n                    options=\"$ctrl.autocompleteOptions[$ctrl.getVariableKind()]\" \n                    name=\"{{::$ctrl.variable.key}}\"\n                    ng-model=\"$ctrl.model\"\n                    ng-required=\"$ctrl.variable.requiresValue\"\n                    on-toggle=\"$ctrl.onToggle\">\n                    <input xl-dip-integer\n                        type=\"text\" \n                        name=\"{{::$ctrl.variable.key}}\" \n                        class=\"input-block-level\"\n                        metadata=\"{required: $ctrl.variable.requiresValue}\"\n                        ng-model=\"$ctrl.model\" \n                        ng-change=\"$ctrl.onModelChangeInternally()\"\n                        ng-disabled=\"$ctrl.isReadOnly\"/>\n                </property-mapping-component>\n            </div>\n            <div ng-switch-when=\"xlrelease.BooleanVariable\">\n                <property-mapping-component \n                    options=\"$ctrl.autocompleteOptions[$ctrl.getVariableKind()]\" \n                    name=\"{{::$ctrl.variable.key}}\"\n                    ng-model=\"$ctrl.model\"\n                    ng-required=\"$ctrl.variable.requiresValue\"\n                    on-toggle=\"$ctrl.onToggle\">\n                    <input type=\"checkbox\" \n                        class=\"input-block-level\" \n                        name=\"{{::$ctrl.variable.key}}\"\n                        ng-change=\"$ctrl.onModelChangeInternally()\"\n                        ng-model=\"$ctrl.model\"\n                        ng-checked=\"$ctrl.model\"\n                        ng-disabled=\"$ctrl.isReadOnly\"/>\n                </property-mapping-component>\n            </div>\n            <div ng-switch-when=\"xlrelease.ListStringVariable\">\n                <property-mapping-component \n                    options=\"$ctrl.autocompleteOptions[$ctrl.getVariableKind()]\" \n                    name=\"{{::$ctrl.variable.key}}\"\n                    ng-model=\"$ctrl.model\"\n                    ng-required=\"$ctrl.variable.requiresValue\"\n                    on-toggle=\"$ctrl.onToggle\">\n                    <div xl-dip-list\n                        class=\"ui-front field\"\n                        name=\"{{::$ctrl.variable.key}}\"\n                        ng-model=\"$ctrl.model\"\n                        on-change=\"$ctrl.onModelChangeInternally()\" \n                        metadata=\"{name: $ctrl.variable.key, required: $ctrl.variable.requiresValue }\"\n                        read-only=\"$ctrl.isReadOnly\">\n                    </property-mapping-component>    \n                </div>\n            </div>\n            <div ng-switch-when=\"xlrelease.DateVariable\">\n                <property-mapping-component \n                    options=\"$ctrl.autocompleteOptions[$ctrl.getVariableKind()]\" \n                    name=\"{{::$ctrl.variable.key}}\"\n                    ng-model=\"$ctrl.model\"\n                    ng-required=\"$ctrl.variable.requiresValue\"\n                    on-toggle=\"$ctrl.onToggle\">\n                    <div date-editor\n                        class=\"date-variable\" \n                        name=\"{{$ctrl.variable.key}}\"\n                        ng-model=\"$ctrl.model\" \n                        on-change=\"$ctrl.onModelChangeInternally()\"\n                        date-format=\"{{::$ctrl.defaultDatetimeFormat}}\">\n                        deletable=\"true\"\n                        placeholder=\"Select date\"\n                        is-required=\"$ctrl.variable.requiresValue\"\n                        readonly=\"$ctrl.isReadOnly\">\n                    </div>\n                </property-mapping-component>\n            </div>\n            <div ng-switch-when=\"xlrelease.SetStringVariable\">\n                <property-mapping-component \n                    options=\"$ctrl.autocompleteOptions[$ctrl.getVariableKind()]\" \n                    name=\"{{::$ctrl.variable.key}}\"\n                    ng-model=\"$ctrl.model\"\n                    ng-required=\"$ctrl.variable.requiresValue\"\n                    on-toggle=\"$ctrl.onToggle\">\n                    <div xl-dip-set \n                        class=\"field\" \n                        ng-model=\"$ctrl.model\"\n                        on-change=\"$ctrl.onModelChangeInternally()\"\n                        metadata=\"{name: $ctrl.variable.key, required: $ctrl.variable.requiresValue }\"\n                        read-only=\"$ctrl.isReadOnly\">\n                    </div>\n                </property-mapping-component>\n            </div>\n            <div ng-switch-when=\"xlrelease.MapStringStringVariable\">\n                <property-mapping-component \n                    options=\"$ctrl.autocompleteOptions[$ctrl.getVariableKind()]\" \n                    name=\"{{::$ctrl.variable.key}}\"\n                    ng-model=\"$ctrl.model\"\n                    ng-required=\"$ctrl.variable.requiresValue\"\n                    on-toggle=\"$ctrl.onToggle\">\n                    <div xl-dip-map-string-string\n                        class=\"field\"\n                        name=\"{{$ctrl.variable.key}}\"\n                        ng-model=\"$ctrl.model\"\n                        on-change=\"$ctrl.onModelChangeInternally()\"\n                        read-only=\"$ctrl.isReadOnly\"\n                        metadata=\"{name: $ctrl.variable.key, required: $ctrl.variable.requiresValue, minVisibleRow: 3}\"\n                        open-on-click=\"true\">\n                    </div>\n                </property-mapping-component>\n            </div>\n            <div ng-switch-when=\"StringValueProvider\" ng-class=\"{'has-error': $ctrl.form[$ctrl.variable.key].$invalid}\">\n                <variable-value-provider-component\n                    ng-model=\"$ctrl.model\"\n                    name=\"{{::$ctrl.variable.key}}\"\n                    on-model-change=\"$ctrl.onModelChangeInternally()\"\n                    is-read-only=\"$ctrl.isReadOnly\"\n                    variable=\"$ctrl.variable\"\n                    ng-required=\"$ctrl.variable.requiresValue\">\n                </variable-value-provider-component>\n            </div>\n            <div ng-switch-default>No renderer</div>\n        </div>\n        <div class=\"description\" ng-class=\"{'no-switch': !$ctrl.displaySwitchOption(), 'has-error': $ctrl.form[$ctrl.variable.key].$invalid}\">\n            <div ng-if=\"$ctrl.variable.hasInvalidName\">\n                <i class='xl-icon circle-exclamation-icon' />\n                There is an issue with the name of the variable. Please update the variable name and save the trigger again. \n                The trigger will be disabled until the issue is fixed.\n            </div>\n            <span ng-if=\"!$ctrl.variable.hasInvalidName\">{{::$ctrl.variable.description}}</span>\n        </div>\n    </div>\n</div>";

var trigger_variable_renderer_component_TriggerVariableRendererController = /*#__PURE__*/function () {
  function TriggerVariableRendererController($scope) {
    var _this = this;

    classCallCheck_default()(this, TriggerVariableRendererController);

    defineProperty_default()(this, "defaultDatetimeFormat", global_constants["a" /* dateTimeFormat */].ISODateTime);

    defineProperty_default()(this, "onModelChangeInternally", function () {
      var path = _this.model;

      var mappingType = trigger_variable_component_const["c" /* MAPPING_TYPES */][_this.getVariableKind()];

      if (_this.isValueProvider()) {
        path = _.get(_this.model, 'id');
        mappingType = 'xlrelease.StringValue';
      }

      var selectedValue = {
        autocompleteType: trigger_variable_component_const["a" /* AUTOCOMPLETE_ACTION_TYPE */].INPUT_VALUE,
        targetName: _this.variable.key,
        mappingType: mappingType,
        path: path
      };

      _.get(_this, ['autocompleteOptions', _this.getVariableKind(), 'onSuggestionSelected'], _.noop)(selectedValue);
    });

    defineProperty_default()(this, "onToggle", function (isToggled) {
      if (!isToggled) {
        _this.onModelChangeInternally();
      }
    });

    this.$scope = $scope;
    this.isInitialized = false;
    this.model = undefined;
    this.variableType = undefined;
  }

  createClass_default()(TriggerVariableRendererController, [{
    key: "$onInit",
    value: function $onInit() {
      this.variableType = !!this.variable.valueProvider ? 'StringValueProvider' : this.variable.type;
      this.model = this.model || this.variable.value;
      this.isInitialized = true;
    }
  }, {
    key: "isValueProvider",
    value: function isValueProvider() {
      var variableType = this.variableType;
      return variableType === 'StringValueProvider';
    }
  }, {
    key: "displaySwitchOption",
    value: function displaySwitchOption() {
      return !this.isValueProvider();
    }
  }, {
    key: "isSupported",
    value: function isSupported() {
      var variableType = this.variableType;

      switch (variableType) {
        case variable_constants["a" /* VariableConstants */].type.integer.key:
        case variable_constants["a" /* VariableConstants */].type.boolean.key:
        case variable_constants["a" /* VariableConstants */].type.listString.key:
        case variable_constants["a" /* VariableConstants */].type.date.key:
        case variable_constants["a" /* VariableConstants */].type.setString.key:
        case variable_constants["a" /* VariableConstants */].type.passwordString.key:
        case variable_constants["a" /* VariableConstants */].type.mapStringString.key:
        case variable_constants["a" /* VariableConstants */].type.string.key:
        case 'StringValueProvider':
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "getVariableKind",
    value: function getVariableKind() {
      return trigger_variable_component_const["e" /* VARIABLE_TYPE_TO_PROPERTY_KIND */][this.variable.type];
    }
  }]);

  return TriggerVariableRendererController;
}();

defineProperty_default()(trigger_variable_renderer_component_TriggerVariableRendererController, "$inject", ['$scope']);

var TriggerVariableRendererComponent = {
  bindings: {
    autocompleteOptions: '<',
    variable: '<',
    isReadOnly: '<',
    model: '<'
  },
  require: {
    form: '^^form'
  },
  controller: trigger_variable_renderer_component_TriggerVariableRendererController,
  template: trigger_variable_renderer_component_template
};

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/trigger-variable-component/variable-value-provider.component.js



var variable_value_provider_component_template = "<xl-react-widget-autocomplete\n    ng-if=\"$ctrl.isLoaded\"\n    handlers=\"$ctrl.handlers\"\n    model=\"$ctrl.value\"\n    on-suggestion-selected=\"$ctrl.onSuggestionSelected\"\n    disabled=\"$ctrl.isReadOnly\"\n    on-model-change=\"$ctrl.onChange\"\n    obj-label=\"'label'\"/>";

var variable_value_provider_component_VariableValueProviderController = /*#__PURE__*/function () {
  function VariableValueProviderController(VariablesService, $scope) {
    var _this = this;

    classCallCheck_default()(this, VariableValueProviderController);

    defineProperty_default()(this, "onSuggestionSelected", function (value) {
      _this.$scope.$evalAsync(function () {
        _this.setValidity(true);

        _this.value = value;

        _this.model.$setViewValue(_this.value);

        _this.onModelChange();
      });
    });

    defineProperty_default()(this, "onChange", function (value) {
      _this.$scope.$evalAsync(function () {
        if (_.isEmpty(value)) {
          _this.setValidity(false);

          _this.value = undefined;

          _this.model.$setViewValue(_this.value);

          _this.onModelChange();
        }
      });
    });

    defineProperty_default()(this, "setValidity", function (isValid) {
      if (_this.required) {
        _this.model.$setValidity('required', isValid);
      }
    });

    this.$scope = $scope;
    this.VariablesService = VariablesService;
    this.isLoaded = false;
  }

  createClass_default()(VariableValueProviderController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      this.required = _.defaultTo(this.required, false);
      this.VariablesService.getPossibleValues(this.variable).then(function (result) {
        return _(result).pick('data').values().flatten().map(function (item) {
          var autocompleteItem;

          if (_.isString(item)) {
            autocompleteItem = {
              id: item,
              label: item
            };
          } else if (_.isPlainObject(item)) {
            autocompleteItem = {
              id: item.id,
              label: item.title
            };
          }

          return autocompleteItem;
        }).value();
      }).then(function (result) {
        _this2.value = result.find(_.matches({
          id: _this2.model.$viewValue
        }));
        _this2.handlers = {
          addCandidates: function addCandidates(_ref) {
            var value = _ref.value,
                objLabel = _ref.objLabel;
            return Promise.all(result.filter(function (item) {
              return _.includes(_.toLower(item[objLabel]), _.toLower(value));
            }));
          }
        };
        _this2.isLoaded = true;
      });
    }
  }]);

  return VariableValueProviderController;
}();

defineProperty_default()(variable_value_provider_component_VariableValueProviderController, "$inject", ['VariablesService', '$scope']);

var VariableValueProviderComponent = {
  bindings: {
    onModelChange: '&',
    variable: '<',
    isReadOnly: '<',
    required: '<'
  },
  controller: variable_value_provider_component_VariableValueProviderController,
  require: {
    model: "ngModel"
  },
  template: variable_value_provider_component_template
};

// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/trigger-variable-component/trigger-variable-renderer.less
var trigger_variable_renderer = __webpack_require__(1425);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/trigger-variable-component/trigger-variable-mapping.component.js




var trigger_variable_mapping_component_template = "<div class=\"trigger-variable-mapping\">\n    <ng-form name=\"triggerVariablesForm\" noValidate>\n        <trigger-variable-renderer-component\n            autocomplete-options=\"$ctrl.autocompleteOptions\"\n            model=\"$ctrl.model[variable.key]\"\n            ng-repeat=\"variable in $ctrl.variables\"\n            variable=\"variable\">\n        </trigger-variable-renderer-component>\n    </ng-form>\n</div>";
var TriggerVariableMappingComponent = {
  bindings: {
    autocompleteOptions: '<',
    variables: '<',
    model: '<'
  },
  template: trigger_variable_mapping_component_template
};
angular_default.a.module('xlrelease').component('variableValueProviderComponent', VariableValueProviderComponent).component('triggerVariableRendererComponent', TriggerVariableRendererComponent).component('triggerVariableMappingComponent', TriggerVariableMappingComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/password-input/password-input-component.js





var password_input_component_PasswordInputController = /*#__PURE__*/function () {
  function PasswordInputController(Backend, $element) {
    var _this = this;

    classCallCheck_default()(this, PasswordInputController);

    defineProperty_default()(this, "validatePassword", _.debounce(function () {
      var payload = {
        password: _this.password || ''
      };

      _this._Backend.post('users/validatePassword', {
        password: _this.password
      }).then(function (response) {
        var data = response.data;
        _this.passwordValidations = data;
        var totalCount = data.length;
        var validCount = data.filter(function (validation) {
          return validation.valid;
        }).length;
        _this.passwordStatus.status = validCount === 0 && 'empty' || (totalCount === validCount ? 'valid' : 'invalid');
        _this.passwordStatus.totalCount = totalCount;
        _this.passwordStatus.validCount = validCount;

        var currentTooltip = _this.getPasswordInputEl().data('bs.tooltip');

        if (currentTooltip.enabled && _this.passwordStatus.status === 'valid') {
          _this.hintTooltip('hide');

          _this.hintTooltip('disable');
        } else {
          _this.hintTooltip('enable');

          if (angular.element(document.activeElement).is(".".concat(passwordInputContainerClassName))) {
            _this.hintTooltip('show');
          }
        }
      });
    }, global_constants["b" /* debounceTime */]));

    this._Backend = Backend;
    this._$element = $element;
  }

  createClass_default()(PasswordInputController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      this.getPasswordInputEl().tooltip({
        trigger: 'manual',
        animation: false,
        placement: 'top',
        container: 'body',
        html: true,
        title: function title() {
          return _this2.getPasswordHintHTML();
        },
        template: "<div class=\"tooltip\" role=\"tooltip\"><div class=\"tooltip-arrow\"></div><div class=\"tooltip-inner password-validation-tooltip\"></div></div>"
      });
      this.validatePassword();
    }
  }, {
    key: "hintTooltip",
    value: function hintTooltip(action) {
      if (this.passwordValidations) {
        this.getPasswordInputEl().tooltip(action);
      }
    }
  }, {
    key: "getPasswordInputEl",
    value: function getPasswordInputEl() {
      return this._$element.find(".".concat(passwordInputContainerClassName));
    }
  }, {
    key: "getPasswordHintHTML",
    value: function getPasswordHintHTML() {
      var messagesHtml = this.passwordValidations.map(function (validation) {
        return "\n                <div class=\"contains-icon validation-message\">\n                    <i class='xl-icon ".concat(validation.valid ? 'circle-check-icon' : 'circle-minus-icon', "'/>\n                    <span>\n                        ").concat(validation.message, "\n                    </span>\n                </div>\n            ");
      });
      return "<p>Password needs to meet these requirements:</p>\n                ".concat(messagesHtml.join(''));
    }
  }]);

  return PasswordInputController;
}();

defineProperty_default()(password_input_component_PasswordInputController, "$inject", ['Backend', '$element']);

var passwordHintContainerClassName = 'password-hint-container';
var passwordInputContainerClassName = 'password-input-container';
var password_input_component_template = "\n<div class=\"password-input-component\">\n    <input type=\"password\" class=\"input-block-level ".concat(passwordInputContainerClassName, "\"\n        data-test=\"password-input\"\n        ng-model=\"$ctrl.password\"\n        ng-change=\"$ctrl.validatePassword();\"\n        ng-focus=\"$ctrl.hintTooltip('show')\"\n        ng-blur=\"$ctrl.hintTooltip('hide')\"\n        ng-mousemove=\"$ctrl.hintTooltip('show')\"\n        ng-mouseout=\"$ctrl.hintTooltip('hide')\"\n        autocomplete=\"none\"\n        ng-required=\"$ctrl.isRequired\"\n    />\n    <span ng-if=\"$ctrl.passwordStatus.status === 'empty'\" style=\"float: left; margin-right: 4px;\">\n        Type in password.\n    </span>\n    <div class=\"").concat(passwordHintContainerClassName, "\">\n        <div class=\"filter-all\"\n              ng-mousemove=\"$ctrl.hintTooltip('show')\"\n              ng-mouseout=\"$ctrl.hintTooltip('hide')\"\n              ng-if=\"$ctrl.passwordStatus.status !== 'valid'\">\n                <span ng-if=\"$ctrl.passwordStatus.status === 'invalid'\" class=\"contains-icon\" >\n                    <i class='xl-icon icon-s warning-icon'/>\n                    This password does not meet the requirements {{$ctrl.passwordStatus.validCount}}/{{$ctrl.passwordStatus.totalCount}}\n                </span>\n                <span ng-if=\"$ctrl.passwordStatus.status === 'empty'\" class=\"contains-icon\">\n                    Password requirements {{$ctrl.passwordStatus.validCount}}/{{$ctrl.passwordStatus.totalCount}}\n                </span>\n         </div>\n     </div>\n    <span ng-if=\"$ctrl.passwordStatus.status === 'valid'\">This password meets the password requirements.</span>\n</div>\n");
var PasswordInputComponent = {
  bindings: {
    password: '=',
    isRequired: '<',
    passwordStatus: '='
  },
  controller: password_input_component_PasswordInputController,
  template: password_input_component_template
};
angular.module('xlrelease').component('passwordInput', PasswordInputComponent);
// EXTERNAL MODULE: ./node_modules/lodash/isEmpty.js
var isEmpty = __webpack_require__(59);
var isEmpty_default = /*#__PURE__*/__webpack_require__.n(isEmpty);

// EXTERNAL MODULE: ./node_modules/lodash/isUndefined.js
var isUndefined = __webpack_require__(197);
var isUndefined_default = /*#__PURE__*/__webpack_require__.n(isUndefined);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/password-lookup-component/password-lookup.html
/* harmony default export */ var password_lookup = ("<ng-container ng-if=\"!$ctrl.readOnly\">\n    <div id=\"password-lookup-field\" class=\"input-group\">\n        <span class=\"input-group-btn\">\n            <button ng-if=\"!$ctrl.isExternalValueMode\" class=\"btn btn-default btn-toggle-lookup\"\n                    type=\"button\" ng-click=\"$ctrl.toggleInput()\"\n                    tooltip=\"'Switch to secrets management system'\" tooltip-position=\"bottom\">\n                <i class='xl-icon keyboard-icon'/></button>\n            <button ng-if=\"$ctrl.isExternalValueMode\" class=\"btn btn-default btn-toggle-lookup btn-checked\"\n                    type=\"button\" ng-click=\"$ctrl.toggleInput()\"\n                    tooltip=\"'Switch to manual entry'\" tooltip-position=\"bottom\">\n                <i class='xl-icon keyboard-icon'/></button>\n        </span>\n        <input ng-if=\"!$ctrl.isExternalValueMode\" type=\"password\" class=\"input-block-level\"\n               data-test-id=\"password-input\"\n               ng-model=\"$ctrl.model.value\" autofocus/>\n        <xl-react-widget-autocomplete ng-if=\"$ctrl.isExternalValueMode\"\n                                      handlers=$ctrl.configurationHandlers\n                                      metadata=\"{ placeholder: 'No external password server', required: true }\"\n                                      model=$ctrl.configurationTitle\n                                      obj-label=\"'title'\"\n                                      ng-disabled=\"false\"\n                                      menu-height=\"135\"\n                                      on-model-change=\"$ctrl.onModelChange\"\n                                      on-suggestion-selected=\"$ctrl.onConfigurationSelected\"\n                                      on-validity-change=\"$ctrl.onConfigurationValidityChange\"\n                                      disabled=\"$ctrl.configurations.length === 0\"\n                                      data-test-id=\"external-server\">\n        </xl-react-widget-autocomplete>\n    </div>\n    <ng-container ng-if=\"$ctrl.isExternalValueMode && $ctrl.model.externalVariableValue.server\">\n        <input type=\"text\" class=\"input-block-level mts\"\n               data-test-id=\"external-path\"\n               ng-model=\"$ctrl.model.externalVariableValue.path\" placeholder=\"Path on the external server\"/>\n        <input ng-if=\"$ctrl.isExternalKeyFieldVisible\" type=\"text\" class=\"input-block-level mts\"\n               data-test-id=\"external-key\"\n               ng-model=\"$ctrl.model.externalVariableValue.externalKey\" placeholder=\"Key to retrieve secret\"/>\n    </ng-container>\n    <div ng-if=\"$ctrl.isExternalValueMode && $ctrl.configurations.length === 0\"\n         id=\"no-configuration-warning\" class=\"description\">\n        An external secrets management system needs to be configured\n    </div>\n</ng-container>\n\n<ng-container ng-if=\"$ctrl.readOnly\">\n    <p class=\"field-readonly\" ng-class=\"{ 'empty-value': !$ctrl.getValue(var) }\" tooltip=\"'External server'\"\n       data-test-id=\"readonly-value\">\n        {{ $ctrl.getValue() || $ctrl.emptyValueString }}</p>\n    <ng-container ng-if=\"$ctrl.isExternalValueMode\">\n        <p ng-class=\"{ 'empty-value': !$ctrl.model.externalVariableValue.path.length }\"\n           data-test-id=\"external-path\">\n            <span class=\"field-readonly\" tooltip=\"'Path'\">\n                {{$ctrl.model.externalVariableValue.path || $ctrl.emptyValueString}}</span>\n        </p>\n        <p ng-class=\"{ 'empty-value': !$ctrl.model.externalVariableValue.externalKey.length }\"\n           ng-if=\"$ctrl.isExternalKeyFieldVisible\" data-test-id=\"external-key\">\n            <span class=\"field-readonly\" tooltip=\"'Key'\">\n                {{$ctrl.model.externalVariableValue.externalKey || $ctrl.emptyValueString}}</span>\n        </p>\n    </ng-container>\n</ng-container>");
// EXTERNAL MODULE: ./core/xlr-ui/app/xlr-components/password-lookup-component/password-lookup.less
var password_lookup_component_password_lookup = __webpack_require__(1426);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/password-lookup-component/password-lookup.component.js







var conjurServerType = 'conjur.ConjurServer';
var externalVariableServerType = 'xlrelease.ExternalVariableServer';
var valueProvider = 'xlrelease.ExternalVariableValue';

var password_lookup_component_PasswordLookupController = /*#__PURE__*/function () {
  function PasswordLookupController($scope, Backend, VariablesService) {
    var _this = this;

    classCallCheck_default()(this, PasswordLookupController);

    defineProperty_default()(this, "_addConfigurationCandidates", function (_ref) {
      var metadata = _ref.metadata,
          objLabel = _ref.objLabel,
          value = _ref.value;
      return Promise.resolve(_this.configurations.filter(function (item) {
        return item.title.toLowerCase().includes(value.toLowerCase());
      }));
    });

    defineProperty_default()(this, "onModelChange", function (value) {
      _this.$scope.$evalAsync(function () {
        if (isEmpty_default()(value)) {
          _this.model.externalVariableValue = _this.initExternalServerValues();
          _this.isExternalKeyFieldVisible = true;
        }

        _this._updateValidity(_this.configurationTitle === value);
      });
    });

    defineProperty_default()(this, "onConfigurationSelected", function (configuration) {
      _this.$scope.$evalAsync(function () {
        _this.model.externalVariableValue.server = configuration.id;
        _this.model.externalVariableValue.path = '';

        if (_this.editMode) {
          _this.setExternalVariableEditValues();
        } else {
          _this.model.externalVariableValue.serverType = configuration.type;
        }

        _this.isExternalKeyFieldVisible = configuration.type !== conjurServerType;

        if (!_this.isExternalKeyFieldVisible) {
          _this.model.externalVariableValue.externalKey = undefined;
        } else {
          _this.model.externalVariableValue.externalKey = '';
        }

        _this._updateValidity(true);
      });
    });

    defineProperty_default()(this, "onConfigurationValidityChange", function (valid) {
      _this.isServerConfValid = valid;
    });

    defineProperty_default()(this, "toggleInput", function () {
      _this.isExternalValueMode = !_this.isExternalValueMode;

      if (_this.isExternalValueMode) {
        _this.model.externalVariableValue = _this.tempModelValue;
        _this.tempModelValue = _this.model.value;
        _this.model.value = undefined;
      } else {
        _this.model.value = _this.tempModelValue;
        _this.tempModelValue = _this.model.externalVariableValue;
        _this.model.externalVariableValue = undefined;

        _this._updateValidity(true);
      }

      _this.onToggle({
        isExternalPassword: _this.isExternalValueMode
      });
    });

    defineProperty_default()(this, "_updateValidity", function () {
      var isValid = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
      var valid = _this.isExternalValueMode ? _this.isServerConfValid && !isEmpty_default()(_this.model.externalVariableValue.server) && isValid : isValid;

      _this.onValidityChange({
        valid: valid
      });
    });

    defineProperty_default()(this, "getValue", function () {
      return _this.isExternalValueMode ? _this.configurationTitle : _this.VariablesService.getValue(_this.model);
    });

    this.$scope = $scope;
    this.Backend = Backend;
    this.VariablesService = VariablesService;
    this.isExternalValueMode = false;
    this.isExternalKeyFieldVisible = true;
    this.isServerConfValid = true;
    this.configurations = [];
  }

  createClass_default()(PasswordLookupController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      this.initConfigurationList().then(function () {
        _this2.initValues();
      });
    }
  }, {
    key: "initValues",
    value: function initValues() {
      var _this3 = this;

      if (!isUndefined_default()(this.model.externalVariableValue)) {
        this.isExternalValueMode = true;
        this.tempModelValue = '';
        this.setExternalVariableEditValues();
        var maybeConfiguration = this.configurations.find(function (conf) {
          return conf.id === _this3.model.externalVariableValue.server;
        });
        this.isExternalKeyFieldVisible = maybeConfiguration ? maybeConfiguration.type !== conjurServerType : true;
      } else {
        this.isExternalValueMode = false;
        this.tempModelValue = this.initExternalServerValues();
      }

      this._updateValidity(true);

      this.onToggle({
        isExternalPassword: this.isExternalValueMode
      });
    }
  }, {
    key: "initExternalServerValues",
    value: function initExternalServerValues() {
      return {
        server: '',
        serverType: '',
        path: '',
        externalKey: ''
      };
    }
  }, {
    key: "setExternalVariableEditValues",
    value: function setExternalVariableEditValues() {
      this.model.externalVariableValue.id = null;
      this.model.externalVariableValue.type = valueProvider;
      this.model.externalVariableValue.serverType = undefined;
    }
  }, {
    key: "initConfigurationList",
    value: function initConfigurationList() {
      var _this4 = this;

      return this.Backend.get('api/v1/config/byTypeAndTitle', {
        params: {
          configurationType: externalVariableServerType,
          folderOnly: false,
          folderId: this.folderId
        }
      }).then(function (resp) {
        _this4.configurations = _.sortBy(resp.data, 'title');
        _this4.configurationHandlers = {
          addCandidates: _this4._addConfigurationCandidates
        };
      });
    }
  }, {
    key: "configurationTitle",
    get: function get() {
      var _this5 = this;

      var maybeConfiguration = this.configurations.find(function (conf) {
        return conf.id === _this5.model.externalVariableValue.server;
      });
      return maybeConfiguration ? maybeConfiguration.title : null;
    }
  }]);

  return PasswordLookupController;
}();

defineProperty_default()(password_lookup_component_PasswordLookupController, "$inject", ['$scope', 'Backend', 'VariablesService']);

var passwordLookupComponent = {
  bindings: {
    model: '=',
    folderId: '<',
    onValidityChange: '&',
    onToggle: '&',
    readOnly: '<',
    editMode: '<',
    emptyValueString: '<'
  },
  controller: password_lookup_component_PasswordLookupController,
  template: password_lookup
};
angular.module('xlrelease').component('xlPasswordLookup', passwordLookupComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/index.js







































// EXTERNAL MODULE: ./node_modules/lodash/includes.js
var lodash_includes = __webpack_require__(63);
var includes_default = /*#__PURE__*/__webpack_require__.n(lodash_includes);

// EXTERNAL MODULE: ./node_modules/lodash/sortBy.js
var sortBy = __webpack_require__(113);
var sortBy_default = /*#__PURE__*/__webpack_require__.n(sortBy);

// EXTERNAL MODULE: ./node_modules/lodash/values.js
var lodash_values = __webpack_require__(237);
var values_default = /*#__PURE__*/__webpack_require__.n(lodash_values);

// EXTERNAL MODULE: ./node_modules/lodash/camelCase.js
var camelCase = __webpack_require__(805);
var camelCase_default = /*#__PURE__*/__webpack_require__.n(camelCase);

// EXTERNAL MODULE: ./node_modules/lodash/isFunction.js
var isFunction = __webpack_require__(85);
var isFunction_default = /*#__PURE__*/__webpack_require__.n(isFunction);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/utils/use-reducer-with-thunk.js



function useReducerWithThunk(reducer, initialState) {
  var _useReducer = Object(react["useReducer"])(reducer, initialState),
      _useReducer2 = slicedToArray_default()(_useReducer, 2),
      state = _useReducer2[0],
      dispatch = _useReducer2[1];

  var customDispatch = function customDispatch(action) {
    if (isFunction_default()(action)) {
      action(customDispatch);
    } else {
      dispatch(action);
    }
  };

  return [state, customDispatch];
}
// EXTERNAL MODULE: ./node_modules/@babel/runtime/regenerator/index.js
var regenerator = __webpack_require__(8);
var regenerator_default = /*#__PURE__*/__webpack_require__.n(regenerator);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/asyncToGenerator.js
var asyncToGenerator = __webpack_require__(278);
var asyncToGenerator_default = /*#__PURE__*/__webpack_require__.n(asyncToGenerator);

// EXTERNAL MODULE: ./node_modules/@reduxjs/toolkit/dist/redux-toolkit.esm.js + 2 modules
var redux_toolkit_esm = __webpack_require__(360);

// EXTERNAL MODULE: ./node_modules/lodash/get.js
var lodash_get = __webpack_require__(176);

// EXTERNAL MODULE: ./node_modules/lodash/trim.js
var trim = __webpack_require__(448);
var trim_default = /*#__PURE__*/__webpack_require__.n(trim);

// CONCATENATED MODULE: ./core/xlr-ui/app/features/support/support-tools/support-tools.reducer.js








var toastr = Object(toastrFactory["a" /* default */])();

var supportToolsState = function supportToolsState() {
  return {};
};

var deleteRelease = Object(redux_toolkit_esm["a" /* createAsyncThunk */])('support/releaseDelete', /*#__PURE__*/function () {
  var _ref = asyncToGenerator_default()( /*#__PURE__*/regenerator_default.a.mark(function _callee(releaseId, thunkAPI) {
    return regenerator_default.a.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return Object(http["b" /* httpDELETE */])("support/releases/".concat(trim_default()(releaseId))).then(function () {
              return toastr.success('Release successfully deleted!');
            });

          case 2:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));

  return function (_x, _x2) {
    return _ref.apply(this, arguments);
  };
}());
var getReleaseContent = Object(redux_toolkit_esm["a" /* createAsyncThunk */])('support/releaseContent', /*#__PURE__*/function () {
  var _ref2 = asyncToGenerator_default()( /*#__PURE__*/regenerator_default.a.mark(function _callee2(releaseId, thunkAPI) {
    var response;
    return regenerator_default.a.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return Object(http["d" /* httpGETBlob */])("support/releases/".concat(trim_default()(releaseId)));

          case 2:
            response = _context2.sent;
            download_helper["a" /* DownloadHelper */].download(response);

          case 4:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));

  return function (_x3, _x4) {
    return _ref2.apply(this, arguments);
  };
}());
var updateTaskStatus = Object(redux_toolkit_esm["a" /* createAsyncThunk */])('support/taskUpdate', /*#__PURE__*/function () {
  var _ref4 = asyncToGenerator_default()( /*#__PURE__*/regenerator_default.a.mark(function _callee3(_ref3, thunkAPI) {
    var taskId, status;
    return regenerator_default.a.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            taskId = _ref3.taskId, status = _ref3.status;
            _context3.next = 3;
            return Object(http["e" /* httpPOST */])("support/tasks/".concat(trim_default()(taskId), "?newStatus=").concat(status.value)).then(function () {
              return toastr.success('Task status successfully changed!');
            });

          case 3:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  }));

  return function (_x5, _x6) {
    return _ref4.apply(this, arguments);
  };
}());
var webhookTestRunSlice = Object(redux_toolkit_esm["b" /* createSlice */])({
  name: 'support',
  initialState: supportToolsState()
});
var supportToolsReducer = webhookTestRunSlice.reducer;
var resetState = webhookTestRunSlice.actions.resetState;

// EXTERNAL MODULE: ./core/xlr-ui/app/features/support/support-tools/support-tools.less
var support_tools = __webpack_require__(1440);

// CONCATENATED MODULE: ./core/xlr-ui/app/features/support/support-tools/support-tools.component.js



function support_tools_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function support_tools_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { support_tools_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { support_tools_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }











var tabs = {
  releases: 'Releases',
  tasks: 'Tasks'
};
var taskStatuses = [{
  title: 'Skipped',
  value: 'SKIPPED'
}, {
  title: 'Completed',
  value: 'COMPLETED'
}, {
  title: 'Aborted',
  value: 'ABORTED'
}, {
  title: 'Failed',
  value: 'FAILED'
}];
var deleteReleaseIdFieldMetadata = {
  label: 'Release ID',
  placeholder: 'Release ID',
  description: 'ID to delete from the active and archive database, in the format Applications/FolderID/ReleaseID',
  required: true
};
var releaseIdFieldMetadata = {
  label: 'Release ID',
  placeholder: 'Release ID',
  description: 'ID of the release to retrieve, in the format Applications/FolderID/ReleaseID',
  required: true
};
var taskIdFieldMetadata = {
  label: 'Task ID',
  placeholder: 'Task ID',
  description: 'ID of the task to change the status, in the format Applications/FolderID/ReleaseID/PhaseID/TaskID',
  required: true
};
var statusFormMetadata = {
  description: 'Select the new status of the task',
  label: 'New status',
  placeholder: 'Select the new status',
  required: true
};

var support_tools_component_SupportToolsComponent = function SupportToolsComponent() {
  var _useReducerWithThunk = useReducerWithThunk(supportToolsReducer, supportToolsState()),
      _useReducerWithThunk2 = slicedToArray_default()(_useReducerWithThunk, 2),
      state = _useReducerWithThunk2[0],
      dispatch = _useReducerWithThunk2[1];

  var _useState = Object(react["useState"])(tabs.releases),
      _useState2 = slicedToArray_default()(_useState, 2),
      selectedTab = _useState2[0],
      setSelectedTab = _useState2[1];

  var _useState3 = Object(react["useState"])(''),
      _useState4 = slicedToArray_default()(_useState3, 2),
      releaseDeletionModel = _useState4[0],
      setReleaseDeletionModel = _useState4[1];

  var _useState5 = Object(react["useState"])(''),
      _useState6 = slicedToArray_default()(_useState5, 2),
      releaseContentModel = _useState6[0],
      setReleaseContentModel = _useState6[1];

  var _useState7 = Object(react["useState"])({
    taskId: '',
    status: {
      title: '',
      value: ''
    }
  }),
      _useState8 = slicedToArray_default()(_useState7, 2),
      taskUpdateModel = _useState8[0],
      setTaskUpdateModel = _useState8[1];

  var _useState9 = Object(react["useState"])(false),
      _useState10 = slicedToArray_default()(_useState9, 2),
      isDeleteReleaseValid = _useState10[0],
      setIsDeleteReleaseValid = _useState10[1];

  var _useState11 = Object(react["useState"])(false),
      _useState12 = slicedToArray_default()(_useState11, 2),
      isReleaseValid = _useState12[0],
      setIsReleaseValid = _useState12[1];

  var _useState13 = Object(react["useState"])(false),
      _useState14 = slicedToArray_default()(_useState13, 2),
      isTaskIdValid = _useState14[0],
      setIsTaskIdValid = _useState14[1];

  var _useState15 = Object(react["useState"])(false),
      _useState16 = slicedToArray_default()(_useState15, 2),
      isTaskStatusValid = _useState16[0],
      setIsTaskStatusValid = _useState16[1];

  var _useState17 = Object(react["useState"])(0),
      _useState18 = slicedToArray_default()(_useState17, 2),
      countTabClick = _useState18[0],
      setCountTabClick = _useState18[1];

  var autocompleteHandler = function autocompleteHandler(_ref) {
    var metadata = _ref.metadata,
        objLabel = _ref.objLabel,
        suggestedElements = _ref.suggestedElements,
        value = _ref.value;
    return Promise.resolve(sortBy_default()(taskStatuses.filter(function (c) {
      return includes_default()(c.title.toLowerCase(), value.toLowerCase());
    }), ['title']));
  };

  var autocompleteHandlers = {
    addCandidates: autocompleteHandler
  };

  var changeTab = function changeTab(tab) {
    //reset validation
    setIsDeleteReleaseValid(false);
    setIsReleaseValid(false);
    setIsTaskIdValid(false);
    setIsTaskStatusValid(false); //reset models

    setReleaseDeletionModel('');
    setReleaseContentModel('');
    setTaskUpdateModel({
      taskId: '',
      status: {
        title: '',
        value: ''
      }
    });
    setCountTabClick(countTabClick + 1);
    setSelectedTab(tab);
  };

  var renderTabMenu = function renderTabMenu(selectedTab) {
    return /*#__PURE__*/react_default.a.createElement("ul", {
      className: "nav nav-tabs support-nav"
    }, values_default()(tabs).map(function (tab, index) {
      return /*#__PURE__*/react_default.a.createElement("li", {
        className: classnames_default()({
          'active': selectedTab === tab
        }),
        key: tab,
        role: "tab",
        tabIndex: index
      }, /*#__PURE__*/react_default.a.createElement("a", {
        onClick: function onClick() {
          return changeTab(tab);
        }
      }, tab));
    }));
  };

  var renderTabContent = function renderTabContent(selectedTab) {
    switch (selectedTab) {
      case tabs.releases:
        return renderReleasesTab();

      case tabs.tasks:
        return renderTasksTab();

      default:
        return /*#__PURE__*/react_default.a.createElement("div", null, "\xA0");
    }
  };

  var renderFieldset = function renderFieldset(title, description, form) {
    return /*#__PURE__*/react_default.a.createElement("fieldset", {
      key: "".concat(countTabClick, "-").concat(camelCase_default()(title))
    }, /*#__PURE__*/react_default.a.createElement("legend", null, title), /*#__PURE__*/react_default.a.createElement("div", {
      className: "help"
    }, description), /*#__PURE__*/react_default.a.createElement("div", null, form));
  };

  var renderReleasesTab = function renderReleasesTab() {
    var deleteForm = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetString"], {
      metadata: deleteReleaseIdFieldMetadata,
      model: releaseDeletionModel,
      onModelChange: function onModelChange(title) {
        return setReleaseDeletionModel(title);
      },
      onValidityChange: function onValidityChange(valid) {
        return setIsDeleteReleaseValid(valid);
      }
    }), /*#__PURE__*/react_default.a.createElement("button", {
      className: "button primary pull-right",
      disabled: !isDeleteReleaseValid,
      onClick: function onClick() {
        return dispatch(deleteRelease(releaseDeletionModel));
      }
    }, "Delete"));
    var releaseContentForm = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetString"], {
      metadata: releaseIdFieldMetadata,
      model: releaseContentModel,
      onModelChange: function onModelChange(title) {
        return setReleaseContentModel(title);
      },
      onValidityChange: function onValidityChange(valid) {
        return setIsReleaseValid(valid);
      }
    }), /*#__PURE__*/react_default.a.createElement("button", {
      className: "button primary pull-right",
      disabled: !isReleaseValid,
      onClick: function onClick() {
        return dispatch(getReleaseContent(releaseContentModel));
      }
    }, "Get content"));
    return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, renderFieldset('Get release content', "Retrieve the raw release JSON from the database.", releaseContentForm), renderFieldset('Delete release', "Delete an active or archived release from database. If there are incoming dependencies to the release, they will be archived before deletion.", deleteForm));
  };

  var renderTasksTab = function renderTasksTab() {
    var form = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetString"], {
      metadata: taskIdFieldMetadata,
      model: taskUpdateModel.taskId,
      onModelChange: function onModelChange(taskId) {
        return setTaskUpdateModel(support_tools_component_objectSpread({}, taskUpdateModel, {
          taskId: taskId
        }));
      },
      onValidityChange: function onValidityChange(valid) {
        return setIsTaskIdValid(valid);
      }
    }), /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetAutocomplete"], {
      handlers: autocompleteHandlers,
      metadata: statusFormMetadata,
      model: taskUpdateModel.status,
      objLabel: 'title',
      onModelChange: function onModelChange(status) {
        return setTaskUpdateModel(support_tools_component_objectSpread({}, taskUpdateModel, {
          status: status
        }));
      },
      onValidityChange: function onValidityChange(valid) {
        return setIsTaskStatusValid(valid);
      }
    }), /*#__PURE__*/react_default.a.createElement("button", {
      className: "button primary pull-right",
      disabled: !(isTaskIdValid && isTaskStatusValid),
      onClick: function onClick() {
        return dispatch(updateTaskStatus(taskUpdateModel));
      }
    }, "Update"));
    return renderFieldset('Change task status', "Force update the task to a specific status in case the task is stuck in an invalid status.\n                        This update will bypass the state transition checks and perform the transition directly in the model.", form);
  };

  return /*#__PURE__*/react_default.a.createElement("div", {
    id: "support-page"
  }, /*#__PURE__*/react_default.a.createElement("div", {
    className: "header"
  }, "Support Accelerator Tools"), /*#__PURE__*/react_default.a.createElement("div", {
    className: "content"
  }, renderTabMenu(selectedTab), /*#__PURE__*/react_default.a.createElement("div", {
    className: "support-tab mlm mtl col-sm-6"
  }, renderTabContent(selectedTab))));
};


// CONCATENATED MODULE: ./core/xlr-ui/app/features/support/index.js



/* harmony default export */ var support = (angular.module('xlrelease').component('supportPage', Object(react2angular["react2angular"])(support_tools_component_SupportToolsComponent)).config(['$stateProvider', function ($stateProvider) {
  $stateProvider.state('support', {
    url: '/support',
    permissions: [permissions_constants["b" /* GlobalPermissions */].ADMINISTRATOR],
    template: '<support-page></support-page>'
  });
}]).name);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/entry.js






























































































































































































// EXTERNAL MODULE: ./core/xlr-ui/app/features/common/plumbing.js
var plumbing = __webpack_require__(273);

// CONCATENATED MODULE: ./core/xlr-ui/app/features/confirm-leave/directive/confirm-leave-directive.js
var confirmLeave = function confirmLeave(ConfirmLeaveService) {
  return {
    restrict: 'A',
    require: '?form',
    link: function link(scope, element, attrs, formCtrl) {
      var listener = scope.$watch(formCtrl ? "".concat(formCtrl.$name, ".$dirty") : '$ctrl.dataChanged', function (newVal) {
        if (newVal) {
          ConfirmLeaveService.requireConfirmation();
        } else {
          ConfirmLeaveService.disableConfirmation();
        }
      });
      scope.$on('$destroy', function () {
        listener();
        ConfirmLeaveService.disableConfirmation();
      });
    }
  };
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/confirm-leave/directive/index.js

var confirmLeaveDirective = ['ConfirmLeaveService', confirmLeave];
// EXTERNAL MODULE: ./core/xlr-ui/app/features/confirm-leave/modal-component/confirm-leave-modal.less
var confirm_leave_modal = __webpack_require__(1441);

// CONCATENATED MODULE: ./core/xlr-ui/app/features/confirm-leave/modal-component/confirm-leave-modal-tpl.html
/* harmony default export */ var confirm_leave_modal_tpl = ("<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"$ctrl.dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\" /></button>\n        <h4 class=\"modal-title\">Confirm leave</h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>Edits are not saved. Are you sure you want to leave?</p>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button continue primary\" ng-click=\"$ctrl.close({$value: true})\">Leave</button>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/confirm-leave/modal-component/index.js


var confirmLeaveModalComponent = {
  bindings: {
    close: '&',
    dismiss: '&'
  },
  template: confirm_leave_modal_tpl
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/confirm-leave/service/confirm-leave-service.js



var confirm_leave_service_ConfirmLeaveService = /*#__PURE__*/function () {
  function ConfirmLeaveService($q, $window, $uibModal) {
    classCallCheck_default()(this, ConfirmLeaveService);

    this._$q = $q;
    this._$window = $window;
    this._$uibModal = $uibModal;
    this._requireConfirmation = false;
    this._onBeforeUnload = _.constant('Edits are not saved. Are you sure you want to leave?');
  }

  createClass_default()(ConfirmLeaveService, [{
    key: "isConfirmationRequired",
    value: function isConfirmationRequired() {
      return this._requireConfirmation;
    }
  }, {
    key: "requireConfirmation",
    value: function requireConfirmation() {
      this._requireConfirmation = true;
      this._$window.onbeforeunload = this._onBeforeUnload;
    }
  }, {
    key: "disableConfirmation",
    value: function disableConfirmation() {
      this._requireConfirmation = false;
      this._$window.onbeforeunload = undefined;
    }
  }, {
    key: "openConfirmationDialog",
    value: function openConfirmationDialog() {
      var _this = this;

      var deferred = this._$q.defer();

      var modal = this._$uibModal.open({
        animation: false,
        component: 'confirmLeaveModal',
        windowClass: 'confirm-leave-modal'
      });

      modal.result.then(function (confirmedLeave) {
        if (confirmedLeave) {
          _this.disableConfirmation();

          deferred.resolve();
        } else {
          deferred.reject();
        }
      }, function (canceledLeave) {
        deferred.reject();
      });
      return deferred.promise;
    }
  }]);

  return ConfirmLeaveService;
}();


// CONCATENATED MODULE: ./core/xlr-ui/app/features/confirm-leave/service/index.js

confirm_leave_service_ConfirmLeaveService.$inject = ['$q', '$window', '$uibModal'];

// CONCATENATED MODULE: ./core/xlr-ui/app/features/confirm-leave/index.js



/* harmony default export */ var confirm_leave = (angular.module('xlrelease.modals', []).directive('confirmLeave', confirmLeaveDirective).component('confirmLeaveModal', confirmLeaveModalComponent).service('ConfirmLeaveService', confirm_leave_service_ConfirmLeaveService).name);
// EXTERNAL MODULE: ./core/xlr-ui/app/partials/items-count/items-count-tpl.html
var items_count_tpl = __webpack_require__(268);

// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/release-overview-controller.js






var release_overview_controller_ReleaseOverviewController = /*#__PURE__*/function () {
  function ReleaseOverviewController(filterSettings, ClientSettings, $scope, Events, $location, $window, ReleasesService, TasksService, ViewStorage, Authenticator, $uibModal, $ngRedux, FiltersQueryParams, Download) {
    classCallCheck_default()(this, ReleaseOverviewController);

    this.filters = filterSettings;
    this._ClientSettings = ClientSettings;
    this._$scope = $scope;
    this._Events = Events;
    this._$location = $location;
    this._$window = $window;
    this._ReleasesService = ReleasesService;
    this._TasksService = TasksService;
    this._ViewStorage = ViewStorage;
    this.security = Authenticator;
    this._Download = Download;
    /* ngRedux will merge the requested state's slice and actions onto this,
     you don't need to redefine them in your controller */

    this._unsubscribe = $ngRedux.connect(this._mapStateToThis, this._mapDispatchToThis.call(this, $uibModal))(this);
    this._FiltersQueryParams = FiltersQueryParams;
    this.itemsCountTemplate = items_count_tpl["a" /* default */];
  }

  createClass_default()(ReleaseOverviewController, [{
    key: "$onInit",
    value: function $onInit() {
      this.isLoad = true;

      this._resetSelectedStatuses(this.filters.onlyArchived);

      this._$scope.$emit(this._Events.permission.refresh);
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this._unsubscribe();
    }
  }, {
    key: "_mapDispatchToThis",
    value: function _mapDispatchToThis(uibModalService) {
      var _this = this;

      return function (dispatch) {
        return {
          loadMoreReleases: function loadMoreReleases() {
            return dispatch(getMoreReleases());
          },
          updateFilters: function updateFilters(filters) {
            return dispatch(setFilters(filters, true, _this.isLoad));
          },
          start: function start() {
            return dispatch(startReleases(uibModalService));
          },
          abort: function abort(abortComment) {
            return dispatch(release_overview_actions_abortReleases(uibModalService), abortComment);
          },
          group: function group() {
            return dispatch(groupReleases(uibModalService, _this.selectedReleases));
          },
          unSelectAll: function unSelectAll() {
            return dispatch(release_overview_actions_unSelectAll());
          },
          toggleRelease: function toggleRelease($event, $index, releaseId) {
            return dispatch(release_overview_actions_toggleRelease($event, $index, releaseId));
          },
          toggleSelectAll: function toggleSelectAll() {
            return dispatch(release_overview_actions_toggleSelectAll());
          }
        };
      };
    } // Which part of the Redux global state does our component want to receive?

  }, {
    key: "_mapStateToThis",
    value: function _mapStateToThis(state) {
      var reducer = state.releaseOverview;
      return {
        releases: reducer.releases,
        itemsCount: reducer.itemsCount,
        loading: reducer.loading,
        hasMoreReleases: reducer.hasMoreReleases,
        allowedActions: reducer.allowedActions,
        riskConfig: reducer.riskConfig,
        selectingAll: reducer.selectingAll,
        selectedReleases: reducer.selectedReleases,
        filters: reducer.filters.toJS(),
        allTags: reducer.allTags.toJS(),
        isBulkActionExecuting: reducer.isBulkActionExecuting
      };
    }
  }, {
    key: "filtersChanged",
    value: function filtersChanged(filters) {
      this._$scope.$emit(this._Events.permission.refresh);

      this.updateFilters(filters);

      this._resetSelectedStatuses(filters.onlyArchived);

      this.isLoad = false;
    }
  }, {
    key: "isActive",
    value: function isActive(order) {
      var search = this._$location.search();

      return search.order && search.order === order;
    }
  }, {
    key: "isExportEnabled",
    value: function isExportEnabled() {
      return this.selectedReleases.size <= 50;
    }
  }, {
    key: "_resetSelectedStatuses",
    value: function _resetSelectedStatuses(onlyArchived) {
      this.statuses = onlyArchived ? ReleaseStatuses.filter(function (s) {
        return s.label === 'Completed' || s.label === 'Aborted';
      }) : ReleaseStatuses;
    }
  }, {
    key: "goBackToCalendar",
    value: function goBackToCalendar() {
      this._$location.url('/calendar');
    }
  }, {
    key: "isActionEnabled",
    value: function isActionEnabled(action) {
      return this.allowedActions.get(action) && !(this.isBulkActionExecuting || this.selectingAll && this.loading);
    }
  }, {
    key: "getDisabledActionTooltip",
    value: function getDisabledActionTooltip(action) {
      return !this.allowedActions.get(action) ? "Due to the status of your selected releases, you can not perform this action" : "";
    }
  }, {
    key: "cameFromCalendar",
    get: function get() {
      return this._$location.search().fromCalendar;
    }
  }, {
    key: "hasAutomatedTaskInProgress",
    get: function get() {
      return this._ReleasesService.hasAutomatedTaskInProgress();
    }
  }, {
    key: "isHeaderExpanded",
    get: function get() {
      var layout = this._ClientSettings.getReleaseFiltersLayout();

      return layout ? layout.expanded : false;
    }
  }, {
    key: "isAnyReleaseSelected",
    get: function get() {
      return !this.selectedReleases.isEmpty();
    }
  }]);

  return ReleaseOverviewController;
}();

release_overview_controller_ReleaseOverviewController.$inject = ['filterSettings', 'ClientSettings', '$scope', 'Events', '$location', '$window', 'ReleasesService', 'TasksService', 'ViewStorage', 'Authenticator', '$uibModal', '$ngRedux', 'FiltersQueryParams', 'Download'];
/* harmony default export */ var release_overview_controller = (release_overview_controller_ReleaseOverviewController);
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/release-overview-tpl.html
/* harmony default export */ var release_overview_tpl = ("<div id=\"releases\" ng-class=\"{'header-expanded': $ctrl.isHeaderExpanded}\">\n    <div id=\"releases-header\" class=\"header\">\n        <div class=\"actions\">\n            <filter class=\"filter-release\" filters=\"$ctrl.filters\" on-change=\"$ctrl.filtersChanged(filters)\">\n                <div class=\"filter-release-basic\">\n                    <button type=\"button\" class=\"button back-to-calendar\" ng-if=\"$ctrl.cameFromCalendar\" tooltip=\"'Back to Calendar'\"\n                            ng-click=\"$ctrl.goBackToCalendar()\">\n                        <i class=\"xl-icon back-icon\"></i> Back\n                    </button>\n                    <search-filter class=\"filter first\" layout=\"'Release'\"></search-filter>\n                    <span class=\"filter-bulk\" ng-if=\"!$ctrl.isAnyReleaseSelected\">\n                        <date-filter class=\"filter\"></date-filter>\n                        <ci-filter-status statuses=\"$ctrl.statuses\"></ci-filter-status>\n                        <div class=\"button-group filter\">\n                            <button-toggle-filter class=\"only-archived\" filter=\"'onlyArchived'\" title=\"Archived\">\n                                <span class=\"button-toggle-filter-icon xl-icon archive-icon\"></span> Archived\n                            </button-toggle-filter>\n                            <button-toggle-filter class=\"only-flagged\" filter=\"'onlyFlagged'\" title=\"Flagged\">\n                                <span class=\"button-toggle-filter-icon xl-icon flag-none-icon\"></span> Flagged\n                            </button-toggle-filter>\n                            <button-toggle-filter class=\"only-mine\" filter=\"'onlyMine'\" title=\"My Releases\">\n                                <span class=\"button-toggle-filter-icon xl-icon user-icon\"></span> My Releases\n                            </button-toggle-filter>\n                        </div>\n                        <order-by-filter class=\"filter last\"></order-by-filter>\n                    </span>\n                    <div class=\"buttons\">\n                        <span class=\"pull-right unselect-all\" ng-if=\"$ctrl.isAnyReleaseSelected\">\n                            <span ng-pluralize\n                            count=\"$ctrl.selectedReleases.size\"\n                            when=\"{'1': '{} release', 'other': '{} releases', 'few': '{} releases', 'many': '{} releases'}\"></span> selected\n                            <button title=\"Unselect all\" class=\"actions-bar-clear xl-icon close-icon\" ng-click=\"$ctrl.unSelectAll()\"></button>\n                        </span>\n                        <span class=\"pull-right filter-all\" ng-if=\"!$ctrl.isAnyReleaseSelected && !$ctrl.filters.onlyArchived && $ctrl.itemsCount.live.total > 0\"\n                            bs-tooltip placement=\"bottom\" template=\"{{$ctrl.itemsCountTemplate}}\">\n                            <span ng-pluralize\n                            count=\"$ctrl.itemsCount.live.total\"\n                            when=\"{'1': '{} release', 'other': '{} releases', 'few': '{} releases', 'many': '{} releases'}\" style=\"font-weight: bold\"></span>\n                        </span>\n                        <span class=\"pull-right filter-all\" ng-if=\"!$ctrl.isAnyReleaseSelected && $ctrl.filters.onlyArchived && $ctrl.itemsCount.archived.total > 0\"\n                                  bs-tooltip placement=\"bottom\" template=\"{{$ctrl.itemsCountTemplate}}\">\n                             <span ng-pluralize\n                                   count=\"$ctrl.itemsCount.archived.total\"\n                                   when=\"{'1': '{} release', 'other': '{} releases', 'few': '{} releases', 'many': '{} releases'}\" style=\"font-weight: bold\"></span>\n                        </span>\n                        <a ng-if=\"$ctrl.security.hasPermission('release#create') && !$ctrl.isAnyReleaseSelected\" ng-href=\"#/releases/create\" class=\"button primary new-release\">New release</a>\n                        <span ng-if=\"$ctrl.isAnyReleaseSelected\">\n                            <button class=\"button\" ng-disabled=\"!$ctrl.isActionEnabled('start')\"\n                            title=\"{{$ctrl.getDisabledActionTooltip('start')}}\" ng-click=\"$ctrl.start()\">Start</button>\n                            <button class=\"button\" ng-disabled=\"!$ctrl.isActionEnabled('abort')\"\n                            title=\"{{$ctrl.getDisabledActionTooltip('abort')}}\" ng-click=\"$ctrl.abort()\">Abort</button>\n                            <button class=\"button\" ng-disabled=\"!$ctrl.isActionEnabled('group')\"\n                            ng-click=\"$ctrl.group()\">Add to group</button>\n                        </span>\n                        <span doc-icon=\"release-overview.html\"></span>\n                    </div>\n\n                </div>\n                <div class=\"filter-release-advanced\" ng-if=\"$ctrl.isHeaderExpanded\">\n                    <span class=\"filter first\">\n                        <label class=\"filter-title\" for=\"title-filter\">Title</label> <text-filter element-id=\"'title-filter'\" field=\"'title'\" focus-on=\"$ctrl.isHeaderExpanded\"></text-filter>\n                    </span>\n                    <span class=\"filter last\">\n                        <label class=\"filter-title\">Tags</label> <tag-filter all-tags=\"$ctrl.allTags\" class=\"tags-input\"></tag-filter>\n                    </span>\n                </div>\n            </filter>\n        </div>\n        <releases-sub-header releases=\"$ctrl.releases\"\n            selected-releases=\"$ctrl.selectedReleases\"\n            is-selecting-all=\"$ctrl.selectingAll\"\n            filters=\"$ctrl.filters\"\n            allowed-actions=\"$ctrl.allowedActions\"\n            on-toggle-select-all=\"$ctrl.toggleSelectAll()\"\n            class=\"releases-sub-header-container\">\n        </releases-sub-header>\n    </div>\n\n    <div class=\"release-list\">\n        <xlr-release-list releases=\"$ctrl.releases\"\n                          releases-loading-status=\"$ctrl.loading\"\n                          releases-has-more=\"$ctrl.hasMoreReleases\"\n                          on-refresh=\"$ctrl.filtersChanged($ctrl.filters)\"\n                          on-show-more-releases=\"$ctrl.loadMoreReleases()\"\n                          on-toggle-release=\"$ctrl.toggleRelease($event, $index, releaseId)\"\n                          selected-releases=\"$ctrl.selectedReleases\"\n                          allowed-actions=\"$ctrl.allowedActions\"\n                          risk-config=\"$ctrl.riskConfig\">\n        </xlr-release-list>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/release-list/release-list-controller.js



var release_list_controller_ReleaseListController = /*#__PURE__*/function () {
  function ReleaseListController() {
    classCallCheck_default()(this, ReleaseListController);
  }

  createClass_default()(ReleaseListController, [{
    key: "reloadReleases",
    value: function reloadReleases() {
      this.onRefresh();
    }
  }, {
    key: "showMore",
    value: function showMore() {
      this.onShowMoreReleases();
    }
  }, {
    key: "toggleRelease",
    value: function toggleRelease($event, $index, releaseId) {
      this.onToggleRelease({
        $event: $event,
        $index: $index,
        releaseId: releaseId
      });
    }
  }, {
    key: "isReleaseSelected",
    value: function isReleaseSelected(releaseId) {
      return this.selectedReleases.has(releaseId);
    }
  }, {
    key: "isAnyReleaseSelected",
    get: function get() {
      return !this.selectedReleases.isEmpty();
    }
  }]);

  return ReleaseListController;
}();


// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/release-list/release-list-tpl.html
/* harmony default export */ var release_list_tpl = ("<div id=\"releases-content\" class=\"content-under-header\">\n    <div class=\"row\" ng-show=\"$ctrl.releases.size\">\n        <div class=\"col-xs-12\">\n            <xlr-infinite-scroll-wrapper\n                    on-show-more=\"$ctrl.showMore()\"\n                    disable-when=\"!$ctrl.releasesHasMore || $ctrl.releasesLoadingStatus\"\n                    show-loader-when=\"$ctrl.releasesLoadingStatus\">\n                <div ng-repeat=\"release in $ctrl.releases.toJS()\"\n                     class=\"row release-row releases-list-loaded\"\n                     xlr-infinite-scroll>\n                    <div class=\"risk-line\"></div>\n                    <xlr-release-row\n                            release=\"release\"\n                            on-refresh=\"$ctrl.reloadReleases()\"\n                            is-selected=\"$ctrl.isReleaseSelected(release.id)\"\n                            toggle-release=\"$ctrl.toggleRelease($event, $index, release.id)\"\n                            show-select-checkbox=\"$ctrl.isAnyReleaseSelected\"\n                            allowed-actions=\"$ctrl.allowedActions\"\n                            risk-config=\"$ctrl.riskConfig\">\n                    </xlr-release-row>\n                </div>\n\n            </xlr-infinite-scroll-wrapper>\n        </div>\n    </div>\n    <div class=\"alert notice releases-list-loaded\" ng-show=\"!$ctrl.releasesLoadingStatus && !$ctrl.releases.size\">No releases found.</div>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/release-list/index.js


var releaseListComponent = {
  bindings: {
    releases: '<',
    releasesLoadingStatus: '<',
    releasesHasMore: '<',
    onRefresh: '&',
    onShowMoreReleases: '&',
    onToggleRelease: '&',
    selectedReleases: '<',
    allowedActions: '<',
    riskConfig: '<'
  },
  controller: release_list_controller_ReleaseListController,
  template: release_list_tpl
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/release-row/risk-bubble-tpl.html
/* harmony default export */ var risk_bubble_tpl = ("<div class=\"popover\" ng-class=\"vm.getRiskStatus()\">\n    <h3 class=\"popover-title row\">\n        <div class=\"pull-left\">\n            <span class=\"status\">{{vm.getRiskStatus().replace('-', ' ')}}</span>\n            <span> - {{vm.riskSummary}} </span>\n        </div>\n        <div class=\"pull-right\">\n            <span ng-if=\"!!vm.getRiskScore(vm.riskScore)\" class=\"risk-bubble-score\" ng-click=\"vm.goToReleaseSummary()\">\n                Risk score {{vm.riskScore}}\n            </span>\n        </div>\n    </h3>\n    <div class=\"popover-content\" ng-if=\"vm.riskLoading\">\n        <img class=\"spinner\" src=\"static/9.7.16/styles/img/big-ajax-loader.gif\" alt=\"Loading...\"/>\n        <span class=\"spinner-text\">Loading...</span>\n    </div>\n    <div class=\"popover-content\" >\n        <div ng-class=\"{'margin-10': !$last}\" ng-repeat=\"riskMessage in vm.riskMessages track by $index\" ng-switch=\"vm.isPlanItemOverdueMessage(riskMessage)\">\n            <div class=\"risk-message-line\" ng-switch-when=\"false\">\n                <span ng-if=\"!riskMessage.icon\" class=\"xl-icon\" ng-class=\"vm.getRiskMessageIconClasses(riskMessage)\"></span>\n                <div ng-if=\"riskMessage.icon\" class=\"assessment-custom-icon\"><img ng-src=\"{{riskMessage.icon}}\"/></div>\n                <p class=\"riskMessageText\" display-variables=\"riskMessage.message\" variables=\"vm.release.variables\" markdown=\"true\"></p>\n            </div>\n            <plan-item-overdue-message ng-switch-default message=\"riskMessage.message\"/>\n        </div>\n\n        <span ng-show=\"vm.hasMoreRisks\" ng-click=\"vm.onShowMoreRisks()\" class=\"center-block more-link\">\n            Show all {{vm.allRiskMessages.length}} warnings\n        </span>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/release-row/release-row-controller.js







var release_row_controller_ReleaseRowController = /*#__PURE__*/function () {
  function ReleaseRowController(Authenticator, ReleasesService, DateService, ViewStorage, $location, $ngRedux, Ids) {
    classCallCheck_default()(this, ReleaseRowController);

    this._releaseService = ReleasesService;
    this._dateService = DateService;
    this._security = Authenticator;
    this._viewStorage = ViewStorage;
    this._location = $location;
    this._Ids = Ids;
    this.riskBubbleTemplate = risk_bubble_tpl;
    this.showPipeline = false;
    this._unsubscribe = $ngRedux.connect(this._mapStateToThis, this._mapDispatchToThis.bind(this))(this);
  }

  createClass_default()(ReleaseRowController, [{
    key: "$onInit",
    value: function $onInit() {
      var abortAction = null;

      if (this.isStartActionAvailable()) {
        abortAction = {
          title: 'Abort',
          modalTemplate: 'partials/releases/abort-release-modal-context-menu.html',
          data: {
            ctrl: this
          }
        };
      }

      var groupAction = {
        title: 'Add to group',
        modal: 'addReleaseToReleaseGroupModal',
        disabled: false,
        data: {
          releases: [this.release.id]
        }
      };
      this.contextMenuItems = abortAction ? [abortAction, groupAction] : [groupAction];
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this._unsubscribe();
    }
  }, {
    key: "_mapDispatchToThis",
    value: function _mapDispatchToThis(dispatch) {
      var _this = this;

      return {
        getRisks: function getRisks() {
          return dispatch(release_overview_actions_getRisks(_this._Ids.toDomainId(_this.release.id)));
        }
      };
    } // Which part of the Redux global state does our component want to receive?

  }, {
    key: "_mapStateToThis",
    value: function _mapStateToThis(state) {
      var reducer = state.releaseOverview;
      return {
        riskSummary: reducer.riskSummary,
        riskMessages: reducer.riskMessages.toJS().slice(0, 7),
        riskLoading: reducer.riskLoading,
        allRiskMessages: reducer.riskMessages.toJS(),
        hasMoreRisks: reducer.riskMessages.size >= 8,
        riskScore: reducer.riskScore
      };
    }
  }, {
    key: "togglePipeline",
    value: function togglePipeline() {
      this.showPipeline = !this.showPipeline;
    }
  }, {
    key: "calculateDuration",
    value: function calculateDuration() {
      var start = this._dateService.getStartOrScheduledDate(this.release);

      var end = this._dateService.getEndOrDueDate(this.release);

      if (start && end && end >= start) {
        return end - start;
      }

      return null;
    }
  }, {
    key: "onStart",
    value: function onStart() {
      this._releaseService.startRelease(this.release).then(this.onRefresh);
    }
  }, {
    key: "onAbort",
    value: function onAbort(abortComment) {
      this._releaseService.abortRelease(this.release, abortComment).then(this.onRefresh);
    }
  }, {
    key: "getReleaseEditorURL",
    value: function getReleaseEditorURL() {
      return "#".concat(this._viewStorage.getView(this.release.id, '/releases/' + this.release.id));
    }
  }, {
    key: "getRiskScore",
    value: function getRiskScore(score) {
      if (score) {
        return parseInt(score);
      }

      return parseInt(this.release.syntheticProperties.riskScore);
    }
  }, {
    key: "getRiskStatus",
    value: function getRiskStatus() {
      return risk_detector["b" /* getRiskStatus */](this.release, this.getRiskScore(), this.riskConfig);
    }
  }, {
    key: "getRiskMessageIconClasses",
    value: function getRiskMessageIconClasses(riskMessage) {
      return risk_detector["a" /* getRiskIconClasses */](riskMessage);
    }
  }, {
    key: "onShowMoreRisks",
    value: function onShowMoreRisks() {
      this.riskMessages = this.allRiskMessages;
      this.hasMoreRisks = false;
    }
  }, {
    key: "goToReleaseSummary",
    value: function goToReleaseSummary() {
      this._location.url("/releases/".concat(this.release.id, "/summary"));
    }
  }, {
    key: "isStartActionAvailable",
    value: function isStartActionAvailable() {
      return this._releaseService.isReleasePlanned(this.release) && this._security.hasPermission('release#start', this.release);
    }
  }, {
    key: "isAbortActionAvailable",
    value: function isAbortActionAvailable() {
      return this._security.hasPermission('release#abort', this.release) && !this._releaseService.isReleaseCompleted(this.release);
    }
  }, {
    key: "isPlanItemOverdueMessage",
    value: function isPlanItemOverdueMessage(message) {
      return risk_detector["g" /* isPlanItemOverdueMessage */](message);
    }
  }, {
    key: "isInsideFolder",
    value: function isInsideFolder() {
      return this.release.id.includes('Folder');
    }
  }, {
    key: "isRiskBubbleEnabled",
    value: function isRiskBubbleEnabled() {
      return this.getRiskStatus() !== 'none';
    }
  }, {
    key: "isReleaseInProgress",
    value: function isReleaseInProgress() {
      return this._releaseService.isReleaseInProgress(this.release);
    }
  }, {
    key: "isReleaseFailing",
    value: function isReleaseFailing() {
      return this._releaseService.isReleaseFailing(this.release);
    }
  }, {
    key: "isReleasePaused",
    value: function isReleasePaused() {
      return this._releaseService.isReleasePaused(this.release);
    }
  }, {
    key: "isReleaseFailed",
    value: function isReleaseFailed() {
      return this._releaseService.isReleaseFailed(this.release);
    }
  }, {
    key: "isReleasePlanned",
    value: function isReleasePlanned() {
      return this._releaseService.isReleasePlanned(this.release);
    }
  }, {
    key: "isReleaseAborted",
    value: function isReleaseAborted() {
      return this._releaseService.isReleaseAborted(this.release);
    }
  }, {
    key: "hasCompletedStatus",
    value: function hasCompletedStatus() {
      return this._releaseService.hasCompletedStatus(this.release);
    }
  }, {
    key: "isReleaseArchived",
    value: function isReleaseArchived() {
      return this._releaseService.isReleaseArchived(this.release);
    }
  }, {
    key: "isAtRisk",
    value: function isAtRisk() {
      return risk_detector["c" /* isAtRisk */](this.release, this.getRiskScore(), this.riskConfig);
    }
  }, {
    key: "isAttentionNeeded",
    value: function isAttentionNeeded() {
      return risk_detector["d" /* isAttentionNeeded */](this.release, this.getRiskScore(), this.riskConfig);
    }
  }, {
    key: "isOnTrack",
    value: function isOnTrack() {
      return risk_detector["f" /* isOnTrack */](this.release, this.getRiskScore(), this.riskConfig);
    }
  }, {
    key: "isOverdue",
    value: function isOverdue(date) {
      return this._dateService.isOverdue(date);
    }
  }]);

  return ReleaseRowController;
}();

defineProperty_default()(release_row_controller_ReleaseRowController, "$inject", ['Authenticator', 'ReleasesService', 'DateService', 'ViewStorage', '$location', '$ngRedux', 'Ids']);


// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/release-row/release-row-tpl.html
/* harmony default export */ var release_row_tpl = ("<div class=\"col-xs-1\" ng-class=\"{'flag-margin': vm.release.flag.status != 'OK'}\">\n    <div class=\"checkbox-wrapper\">\n\n        <input aria-label=\"Select this release\" type=\"checkbox\" ng-click=\"vm.toggleRelease({$event})\" class=\"release-bulk-checkbox\"\n               ng-checked=\"vm.isSelected()\"\n               >\n    </div>\n    <div class=\"risk-status {{vm.getRiskStatus()}}\"\n         bs-popover\n         bs-show=\"xlrPopoverTrigger\"\n         bs-enabled=\"vm.isRiskBubbleEnabled()\"\n         placement=\"right-bottom\"\n         trigger=\"manual\"\n         delay=\"500,100\"\n         container=\"body\"\n         template=\"{{vm.riskBubbleTemplate}}\"\n         auto-close=\"true\"\n         bs-on-before-show=\"vm.getRisks\"\n         xlr-popover-trigger>\n         <i ng-class=\"{'xl-icon circle-cross-icon icon-xl': vm.isAtRisk(), 'xl-icon circle-exclamation-icon icon-xl': vm.isAttentionNeeded(),\n             'xl-icon circle-check-icon icon-xl': vm.isOnTrack() || vm.hasCompletedStatus() || vm.isReleaseAborted()}\"></i>\n    </div>\n</div>\n<div class=\"col-xs-11 raised-link-wrapper\">\n    <div class=\"release flagged_{{ vm.release.flag.status | lowercase }}\">\n        <div class=\"release-line\">\n            <div class=\"row\">\n                <div class=\"row-wrapper\">\n                    <a tabindex=\"-1\" aria-label=\"{{vm.release.title}}\" class=\"col-xs-6 raised-link\" ng-href=\"{{vm.getReleaseEditorURL()}}\"></a>\n                    <div class=\"col-xs-3 release-title-wrapper\">\n                        <a ng-href=\"{{vm.getReleaseEditorURL()}}\"><strong class=\"release-title raised-link-target\">{{vm.release.title}}</strong></a>\n                        <span ng-show=\"vm.release.currentPhase.length\">-</span>\n                        <span class=\"phase-title\" display-variables=\"vm.release.currentPhase\" variables=\"vm.release.variables\"></span>\n                        <folder-path ci=\"vm.release\"></folder-path>\n                    </div>\n\n                    <div class=\"col-xs-9\">\n                        <div class=\"row\">\n                            <div class=\"col-xs-2\">\n                                <release-status-label release=\"vm.release\" show-archived=\"true\"></release-status-label>\n                            </div>\n                            <div class=\"col-xs-2\">\n                                <release-progress-bar progress=\"vm.release.extensions.progress\"></release-progress-bar>\n                            </div>\n                            <div class=\"col-xs-2 text-centered calendar-link\">\n                                <span ng-if=\"!vm.release.startDate\" ng-class=\"{'date-overdue': vm.isOverdue(vm.release.scheduledStartDate)}\">\n                                    <a ng-href=\"#/calendar?month={{vm.release.scheduledStartDate | date:'MM-yyyy'}}\" stop-click-propagation>{{vm.release.scheduledStartDate | date:'short'}}</a>\n                                </span>\n                                <span ng-if=\"vm.release.startDate\">\n                                    <a ng-href=\"#/calendar?month={{vm.release.startDate | date:'MM-yyyy'}}\" stop-click-propagation>{{vm.release.startDate | date:'short'}}</a>\n                                </span>\n\n                                <span ng-if=\"vm.isReleasePlanned() && vm.release.autoStart\" class=\"timer-icon\"/>\n                            </div>\n                            <div class=\"col-xs-2 text-centered calendar-link\">\n                                <span ng-if=\"!vm.release.endDate\" ng-class=\"{'date-overdue': vm.isOverdue(vm.release.dueDate)}\">\n                                    <a ng-href=\"#/calendar?month={{vm.release.dueDate | date:'MM-yyyy'}}\" stop-click-propagation>{{vm.release.dueDate | date:'short'}}</a>\n                                </span>\n                                <span ng-if=\"vm.release.endDate\">\n                                    <a ng-href=\"#/calendar?month={{vm.release.endDate | date:'MM-yyyy'}}\" stop-click-propagation>{{vm.release.endDate | date:'short'}}</a>\n                                </span>\n                            </div>\n                            <div class=\"col-xs-2 text-centered duration\">\n                                <span>{{vm.calculateDuration() | prettyDuration}}</span>\n                            </div>\n                            <div class=\"col-xs-2\">\n                                <div ng-if=\"!vm.showSelectCheckbox\" class=\"row release-actions\">\n                                    <div class=\"col-xs-7\">\n                                        <div ng-if=\"vm.isStartActionAvailable()\" class=\"link\"\n                                             scope-less-modal=\"'partials/releases/start-release-modal-ctrl-binding.html'\" ctrl=\"vm\">\n                                            <i class=\"xl-icon play-icon start\"></i> Start\n                                        </div>\n\n                                        <div ng-if=\"vm.isAbortActionAvailable() && !vm.isStartActionAvailable()\" class=\"link\"\n                                             scope-less-modal=\"'partials/releases/abort-release-modal-ctrl-binding.html'\" ctrl=\"vm\">\n                                            <i class=\"xl-icon cancel-icon\"></i> Abort\n                                        </div>\n                                    </div>\n\n                                    <div class=\"col-xs-5\">\n                                        <div class=\"link context-menu-button dropdown-button\" data-container=\"body\"\n                                             bs-popover data-content-template=\"partials/releases/context-menu.html\" data-placement=\"top\" auto-close=\"true\">\n                                            <i class=\"xl-icon options-icon\"></i>\n                                        </div>\n                                    </div>\n                                </div>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n                <span class=\"release-flag-line\" flag-line item=\"vm.release\"></span>\n            </div>\n            <div class=\"row\">\n                <div class=\"col-xs-12\" style=\"padding-left: 0;\" ng-if=\"vm.showPipeline\">\n                    <xlr-release-pipeline show=\"vm.showPipeline\" release-id=\"vm.release.id\"\n                                          phases-stat=\"vm.release.extensions.progress.phases\"\n                                          phases=\"vm.release.phases\"\n                                          variables=\"vm.release.variables\">\n                    </xlr-release-pipeline>\n                </div>\n            </div>\n        </div>\n    </div>\n    <xlr-release-pipeline-button ng-if=\"vm.release.extensions.progress\" active=\"vm.showPipeline\" ng-click=\"vm.togglePipeline()\"/>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/release-row/index.js


var releaseRowComponent = {
  bindToController: true,
  bindings: {
    release: '<',
    onRefresh: '&',
    isSelected: '&',
    toggleRelease: '&',
    showSelectCheckbox: '<',
    allowedActions: '<',
    riskConfig: '<'
  },
  controllerAs: 'vm',
  controller: release_row_controller_ReleaseRowController,
  template: release_row_tpl
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/release-progress/index.js


var HTML = "\n<div class=\"release-progress-bar\">\n    <span ng-style=\"{'left': $ctrl.percent/2 + '%'}\" class=\"percent-number\">{{$ctrl.percent}}%</span><span class=\"progress-text\"> complete</span>\n    <div class=\"bar-container\">\n        <div class=\"bar\" ng-style=\"{'width': $ctrl.percent +'%'}\"></div>\n    </div>\n</div>";

var release_progress_ReleaseProgressCtrl = /*#__PURE__*/function () {
  function ReleaseProgressCtrl() {
    classCallCheck_default()(this, ReleaseProgressCtrl);
  }

  createClass_default()(ReleaseProgressCtrl, [{
    key: "$onInit",
    value: function $onInit() {
      this._percent = 0;
      this.calculate();
    }
  }, {
    key: "$onChanges",
    value: function $onChanges() {
      this.calculate();
    }
  }, {
    key: "calculate",
    value: function calculate() {
      if (this.progress) {
        var totalTasks = this.progress.totalTasks;
        var totalRemainingTasks = this.progress.totalRemainingTasks;
        var tasksFinished = totalTasks - totalRemainingTasks;
        this.percent = tasksFinished === 0 ? 0 : Math.round(tasksFinished * 100 / totalTasks);
      } else if (this.calculatedPercent) {
        this.percent = this.calculatedPercent;
      }
    }
  }, {
    key: "percent",
    get: function get() {
      return this._percent;
    },
    set: function set(percent) {
      this._percent = percent;
    }
  }]);

  return ReleaseProgressCtrl;
}();

release_progress_ReleaseProgressCtrl.$inject = [];
var releaseProgressComponent = {
  controller: release_progress_ReleaseProgressCtrl,
  template: HTML,
  bindings: {
    progress: '<',
    calculatedPercent: '<'
  }
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/release-pipeline/scroll-container-directive.js
function linkFn(scope, element, attr) {
  var PHASE_PADDING = 10;
  var PHASE_WIDTH_WITHOUT_PADDING = 176;
  var PHASE_WIDTH = PHASE_WIDTH_WITHOUT_PADDING + PHASE_PADDING;
  var container = scope.$eval(attr.container);
  var leftArrow = element.find('.scroll-arrow-left');
  var rightArrow = element.find('.scroll-arrow-right');

  var calculateVisiblePhaseCount = function calculateVisiblePhaseCount() {
    return Math.floor(element.width() / PHASE_WIDTH_WITHOUT_PADDING);
  };

  var visiblePhasesCount = calculateVisiblePhaseCount();
  var amountOfPhases = container.phasesSize;
  var amountOfPages = Math.round(amountOfPhases / visiblePhasesCount);
  var currentPage = 0;

  var recalculatePhases = function recalculatePhases() {
    amountOfPhases = container.phasesSize;
    amountOfPages = Math.round(amountOfPhases / visiblePhasesCount);
  };

  var resetView = function resetView() {
    element.scrollLeft(0);
    visiblePhasesCount = calculateVisiblePhaseCount();
    currentPage = 0;
    setTooltipText();
  };

  var setTooltipText = function setTooltipText() {
    recalculatePhases();
    var rightCount = Math.max(0, amountOfPhases - visiblePhasesCount * (currentPage + 1));
    var leftCount = Math.min(amountOfPhases - visiblePhasesCount, Math.max(0, visiblePhasesCount * currentPage));

    if (rightCount > 0) {
      rightArrow.show();
    } else {
      rightArrow.hide();
    }

    if (leftCount > 0) {
      leftArrow.show();
    } else {
      leftArrow.hide();
    }

    var message = function message(n) {
      return "See ".concat(n, " more");
    };

    container.left = leftCount > 1 ? "".concat(message(leftCount), " phases") : "".concat(message(leftCount), " phase");
    container.right = rightCount > 1 ? "".concat(message(rightCount), " phases") : "".concat(message(rightCount), " phase");
  };

  var scrollToPage = function scrollToPage(pageNumber) {
    return pageNumber * PHASE_WIDTH * visiblePhasesCount + 5;
  };

  var animationConfig = {
    duration: 500,
    easing: "swing"
  };
  rightArrow.on('click', function (event) {
    currentPage = Math.min(amountOfPages, currentPage + 1);
    setTooltipText();
    element.animate({
      scrollLeft: scrollToPage(currentPage)
    }, animationConfig);
    event.preventDefault();
  });
  leftArrow.on('click', function (event) {
    currentPage = Math.max(0, currentPage - 1);
    setTooltipText();

    if (currentPage === 0) {
      element.animate({
        scrollLeft: 0
      });
    } else {
      element.animate({
        scrollLeft: scrollToPage(currentPage)
      }, animationConfig);
    }

    event.preventDefault();
  });

  var listener = function listener() {
    scope.$apply(function () {
      resetView();
    });
  };

  scope.$on('$destroy', function () {
    rightArrow.unbind('click');
    leftArrow.unbind('click');
    window.removeEventListener("resize", listener);
  });
  scope.$on('phasesChanged', function () {
    setTooltipText();
  });
  window.addEventListener("resize", listener);
  resetView();
}

var directiveConf = {
  link: linkFn
};

function scrollContainerDirective() {
  return directiveConf;
}

/* harmony default export */ var scroll_container_directive = (scrollContainerDirective);
// EXTERNAL MODULE: ./core/xlr-ui/app/features/release-overview/release-pipeline/release-pipeline-component.less
var release_pipeline_component = __webpack_require__(1442);

// EXTERNAL MODULE: ./core/xlr-ui/app/features/release-overview/release-pipeline/release-pipeline-button.less
var release_pipeline_button = __webpack_require__(1443);

// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/release-pipeline/release-pipeline-controller.js





function release_pipeline_controller_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function release_pipeline_controller_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { release_pipeline_controller_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { release_pipeline_controller_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }


var release_pipeline_controller_mergePhasesAndStat = function mergePhasesAndStat(phase, stat, id) {
  var domainId = id(phase.id);
  var phaseStat = stat[domainId] || '0;0';

  var _phaseStat$split$map = phaseStat.split(';').map(function (v) {
    return parseInt(v);
  }),
      _phaseStat$split$map2 = slicedToArray_default()(_phaseStat$split$map, 2),
      totalTasks = _phaseStat$split$map2[0],
      tasksCompleted = _phaseStat$split$map2[1];

  return {
    title: phase.title,
    color: phase.color || colors["a" /* default */].blue,
    status: phase.status,
    totalTasks: totalTasks,
    tasksCompleted: tasksCompleted
  };
};

var mapPhaseToView = function mapPhaseToView(stat, fn) {
  return function (phase) {
    return release_pipeline_controller_mergePhasesAndStat(phase, stat, fn);
  };
};

var release_pipeline_controller_ReleasePipelineController = /*#__PURE__*/function () {
  function ReleasePipelineController(PhasesService, Ids, $location, $scope) {
    var _this = this;

    classCallCheck_default()(this, ReleasePipelineController);

    this.PhasesService = PhasesService;
    this.Ids = Ids;
    this.$location = $location;
    this.$scope = $scope;
    this.container = {
      phasesSize: 0,
      left: '',
      right: ''
    };

    this.decorateWithStatuses = function (phase) {
      return Object.assign({
        active: _this.PhasesService.isPhaseActive(phase),
        readOnly: _this.PhasesService.isPhaseReadOnly(phase),
        planned: _this.PhasesService.isPhasePlanned(phase)
      }, phase);
    };

    this.decorateColor = function (phase) {
      return Object.assign({
        color: _this.PhasesService.isPhaseReadOnly(phase) ? colors["a" /* default */].gray : phase.color
      }, phase);
    };
  }

  createClass_default()(ReleasePipelineController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      var collapsePhases = function collapsePhases(acc, val) {
        var phasesCounter = 1;

        if (val.readOnly && acc.length !== 0) {
          var first = acc[0];
          phasesCounter++;
          acc[0] = release_pipeline_controller_objectSpread({}, first, {
            title: "".concat(phasesCounter, " completed"),
            collapsed: true
          });
        } else {
          acc.push(val);
        }

        return acc;
      };

      this.showSummary = function () {
        return _this2.$location.url("/releases/".concat(_this2.releaseId, "/summary"));
      };

      this.phasesView = this.phases.map(mapPhaseToView(this.phasesStat, this.Ids.toDomainId)).map(this.decorateWithStatuses).map(this.decorateColor).reduce(collapsePhases, []);
      this.phaseSizeChanged();
    }
  }, {
    key: "phaseSizeChanged",
    value: function phaseSizeChanged() {
      this.container.phasesSize = this.phasesView.length;
      this.$scope.$broadcast('phasesChanged');
    }
  }, {
    key: "expand",
    value: function expand() {
      this.phasesView = this.phases.map(mapPhaseToView(this.phasesStat, this.Ids.toDomainId)).map(this.decorateWithStatuses).map(this.decorateColor);
      this.phaseSizeChanged();
    }
  }]);

  return ReleasePipelineController;
}();
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/release-pipeline/release-pipeline-tpl.html
/* harmony default export */ var release_pipeline_tpl = ("<div class=\"pipeline\" scroll-container-directive container=\"$ctrl.container\" ng-if=\"$ctrl.show\">\n    <i class=\"xl-icon chevron-left-icon scroll-arrow-left\" tooltip=\"$ctrl.container.left\"></i>\n    <div class=\"phase\" ng-repeat=\"phase in $ctrl.phasesView\" ng-class=\"{'done': phase.readOnly}\" ng-click=\"$ctrl.showSummary()\">\n        <div class=\"phase-body\">\n            <div class=\"arrow-active\" ng-if=\"phase.active\"><i class=\"arrow-orange-right\"></i></div>\n            <div class=\"phase-header\" ng-style=\"{'border-top-color': phase.color}\">\n                <div class=\"phase-title\">\n                    <span display-variables=\"phase.title\" variables=\"$ctrl.variables\"></span>\n                </div>\n            </div>\n            <div class=\"phase-content\">\n                <span ng-if=\"phase.active\">\n                      <span>{{ phase.tasksCompleted }}/{{ phase.totalTasks }}</span> tasks completed\n                </span>\n                <span ng-if=\"phase.readOnly && !phase.collapsed\"\n                      ng-pluralize count=\"phase.totalTasks\" when=\"{'0': '{} tasks completed', '1': '1 task completed', 'other': '{} tasks completed', 'many': '{} tasks completed', 'few': '{} tasks completed'}\"></span>\n\n                <span ng-if=\"phase.collapsed\" ng-click=\"$ctrl.expand()\" class=\"collapse-details\">View all completed phases</span>\n\n                <span ng-if=\"phase.planned\"\n                      ng-pluralize count=\"phase.totalTasks\" when=\"{'0': '{} tasks planned', '1': '1 task planned', 'other': '{} tasks planned', 'many': '{} tasks planned', 'few': '{} tasks planned'}\"></span>\n            </div>\n        </div>\n    </div>\n    <i class=\"xl-icon chevron-right-icon scroll-arrow-right\" tooltip=\"$ctrl.container.right\"></i>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/release-pipeline/release-pipeline-button-tpl.html
/* harmony default export */ var release_pipeline_button_tpl = ("<div class=\"pipeline-button-container\">\n        <div class=\"pipeline-button\">\n            <i ng-if=\"!$ctrl.active\" class=\"xl-icon chevron-down-icon icon-s pipeline-chevron\"></i>\n            <i ng-if=\"$ctrl.active\" class=\"xl-icon chevron-up-icon icon-s pipeline-chevron\"></i>\n        </div>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/release-pipeline/index.js





release_pipeline_controller_ReleasePipelineController.$inject = ['PhasesService', 'Ids', '$location', '$scope'];
var releasePipelineComponent = {
  bindings: {
    show: '=',
    phasesStat: '=',
    phases: '=',
    variables: '<',
    releaseId: '<'
  },
  controller: release_pipeline_controller_ReleasePipelineController,
  template: release_pipeline_tpl
};
var releasePipelineButtonComponent = {
  bindings: {
    active: '<'
  },
  controller: _.noop,
  template: release_pipeline_button_tpl
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/popover-trigger/popover-trigger.js

var popover_trigger_popoverTrigger = function popoverTrigger($timeout) {
  return {
    restrict: 'A',
    link: function link(scope, element, attrs) {
      var _attrs$delay$split = attrs.delay.split(','),
          _attrs$delay$split2 = slicedToArray_default()(_attrs$delay$split, 2),
          showDelay = _attrs$delay$split2[0],
          hideDelay = _attrs$delay$split2[1];

      var toggleHover = function toggleHover(delay) {
        return $timeout(function () {
          return scope.xlrPopoverTrigger = !scope.xlrPopoverTrigger;
        }, delay);
      };

      var tryToClosePopover = function tryToClosePopover() {
        var timeout = toggleHover(hideDelay);
        var popover = angular.element('.popover');
        popover.mouseenter(function () {
          $timeout.cancel(timeout);
        });
        popover.mouseleave(function () {
          popover.off('mouseenter mouseleave');
          tryToClosePopover();
        });
      };

      element.mouseenter(function () {
        return toggleHover(showDelay);
      });
      element.mouseleave(function () {
        return tryToClosePopover();
      });
      scope.$on('$destroy', function () {
        return element.off('mouseenter mouseleave');
      });
    }
  };
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/popover-trigger/index.js

var popoverTriggerDirective = ['$timeout', popover_trigger_popoverTrigger];
// EXTERNAL MODULE: ./core/xlr-ui/app/features/release-overview/release-status-label/index.js
var release_status_label = __webpack_require__(269);

// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/risk-message/index.js


var PlanItemOverdueTemplate = "\n<div class=\"risk-message risk-message-line\">\n    <span class=\"xl-icon pending-icon\"></span>\n    <p class=\"riskMessageText\" display-variables=\"$ctrl.displayMessage\" variables=\"vm.release.variables\" markdown=\"true\"></p>\n</div>\n";

var risk_message_PlanItemOverdueMessageController = /*#__PURE__*/function () {
  function PlanItemOverdueMessageController() {
    classCallCheck_default()(this, PlanItemOverdueMessageController);
  }

  createClass_default()(PlanItemOverdueMessageController, [{
    key: "$onInit",
    value: function $onInit() {
      if (this.message.search(REGEXP) !== -1) {
        var overdueSince = moment(REGEXP.exec(this.message)[2]);
        var duration = moment.duration(moment().diff(overdueSince));
        var overdueBy = "".concat(duration.days(), "d ").concat(duration.hours(), "h ").concat(duration.minutes(), "m");
        this.displayMessage = this.message.replace(REGEXP, function replace(match, g1, g2) {
          return "".concat(g1, "by ").concat(overdueBy);
        });
      } else {
        this.displayMessage = this.message;
      }
    }
  }]);

  return PlanItemOverdueMessageController;
}();

var REGEXP = /(.*)since\s(\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\.\d{3})$/;
var PlanItemOverdueMessageComponent = {
  template: PlanItemOverdueTemplate,
  controller: risk_message_PlanItemOverdueMessageController,
  bindings: {
    message: '<'
  }
};
// EXTERNAL MODULE: ./node_modules/pluralize/pluralize.js
var pluralize = __webpack_require__(76);
var pluralize_default = /*#__PURE__*/__webpack_require__.n(pluralize);

// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/common/release-to-words.js

function releasesToWords(number) {
  return "".concat(number, " ").concat(pluralize_default()('release', number));
}
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/modals/common-modal.js

function templateBuilder(title, body, actionName) {
  return "\n    <div class=\"modal-header\">\n        <h4 class=\"modal-title pull-left\" id=\"modal-title\">".concat(title, "</h4>\n        <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.dismiss()\"><i class=\"xl-icon close-icon\"/></button>\n        <div class=\"clearfix\"/>\n    </div>\n    <div class=\"modal-body actions-modal\">      \n     ").concat(body, "\n    </div>\n    <div class=\"modal-footer\">\n        <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button class=\"button save primary\" type=\"submit\" ng-click=\"$ctrl.action()\">").concat(actionName, "</button>\n    </div>\n");
}
function defaultMapStateThis(state) {
  return {
    selectedReleases: state.releaseOverview.selectedReleases,
    releases: releasesToWords(state.releaseOverview.selectedReleases.size)
  };
}
function defaultMapDispatchToThis(_action) {
  return function (dispatch) {
    return {
      action: function action() {
        dispatch(_action());
        this.dismiss();
      }
    };
  };
}
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/modals/start-release-modal.js





var start_release_modal_title = "Start {{$ctrl.pluralizeWord('releases')}}";
var start_release_modal_body = "<p>{{$ctrl.message()}}</p>";
var start_release_modal_template = templateBuilder(start_release_modal_title, start_release_modal_body, 'Start');

var start_release_modal_StartReleasesModalController = /*#__PURE__*/function () {
  function StartReleasesModalController($ngRedux) {
    classCallCheck_default()(this, StartReleasesModalController);

    this.unsubscribe = $ngRedux.connect(defaultMapStateThis, this.mapDispatchToThis.bind(this))(this);
  }

  createClass_default()(StartReleasesModalController, [{
    key: "mapDispatchToThis",
    value: function mapDispatchToThis(dispatch) {
      var _this = this;

      return {
        action: function action() {
          dispatch(doStartAction(_this.selectedReleases));

          _this.dismiss();
        }
      };
    }
  }, {
    key: "pluralizeWord",
    value: function pluralizeWord(word) {
      return pluralize_default()(word, this.selectedReleases.size);
    }
  }, {
    key: "message",
    value: function message() {
      if (this.selectedReleases.size > 1) {
        return "You are about to start ".concat(this.releases, ". Team members will be notified and once releases start dates have been reached, the releases flow will commence.");
      }

      return 'You are about to start a release. Team members will be notified and once the release start date has been reached, the release flow will commence.';
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this.unsubscribe();
    }
  }]);

  return StartReleasesModalController;
}();

start_release_modal_StartReleasesModalController.$inject = ['$ngRedux'];
var startReleasesModal = {
  bindings: {
    close: '&',
    dismiss: '&'
  },
  controller: start_release_modal_StartReleasesModalController,
  template: start_release_modal_template
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/modals/abort-releases-modal.js





var abort_releases_modal_template = "\n    <div class=\"modal-header\">\n        <h4 class=\"modal-title pull-left\" id=\"modal-title\">Abort {{$ctrl.pluralizeWord('releases')}}</h4>\n        <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.dismiss()\"><i class=\"xl-icon close-icon\"/></button>\n        <div class=\"clearfix\"/>\n    </div>\n    <div class=\"modal-body actions-modal\">      \n     <p>You are about to abort {{$ctrl.releases}}.</p>\n     \n    <form name=\"abortTaskForm\">\n        <textarea rows=\"4\" class=\"input-block-level\" ng-model=\"abortComment\" placeholder=\"Give feedback or place a comment...\" auto-focus required></textarea>\n    </form>\n    </div>\n    <div class=\"modal-footer\">\n        <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button class=\"button save primary\" type=\"submit\" ng-click=\"$ctrl.abortReleases(abortComment)\" ng-disabled=\"abortTaskForm.$invalid\">Abort</button>\n    </div>\n";

var abort_releases_modal_AbortReleasesModalController = /*#__PURE__*/function () {
  function AbortReleasesModalController($ngRedux) {
    classCallCheck_default()(this, AbortReleasesModalController);

    this.unsubscribe = $ngRedux.connect(defaultMapStateThis, this.mapDispatchToThis.bind(this))(this);
  }

  createClass_default()(AbortReleasesModalController, [{
    key: "mapDispatchToThis",
    value: function mapDispatchToThis(dispatch) {
      var _this = this;

      return {
        abortReleases: function abortReleases(abortComment) {
          dispatch(doAbortAction(_this.selectedReleases, abortComment));

          _this.dismiss();
        }
      };
    }
  }, {
    key: "pluralizeWord",
    value: function pluralizeWord(word) {
      return pluralize_default()(word, this.selectedReleases.size);
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this.unsubscribe();
    }
  }]);

  return AbortReleasesModalController;
}();

abort_releases_modal_AbortReleasesModalController.$inject = ['$ngRedux'];
var abortReleasesModal = {
  bindings: {
    close: '&',
    dismiss: '&'
  },
  controller: abort_releases_modal_AbortReleasesModalController,
  template: abort_releases_modal_template
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/releases-sub-header/releases-sub-header-tpl.html
/* harmony default export */ var releases_sub_header_tpl = ("<div id=\"releases-sub-header\" class=\"container-fluid\">\n    <div ng-if=\"!$ctrl.releases.isEmpty()\" class=\"row\">\n        <div class=\"col-xs-1\">\n            <div class=\"checkbox\">\n                <label aria-label=\"Select all releases\" for=\"selectAllCheckbox\">\n                    <input id=\"selectAllCheckbox\"\n                           type=\"checkbox\"\n                           checkbox-status=\"$ctrl.calculateSelectAllCheckboxStatus()\"\n                           ng-click=\"$ctrl.onToggleSelectAll()\"/>\n                    <span ng-if=\"!$ctrl.isEverythingSelected\">Select all</span>\n                    <span ng-if=\"$ctrl.isEverythingSelected\">Unselect all</span>\n                </label>\n            </div>\n        </div>\n        <div class=\"col-xs-11\">\n            <div class=\"row\">\n                <div class=\"col-xs-3\"></div>\n                <div class=\"col-xs-9\">\n                    <div class=\"row\">\n                        <div class=\"col-xs-2\"></div>\n                        <div class=\"col-xs-2\"></div>\n                        <div class=\"col-xs-2 text-centered\">\n                            <div class=\"release-table-text\">Start date</div>\n                        </div>\n                        <div class=\"col-xs-2 text-centered\">\n                            <div class=\"release-table-text\">End date</div>\n                        </div>\n                        <div class=\"col-xs-2 text-centered\">\n                            <div class=\"release-table-text\">Duration</div>\n                        </div>\n                        <div class=\"col-xs-2\"></div>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/releases-sub-header/index.js







var releases_sub_header_ReleasesSubHeader = /*#__PURE__*/function () {
  function ReleasesSubHeader(ReleasesService, Authenticator) {
    classCallCheck_default()(this, ReleasesSubHeader);

    this.ReleasesService = ReleasesService;
    this.Authenticator = Authenticator;
  }

  createClass_default()(ReleasesSubHeader, [{
    key: "calculateSelectAllCheckboxStatus",
    value: function calculateSelectAllCheckboxStatus() {
      var _this = this;

      if (this.isSelectingAll) {
        return checkbox_statuses_const["a" /* default */].CHECKED;
      } else if (this.selectedReleases.isEmpty()) {
        return checkbox_statuses_const["a" /* default */].UNCHECKED;
      } else {
        var selectableReleases = this.releases.filter(function (release) {
          return bulkSelectReleasesFilter(release, _this.allowedActions, _this.Authenticator, _this.ReleasesService);
        });

        if (this.selectedReleases.size < selectableReleases.size) {
          return checkbox_statuses_const["a" /* default */].INDETERMINATE;
        } else {
          return checkbox_statuses_const["a" /* default */].CHECKED;
        }
      }
    }
  }, {
    key: "isEverythingSelected",
    get: function get() {
      return this.calculateSelectAllCheckboxStatus() === checkbox_statuses_const["a" /* default */].CHECKED;
    }
  }]);

  return ReleasesSubHeader;
}();

defineProperty_default()(releases_sub_header_ReleasesSubHeader, "$inject", ['ReleasesService', 'Authenticator']);

var releasesSubHeaderComponent = {
  bindings: {
    filters: '<',
    releases: '<',
    selectedReleases: '<',
    isSelectingAll: '<',
    allowedActions: '<',
    onToggleSelectAll: '&'
  },
  controller: releases_sub_header_ReleasesSubHeader,
  template: releases_sub_header_tpl
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/constants.js
var ITEMS_PER_PAGE = 15;
var DEFAULT_ORDER_BY = 'risk';
var RELEASE_STATUS_FILTER_KEY_TO_STATUS = {
  planned: 'PLANNED',
  inProgress: 'IN_PROGRESS',
  paused: 'PAUSED',
  failing: 'FAILING',
  failed: 'FAILED',
  completed: 'COMPLETED',
  aborted: 'ABORTED'
};
var constants_ENTITY_ID_PLACEHOLDER = -1;
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/services/index.js


function services_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function services_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { services_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { services_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var RELEASE_GROUP_API = 'api/v1/release-groups';

function reduceFilters(filters) {
  var keys = _.keys(filters);

  return _.reduce(keys, function (reduced, key) {
    if (_.has(RELEASE_STATUS_FILTER_KEY_TO_STATUS, key)) {
      filters[key] && reduced.statuses.push(RELEASE_STATUS_FILTER_KEY_TO_STATUS[key]);
    } else {
      reduced[key] = filters[key];
    }

    return reduced;
  }, {
    statuses: []
  });
}

var services_fetchGroups = function fetchGroups(data, pageNumber) {
  var params = {
    resultsPerPage: ITEMS_PER_PAGE,
    page: pageNumber,
    orderBy: (data.orderBy || DEFAULT_ORDER_BY).toUpperCase()
  };
  var url = "".concat(RELEASE_GROUP_API, "/search?") + $.param(params);
  return Object(http["e" /* httpPOST */])(url, services_objectSpread({}, reduceFilters(data)));
};
var services_deleteGroup = function deleteGroup(groupId) {
  return Object(http["b" /* httpDELETE */])("".concat(RELEASE_GROUP_API, "/").concat(groupId));
};
var services_createGroup = function createGroup(releaseGroup) {
  return Object(http["e" /* httpPOST */])(RELEASE_GROUP_API, releaseGroup);
};
var services_updateGroup = function updateGroup(releaseGroup) {
  return Object(http["f" /* httpPUT */])("".concat(RELEASE_GROUP_API, "/").concat(releaseGroup.id), releaseGroup);
};
var services_addReleasesToReleaseGroup = function addReleasesToReleaseGroup(memberIds, groupId) {
  return Object(http["e" /* httpPOST */])("".concat(RELEASE_GROUP_API, "/").concat(groupId, "/members"), memberIds);
};
var services_removeReleaseFromGroup = function removeReleaseFromGroup(memberId, groupId) {
  return Object(http["b" /* httpDELETE */])("".concat(RELEASE_GROUP_API, "/").concat(groupId, "/members"), [memberId]);
};
var completedStatuses = ['COMPLETED', 'ABORTED'];
var isGroupUpdatable = function isGroupUpdatable(group) {
  return group && !completedStatuses.includes(group.status);
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/modals/add-release-to-release-group-modal.js






var add_release_to_release_group_modal_template = "<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"$ctrl.dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n        <h4>Add {{$ctrl.isBulkAction? 'releases' : 'release' }} to release group</h4>\n    </div>\n    <div class=\"modal-body\">\n        <form name=\"addToGroupForm\" class=\"form-horizontal\" novalidate>\n            <div class=\"form-group\">\n                <label for=\"releaseGroup\" class=\"control-label col-xs-3\">\n                    Group name \n                    <span class=\"error\">*</span>\n                    <span class=\"inline-doc-icon\" doc-icon=\"groups.html\"></span>\n                </label>\n                <div class=\"col-xs-9\">\n                    <div xl-widget-autocomplete\n                         ng-model=\"$ctrl.releaseGroup\"\n                         handlers=\"$ctrl.handlers\"\n                         options=\"{placeholder : 'Please select a release group'}\"\n                         obj-label=\"title\"\n                         show-all-on-click=\"true\"\n                         auto-select-on-exact-match=\"true\"\n                         open-on-click=\"false\"\n                         isRequired=\"true\"></div>\n                    <span class=\"description\">Select the group that you want add this release to</span>\n                </div>\n            </div>  \n        </form>     \n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"$ctrl.addRelease()\" ng-disabled=\"$ctrl.isAddReleaseToGroupDisabled()\">Add</button>\n    </div>\n</div>";

var add_release_to_release_group_modal_AddReleaseToReleaseGroupController = /*#__PURE__*/function () {
  function AddReleaseToReleaseGroupController(Authenticator) {
    classCallCheck_default()(this, AddReleaseToReleaseGroupController);

    this._Authenticator = Authenticator;
  }

  createClass_default()(AddReleaseToReleaseGroupController, [{
    key: "$onInit",
    value: function $onInit() {
      this.releases = this.resolve.data.releases;
      this.isBulkAction = this.releases.length > 1;
      this.releaseGroup = {};
      this.handlers = {
        addCandidates: function addCandidates(metadata, options) {
          return services_fetchGroups({
            title: options.term,
            planned: true,
            inProgress: true,
            failing: true,
            failed: true,
            paused: true,
            orderBy: 'START_DATE'
          }, 0).then(function (response) {
            return response.data;
          });
        }
      };
      this.toastr = new toastrFactory["a" /* default */]();
    }
  }, {
    key: "addRelease",
    value: function addRelease() {
      var _this = this;

      services_addReleasesToReleaseGroup(this.releases.map(function (release) {
        return Object(ids["a" /* default */])().toDomainId(release);
      }), this.releaseGroup.id).then(function () {
        _this.toastr.success("".concat(_this.isBulkAction ? 'Releases were' : 'Release was', " successfully added to group ").concat(_this.releaseGroup.title));

        _this.dismiss();
      }).catch(function () {
        return _this.toastr.error("Failed to add ".concat(_this.isBulkAction ? 'releases' : 'release', " to the group ").concat(_this.releaseGroup.title));
      });
    }
  }, {
    key: "isAddReleaseToGroupDisabled",
    value: function isAddReleaseToGroupDisabled() {
      return _.has(this.releaseGroup, 'id') ? !this._Authenticator.hasReleaseGroupEditPermission(this.releaseGroup) : true;
    }
  }]);

  return AddReleaseToReleaseGroupController;
}();

defineProperty_default()(add_release_to_release_group_modal_AddReleaseToReleaseGroupController, "$inject", ['Authenticator']);

var addReleaseToReleaseGroupModal = {
  bindings: {
    close: '&',
    dismiss: '&',
    resolve: '<'
  },
  controller: add_release_to_release_group_modal_AddReleaseToReleaseGroupController,
  template: add_release_to_release_group_modal_template
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/index.js














/* harmony default export */ var release_overview = (angular.module('xlrelease.releaseOverview', []).component('releaseProgressBar', releaseProgressComponent).component('xlrReleaseList', releaseListComponent).component('xlrReleaseRow', releaseRowComponent).component('xlrReleasePipeline', releasePipelineComponent).component('xlrReleasePipelineButton', releasePipelineButtonComponent).component('releaseStatusLabel', release_status_label["a" /* releaseStatusLabelComponent */]).component('planItemOverdueMessage', PlanItemOverdueMessageComponent).component('startReleases', startReleasesModal).component('abortReleases', abortReleasesModal).component('releasesSubHeader', releasesSubHeaderComponent).directive('xlrPopoverTrigger', popoverTriggerDirective).directive('scrollContainerDirective', scroll_container_directive).component('addReleaseToReleaseGroupModal', addReleaseToReleaseGroupModal).config(function ($stateProvider) {
  $stateProvider.state('releaseOverview', {
    url: '/releases',
    reloadOnSearch: false,
    controller: release_overview_controller,
    template: release_overview_tpl,
    controllerAs: '$ctrl',
    resolve: {
      filterSettings: ['Filters', function (Filters) {
        return Filters.getReleasesFilterSettings();
      }]
    }
  });
}).name);
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-list-modal/actions/release-list-modal-actions.js
var release_list_modal_actions_actionTypes = {
  FETCH_ITEMS: 'FETCH_ITEMS',
  FETCH_ITEMS_SUCCEEDED: 'FETCH_ITEMS_SUCCEEDED',
  FETCH_ITEMS_FAILED: 'FETCH_ITEMS_FAILED',
  MORE_ITEMS_SUCCEEDED: 'MORE_ITEMS_SUCCEEDED',
  MORE_ITEMS_REQUESTED: 'MORE_ITEMS_REQUESTED',
  ITEMS_TOGGLE_SELECT_ALL: 'ITEMS_TOGGLE_SELECT_ALL',
  ITEM_TOGGLE: 'ITEM_TOGGLE'
};
var release_list_modal_actions_fetchItems = function fetchItems(filters) {
  return {
    type: release_list_modal_actions_actionTypes.FETCH_ITEMS,
    payload: filters
  };
};
var release_list_modal_actions_loadMoreItems = function loadMoreItems(filters) {
  return {
    type: release_list_modal_actions_actionTypes.MORE_ITEMS_REQUESTED,
    payload: filters
  };
};
var release_list_modal_actions_toggleSelectAll = function toggleSelectAll() {
  return {
    type: release_list_modal_actions_actionTypes.ITEMS_TOGGLE_SELECT_ALL
  };
};
var release_list_modal_actions_toggleItem = function toggleItem($event, $index, releaseId) {
  return {
    type: release_list_modal_actions_actionTypes.ITEM_TOGGLE,
    payload: {
      $event: $event,
      $index: $index,
      releaseId: releaseId
    }
  };
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-list-modal/release-list-modal.html
/* harmony default export */ var release_list_modal = ("<div class=\"modal-content f-add-release\">\n    <modal-header title=\"$ctrl.resolve.title\" dismiss=\"$ctrl.dismiss()\"></modal-header>\n    <div class=\"modal-body\">\n        <release-list-modal-filter on-title-change=\"$ctrl.onTitleChange(title)\">\n        </release-list-modal-filter>\n\n        <release-list-modal-sub-header releases=\"$ctrl.releases\"\n                                   selected-releases=\"$ctrl.selectedReleases\"\n                                   is-selecting-all=\"$ctrl.selectingAll\"\n                                   allowed-actions=\"$ctrl.allowedActions\"\n                                   on-toggle-select-all=\"$ctrl.toggleSelectAll()\">\n        </release-list-modal-sub-header>\n\n        <release-list-modal-release-list ng-class=\"{'no-releases': !$ctrl.releases.size}\"\n                                releases=\"$ctrl.releases\"\n                                releases-loading-status=\"$ctrl.loading\"\n                                releases-has-more=\"$ctrl.hasMoreReleases\"\n                                on-refresh=\"$ctrl.filtersChanged()\"\n                                on-show-more-releases=\"$ctrl.loadMoreItems($ctrl.filters)\"\n                                on-toggle-release=\"$ctrl.toggleItem($event, $index, releaseId)\"\n                                selected-releases=\"$ctrl.selectedReleases\">\n        </release-list-modal-release-list>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button save primary\"\n                ng-disabled=\"!$ctrl.selectedReleases.size\"\n                ng-click=\"$ctrl.addReleases()\">Add</button>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-list-modal/release-list-modal.js




function release_list_modal_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function release_list_modal_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { release_list_modal_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { release_list_modal_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }





var release_list_modal_ReleaseListModalController = /*#__PURE__*/function () {
  function ReleaseListModalController($ngRedux, $scope) {
    classCallCheck_default()(this, ReleaseListModalController);

    this.filters = {};
    this.$scope = $scope;
    this._unsubscribe = $ngRedux.connect(this._mapStateToThis, this._mapDispatchToThis.call(this))(this);
  }

  createClass_default()(ReleaseListModalController, [{
    key: "$onInit",
    value: function $onInit() {
      this.filters = {
        inProgress: true,
        failing: true,
        paused: true,
        failed: true,
        planned: true
      };
      this.fetchItems(this.filters);
      this.$scope.$on('$stateChangeStart', this.close);
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this._unsubscribe();
    }
  }, {
    key: "_mapDispatchToThis",
    value: function _mapDispatchToThis() {
      return function (dispatch) {
        return {
          loadMoreItems: function loadMoreItems(filters) {
            return dispatch(release_list_modal_actions_loadMoreItems(filters));
          },
          toggleItem: function toggleItem($event, $index, releaseId) {
            return dispatch(release_list_modal_actions_toggleItem($event, $index, releaseId));
          },
          toggleSelectAll: function toggleSelectAll() {
            return dispatch(release_list_modal_actions_toggleSelectAll());
          },
          fetchItems: function fetchItems(filters) {
            return dispatch(release_list_modal_actions_fetchItems(filters));
          }
        };
      };
    }
  }, {
    key: "_mapStateToThis",
    value: function _mapStateToThis(state) {
      var reducer = state.releaseListModal;
      return {
        releases: reducer.releases,
        loading: reducer.loading,
        hasMoreReleases: reducer.hasMoreReleases,
        selectingAll: reducer.selectingAll,
        selectedReleases: reducer.selectedReleases,
        allowedActions: reducer.allowedActions
      };
    }
  }, {
    key: "addReleases",
    value: function addReleases() {
      this.resolve.confirmAction(this.selectedReleases, this.close);
    }
  }, {
    key: "onTitleChange",
    value: function onTitleChange(title) {
      // TODO: Check for permissions
      this.fetchItems(release_list_modal_objectSpread({
        title: title
      }, this.filters));
    }
  }]);

  return ReleaseListModalController;
}();

defineProperty_default()(release_list_modal_ReleaseListModalController, "$inject", ['$ngRedux', '$scope']);

var releaseListModal = {
  bindings: {
    close: '&',
    dismiss: '&',
    resolve: '<'
  },
  controller: release_list_modal_ReleaseListModalController,
  template: release_list_modal
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-list-modal/release-list-modal-filter/release-list-modal-filter.html
/* harmony default export */ var release_list_modal_filter = ("<div class=\"release-list-filter\">\n    <i class=\"button-toggle-filter-icon xl-icon search-icon\"></i>\n    <input type=\"text\"\n           ng-model=\"$ctrl.title\"\n           class=\"modal-filter\"\n           ng-model-options=\"{ debounce: 1200 }\"\n           placeholder=\"Search for a release...\"\n           ng-change=\"$ctrl.onTitleChange({title: $ctrl.title})\" />\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-list-modal/release-list-modal-filter/release-list-modal-filter.js

var releaseListModalFilter = {
  bindings: {
    onTitleChange: '&'
  },
  template: release_list_modal_filter
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-list-modal/release-list-modal-sub-header/release-list-modal-sub-header.html
/* harmony default export */ var release_list_modal_sub_header = ("<div class=\"releases-list-modal-sub-header\">\n    <div ng-if=\"!$ctrl.releases.isEmpty()\" class=\"row\">\n        <div class=\"col-xs-12\">\n            <div class=\"row\">\n                <div class=\"col-xs-5\">\n                    <div class=\"checkbox\">\n                        <label>\n                            <input id=\"selectAllCheckbox\"\n                                   type=\"checkbox\"\n                                   checkbox-status=\"$ctrl.calculateSelectAllCheckboxStatus()\"\n                                   ng-click=\"$ctrl.onToggleSelectAll()\"/>\n                            <span ng-if=\"!$ctrl.isEverythingSelected\">Select all</span>\n                            <span ng-if=\"$ctrl.isEverythingSelected\">Unselect all</span>\n                        </label>\n                    </div>\n                </div>\n                <div class=\"col-xs-7\">\n                    <div class=\"row\">\n                        <div class=\"col-xs-4\"></div>\n                        <div class=\"col-xs-4 text-left\">\n                            <div class=\"release-table-text\">Start date</div>\n                        </div>\n                        <div class=\"col-xs-4 text-left end-date\">\n                            <div class=\"release-table-text\">End date</div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-list-modal/release-list-modal-sub-header/release-list-modal-sub-header.js







var release_list_modal_sub_header_ReleaseListSubHeader = /*#__PURE__*/function () {
  function ReleaseListSubHeader(ReleasesService, Authenticator) {
    classCallCheck_default()(this, ReleaseListSubHeader);

    this.ReleasesService = ReleasesService;
    this.Authenticator = Authenticator;
  }

  createClass_default()(ReleaseListSubHeader, [{
    key: "calculateSelectAllCheckboxStatus",
    value: function calculateSelectAllCheckboxStatus() {
      if (this.isSelectingAll) {
        return checkbox_statuses_const["a" /* default */].CHECKED;
      }

      if (this.selectedReleases.isEmpty() || this.selectedReleases.size === 0) {
        return checkbox_statuses_const["a" /* default */].UNCHECKED;
      }

      if (this.selectedReleases.size < this.releases.size) {
        return checkbox_statuses_const["a" /* default */].INDETERMINATE;
      } else {
        return checkbox_statuses_const["a" /* default */].CHECKED;
      }
    }
  }, {
    key: "isEverythingSelected",
    get: function get() {
      return this.calculateSelectAllCheckboxStatus() === checkbox_statuses_const["a" /* default */].CHECKED;
    }
  }]);

  return ReleaseListSubHeader;
}();

defineProperty_default()(release_list_modal_sub_header_ReleaseListSubHeader, "$inject", ['ReleasesService', 'Authenticator']);

var releaseListModalSubHeader = {
  bindings: {
    releases: '<',
    selectedReleases: '<',
    isSelectingAll: '<',
    allowedActions: '<',
    onToggleSelectAll: '&'
  },
  controller: release_list_modal_sub_header_ReleaseListSubHeader,
  template: release_list_modal_sub_header
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-list-modal/release-list-modal-release-list/release-list-modal-release-list.html
/* harmony default export */ var release_list_modal_release_list = ("<div class=\"release-modal-list row\">\n    <div ng-if=\"$ctrl.releases.size\">\n        <xlr-infinite-scroll-wrapper\n                on-show-more=\"$ctrl.showMore()\"\n                disable-when=\"!$ctrl.releasesHasMore || $ctrl.releasesLoadingStatus\"\n                show-loader-when=\"$ctrl.releasesLoadingStatus\">\n            <div ng-repeat=\"release in $ctrl.releases.toJS()\"\n                 class=\"release-row releases-list-loaded\"\n                 xlr-infinite-scroll>\n                <release-list-modal-release-row\n                        release=\"release\"\n                        on-refresh=\"$ctrl.reloadReleases()\"\n                        is-selected=\"$ctrl.isReleaseSelected(release.id)\"\n                        toggle-release=\"$ctrl.toggleRelease($event, $index, release.id)\">\n                </release-list-modal-release-row>\n            </div>\n        </xlr-infinite-scroll-wrapper>\n    </div>\n    <div class=\"alert notice releases-list-loaded\" ng-show=\"!$ctrl.releasesLoadingStatus && !$ctrl.releases.size\">No releases found.</div>\n    <div ng-if=\"$ctrl.releasesLoadingStatus && !$ctrl.releases.size\" class=\"spinner text-center\">\n        <img src=\"static/9.7.16/styles/img/big-ajax-loader.gif\" alt=\"Loading...\" />\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-list-modal/release-list-modal-release-list/release-list-modal-release-list.js




var release_list_modal_release_list_ReleaseListModalReleaseListController = /*#__PURE__*/function () {
  function ReleaseListModalReleaseListController() {
    classCallCheck_default()(this, ReleaseListModalReleaseListController);
  }

  createClass_default()(ReleaseListModalReleaseListController, [{
    key: "reloadReleases",
    value: function reloadReleases() {
      this.onRefresh();
    }
  }, {
    key: "showMore",
    value: function showMore() {
      this.onShowMoreReleases(this.filters);
    }
  }, {
    key: "toggleRelease",
    value: function toggleRelease($event, $index, releaseId) {
      this.onToggleRelease({
        $event: $event,
        $index: $index,
        releaseId: releaseId
      });
    }
  }, {
    key: "isReleaseSelected",
    value: function isReleaseSelected(releaseId) {
      return this.selectedReleases.has(releaseId);
    }
  }]);

  return ReleaseListModalReleaseListController;
}();

var releaseListModalReleaseList = {
  bindings: {
    releases: '<',
    releasesLoadingStatus: '<',
    releasesHasMore: '<',
    onRefresh: '&',
    onShowMoreReleases: '&',
    selectedReleases: '<',
    onToggleRelease: '&',
    filters: '<'
  },
  controller: release_list_modal_release_list_ReleaseListModalReleaseListController,
  template: release_list_modal_release_list
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-list-modal/release-list-modal-release-row/release-list-modal-release-row.html
/* harmony default export */ var release_list_modal_release_row = ("<div class=\"col-xs-12 release-list-modal-release-row\">\n    <div class=\"release\">\n        <input type=\"checkbox\"\n               class=\"release-bulk-checkbox\"\n               ng-click=\"$ctrl.toggleRelease({$event})\"\n               ng-checked=\"$ctrl.isSelected()\"\n               tabindex=\"{{$index + 1}}\">\n        <div class=\"release-modal-line release-line\">\n            <div class=\"row-wrapper\">\n                <div class=\"col-xs-5 release-title-wrapper\">\n                    <strong class=\"release-title raised-link-target\" ng-attr-title=\"{{$ctrl.release.title}}\">{{$ctrl.release.title}}</strong>\n                    <div class=\"phase-title-wrapper\">\n                        <folder-path ci=\"$ctrl.release\"></folder-path>\n                    </div>\n                </div>\n                <div class=\"col-xs-7 center\">\n                    <div class=\"row\">\n                        <div class=\"col-xs-4 text-left\">\n                            <release-status-label release=\"$ctrl.release\" show-archived=\"true\"></release-status-label>\n                        </div>\n                        <div class=\"col-xs-4 text-left calendar-link\">\n                            <span ng-if=\"!$ctrl.release.startDate\" ng-class=\"{'date-overdue': $ctrl.isOverdue($ctrl.release.scheduledStartDate)}\">\n                                {{$ctrl.release.scheduledStartDate | date:'short'}}\n                            </span>\n                            <span ng-if=\"$ctrl.release.startDate\">\n                                {{$ctrl.release.startDate | date:'short'}}\n                            </span>\n                        </div>\n                        <div class=\"col-xs-4 text-left calendar-link\">\n                            <span ng-if=\"!$ctrl.release.endDate\" ng-class=\"{'date-overdue': $ctrl.isOverdue($ctrl.release.dueDate)}\">\n                               {{$ctrl.release.dueDate | date:'short'}}\n                            </span>\n                            <span ng-if=\"$ctrl.release.endDate\">\n                                {{$ctrl.release.endDate | date:'short'}}\n                            </span>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-list-modal/release-list-modal-release-row/release-list-modal-release-row.js




var release_list_modal_release_row_ReleaseListModalReleaseRowController = function ReleaseListModalReleaseRowController() {
  classCallCheck_default()(this, ReleaseListModalReleaseRowController);
};

defineProperty_default()(release_list_modal_release_row_ReleaseListModalReleaseRowController, "$inject", []);

var releaseListModalReleaseRow = {
  bindToController: true,
  bindings: {
    release: '<',
    onRefresh: '&',
    isSelected: '&',
    toggleRelease: '&'
  },
  controller: release_list_modal_release_row_ReleaseListModalReleaseRowController,
  template: release_list_modal_release_row
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-list-modal/index.js





/* harmony default export */ var features_release_list_modal = (angular.module('xlrelease.releaseListModal', []).component('releaseListModal', releaseListModal).component('releaseListModalFilter', releaseListModalFilter).component('releaseListModalSubHeader', releaseListModalSubHeader).component('releaseListModalReleaseList', releaseListModalReleaseList).component('releaseListModalReleaseRow', releaseListModalReleaseRow).name);
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/group-list/group-list-controller.js



var group_list_controller_GroupListController = /*#__PURE__*/function () {
  function GroupListController() {
    classCallCheck_default()(this, GroupListController);
  }

  createClass_default()(GroupListController, [{
    key: "reloadGroups",
    value: function reloadGroups() {
      this.onRefresh();
    }
  }, {
    key: "showMore",
    value: function showMore() {
      this.onShowMoreGroups();
    }
  }, {
    key: "getGroups",
    value: function getGroups() {
      return this.groups.toJS();
    }
  }, {
    key: "hasReleaseGroups",
    value: function hasReleaseGroups() {
      return _.get(this, ['groups', 'size']);
    }
  }, {
    key: "hasMoreGroups",
    value: function hasMoreGroups() {
      return this.groupsHasMore && !this.groupsLoadingStatus;
    }
  }]);

  return GroupListController;
}();


// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/group-list/group-list-tpl.html
/* harmony default export */ var group_list_tpl = ("<div class=\"content-under-header fc-list-items\">\n    <div class=\"row\" ng-if=\"$ctrl.groups.size\">\n        <div class=\"col-xs-12\">\n            <xlr-infinite-scroll-wrapper\n                    on-show-more=\"$ctrl.showMore()\"\n                    disable-when=\"!$ctrl.hasMoreGroups()\"\n                    show-loader-when=\"$ctrl.groupsLoadingStatus\">\n                <div ng-repeat=\"group in $ctrl.getGroups()\"\n                     ng-class=\"{'fc-list-item-first': $first}\"\n                     class=\"row fc-list-item fc-list-loaded\"\n                     xlr-infinite-scroll>\n                    <div class=\"fc-list-side-line\"></div>\n                    <xlr-release-group-row\n                            group=\"group\"\n                            on-refresh=\"$ctrl.reloadGroups()\"\n                            risk-config=\"$ctrl.riskConfig\">\n                    </xlr-release-group-row>\n                </div>\n            </xlr-infinite-scroll-wrapper>\n        </div>\n    </div>\n    <div class=\"alert notice fc-list-loaded\" ng-if=\"!$ctrl.hasReleaseGroups() && !$ctrl.groupsLoadingStatus\">No release groups found.</div>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/group-list/index.js


var groupListComponent = {
  bindings: {
    groups: '<',
    groupsLoadingStatus: '<',
    groupsHasMore: '<',
    onRefresh: '&',
    onShowMoreGroups: '&',
    riskConfig: '<'
  },
  controller: group_list_controller_GroupListController,
  template: group_list_tpl
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/group-row/group-row-controller.js








var group_row_controller_GroupRowController = /*#__PURE__*/function () {
  function GroupRowController(Authenticator, ReleasesService, DateService, $ngRedux, $uibModal) {
    classCallCheck_default()(this, GroupRowController);

    this._releasesService = ReleasesService;
    this._dateService = DateService;
    this._security = Authenticator;
    this._$uibModal = $uibModal;
    this._unsubscribe = $ngRedux.connect(this._mapStateToThis, this._mapDispatchToThis.bind(this))(this);
  }

  createClass_default()(GroupRowController, [{
    key: "$onDestroy",
    value: function $onDestroy() {
      this._unsubscribe();
    }
  }, {
    key: "_mapDispatchToThis",
    value: function _mapDispatchToThis(dispatch) {
      return {
        delete: function _delete(id) {
          return dispatch(release_groups_actions_deleteGroup(id));
        }
      };
    }
  }, {
    key: "hasDuration",
    value: function hasDuration() {
      return this.group.startDate && this.group.endDate;
    }
  }, {
    key: "getFormattedDuration",
    value: function getFormattedDuration() {
      if (this.hasDuration()) {
        return this._dateService.getDuration(this.group.startDate, this.group.endDate);
      }
    }
  }, {
    key: "getNumberReleases",
    value: function getNumberReleases() {
      return _.get(this.group, ['releaseIds', 'length']) || 0;
    }
  }, {
    key: "getRiskStatus",
    value: function getRiskStatus() {
      return risk_detector["b" /* getRiskStatus */](this.group, this.getRiskScore(), this.riskConfig);
    }
  }, {
    key: "getRiskScore",
    value: function getRiskScore() {
      return parseInt(this.group.riskScore);
    }
  }, {
    key: "getRiskMessageIconClasses",
    value: function getRiskMessageIconClasses(riskMessage) {
      return risk_detector["a" /* getRiskIconClasses */](riskMessage);
    }
  }, {
    key: "isUpdatable",
    value: function isUpdatable(group) {
      return isGroupUpdatable(group) && this._security.hasReleaseGroupEditPermission(group);
    }
  }, {
    key: "isOverdue",
    value: function isOverdue(date) {
      return this._dateService.isOverdue(date, global_constants["a" /* dateTimeFormat */].ISODateTime);
    }
  }, {
    key: "getRiskStatusIcon",
    value: function getRiskStatusIcon() {
      return this._releasesService.getRiskStatusIcon(this.group, this.getRiskScore(), this.riskConfig);
    }
  }, {
    key: "deleteGroup",
    value: function deleteGroup(_releaseGroup) {
      var _this = this;

      this._$uibModal.open({
        animation: false,
        component: 'confirmDeleteGroup',
        resolve: {
          releaseGroup: function releaseGroup() {
            return _releaseGroup;
          }
        }
      }).result.then(function (confirm) {
        if (confirm) {
          _this.delete(_releaseGroup.id);
        }
      });
    }
  }, {
    key: "updateGroup",
    value: function updateGroup(_releaseGroup2) {
      var _this2 = this;

      this._$uibModal.open({
        animation: false,
        component: 'createReleaseGroupModal',
        resolve: {
          releaseGroup: function releaseGroup() {
            return _releaseGroup2;
          }
        }
      }).result.then(function (confirm) {
        return _this2.onRefresh();
      });
    }
  }]);

  return GroupRowController;
}();

defineProperty_default()(group_row_controller_GroupRowController, "$inject", ['Authenticator', 'ReleasesService', 'DateService', '$ngRedux', '$uibModal']);


// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/group-row/group-row-tpl.html
/* harmony default export */ var group_row_tpl = ("<div class=\"col-xs-1\">\n    <div class=\"risk-status {{$ctrl.getRiskStatus()}}\">\n        <i ng-class=\"$ctrl.getRiskStatusIcon()\"></i>\n    </div>\n</div>\n<div class=\"col-xs-11 raised-link-wrapper\">\n    <div class=\"fc-list-item-line\">\n        <div class=\"row\">\n            <div class=\"fc-list-item-wrapper\">\n                <a class=\"col-xs-6 raised-link\" href=\"#/groups/{{$ctrl.group.id}}\"></a>\n                <div class=\"col-xs-3 fc-list-item-title-wrapper\">\n                    <div class=\"fc-list-item-title\">\n                      <i class=\"xl-icon collection-icon icon-l\"></i>\n                      <strong class=\"raised-link-target\">\n                          {{$ctrl.group.title}}\n                      </strong>\n                    </div>\n                    <div class=\"fc-list-item-release-count\">\n                        <ng-pluralize count=\"$ctrl.getNumberReleases()\"\n                                      when=\"{'one': '{} release', 'other': '{} releases'}\"></ng-pluralize>\n                    </div>\n                </div>\n                <div class=\"col-xs-9 fc-list-item-content-wrapper\">\n                    <div class=\"row\">\n                        <div class=\"col-xs-2 fc-list-item-content\">\n                            <release-group-status-label release=\"$ctrl.group\" show-archived=\"true\"></release-group-status-label>\n                        </div>\n                        <div class=\"col-xs-2 fc-list-item-content fc-list-item-progress\">\n                            <release-group-progress-bar calculated-percent=\"$ctrl.group.progress\"></release-group-progress-bar>\n                        </div>\n                        <div class=\"col-xs-2 text-centered fc-list-item-content\">\n                            <span ng-if=\"$ctrl.group.startDate\" ng-class=\"{'date-overdue': $ctrl.isOverdue($ctrl.group.startDate)}\">\n                                {{$ctrl.group.startDate | date: 'short'}}\n                            </span>\n                        </div>\n                        <div class=\"col-xs-2 text-centered fc-list-item-content\">\n                            <span ng-if=\"$ctrl.group.endDate\" ng-class=\"{'date-overdue': $ctrl.isOverdue($ctrl.group.endDate)}\">\n                                {{$ctrl.group.endDate | date: 'short'}}\n                            </span>\n                        </div>\n                        <div class=\"col-xs-2 text-centered duration fc-list-item-content\">\n                            <span ng-if=\"$ctrl.hasDuration()\">{{$ctrl.getFormattedDuration()}}</span>\n                        </div>\n                        <div class=\"col-xs-2 text-centered fc-list-item-actions\">\n                          <!-- div ng-if=\"vm.isAbortActionAvailable() && !vm.isStartActionAvailable()\" class=\"link\"\n                               scope-less-modal=\"'partials/releases/abort-release-modal-ctrl-binding.html'\" ctrl=\"vm\">\n                              <i class=\"xl-icon cancel-icon\"></i> Abort\n                          </div> -->\n\n                            <div class=\"fc-list-item-actions-button fc-item-update link\" ng-if=\"$ctrl.isUpdatable($ctrl.group)\"\n                                  ng-click=\"$ctrl.updateGroup($ctrl.group)\">\n                                <i class=\"xl-icon edit-icon\"></i>\n                                <span class=\"action-label\">Edit</span>\n                            </div>\n                            <div class=\"fc-list-item-actions-button fc-item-delete link\" ng-if=\"$ctrl.isUpdatable($ctrl.group)\"\n                                  ng-click=\"$ctrl.deleteGroup($ctrl.group)\">\n                                <i class=\"xl-icon delete-icon\"></i>\n                                <span class=\"action-label\">Delete</span>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/group-row/index.js


var groupRowComponent = {
  bindToController: true,
  bindings: {
    group: '<',
    onRefresh: '&',
    riskConfig: '<'
  },
  controllerAs: '$ctrl',
  controller: group_row_controller_GroupRowController,
  template: group_row_tpl
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/components/create-release-groups-modal-tpl.html
/* harmony default export */ var create_release_groups_modal_tpl = ("<div class=\"modal-content f-release-groups-create\">\n    <div class=\"modal-header\">\n        <h4 class=\"modal-title pull-left\" id=\"modal-title\">\n            <span ng-if=\"$ctrl.isNew()\">Create new release group</span>\n            <span ng-if=\"!$ctrl.isNew()\">Edit {{::$ctrl.releaseGroup.title}}</span>\n        </h4>\n        <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.dismiss()\">\n            <i class=\"xl-icon close-icon\" />\n        </button>\n        <div class=\"clearfix\"></div>\n    </div>\n    <form id=\"releaseGroupForm\" name=\"releaseGroupForm\" class=\"form-horizontal\"\n          ng-submit=\"$ctrl.createReleaseGroup()\"\n          novalidate>\n        <div class=\"modal-body\">\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">\n                    Group name\n                    <span class=\"error\">*</span>\n                </label>\n\n                <div class=\"col-sm-9\">\n                    <input type=\"text\" class=\"input-block-level\" id=\"title\" name=\"title\"\n                           ng-model=\"$ctrl.releaseGroup.title\" ng-maxlength=\"255\" autofocus required/>\n                    <span class=\"description\" ng-if=\"releaseGroupForm.title.$pristine || releaseGroupForm.title.$valid\">Unique name for the group.</span>\n                    <span class=\"field-errors\" ng-if=\"releaseGroupForm.title.$dirty && releaseGroupForm.title.$invalid\">\n                        <span ng-if=\"releaseGroupForm.title.$error.required\">Group name is mandatory</span>\n                        <span ng-if=\"releaseGroupForm.title.$error.maxlength\">Group name is too long</span>\n                    </span>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">\n                    Start date\n                </label>\n\n                <div class=\"col-sm-9\">\n                    <i class=\"xl-icon calendar-icon\"></i>\n                    <span class=\"start-date\"\n                          date-editor\n                          ng-model=\"$ctrl.releaseGroup.startDate\"\n                          placeholder=\"Start date\"\n                          deletable=\"false\"\n                          readonly=\"::$ctrl.readOnly()\"\n                          date-format=\"{{::$ctrl.defaultDatetimeFormat}}\">\n                    </span>\n                    <div class=\"description\">Date and time when you want the release group to start</div>\n                </div>\n            </div>\n\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">\n                    End date\n                </label>\n\n                <div class=\"col-sm-9\">\n                    <i class=\"xl-icon calendar-icon\"></i>\n                    <span class=\"end-date\"\n                          date-editor\n                          ng-model=\"$ctrl.releaseGroup.endDate\"\n                          placeholder=\"End date\"\n                          deletable=\"false\"\n                          readonly=\"::$ctrl.readOnly()\"\n                          date-format=\"{{::$ctrl.defaultDatetimeFormat}}\">\n                        </span>\n                    <div class=\"description\">Date and time when you want the release group to end</div>\n                    <div class=\"field-errors\" ng-if=\"!$ctrl.hasValidDates()\">\n                        Start date must be before end date\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"modal-footer\">\n            <button type=\"button\" class=\"button cancel\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"button save primary\"\n                    ng-disabled=\"releaseGroupForm.$pristine || releaseGroupForm.$invalid || !$ctrl.hasValidDates()\">\n                {{ $ctrl.isNew() ? 'Create' : 'Save' }}\n            </button>\n        </div>\n    </form>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/components/create-release-groups-modal-component.js




function create_release_groups_modal_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function create_release_groups_modal_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { create_release_groups_modal_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { create_release_groups_modal_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }







var create_release_groups_modal_component_getInitialReleaseGroupProperties = function getInitialReleaseGroupProperties() {
  var now = moment().add(1, 'hours');
  return {
    id: constants_ENTITY_ID_PLACEHOLDER,
    type: 'xlrelease.ReleaseGroup',
    startDate: now.format(global_constants["a" /* dateTimeFormat */].ISODateTime),
    endDate: now.add(7, 'days').format(global_constants["a" /* dateTimeFormat */].ISODateTime)
  };
};

var create_release_groups_modal_component_CreateReleaseGroupController = /*#__PURE__*/function () {
  function CreateReleaseGroupController($location, $rootScope) {
    classCallCheck_default()(this, CreateReleaseGroupController);

    this._location = $location;
    this.$rootScope = $rootScope;
    this.toastr = Object(toastrFactory["a" /* default */])();
    this.defaultDatetimeFormat = global_constants["a" /* dateTimeFormat */].ISODateTime;
  }

  createClass_default()(CreateReleaseGroupController, [{
    key: "$onInit",
    value: function $onInit() {
      this.releaseGroup = create_release_groups_modal_component_objectSpread({}, create_release_groups_modal_component_getInitialReleaseGroupProperties(), {}, this.resolve.releaseGroup);
      this.$rootScope.$on('$stateChangeStart', this.close);
    }
  }, {
    key: "createReleaseGroup",
    value: function createReleaseGroup() {
      var _this = this;

      if (this.isNew()) {
        this.releaseGroup.folderId = this.resolve.folder.id;
        return services_createGroup(this.releaseGroup).then(function (response) {
          var groupId = response.data.id;

          _this.toastr.success('Created release group successfully');

          _this.close();

          if (_this.isNew()) {
            _this._location.url("/groups/".concat(groupId));
          }
        });
      }

      return services_updateGroup(this.releaseGroup).then(function () {
        _this.toastr.success('Updated release group successfully');

        _this.close();
      });
    }
  }, {
    key: "hasValidDates",
    value: function hasValidDates() {
      return moment(this.releaseGroup.startDate).isBefore(moment(this.releaseGroup.endDate));
    }
  }, {
    key: "isNew",
    value: function isNew() {
      return this.releaseGroup.id === constants_ENTITY_ID_PLACEHOLDER;
    }
  }]);

  return CreateReleaseGroupController;
}();

defineProperty_default()(create_release_groups_modal_component_CreateReleaseGroupController, "$inject", ['$location', '$rootScope']);

var CreateReleaseGroupModal = {
  bindings: {
    close: '&',
    dismiss: '&',
    resolve: '<'
  },
  controller: create_release_groups_modal_component_CreateReleaseGroupController,
  template: create_release_groups_modal_tpl
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/components/delete-release-groups-modal-component.js
var delete_release_groups_modal_component_template = "\n    <div class=\"modal-header\">\n        <h4 class=\"modal-title pull-left\" id=\"modal-title\">Delete release group</h4>\n        <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.close()\"><i class=\"xl-icon close-icon\"/></button>\n        <div class=\"clearfix\"/>\n    </div>\n    <div class=\"modal-body\" id=\"modal-body\">\n        You are about to delete the release group <strong>{{::$ctrl.resolve.releaseGroup.title}}</strong>.\n    </div>\n    <div class=\"modal-footer\">\n        <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button class=\"button continue primary\" type=\"button\" focus-on=\"true\" ng-click=\"$ctrl.close({$value: true})\">Delete</button>\n    </div>\n";
var ConfirmDeleteGroup = {
  bindings: {
    resolve: '<',
    close: '&',
    dismiss: '&'
  },
  template: delete_release_groups_modal_component_template
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/group-filter/group-filter-tpl.html
/* harmony default export */ var group_filter_tpl = ("<filter class=\"fc-list-header-filter\" filters=\"$ctrl.filters\" on-change=\"$ctrl.filtersChanged(filters)\">\n    <div class=\"fc-list-header-filter-basic\">\n        <text-filter field=\"'title'\" class=\"release-group\" placeholder=\"'Search for groups...'\"></text-filter>\n        <span>\n            <ci-filter-status />\n            <order-by-filter class=\"filter last\"></order-by-filter>\n        </span>\n        <div class=\"buttons\">\n            <span ng-if=\"$ctrl.isNewReleaseGroupButtonVisible()\"\n                  ng-click=\"$ctrl.createReleaseGroup()\"\n                  class=\"button primary new-group\">\n                New release group\n            </span>\n            \n        </div>\n        <span class=\"fc-list-header-doc-icon\" doc-icon=\"release-groups.html\"></span>\n    </div>\n</filter>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/group-filter/index.js

var groupFilter = {
  bindings: {
    filters: '<',
    filtersChanged: '&',
    isNewReleaseGroupButtonVisible: '&',
    createReleaseGroup: '&'
  },
  template: group_filter_tpl
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/group-sub-header/group-sub-header-tpl.html
/* harmony default export */ var group_sub_header_tpl = ("<div class=\"container-fluid fc-list-sub-header\" ng-if=\"$ctrl.hasGroups()\">\n    <div class=\"col-xs-1\">&nbsp;</div>\n    <div class=\"col-xs-11\">\n        <div class=\"row\">\n            <div class=\"col-xs-3\"></div>\n            <div class=\"col-xs-9\">\n                <div class=\"row\">\n                    <div class=\"col-xs-2\"></div>\n                    <div class=\"col-xs-2\"></div>\n                    <div class=\"col-xs-2 text-centered\">\n                        <div class=\"release-table-text\">Start date</div>\n                    </div>\n                    <div class=\"col-xs-2 text-centered\">\n                        <div class=\"release-table-text\">End date</div>\n                    </div>\n                    <div class=\"col-xs-2 text-centered\">\n                        <div class=\"release-table-text\">Duration</div>\n                    </div>\n                    <div class=\"col-xs-2\"></div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/group-sub-header/index.js

var groupSubHeader = {
  bindings: {
    hasGroups: '&'
  },
  template: group_sub_header_tpl
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/release-groups-tpl.html
/* harmony default export */ var release_groups_tpl = ("<div class=\"fc-list f-release-groups header\" id=\"release-groups\">\n    <div class=\"fc-list-header\">\n        <div class=\"fc-list-header-actions\">\n            <group-filter filters=\"$ctrl.filters\"\n                filters-changed=\"$ctrl.filtersChanged()\"></group-filter>\n            <group-sub-header has-groups=\"$ctrl.hasGroups()\"></group-sub-header>\n        </div>\n    </div>\n    <div class=\"fc-list-items-wrapper\">\n        <xlr-release-group-list groups=\"$ctrl.groups\"\n            groups-loading-status=\"$ctrl.loading\"\n            groups-has-more=\"$ctrl.hasMoreGroups\"\n            on-refresh=\"$ctrl.filtersChanged()\"\n            on-show-more-groups=\"$ctrl.loadMoreGroups()\"\n            risk-config=\"$ctrl.riskConfig\">\n        </xlr-release-group-list>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/release-groups-controller.js





var release_groups_controller_ReleaseGroupsController = /*#__PURE__*/function () {
  function ReleaseGroupsController($scope, Events, Authenticator, $uibModal, $ngRedux) {
    classCallCheck_default()(this, ReleaseGroupsController);

    this._$scope = $scope;
    this._Events = Events;
    this._$uibModal = $uibModal;
    this._Authenticator = Authenticator;
    this._unsubscribe = $ngRedux.connect(this._mapStateToThis, this._mapDispatchToThis.call(this, $uibModal))(this);
  }

  createClass_default()(ReleaseGroupsController, [{
    key: "$onInit",
    value: function $onInit() {
      if (this.folder) {
        this.filters.folderId = this.folder.id;
      }

      this._initialFilters = this.filters;

      this._$scope.$emit(this._Events.permission.refresh);

      this.updateFilters(this._initialFilters);
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this._unsubscribe();
    }
  }, {
    key: "_mapDispatchToThis",
    value: function _mapDispatchToThis(uibModalService) {
      return function (dispatch) {
        return {
          loadMoreGroups: function loadMoreGroups() {
            dispatch(getMoreGroups());
          },
          updateFilters: function updateFilters(filters) {
            dispatch(release_groups_actions_setFilters(filters, true));
          },
          deleteGroup: function deleteGroup() {
            dispatch(release_groups_actions_deleteGroup(uibModalService));
          }
        };
      };
    }
  }, {
    key: "_mapStateToThis",
    value: function _mapStateToThis(state) {
      var reducer = state.releaseGroups;
      return {
        groups: reducer.groups,
        loading: reducer.loading,
        hasMoreGroups: reducer.hasMoreGroups,
        filters: reducer.filters.toJS(),
        riskConfig: reducer.riskConfig
      };
    }
  }, {
    key: "filtersChanged",
    value: function filtersChanged() {
      this.updateFilters(this.filters);
    }
  }, {
    key: "isNewReleaseGroupButtonVisible",
    value: function isNewReleaseGroupButtonVisible() {
      return this._Authenticator.hasReleaseGroupEditPermission(this.folder);
    }
  }, {
    key: "createReleaseGroup",
    value: function createReleaseGroup() {
      var _this = this;

      var modal = this._$uibModal.open({
        animation: false,
        component: 'createReleaseGroupModal',
        resolve: {
          folder: function folder() {
            return _this.folder;
          }
        }
      });

      modal.result.then(function () {
        return _this.updateFilters(_this.filters);
      });
    }
  }, {
    key: "hasGroups",
    value: function hasGroups() {
      return !!_.get(this.groups, 'size');
    }
  }]);

  return ReleaseGroupsController;
}();

defineProperty_default()(release_groups_controller_ReleaseGroupsController, "$inject", ['$scope', 'Events', 'Authenticator', '$uibModal', '$ngRedux']);


// EXTERNAL MODULE: ./core/xlr-ui/app/features/release-groups/release-groups.less
var release_groups = __webpack_require__(1444);

// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/release-groups-component.js



/* harmony default export */ var release_groups_component = ({
  bindings: {
    filters: '<'
  },
  controller: release_groups_controller_ReleaseGroupsController,
  template: release_groups_tpl
});
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/index.js









/* harmony default export */ var features_release_groups = (angular.module('xlrelease.releaseGroups', []).component('releaseGroupProgressBar', releaseProgressComponent).component('releaseGroupStatusLabel', release_status_label["a" /* releaseStatusLabelComponent */]).component('xlrReleaseGroupList', groupListComponent).component('xlrReleaseGroupRow', groupRowComponent).component('createReleaseGroupModal', CreateReleaseGroupModal).component('confirmDeleteGroup', ConfirmDeleteGroup).component('groupFilter', groupFilter).component('groupSubHeader', groupSubHeader).component('releaseGroups', release_groups_component).config(['$stateProvider', function ($stateProvider) {
  $stateProvider.state('releaseGroups', {
    url: '/groups',
    reloadOnSearch: false,
    controller: ['filters', function (filters) {
      this.filters = filters;
    }],
    template: '<release-groups filters="$ctrl.filters" />',
    controllerAs: '$ctrl',
    resolve: {
      filters: ['Filters', function (Filters) {
        return Filters.getGroupsFilterSettings();
      }]
    }
  });
}]).name);
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups-details/timeline/timeline-row-name.html
/* harmony default export */ var timeline_row_name = ("<div class=\"timeline-row-name\" ng-init=\"model = getValue()\">\n    <span class=\"timeline-row-name-release\" ng-if=\"!model.isReleaseGroup\">\n        <i class=\"fgd-risk-icon\" ng-class=\"model.riskStatusIcon\"></i>\n        <a class=\"release-title\" ng-href=\"{{model.releaseEditorURL}}\" title=\"{{::model.title}}\">{{::model.title}}</a>\n    </span>\n    <div class=\"context-menu-button dropdown-button pull-right\"\n         ng-if=\"!model.isReleaseGroup && model.isUpdatable()\"\n         data-container=\"body\"\n         bs-popover\n         template=\"{{::model.timelineContextMenuTemplate}}\"\n         data-placement=\"top\"\n         auto-close=\"true\">\n        <i class=\"xl-icon options-icon\"></i>\n    </div>\n    <span class=\"timeline-row-name-group\" ng-if=\"model.isReleaseGroup\">\n        <i class=\"xl-icon collection-icon\"></i>\n        <span class=\"group-title\" title=\"{{::model.title}}\">{{::model.title}}</span>\n    </span>\n</div>");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups-details/timeline/timeline-context-menu.html
/* harmony default export */ var timeline_context_menu = ("<div class=\"popover\">\n    <div class=\"arrow\"></div>\n    <div class=\"popover-content\">\n        <xlr-context-menu id=\"context-menu-container\"\n                          items=\"model.contextMenuSettings\">\n        </xlr-context-menu>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups-details/actions/release-groups-timeline-actions.js
var release_groups_timeline_actions_actionTypes = {
  GROUP_REQUESTED: 'GROUP_DETAILS_REQUESTED',
  GROUP_PRE_LOAD: 'GROUP_DETAILS_GROUP_PRE_LOAD',
  GROUP_SUCCEEDED: 'GROUP_DETAILS_GROUP_SUCCEEDED',
  GROUP_FAILED: 'GROUP_DETAILS_GROUP_FAILED',
  UPDATE_FILTERS_REQUESTED: 'GROUP_DETAILS_UPDATE_FILTERS_REQUESTED',
  UPDATE_FILTERS_SUCCEEDED: 'GROUP_DETAILS_UPDATE_FILTERS_SUCCEEDED',
  UPDATE_FILTERS_FAILED: 'GROUP_DETAILS_UPDATE_FILTERS_FAILED',
  ZOOM_IN: 'GROUP_DETAILS_ZOOM_IN',
  ZOOM_OUT: 'GROUP_DETAILS_ZOOM_OUT',
  RESET_TO_INITIAL_STATE: 'GROUP_DETAILS_RESET_TO_INITIAL_STATE'
};
var release_groups_timeline_actions_setFilters = function setFilters(filters) {
  return {
    type: release_groups_timeline_actions_actionTypes.UPDATE_FILTERS_REQUESTED,
    payload: {
      filters: filters
    }
  };
};
var release_groups_timeline_actions_fetchGroup = function fetchGroup(groupId, filters) {
  return {
    type: release_groups_timeline_actions_actionTypes.GROUP_REQUESTED,
    payload: {
      groupId: groupId,
      filters: filters
    }
  };
};
var release_groups_timeline_actions_resetToInitialState = function resetToInitialState() {
  return {
    type: release_groups_timeline_actions_actionTypes.RESET_TO_INITIAL_STATE
  };
};
/* harmony default export */ var release_groups_timeline_actions = ({
  setFilters: release_groups_timeline_actions_setFilters,
  fetchGroup: release_groups_timeline_actions_fetchGroup,
  resetToInitialState: release_groups_timeline_actions_resetToInitialState
});
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups-details/timeline/timeline-controller.js




function timeline_controller_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function timeline_controller_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { timeline_controller_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { timeline_controller_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }






var phaseContentTemplate = "\n    <div xlr-timeline-tooltip\n         class=\"fgt-timeline-task-content\">\n         {{::task.model.name}}\n     </div>\n";
var groupContentTemplate = "\n    <div xlr-timeline-tooltip>\n         {{::task.model.name}}\n     </div>\n";

var timeline_controller_TimelineController = /*#__PURE__*/function () {
  function TimelineController($ngRedux, $scope, ReleasesService, ViewStorage, Ids, DateService, Authenticator) {
    classCallCheck_default()(this, TimelineController);

    this._scope = $scope;
    this._releasesService = ReleasesService;
    this._viewStorage = ViewStorage;
    this._Ids = Ids;
    this._DateService = DateService;
    this._Authenticator = Authenticator;
    this._unsubscribe = $ngRedux.connect(this._mapStateToThis.bind(this), this._mapDispatchToThis.bind(this))(this);
  }

  createClass_default()(TimelineController, [{
    key: "$onInit",
    value: function $onInit() {
      this.initGanttTableOptions();
      this.currentDate = new Date(); // For performance reasons, when a lot of tasks are loaded in the gantt chart,
      // tasks outside of the visible scrollable viewport are removed from the DOM.

      this.taskLimitThreshold = 30;
      this.registerGanttApi = this.registerGanttApi.bind(this);
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this.resetToInitialState();

      this._unsubscribe();
    }
  }, {
    key: "initGanttTableOptions",
    value: function initGanttTableOptions() {
      this.tableColumns = ['row.model.id'];
      this.tableHeaders = {
        'row.model.id': 'Name'
      };
      this.tableContents = {
        'row.model.id': timeline_row_name
      };
      this.tableFormatters = {
        'row.model.id': this.getRowModel.bind(this)
      };
    }
  }, {
    key: "getRowModel",
    value: function getRowModel(value, column, row) {
      var isReleaseGroup = _.get(row, ['model', 'tasks', 0, 'data', 'isReleaseGroup']);

      if (isReleaseGroup) {
        return {
          title: row.model.name,
          isReleaseGroup: isReleaseGroup
        };
      }

      var release = _.get(row, ['model', 'data', 'release']);

      return {
        riskStatusIcon: this.getRiskStatusIcon(release, this.getRiskScore(release)),
        title: release.title,
        releaseEditorURL: this.getReleaseEditorURL(release),
        timelineContextMenuTemplate: timeline_context_menu,
        contextMenuSettings: [{
          modal: 'xlrRemoveReleaseFromGroup',
          disabled: false,
          title: 'Remove from group',
          refresh: this.fetchGroup.bind(this),
          data: {
            group: this.group,
            release: release
          }
        }],
        isReleaseGroup: isReleaseGroup,
        isUpdatable: this.isUpdatable.bind(this)
      };
    }
  }, {
    key: "getReleaseEditorURL",
    value: function getReleaseEditorURL(release) {
      var releaseId = this._Ids.toInternalId(release.id);

      return "#".concat(this._viewStorage.getView(releaseId, "/releases/".concat(releaseId)));
    }
  }, {
    key: "getRiskStatusIcon",
    value: function getRiskStatusIcon(release, riskScore) {
      return this._releasesService.getRiskStatusIcon(release, riskScore, this.riskConfig, 'icon-md');
    }
  }, {
    key: "getRiskScore",
    value: function getRiskScore(release) {
      return parseInt(release.riskScore);
    }
  }, {
    key: "_mapDispatchToThis",
    value: function _mapDispatchToThis(dispatch) {
      return {
        fetchGroup: function fetchGroup() {
          dispatch(release_groups_timeline_actions_fetchGroup(this.group.id));
        },
        resetToInitialState: function resetToInitialState() {
          dispatch(release_groups_timeline_actions_resetToInitialState());
        }
      };
    }
  }, {
    key: "_mapStateToThis",
    value: function _mapStateToThis(state) {
      var reducer = state.groupsTimeline;
      var newGanttData = this.getGanttData(reducer.group, reducer.filteredReleases);
      var ganttData = _.isEqual(reducer.filteredReleasesDateStamp, this.filteredReleasesDateStamp) ? this.ganttData : newGanttData;
      return timeline_controller_objectSpread({
        group: reducer.group,
        loading: reducer.loading,
        hasReleases: !!reducer.filteredReleases.length,
        filters: reducer.filters,
        riskConfig: reducer.riskConfig,
        filteredReleasesDateStamp: reducer.filteredReleasesDateStamp
      }, reducer.zoomLevel, {}, ganttData);
    }
  }, {
    key: "registerGanttApi",
    value: function registerGanttApi(api) {
      api.directives.on.new(this._scope, function (dName, dScope, dElement) {
        if (dName === 'ganttTask') {
          var phaseColor = _.get(dScope, ['task', 'model', 'data', 'phase', 'color']);

          if (phaseColor) {
            dElement.css({
              'border-color': phaseColor
            });
          }
        }
      });
    }
  }, {
    key: "isUpdatable",
    value: function isUpdatable() {
      return isGroupUpdatable(this.group) && this._Authenticator.hasReleaseGroupEditPermission(this.group);
    }
  }, {
    key: "getPhaseStartDate",
    value: function getPhaseStartDate(phase) {
      return phase.plannedStartDate;
    }
  }, {
    key: "getPhaseEndDate",
    value: function getPhaseEndDate(phase) {
      return phase.plannedEndDate;
    }
  }, {
    key: "hasPhaseDates",
    value: function hasPhaseDates(phase) {
      return this.getPhaseStartDate(phase) && this.getPhaseEndDate(phase);
    }
  }, {
    key: "getGanttData",
    value: function getGanttData(group, releases) {
      var _this = this;

      if (!group || !releases) {
        return {
          ganttData: {
            data: [],
            timespans: []
          }
        };
      }

      var height = 36;
      var groupTimespan = {
        from: moment(group.startDate).toDate(),
        to: moment(group.endDate).toDate()
      };

      var data = _.reduce(releases, function (rows, release) {
        rows.push({
          name: release.title,
          height: height,
          sortable: false,
          classes: 'gantt-row-milestone',
          tasks: _(release.phases).filter(function (phase) {
            return _this.hasPhaseDates(phase);
          }).map(function (phase) {
            var from = moment(_this.getPhaseStartDate(phase));
            var to = moment(_this.getPhaseEndDate(phase));
            var classes = ['fgt-timeline-task-release-phase'];

            if (_this._DateService.isOverdue(to.valueOf())) {
              classes.push('fgt-timeline-task-incomplete');
            }

            return {
              name: phase.title,
              from: from.toDate(),
              to: to.toDate(),
              classes: classes,
              data: {
                phase: phase,
                release: release,
                $ctrl: _this
              },
              content: phaseContentTemplate
            };
          }).value(),
          data: {
            release: release,
            isReleaseGroup: false
          }
        });
        return rows;
      }, [{
        name: group.title,
        height: height,
        classes: ['fgt-timeline-task-release-group'],
        tasks: [timeline_controller_objectSpread({
          name: group.title,
          content: groupContentTemplate,
          data: {
            isReleaseGroup: true
          }
        }, groupTimespan)]
      }]);

      return {
        ganttData: {
          data: data,
          timespans: data.length > 1 ? [groupTimespan] : []
        }
      };
    }
  }, {
    key: "getDateDiff",
    value: function getDateDiff(actualDate, expectedDate) {
      return this._DateService.getOverdueDuration(actualDate, expectedDate);
    }
  }, {
    key: "isDateOverdue",
    value: function isDateOverdue(actualDate, expectedDate) {
      return expectedDate && moment(actualDate, global_constants["a" /* dateTimeFormat */].unixMillisecondTimestamp).diff(moment(expectedDate, global_constants["a" /* dateTimeFormat */].unixMillisecondTimestamp)) > 0;
    }
  }, {
    key: "hasReleasesFound",
    value: function hasReleasesFound() {
      return this.hasReleases && !this.loading;
    }
  }]);

  return TimelineController;
}();

defineProperty_default()(timeline_controller_TimelineController, "$inject", ['$ngRedux', '$scope', 'ReleasesService', 'ViewStorage', 'Ids', 'DateService', 'Authenticator']);


// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups-details/timeline/timeline-tpl.html
/* harmony default export */ var timeline_tpl = ("<div class=\"content-under-header fgt-group-timeline\">\n    <div class=\"row\">\n        <div gantt\n             data=\"$ctrl.ganttData.data\"\n             timespans=\"$ctrl.ganttData.timespans\"\n             current-date-value=\"$ctrl.currentDate\"\n             column-width=\"$ctrl.columnWidth\"\n             view-scale=\"$ctrl.viewScale\"\n             headers=\"$ctrl.headers\"\n             headers-scales=\"$ctrl.headersScales\"\n             headers-formats=\"$ctrl.headersFormats\"\n\n             allow-side-resizing=\"false\"\n             api=\"::$ctrl.registerGanttApi\"\n             current-date=\"'line'\"\n             expand-to-fit=\"true\"\n             taskLimitThreshold=\"::$ctrl.taskLimitThreshold\"\n             max-height=\"'100%'\">\n            <gantt-table\n                    columns=\"::$ctrl.tableColumns\"\n                    headers=\"::$ctrl.tableHeaders\"\n                    contents=\"::$ctrl.tableContents\"\n                    formatters=\"::$ctrl.tableFormatters\">\n            </gantt-table>\n\n            <gantt-bounds></gantt-bounds>\n            <gantt-progress></gantt-progress>\n            <gantt-overlap></gantt-overlap>\n            <gantt-groups></gantt-groups>\n        </div>\n    </div>\n    <div class=\"row alert notice no-release-message\" ng-if=\"!$ctrl.hasReleasesFound() && !$ctrl.loading\">\n        <div>No releases found</div>\n    </div>\n    <div class=\"spinner\" ng-if=\"$ctrl.loading\">\n        <img src=\"static/9.7.16/styles/img/big-ajax-loader.gif\" alt=\"Loading...\" />\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups-details/timeline/index.js


var timelineComponent = {
  bindings: {
    loading: '<',
    group: '<',
    onRefresh: '&',
    riskConfig: '<'
  },
  controller: timeline_controller_TimelineController,
  template: timeline_tpl
};
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups-details/timeline/timeline-phase-tooltip.html
/* harmony default export */ var timeline_phase_tooltip = ("<div>\n    <span class=\"fgt-timeline-text-ellipsis fgt-timeline-tooltip-phase_name\">Phase: {{::task.model.data.phase.title}}</span>\n    <ul class=\"list-unstyled\" ng-init=\"phase = task.model.data.phase\">\n        <li ng-if=\"::!phase.startDate\" class=\"text-right\">\n            <span class=\"pull-left\">Estimated start date:</span>\n            <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(phase.plannedStartDate, phase.scheduledStartDate)}\">\n                {{::phase.plannedStartDate | mediumDateShortTime}}\n                <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(phase.plannedStartDate, phase.scheduledStartDate)}}</div>\n            </span>\n        </li>\n        <li ng-if=\"::phase.startDate\" class=\"text-right\">\n            <span class=\"pull-left\">Start date:</span>\n            <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(phase.startDate, phase.scheduledStartDate)}\">\n                {{::phase.startDate | mediumDateShortTime}}\n                <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(phase.startDate, phase.scheduledStartDate)}}</div>\n            </span>\n        </li>\n        <li ng-if=\"::!phase.endDate\" class=\"text-right\">\n            <span class=\"pull-left\">Estimated end date:</span>\n            <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(phase.plannedEndDate, phase.dueDate)}\">\n                {{::phase.plannedEndDate | mediumDateShortTime}}\n                <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(phase.plannedEndDate, phase.dueDate)}}</div>\n            </span>\n        </li>\n        <li ng-if=\"::phase.endDate\" class=\"text-right\">\n            <span class=\"pull-left\">End date:</span>\n            <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(phase.endDate, phase.dueDate)}\">\n                {{::phase.endDate | mediumDateShortTime}}\n                <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(phase.endDate, phase.dueDate)}}</div>\n            </span>\n        </li>\n    </ul>\n    <div class=\"running-task-info\" ng-show=\"::phase.currentTask\">\n        Running task: {{::phase.currentTask}}\n    </div>\n    <div class=\"fgt-timeline-tooltip-splitter\"></div>\n    <div class=\"fgt-timeline-tooltip-release\">\n        <span class=\"fgt-timeline-tooltip-belongs_to\">Release: {{::task.model.data.release.title}}</span>\n        <span class=\"pull-right\">\n            <release-status-label release=\"task.model.data.release\" show-archived=\"true\"></release-status-label>\n        </span>\n    </div>\n    <ul class=\"list-unstyled\" ng-init=\"release = task.model.data.release\">\n        <li ng-if=\"::!release.startDate\" class=\"text-right\">\n            <span class=\"pull-left\">Planned start date:</span>\n            <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(release.plannedStartDate, release.scheduledStartDate)}\">\n                {{::release.plannedStartDate | mediumDateShortTime}}\n                <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(release.plannedStartDate, release.scheduledStartDate)}}</div>\n            </span>\n        </li>\n        <li ng-if=\"::release.startDate\" class=\"text-right\">\n            <span class=\"pull-left\">Start date:</span>\n            <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(release.startDate, release.scheduledStartDate)}\">\n                {{::release.startDate | mediumDateShortTime}}\n                <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(release.startDate, release.scheduledStartDate)}}</div>\n            </span>\n        </li>\n        <li ng-if=\"::!release.endDate\" class=\"text-right\">\n            <span class=\"pull-left\">Planned end date:</span>\n            <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(release.plannedEndDate, release.dueDate)}\">\n                {{::release.plannedEndDate | mediumDateShortTime}}\n                <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(release.plannedEndDate, release.dueDate)}}</div>\n            </span>\n        </li>\n        <li ng-if=\"::release.endDate\" class=\"text-right\">\n            <span class=\"pull-left\">End date:</span>\n            <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(release.endDate, release.dueDate)}\">\n                {{::release.endDate | mediumDateShortTime}}\n                <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(release.endDate, release.dueDate)}}</div>\n            </span>\n        </li>\n    </ul>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups-details/timeline/timeline-group-tooltip.html
/* harmony default export */ var timeline_group_tooltip = ("<div>\n    <span class=\"fgt-timeline-text-ellipsis fgt-timeline-tooltip-phase_name\">Group: {{::task.model.name}}</span>\n    <ul class=\"list-unstyled\">\n        <li>\n            <span>Start date:</span>\n            <span class=\"pull-right\">\n                {{::task.model.from.toDate() | mediumDateShortTime}}\n            </span>\n        </li>\n        <li>\n            <span>End date:</span>\n            <span class=\"pull-right\">\n                {{::task.model.to.toDate() | mediumDateShortTime}}\n            </span>\n        </li>\n    </ul>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups-details/timeline/timeline-tooltip-directive.js


var tooltipTemplate = "\n    <div class='tooltip fgt-timeline-tooltip' role='tooltip'>\n        <div class='tooltip-arrow fgt-timeline-tooltip-arrow'></div>\n        <div class='tooltip-inner'></div>\n    </div>\n";
/* harmony default export */ var timeline_tooltip_directive = (['$compile', function ($compile) {
  return {
    restrict: 'A',
    link: function link(scope, element) {
      var template = _.get(scope, ['task', 'model', 'data', 'isReleaseGroup']) ? timeline_group_tooltip : timeline_phase_tooltip;
      element.tooltip({
        title: function title() {
          var compiledTemplate = $compile(template)(scope);
          scope.$digest();
          return compiledTemplate[0].outerHTML;
        },
        delay: 50,
        trigger: 'hover',
        placement: 'auto',
        html: true,
        animation: false,
        container: 'body',
        template: tooltipTemplate
      });
      var offStateChangeStart = scope.$on('$stateChangeStart', function () {
        element.tooltip('destroy');
        offStateChangeStart();
      });

      var throttled = _.throttle(trackMove, 0);

      element.mousemove(throttled);

      function trackMove(event) {
        var tooltip = angular.element('.fgt-timeline-tooltip');
        var tooltipArrow = angular.element('.fgt-timeline-tooltip-arrow');
        var tooltipWidth = tooltip.outerWidth();
        var tooltipHalfWidth = tooltipWidth / 2;
        var clientX = parseInt(event.clientX);
        var marginRight = 5;

        if (event.clientX + tooltipHalfWidth + marginRight >= window.outerWidth) {
          tooltip.css('left', '');
          tooltip.css('right', "".concat(marginRight, "px"));
          tooltipArrow.css('left', "".concat(tooltipWidth - (window.outerWidth - clientX), "px"));
        } else {
          tooltipArrow.css('left', "".concat(tooltipHalfWidth, "px"));
          tooltip.css('left', "".concat(clientX - tooltipHalfWidth, "px"));
          tooltip.css('right', '');
        }
      }
    }
  };
}]);
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups-details/release-groups-details-controller.js




function release_groups_details_controller_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function release_groups_details_controller_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { release_groups_details_controller_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { release_groups_details_controller_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }





var release_groups_details_controller_GroupsDetailsController = /*#__PURE__*/function () {
  function GroupsDetailsController(filterSettings, $scope, Events, $uibModal, $ngRedux, Page, $stateParams, Authenticator) {
    classCallCheck_default()(this, GroupsDetailsController);

    this._initialFilters = filterSettings;
    this._$scope = $scope;
    this._Events = Events;
    this._$stateParams = $stateParams;
    this._Page = Page;
    this._$uibModal = $uibModal;
    this._isBreadCrumbInitialized = false;
    this._Authenticator = Authenticator;
    this._unsubscribe = $ngRedux.connect(this._mapStateToThis.bind(this), this._mapDispatchToThis.call(this))(this);
    $scope.$on('$destroy', this.$onDestroy.bind(this));
  }

  createClass_default()(GroupsDetailsController, [{
    key: "$onInit",
    value: function $onInit() {
      this._$scope.$emit(this._Events.permission.refresh);

      this.fetchGroup(this._initialFilters);
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this.resetToInitialState();

      this._unsubscribe();
    }
  }, {
    key: "_mapDispatchToThis",
    value: function _mapDispatchToThis() {
      var _this = this;

      var groupId = this._$stateParams.groupId;
      return function (dispatch) {
        return {
          resetToInitialState: function resetToInitialState() {
            dispatch(release_groups_timeline_actions_resetToInitialState());
          },
          fetchGroup: function fetchGroup(filters) {
            dispatch(release_groups_timeline_actions_fetchGroup(groupId, filters));
          },
          updateFilters: function updateFilters(filters) {
            dispatch(release_groups_timeline_actions_setFilters(filters));
          },
          addRelease: function addRelease(selectedReleases, close) {
            dispatch(doAddRelease(_this.group.id, selectedReleases, close));
          },
          zoomIn: function zoomIn() {
            dispatch({
              type: release_groups_timeline_actions_actionTypes.ZOOM_IN
            });
          },
          zoomOut: function zoomOut() {
            dispatch({
              type: release_groups_timeline_actions_actionTypes.ZOOM_OUT
            });
          }
        };
      };
    }
  }, {
    key: "_mapStateToThis",
    value: function _mapStateToThis(state) {
      var reducer = state.groupsTimeline;

      if (reducer.group) {
        this._setBreadcrumbs(reducer.group);
      }

      return release_groups_details_controller_objectSpread({
        gantt: reducer.gantt,
        group: reducer.group,
        loading: reducer.loading,
        riskConfig: reducer.riskConfig,
        filters: reducer.filters
      }, reducer.zoomLevel);
    }
  }, {
    key: "_setBreadcrumbs",
    value: function _setBreadcrumbs(group) {
      if (!this._isBreadCrumbInitialized) {
        this._Page.setFolderEntityOpened(group.folderId, group);

        this._isBreadCrumbInitialized = true;
      }
    }
  }, {
    key: "isUpdatable",
    value: function isUpdatable() {
      return isGroupUpdatable(this.group) && this._Authenticator.hasReleaseGroupEditPermission(this.group);
    }
  }, {
    key: "onFiltersChanged",
    value: function onFiltersChanged() {
      this.updateFilters(this.filters);
    }
  }, {
    key: "addReleasesToRele