/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.content;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.StartWelcomeReleaseEvent;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.ReleaseForm;
import com.xebialabs.xlrelease.views.UserView;
import com.xebialabs.xlrelease.views.VariableView;
import com.xebialabs.xlrelease.views.converters.ReleaseFormConverter;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WelcomeTemplateHandler {
    private static final Logger logger = LoggerFactory.getLogger(WelcomeTemplateHandler.class);
    private final ReleaseService releaseService;
    private final ReleaseActorService releaseActorService;
    private final XLReleaseEventBus eventBus;
    private final Scheduler scheduler;
    private final ReleaseFormConverter releaseFormConverter;

    @Autowired
    public WelcomeTemplateHandler(ReleaseService releaseService, ReleaseActorService releaseActorService, XLReleaseEventBus eventBus, Scheduler scheduler, ReleaseFormConverter releaseFormConverter) {
        this.releaseService = releaseService;
        this.releaseActorService = releaseActorService;
        this.eventBus = eventBus;
        this.scheduler = scheduler;
        this.releaseFormConverter = releaseFormConverter;
    }

    @Subscribe
    public void startWelcomeReleaseAsync(StartWelcomeReleaseEvent startWelcomeReleaseEvent) {
        this.scheduler.submit(() -> this.startWelcomeRelease(startWelcomeReleaseEvent.getWelcomeUser(), startWelcomeReleaseEvent.getFullName()));
    }

    private void startWelcomeRelease(String username, String fullName) {
        this.startRelease(username, "Applications/FolderSamplesAndTutorials/ReleaseTemplate_welcome", "Welcome " + fullName, fullName);
        if (XLReleasePermissions.isAdmin((String)username)) {
            this.startRelease(username, "Applications/FolderSamplesAndTutorials/ReleaseTemplate_configure", "Configure Release", fullName);
        }
    }

    private void startRelease(String username, String templateId, String title, String fullName) {
        if (!this.releaseService.exists(templateId)) {
            logger.info("Skipping creation of welcome release because template {} is not in the repository", (Object)templateId);
            return;
        }
        ReleaseForm releaseData = new ReleaseForm();
        releaseData.setOwner(new UserView(username, fullName));
        releaseData.setScheduledStartDate(new DateTime().withHourOfDay(17).withMinuteOfHour(0).toDate());
        releaseData.setDueDate(new DateTime().plusDays(7).withHourOfDay(17).withMinuteOfHour(0).toDate());
        releaseData.setTitle(title);
        releaseData.setVariables(Lists.newArrayList((Object[])new VariableView[]{new VariableView("${user}", username)}));
        Release sourceTemplate = this.releaseService.findById(templateId);
        releaseData.setTags(sourceTemplate.getTags());
        Release welcomeRelease = this.releaseService.createFromTemplate(templateId, this.releaseFormConverter.toRelease(releaseData));
        this.releaseActorService.startReleaseWithoutResponse(welcomeRelease.getId(), User.AUTHENTICATED_USER);
    }

    @PostConstruct
    public void postConstruct() {
        this.eventBus.register(this);
    }

    @PreDestroy
    public void preDestroy() {
        this.eventBus.deregister(this);
    }
}

