/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;

public abstract class RateLimitHandler {
    public static final RateLimitHandler WAIT = new RateLimitHandler(){

        public void onError(IOException e, HttpURLConnection uc) throws IOException {
            try {
                Thread.sleep(this.parseWaitTime(uc));
            }
            catch (InterruptedException x) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
        }

        private long parseWaitTime(HttpURLConnection uc) {
            String v = uc.getHeaderField("X-RateLimit-Reset");
            if (v == null) {
                return 10000L;
            }
            return Math.max(10000L, Long.parseLong(v) * 1000L - System.currentTimeMillis());
        }
    };
    public static final RateLimitHandler FAIL = new RateLimitHandler(){

        public void onError(IOException e, HttpURLConnection uc) throws IOException {
            throw (IOException)new IOException("API rate limit reached").initCause(e);
        }
    };

    public abstract void onError(IOException var1, HttpURLConnection var2) throws IOException;
}

