/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.kohsuke.github.GHBlob;
import org.kohsuke.github.GHTree;
import org.kohsuke.github.GitHub;

public class GHTreeEntry {
    GHTree tree;
    private String path;
    private String mode;
    private String type;
    private String sha;
    private String url;
    private long size;

    public String getPath() {
        return this.path;
    }

    public String getMode() {
        return this.mode;
    }

    public long getSize() {
        return this.size;
    }

    public String getType() {
        return this.type;
    }

    public String getSha() {
        return this.sha;
    }

    public URL getUrl() {
        return GitHub.parseURL(this.url);
    }

    public GHBlob asBlob() throws IOException {
        if (this.type.equals("blob")) {
            return this.tree.repo.getBlob(this.sha);
        }
        return null;
    }

    public InputStream readAsBlob() throws IOException {
        if (this.type.equals("blob")) {
            return this.tree.repo.readBlob(this.sha);
        }
        return null;
    }

    public GHTree asTree() throws IOException {
        if (this.type.equals("tree")) {
            return this.tree.repo.getTree(this.sha);
        }
        return null;
    }
}

