/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.builder;

import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import java.util.Arrays;
import java.util.List;

public class RiskBuilder {
    private String id;
    private int score = 0;
    private int totalScore = 0;
    private List<RiskAssessment> riskAssessments;

    public static RiskBuilder newRisk() {
        return new RiskBuilder();
    }

    public RiskBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public RiskBuilder withScore(int score) {
        this.score = score;
        return this;
    }

    public RiskBuilder withTotalScore(int totalScore) {
        this.totalScore = totalScore;
        return this;
    }

    public RiskBuilder withAssessments(RiskAssessment ... assessments) {
        this.riskAssessments = Arrays.asList(assessments);
        return this;
    }

    public Risk build() {
        Risk risk = (Risk)new Risk().getType().getDescriptor().newInstance(this.id);
        risk.setScore(this.score);
        risk.setTotalScore(this.totalScore);
        if (this.riskAssessments != null) {
            risk.setRiskAssessments(this.riskAssessments);
        }
        return risk;
    }
}

