/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.Diff$;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlReleaseRepositoryHelper;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\r\u0015f\u0001B\u00193\u0001uB\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tU\u0002\u0011)\u0019!C\tW\"Aq\u000e\u0001B\u0001B\u0003%A\u000e\u0003\u0005q\u0001\t\u0015\r\u0011\"\u0005r\u0011!)\bA!A!\u0002\u0013\u0011\b\u0002\u0003<\u0001\u0005\u000b\u0007I\u0011C<\t\u0011m\u0004!\u0011!Q\u0001\naD\u0001\u0002 \u0001\u0003\u0006\u0004%\t\" \u0005\n\u0003\u0007\u0001!\u0011!Q\u0001\nyD!\"!\u0002\u0001\u0005\u000b\u0007I\u0011CA\u0004\u0011)\ty\u0001\u0001B\u0001B\u0003%\u0011\u0011\u0002\u0005\u000b\u0003#\u0001!Q1A\u0005\u0002\u0005M\u0001BCA\u0011\u0001\t\u0005\t\u0015!\u0003\u0002\u0016!Q\u00111\u0005\u0001\u0003\u0006\u0004%\t!!\n\t\u0015\u00055\u0002A!A!\u0002\u0013\t9\u0003\u0003\u0006\u00020\u0001\u0011\t\u0011)A\u0005\u0003cA!\"a\u000e\u0001\u0005\u000b\u0007I1AA\u001d\u0011)\tI\u0007\u0001B\u0001B\u0003%\u00111\b\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\t9\t\u0001C!\u0003\u0013Cq!!3\u0001\t\u0003\nY\rC\u0004\u0002d\u0002!\t%!:\t\u000f\u0005\r\b\u0001\"\u0011\u0002l\"9!\u0011\u0001\u0001\u0005B\t\r\u0001b\u0002B\u001f\u0001\u0011\u0005#q\b\u0005\b\u0005\u000f\u0002A\u0011\u0001B%\u0011\u001d\u0011i\u0007\u0001C!\u0005_BqA!!\u0001\t\u0003\u0011\u0019\tC\u0004\u0003\u0012\u0002!\tEa%\t\u000f\t\u001d\u0006\u0001\"\u0011\u0003*\"9!q\u0016\u0001\u0005\n\tE\u0006b\u0002B]\u0001\u0011\u0005#1\u0018\u0005\b\u0005\u0007\u0004A\u0011\tBc\u0011\u001d\u0011\t\u000e\u0001C!\u0005'DqA!7\u0001\t\u0003\u0012Y\u000eC\u0004\u0003f\u0002!\tEa:\t\u000f\tE\b\u0001\"\u0011\u0003t\"91\u0011\u0001\u0001\u0005B\r\r\u0001bBB\u0006\u0001\u0011\u00053Q\u0002\u0005\b\u0007+\u0001A\u0011IB\f\u0011\u001d\u0019)\u0002\u0001C!\u0007;Aqa!\u000b\u0001\t\u0003\u001aY\u0003C\u0004\u00044\u0001!\te!\u000e\t\u000f\r\u0015\u0003\u0001\"\u0003\u0004H!91q\r\u0001\u0005\n\r%\u0004bBB8\u0001\u0011\u00053\u0011\u000f\u0005\b\u0007\u0017\u0003A\u0011IBG\u0011\u001d\u0019\u0019\n\u0001C!\u0007+\u0013AcU9m%\u0016dW-Y:f%\u0016\u0004xn]5u_JL(BA\u001a5\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003kY\n!B]3q_NLGo\u001c:z\u0015\t9\u0004(A\u0005yYJ,G.Z1tK*\u0011\u0011HO\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aO\u0001\u0004G>l7\u0001A\n\t\u0001y\"\u0005J\u0015.^AB\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n1\u0011I\\=SK\u001a\u0004\"!\u0012$\u000e\u0003QJ!a\u0012\u001b\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010E\u0002J\u00152k\u0011AM\u0005\u0003\u0017J\u0012Q#\u00138uKJ\u001cW\r\u001d;fIJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002N!6\taJ\u0003\u0002Pm\u00051Am\\7bS:L!!\u0015(\u0003\u000fI+G.Z1tKB\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\u0006g24GG\u001b\u0006\u0002/\u0006AqM]5{u2,G-\u0003\u0002Z)\n9Aj\\4hS:<\u0007CA%\\\u0013\ta&G\u0001\fEKN,'/[1mSj\fG/[8o'V\u0004\bo\u001c:u!\tIe,\u0003\u0002`e\tq2i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cWm]*vaB|'\u000f\u001e\t\u0003\u0013\u0006L!A\u0019\u001a\u00035M\u000bHNU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0011\u0016d\u0007/\u001a:\u0002%I,G.Z1tKB+'o]5ti\u0016t7-\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003OJ\n1\u0002]3sg&\u001cH/\u001a8dK&\u0011\u0011N\u001a\u0002\u0013%\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW-A\buCN\\\u0007+\u001a:tSN$XM\\2f+\u0005a\u0007CA3n\u0013\tqgMA\bUCN\\\u0007+\u001a:tSN$XM\\2f\u0003A!\u0018m]6QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\u000beKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3\u0016\u0003I\u0004\"!Z:\n\u0005Q4'!\u0006#fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-Z\u0001\u0017I\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2fA\u0005\u00112m\\7nK:$\b+\u001a:tSN$XM\\2f+\u0005A\bCA3z\u0013\tQhM\u0001\nD_6lWM\u001c;QKJ\u001c\u0018n\u001d;f]\u000e,\u0017aE2p[6,g\u000e\u001e)feNL7\u000f^3oG\u0016\u0004\u0013A\u0004;fC6\u0014V\r]8tSR|'/_\u000b\u0002}B\u0011Qi`\u0005\u0004\u0003\u0003!$A\u0004+fC6\u0014V\r]8tSR|'/_\u0001\u0010i\u0016\fWNU3q_NLGo\u001c:zA\u0005Y\"/\u001a7fCN,W\t\u001f;f]NLwN\\:SKB|7/\u001b;pef,\"!!\u0003\u0011\u0007\u0015\u000bY!C\u0002\u0002\u000eQ\u00121DU3mK\u0006\u001cX-\u0012=uK:\u001c\u0018n\u001c8t%\u0016\u0004xn]5u_JL\u0018\u0001\b:fY\u0016\f7/Z#yi\u0016t7/[8ogJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0019G>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,WCAA\u000b!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000eM\u0006i1m\u001c8gS\u001e,(/\u0019;j_:LA!a\b\u0002\u001a\t\t3i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cW\rU3sg&\u001cH/\u001a8dK\u0006I2m\u001c8gS\u001e,(/\u0019;j_:\u0004VM]:jgR,gnY3!\u0003E\u0011X\r]8tSR|'/_!eCB$XM]\u000b\u0003\u0003O\u00012!SA\u0015\u0013\r\tYC\r\u0002\u0015'Fd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0002%I,\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000fI\u0001\u001aM\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ss\u0012K7\u000f]1uG\",'\u000fE\u0002F\u0003gI1!!\u000e5\u0005e1\u0015mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:\u0002\u0015M\fH\u000eR5bY\u0016\u001cG/\u0006\u0002\u0002<A!\u0011QHA2\u001d\u0011\ty$!\u0018\u000f\t\u0005\u0005\u0013\u0011\f\b\u0005\u0003\u0007\n)F\u0004\u0003\u0002F\u0005Mc\u0002BA$\u0003#rA!!\u0013\u0002P5\u0011\u00111\n\u0006\u0004\u0003\u001bb\u0014A\u0002\u001fs_>$h(C\u0001<\u0013\tI$(\u0003\u00028q%\u0019\u0011q\u000b\u001c\u0002\u0005\u0011\u0014\u0017bA\u001a\u0002\\)\u0019\u0011q\u000b\u001c\n\t\u0005}\u0013\u0011M\u0001\u000b'Fd')^5mI\u0016\u0014(bA\u001a\u0002\\%!\u0011QMA4\u0005\u001d!\u0015.\u00197fGRTA!a\u0018\u0002b\u0005Y1/\u001d7ES\u0006dWm\u0019;!\u0003\u0019a\u0014N\\5u}Q!\u0012qNA;\u0003o\nI(a\u001f\u0002~\u0005}\u0014\u0011QAB\u0003\u000b#B!!\u001d\u0002tA\u0011\u0011\n\u0001\u0005\b\u0003o\u0019\u00029AA\u001e\u0011\u0015\u00197\u00031\u0001e\u0011\u0015Q7\u00031\u0001m\u0011\u0015\u00018\u00031\u0001s\u0011\u001518\u00031\u0001y\u0011\u0015a8\u00031\u0001\u007f\u0011\u001d\t)a\u0005a\u0001\u0003\u0013Aq!!\u0005\u0014\u0001\u0004\t)\u0002C\u0004\u0002$M\u0001\r!a\n\t\u000f\u0005=2\u00031\u0001\u00022\u00051Q\r_5tiN$B!a#\u0002\u0012B\u0019q(!$\n\u0007\u0005=\u0005IA\u0004C_>dW-\u00198\t\u000f\u0005ME\u00031\u0001\u0002\u0016\u0006\u0011\u0011\u000e\u001a\t\u0005\u0003/\u000byJ\u0004\u0003\u0002\u001a\u0006m\u0005cAA%\u0001&\u0019\u0011Q\u0014!\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t+a)\u0003\rM#(/\u001b8h\u0015\r\ti\n\u0011\u0015\u0004)\u0005\u001d\u0006\u0003BAU\u0003_k!!a+\u000b\t\u00055\u0016\u0011M\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u00022\u0006-&AC%t%\u0016\fGm\u00148ms\"\u001aA#!.\u0011\t\u0005]\u0016QY\u0007\u0003\u0003sSA!a/\u0002>\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005}\u0016\u0011Y\u0001\b[\u0016$(/[2t\u0015\r\t\u0019MO\u0001\tG>$\u0017\r[1mK&!\u0011qYA]\u0005\u0015!\u0016.\\3e\u0003\u0019\u0019'/Z1uKR)A*!4\u0002R\"1\u0011qZ\u000bA\u00021\u000bqA]3mK\u0006\u001cX\rC\u0004\u0002TV\u0001\r!!6\u0002+I,G.Z1tK\u000e\u0013X-\u0019;j_:\u001cv.\u001e:dKB!\u0011q[Ao\u001b\t\tINC\u0002\u0002\\:\u000ba!\u001a<f]R\u001c\u0018\u0002BAp\u00033\u0014QCU3mK\u0006\u001cXm\u0011:fCRLwN\\*pkJ\u001cW\rK\u0002\u0016\u0003k\u000b\u0001BZ5oI\nK\u0018\n\u001a\u000b\u0004\u0019\u0006\u001d\bbBAJ-\u0001\u0007\u0011Q\u0013\u0015\u0004-\u0005UF#\u0002'\u0002n\u0006=\bbBAJ/\u0001\u0007\u0011Q\u0013\u0005\b\u0003c<\u0002\u0019AAz\u00039\u0011Xm]8mm\u0016|\u0005\u000f^5p]N\u0004B!!>\u0002|6\u0011\u0011q\u001f\u0006\u0004\u0003s$\u0014!B9vKJL\u0018\u0002BA\u007f\u0003o\u0014aBU3t_24Xm\u00149uS>t7\u000fK\u0002\u0018\u0003k\u000bqBZ5oI&#7OQ=Ti\u0006$Xo\u001d\u000b\u0005\u0005\u000b\u00119\u0002\u0005\u0004\u0003\b\tE\u0011Q\u0013\b\u0005\u0005\u0013\u0011iA\u0004\u0003\u0002J\t-\u0011\"A!\n\u0007\t=\u0001)A\u0004qC\u000e\\\u0017mZ3\n\t\tM!Q\u0003\u0002\u0004'\u0016\f(b\u0001B\b\u0001\"9!\u0011\u0004\rA\u0002\tm\u0011\u0001C:uCR,8/Z:\u0011\u000b}\u0012iB!\t\n\u0007\t}\u0001I\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002BAa\t\u0003*5\u0011!Q\u0005\u0006\u0004\u0005Oq\u0015AB:uCR,8/\u0003\u0003\u0003,\t\u0015\"!\u0004*fY\u0016\f7/Z*uCR,8\u000fK\u0002\u0019\u0003OC3\u0001GA[Q\rA\"1\u0007\t\u0005\u0005k\u0011I$\u0004\u0002\u00038)\u0019\u00111\u0018!\n\t\tm\"q\u0007\u0002\bm\u0006\u0014\u0018M]4t\u0003M1\u0017N\u001c3Cs\u000e\u000bG.\u001a8eCJ$vn[3o)\ra%\u0011\t\u0005\b\u0005\u0007J\u0002\u0019AAK\u00035\u0019\u0017\r\\3oI\u0006\u0014Hk\\6f]\"\u001a\u0011$!.\u00021\u0019Lg\u000eZ!sG\"Lg/\u00192mKJ+G.Z1tK&#7\u000f\u0006\u0004\u0003\u0006\t-#q\f\u0005\b\u0005\u001bR\u0002\u0019\u0001B(\u0003\u0011!\u0017\r^3\u0011\t\tE#1L\u0007\u0003\u0005'RAA!\u0016\u0003X\u0005!Q\u000f^5m\u0015\t\u0011I&\u0001\u0003kCZ\f\u0017\u0002\u0002B/\u0005'\u0012A\u0001R1uK\"9!\u0011\r\u000eA\u0002\t\r\u0014\u0001\u00039bO\u0016\u001c\u0016N_3\u0011\u0007}\u0012)'C\u0002\u0003h\u0001\u00131!\u00138uQ\rQ\u0012q\u0015\u0015\u00045\u0005U\u0016AD:fiB\u0013X-\u0011:dQ&4X\r\u001a\u000b\u0007\u0005c\u00129Ha\u001f\u0011\u0007}\u0012\u0019(C\u0002\u0003v\u0001\u0013A!\u00168ji\"9!\u0011P\u000eA\u0002\u0005U\u0015!\u0003:fY\u0016\f7/Z%e\u0011\u001d\u0011ih\u0007a\u0001\u0003\u0017\u000b1\u0002\u001d:f\u0003J\u001c\u0007.\u001b<fI\"\u001a1$!.\u00023\u0019Lg\u000e\u001a)sK\u0006\u00138\r[5wC\ndWMU3mK\u0006\u001cXm\u001d\u000b\u0007\u0005\u000b\u00139Ia#\u0011\u000b\t\u001d!\u0011\u0003'\t\u000f\t%E\u00041\u0001\u0003d\u0005!\u0001/Y4f\u0011\u001d\u0011\t\u0007\ba\u0001\u0005GB3\u0001HATQ\ra\u0012QW\u0001\u0007g\u0016\f'o\u00195\u0015\t\tU%1\u0014\t\u0006\u0005#\u00129\nT\u0005\u0005\u00053\u0013\u0019F\u0001\u0003MSN$\bb\u0002BO;\u0001\u0007!qT\u0001\rg\u0016\f'o\u00195QCJ\fWn\u001d\t\u0004\u000b\n\u0005\u0016b\u0001BRi\t)\"+\u001a7fCN,7+Z1sG\"\u0014\u0015\u0010U1sC6\u001c\bfA\u000f\u00026\u00061A-\u001a7fi\u0016$BA!\u001d\u0003,\"9\u00111\u0013\u0010A\u0002\u0005U\u0005f\u0001\u0010\u00026\u00069B-\u001a7fi\u0016\u0014V\r\\3bg\u0016\u0014VMZ3sK:\u001cWm\u001d\u000b\u0007\u0005c\u0012\u0019L!.\t\u000f\u0005Mu\u00041\u0001\u0002\u0016\"9!qW\u0010A\u0002\t\r\u0014A\u0003:fY\u0016\f7/Z+jI\u0006iA-\u001a7fi\u0016<\u0016\u000e\u001e5VS\u0012$bA!\u001d\u0003>\n}\u0006bBAJA\u0001\u0007\u0011Q\u0013\u0005\b\u0005o\u0003\u0003\u0019\u0001B2Q\r\u0001\u0013QW\u0001\u0005[>4X\r\u0006\u0004\u0003r\t\u001d'1\u001a\u0005\b\u0005\u0013\f\u0003\u0019AAK\u0003)y'/[4j]\u0006d\u0017\n\u001a\u0005\b\u0005\u001b\f\u0003\u0019AAK\u0003\u0015qWm^%eQ\r\t\u0013QW\u0001\nO\u0016$8\u000b^1ukN$BA!\t\u0003V\"9\u00111\u0013\u0012A\u0002\u0005U\u0005f\u0001\u0012\u00026\u0006Yq-\u001a;Ti\u0006$Xo]3t)\u0011\u0011iNa8\u0011\r\t\u001d!\u0011\u0003B\u0011\u0011\u001d\u0011\to\ta\u0001\u0005\u000b\t1!\u001b3tQ\r\u0019\u0013QW\u0001\u000eO\u0016$(+[:l'\u000e|'/Z:\u0015\t\t%(1\u001e\t\u0007\u0005\u000f\u0011\tBa\u0019\t\u000f\t\u0005H\u00051\u0001\u0003\u0006!\u001aA%a*)\u0007\u0011\n),A\u0007tKR\u0014\u0016n]6TG>\u0014Xm\u001d\u000b\t\u0005c\u0012)Pa>\u0003|\"9!\u0011P\u0013A\u0002\u0005U\u0005b\u0002B}K\u0001\u0007!1M\u0001\u0006g\u000e|'/\u001a\u0005\b\u0005{,\u0003\u0019\u0001B2\u0003)!x\u000e^1m'\u000e|'/\u001a\u0015\u0004K\u0005U\u0016AC5t)\u0016l\u0007\u000f\\1uKR!\u00111RB\u0003\u0011\u001d\u0011IH\na\u0001\u0003+C3AJATQ\r1\u0013QW\u0001\tO\u0016$H+\u001b;mKR!\u0011QSB\b\u0011\u001d\t\u0019j\na\u0001\u0003+C3aJATQ\r9\u0013QW\u0001\u0007kB$\u0017\r^3\u0015\u00071\u001bI\u0002\u0003\u0004\u0002P\"\u0002\r\u0001\u0014\u0015\u0004Q\u0005UF#\u0002'\u0004 \r\r\u0002BBB\u0011S\u0001\u0007A*\u0001\u0005pe&<\u0017N\\1m\u0011\u0019\u0019)#\u000ba\u0001\u0019\u00069Q\u000f\u001d3bi\u0016$\u0007fA\u0015\u00026\u00069!/\u001a9mC\u000e,G#\u0002'\u0004.\r=\u0002BBB\u0011U\u0001\u0007A\n\u0003\u0004\u0004&)\u0002\r\u0001\u0014\u0015\u0004U\u0005U\u0016AC4fi\u0006cG\u000eV1hgR!1qGB\u001f!\u0019\u0011\tf!\u000f\u0002\u0016&!11\bB*\u0005\r\u0019V\r\u001e\u0005\b\u0007\u007fY\u0003\u0019\u0001B2\u0003-a\u0017.\\5u\u001dVl'-\u001a:)\u0007-\n9\u000bK\u0002,\u0003k\u000b!bZ3u%\u0016dW-Y:f)\u0015a5\u0011JB3\u0011\u001d\u0011I\b\fa\u0001\u0007\u0017\u0002Ba!\u0014\u0004`9!1qJB.\u001d\u0011\u0019\tf!\u0017\u000f\t\rM3q\u000b\b\u0005\u0003\u0007\u001a)&\u0003\u00026m%\u00111\u0007N\u0005\u0003OJJ1a!\u0018g\u0003\u0011\u0019\u0015.\u00133\n\t\r\u000541\r\u0002\u0005\u0007&LEMC\u0002\u0004^\u0019Dq!!=-\u0001\u0004\t\u00190\u0001\u0012dQ\u0016\u001c7.S:O_R\u0014VMZ3sK:\u001cW\r\u001a\"z\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d\u000b\u0005\u0005c\u001aY\u0007C\u0004\u0004n5\u0002\raa\u0013\u0002/Ad\u0017M\\%uK6LEm\u0014:JiN\u001c\u0005.\u001b7ee\u0016t\u0017a\u00044j]\u0012\u001c6)\u0014#bi\u0006\u0014\u00150\u00133\u0015\t\rM4Q\u0011\t\u0006\u007f\rU4\u0011P\u0005\u0004\u0007o\u0002%AB(qi&|g\u000e\u0005\u0003\u0004|\r\u0005UBAB?\u0015\u0011\u0019yHa\u0016\u0002\t1\fgnZ\u0005\u0005\u0007\u0007\u001biHA\u0004J]R,w-\u001a:\t\u000f\u0005Me\u00061\u0001\u0002\u0016\"\u001aa&a*)\u00079\n),A\u000bgS:$wJ^3sIV,'+\u001a7fCN,\u0017\nZ:\u0015\u0005\t\u0015\u0001fA\u0018\u0002(\"\u001aq&!.\u0002\u001d\u001d,GOU3mK\u0006\u001cXMS:p]R!\u0011QSBL\u0011\u001d\u0011I\b\ra\u0001\u0003+C3\u0001MATQ\r\u0001\u0014Q\u0017\u0015\u0004\u0001\r}\u0005\u0003BAU\u0007CKAaa)\u0002,\ny\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e")
public class SqlReleaseRepository
implements ReleaseRepository,
InterceptedRepository<Release>,
Logging,
DeserializationSupport,
ConfigurationReferencesSupport,
SqlReleaseRepositoryHelper {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final DependencyPersistence dependencyPersistence;
    private final CommentPersistence commentPersistence;
    private final TeamRepository teamRepository;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect sqlDialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private Seq<PersistenceInterceptor<Release>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void replaceTasks(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceTasks$(this, original, updated);
    }

    @Override
    public void replaceReleaseExtensions(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseExtensions$(this, original, updated);
    }

    @Override
    public void replaceReleaseTeams(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseTeams$(this, original, updated);
    }

    @Override
    public void updateCommentsOnTasks(Task originalTask, Task updatedTask) {
        SqlReleaseRepositoryHelper.updateCommentsOnTasks$(this, originalTask, updatedTask);
    }

    @Override
    public void insertDependency(Integer gateTaskUid, Dependency dependency) {
        SqlReleaseRepositoryHelper.insertDependency$(this, gateTaskUid, dependency);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Release> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseRepository sqlReleaseRepository = this;
        synchronized (sqlReleaseRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Seq<PersistenceInterceptor<Release>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(Seq<PersistenceInterceptor<Release>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public Seq<String> findIdsByStatus(ReleaseStatus ... statuses) {
        return this.findIdsByStatus((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses));
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public CommentPersistence commentPersistence() {
        return this.commentPersistence;
    }

    public TeamRepository teamRepository() {
        return this.teamRepository;
    }

    public ReleaseExtensionsRepository releaseExtensionsRepository() {
        return this.releaseExtensionsRepository;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String id) {
        return this.releasePersistence.existsRelease(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id)));
    }

    @Timed
    public Release create(Release release, ReleaseCreationSource releaseCreationSource) {
        if (this.releasePersistence.existsRelease(release.getId())) {
            throw new ItemAlreadyExistsException("A release with ID [%s] already exists", new Object[]{release.getId()});
        }
        this.interceptCreate((ConfigurationItem)release);
        this.releasePersistence.insert(release);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            SqlReleaseRepository.$anonfun$create$1(this, release, task);
            return BoxedUnit.UNIT;
        });
        release.getExtensions().forEach(extension -> this.releaseExtensionsRepository().create(extension));
        this.updateConfigurationRefs((CiWithUid)release);
        this.facetRepositoryDispatcher.liveRepository().createFromTasks((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala(), this.facetRepositoryDispatcher.liveRepository().createFromTasks$default$2());
        return release;
    }

    @Timed
    public Release findById(String id) {
        return this.getRelease(id, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public Release findById(String id, ResolveOptions resolveOptions) {
        return this.getRelease(id, resolveOptions);
    }

    @Timed
    @IsReadOnly
    public Seq<String> findIdsByStatus(Seq<ReleaseStatus> statuses) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses(statuses).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    @Timed
    public Release findByCalendarToken(String calendarToken) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withCalendarToken(calendarToken).build();
        Seq<ReleaseRow> releases = this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
        return (Release)releases.headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> this.deserializeRelease((ReleaseRow)x$1, new ResolveOptionsBuilder().withEverything().build())).orNull(Predef$.MODULE$.$conforms());
    }

    @Timed
    @IsReadOnly
    public Seq<String> findArchivableReleaseIds(Date date, int pageSize) {
        ReleasesSqlBuilder qual$1 = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED})))).withEndDateBefore(date).withPage(new Page(0L, (long)pageSize, Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4()));
        boolean x$1 = qual$1.withPreArchived$default$1();
        Tuple2 sqlWithParams = qual$1.withPreArchived(x$1).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    @Timed
    public void setPreArchived(String releaseId, boolean preArchived) {
        this.releasePersistence.setPreArchived(releaseId, preArchived);
    }

    @Timed
    @IsReadOnly
    public Seq<Release> findPreArchivableReleases(int page, int pageSize) {
        Seq inactive = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED}));
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withOneOfStatuses((Seq<ReleaseStatus>)inactive).withPreArchived(false).limitAndOffset(pageSize, page * pageSize).build();
        return (Seq)((TraversableLike)((TraversableLike)((TraversableLike)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)x$2, new ResolveOptionsBuilder().withEverything().build())), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isTutorial()))).map((Function1 & Serializable & scala.Serializable)release -> this.releaseExtensionsRepository().decorate(release), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.commentPersistence().decorate((Release)release), Seq$.MODULE$.canBuildFrom());
    }

    @Timed
    public List<Release> search(ReleaseSearchByParams searchParams) {
        ReleaseSearchByParams releaseSearchByParams = searchParams;
        if (releaseSearchByParams == null) {
            throw new MatchError((Object)releaseSearchByParams);
        }
        Page page = releaseSearchByParams.page();
        Either folderId2 = releaseSearchByParams.folderId();
        ReleaseStatus[] statuses = releaseSearchByParams.statuses();
        String title = releaseSearchByParams.title();
        String rootReleaseId = releaseSearchByParams.rootReleaseId();
        boolean autoStart = releaseSearchByParams.autoStart();
        ReleasesSqlBuilder base = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withTitle(title).withRootReleaseId(rootReleaseId).withPage(page);
        ReleasesSqlBuilder sqlBuilder = folderId2 == null ? base : (ReleasesSqlBuilder)folderId2.fold((Function1 & Serializable & scala.Serializable)folderId -> base.withFolder((String)folderId), (Function1 & Serializable & scala.Serializable)ancestorId -> base.withAncestor((String)ancestorId));
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).nonEmpty() ? sqlBuilder.withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses)) : BoxedUnit.UNIT;
        Object object2 = autoStart ? sqlBuilder.withAutoStart() : BoxedUnit.UNIT;
        List list = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlBuilder.build()).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)x$4, new ResolveOptionsBuilder().withEverything().build())), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.releaseExtensionsRepository().decorate(release), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.commentPersistence().decorate((Release)release), Seq$.MODULE$.canBuildFrom())).asJava();
        return list;
    }

    @Timed
    public void delete(String id) {
        this.checkIsNotReferencedByDependencies(id);
        this.releasePersistence.findUidByReleaseId(id).foreach((Function1 & Serializable & scala.Serializable)uid -> {
            this.deleteReleaseReferences(id, uid);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence.deleteById(id);
    }

    private void deleteReleaseReferences(String id, int releaseUid) {
        this.dependencyPersistence().deleteByReleaseUid(Predef$.MODULE$.int2Integer(releaseUid));
        this.commentPersistence().deleteByRelease(Predef$.MODULE$.int2Integer(releaseUid));
        this.taskPersistence().deleteTasksByReleaseUid(releaseUid);
        this.teamRepository().deleteTeamsFromPlatform(new SecuredCi(id, releaseUid));
        this.releaseExtensionsRepository().deleteAll(id);
        this.deleteConfigurationRefs(Predef$.MODULE$.int2Integer(releaseUid));
        this.interceptDelete(id);
    }

    @Timed
    public void deleteWithUid(String id, int releaseUid) {
        this.deleteReleaseReferences(id, releaseUid);
        this.releasePersistence.deleteById(id);
    }

    @Timed
    public void move(String originalId, String newId) {
        this.releasePersistence.move(originalId, newId);
    }

    @Timed
    public ReleaseStatus getStatus(String id) {
        String status = (String)this.releasePersistence.findReleaseStatus(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).orNull(Predef$.MODULE$.$conforms());
        return status == null ? null : ReleaseStatus.valueOf((String)status.toUpperCase());
    }

    @Timed
    public Seq<ReleaseStatus> getStatuses(Seq<String> ids) {
        return ids.isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : (Seq)this.releasePersistence.findReleaseStatuses(ids).map((Function1 & Serializable & scala.Serializable)status -> ReleaseStatus.valueOf((String)status.toUpperCase()), Seq$.MODULE$.canBuildFrom());
    }

    @Timed
    @IsReadOnly
    public Seq<Object> getRiskScores(Seq<String> ids) {
        return this.releasePersistence.findReleaseRiskScores(ids);
    }

    @Timed
    public void setRiskScores(String releaseId, int score, int totalScore) {
        this.releasePersistence.updateReleaseRiskScores(releaseId, score, totalScore);
    }

    @Timed
    @IsReadOnly
    public boolean isTemplate(String releaseId) {
        return ReleaseStatus.TEMPLATE.equals(this.getStatus(releaseId));
    }

    @Timed
    @IsReadOnly
    public String getTitle(String id) {
        return (String)this.releasePersistence.findReleaseTitle(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException("Release [%s] not found", new Object[]{id});
        });
    }

    @Timed
    public Release update(Release release) {
        return this.update(null, release);
    }

    @Timed
    public Release update(Release original, Release updated) {
        Option originalReleaseOpt = Option$.MODULE$.apply((Object)original);
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        originalReleaseOpt.foreach((Function1 & Serializable & scala.Serializable)rel -> {
            SqlReleaseRepository.$anonfun$update$1(this, updated, rel);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    public Release replace(Release original, Release updated) {
        if (Ids.isFolderId((String)original.getId())) {
            updated.setTeams(Collections.emptyList());
        }
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            this.replaceTasks(original, updated);
            this.replaceReleaseExtensions(original, updated);
            this.replaceReleaseTeams(original, updated);
        }
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.releasePersistence.findAllTags(limitNumber)).asJava();
    }

    /*
     * WARNING - void declaration
     */
    private Release getRelease(String releaseId, ResolveOptions resolveOptions) {
        void var3_3;
        BoxedUnit boxedUnit;
        Release release = (Release)this.repositoryAdapter().read(releaseId, resolveOptions);
        if (release == null) {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        }
        if (resolveOptions.hasDecorators()) {
            this.releaseExtensionsRepository().decorate(release);
            boxedUnit = this.commentPersistence().decorate(release);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    private void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        Seq externalIncomingDependencies = (Seq)((TraversableLike)this.dependencyPersistence().findByPartialTargetIds((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{planItemIdOrItsChildren}))), (Option<scala.collection.immutable.Set<String>>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$6 -> DependencyRow$.MODULE$.DependencyRowOps((DependencyRow)x$6).fullDependencyId(), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(planItemIdOrItsChildren)))));
        if (externalIncomingDependencies.nonEmpty()) {
            throw new ItemInUseException(new StringBuilder(68).append("Cannot delete [").append(planItemIdOrItsChildren).append("] because it or one of its children is referenced by ").append(new StringBuilder(28).append("one or more dependencies: [").append(externalIncomingDependencies.mkString(", ")).append("]").toString()).toString(), new Object[0]);
        }
    }

    @Timed
    @IsReadOnly
    public Option<Integer> findSCMDataById(String id) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Finding scm data for template or release with id ").append(id).toString());
        return this.releasePersistence.findSCMDataById(id).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1));
    }

    @Timed
    @IsReadOnly
    public Seq<String> findOverdueReleaseIds() {
        return this.releasePersistence.findOverdueReleaseIds();
    }

    @Timed
    @IsReadOnly
    public String getReleaseJson(String releaseId) {
        return (String)this.releasePersistence.findByReleaseId(releaseId).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.json()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        });
    }

    public static final /* synthetic */ boolean $anonfun$create$2(SqlReleaseRepository $this, Integer taskUid$1, Comment comment) {
        return $this.commentPersistence().create(taskUid$1, CommentPersistence$CommentRow$.MODULE$.fromComment(comment));
    }

    public static final /* synthetic */ void $anonfun$create$1(SqlReleaseRepository $this, Release release$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(release$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)comment -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$create$2($this, taskUid, comment)));
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$3(SqlReleaseRepository $this, Integer taskUid$2, Comment c) {
        return $this.commentPersistence().create(taskUid$2, CommentPersistence$CommentRow$.MODULE$.fromComment(c));
    }

    public static final /* synthetic */ void $anonfun$update$2(SqlReleaseRepository $this, Release updated$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(updated$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$3($this, taskUid, c)));
        ((IterableLike)syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isArchived()))).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$update$1(SqlReleaseRepository $this, Release updated$1, Release rel) {
        Diff$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getAllTasks()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(updated$1.getAllTasks()).asScala()).newValues().foreach((Function1 & Serializable & scala.Serializable)task -> {
            SqlReleaseRepository.$anonfun$update$2($this, updated$1, task);
            return BoxedUnit.UNIT;
        });
    }

    public SqlReleaseRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, DependencyPersistence dependencyPersistence, CommentPersistence commentPersistence, TeamRepository teamRepository, ReleaseExtensionsRepository releaseExtensionsRepository, ConfigurationReferencePersistence configurationPersistence, SqlRepositoryAdapter repositoryAdapter, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect sqlDialect) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.commentPersistence = commentPersistence;
        this.teamRepository = teamRepository;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.configurationPersistence = configurationPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.sqlDialect = sqlDialect;
        InterceptedRepository.$init$((InterceptedRepository)this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        SqlReleaseRepositoryHelper.$init$(this);
    }
}

