/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.repository.sql.persistence;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.EnvironmentPersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.Mappers$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.ApplicationSqlBuilder$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.package$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.ApplicationSchema$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.ApplicationSchema$APPLICATIONS$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentSchema$ENVIRONMENTS$;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.SecurablePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.package;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;

@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\tmc\u0001\u0002\u0012$\u0001IB\u0001\u0002\u0011\u0001\u0003\u0006\u0004%\u0019!\u0011\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u0005\"Aq\n\u0001BC\u0002\u0013\r\u0001\u000b\u0003\u0005i\u0001\t\u0005\t\u0015!\u0003R\u0011!I\u0007A!b\u0001\n\u0007Q\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011B6\t\u0011I\u0004!Q1A\u0005\u0002MD\u0001\u0002\u001f\u0001\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\ts\u0002\u0011)\u0019!C\u0001u\"Aa\u0010\u0001B\u0001B\u0003%1\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\n\u0003w\u0001!\u0019!C\u0005\u0003{A\u0001\"a\u0014\u0001A\u0003%\u0011q\b\u0005\n\u0003#\u0002!\u0019!C\u0005\u0003{A\u0001\"a\u0015\u0001A\u0003%\u0011q\b\u0005\b\u0003+\u0002A\u0011AA,\u0011%\t)\t\u0001b\u0001\n\u0013\ti\u0004\u0003\u0005\u0002\b\u0002\u0001\u000b\u0011BA \u0011%\tI\t\u0001b\u0001\n\u0013\ti\u0004\u0003\u0005\u0002\f\u0002\u0001\u000b\u0011BA \u0011\u001d\ti\t\u0001C\u0001\u0003\u001fC\u0011\"!'\u0001\u0005\u0004%I!!\u0010\t\u0011\u0005m\u0005\u0001)A\u0005\u0003\u007fAq!!(\u0001\t\u0003\ty\nC\u0004\u00022\u0002!\t!a-\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\"9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d\u0007bBAn\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0003s\u0004A\u0011AA~\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+AqA!\u0007\u0001\t\u0013\u0011Y\u0002C\u0004\u00032\u0001!IAa\r\t\u000f\te\u0002\u0001\"\u0003\u0003<\t1\u0012\t\u001d9mS\u000e\fG/[8o!\u0016\u00148/[:uK:\u001cWM\u0003\u0002%K\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\t1s%A\u0002tc2T!\u0001K\u0015\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002+W\u0005aQM\u001c<je>tW.\u001a8ug*\u0011A&L\u0001\nq2\u0014X\r\\3bg\u0016T!AL\u0018\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u0019\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0019\u0014\b\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0004B]f\u0014VM\u001a\t\u0003uyj\u0011a\u000f\u0006\u0003IqR!AJ\u001f\u000b\u0005!Z\u0013BA <\u0005I\u0001VM]:jgR,gnY3TkB\u0004xN\u001d;\u0002\u0019)$'m\u0019+f[Bd\u0017\r^3\u0016\u0003\t\u0003\"a\u0011'\u000e\u0003\u0011S!!\u0012$\u0002\t\r|'/\u001a\u0006\u0003\u000f\"\u000bAA\u001b3cG*\u0011\u0011JS\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t1*A\u0002pe\u001eL!!\u0014#\u0003\u0019)#'m\u0019+f[Bd\u0017\r^3\u0002\u001b)$'m\u0019+f[Bd\u0017\r^3!\u0003\u001d!\u0017.\u00197fGR,\u0012!\u0015\t\u0003%\u0016t!a\u00152\u000f\u0005Q\u0003gBA+_\u001d\t1VL\u0004\u0002X9:\u0011\u0001lW\u0007\u00023*\u0011!,M\u0001\u0007yI|w\u000e\u001e \n\u0003AJ!AL\u0018\n\u00051j\u0013BA0,\u0003\t!'-\u0003\u0002'C*\u0011qlK\u0005\u0003G\u0012\f!bU9m\u0005VLG\u000eZ3s\u0015\t1\u0013-\u0003\u0002gO\n9A)[1mK\u000e$(BA2e\u0003!!\u0017.\u00197fGR\u0004\u0013aC2j\u0013\u0012\u001cVM\u001d<jG\u0016,\u0012a\u001b\t\u0003Y>l\u0011!\u001c\u0006\u0003].\nqa]3sm&\u001cW-\u0003\u0002q[\nY1)[%e'\u0016\u0014h/[2f\u00031\u0019\u0017.\u00133TKJ4\u0018nY3!\u0003Y)gN^5s_:lWM\u001c;QKJ\u001c\u0018n\u001d;f]\u000e,W#\u0001;\u0011\u0005U4X\"A\u0012\n\u0005]\u001c#AF#om&\u0014xN\\7f]R\u0004VM]:jgR,gnY3\u0002/\u0015tg/\u001b:p]6,g\u000e\u001e)feNL7\u000f^3oG\u0016\u0004\u0013\u0001F:fGV\u0014\u0018M\u00197f!\u0016\u00148/[:uK:\u001cW-F\u0001|!\tQD0\u0003\u0002~w\t!2+Z2ve\u0006\u0014G.\u001a)feNL7\u000f^3oG\u0016\fQc]3dkJ\f'\r\\3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003\u0007!B\"!\u0002\u0002\b\u0005\u0015\u0012QFA\u0018\u0003c\u0001\"!\u001e\u0001\t\u000b\u0001[\u00019\u0001\")\u0011\u0005\u001d\u00111BA\u0010\u0003C\u0001B!!\u0004\u0002\u001c5\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0006b]:|G/\u0019;j_:TA!!\u0006\u0002\u0018\u00059a-Y2u_JL(bAA\r\u0011\u0006)!-Z1og&!\u0011QDA\b\u0005%\tV/\u00197jM&,'/A\u0003wC2,X-\t\u0002\u0002$\u0005I\u0002\u0010\u001c:SKB|7/\u001b;pefTEMY2UK6\u0004H.\u0019;f\u0011\u0015y5\u0002q\u0001RQ!\t)#a\u0003\u0002 \u0005%\u0012EAA\u0016\u0003]AHN\u001d*fa>\u001c\u0018\u000e^8ssN\u000bH\u000eR5bY\u0016\u001cG\u000fC\u0003j\u0017\u0001\u000f1\u000eC\u0003s\u0017\u0001\u0007A\u000fC\u0003z\u0017\u0001\u00071\u0010K\u0002\f\u0003k\u0001B!!\u0004\u00028%!\u0011\u0011HA\b\u0005%\tU\u000f^8xSJ,G-\u0001\rT)6#v,\u0013(T\u000bJ#v,\u0011)Q\u0019&\u001b\u0015\tV%P\u001dN+\"!a\u0010\u0011\t\u0005\u0005\u0013\u0011\n\b\u0005\u0003\u0007\n)\u0005\u0005\u0002Yk%\u0019\u0011qI\u001b\u0002\rA\u0013X\rZ3g\u0013\u0011\tY%!\u0014\u0003\rM#(/\u001b8h\u0015\r\t9%N\u0001\u001a'RkEkX%O'\u0016\u0013FkX!Q!2K5)\u0011+J\u001f:\u001b\u0006%A\u0010T)6#v,\u0012-J'R\u001bvLQ-`)&#F*R0J\u000f:{%+R\"B'\u0016\u000b\u0001e\u0015+N)~+\u0005,S*U'~\u0013\u0015l\u0018+J)2+u,S$O\u001fJ+5)Q*FA\u00051\u0011N\\:feR$B!!\u0017\u0002tA!\u00111LA7\u001d\u0011\ti&!\u001b\u000f\t\u0005}\u0013q\r\b\u0005\u0003C\n)GD\u0002V\u0003GJ!\u0001K\u0016\n\u0005\u0019j\u0014B\u0001\u0013=\u0013\r\tYgO\u0001\u0005\u0007&LE-\u0003\u0003\u0002p\u0005E$\u0001B\"j\u0013\u0012T1!a\u001b<\u0011\u001d\t)\b\u0005a\u0001\u0003o\n1\"\u00199qY&\u001c\u0017\r^5p]B!\u0011\u0011PAA\u001b\t\tYHC\u0002+\u0003{R1!a ,\u0003\u0019!w.\\1j]&!\u00111QA>\u0005-\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8\u00021M#V\nV0V!\u0012\u000bE+R0B!Bc\u0015jQ!U\u0013>s5+A\rT)6#v,\u0016)E\u0003R+u,\u0011)Q\u0019&\u001b\u0015\tV%P\u001dN\u0003\u0013AI*U\u001bR{V\tW%T)N{\u0016IT(U\u0011\u0016\u0013v,\u0011)Q?^KE\u000bS0U\u0013RcU)A\u0012T)6#v,\u0012-J'R\u001bv,\u0011(P)\"+%kX!Q!~;\u0016\n\u0016%`)&#F*\u0012\u0011\u0002\rU\u0004H-\u0019;f)\u0011\t\t*a&\u0011\u0007Q\n\u0019*C\u0002\u0002\u0016V\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002vU\u0001\r!a\u001e\u0002=M#V\nV0E\u000b2+E+R0B!Bc\u0015jQ!U\u0013>s5k\u0018\"Z?&#\u0015aH*U\u001bR{F)\u0012'F)\u0016{\u0016\t\u0015)M\u0013\u000e\u000bE+S(O'~\u0013\u0015lX%EA\u00051A-\u001a7fi\u0016$B!!)\u0002.B1\u00111UAU\u0003#k!!!*\u000b\u0007\u0005\u001dV'\u0001\u0003vi&d\u0017\u0002BAV\u0003K\u00131\u0001\u0016:z\u0011\u001d\ty\u000b\u0007a\u0001\u00033\nQ\"\u00199qY&\u001c\u0017\r^5p]&#\u0017\u0001\u00034j]\u0012\u0014\u00150\u00133\u0015\t\u0005U\u00161\u0018\t\u0006i\u0005]\u0016qO\u0005\u0004\u0003s+$AB(qi&|g\u000eC\u0004\u00020f\u0001\r!!\u0017\u0002\u0017\u0019Lg\u000e\u001a\"z)&$H.\u001a\u000b\u0005\u0003k\u000b\t\rC\u0004\u0002Dj\u0001\r!a\u0010\u0002\u000bQLG\u000f\\3\u0002\u0017\u0019Lg\u000eZ+jI\nK\u0018\n\u001a\u000b\u0005\u0003\u0013\fI\u000eE\u00035\u0003o\u000bY\r\u0005\u0003\u0002N\u0006Mg\u0002BA/\u0003\u001fL1!!5<\u0003\u001d\u0001\u0018mY6bO\u0016LA!!6\u0002X\n)1)[+jI*\u0019\u0011\u0011[\u001e\t\u000f\u0005=6\u00041\u0001\u0002Z\u0005aq-\u001a;VS\u0012\u001c()_%egR!\u0011q\\As!!\t\t%!9\u0002Z\u0005-\u0017\u0002BAr\u0003\u001b\u00121!T1q\u0011\u001d\t9\u000f\ba\u0001\u0003S\fa\"\u00199qY&\u001c\u0017\r^5p]&#7\u000f\u0005\u0004\u0002l\u0006M\u0018\u0011\f\b\u0005\u0003[\f\tPD\u0002Y\u0003_L\u0011AN\u0005\u0004\u0003#,\u0014\u0002BA{\u0003o\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003#,\u0014AB:fCJ\u001c\u0007\u000e\u0006\u0003\u0002~\n\r\u0001CBAv\u0003\u007f\f9(\u0003\u0003\u0003\u0002\u0005](aA*fc\"9!QA\u000fA\u0002\t\u001d\u0011!E:rY^KG\u000f\u001b)be\u0006lW\r^3sgB!!\u0011\u0002B\u0007\u001d\r\u0019&1B\u0005\u0004\u0003#$\u0017\u0002\u0002B\b\u0005#\u0011\u0011cU9m/&$\b\u000eU1sC6,G/\u001a:t\u0015\r\t\t\u000eZ\u0001\u0013O\u0016$XI\u001c<je>tW.\u001a8u+&$7\u000f\u0006\u0003\u0002`\n]\u0001bBA;=\u0001\u0007\u0011qO\u0001\u0019S:\u001cXM\u001d;BaB$v.\u00128w%\u00164WM]3oG\u0016\u001cHC\u0002B\u000f\u0005G\u00119\u0003E\u00025\u0005?I1A!\t6\u0005\u0011)f.\u001b;\t\u000f\t\u0015r\u00041\u0001\u0002L\u0006q\u0011\r\u001d9mS\u000e\fG/[8o+&$\u0007b\u0002B\u0015?\u0001\u0007!1F\u0001\bK:4X+\u001b3t!\u0019\t\tE!\f\u0002L&!!qFA'\u0005\r\u0019V\r^\u0001\u0019kB$\u0017\r^3BaB$v.\u00128w%\u00164WM]3oG\u0016\u001cHC\u0002B\u000f\u0005k\u00119\u0004C\u0004\u0002v\u0001\u0002\r!a\u001e\t\u000f\t\u0015\u0002\u00051\u0001\u0002L\u0006A2/\u00198ji&TX-\u00119qY&\u001c\u0017\r^5p]&s\u0007/\u001e;\u0015\t\tu!Q\b\u0005\b\u0003k\n\u0003\u0019AA<Q\r\u0001!\u0011\t\t\u0005\u0005\u0007\u0012I%\u0004\u0002\u0003F)\u0019!q\t3\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0005\u0017\u0012)EA\bJgR\u0013\u0018M\\:bGRLwN\\1mQ\r\u0001!q\n\t\u0005\u0005#\u00129&\u0004\u0002\u0003T)\u0019!Q\u000b%\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0003Z\tM#A\u0003*fa>\u001c\u0018\u000e^8ss\u0002")
public class ApplicationPersistence
implements PersistenceSupport {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final CiIdService ciIdService;
    private final EnvironmentPersistence environmentPersistence;
    private final SecurablePersistence securablePersistence;
    private final String STMT_INSERT_APPLICATIONS;
    private final String STMT_EXISTS_BY_TITLE_IGNORECASE;
    private final String STMT_UPDATE_APPLICATIONS;
    private final String STMT_EXISTS_ANOTHER_APP_WITH_TITLE;
    private final String STMT_DELETE_APPLICATIONS_BY_ID;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;

    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$((PersistenceSupport)this, params);
    }

    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params);
    }

    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$((PersistenceSupport)this, (String)sqlStatement, params, callback);
    }

    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$((PersistenceSupport)this, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$((PersistenceSupport)this, (String)sqlStatement, setup, callback);
    }

    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (String)entityId);
    }

    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (Integer)uid, token, (UUID)freshToken);
    }

    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$((PersistenceSupport)this, (Integer)uid);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, extractor);
    }

    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$((PersistenceSupport)this, (String)sqlStatement, parameters);
    }

    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$((PersistenceSupport)this, (String)pkColumn);
    }

    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$((PersistenceSupport)this, pairs);
    }

    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, (String)text);
    }

    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, (InputStream)inputStream);
    }

    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, (byte[])byteArray);
    }

    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, (byte[])byteArray);
    }

    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$((Utils)this, body, (JdbcTemplate)jdbcTemplate);
    }

    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$((Utils)this, body);
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        ApplicationPersistence applicationPersistence = this;
        synchronized (applicationPersistence) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$((PersistenceSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    public NamedParameterJdbcTemplate namedTemplate() {
        return !this.bitmap$0 ? this.namedTemplate$lzycompute() : this.namedTemplate;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public EnvironmentPersistence environmentPersistence() {
        return this.environmentPersistence;
    }

    public SecurablePersistence securablePersistence() {
        return this.securablePersistence;
    }

    private String STMT_INSERT_APPLICATIONS() {
        return this.STMT_INSERT_APPLICATIONS;
    }

    private String STMT_EXISTS_BY_TITLE_IGNORECASE() {
        return this.STMT_EXISTS_BY_TITLE_IGNORECASE;
    }

    public String insert(Application application) {
        this.sanitizeApplicationInput(application);
        boolean exists = BoxesRunTime.unboxToBoolean((Object)this.sqlQuery(this.STMT_EXISTS_BY_TITLE_IGNORECASE(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()), (Object)application.getTitle())})), (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ApplicationPersistence.$anonfun$insert$1(x$1))).head());
        if (exists) {
            throw new IllegalArgumentException(new StringBuilder(40).append("Application with title '").append(application.getTitle()).append("' already exists").toString());
        }
        Map<String, Integer> environmentUids = this.getEnvironmentUids(application);
        Integer ciUid = this.securablePersistence().insert();
        String appId = package$.MODULE$.createPersistedId(ClassTag$.MODULE$.apply(Application.class), this.ciIdService());
        String displayedAppId = package$.MODULE$.toDisplayId(appId);
        try {
            this.sqlExec(this.STMT_INSERT_APPLICATIONS(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()), (Object)ciUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.ID()), (Object)appId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()), (Object)application.getTitle())})), x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.execute()));
        }
        catch (DuplicateKeyException ex) {
            throw new IllegalArgumentException(new StringBuilder(37).append("Application with ID '").append(displayedAppId).append("' already exists").toString(), ex);
        }
        this.insertAppToEnvReferences(ciUid, (Set<Integer>)environmentUids.valuesIterator().toSet());
        return displayedAppId;
    }

    private String STMT_UPDATE_APPLICATIONS() {
        return this.STMT_UPDATE_APPLICATIONS;
    }

    private String STMT_EXISTS_ANOTHER_APP_WITH_TITLE() {
        return this.STMT_EXISTS_ANOTHER_APP_WITH_TITLE;
    }

    public boolean update(Application application) {
        Integer applicationUid = (Integer)this.findUidById(application.getId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(24).append("Application [").append(application.getId()).append("] not found").toString(), new Object[0]);
        });
        this.sanitizeApplicationInput(application);
        boolean existsAnotherWithSameTitle = BoxesRunTime.unboxToBoolean((Object)this.sqlQuery(this.STMT_EXISTS_ANOTHER_APP_WITH_TITLE(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()), (Object)application.getTitle()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()), (Object)applicationUid)})), (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ApplicationPersistence.$anonfun$update$2(x$3))).head());
        if (existsAnotherWithSameTitle) {
            throw new IllegalArgumentException(new StringBuilder(40).append("Application with title '").append(application.getTitle()).append("' already exists").toString());
        }
        this.updateAppToEnvReferences(application, applicationUid);
        return BoxesRunTime.unboxToBoolean(this.sqlUpdate(this.STMT_UPDATE_APPLICATIONS(), this.paramMap2MapSqlParameterSource((Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()), (Object)applicationUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()), (Object)application.getTitle())}))), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 == 1));
    }

    private String STMT_DELETE_APPLICATIONS_BY_ID() {
        return this.STMT_DELETE_APPLICATIONS_BY_ID;
    }

    public Try<Object> delete(String applicationId) {
        return (Try)this.sqlExec(this.STMT_DELETE_APPLICATIONS_BY_ID(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.ID()), (Object)package$.MODULE$.toPersistedId(applicationId))})), ps -> Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ps.execute()));
    }

    public Option<Application> findById(String applicationId) {
        Tuple2<String, Seq<Object>> tuple2 = ApplicationSqlBuilder$.MODULE$.apply(ApplicationSqlBuilder$.MODULE$.apply$default$1(), this.dialect()).select().withApplicationId(package$.MODULE$.toPersistedId(applicationId)).build();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        Tuple2 tuple23 = tuple22;
        String sql2 = (String)tuple23._1();
        Seq params2 = (Seq)tuple23._2();
        return (Option)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.applicationResultSetExtractor());
    }

    public Option<Application> findByTitle(String title) {
        Tuple2<String, Seq<Object>> tuple2 = ApplicationSqlBuilder$.MODULE$.apply(ApplicationSqlBuilder$.MODULE$.apply$default$1(), this.dialect()).select().withTitle(title).build();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        Tuple2 tuple23 = tuple22;
        String sql2 = (String)tuple23._1();
        Seq params2 = (Seq)tuple23._2();
        return (Option)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.applicationResultSetExtractor());
    }

    public Option<Integer> findUidById(String applicationId) {
        String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(47).append("|SELECT ").append(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()).append("\n          |FROM ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TABLE()).append("\n          |WHERE ").append(ApplicationSchema$APPLICATIONS$.MODULE$.ID()).append(" = :").append(ApplicationSchema$APPLICATIONS$.MODULE$.ID()).toString())).stripMargin();
        return this.sqlQuery(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.ID()), (Object)package$.MODULE$.toPersistedId(applicationId))})), (Function1 & Serializable & scala.Serializable)rs -> package.CiUid$.MODULE$.apply(rs.getInt(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()))).headOption();
    }

    public Map<String, Integer> getUidsByIds(Iterable<String> applicationIds) {
        String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(74).append("|SELECT ").append(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()).append(", ").append(ApplicationSchema$APPLICATIONS$.MODULE$.ID()).append("\n          |FROM ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TABLE()).append("\n          |WHERE ").append(ApplicationSchema$APPLICATIONS$.MODULE$.ID()).append(" IN (:applicationIds)\n       ").toString())).stripMargin();
        return this.sqlQuery(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"applicationIds"), JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)applicationIds.map((Function1 & Serializable & scala.Serializable)id -> package$.MODULE$.toPersistedId((String)id), Iterable$.MODULE$.canBuildFrom())).asJava())})), (Function1 & Serializable & scala.Serializable)rs -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.ResultSetExtension((ResultSet)rs).getCiId(ApplicationSchema$APPLICATIONS$.MODULE$.ID())), (Object)package.CiUid$.MODULE$.apply(rs.getInt(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID())))).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<Application> search(Tuple2<String, Seq<Object>> sqlWithParameters) {
        Tuple2<String, Seq<Object>> tuple2 = sqlWithParameters;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        Tuple2 tuple23 = tuple22;
        String sql2 = (String)tuple23._1();
        Seq params2 = (Seq)tuple23._2();
        return (Seq)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.applicationSearchResultSetExtractor());
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Integer> getEnvironmentUids(Application application) {
        Map map;
        if (CollectionUtils.isEmpty(application.getEnvironments())) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            void var3_3;
            Map<String, Integer> environmentIdsToUids;
            Set environmentIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(application.getEnvironments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getId(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Set environmentDiff = (Set)environmentIds.diff((GenSet)(environmentIdsToUids = this.environmentPersistence().getUidsByIds((Iterable<String>)environmentIds)).keySet());
            if (environmentDiff.nonEmpty()) {
                throw new NotFoundException(new StringBuilder(25).append("Environments [").append(environmentDiff.mkString(", ")).append("] not found").toString(), new Object[0]);
            }
            map = var3_3;
        }
        return map;
    }

    private void insertAppToEnvReferences(Integer applicationUid, Set<Integer> envUids) {
        String insertAppTpEnvStmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(113).append("INSERT INTO ").append(ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.TABLE()).append(" (\n         |").append(ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID()).append(",\n         |").append(ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.ENVIRONMENT_UID()).append("\n         |)\n         |VALUES (\n         |:").append(ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID()).append(",\n         |:").append(ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.ENVIRONMENT_UID()).append("\n         |)\n       ").toString())).stripMargin();
        this.sqlBatch(insertAppTpEnvStmt, (Set<Map<String, Object>>)((Set)envUids.map((Function1 & Serializable & scala.Serializable)envUid -> Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID()), (Object)applicationUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.ENVIRONMENT_UID()), envUid)})), Set$.MODULE$.canBuildFrom())));
    }

    private void updateAppToEnvReferences(Application application, Integer applicationUid) {
        Map<String, Integer> envIdsToUids = this.getEnvironmentUids(application);
        String deleteAppToEnvRefsStmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n         |DELETE FROM ").append(ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.TABLE()).append("\n         | WHERE\n         | ").append(ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID()).append(" = :").append(ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID()).append("\n       ").toString())).stripMargin();
        this.sqlExec(deleteAppToEnvRefsStmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID()), (Object)applicationUid)})), x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.execute()));
        this.insertAppToEnvReferences(applicationUid, (Set<Integer>)envIdsToUids.valuesIterator().toSet());
    }

    private void sanitizeApplicationInput(Application application) {
        application.setTitle(Utils.RichStringAsTruncatable$.MODULE$.trimAndTruncate$extension(Utils$.MODULE$.RichStringAsTruncatable(application.getTitle()), ApplicationSchema$.MODULE$.TITLE_LENGTH()));
    }

    public static final /* synthetic */ boolean $anonfun$insert$1(ResultSet x$1) {
        return x$1.getInt(1) > 0;
    }

    public static final /* synthetic */ boolean $anonfun$update$2(ResultSet x$3) {
        return x$3.getInt(1) > 0;
    }

    @Autowired
    public ApplicationPersistence(@Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, CiIdService ciIdService, EnvironmentPersistence environmentPersistence, SecurablePersistence securablePersistence) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        this.ciIdService = ciIdService;
        this.environmentPersistence = environmentPersistence;
        this.securablePersistence = securablePersistence;
        Utils.$init$((Utils)this);
        CompressionSupport.$init$((CompressionSupport)this);
        PersistenceSupport.$init$((PersistenceSupport)this);
        this.STMT_INSERT_APPLICATIONS = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(160).append("|INSERT INTO ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TABLE()).append("\n        |   ( ").append(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()).append("\n        |   , ").append(ApplicationSchema$APPLICATIONS$.MODULE$.ID()).append("\n        |   , ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()).append("\n        |   )\n        | VALUES\n        |   ( :").append(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()).append("\n        |   , :").append(ApplicationSchema$APPLICATIONS$.MODULE$.ID()).append("\n        |   , :").append(ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()).append("\n        |   )\n        ").toString())).stripMargin();
        this.STMT_EXISTS_BY_TITLE_IGNORECASE = new StringBuilder(46).append("SELECT COUNT(*) FROM ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TABLE()).append(" WHERE LOWER(").append(ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()).append(") = LOWER(:").append(ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()).append(")").toString();
        this.STMT_UPDATE_APPLICATIONS = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(78).append("|UPDATE ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TABLE()).append("\n        | SET\n        |  ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()).append(" = :").append(ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()).append("\n        | WHERE\n        |  ").append(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()).append(" = :").append(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()).append("\n       ").toString())).stripMargin();
        this.STMT_EXISTS_ANOTHER_APP_WITH_TITLE = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(92).append("|SELECT COUNT(*)\n        |FROM ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TABLE()).append("\n        |WHERE LOWER(").append(ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()).append(") = LOWER(:").append(ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()).append(")\n        |AND ").append(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()).append(" <> :").append(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()).append("\n       ").toString())).stripMargin();
        this.STMT_DELETE_APPLICATIONS_BY_ID = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(42).append("|DELETE FROM ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TABLE()).append("\n        | WHERE ").append(ApplicationSchema$APPLICATIONS$.MODULE$.ID()).append(" = :").append(ApplicationSchema$APPLICATIONS$.MODULE$.ID()).append("\n       ").toString())).stripMargin();
    }
}

