/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.xlrelease.api.utils.ResponseHelper;
import com.xebialabs.xlrelease.api.v1.ReleaseApi;
import com.xebialabs.xlrelease.calendar.ReleaseCalendar;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.export.TemplateExporter;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TeamService;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/export")
@Controller
public class ExportResource {
    private static final String ICS_CONTENT_TYPE = "text/calendar";
    private static final String ICS_EXTENSION = ".ics";
    private static final String XLR_EXTENSION = ".xlr";
    private static final String APPLICATION_ZIP_MEDIA_TYPE = "application/zip";
    private PermissionChecker permissions;
    private ReleaseService releaseService;
    private TeamService teamService;
    private ReleaseApi releaseApi;
    private TemplateExporter templateExporter;

    @Autowired
    public ExportResource(PermissionChecker permissions, TemplateExporter templateExporter, ReleaseService releaseService, TeamService teamService, ReleaseApi releaseApi) {
        this.permissions = permissions;
        this.templateExporter = templateExporter;
        this.releaseService = releaseService;
        this.teamService = teamService;
        this.releaseApi = releaseApi;
    }

    @GET
    @Workdir(prefix="download")
    @Path(value="attachments/{attachmentId}")
    @Produces(value={"application/octet-stream"})
    public Response downloadAttachment(@PathParam(value="attachmentId") @IdParam String attachmentId) {
        return this.releaseApi.downloadAttachment(attachmentId);
    }

    @GET
    @Path(value="calendar/{releaseId}")
    @Produces(value={"application/octet-stream"})
    public Response exportReleaseToCalendar(@PathParam(value="releaseId") @IdParam String releaseId) {
        Release release = this.releaseService.findByIdIncludingArchived(releaseId);
        this.permissions.checkView(release);
        this.releaseService.decorateRemovingUnnecessaryFields(release);
        String calendarContent = new ReleaseCalendar(release).toString();
        StreamingOutput output = outputStream -> outputStream.write(calendarContent.getBytes("UTF-8"));
        String fileName = release.getTitle() + ICS_EXTENSION;
        return ResponseHelper.streamFile(fileName, output, ICS_CONTENT_TYPE);
    }

    @GET
    @Workdir(prefix="export")
    @Path(value="zip/{releaseId}")
    @Produces(value={"application/octet-stream"})
    public Response exportTemplateToZip(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkView(releaseId);
        WorkDir workDir = WorkDirContext.get();
        Release release = this.releaseService.findById(releaseId);
        Preconditions.checkArgument((boolean)release.isTemplate(), (Object)"Only templates can be exported.");
        this.teamService.decorateWithEffectiveTeams(release);
        this.releaseService.decorateRemovingUnnecessaryFields(release);
        StreamingOutput output = outputStream -> {
            try {
                this.templateExporter.exportTemplate(release, outputStream);
            }
            finally {
                workDir.delete();
            }
        };
        String fileName = release.getTitle() + XLR_EXTENSION;
        return ResponseHelper.streamFile(fileName, output, APPLICATION_ZIP_MEDIA_TYPE);
    }
}

