/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.jackrabbit.core.journal.AbstractRecord;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;

public class ReadRecord
extends AbstractRecord {
    private final String journalId;
    private final String producerId;
    private final long revision;
    private final DataInputStream dataIn;
    private final int length;
    private boolean consumed;

    public ReadRecord(String journalId, String producerId, long revision, DataInputStream dataIn, int length, NamespaceResolver resolver, NamePathResolver npResolver) {
        super(resolver, npResolver);
        this.journalId = journalId;
        this.producerId = producerId;
        this.revision = revision;
        this.dataIn = dataIn;
        this.length = length;
    }

    public String getJournalId() {
        return this.journalId;
    }

    public String getProducerId() {
        return this.producerId;
    }

    public long getRevision() {
        return this.revision;
    }

    public byte readByte() throws JournalException {
        this.consumed = true;
        try {
            return this.dataIn.readByte();
        }
        catch (IOException e) {
            String msg = "I/O error while reading byte.";
            throw new JournalException(msg, e);
        }
    }

    public char readChar() throws JournalException {
        this.consumed = true;
        try {
            return this.dataIn.readChar();
        }
        catch (IOException e) {
            String msg = "I/O error while reading character.";
            throw new JournalException(msg, e);
        }
    }

    public boolean readBoolean() throws JournalException {
        this.consumed = true;
        try {
            return this.dataIn.readBoolean();
        }
        catch (IOException e) {
            String msg = "I/O error while reading boolean.";
            throw new JournalException(msg, e);
        }
    }

    public int readInt() throws JournalException {
        this.consumed = true;
        try {
            return this.dataIn.readInt();
        }
        catch (IOException e) {
            String msg = "I/O error while reading integer.";
            throw new JournalException(msg, e);
        }
    }

    public String readString() throws JournalException {
        this.consumed = true;
        try {
            boolean isNull = this.dataIn.readBoolean();
            if (isNull) {
                return null;
            }
            return this.dataIn.readUTF();
        }
        catch (IOException e) {
            String msg = "I/O error while reading string.";
            throw new JournalException(msg, e);
        }
    }

    public void readFully(byte[] b) throws JournalException {
        this.consumed = true;
        try {
            this.dataIn.readFully(b);
        }
        catch (IOException e) {
            String msg = "I/O error while reading byte array.";
            throw new JournalException(msg, e);
        }
    }

    public void close() throws IOException {
        if (this.length != 0) {
            if (!this.consumed) {
                this.skip(this.length);
            }
        } else {
            this.dataIn.close();
        }
    }

    private void skip(long n) throws IOException {
        long skiplen;
        long skipped;
        for (skiplen = n; skiplen > 0L && (skipped = this.dataIn.skip(skiplen)) > 0L; skiplen -= skipped) {
        }
        if (skiplen != 0L) {
            String msg = "Should have skipped " + n + " bytes, only " + (n - skiplen) + " skipped.";
            throw new IOException(msg);
        }
    }

    public void writeByte(int n) throws JournalException {
        throw this.unsupported();
    }

    public void writeChar(char c) throws JournalException {
        throw this.unsupported();
    }

    public void writeBoolean(boolean b) throws JournalException {
        throw this.unsupported();
    }

    public void writeInt(int n) throws JournalException {
        throw this.unsupported();
    }

    public void writeString(String s) throws JournalException {
        throw this.unsupported();
    }

    public void writeQName(Name name) throws JournalException {
        throw this.unsupported();
    }

    public void write(byte[] b) throws JournalException {
        throw this.unsupported();
    }

    public void update() throws JournalException {
        throw this.unsupported();
    }

    public void cancelUpdate() {
    }

    private JournalException unsupported() {
        String msg = "Record has been opened read-only.";
        return new JournalException(msg);
    }
}

