/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.security.authentication.CryptedSimpleCredentials;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.core.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.core.security.user.AuthorizableImpl;
import org.apache.jackrabbit.core.security.user.ImpersonationImpl;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.util.Text;

class UserImpl
extends AuthorizableImpl
implements User {
    private final String id;
    private Principal principal = null;
    private Impersonation impersonation = null;

    private UserImpl(NodeImpl node, UserManagerImpl userManager) throws RepositoryException {
        super(node, userManager);
        this.id = node.getProperty(P_USERID).getString();
    }

    static User create(NodeImpl node, UserManagerImpl userManager) throws RepositoryException {
        if (node == null || !node.isNodeType(NT_REP_USER)) {
            throw new IllegalArgumentException();
        }
        if (!Text.isDescendant("/rep:security/rep:authorizables/rep:users", node.getPath())) {
            throw new IllegalArgumentException("User has to be within the User Path");
        }
        return new UserImpl(node, userManager);
    }

    static String buildPasswordValue(String password) throws RepositoryException {
        try {
            CryptedSimpleCredentials creds = new CryptedSimpleCredentials("_", password);
            return creds.getPassword();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public String getID() throws RepositoryException {
        return this.id;
    }

    public boolean isAdmin() {
        return this.userManager.isAdminId(this.id);
    }

    public Credentials getCredentials() throws RepositoryException {
        try {
            String password = this.getNode().getProperty(P_PASSWORD).getString();
            CryptedSimpleCredentials creds = new CryptedSimpleCredentials(this.getID(), password);
            return creds;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean isGroup() {
        return false;
    }

    public Principal getPrincipal() throws RepositoryException {
        if (this.principal == null) {
            this.principal = this.isAdmin() ? new NodeBasedAdminPrincipal(this.getPrincipalName()) : new AuthorizableImpl.NodeBasedPrincipal(this, this.getPrincipalName());
        }
        return this.principal;
    }

    public Impersonation getImpersonation() throws RepositoryException {
        if (this.impersonation == null) {
            this.impersonation = new ImpersonationImpl(this, this.userManager);
        }
        return this.impersonation;
    }

    public void changePassword(String password) throws RepositoryException {
        if (password == null) {
            throw new IllegalArgumentException("The password may never be null.");
        }
        Value v = this.getSession().getValueFactory().createValue(UserImpl.buildPasswordValue(password));
        this.userManager.setProtectedProperty(this.getNode(), P_PASSWORD, v);
    }

    private class NodeBasedAdminPrincipal
    extends AdminPrincipal
    implements ItemBasedPrincipal {
        public NodeBasedAdminPrincipal(String adminId) {
            super(adminId);
        }

        public String getPath() throws RepositoryException {
            return UserImpl.this.getNode().getPath();
        }
    }
}

