/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plumbing.IgnoreArrayEmptyValues;
import com.xebialabs.deployit.plumbing.PasswordDeserializer;
import com.xebialabs.deployit.plumbing.PasswordSerializer;
import com.xebialabs.deployit.plumbing.id.DomainIdDeserializer;
import com.xebialabs.deployit.plumbing.id.DomainIdSerializer;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.views.Flag;
import com.xebialabs.xlrelease.views.UserView;
import com.xebialabs.xlrelease.views.VariableView;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ReleaseForm {
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String templateId;
    private Date scheduledStartDate;
    private boolean autoStart;
    private Date dueDate;
    private String title;
    private String description;
    private UserView owner;
    private List<VariableView> variables = Lists.newArrayList();
    @JsonDeserialize(using=IgnoreArrayEmptyValues.class)
    private List<String> tags;
    private Flag flag = new Flag(FlagStatus.OK);
    private boolean calendarPublished;
    private Long plannedDuration;
    private boolean abortOnFailure;
    private boolean allowPasswordsInAllFields;
    private boolean allowConcurrentReleaseFromTrigger;
    private UserView scriptUsername;
    @JsonSerialize(using=PasswordSerializer.class)
    @JsonDeserialize(using=PasswordDeserializer.class)
    private String scriptUserPassword;
    private String parentId;
    private Map<String, Object> syntheticProperties = new HashMap<String, Object>();

    public boolean hasValidDates() {
        if (this.scheduledStartDate != null && this.dueDate != null) {
            return new DateTime((Object)this.scheduledStartDate).isBefore((ReadableInstant)new DateTime((Object)this.dueDate));
        }
        return true;
    }

    public boolean isFromTemplate() {
        return null != this.templateId;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public Date getScheduledStartDate() {
        return this.scheduledStartDate;
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public String getDescription() {
        return this.description;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public UserView getOwner() {
        return this.owner;
    }

    public String getOwnerUsername() {
        return this.hasOwner() ? this.getOwner().getUsername() : null;
    }

    public void setOwner(UserView owner) {
        this.owner = owner;
    }

    public List<VariableView> getVariables() {
        return this.variables;
    }

    public void setVariables(List<VariableView> variables) {
        this.variables = variables;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public void setFlag(Flag flag) {
        this.flag = flag;
    }

    public boolean isCalendarPublished() {
        return this.calendarPublished;
    }

    public void setCalendarPublished(boolean calendarPublished) {
        this.calendarPublished = calendarPublished;
    }

    public boolean isAbortOnFailure() {
        return this.abortOnFailure;
    }

    public void setAbortOnFailure(boolean abortOnFailure) {
        this.abortOnFailure = abortOnFailure;
    }

    public boolean isAllowPasswordsInAllFields() {
        return this.allowPasswordsInAllFields;
    }

    public void setAllowPasswordsInAllFields(boolean allowPasswordsInAllFields) {
        this.allowPasswordsInAllFields = allowPasswordsInAllFields;
    }

    public Long getPlannedDuration() {
        return this.plannedDuration;
    }

    public void setPlannedDuration(Long plannedDuration) {
        this.plannedDuration = plannedDuration;
    }

    public boolean isAllowConcurrentReleaseFromTrigger() {
        return this.allowConcurrentReleaseFromTrigger;
    }

    public void setAllowConcurrentReleasesFromTrigger(boolean allowConcurrentReleasesFromTrigger) {
        this.allowConcurrentReleaseFromTrigger = allowConcurrentReleasesFromTrigger;
    }

    public UserView getScriptUsername() {
        return this.scriptUsername;
    }

    public void setScriptUsername(UserView scriptUsername) {
        this.scriptUsername = scriptUsername;
    }

    public String getScriptUserPassword() {
        return this.scriptUserPassword;
    }

    public void setScriptUserPassword(String scriptUserPassword) {
        this.scriptUserPassword = scriptUserPassword;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Map<String, Object> getSyntheticProperties() {
        return this.syntheticProperties;
    }

    public boolean hasProperty(String name) {
        return this.syntheticProperties.containsKey(name);
    }

    public Object getProperty(String name) {
        return this.syntheticProperties.get(name);
    }

    public void setSyntheticProperties(Map<String, Object> syntheticProperties) {
        this.syntheticProperties = syntheticProperties;
    }
}

