/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.GlobalVariableCreatedEvent;
import com.xebialabs.xlrelease.domain.events.GlobalVariableDeletedEvent;
import com.xebialabs.xlrelease.domain.events.GlobalVariableUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariableCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariableDeletedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariableReplacedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariableUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariablesUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TemplateVariablesChangedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.variables.GlobalVariables;
import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.VariableReference;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseVariableRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.TaskBackup;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\t=d\u0001\u0002\u0010 \u0001!B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011!Y\u0005A!A!\u0002\u0013a\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u0011M\u0003!\u0011!Q\u0001\nQCQA\u0017\u0001\u0005\u0002mCQa\u001d\u0001\u0005\u0002QDq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u00022\u0001!I!a\r\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:!9\u0011Q\b\u0001\u0005\u0002\u0005}\u0002bBA&\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003C\u0002A\u0011AA2\u0011\u001d\t\t\u0007\u0001C\u0001\u0003wBq!!$\u0001\t\u0003\ty\tC\u0004\u0002\u001a\u0002!\t!a'\t\u000f\u0005\u0015\u0006\u0001\"\u0003\u0002\u001c\"9\u0011q\u0015\u0001\u0005\u0002\u0005%\u0006bBAY\u0001\u0011\u0005\u00111\u0017\u0005\b\u0003s\u0003A\u0011AA^\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013Dq!!5\u0001\t\u0003\t\u0019\u000eC\u0004\u0002t\u0002!I!!>\t\u000f\tE\u0001\u0001\"\u0003\u0003\u0014!9!\u0011\u0004\u0001\u0005\n\tm\u0001b\u0002B\u0014\u0001\u0011%!\u0011\u0006\u0005\b\u00057\u0002A\u0011\u0002B/\u0005=1\u0016M]5bE2,7+\u001a:wS\u000e,'B\u0001\u0011\"\u0003\u001d\u0019XM\u001d<jG\u0016T!AI\u0012\u0002\u0013ad'/\u001a7fCN,'B\u0001\u0013&\u0003%AXMY5bY\u0006\u00147OC\u0001'\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0011f\f\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014!B:mMRR'\"\u0001\u001b\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!AN\u0019\u0003\u000f1{wmZ5oO\u000692m\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0003sqj\u0011A\u000f\u0006\u0003w\u0005\n!B]3q_NLGo\u001c:z\u0013\ti$HA\fD_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0005e\u0002\u0015BA!;\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\u0013m\u0006\u0014\u0018.\u00192mKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002:\t&\u0011QI\u000f\u0002\u001a%\u0016dW-Y:f-\u0006\u0014\u0018.\u00192mKJ+\u0007o\\:ji>\u0014\u00180\u0001\tbe\u000eD\u0017N^5oON+'O^5dKB\u0011\u0001*S\u0007\u0002?%\u0011!j\b\u0002\u0011\u0003J\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\f1bY5JIN+'O^5dKB\u0011\u0001*T\u0005\u0003\u001d~\u00111bQ5JIN+'O^5dK\u0006QA/Y:l\u0005\u0006\u001c7.\u001e9\u0011\u0005!\u000b\u0016B\u0001* \u0005)!\u0016m]6CC\u000e\\W\u000f]\u0001\tKZ,g\u000e\u001e\"vgB\u0011Q\u000bW\u0007\u0002-*\u0011q+I\u0001\u0007KZ,g\u000e^:\n\u0005e3&!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u00061A(\u001b8jiz\"\u0002\u0002X/_?\u0002\f'm\u0019\t\u0003\u0011\u0002AQa\u000e\u0005A\u0002aBQA\u0010\u0005A\u0002}BQA\u0011\u0005A\u0002\rCQA\u0012\u0005A\u0002\u001dCQa\u0013\u0005A\u00021CQa\u0014\u0005A\u0002ACQa\u0015\u0005A\u0002QC#\u0001C3\u0011\u0005\u0019\fX\"A4\u000b\u0005!L\u0017AC1o]>$\u0018\r^5p]*\u0011!n[\u0001\bM\u0006\u001cGo\u001c:z\u0015\taW.A\u0003cK\u0006t7O\u0003\u0002o_\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001q\u0003\ry'oZ\u0005\u0003e\u001e\u0014\u0011\"Q;u_^L'/\u001a3\u00023\u0019Lg\u000e\u001a\"z\u0013\u0012Len\u00197vI&tw-\u0011:dQ&4X\r\u001a\u000b\u0003kv\u0004\"A^>\u000e\u0003]T!\u0001_=\u0002\u0013Y\f'/[1cY\u0016\u001c(B\u0001>\"\u0003\u0019!w.\\1j]&\u0011Ap\u001e\u0002\t-\u0006\u0014\u0018.\u00192mK\")a0\u0003a\u0001\u007f\u0006Qa/\u0019:jC\ndW-\u00133\u0011\t\u0005\u0005\u0011q\u0002\b\u0005\u0003\u0007\tY\u0001E\u0002\u0002\u0006-j!!a\u0002\u000b\u0007\u0005%q%\u0001\u0004=e>|GOP\u0005\u0004\u0003\u001bY\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0012\u0005M!AB*ue&twMC\u0002\u0002\u000e-B3!CA\f!\u0011\tI\"!\n\u000e\u0005\u0005m!b\u00015\u0002\u001e)!\u0011qDA\u0011\u0003\u001diW\r\u001e:jGNT1!a\t&\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA\u0014\u00037\u0011Q\u0001V5nK\u0012\f\u0001BZ5oI\nK\u0018\n\u001a\u000b\u0004k\u00065\u0002\"\u0002@\u000b\u0001\u0004y\bf\u0001\u0006\u0002\u0018\u00059b-\u001b8e%\u0016dW-Y:f-\u0006\u0014\u0018.\u00192mK\nK\u0018\n\u001a\u000b\u0004k\u0006U\u0002\"\u0002@\f\u0001\u0004y\u0018A\u00064j]\u0012<En\u001c2bYZ\u000b'/[1cY\u0016\u0014\u00150\u00133\u0015\u0007U\fY\u0004C\u0003\u007f\u0019\u0001\u0007q0A\u0005gS:$')_&fsR)Q/!\u0011\u0002F!1\u00111I\u0007A\u0002}\fAB^1sS\u0006\u0014G.\u001a(b[\u0016Da!a\u0012\u000e\u0001\u0004y\u0018!\u0003:fY\u0016\f7/Z%eQ\ri\u0011qC\u0001\fC\u0012$g+\u0019:jC\ndW\rF\u0003v\u0003\u001f\nY\u0006C\u0004\u0002R9\u0001\r!a\u0015\u0002\u000fI,G.Z1tKB!\u0011QKA,\u001b\u0005I\u0018bAA-s\n9!+\u001a7fCN,\u0007BBA/\u001d\u0001\u0007Q/\u0001\u0005wCJL\u0017M\u00197fQ\rq\u0011qC\u0001\u0017kB$\u0017\r^3SK2,\u0017m]3WCJL\u0017M\u00197fgR1\u00111KA3\u0003OBq!!\u0015\u0010\u0001\u0004\t\u0019\u0006\u0003\u0004y\u001f\u0001\u0007\u0011\u0011\u000e\t\u0006\u0003W\n)(^\u0007\u0003\u0003[RA!a\u001c\u0002r\u0005!Q\u000f^5m\u0015\t\t\u0019(\u0001\u0003kCZ\f\u0017\u0002BA<\u0003[\u0012A\u0001T5ti\"\u001aq\"a\u0006\u0015\u0011\u0005M\u0013QPA@\u0003\u0003Cq!!\u0015\u0011\u0001\u0004\t\u0019\u0006\u0003\u0004y!\u0001\u0007\u0011\u0011\u000e\u0005\b\u0003\u0007\u0003\u0002\u0019AAC\u0003!1\u0018\r\\5eCR,\u0007c\u0001\u0016\u0002\b&\u0019\u0011\u0011R\u0016\u0003\u000f\t{w\u000e\\3b]\"\u001a\u0001#a\u0006\u0002\u001dU\u0004H-\u0019;f-\u0006\u0014\u0018.\u00192mKR)Q/!%\u0002\u0014\"9\u0011\u0011K\tA\u0002\u0005M\u0003BBAK#\u0001\u0007Q/A\u0004va\u0012\fG/\u001a3)\u0007E\t9\"\u0001\u000egS:$w\t\\8cC24\u0016M]5bE2,7o\u0014:F[B$\u0018\u0010\u0006\u0002\u0002\u001eB\u0019a/a(\n\u0007\u0005\u0005vOA\bHY>\u0014\u0017\r\u001c,be&\f'\r\\3tQ\r\u0011\u0012qC\u0001\u0014M&tGm\u00127pE\u0006dg+\u0019:jC\ndWm]\u0001\u0012C\u0012$w\t\\8cC24\u0016M]5bE2,GcA;\u0002,\"1\u0011Q\u0016\u000bA\u0002U\f\u0011A\u001e\u0015\u0004)\u0005]\u0011\u0001F;qI\u0006$Xm\u00127pE\u0006dg+\u0019:jC\ndW\rF\u0002v\u0003kCa!!&\u0016\u0001\u0004)\bfA\u000b\u0002\u0018\u0005!B-\u001a7fi\u0016<En\u001c2bYZ\u000b'/[1cY\u0016$B!!0\u0002DB\u0019!&a0\n\u0007\u0005\u00057F\u0001\u0003V]&$\b\"\u0002@\u0017\u0001\u0004y\bf\u0001\f\u0002\u0018\u0005qA-\u001a7fi\u00164\u0016M]5bE2,GCBA_\u0003\u0017\fi\rC\u0004\u0002R]\u0001\r!a\u0015\t\u000by<\u0002\u0019A@)\u0007]\t9\"A\bsKBd\u0017mY3WCJL\u0017M\u00197f)!\ti,!6\u0002X\u0006e\u0007bBA)1\u0001\u0007\u00111\u000b\u0005\u0007\u0003;B\u0002\u0019A;\t\u000f\u0005m\u0007\u00041\u0001\u0002^\u0006Y!/\u001a9mC\u000e,W.\u001a8u!\u0011\ty.!<\u000e\u0005\u0005\u0005(\u0002BAr\u0003K\fQAZ8s[NTA!a:\u0002j\u0006\u0011a/\r\u0006\u0004\u0003W\f\u0013aA1qS&!\u0011q^Aq\u0005=1\u0016M]5bE2,wJ\u001d,bYV,\u0007f\u0001\r\u0002\u0018\u0005\u00192\r[3dWJ+g.Y7f-\u0006d\u0017\u000eZ5usRA\u0011QXA|\u0005\u0017\u0011y\u0001\u0003\u0004y3\u0001\u0007\u0011\u0011 \t\u0006\u0003w\u0014)!\u001e\b\u0005\u0003{\u0014\tA\u0004\u0003\u0002\u0006\u0005}\u0018\"\u0001\u0017\n\u0007\t\r1&A\u0004qC\u000e\\\u0017mZ3\n\t\t\u001d!\u0011\u0002\u0002\u0004'\u0016\f(b\u0001B\u0002W!1!QB\rA\u0002U\fqaY;se\u0016tG\u000f\u0003\u0004\u0002\u0016f\u0001\r!^\u0001\u000eG\",7m[*b[\u0016$\u0016\u0010]3\u0015\r\u0005u&Q\u0003B\f\u0011\u0019\u0011iA\u0007a\u0001k\"1\u0011Q\u0013\u000eA\u0002U\f\u0011$\u001e9eCR,g+\u0019:jC\ndW-\u00118e!J|g/\u001b3feRIQO!\b\u0003\"\t\r\"Q\u0005\u0005\u0007\u0005?Y\u0002\u0019A@\u0002\u0011A\f'/\u001a8u\u0013\u0012DaA!\u0004\u001c\u0001\u0004)\bBBAK7\u0001\u0007Q\u000fC\u0004\u0002Rm\u0001\r!a\u0015\u0002!U\u0004H-\u0019;f+N\fw-\u001a)pS:$H\u0003\u0003B\u0016\u0005\u000f\u00129F!\u0017\u0011\r\u0005\u0005!Q\u0006B\u0019\u0013\u0011\u0011y#a\u0005\u0003\u0007M+G\u000f\u0005\u0003\u00034\t\rSB\u0001B\u001b\u0015\u0011\u00119D!\u000f\u0002\u0007U$WN\u0003\u0003\u0002l\nm\"\u0002\u0002B\u001f\u0005\u007f\ta\u0001\u001d7vO&t'b\u0001B!G\u0005AA-\u001a9m_fLG/\u0003\u0003\u0003F\tU\"!E\"p]\u001aLw-\u001e:bi&|g.\u0013;f[\"9!\u0011\n\u000fA\u0002\t-\u0013AA;q!\u0011\u0011iEa\u0015\u000e\u0005\t=#b\u0001B)o\u0006I!/\u001a4fe\u0016t7-Z\u0005\u0005\u0005+\u0012yE\u0001\u0006Vg\u0006<W\rU8j]RDa!!\u0018\u001d\u0001\u0004)\bbBAn9\u0001\u0007\u0011Q\\\u0001\u0010gft7\r\u0016:jO\u001e,'OV1sgR!\u0011Q\u0018B0\u0011\u001d\t\t&\ba\u0001\u0003'B3\u0001\u0001B2!\u0011\u0011)Ga\u001b\u000e\u0005\t\u001d$b\u0001B5[\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\t5$q\r\u0002\b'\u0016\u0014h/[2f\u0001")
public class VariableService
implements Logging {
    private final ConfigurationRepository configurationRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseVariableRepository variableRepository;
    private final ArchivingService archivingService;
    private final CiIdService ciIdService;
    private final TaskBackup taskBackup;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        VariableService variableService = this;
        synchronized (variableService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Variable findByIdIncludingArchived(String variableId) {
        Variable variable;
        if (VariableHelper$.MODULE$.isGlobalVariableId(variableId)) {
            variable = this.findGlobalVariableById(variableId);
        } else if (this.variableRepository.exists(variableId)) {
            variable = this.findById(variableId);
        } else if (this.archivingService.exists(variableId)) {
            variable = this.archivingService.getVariable(variableId);
        } else {
            throw new NotFoundException(new StringBuilder(55).append("Variable [").append(variableId).append("] does not exist in the repository or archive").toString(), new Object[0]);
        }
        return variable;
    }

    @Timed
    public Variable findById(String variableId) {
        return VariableHelper$.MODULE$.isGlobalVariableId(variableId) ? this.findGlobalVariableById(variableId) : this.findReleaseVariableById(variableId);
    }

    private Variable findReleaseVariableById(String variableId) {
        return this.variableRepository.findById(variableId);
    }

    private Variable findGlobalVariableById(String variableId) {
        return (Variable)this.configurationRepository.read(variableId);
    }

    @Timed
    public Variable findByKey(String variableName, String releaseId) {
        String string = variableName;
        Variable variable = Strings.isNotBlank((String)string) ? this.variableRepository.findByKey(string, releaseId) : null;
        return variable;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Variable addVariable(Release release, Variable variable) {
        void var3_3;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Adding new variable with key [").append(variable.getKey()).append("] to release [").append(release.getId()).append("]").toString());
        if (variable.isPassword()) {
            ((PasswordStringVariable)variable).checkExternalPasswordVariable();
        }
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option<ConfigurationItem>)None$.MODULE$, (ConfigurationItem)variable);
        release.addVariable(variable);
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(release.getId(), release.getVariables(), this.ciIdService);
        Object object = !release.getVariableById(variable.getId()).isPresent() ? release.addVariable(variable) : BoxedUnit.UNIT;
        this.syncTriggerVars(release);
        Variable created = this.variableRepository.create(variable, release);
        this.eventBus.publish((XLReleaseEvent)new ReleaseVariableCreatedEvent(variable));
        return var3_3;
    }

    @Timed
    public Release updateReleaseVariables(Release release, java.util.List<Variable> variables) {
        return this.updateReleaseVariables(release, variables, true);
    }

    @Timed
    public Release updateReleaseVariables(Release release, java.util.List<Variable> variables, boolean validate) {
        variables.forEach(variable -> Checks.checkArgument((!com.google.common.base.Strings.isNullOrEmpty((String)variable.getKey()) ? 1 : 0) != 0, (String)"Variable must have a 'key' field", (Object[])new Object[0]));
        java.util.List originalVariables = release.getVariables();
        if (validate) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(variables).asScala()).foreach((Function1 & Serializable & scala.Serializable)v -> {
                VariableService.$anonfun$updateReleaseVariables$2(originalVariables, v);
                return BoxedUnit.UNIT;
            });
        }
        release.setVariables(variables);
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(release.getId(), release.getVariables(), this.ciIdService);
        this.syncTriggerVars(release);
        this.variableRepository.update((Seq<Variable>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(originalVariables).asScala()), (Seq<Variable>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(variables).asScala()), release);
        this.eventBus.publish((XLReleaseEvent)new ReleaseVariablesUpdatedEvent(originalVariables, variables));
        return release;
    }

    @Timed
    public Variable updateVariable(Release release, Variable updated) {
        Variable updatedVariable;
        block3: {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Updating variable [").append(updated.getId()).append("]").toString());
            updated.checkValidity();
            Variable current = this.findById(updated.getId());
            this.checkSameType(current, updated);
            String string = current.getKey();
            String string2 = updated.getKey();
            if (string == null ? string2 != null : !string.equals(string2)) {
                ReleaseStatus releaseStatus = release.getStatus();
                ReleaseStatus releaseStatus2 = ReleaseStatus.TEMPLATE;
                if (releaseStatus == null ? releaseStatus2 != null : !releaseStatus.equals(releaseStatus2)) {
                    ReleaseStatus releaseStatus3 = release.getStatus();
                    ReleaseStatus releaseStatus4 = ReleaseStatus.PLANNED;
                    if (releaseStatus3 == null ? releaseStatus4 != null : !releaseStatus3.equals(releaseStatus4)) {
                        throw new IllegalStateException(new StringBuilder(53).append("Cannot rename variable ").append(updated.getId()).append(" of an already started release").toString());
                    }
                }
                this.checkRenameValidity((Seq<Variable>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(release.getVariables()).asScala()), current, updated);
            }
            updatedVariable = this.updateVariableAndProvider(release.getId(), current, updated, release);
            this.eventBus.publish((XLReleaseEvent)new ReleaseVariableUpdatedEvent(current, updated));
            String string3 = current.getKey();
            String string4 = updated.getKey();
            if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block3;
            this.replaceVariableUsages$1(current, updatedVariable, release);
        }
        return updatedVariable;
    }

    @Timed
    public GlobalVariables findGlobalVariablesOrEmpty() {
        return this.findGlobalVariables();
    }

    /*
     * WARNING - void declaration
     */
    private GlobalVariables findGlobalVariables() {
        void var1_1;
        GlobalVariables globalVariables = new GlobalVariables();
        globalVariables.setVariables(this.configurationRepository.findAllByType(Type.valueOf(Variable.class)));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Variable addGlobalVariable(Variable v) {
        void var3_3;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Adding new global variable with key [").append(v.getKey()).append("]").toString());
        if (v.isPassword()) {
            ((PasswordStringVariable)v).checkExternalPasswordVariable();
        }
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option<ConfigurationItem>)None$.MODULE$, (ConfigurationItem)v);
        GlobalVariables globalVars = this.findGlobalVariables();
        Variable newVariable = globalVars.addVariable(v);
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(globalVars.getId(), globalVars.getVariables(), this.ciIdService);
        this.configurationRepository.create(newVariable);
        this.eventBus.publish((XLReleaseEvent)new GlobalVariableCreatedEvent(newVariable, null));
        return var3_3;
    }

    @Timed
    public Variable updateGlobalVariable(Variable updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Updating global variable [").append(updated.getId()).append("]").toString());
        updated.checkGlobalVariableValidity();
        Variable current = this.findGlobalVariableById(updated.getId());
        this.checkSameType(current, updated);
        GlobalVariables globalVars = this.findGlobalVariables();
        String string = current.getKey();
        String string2 = updated.getKey();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.checkRenameValidity((Seq<Variable>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(globalVars.getVariables()).asScala()), current, updated);
        }
        Variable variable = this.updateVariableAndProvider(globalVars.getId(), current, updated, null);
        this.eventBus.publish((XLReleaseEvent)new GlobalVariableUpdatedEvent(current, variable, null));
        return variable;
    }

    @Timed
    public void deleteGlobalVariable(String variableId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Deleting global variable [").append(variableId).append("]").toString());
        Variable variable = this.findGlobalVariableById(variableId);
        this.configurationRepository.delete(variableId);
        this.eventBus.publish((XLReleaseEvent)new GlobalVariableDeletedEvent(variable, null));
    }

    @Timed
    public void deleteVariable(Release release, String variableId) {
        Variable variable = (Variable)release.getVariableById(variableId).orElseThrow(() -> new NotFoundException(new StringBuilder(30).append("Repository entity [").append(variableId).append("] not found").toString(), new Object[0]));
        release.removeVariable(variableId);
        release.getAllUserInputTasks().forEach(task -> $this.taskBackup.removeVariable((UserInputTask)task, variableId));
        this.syncTriggerVars(release);
        this.variableRepository.delete(variableId, release);
        this.eventBus.publish((XLReleaseEvent)new ReleaseVariableDeletedEvent(variable));
    }

    @Timed
    public void replaceVariable(Release release, Variable variable, VariableOrValue replacement) {
        if (replacement.getVariable() == null && replacement.getValue() == null) {
            replacement.setValue(variable.getEmptyValue());
        } else if (variable.isPassword()) {
            replacement.setValue((Object)PasswordVerificationUtils$.MODULE$.replacePasswordIfNeeded(variable.getValue(), replacement.getValue()));
        }
        if (replacement.getVariable() != null) {
            replacement.setVariable(VariableHelper$.MODULE$.formatVariableIfNeeded(replacement.getVariable()));
        }
        Set cis = (Set)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(release.collectVariableReferences()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)varRef -> BoxesRunTime.boxToBoolean((boolean)VariableService.$anonfun$replaceVariable$1(variable, varRef))).flatMap((Function1 & Serializable & scala.Serializable)varRef -> (Set)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(varRef.getUsagePoints()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)up -> (scala.collection.immutable.Set)this.updateUsagePoint((UsagePoint)up, variable, replacement).map((Function1 & Serializable & scala.Serializable)u -> u, Set$.MODULE$.canBuildFrom()), scala.collection.mutable.Set$.MODULE$.canBuildFrom()), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService);
        this.syncTriggerVars(release);
        this.variableRepository.replace(release, (Seq<ConfigurationItem>)cis.toSeq());
        this.eventBus.publish((XLReleaseEvent)new ReleaseVariableReplacedEvent(variable, replacement));
    }

    private void checkRenameValidity(Seq<Variable> variables, Variable current, Variable updated) {
        if (((SeqLike)variables.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getKey(), Seq$.MODULE$.canBuildFrom())).contains((Object)updated.getKey())) {
            throw new IllegalArgumentException(new StringBuilder(29).append("Cannot rename variable ").append(updated.getId()).append(" from ").append(current.getKey()).append(new StringBuilder(28).append(" to ").append(updated.getKey()).append(" because ").append(updated.getKey()).append(" already exists").toString()).toString());
        }
    }

    private void checkSameType(Variable current, Variable updated) {
        if (!current.getType().equals((Object)updated.getType())) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Cannot change type of variable ").append(updated.getId()).append(" from ").append(current.getType()).append(" to ").append(updated.getType()).toString());
        }
    }

    private Variable updateVariableAndProvider(String parentId, Variable current, Variable updated, Release release) {
        Variable variable;
        PropertyDescriptor currentValueType = current.getType().getDescriptor().getPropertyDescriptor("value");
        PropertyDescriptor updatedValueType = updated.getType().getDescriptor().getPropertyDescriptor("value");
        if (!currentValueType.getKind().equals((Object)updatedValueType.getKind())) {
            throw new IllegalArgumentException(new StringBuilder(40).append("Cannot change type of variable from ").append(current.getType()).append(" to ").append(updated.getType()).toString());
        }
        if (updated.isPassword()) {
            ((PasswordStringVariable)updated).checkExternalPasswordVariable();
        }
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option<ConfigurationItem>)new Some((Object)current), (ConfigurationItem)updated);
        if (updated.getValueProvider() != null) {
            updated.getValueProvider().setVariable(updated);
        }
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(parentId, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)updated, (List)Nil$.MODULE$)).asJava(), this.ciIdService);
        if (Ids.isReleaseId((String)parentId)) {
            release.replaceVariable(current, updated);
            this.syncTriggerVars(release);
            this.variableRepository.update(current, updated, release);
            variable = BoxedUnit.UNIT;
        } else {
            variable = this.configurationRepository.update(updated);
        }
        return updated;
    }

    private scala.collection.immutable.Set<ConfigurationItem> updateUsagePoint(UsagePoint up, Variable variable, VariableOrValue replacement) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(up.replaceVariable(variable, replacement)).asScala()).toSet();
    }

    private void syncTriggerVars(Release release) {
        block0: {
            String templateId = release.getId();
            java.util.List templateVars = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getVariables()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.getShowOnReleaseStart())).map((Function1 & Serializable & scala.Serializable)v -> CiCloneHelper.cloneCi(v), Buffer$.MODULE$.canBuildFrom())).asJava();
            ReleaseStatus releaseStatus = release.getStatus();
            ReleaseStatus releaseStatus2 = ReleaseStatus.TEMPLATE;
            if (releaseStatus != null ? !releaseStatus.equals(releaseStatus2) : releaseStatus2 != null) break block0;
            this.eventBus.publishAndFailOnError((XLReleaseEvent)new TemplateVariablesChangedEvent(templateId, templateVars));
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateReleaseVariables$3(Variable v$1, Variable x$1) {
        String string = x$1.getName();
        String string2 = v$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$updateReleaseVariables$2(java.util.List originalVariables$1, Variable v) {
        if (v.isPassword()) {
            ((PasswordStringVariable)v).checkExternalPasswordVariable();
        }
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option<ConfigurationItem>)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(originalVariables$1).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)VariableService.$anonfun$updateReleaseVariables$3(v, x$1))), (ConfigurationItem)v);
    }

    private final void replaceVariableUsages$1(Variable oldVariable, Variable updatedVariable, Release release$2) {
        VariableOrValue replacement = new VariableOrValue();
        replacement.setVariable(updatedVariable.getKey());
        Release updatedRelease = this.releaseRepository.findById(release$2.getId());
        this.replaceVariable(updatedRelease, oldVariable, replacement);
    }

    public static final /* synthetic */ boolean $anonfun$replaceVariable$1(Variable variable$2, VariableReference varRef) {
        String string = VariableHelper$.MODULE$.withoutVariableSyntax(varRef.getKey());
        String string2 = VariableHelper$.MODULE$.withoutVariableSyntax(variable$2.getKey());
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public VariableService(ConfigurationRepository configurationRepository, ReleaseRepository releaseRepository, ReleaseVariableRepository variableRepository, ArchivingService archivingService, CiIdService ciIdService, TaskBackup taskBackup, XLReleaseEventBus eventBus) {
        this.configurationRepository = configurationRepository;
        this.releaseRepository = releaseRepository;
        this.variableRepository = variableRepository;
        this.archivingService = archivingService;
        this.ciIdService = ciIdService;
        this.taskBackup = taskBackup;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

