/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Application;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.ResteasyDeployment;

public abstract class ConfigurationBootstrap
implements ResteasyConfiguration {
    private ResteasyDeployment deployment = new ResteasyDeployment();

    public ResteasyDeployment createDeployment() {
        String injectorFactoryClass;
        String disableHtmlSanitizer;
        String addCharset;
        String jaxrs_2_0_requestMatching;
        String widerMatching;
        String useContainerFormParams;
        String append;
        String after;
        String before;
        String languageExtensions;
        String mimeExtentions;
        String contextObjects;
        String paramMapping;
        String unwrapped;
        String resources;
        String jndiComponentResources;
        String jndiResources;
        String scannedJndi;
        String scannedResources;
        String scannedProviders;
        String sScannedByDeployer;
        String sResources;
        String scanAll;
        String sProviders;
        String builtin;
        String resourceMethodInterceptors;
        String applicationConfig;
        String deploymentSensitive = this.getParameter("resteasy.use.deployment.sensitive.factory");
        if (deploymentSensitive != null) {
            this.deployment.setDeploymentSensitiveFactoryEnabled(Boolean.valueOf(deploymentSensitive.trim()));
        } else {
            this.deployment.setDeploymentSensitiveFactoryEnabled(true);
        }
        String async = this.getParameter("resteasy.async.job.service.enabled");
        if (async != null) {
            this.deployment.setAsyncJobServiceEnabled(Boolean.valueOf(async.trim()));
        }
        if (this.deployment.isAsyncJobServiceEnabled()) {
            String[] basePath;
            String threadPool;
            String maxWaitStr;
            String maxJobResults = this.getParameter("resteasy.async.job.service.max.job.results");
            if (maxJobResults != null) {
                int maxJobs = Integer.valueOf(maxJobResults);
                this.deployment.setAsyncJobServiceMaxJobResults(maxJobs);
            }
            if ((maxWaitStr = this.getParameter("resteasy.async.job.service.max.wait")) != null) {
                long maxWait = Long.valueOf(maxWaitStr);
                this.deployment.setAsyncJobServiceMaxWait(maxWait);
            }
            if ((threadPool = this.getParameter("resteasy.async.job.service.thread.pool.size")) != null) {
                int threadPoolSize = Integer.valueOf(threadPool);
                this.deployment.setAsyncJobServiceThreadPoolSize(threadPoolSize);
            }
            if ((basePath = this.getParameter("resteasy.async.job.service.base.path")) != null) {
                this.deployment.setAsyncJobServiceBasePath((String)basePath);
            }
        }
        if ((applicationConfig = this.getParameter(Application.class.getName())) == null) {
            applicationConfig = this.getParameter("javax.ws.rs.Application");
        } else {
            LogMessages.LOGGER.useOfApplicationClass(Application.class.getName());
        }
        String providers = this.getParameter("resteasy.providers");
        if (providers != null && !"".equals(providers.trim())) {
            String[] p;
            for (String pr : p = providers.split(",")) {
                this.deployment.getProviderClasses().add(pr.trim());
            }
        }
        if ((resourceMethodInterceptors = this.getParameter("resteasy.resource.method.interceptors")) != null) {
            throw new RuntimeException(Messages.MESSAGES.noLongerASupportedContextParam("resteasy.resource.method.interceptors"));
        }
        String resteasySecurity = this.getParameter("resteasy.role.based.security");
        if (resteasySecurity != null) {
            boolean useResteasySecurity = this.parseBooleanParam("resteasy.role.based.security", resteasySecurity);
            this.deployment.setSecurityEnabled(useResteasySecurity);
        }
        if ((builtin = this.getParameter("resteasy.use.builtin.providers")) != null) {
            boolean useBuiltin = this.parseBooleanParam("resteasy.use.builtin.providers", builtin);
            this.deployment.setRegisterBuiltin(useBuiltin);
        }
        if ((sProviders = this.getParameter("resteasy.scan.providers")) != null) {
            LogMessages.LOGGER.noLongerSupported("resteasy.scan.providers");
        }
        if ((scanAll = this.getParameter("resteasy.scan")) != null) {
            LogMessages.LOGGER.noLongerSupported("resteasy.scan");
        }
        if ((sResources = this.getParameter("resteasy.scan.resources")) != null) {
            LogMessages.LOGGER.noLongerSupported("resteasy.scan.resources");
        }
        if ((sScannedByDeployer = this.getParameter("resteasy.scanned.by.deployer")) != null) {
            // empty if block
        }
        if ((scannedProviders = this.getParameter("resteasy.scanned.providers")) != null) {
            String[] p;
            for (String pr : p = scannedProviders.split(",")) {
                this.deployment.getScannedProviderClasses().add(pr.trim());
            }
        }
        if ((scannedResources = this.getParameter("resteasy.scanned.resources")) != null) {
            String[] p;
            for (String pr : p = scannedResources.split(",")) {
                this.deployment.getScannedResourceClasses().add(pr.trim());
            }
        }
        if ((scannedJndi = this.getParameter("resteasy.scanned.jndi.resources")) != null) {
            this.processScannedJndiComponentResources(scannedJndi);
        }
        if ((jndiResources = this.getParameter("resteasy.jndi.resources")) != null && !"".equals(jndiResources.trim())) {
            this.processJndiResources(jndiResources);
        }
        if ((jndiComponentResources = this.getParameter("resteasy.jndi.component.resources")) != null) {
            this.processJndiComponentResources(jndiComponentResources);
        }
        if ((resources = this.getParameter("resteasy.resources")) != null && !"".equals(resources.trim())) {
            this.processResources(resources);
        }
        if ((unwrapped = this.getParameter("resteasy.unwrapped.exceptions")) != null) {
            this.processUnwrapped(unwrapped);
        }
        if ((paramMapping = this.getParameter("resteasy.media.type.param.mapping")) != null) {
            if ((paramMapping = paramMapping.trim()).length() > 0) {
                this.deployment.setMediaTypeParamMapping(paramMapping);
            } else {
                this.deployment.setMediaTypeParamMapping("Accept".toLowerCase());
            }
        }
        if ((contextObjects = this.getParameter("resteasy.context.objects")) != null) {
            Map<String, String> map = this.parseMap(contextObjects);
            this.deployment.setConstructedDefaultContextObjects(map);
        }
        if ((mimeExtentions = this.getParameter("resteasy.media.type.mappings")) != null) {
            Map<String, String> map = this.parseMap(mimeExtentions);
            this.deployment.setMediaTypeMappings(map);
        }
        if ((languageExtensions = this.getParameter("resteasy.language.mappings")) != null) {
            Map<String, String> map = this.parseMap(languageExtensions);
            this.deployment.setLanguageExtensions(map);
        }
        if ((before = this.getParameter("resteasy.interceptor.before.precedence")) != null) {
            Map<String, String> map = this.parseMap(before);
            this.deployment.setInterceptorBeforePrecedences(map);
        }
        if ((after = this.getParameter("resteasy.interceptor.after.precedence")) != null) {
            Map<String, String> map = this.parseMap(after);
            this.deployment.setInterceptorAfterPrecedences(map);
        }
        if ((append = this.getParameter("resteasy.append.interceptor.precedence")) != null) {
            String[] precedences;
            for (String precedence : precedences = append.split(",")) {
                this.deployment.getInterceptorPrecedences().add(precedence.trim());
            }
        }
        if ((useContainerFormParams = this.getParameter("resteasy.use.container.form.params")) != null) {
            boolean useContainer = this.parseBooleanParam("resteasy.use.container.form.params", useContainerFormParams);
            this.deployment.setUseContainerFormParams(useContainer);
        }
        if ((widerMatching = this.getParameter("resteasy.wider.request.matching")) != null) {
            boolean wider = this.parseBooleanParam("resteasy.wider.request.matching", widerMatching);
            this.deployment.setWiderRequestMatching(wider);
        }
        if ((jaxrs_2_0_requestMatching = this.getParameter("jaxrs.2.0.request.matching")) != null) {
            boolean requestMatching = this.parseBooleanParam("jaxrs.2.0.request.matching", jaxrs_2_0_requestMatching);
            this.deployment.setJaxrs_2_0_RequestMatching(requestMatching);
        }
        if ((addCharset = this.getParameter("resteasy.add.charset")) != null) {
            boolean add = this.parseBooleanParam("resteasy.add.charset", addCharset);
            this.deployment.setAddCharset(add);
        }
        if ((disableHtmlSanitizer = this.getParameter("resteasy.disable.html.sanitizer")) != null) {
            boolean b = this.parseBooleanParam("resteasy.disable.html.sanitizer", disableHtmlSanitizer);
            this.deployment.setProperty("resteasy.disable.html.sanitizer", b);
        }
        if ((injectorFactoryClass = this.getParameter("resteasy.injector.factory")) != null) {
            this.deployment.setInjectorFactoryClass(injectorFactoryClass);
        }
        if (applicationConfig != null) {
            this.deployment.setApplicationClass(applicationConfig);
        }
        this.deployment.getDefaultContextObjects().put(ResteasyConfiguration.class, this);
        return this.deployment;
    }

    private boolean parseBooleanParam(String key, String value) {
        if ((value = value.trim().toLowerCase()).equals("true") || value.equals("1")) {
            return true;
        }
        if (value.equals("false") || value.equals("0")) {
            return false;
        }
        throw new RuntimeException(Messages.MESSAGES.keyCouldNotBeParsed(key));
    }

    protected Map<String, String> parseMap(String map) {
        String[] entries;
        HashMap<String, String> parsed = new HashMap<String, String>();
        for (String entry : entries = map.trim().split(",")) {
            String[] split = entry.trim().split(":");
            parsed.put(split[0].trim(), split[1].trim());
        }
        return parsed;
    }

    protected void processJndiResources(String jndiResources) {
        String[] resources;
        for (String resource : resources = jndiResources.trim().split(",")) {
            this.deployment.getJndiResources().add(resource);
        }
    }

    protected void processJndiComponentResources(String jndiResources) {
        String[] resources;
        for (String resource : resources = jndiResources.trim().split(",")) {
            this.deployment.getJndiComponentResources().add(resource);
        }
    }

    protected void processScannedJndiComponentResources(String jndiResources) {
        String[] resources;
        for (String resource : resources = jndiResources.trim().split(",")) {
            this.deployment.getScannedJndiComponentResources().add(resource);
        }
    }

    protected void processResources(String list) {
        String[] resources;
        for (String resource : resources = list.trim().split(",")) {
            this.deployment.getResourceClasses().add(resource);
        }
    }

    protected void processUnwrapped(String list) {
        String[] resources;
        for (String resource : resources = list.trim().split(",")) {
            this.deployment.getUnwrappedExceptions().add(resource);
        }
    }
}

