/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jetty9;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import java.util.concurrent.BlockingQueue;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class InstrumentedQueuedThreadPool
extends QueuedThreadPool {
    private final MetricRegistry metricRegistry;
    private String prefix;

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry) {
        this(registry, 200);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads) {
        this(registry, maxThreads, 8);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads) {
        this(registry, maxThreads, minThreads, 60000);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads, @Name(value="idleTimeout") int idleTimeout) {
        this(registry, maxThreads, minThreads, idleTimeout, null);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads, @Name(value="idleTimeout") int idleTimeout, @Name(value="queue") BlockingQueue<Runnable> queue) {
        this(registry, maxThreads, minThreads, idleTimeout, queue, null);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads, @Name(value="idleTimeout") int idleTimeout, @Name(value="queue") BlockingQueue<Runnable> queue, @Name(value="prefix") String prefix) {
        super(maxThreads, minThreads, idleTimeout, queue);
        this.metricRegistry = registry;
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    protected void doStart() throws Exception {
        super.doStart();
        String prefix = this.prefix == null ? MetricRegistry.name(QueuedThreadPool.class, (String[])new String[]{this.getName()}) : MetricRegistry.name((String)this.prefix, (String[])new String[]{this.getName()});
        this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"utilization"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)(InstrumentedQueuedThreadPool.this.getThreads() - InstrumentedQueuedThreadPool.this.getIdleThreads()), (double)InstrumentedQueuedThreadPool.this.getThreads());
            }
        });
        this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"utilization-max"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)(InstrumentedQueuedThreadPool.this.getThreads() - InstrumentedQueuedThreadPool.this.getIdleThreads()), (double)InstrumentedQueuedThreadPool.this.getMaxThreads());
            }
        });
        this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"size"}), (Metric)((Gauge)() -> ((InstrumentedQueuedThreadPool)this).getThreads()));
        this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"jobs"}), (Metric)((Gauge)() -> this.getQueue().size()));
    }
}

