/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configuration;

import java.util.LinkedHashSet;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;

final class OAuth2ImportSelector
implements ImportSelector {
    OAuth2ImportSelector() {
    }

    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        boolean webfluxPresent;
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        boolean oauth2ClientPresent = ClassUtils.isPresent((String)"org.springframework.security.oauth2.client.registration.ClientRegistration", (ClassLoader)this.getClass().getClassLoader());
        if (oauth2ClientPresent) {
            imports.add("org.springframework.security.config.annotation.web.configuration.OAuth2ClientConfiguration");
        }
        if ((webfluxPresent = ClassUtils.isPresent((String)"org.springframework.web.reactive.function.client.ExchangeFilterFunction", (ClassLoader)this.getClass().getClassLoader())) && oauth2ClientPresent) {
            imports.add("org.springframework.security.config.annotation.web.configuration.SecurityReactorContextConfiguration");
        }
        boolean oauth2ResourceServerPresent = ClassUtils.isPresent((String)"org.springframework.security.oauth2.server.resource.BearerTokenError", (ClassLoader)this.getClass().getClassLoader());
        if (webfluxPresent && oauth2ResourceServerPresent) {
            imports.add("org.springframework.security.config.annotation.web.configuration.SecurityReactorContextConfiguration");
        }
        return imports.toArray(new String[0]);
    }
}

