/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.security.oauth2.client.http.AccessTokenRequiredException;
import org.springframework.security.oauth2.client.http.StringSplitUtils;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.UserDeniedAuthorizationException;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpMessageConverterExtractor;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class OAuth2ErrorHandler
implements ResponseErrorHandler {
    private final ResponseErrorHandler errorHandler;
    private final OAuth2ProtectedResourceDetails resource;
    private List<HttpMessageConverter<?>> messageConverters = new RestTemplate().getMessageConverters();

    public OAuth2ErrorHandler(OAuth2ProtectedResourceDetails resource) {
        this.resource = resource;
        this.errorHandler = new DefaultResponseErrorHandler();
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public OAuth2ErrorHandler(ResponseErrorHandler errorHandler, OAuth2ProtectedResourceDetails resource) {
        this.resource = resource;
        this.errorHandler = errorHandler;
    }

    public boolean hasError(ClientHttpResponse response) throws IOException {
        return HttpStatus.Series.CLIENT_ERROR.equals((Object)response.getStatusCode().series()) || this.errorHandler.hasError(response);
    }

    public void handleError(final ClientHttpResponse response) throws IOException {
        if (!HttpStatus.Series.CLIENT_ERROR.equals((Object)response.getStatusCode().series())) {
            this.errorHandler.handleError(response);
        } else {
            ClientHttpResponse bufferedResponse = new ClientHttpResponse(){
                private byte[] lazyBody;

                public HttpStatus getStatusCode() throws IOException {
                    return response.getStatusCode();
                }

                public synchronized InputStream getBody() throws IOException {
                    if (this.lazyBody == null) {
                        InputStream bodyStream = response.getBody();
                        this.lazyBody = bodyStream != null ? FileCopyUtils.copyToByteArray((InputStream)bodyStream) : new byte[0];
                    }
                    return new ByteArrayInputStream(this.lazyBody);
                }

                public HttpHeaders getHeaders() {
                    return response.getHeaders();
                }

                public String getStatusText() throws IOException {
                    return response.getStatusText();
                }

                public void close() {
                    response.close();
                }

                public int getRawStatusCode() throws IOException {
                    return this.getStatusCode().value();
                }
            };
            try {
                HttpMessageConverterExtractor extractor = new HttpMessageConverterExtractor(OAuth2Exception.class, this.messageConverters);
                try {
                    OAuth2Exception oauth2Exception = (OAuth2Exception)extractor.extractData(bufferedResponse);
                    if (oauth2Exception != null) {
                        if (oauth2Exception.getClass() == UserDeniedAuthorizationException.class && bufferedResponse.getStatusCode().equals((Object)HttpStatus.FORBIDDEN)) {
                            oauth2Exception = new OAuth2AccessDeniedException(oauth2Exception.getMessage());
                        }
                        throw oauth2Exception;
                    }
                }
                catch (RestClientException oauth2Exception) {
                }
                catch (HttpMessageConversionException oauth2Exception) {
                    // empty catch block
                }
                List authenticateHeaders = bufferedResponse.getHeaders().get((Object)"WWW-Authenticate");
                if (authenticateHeaders != null) {
                    for (String authenticateHeader : authenticateHeaders) {
                        this.maybeThrowExceptionFromHeader(authenticateHeader, "Bearer");
                        this.maybeThrowExceptionFromHeader(authenticateHeader, "OAuth2");
                    }
                }
                this.errorHandler.handleError(bufferedResponse);
            }
            catch (InvalidTokenException ex) {
                throw new AccessTokenRequiredException(this.resource);
            }
            catch (OAuth2Exception ex) {
                if (!ex.getClass().equals(OAuth2Exception.class)) {
                    throw ex;
                }
                this.errorHandler.handleError(bufferedResponse);
            }
        }
    }

    private void maybeThrowExceptionFromHeader(String authenticateHeader, String headerType) {
        headerType = headerType.toLowerCase();
        if (authenticateHeader.toLowerCase().startsWith(headerType)) {
            Map<String, String> headerEntries = StringSplitUtils.splitEachArrayElementAndCreateMap(StringSplitUtils.splitIgnoringQuotes(authenticateHeader.substring(headerType.length()), ','), "=", "\"");
            OAuth2Exception ex = OAuth2Exception.valueOf(headerEntries);
            if (ex instanceof InvalidTokenException) {
                throw new AccessTokenRequiredException(this.resource);
            }
            throw ex;
        }
    }
}

