/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.notification.MailPriority;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.variables.reference.PropertyUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.events.TaskStartOrRetryOperation;
import com.xebialabs.xlrelease.service.ExecuteTaskAction;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label="Notification", versioned=false)
public class NotificationTask
extends Task {
    @Property(description="List of email addresses where the message will be sent.")
    private Set<String> addresses;
    @Property(description="Subject of the message.")
    private String subject;
    @Property(description="Message body, in Markdown format.")
    private String body;
    @Property(required=false, description="List of email addresses that receive the message as CC.")
    private Set<String> cc;
    @Property(required=false, description="List of email addresses that receive the message as BCC.")
    private Set<String> bcc;
    @Property(required=false, description="The email address of the reply message recipient")
    private String replyTo;
    @Property(required=false, description="The email address of the message sender.")
    private String from;
    @Property(required=false, description="The SMTP server username of the message sender.")
    private String senderUsername;
    @Property(required=false, password=true, description="The SMTP server password of the message sender.")
    private String senderPassword;
    @Property(required=false, description="Priority of the message.")
    private MailPriority priority;

    @Override
    protected Set<String> freezeVariablesInCustomFields(Map<String, String> variables, Map<String, String> passwordVariables, Changes changes, boolean freezeEvenIfUnresolved) {
        HashSet unresolvedVariables = Sets.newHashSet();
        this.setAddresses(this.replaceAllInSet(this.getAddresses(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        this.setSubject(VariableHelper.replaceAll(this.getSubject(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        this.setBody(VariableHelper.replaceAll(this.getBody(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        this.setCc(this.replaceAllInSet(this.getCc(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        this.setBcc(this.replaceAllInSet(this.getBcc(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        this.setReplyTo(VariableHelper.replaceAll(this.getReplyTo(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        this.setFrom(VariableHelper.replaceAll(this.getFrom(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        this.setSenderUsername(VariableHelper.replaceAll(this.getSenderUsername(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        this.setSenderPassword(VariableHelper.replaceAll(this.getSenderPassword(), passwordVariables, unresolvedVariables, freezeEvenIfUnresolved));
        return unresolvedVariables;
    }

    private Set<String> replaceAllInSet(Set<String> setOfString, Map<String, String> variables, Set<String> unresolvedVariables, boolean freezeEvenIfUnresolved) {
        HashSet newSetOfString = Sets.newHashSet();
        for (String item : setOfString) {
            newSetOfString.add(VariableHelper.replaceAll(item, variables, unresolvedVariables, freezeEvenIfUnresolved));
        }
        return newSetOfString;
    }

    @Override
    protected Changes execute(String targetId, TaskStartOrRetryOperation operation) {
        Changes changes = super.execute(targetId, operation);
        if (this.getStatus() != TaskStatus.IN_PROGRESS) {
            return changes;
        }
        changes.addPostAction(new ExecuteTaskAction(this));
        return changes;
    }

    @PublicApiMember
    public Set<String> getAddresses() {
        return this.addresses;
    }

    @PublicApiMember
    public void setAddresses(Set<String> addresses) {
        this.addresses = addresses;
    }

    @PublicApiMember
    public String getSubject() {
        return this.subject;
    }

    @PublicApiMember
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @PublicApiMember
    public String getBody() {
        return this.body;
    }

    @PublicApiMember
    public void setBody(String body) {
        this.body = body;
    }

    @PublicApiMember
    public Set<String> getCc() {
        return this.cc;
    }

    @PublicApiMember
    public void setCc(Set<String> cc) {
        this.cc = cc;
    }

    @PublicApiMember
    public Set<String> getBcc() {
        return this.bcc;
    }

    @PublicApiMember
    public void setBcc(Set<String> bcc) {
        this.bcc = bcc;
    }

    @PublicApiMember
    public String getReplyTo() {
        return this.replyTo;
    }

    @PublicApiMember
    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    @PublicApiMember
    public String getFrom() {
        return this.from;
    }

    @PublicApiMember
    public void setFrom(String from) {
        this.from = from;
    }

    @PublicApiMember
    public String getSenderUsername() {
        return this.senderUsername;
    }

    @PublicApiMember
    public void setSenderUsername(String senderUsername) {
        this.senderUsername = senderUsername;
    }

    @PublicApiMember
    public String getSenderPassword() {
        return this.senderPassword;
    }

    @PublicApiMember
    public void setSenderPassword(String senderPassword) {
        this.senderPassword = senderPassword;
    }

    @PublicApiMember
    public MailPriority getPriority() {
        return this.priority;
    }

    @PublicApiMember
    public void setPriority(MailPriority priority) {
        this.priority = priority;
    }

    @Override
    public List<UsagePoint> getVariableUsages() {
        ArrayList<UsagePoint> usagePoints = new ArrayList<UsagePoint>(super.getVariableUsages());
        usagePoints.addAll(Arrays.asList(new PropertyUsagePoint((ConfigurationItem)this, "addresses"), new PropertyUsagePoint((ConfigurationItem)this, "subject"), new PropertyUsagePoint((ConfigurationItem)this, "body"), new PropertyUsagePoint((ConfigurationItem)this, "bcc"), new PropertyUsagePoint((ConfigurationItem)this, "cc"), new PropertyUsagePoint((ConfigurationItem)this, "replyTo"), new PropertyUsagePoint((ConfigurationItem)this, "priority")));
        return usagePoints;
    }
}

