/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.client.ClusterClientReceptionist$;
import akka.cluster.client.ClusterReceptionist$;
import akka.cluster.client.ClusterReceptionistSettings$;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSub$;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.cluster.pubsub.DistributedPubSubMediator$Subscribe$;
import akka.cluster.pubsub.DistributedPubSubMediator$Unsubscribe$;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055q!\u0002\f\u0018\u0011\u0003qb!\u0002\u0011\u0018\u0011\u0003\t\u0003\"B\u001c\u0002\t\u0003I\b\"\u0002>\u0002\t\u0003Z\bbBA\u0001\u0003\u0011\u0005\u00131\u0001\u0005\b\u0003\u000f\tA\u0011IA\u0005\r\u0011\u0001sCA\u0018\t\u0011M2!\u0011!Q\u0001\nQBQa\u000e\u0004\u0005\u0002aBqA\u000f\u0004C\u0002\u0013%1\b\u0003\u0004F\r\u0001\u0006I\u0001\u0010\u0005\b\r\u001a\u0011\r\u0011\"\u0003H\u0011\u00191f\u0001)A\u0005\u0011\")qK\u0002C\u00011\")AL\u0002C\u0005;\")\u0011M\u0002C\u0001E\")qM\u0002C\u0001Q\")!N\u0002C\u0001W\")qN\u0002C\u0001a\"91O\u0002b\u0001\n\u0013i\u0006B\u0002;\u0007A\u0003%a\fC\u0003v\r\u0011\u0005Q,A\rDYV\u001cH/\u001a:DY&,g\u000e\u001e*fG\u0016\u0004H/[8oSN$(B\u0001\r\u001a\u0003\u0019\u0019G.[3oi*\u0011!dG\u0001\bG2,8\u000f^3s\u0015\u0005a\u0012\u0001B1lW\u0006\u001c\u0001\u0001\u0005\u0002 \u00035\tqCA\rDYV\u001cH/\u001a:DY&,g\u000e\u001e*fG\u0016\u0004H/[8oSN$8\u0003B\u0001#QY\u0004\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0007cA\u0015-]5\t!F\u0003\u0002,7\u0005)\u0011m\u0019;pe&\u0011QF\u000b\u0002\f\u000bb$XM\\:j_:LE\r\u0005\u0002 \rM\u0019aA\t\u0019\u0011\u0005%\n\u0014B\u0001\u001a+\u0005%)\u0005\u0010^3og&|g.\u0001\u0004tsN$X-\u001c\t\u0003SUJ!A\u000e\u0016\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\u0002\rqJg.\u001b;?)\tq\u0013\bC\u00034\u0011\u0001\u0007A'\u0001\u0004d_:4\u0017nZ\u000b\u0002yA\u0011QhQ\u0007\u0002})\u0011!h\u0010\u0006\u0003\u0001\u0006\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0002\u0005\u0006\u00191m\\7\n\u0005\u0011s$AB\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\tI|G.Z\u000b\u0002\u0011B\u00191%S&\n\u0005)##AB(qi&|g\u000e\u0005\u0002M':\u0011Q*\u0015\t\u0003\u001d\u0012j\u0011a\u0014\u0006\u0003!v\ta\u0001\u0010:p_Rt\u0014B\u0001*%\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I#\u0013!\u0002:pY\u0016\u0004\u0013\u0001D5t)\u0016\u0014X.\u001b8bi\u0016$W#A-\u0011\u0005\rR\u0016BA.%\u0005\u001d\u0011un\u001c7fC:\fa\u0002];c'V\u0014W*\u001a3jCR|'/F\u0001_!\tIs,\u0003\u0002aU\tA\u0011i\u0019;peJ+g-A\bsK\u001eL7\u000f^3s'\u0016\u0014h/[2f)\t\u0019g\r\u0005\u0002$I&\u0011Q\r\n\u0002\u0005+:LG\u000fC\u0003,\u001f\u0001\u0007a,A\tv]J,w-[:uKJ\u001cVM\u001d<jG\u0016$\"aY5\t\u000b-\u0002\u0002\u0019\u00010\u0002%I,w-[:uKJ\u001cVOY:de&\u0014WM\u001d\u000b\u0004G2t\u0007\"B7\u0012\u0001\u0004Y\u0015!\u0002;pa&\u001c\u0007\"B\u0016\u0012\u0001\u0004q\u0016\u0001F;oe\u0016<\u0017n\u001d;feN+(m]2sS\n,'\u000fF\u0002dcJDQ!\u001c\nA\u0002-CQa\u000b\nA\u0002y\u000bAB]3dKB$\u0018n\u001c8jgR\fQB]3dKB$\u0018n\u001c8jgR\u0004\u0013AC;oI\u0016\u0014H._5oOB\u0011\u0011f^\u0005\u0003q*\u00121#\u0012=uK:\u001c\u0018n\u001c8JIB\u0013xN^5eKJ$\u0012AH\u0001\u0004O\u0016$HC\u0001\u0018}\u0011\u0015\u00194\u00011\u0001~!\tIc0\u0003\u0002\u0000U\tY\u0011i\u0019;peNK8\u000f^3n\u0003\u0019awn\\6vaR\u0011\u0011Q\u0001\b\u0003?\u0001\tqb\u0019:fCR,W\t\u001f;f]NLwN\u001c\u000b\u0004]\u0005-\u0001\"B\u001a\u0006\u0001\u0004!\u0004")
public final class ClusterClientReceptionist
implements Extension {
    private final ExtendedActorSystem system;
    private final Config config;
    private final Option<String> role;
    private final ActorRef receptionist;

    public static ClusterClientReceptionist createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterClientReceptionist$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterClientReceptionist$ lookup() {
        return ClusterClientReceptionist$.MODULE$.lookup();
    }

    public static ClusterClientReceptionist get(ActorSystem actorSystem) {
        return ClusterClientReceptionist$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterClientReceptionist$.MODULE$.apply(actorSystem);
    }

    private Config config() {
        return this.config;
    }

    private Option<String> role() {
        return this.role;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTerminated() {
        if (((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).isTerminated()) return true;
        Set set = ((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).selfRoles();
        if (this.role().forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains((Object)elem)))) return false;
        return true;
    }

    private ActorRef pubSubMediator() {
        return ((DistributedPubSub)DistributedPubSub$.MODULE$.apply((ActorSystem)this.system)).mediator();
    }

    public void registerService(ActorRef actor) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Put x$1 = new DistributedPubSubMediator.Put(actor);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void unregisterService(ActorRef actor) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Remove x$1 = new DistributedPubSubMediator.Remove(actor.path().toStringWithoutAddress());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void registerSubscriber(String topic, ActorRef actor) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Subscribe x$1 = DistributedPubSubMediator$Subscribe$.MODULE$.apply(topic, actor);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void unregisterSubscriber(String topic, ActorRef actor) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Unsubscribe x$1 = DistributedPubSubMediator$Unsubscribe$.MODULE$.apply(topic, actor);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    private ActorRef receptionist() {
        return this.receptionist;
    }

    public ActorRef underlying() {
        return this.receptionist();
    }

    public ClusterClientReceptionist(ExtendedActorSystem system) {
        ActorRef actorRef;
        this.system = system;
        this.config = system.settings().config().getConfig("akka.cluster.client.receptionist");
        String string = this.config().getString("role");
        Object object = "".equals(string) ? None$.MODULE$ : new Some((Object)string);
        this.role = object;
        if (this.isTerminated()) {
            actorRef = system.deadLetters();
        } else {
            String name = this.config().getString("name");
            String string2 = this.config().getString("use-dispatcher");
            String string3 = "".equals(string2) ? "akka.actor.default-dispatcher" : string2;
            String dispatcher = string3;
            ActorRef mediator = this.pubSubMediator();
            actorRef = system.systemActorOf(ClusterReceptionist$.MODULE$.props(mediator, ClusterReceptionistSettings$.MODULE$.apply(this.config())).withDispatcher(dispatcher), name);
        }
        this.receptionist = actorRef;
    }
}

