/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.IteratingRLW;

public class IntIteratorOverIteratingRLW
implements IntIterator {
    final IteratingRLW parent;
    private int position;
    private int runningLength;
    private long word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;
    private boolean hasNext;

    public IntIteratorOverIteratingRLW(IteratingRLW p) {
        this.parent = p;
        this.position = 0;
        this.setupForCurrentRunningLengthWord();
        this.hasNext = this.moveToNext();
    }

    private boolean moveToNext() {
        while (!this.runningHasNext() && !this.literalHasNext()) {
            if (this.parent.next()) {
                this.setupForCurrentRunningLengthWord();
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public final int next() {
        int answer;
        if (this.runningHasNext()) {
            answer = this.position++;
        } else {
            long t = this.word & -this.word;
            answer = this.literalPosition + Long.bitCount(t - 1L);
            this.word ^= t;
        }
        this.hasNext = this.moveToNext();
        return answer;
    }

    private void setupForCurrentRunningLengthWord() {
        this.runningLength = 64 * (int)this.parent.getRunningLength() + this.position;
        if (!this.parent.getRunningBit()) {
            this.position = this.runningLength;
        }
        this.wordPosition = 0;
        this.wordLength = this.parent.getNumberOfLiteralWords();
    }

    private boolean runningHasNext() {
        return this.position < this.runningLength;
    }

    private boolean literalHasNext() {
        while (this.word == 0L && this.wordPosition < this.wordLength) {
            this.word = this.parent.getLiteralWordAt(this.wordPosition++);
            this.literalPosition = this.position;
            this.position += 64;
        }
        return this.word != 0L;
    }
}

