/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ResolvableScriptTask;
import com.xebialabs.xlrelease.domain.ScriptEngine;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.reference.PropertyUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.events.TaskStartOrRetryOperation;
import com.xebialabs.xlrelease.service.ExecuteTaskAction;
import com.xebialabs.xlrelease.service.PostAction;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.ParseException;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.springframework.util.StringUtils;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label="Script: External Script", versioned=false)
public class ExternalScriptTask
extends ResolvableScriptTask {
    private static final Map<String, String> EXTENSION_ENGINE_MAP;
    @Property(description="Script location.")
    private String url;
    @Property(description="Username for basic authentication.", required=false)
    private String username;
    @Property(description="Password for basic authentication.", required=false, password=true)
    private String password;
    @Property(description="Language of the script. Allowed values are 'AUTODETECT', 'JYTHON' and 'GROOVY'.", required=false, defaultValue="AUTODETECT")
    private ScriptEngine scriptEngine = ScriptEngine.AUTODETECT;

    protected Changes execute(String targetId, TaskStartOrRetryOperation operation) {
        return this.executeScript(targetId, operation, (PostAction)new ExecuteTaskAction((Task)this));
    }

    public String getEngine() {
        String engine;
        if (!StringUtils.isEmpty((Object)((Object)this.scriptEngine)) && this.scriptEngine != ScriptEngine.AUTODETECT) {
            return EXTENSION_ENGINE_MAP.values().stream().filter(e -> e.equals(this.scriptEngine.name().toLowerCase())).findFirst().orElse("unsupported_engine");
        }
        try {
            String extension = FilenameUtils.getExtension((String)URI.create(this.url).getPath());
            engine = EXTENSION_ENGINE_MAP.getOrDefault(extension, "unsupported_engine");
        }
        catch (IllegalArgumentException | NullPointerException e2) {
            engine = "unsupported_engine";
        }
        return engine;
    }

    public String getScript() {
        String script = this.resolveScript();
        if (!this.isScriptInterpolationOff()) {
            script = this.replaceVariables(script);
        }
        return script;
    }

    private String replaceVariables(String script) {
        Release release = this.getRelease();
        Map variables = release.getAllStringVariableValues();
        return (String)VariableHelper.replaceAll((Object)script, (Map)variables, new HashSet(), (boolean)false);
    }

    private String resolveScript() {
        String script;
        try (CloseableHttpClient httpClient = HttpClients.custom().build();){
            HttpGet httpGet = new HttpGet(this.url);
            HttpClientContext httpClientContext = HttpClientContext.create();
            if (!StringUtils.isEmpty((Object)this.username) && !StringUtils.isEmpty((Object)this.password)) {
                this.addAuthentication(this.url, this.username, this.password, httpClientContext);
            }
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet, (HttpContext)httpClientContext);){
                if (httpResponse.getStatusLine().getStatusCode() == 403) {
                    throw new IllegalStateException("Got status code 403 while fetching the script from the url");
                }
                script = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            }
            catch (IOException | ParseException ex) {
                throw new IllegalStateException("Can't extract the script from the response");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't fetch the script from the url");
        }
        return script;
    }

    private void addAuthentication(String url, String username, String password, HttpClientContext httpClientContext) {
        HttpHost targetHost;
        try {
            URL targetUrl = new URL(url);
            URIBuilder builder = new URIBuilder(url);
            URI uri = builder.build();
            int port = uri.getPort();
            if (port == -1) {
                port = uri.getScheme().equalsIgnoreCase("https") ? 443 : 80;
            }
            targetHost = new HttpHost(targetUrl.getHost(), port, targetUrl.getProtocol());
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new IllegalArgumentException("Provided URL is not parsable", ex);
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicScheme = new BasicScheme();
        authCache.put(targetHost, (AuthScheme)basicScheme);
        httpClientContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        httpClientContext.setAuthCache((AuthCache)authCache);
    }

    public List<UsagePoint> getVariableUsages() {
        ArrayList<UsagePoint> usagePoints = new ArrayList<UsagePoint>(super.getVariableUsages());
        usagePoints.add((UsagePoint)new PropertyUsagePoint((ConfigurationItem)this, "url"));
        usagePoints.add((UsagePoint)new PropertyUsagePoint((ConfigurationItem)this, "username"));
        usagePoints.add((UsagePoint)new PropertyUsagePoint((ConfigurationItem)this, "password"));
        return usagePoints;
    }

    protected Set<String> freezeVariablesInCustomFields(Map<String, String> variables, Map<String, String> passwordVariables, Changes changes, boolean freezeEvenIfUnresolved) {
        HashSet<String> unresolvedVariables = new HashSet<String>();
        this.setUrl((String)VariableHelper.replaceAll((Object)this.getUrl(), variables, unresolvedVariables, (boolean)freezeEvenIfUnresolved));
        this.setUsername((String)VariableHelper.replaceAll((Object)this.getUsername(), variables, unresolvedVariables, (boolean)freezeEvenIfUnresolved));
        this.setPassword((String)VariableHelper.replaceAll((Object)this.getPassword(), passwordVariables, unresolvedVariables, (boolean)freezeEvenIfUnresolved));
        return unresolvedVariables;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    static {
        HashMap<String, String> extensionToEngineMap = new HashMap<String, String>();
        extensionToEngineMap.put("py", "jython");
        extensionToEngineMap.put("groovy", "groovy");
        EXTENSION_ENGINE_MAP = Collections.unmodifiableMap(extensionToEngineMap);
    }
}

