/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns;

import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.io.dns.DnsSettings$;
import akka.io.dns.internal.ResolvConf;
import akka.io.dns.internal.ResolvConfParser$;
import akka.util.Helpers$;
import akka.util.JavaDurationConverters$;
import akka.util.JavaDurationConverters$JavaDurationOps$;
import akka.util.ccompat.package$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueType;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\u0005Mc!B\f\u0019\u0005aq\u0002\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u00115\u0002!\u0011!Q\u0001\n9BQ\u0001\u000f\u0001\u0005\u0002eBqA\u0010\u0001C\u0002\u0013\u0005q\b\u0003\u0004U\u0001\u0001\u0006I\u0001\u0011\u0005\b+\u0002\u0011\r\u0011\"\u0001W\u0011\u0019y\u0006\u0001)A\u0005/\"A\u0001\r\u0001EC\u0002\u0013%\u0011\rC\u0004l\u0001\t\u0007I\u0011\u00017\t\rY\u0004\u0001\u0015!\u0003n\u0011\u001d9\bA1A\u0005\u0002aDa\u0001 \u0001!\u0002\u0013I\b\"B?\u0001\t\u0003qxaBA\n1!\u0005\u0011Q\u0003\u0004\u0007/aA\t!a\u0006\t\razA\u0011AA\r\u0011%\tYb\u0004b\u0001\n\u001b\ti\u0002\u0003\u0005\u0002$=\u0001\u000bQBA\u0010\u0011%\t)c\u0004b\u0001\n\u0013\t9\u0003\u0003\u0005\u0002:=\u0001\u000b\u0011BA\u0015\u0011!\tYd\u0004C\u00019\u0005u\u0002\u0002CA#\u001f\u0011\u0005A$a\u0012\u0003\u0017\u0011s7oU3ui&twm\u001d\u0006\u00033i\t1\u0001\u001a8t\u0015\tYB$\u0001\u0002j_*\tQ$\u0001\u0003bW.\f7C\u0001\u0001 !\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fM\u000611/_:uK6\u001c\u0001\u0001\u0005\u0002)W5\t\u0011F\u0003\u0002+9\u0005)\u0011m\u0019;pe&\u0011A&\u000b\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\\\u0001\u0002GB\u0011qFN\u0007\u0002a)\u0011\u0011GM\u0001\u0007G>tg-[4\u000b\u0005M\"\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003U\n1aY8n\u0013\t9\u0004G\u0001\u0004D_:4\u0017nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007ibT\b\u0005\u0002<\u00015\t\u0001\u0004C\u0003&\u0007\u0001\u0007q\u0005C\u0003.\u0007\u0001\u0007a&A\u0006OC6,7+\u001a:wKJ\u001cX#\u0001!\u0011\u0007\u0005KEJ\u0004\u0002C\u000f:\u00111IR\u0007\u0002\t*\u0011QIJ\u0001\u0007yI|w\u000e\u001e \n\u0003\tJ!\u0001S\u0011\u0002\u000fA\f7m[1hK&\u0011!j\u0013\u0002\u0005\u0019&\u001cHO\u0003\u0002ICA\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\u0004]\u0016$(\"A)\u0002\t)\fg/Y\u0005\u0003':\u0013\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u00031q\u0015-\\3TKJ4XM]:!\u00039\u0011Vm]8mm\u0016$\u0016.\\3pkR,\u0012a\u0016\t\u00031vk\u0011!\u0017\u0006\u00035n\u000b\u0001\u0002Z;sCRLwN\u001c\u0006\u00039\u0006\n!bY8oGV\u0014(/\u001a8u\u0013\tq\u0016L\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002\u001fI+7o\u001c7wKRKW.Z8vi\u0002\n!B]3t_248i\u001c8g+\u0005\u0011\u0007c\u0001\u0011dK&\u0011A-\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0019LW\"A4\u000b\u0005!D\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005)<'A\u0003*fg>dgoQ8oM\u0006i1+Z1sG\"$u.\\1j]N,\u0012!\u001c\t\u0004\u0003&s\u0007CA8t\u001d\t\u0001\u0018\u000f\u0005\u0002DC%\u0011!/I\u0001\u0007!J,G-\u001a4\n\u0005Q,(AB*ue&twM\u0003\u0002sC\u0005q1+Z1sG\"$u.\\1j]N\u0004\u0013!\u0002(E_R\u001cX#A=\u0011\u0005\u0001R\u0018BA>\"\u0005\rIe\u000e^\u0001\u0007\u001d\u0012{Go\u001d\u0011\u0002O\u0019\f\u0017\u000e\\+oC\ndW\rV8EKR,'/\\5oK\u0012+g-Y;mi:\u000bW.Z:feZ,'o]\u000b\u0002\u007fB\u0019\u0001%!\u0001\n\u0007\u0005\r\u0011EA\u0004O_RD\u0017N\\4)\u0007\u0001\t9\u0001\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\ti\u0001H\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\t\u0003\u0017\u00111\"\u00138uKJt\u0017\r\\!qS\u0006YAI\\:TKR$\u0018N\\4t!\tYtb\u0005\u0002\u0010?Q\u0011\u0011QC\u0001\u0010\t:\u001ch)\u00197mE\u0006\u001c7\u000eU8siV\u0011\u0011qD\b\u0003\u0003Ci\u0012!N\u0001\u0011\t:\u001ch)\u00197mE\u0006\u001c7\u000eU8si\u0002\n\u0011#\u001b8fiN{7m[3u\u0003\u0012$'/Z:t+\t\tI\u0003\u0005\u0003\u0002,\u0005URBAA\u0017\u0015\u0011\ty#!\r\u0002\u00115\fGo\u00195j]\u001eT1!a\r\"\u0003\u0011)H/\u001b7\n\t\u0005]\u0012Q\u0006\u0002\u0006%\u0016<W\r_\u0001\u0013S:,GoU8dW\u0016$\u0018\t\u001a3sKN\u001c\b%\u0001\fqCJ\u001cXMT1nKN,'O^3s\u0003\u0012$'/Z:t)\ra\u0015q\b\u0005\u0007\u0003\u0003*\u0002\u0019\u00018\u0002\u0007M$(\u000fK\u0002\u0016\u0003\u000f\tQcZ3u\t\u00164\u0017-\u001e7u\u001d\u0006lWmU3sm\u0016\u00148\u000f\u0006\u0003\u0002J\u0005E\u0003#BA&\u0003\u001b\u0002UBAA\u0019\u0013\u0011\ty%!\r\u0003\u0007Q\u0013\u0018\u0010C\u0003&-\u0001\u0007q\u0005")
public final class DnsSettings {
    private Option<ResolvConf> resolvConf;
    private final ExtendedActorSystem system;
    private final List<InetSocketAddress> NameServers;
    private final FiniteDuration ResolveTimeout;
    private final List<String> SearchDomains;
    private final int NDots;
    private volatile boolean bitmap$0;

    public List<InetSocketAddress> NameServers() {
        return this.NameServers;
    }

    public FiniteDuration ResolveTimeout() {
        return this.ResolveTimeout;
    }

    private Option<ResolvConf> resolvConf$lzycompute() {
        DnsSettings dnsSettings = this;
        synchronized (dnsSettings) {
            if (!this.bitmap$0) {
                None$ none$;
                File etcResolvConf = new File("/etc/resolv.conf");
                if (Helpers$.MODULE$.isWindows()) {
                    none$ = None$.MODULE$;
                } else if (etcResolvConf.exists()) {
                    Some some;
                    Try<ResolvConf> parsed = ResolvConfParser$.MODULE$.parseFile(etcResolvConf);
                    Try<ResolvConf> try_ = parsed;
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        ResolvConf value = (ResolvConf)success.value();
                        some = new Some((Object)value);
                    } else if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable exception = failure.exception();
                        if (this.system.log().isWarningEnabled()) {
                            this.system.log().error(exception, "Error parsing /etc/resolv.conf, ignoring.");
                        }
                        some = None$.MODULE$;
                    } else {
                        throw new MatchError(try_);
                    }
                    none$ = some;
                } else {
                    none$ = None$.MODULE$;
                }
                this.resolvConf = none$;
                this.bitmap$0 = true;
            }
        }
        return this.resolvConf;
    }

    private Option<ResolvConf> resolvConf() {
        return !this.bitmap$0 ? this.resolvConf$lzycompute() : this.resolvConf;
    }

    public List<String> SearchDomains() {
        return this.SearchDomains;
    }

    public int NDots() {
        return this.NDots;
    }

    public Nothing$ failUnableToDetermineDefaultNameservers() {
        throw new IllegalStateException("Unable to obtain default nameservers from JNDI or via reflection. Please set `akka.io.dns.async-dns.nameservers` explicitly in order to be able to resolve domain names. ");
    }

    public DnsSettings(ExtendedActorSystem system, Config c) {
        int n;
        List list;
        List list2;
        this.system = system;
        ConfigValueType configValueType = c.getValue("nameservers").valueType();
        if (ConfigValueType.STRING.equals(configValueType)) {
            List list3;
            String string = c.getString("nameservers");
            if ("default".equals(string)) {
                List osAddresses = (List)DnsSettings$.MODULE$.getDefaultNameServers(system).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.failUnableToDetermineDefaultNameservers());
                if (osAddresses.isEmpty()) {
                    throw this.failUnableToDetermineDefaultNameservers();
                }
                list3 = osAddresses;
            } else {
                InetSocketAddress inetSocketAddress = DnsSettings$.MODULE$.parseNameserverAddress(string);
                list3 = Nil$.MODULE$.$colon$colon((Object)inetSocketAddress);
            }
            list2 = list3;
        } else if (ConfigValueType.LIST.equals(configValueType)) {
            IndexedSeq userAddresses = (IndexedSeq)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(c.getStringList("nameservers")).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)str -> DnsSettings$.MODULE$.parseNameserverAddress((String)str)).to(package$.MODULE$.genericCompanionToCBF(IndexedSeq$.MODULE$));
            Predef$.MODULE$.require(userAddresses.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "nameservers can not be empty");
            list2 = userAddresses.toList();
        } else {
            throw new IllegalArgumentException("Invalid type for nameservers. Must be a string or string list");
        }
        this.NameServers = list2;
        this.ResolveTimeout = JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(c.getDuration("resolve-timeout")));
        ConfigValueType configValueType2 = c.getValue("search-domains").valueType();
        if (ConfigValueType.STRING.equals(configValueType2)) {
            String string = c.getString("search-domains");
            Object object = "default".equals(string) ? (List)this.resolvConf().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.search()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$) : new .colon.colon((Object)string, (List)Nil$.MODULE$);
            list = object;
        } else if (ConfigValueType.LIST.equals(configValueType2)) {
            list = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(c.getStringList("search-domains")).asScala()).toList();
        } else {
            throw new IllegalArgumentException("Invalid type for search-domains. Must be a string or string list.");
        }
        this.SearchDomains = list;
        ConfigValueType configValueType3 = c.getValue("ndots").valueType();
        if (ConfigValueType.STRING.equals(configValueType3)) {
            String string = c.getString("ndots");
            if (!"default".equals(string)) {
                throw new IllegalArgumentException("Invalid value for ndots. Must be the string 'default' or an integer.");
            }
            int n2 = BoxesRunTime.unboxToInt((Object)this.resolvConf().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.ndots())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
            n = n2;
        } else if (ConfigValueType.NUMBER.equals(configValueType3)) {
            int ndots = c.getInt("ndots");
            if (ndots < 0) {
                throw new IllegalArgumentException("Invalid value for ndots, ndots must not be negative.");
            }
            n = ndots;
        } else {
            throw new IllegalArgumentException("Invalid value for ndots. Must be the string 'default' or an integer.");
        }
        this.NDots = n;
    }
}

