/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\tMd\u0001\u0002\u0011\"\u00011B\u0001\"\u0013\u0001\u0003\u0006\u0004%\tA\u0013\u0005\t#\u0002\u0011\t\u0011)A\u0005\u0017\"A!\u000b\u0001BC\u0002\u0013\u00051\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003U\u0011!A\u0006A!b\u0001\n\u0003I\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tI\u0002\u0011)\u0019!C\u0001K\"A\u0011\u000e\u0001B\u0001B\u0003%a\r\u0003\u0005k\u0001\t\u0015\r\u0011\"\u0001l\u0011!\u0011\bA!A!\u0002\u0013a\u0007\u0002C:\u0001\u0005\u000b\u0007I\u0011\u0001;\t\u0011a\u0004!\u0011!Q\u0001\nUD\u0001\"\u001f\u0001\u0003\u0006\u0004%\u0019A\u001f\u0005\n\u0003K\u0001!\u0011!Q\u0001\nmDq!a\n\u0001\t\u0003\tI\u0003C\u0004\u0002>\u0001!\t%a\u0010\t\u000f\u0005u\u0002\u0001\"\u0011\u0002\n\"9\u0011Q\u0015\u0001\u0005B\u0005\u001d\u0006bBAk\u0001\u0011\u0005\u0013q\u001b\u0005\b\u0003K\u0004A\u0011IAt\u0011\u001d\ty\u000f\u0001C!\u0003cDq!!@\u0001\t\u0003\ny\u0010C\u0004\u0003\u0010\u0001!\tE!\u0005\t\u000f\t]\u0001\u0001\"\u0011\u0003\u001a!9!q\u0004\u0001\u0005\n\t\u0005\u0002b\u0002B\u0014\u0001\u0011\u0005#\u0011\u0006\u0005\b\u0005_\u0001A\u0011\tB\u0019\u0011\u001d\u0011Y\u0005\u0001C!\u0005\u001bBqA!\u0019\u0001\t\u0003\u0012\u0019GA\tTc2$\u0016m]6SKB|7/\u001b;pefT!AI\u0012\u0002\u0007M\fHN\u0003\u0002%K\u0005Q!/\u001a9pg&$xN]=\u000b\u0005\u0019:\u0013!\u0003=me\u0016dW-Y:f\u0015\tA\u0013&A\u0005yK\nL\u0017\r\\1cg*\t!&A\u0002d_6\u001c\u0001aE\u0004\u0001[M:4HP!\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g!\t!T'D\u0001$\u0013\t14E\u0001\bUCN\\'+\u001a9pg&$xN]=\u0011\u0005aJT\"A\u0011\n\u0005i\n#!\u0007\"bg\u0016\u0014V\r\\3bg\u0016LE/Z7SKB|7/\u001b;pef\u0004\"\u0001\u000f\u001f\n\u0005u\n#A\u0006#fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8TkB\u0004xN\u001d;\u0011\u0005az\u0014B\u0001!\"\u0005y\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+g-\u001a:f]\u000e,7oU;qa>\u0014H\u000f\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u0006)1\u000f\u001c45U*\ta)\u0001\u0005he&T(\u0010\\3e\u0013\tA5IA\u0004M_\u001e<\u0017N\\4\u0002%I,G.Z1tKB+'o]5ti\u0016t7-Z\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\u0011a*I\u0001\fa\u0016\u00148/[:uK:\u001cW-\u0003\u0002Q\u001b\n\u0011\"+\u001a7fCN,\u0007+\u001a:tSN$XM\\2f\u0003M\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3!\u0003U!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016,\u0012\u0001\u0016\t\u0003\u0019VK!AV'\u0003+\u0011+\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dK\u00061B-\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\buCN\\\u0007+\u001a:tSN$XM\\2f+\u0005Q\u0006C\u0001'\\\u0013\taVJA\bUCN\\\u0007+\u001a:tSN$XM\\2f\u0003A!\u0018m]6QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\td_6lWM\u001c;SKB|7/\u001b;pef,\u0012\u0001\u0019\t\u0003i\u0005L!AY\u0012\u0003#\r{W.\\3oiJ+\u0007o\\:ji>\u0014\u00180\u0001\nd_6lWM\u001c;SKB|7/\u001b;pef\u0004\u0013!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\ta\r\u0005\u00029O&\u0011\u0001.\t\u0002\u0015'Fd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0002%I,\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000fI\u0001\u0019G>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,W#\u00017\u0011\u00055\u0004X\"\u00018\u000b\u0005=l\u0015!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0002r]\n\t3i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cW\rU3sg&\u001cH/\u001a8dK\u0006I2m\u001c8gS\u001e,(/\u0019;j_:\u0004VM]:jgR,gnY3!\u0003e1\u0017mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:\u0016\u0003U\u0004\"\u0001\u000e<\n\u0005]\u001c#!\u0007$bG\u0016$(+\u001a9pg&$xN]=ESN\u0004\u0018\r^2iKJ\f!DZ1dKR\u0014V\r]8tSR|'/\u001f#jgB\fGo\u00195fe\u0002\nq\u0001Z5bY\u0016\u001cG/F\u0001|!\ra\u0018q\u0004\b\u0004{\u0006eab\u0001@\u0002\u00169\u0019q0!\u0005\u000f\t\u0005\u0005\u0011q\u0002\b\u0005\u0003\u0007\tiA\u0004\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tIaK\u0001\u0007yI|w\u000e\u001e \n\u0003)J!\u0001K\u0015\n\u0005\u0019:\u0013bAA\nK\u0005\u0011AMY\u0005\u0004E\u0005]!bAA\nK%!\u00111DA\u000f\u0003)\u0019\u0016\u000f\u001c\"vS2$WM\u001d\u0006\u0004E\u0005]\u0011\u0002BA\u0011\u0003G\u0011q\u0001R5bY\u0016\u001cGO\u0003\u0003\u0002\u001c\u0005u\u0011\u0001\u00033jC2,7\r\u001e\u0011\u0002\rqJg.\u001b;?)I\tY#!\f\u00020\u0005E\u00121GA\u001b\u0003o\tI$a\u000f\u0011\u0005a\u0002\u0001\"B%\u0012\u0001\u0004Y\u0005\"\u0002*\u0012\u0001\u0004!\u0006\"\u0002-\u0012\u0001\u0004Q\u0006\"\u00020\u0012\u0001\u0004\u0001\u0007\"\u00023\u0012\u0001\u00041\u0007\"\u00026\u0012\u0001\u0004a\u0007\"B:\u0012\u0001\u0004)\b\"B=\u0012\u0001\bY\u0018\u0001\u00034j]\u0012\u0014\u00150\u00133\u0016\t\u0005\u0005\u0013q\t\u000b\u0005\u0003\u0007\ny\u0006\u0005\u0003\u0002F\u0005\u001dC\u0002\u0001\u0003\b\u0003\u0013\u0012\"\u0019AA&\u0005\u0005!\u0016\u0003BA'\u0003'\u00022ALA(\u0013\r\t\tf\f\u0002\b\u001d>$\b.\u001b8h!\u0011\t)&a\u0017\u000e\u0005\u0005]#bAA-K\u00051Am\\7bS:LA!!\u0018\u0002X\t!A+Y:l\u0011\u001d\t\tG\u0005a\u0001\u0003G\na\u0001^1tW&#\u0007\u0003BA3\u0003[rA!a\u001a\u0002jA\u0019\u0011QA\u0018\n\u0007\u0005-t&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003_\n\tH\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Wz\u0003f\u0001\n\u0002vA!\u0011qOAC\u001b\t\tIH\u0003\u0003\u0002|\u0005u\u0014AC1o]>$\u0018\r^5p]*!\u0011qPAA\u0003\u001diW\r\u001e:jGNT1!a!*\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BAD\u0003s\u0012Q\u0001V5nK\u0012,B!a#\u0002\u0010R1\u0011QRAI\u0003'\u0003B!!\u0012\u0002\u0010\u00129\u0011\u0011J\nC\u0002\u0005-\u0003bBA1'\u0001\u0007\u00111\r\u0005\b\u0003+\u001b\u0002\u0019AAL\u00039\u0011Xm]8mm\u0016|\u0005\u000f^5p]N\u0004B!!'\u0002 6\u0011\u00111\u0014\u0006\u0004\u0003;\u001b\u0013!B9vKJL\u0018\u0002BAQ\u00037\u0013aBU3t_24Xm\u00149uS>t7\u000fK\u0002\u0014\u0003k\n!CZ5oIR\u000b7o[:CCNL7\rR1uCR!\u0011\u0011VA`!\u0019\tY+!.\u0002:6\u0011\u0011Q\u0016\u0006\u0005\u0003_\u000b\t,\u0001\u0003vi&d'BAAZ\u0003\u0011Q\u0017M^1\n\t\u0005]\u0016Q\u0016\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u001a\u0006m\u0016\u0002BA_\u00037\u0013Q\u0002V1tW\n\u000b7/[2ECR\f\u0007bBAa)\u0001\u0007\u00111Y\u0001\bi\u0006\u001c8.\u00133t!\u0019\tY+!.\u0002d!\u001aA#a2\u0011\t\u0005%\u0017qZ\u0007\u0003\u0003\u0017TA!!4\u0002\u001e\u0005YAO]1og\u0006\u001cG/[8o\u0013\u0011\t\t.a3\u0003\u0015%\u001b(+Z1e\u001f:d\u0017\u0010K\u0002\u0015\u0003k\na!\u001a=jgR\u001cH\u0003BAm\u0003?\u00042ALAn\u0013\r\tin\f\u0002\b\u0005>|G.Z1o\u0011\u001d\t\t'\u0006a\u0001\u0003GB3!FAdQ\r)\u0012QO\u0001\u0007kB$\u0017\r^3\u0015\t\u0005M\u0013\u0011\u001e\u0005\b\u0003W4\u0002\u0019AA*\u0003\u0011!\u0018m]6)\u0007Y\t)(\u0001\u000bva\u0012\fG/\u001a+bg.\u0004&o\u001c9feRLWm\u001d\u000b\u0005\u0003g\fI\u0010E\u0002/\u0003kL1!a>0\u0005\u0011)f.\u001b;\t\u000f\u0005-x\u00031\u0001\u0002T!\u001aq#!\u001e\u0002=U\u0004H-\u0019;f)\u0006\u001c8.\u00118e%\u0016dW-Y:f\r2\fwm\u0015;biV\u001cHCBA*\u0005\u0003\u0011\u0019\u0001C\u0004\u0002lb\u0001\r!a\u0015\t\u000f\t\u0015\u0001\u00041\u0001\u0003\b\u00059!/\u001a7fCN,\u0007\u0003BA+\u0005\u0013IAAa\u0003\u0002X\t9!+\u001a7fCN,\u0007f\u0001\r\u0002v\u0005QQ\u000f\u001d3bi\u0016$\u0016\u0010]3\u0015\t\u0005M#1\u0003\u0005\b\u0003WL\u0002\u0019AA*Q\rI\u0012QO\u0001\u0007I\u0016dW\r^3\u0015\t\u0005M(1\u0004\u0005\b\u0003WT\u0002\u0019AA*Q\rQ\u0012QO\u0001\u000bGJ,\u0017\r^3UCN\\G\u0003BA*\u0005GAqA!\n\u001c\u0001\u0004\t\u0019&A\u0004oK^$\u0016m]6\u0002\r\r\u0014X-\u0019;f)\u0011\t\u0019Fa\u000b\t\u000f\t\u0015B\u00041\u0001\u0002T!\u001aA$!\u001e\u0002\u00115|g/\u001a+bg.$\"\"a\u0015\u00034\t]\"1\bB#\u0011\u001d\u0011)$\ba\u0001\u0003'\n!\u0002^1tWR{Wj\u001c<f\u0011\u001d\u0011I$\ba\u0001\u0003'\n\u0011\"\\8wK\u0012$\u0016m]6\t\u000f\tuR\u00041\u0001\u0003@\u00051R\u000f\u001d3bi\u0016$wJ]5hS:\u001cuN\u001c;bS:,'\u000f\u0005\u0003\u0002V\t\u0005\u0013\u0002\u0002B\"\u0003/\u0012Q\u0002V1tW\u000e{g\u000e^1j]\u0016\u0014\bb\u0002B$;\u0001\u0007!qH\u0001\u0017kB$\u0017\r^3e)\u0006\u0014x-\u001a;D_:$\u0018-\u001b8fe\"\u001aQ$!\u001e\u0002-\u0019Lg\u000eZ!gM\u0016\u001cG/\u001a3Cs\nc\u0017mY6pkR$B!a1\u0003P!9!\u0011\u000b\u0010A\u0002\tM\u0013\u0001\u00032mC\u000e\\w.\u001e;\u0011\t\tU#1L\u0007\u0003\u0005/RAA!\u0017\u0002X\u0005A1-\u00197f]\u0012\f'/\u0003\u0003\u0003^\t]#\u0001\u0003\"mC\u000e\\w.\u001e;)\u0007y\t)(\u0001\u0005hKR$\u0016\u000e\u001e7f)\u0011\t\u0019G!\u001a\t\u000f\u0005\u0005t\u00041\u0001\u0002d!\u001aq$a2)\u0007}\t)\bK\u0002\u0001\u0005[\u0002B!!3\u0003p%!!\u0011OAf\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlTaskRepository
implements TaskRepository,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final CommentRepository commentRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect dialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    public TaskBasicData findTaskBasicData(String taskId) {
        return TaskRepository.findTaskBasicData$((TaskRepository)this, (String)taskId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskRepository sqlTaskRepository = this;
        synchronized (sqlTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentRepository commentRepository() {
        return this.commentRepository;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        return this.findById(taskId, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public <T extends Task> T findById(String taskId, ResolveOptions resolveOptions) {
        if (!this.exists(taskId)) {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(taskId).append("] not found").toString(), new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId, resolveOptions);
        return (T)((Task)Option$.MODULE$.apply((Object)release.getTask(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(taskId)))).fold((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(41).append("Repository entity [").append(taskId).append("] not found in release").toString(), new Object[0]);
        }, (Function1 & Serializable & scala.Serializable)task2 -> {
            task2.getAllTasks().forEach(task -> this.commentRepository().decorate(task));
            return task2;
        }));
    }

    @Timed
    @IsReadOnly
    public List<TaskBasicData> findTasksBasicData(List<String> taskIds) {
        List list;
        if (taskIds.isEmpty()) {
            list = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.empty()).asJava();
        } else {
            Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()));
            list = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()).map((Function1 & Serializable & scala.Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable & scala.Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))), Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                String id = (String)tuple2._1();
                Option option = (Option)tuple2._2();
                if (!(option instanceof Some)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                Some some = (Some)option;
                TaskRow data = (TaskRow)some.value();
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id)));
            }, Buffer$.MODULE$.canBuildFrom())).asJava();
        }
        return list;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Checking if exists task [").append(taskId).append("]").toString());
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.releasePersistence().update(release);
        this.updateTaskProperties(task);
        this.updateConfigurationRefs((CiWithUid)release);
        return task;
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.taskPersistence().updateProperties(task);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTaskProperties$1(this, task, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task updateType(Task task) {
        void var2_2;
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return var2_2;
    }

    @Timed
    public void delete(Task task) {
        this.checkIsNotReferencedByDependencies(task.getId());
        this.releasePersistence().update(task.getRelease());
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        task.getAllTasks().forEach(t -> {
            this.commentRepository().deleteByTask(t);
            this.taskPersistence().delete((Task)t);
        });
        this.updateConfigurationRefs((CiWithUid)task.getRelease());
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, Predef$.MODULE$.Integer2int(newTask2.getRelease().getCiUid()));
        Object object = newTask2 instanceof TaskGroup ? ((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(newTask2.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$1)))).map((Function1 & Serializable & scala.Serializable)newTask -> this.createTask((Task)newTask), Buffer$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
        return newTask2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task create(Task newTask) {
        void var2_2;
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(createdTask)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            this.insertDependency(dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)createdTask.getRelease());
        this.facetRepositoryDispatcher().liveRepository().createFromTasks((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(newTask.getAllTasks()).asScala(), this.facetRepositoryDispatcher().liveRepository().createFromTasks$default$2());
        return var2_2;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskToMove.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])ReleaseStatus.ACTIVE_STATUSES)).build();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)((TraversableLike)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)x$2, new ResolveOptionsBuilder().build())), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)rel -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getAllTasks()).asScala(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    public static final /* synthetic */ void $anonfun$updateTaskProperties$1(SqlTaskRepository $this, Task task$1, Dependency x0$1) {
        Dependency dependency = x0$1;
        if (dependency.isArchived()) {
            $this.dependencyPersistence().deleteDependency(dependency);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            try {
                $this.dependencyPersistence().updateDependency(dependency);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (NotFoundException e) {
                $this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Dependency ").append(dependency).append(" not found when updating task ").append(task$1).toString(), (Function0 & Serializable & scala.Serializable)() -> e);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$1) {
        String string = x$1.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, CommentRepository commentRepository, SqlRepositoryAdapter repositoryAdapter, ConfigurationReferencePersistence configurationPersistence, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.commentRepository = commentRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.dialect = dialect;
        TaskRepository.$init$((TaskRepository)this);
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

