/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.forms;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.domain.variables.StringVariable;
import com.xebialabs.xlrelease.domain.variables.ValueProviderConfiguration;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.io.Serializable;

@PublicApiRef
public class Variable
implements Serializable {
    static final String XLRELEASE_STRING_VARIABLE = Type.valueOf(StringVariable.class).toString();
    private String id;
    private String key;
    private String type = XLRELEASE_STRING_VARIABLE;
    private boolean requiresValue = true;
    private boolean showOnReleaseStart = true;
    private Object value;
    private String label;
    private String description;
    private boolean multiline = false;
    private boolean inherited = false;
    private ValueProviderConfiguration valueProvider;

    public Variable() {
    }

    public Variable(String key, String value) {
        this(key, value, true);
    }

    public Variable(String key, String value, boolean required) {
        this(XLRELEASE_STRING_VARIABLE, key, value, required);
    }

    public Variable(String type, String key, Object value, boolean required) {
        this.type = type;
        this.key = key;
        this.value = value;
        this.requiresValue = required;
        this.showOnReleaseStart = required;
    }

    public com.xebialabs.xlrelease.domain.variables.Variable toReleaseVariable() {
        if (this.key == null) {
            throw new IllegalArgumentException("Variable key must be defined");
        }
        com.xebialabs.xlrelease.domain.variables.Variable variable = (com.xebialabs.xlrelease.domain.variables.Variable)Type.valueOf((String)this.type).getDescriptor().newInstance(this.id);
        variable.setKey(VariableHelper.withoutVariableSyntax((String)this.key));
        variable.setRequiresValue(this.requiresValue);
        variable.setShowOnReleaseStart(this.showOnReleaseStart);
        variable.setUntypedValue(this.value);
        variable.setLabel(this.label);
        variable.setDescription(this.description);
        variable.setValueProvider(this.getValueProvider());
        if (variable.hasProperty("multiline")) {
            variable.setProperty("multiline", (Object)this.multiline);
        }
        variable.setInherited(this.inherited);
        return variable;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isRequiresValue() {
        return this.requiresValue;
    }

    public void setRequiresValue(boolean requiresValue) {
        this.requiresValue = requiresValue;
    }

    public boolean isShowOnReleaseStart() {
        return this.showOnReleaseStart;
    }

    public void setShowOnReleaseStart(boolean showOnReleaseStart) {
        this.showOnReleaseStart = showOnReleaseStart;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ValueProviderConfiguration getValueProvider() {
        return this.valueProvider;
    }

    public void setValueProvider(ValueProviderConfiguration valueProvider) {
        this.valueProvider = valueProvider;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }
}

