/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.principaldata;

import com.atlassian.crowd.integration.springsecurity.RemoteCrowdAuthenticationProvider;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetailsServiceImpl;
import com.xebialabs.xlrelease.principaldata.CrowdUserDataProvider;
import com.xebialabs.xlrelease.principaldata.DefaultUserDataProvider;
import com.xebialabs.xlrelease.principaldata.LdapGroupEmailProvider;
import com.xebialabs.xlrelease.principaldata.LdapUserDataProvider;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProviderCache;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProviderImpl;
import com.xebialabs.xlrelease.principaldata.UserDataProvider;
import com.xebialabs.xlrelease.security.authentication.LdapAuthenticationProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.stereotype.Service;

@Service
public class PrincipalDataProviderFactoryBean
implements FactoryBean<PrincipalDataProvider>,
ApplicationContextAware,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(PrincipalDataProviderFactoryBean.class);
    private ApplicationContext context;
    private PrincipalDataProvider provider;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void afterPropertiesSet() throws Exception {
        List<LdapGroupEmailProvider> ldapGroupEmailProviderList;
        List<UserDataProvider> ldapUserDataProviderList;
        PrincipalDataProviderImpl principalDataProvider = new PrincipalDataProviderImpl();
        DefaultUserDataProvider defaultProvider = new DefaultUserDataProvider();
        principalDataProvider.addUserProvider(defaultProvider);
        List<UserDataProvider> crowdUserDataProviderList = this.tryInitUserDataFromSpringCrowdProvider();
        if (!crowdUserDataProviderList.isEmpty()) {
            principalDataProvider.addUserProvider(crowdUserDataProviderList);
        }
        if ((ldapUserDataProviderList = this.tryInitUserDataProviderFromSpringLdapUserSearch()).isEmpty()) {
            ldapUserDataProviderList = this.tryInitUserDataProviderFromSpringLdapProvider();
        }
        if (!ldapUserDataProviderList.isEmpty()) {
            principalDataProvider.addUserProvider(ldapUserDataProviderList);
        }
        if ((ldapGroupEmailProviderList = this.tryInitGroupEmailProviderFromLdapProvider()).isEmpty()) {
            ldapGroupEmailProviderList = this.tryInitGroupEmailProviderFromLdapGroupEmailProvider();
        }
        if (!ldapGroupEmailProviderList.isEmpty()) {
            principalDataProvider.addGroupProvider(ldapGroupEmailProviderList);
        }
        this.provider = new PrincipalDataProviderCache(principalDataProvider);
    }

    public PrincipalDataProvider getObject() throws Exception {
        return this.provider;
    }

    public Class<?> getObjectType() {
        return PrincipalDataProvider.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private List<LdapGroupEmailProvider> tryInitGroupEmailProviderFromLdapGroupEmailProvider() {
        Map ldapGroupEmailProviders = this.context.getBeansOfType(LdapGroupEmailProvider.class);
        ArrayList<LdapGroupEmailProvider> ldapGroupEmailProviderList = new ArrayList<LdapGroupEmailProvider>();
        if (ldapGroupEmailProviders != null && !ldapGroupEmailProviders.isEmpty()) {
            try {
                logger.info("Found {} in spring context", (Object)LdapGroupEmailProvider.class.getSimpleName());
                ldapGroupEmailProviders.forEach((name, ldapGroupEmailProvider) -> ldapGroupEmailProviderList.add((LdapGroupEmailProvider)ldapGroupEmailProvider));
            }
            catch (Exception e) {
                logger.warn("Error initializing from {}", (Object)LdapGroupEmailProvider.class.getSimpleName(), (Object)e);
            }
        }
        return ldapGroupEmailProviderList;
    }

    private List<LdapGroupEmailProvider> tryInitGroupEmailProviderFromLdapProvider() {
        Map ldapProviders = this.context.getBeansOfType(LdapAuthenticationProvider.class);
        ArrayList<LdapGroupEmailProvider> ldapGroupEmailProviderList = new ArrayList<LdapGroupEmailProvider>();
        if (ldapProviders != null && !ldapProviders.isEmpty()) {
            try {
                logger.info("Found {} in spring context, initializing from LDAP", (Object)LdapAuthenticationProvider.class.getSimpleName());
                ldapProviders.forEach((name, ldapProvider) -> {
                    if (ldapProvider.getGroupEmailProvider() != null) {
                        ldapGroupEmailProviderList.add(ldapProvider.getGroupEmailProvider());
                    }
                });
            }
            catch (Exception e) {
                logger.warn("Error initializing from {}", (Object)LdapAuthenticationProvider.class.getSimpleName(), (Object)e);
            }
        }
        return ldapGroupEmailProviderList;
    }

    private List<UserDataProvider> tryInitUserDataProviderFromSpringLdapProvider() {
        Map ldapProviders = this.context.getBeansOfType(org.springframework.security.ldap.authentication.LdapAuthenticationProvider.class);
        ArrayList<UserDataProvider> ldapUserDataProviderList = new ArrayList<UserDataProvider>();
        if (ldapProviders != null && !ldapProviders.isEmpty()) {
            try {
                logger.info("Found {} in spring context, initializing from LDAP", (Object)org.springframework.security.ldap.authentication.LdapAuthenticationProvider.class.getSimpleName());
                ldapProviders.forEach((name, ldapProvider) -> ldapUserDataProviderList.add(new LdapUserDataProvider((org.springframework.security.ldap.authentication.LdapAuthenticationProvider)ldapProvider)));
            }
            catch (Exception e) {
                logger.warn("Error initializing from {}", (Object)org.springframework.security.ldap.authentication.LdapAuthenticationProvider.class.getSimpleName(), (Object)e);
            }
        }
        return ldapUserDataProviderList;
    }

    private List<UserDataProvider> tryInitUserDataProviderFromSpringLdapUserSearch() {
        Map ldapUserSearches = this.context.getBeansOfType(LdapUserSearch.class);
        ArrayList<UserDataProvider> ldapUserDataProviderList = new ArrayList<UserDataProvider>();
        if (ldapUserSearches != null && !ldapUserSearches.isEmpty()) {
            try {
                logger.info("Found {} in spring context, initializing from LDAP", (Object)LdapUserSearch.class.getSimpleName());
                ldapUserSearches.forEach((name, ldapUserSearch) -> ldapUserDataProviderList.add(new LdapUserDataProvider((LdapUserSearch)ldapUserSearch)));
            }
            catch (Exception e) {
                logger.warn("Error initializing from {}", (Object)LdapUserSearch.class.getSimpleName(), (Object)e);
            }
        }
        return ldapUserDataProviderList;
    }

    private List<UserDataProvider> tryInitUserDataFromSpringCrowdProvider() {
        Map crowdUserDetailServiceImpls = this.context.getBeansOfType(CrowdUserDetailsServiceImpl.class);
        ArrayList<UserDataProvider> crowdUserDataProviderList = new ArrayList<UserDataProvider>();
        if (crowdUserDetailServiceImpls != null && !crowdUserDetailServiceImpls.isEmpty()) {
            try {
                logger.info("Found {} in spring context, initializing from Crowd", (Object)CrowdUserDetailsServiceImpl.class.getSimpleName());
                crowdUserDetailServiceImpls.forEach((name, crowdUserDetailServiceImpl) -> crowdUserDataProviderList.add(new CrowdUserDataProvider((CrowdUserDetailsServiceImpl)crowdUserDetailServiceImpl)));
            }
            catch (Exception e) {
                logger.warn("Error initializing from {}", (Object)RemoteCrowdAuthenticationProvider.class.getSimpleName(), (Object)e);
            }
        }
        return crowdUserDataProviderList;
    }
}

