/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.VariableBuilder;
import com.xebialabs.xlrelease.domain.PollType;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.variables.Variable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ReleaseTriggerBuilder {
    private String type;
    private String id;
    private String title;
    private String description;
    private List<Variable> vars = Lists.newArrayList();
    private Release template;
    private String executionId;
    private boolean enabled = true;
    private String releaseTitle;
    private String triggerState;
    private PollType pollType = PollType.REPEAT;
    private String periodicity = "10";
    private List<String> tags = Lists.newArrayList();
    private Map<String, Object> properties = Maps.newHashMap();
    private boolean initialFire;

    private ReleaseTriggerBuilder(String type) {
        this.type = type;
    }

    public static ReleaseTriggerBuilder newReleaseTrigger(String type) {
        return new ReleaseTriggerBuilder(type);
    }

    public ReleaseTriggerBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public ReleaseTriggerBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public ReleaseTriggerBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public ReleaseTriggerBuilder withIdAndTitle(String id) {
        this.id = id;
        this.title = id;
        return this;
    }

    public ReleaseTriggerBuilder withTemplateVariableValues(Map<String, String> values) {
        for (Map.Entry<String, String> var : values.entrySet()) {
            this.vars.add(VariableBuilder.newStringVariable(var.getKey(), var.getValue()).build());
        }
        return this;
    }

    public ReleaseTriggerBuilder withTemplatePasswordVariableValues(Map<String, String> values) {
        for (Map.Entry<String, String> var : values.entrySet()) {
            this.vars.add(VariableBuilder.newPasswordStringVariable(var.getKey(), var.getValue()).build());
        }
        return this;
    }

    public ReleaseTriggerBuilder withTemplateVariables(Variable ... variables) {
        this.vars.addAll(Arrays.asList(variables));
        return this;
    }

    public ReleaseTriggerBuilder withTemplate(Release template) {
        this.template = template;
        return this;
    }

    public ReleaseTriggerBuilder withExecutionId() {
        this.executionId = UUID.randomUUID().toString();
        return this;
    }

    public ReleaseTriggerBuilder withNoExecutionId() {
        this.executionId = null;
        return this;
    }

    public ReleaseTriggerBuilder withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ReleaseTriggerBuilder withReleaseTitle(String s) {
        this.releaseTitle = s;
        return this;
    }

    public ReleaseTriggerBuilder withTriggerState(String triggerState) {
        this.triggerState = triggerState;
        return this;
    }

    public ReleaseTriggerBuilder withInitialFire(boolean initialFire) {
        this.initialFire = initialFire;
        return this;
    }

    public ReleaseTriggerBuilder withPollType(PollType pollType) {
        this.pollType = pollType;
        return this;
    }

    public ReleaseTriggerBuilder withPeriodicity(String periodicity) {
        this.periodicity = periodicity;
        return this;
    }

    public ReleaseTriggerBuilder withProperty(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public ReleaseTriggerBuilder withTags(String ... tags) {
        this.tags = Lists.newArrayList((Object[])tags);
        return this;
    }

    public ReleaseTrigger build() {
        Type type = Type.valueOf((String)this.type);
        ReleaseTrigger releaseTrigger = (ReleaseTrigger)type.getDescriptor().newInstance(this.id);
        releaseTrigger.setTitle(this.title);
        releaseTrigger.setDescription(this.description);
        releaseTrigger.setVariables(this.vars);
        releaseTrigger.setTemplate(this.template);
        if (this.template != null) {
            this.template.getReleaseTriggers().add(releaseTrigger);
        }
        releaseTrigger.setExecutionId(this.executionId);
        releaseTrigger.setEnabled(this.enabled);
        releaseTrigger.setReleaseTitle(this.releaseTitle);
        releaseTrigger.setTriggerState(this.triggerState);
        releaseTrigger.setInitialFire(this.initialFire);
        releaseTrigger.setPollType(this.pollType);
        releaseTrigger.setPeriodicity(this.periodicity);
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            releaseTrigger.setProperty(entry.getKey(), entry.getValue());
        }
        releaseTrigger.setTags(this.tags);
        return releaseTrigger;
    }
}

