/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.TaskApi;
import com.xebialabs.xlrelease.api.v1.forms.Comment;
import com.xebialabs.xlrelease.api.v1.views.TaskAccessView;
import com.xebialabs.xlrelease.domain.PythonScriptDefinition;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskDefinition;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.TaskGranularPermissions;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.service.TaskSearchService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.BulkActionResultView;
import com.xebialabs.xlrelease.views.CommentTasksView;
import com.xebialabs.xlrelease.views.CommentView;
import com.xebialabs.xlrelease.views.DomainIdsForm;
import com.xebialabs.xlrelease.views.ReassignTasksView;
import com.xebialabs.xlrelease.views.TaskForm;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.TaskPollingView;
import com.xebialabs.xlrelease.views.TaskReleaseView;
import com.xebialabs.xlrelease.views.TaskSearchView;
import com.xebialabs.xlrelease.views.TasksFilters;
import com.xebialabs.xlrelease.views.converters.CommentViewConverter;
import com.xebialabs.xlrelease.views.converters.TasksViewConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/tasks")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class TaskResource {
    private TaskApi taskApi;
    private ReleaseService releaseService;
    private TaskService taskService;
    private PermissionChecker permissions;
    private TaskAccessService taskAccessService;
    private TaskSearchService taskSearchService;
    private ReleaseActorService releaseActorService;
    private TasksViewConverter tasksViewConverter;
    private CommentViewConverter commentViewConverter;
    private TaskGranularPermissions taskPermissionChecker;

    @Autowired
    public TaskResource(TaskApi taskApi, ReleaseService releaseService, TaskService taskService, PermissionChecker permissions, TaskAccessService taskAccessService, TaskSearchService taskSearchService, ReleaseActorService releaseActorService, TasksViewConverter tasksViewConverter, CommentViewConverter commentViewConverter, TaskGranularPermissions taskPermissionChecker) {
        this.taskApi = taskApi;
        this.releaseService = releaseService;
        this.taskService = taskService;
        this.permissions = permissions;
        this.taskAccessService = taskAccessService;
        this.taskSearchService = taskSearchService;
        this.releaseActorService = releaseActorService;
        this.tasksViewConverter = tasksViewConverter;
        this.commentViewConverter = commentViewConverter;
        this.taskPermissionChecker = taskPermissionChecker;
    }

    @POST
    @Timed
    @Path(value="{containerId:.*(Phase|Task)[^/-]*}")
    public TaskFullView addTask(@PathParam(value="containerId") @IdParam String containerId, TaskForm taskForm) {
        String releaseId = Ids.releaseIdFrom((String)containerId);
        this.permissions.checkView(releaseId);
        this.permissions.checkEdit(releaseId);
        this.permissions.checkEditTask(releaseId);
        Task task = this.releaseActorService.createTask(containerId, taskForm.toTask());
        return this.tasksViewConverter.toFullView(task, this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser());
    }

    @GET
    @Timed
    @Path(value="{taskId:[^/]*Task[^/-]*}")
    public TaskFullView getTask(@PathParam(value="taskId") @IdParam String taskId) {
        Task task = this.taskService.findByIdIncludingArchived(taskId);
        this.permissions.checkViewTask(task);
        return this.tasksViewConverter.toFullView(task, this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser());
    }

    @POST
    @Timed
    @Path(value="search")
    public TaskSearchView getTasksByRelease(TasksFilters tasksFilters, @QueryParam(value="limitTasksHint") Integer limitTasksHint) {
        return this.taskSearchService.getTasksByRelease(tasksFilters, limitTasksHint);
    }

    @POST
    @Timed
    @Path(value="{taskId:.*Task[^/-]*}/complete")
    public Response completeTask(@PathParam(value="taskId") @IdParam String taskId, CommentView comment) {
        this.taskApi.completeTask(taskId, this.fromView(comment));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Timed
    @Path(value="complete")
    public BulkActionResultView completeTasks(CommentTasksView commentTasksView) {
        List<String> filteredTaskIds = this.permissions.filterTasksWithTaskTransitionPermission(commentTasksView.getTaskIds());
        if (filteredTaskIds.isEmpty()) {
            return new BulkActionResultView(filteredTaskIds);
        }
        return new BulkActionResultView(this.releaseActorService.completeTasks(filteredTaskIds, commentTasksView.getCommentText()));
    }

    @POST
    @Timed
    @Path(value="{taskId:.*Task[^/-]*}/skip")
    public Response skipTask(@PathParam(value="taskId") @IdParam String taskId, CommentView comment) {
        this.taskApi.skipTask(taskId, this.fromView(comment));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Timed
    @Path(value="skip")
    public BulkActionResultView skipTasks(CommentTasksView comment) {
        Checks.checkNotNull((Object)comment.getCommentText(), (String)"Comment is mandatory when skipping tasks.");
        List<String> filteredTaskIds = this.permissions.filterTasksWithTaskTransitionPermission(comment.getTaskIds());
        if (filteredTaskIds.isEmpty()) {
            return new BulkActionResultView(filteredTaskIds);
        }
        return new BulkActionResultView(this.releaseActorService.skipTasks(filteredTaskIds, comment.getCommentText(), User.AUTHENTICATED_USER));
    }

    @POST
    @Timed
    @Path(value="{taskId:.*Task[^/-]*}/fail")
    public Response failTask(@PathParam(value="taskId") @IdParam String taskId, CommentView comment) {
        this.taskApi.failTask(taskId, this.fromView(comment));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Timed
    @Path(value="fail")
    public BulkActionResultView failTasks(CommentTasksView comment) {
        Checks.checkNotNull((Object)comment.getCommentText(), (String)"Comment is mandatory when failing tasks.");
        List<String> filteredTaskIds = this.permissions.filterTasksWithTaskTransitionPermission(comment.getTaskIds());
        if (filteredTaskIds.isEmpty()) {
            return new BulkActionResultView(filteredTaskIds);
        }
        return new BulkActionResultView(this.releaseActorService.failTasksManually(filteredTaskIds, comment.getCommentText()));
    }

    @POST
    @Timed
    @Path(value="{taskId:.*Task[^/-]*}/abort")
    public Response abortTask(@PathParam(value="taskId") @IdParam String taskId, CommentView comment) {
        this.taskApi.abortTask(taskId, this.fromView(comment));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Timed
    @Path(value="{taskId:.*Task[^/-]*}/retry")
    public Response retryTask(@PathParam(value="taskId") @IdParam String taskId, CommentView comment) {
        this.taskApi.retryTask(taskId, this.fromView(comment));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Timed
    @Path(value="retry")
    public BulkActionResultView retryTasks(CommentTasksView comment) {
        Checks.checkNotNull((Object)comment.getCommentText(), (String)"Comment is mandatory when retrying tasks.");
        List<String> filteredTaskIds = this.permissions.filterTasksWithTaskTransitionPermission(comment.getTaskIds());
        if (filteredTaskIds.isEmpty()) {
            return new BulkActionResultView(filteredTaskIds);
        }
        return new BulkActionResultView(this.releaseActorService.retryTasks(comment.getTaskIds(), comment.getCommentText()));
    }

    @POST
    @Timed
    @Path(value="abort")
    public BulkActionResultView abortTasks(CommentTasksView comment) {
        Checks.checkNotNull((Object)comment.getCommentText(), (String)"Comment is mandatory when aborting tasks.");
        List<String> filteredTaskIds = this.permissions.filterTasksWithTaskTransitionPermission(comment.getTaskIds());
        if (filteredTaskIds.isEmpty()) {
            return new BulkActionResultView(filteredTaskIds);
        }
        return new BulkActionResultView(this.releaseActorService.abortTasks(comment.getTaskIds(), comment.getCommentText()));
    }

    @POST
    @Timed
    @Path(value="{taskId:.*Task[^/-]*}/startNow")
    public Response startNow(@PathParam(value="taskId") @IdParam String taskId, CommentView comment) {
        this.taskApi.start(taskId, this.fromView(comment));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Timed
    @Path(value="{taskId:.*Task[^/-]*}/reopen")
    public Response reopenTask(@PathParam(value="taskId") @IdParam String taskId, CommentView comment) {
        this.taskApi.reopenTask(taskId, this.fromView(comment));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Timed
    @Path(value="reopen")
    public BulkActionResultView reopenTasks(CommentTasksView comment) {
        Checks.checkNotNull((Object)(!Strings.isNullOrEmpty((String)comment.getCommentText()) ? 1 : 0), (String)"Comment is mandatory when reopening tasks.");
        this.permissions.checkReopenTasksInRelease(comment.getTaskIds());
        if (comment.getTaskIds().isEmpty()) {
            return new BulkActionResultView(Collections.emptyList());
        }
        return new BulkActionResultView(this.releaseActorService.reopenTasks(comment.getTaskIds(), comment.getCommentText()));
    }

    @GET
    @Timed
    @Path(value="{taskId:.*Task[^/-]*}/comments")
    public List<CommentView> getCommentsOfTask(@PathParam(value="taskId") @IdParam String taskId) {
        return this.taskService.getCommentsOfTask(taskId).stream().map(this.commentViewConverter::toFullView).collect(Collectors.toList());
    }

    @POST
    @Timed
    @Path(value="{taskId:.*Task[^/-]*}/comments")
    public CommentView addComment(@PathParam(value="taskId") @IdParam String taskId, CommentView commentView) {
        this.permissions.checkIsAllowedToCommentOnTask(taskId);
        com.xebialabs.xlrelease.domain.Comment comment = this.releaseActorService.addCommentToTask(taskId, commentView.getText());
        return this.commentViewConverter.toFullView(comment);
    }

    @POST
    @Timed
    @Path(value="comments")
    public BulkActionResultView addCommentToTasks(CommentTasksView commentTasksView) {
        List<String> filteredTaskIds = this.permissions.filterAllowedToCommentOnTasks(commentTasksView.getTaskIds());
        if (filteredTaskIds.isEmpty()) {
            return new BulkActionResultView(filteredTaskIds);
        }
        return new BulkActionResultView(this.releaseActorService.addCommentToTasks(filteredTaskIds, commentTasksView.getCommentText()));
    }

    @PUT
    @Timed
    @Path(value="{taskId:.*Task[^/-]*}")
    public TaskFullView updateTask(@PathParam(value="taskId") @IdParam String taskId, TaskFullView updatedTask) {
        Set<TaskUpdateDirective> updateDirectives = this.taskPermissionChecker.getUpdateDirectives(this.releaseService.findById(Ids.releaseIdFrom((String)taskId), ResolveOptions.MINIMAL()));
        Task result = this.releaseActorService.updateTask(taskId, this.tasksViewConverter.toTask(updatedTask), updateDirectives);
        return this.tasksViewConverter.toFullView(result, this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser());
    }

    @POST
    @Timed
    @Path(value="{taskId:.*Task[^/-]*}/changeType")
    public TaskFullView changeTaskType(@PathParam(value="taskId") @IdParam String taskId, @QueryParam(value="targetType") String targetType) {
        Task result = this.taskApi.changeTaskType(taskId, targetType);
        return this.tasksViewConverter.toFullView(result, this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser());
    }

    @PUT
    @Timed
    @Path(value="reassign")
    public BulkActionResultView reassignTasks(ReassignTasksView reassignTasks) {
        this.permissions.checkReassignTasks(reassignTasks.getTaskIds(), reassignTasks.getOwner());
        if (reassignTasks.getTaskIds().isEmpty()) {
            return new BulkActionResultView(Collections.emptyList());
        }
        return new BulkActionResultView(this.releaseActorService.reassignTasks(reassignTasks.getTaskIds(), reassignTasks.getTeam(), reassignTasks.getOwner()));
    }

    @PUT
    @Timed
    @Path(value="{taskId:.*Task[^/-]*}/owner")
    public void reassignToOwner(@PathParam(value="taskId") @IdParam String taskId, TaskFullView updatedTask) {
        String newOwner = updatedTask != null ? updatedTask.getOwnerUsername() : null;
        this.permissions.checkReassignTaskToUser(taskId, newOwner);
        this.releaseActorService.reassignTaskToOwner(taskId, newOwner);
    }

    @DELETE
    @Timed
    @Path(value="{taskId:.*Task[^/-]*}/owner")
    public void removeOwner(@PathParam(value="taskId") @IdParam String taskId) {
        this.reassignToOwner(taskId, null);
    }

    @PUT
    @Timed
    @Path(value="{taskId:.*Task[^/-]*}/team")
    public void reassignToTeam(@PathParam(value="taskId") @IdParam String taskId, TaskFullView updatedTask) {
        String newTeam;
        Object task = this.taskService.findById(taskId);
        this.permissions.checkReassignTaskPermission(task.getRelease());
        String previousTeam = task.getTeam();
        String string = newTeam = updatedTask != null ? updatedTask.getTeam() : null;
        if (!Objects.equal((Object)newTeam, (Object)previousTeam)) {
            this.releaseActorService.reassignTaskToTeam(taskId, newTeam);
        }
    }

    @DELETE
    @Timed
    @Path(value="{taskId:.*Task[^/-]*}/team")
    public void removeTeam(@PathParam(value="taskId") @IdParam String taskId) {
        this.reassignToTeam(taskId, null);
    }

    @DELETE
    public BulkActionResultView deleteTasks(List<String> taskIds) {
        this.permissions.checkDeleteTasks(taskIds);
        if (taskIds.isEmpty()) {
            return new BulkActionResultView(Collections.emptyList());
        }
        return new BulkActionResultView(this.releaseActorService.deleteTasks(taskIds));
    }

    @DELETE
    @Timed
    @Path(value="{taskId:.*Task[^/-]*}")
    public void deleteTask(@PathParam(value="taskId") @IdParam String taskId) {
        this.taskApi.delete(taskId);
    }

    @POST
    @Timed
    @Path(value="poll")
    public List<TaskPollingView> poll(DomainIdsForm form) {
        List<TaskBasicData> taskList = this.taskService.findTasksForPolling(form.getIds());
        return taskList.stream().map(taskData -> {
            TaskPollingView view = new TaskPollingView();
            view.setId(taskData.taskId());
            view.setStatus(taskData.status());
            view.setStatusLine(taskData.statusLine());
            return view;
        }).collect(Collectors.toList());
    }

    @GET
    @Timed
    @Path(value="task-definitions")
    public Collection<TaskDefinition> getTaskDefinitions() {
        return this.taskAccessService.getTaskDefinitions();
    }

    @GET
    @Timed
    @Path(value="task-definitions/{scriptDefinitionType}")
    public PythonScriptDefinition getCustomScriptProperties(@PathParam(value="scriptDefinitionType") String scriptDefinitionType) {
        return new PythonScriptDefinition(Type.valueOf((String)scriptDefinitionType));
    }

    @GET
    @Timed
    @Path(value="types-access")
    public List<TaskAccessView> getTaskAccesses() {
        this.permissions.check(PlatformPermissions.EDIT_SECURITY);
        return this.taskAccessService.getTaskAccesses();
    }

    @PUT
    @Timed
    @Path(value="types-access")
    public void updateTaskAccesses(List<TaskAccessView> taskAccesses) {
        this.permissions.check(PlatformPermissions.EDIT_SECURITY);
        this.taskAccessService.updateTaskAccesses(taskAccesses);
    }

    @GET
    @Timed
    @Path(value="{taskId:.*Task[^/-]*}/release")
    public TaskReleaseView getTaskRelease(@PathParam(value="taskId") @IdParam String taskId) {
        Task task = this.taskService.findByIdIncludingArchived(taskId);
        this.permissions.checkViewTask(task);
        Release release = this.releaseService.findByIdIncludingArchived(Ids.releaseIdFrom((String)taskId));
        return new TaskReleaseView(task, release);
    }

    private Comment fromView(CommentView comment) {
        return new Comment(comment.getText());
    }
}

